/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.cli.logging.impl;

import java.net.URL;
import java.util.Map;
import java.util.Set;
import org.apache.maven.cli.logging.BaseSlf4jConfiguration;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class UnsupportedSlf4jBindingConfiguration
extends BaseSlf4jConfiguration {
    private final Logger logger = LoggerFactory.getLogger(UnsupportedSlf4jBindingConfiguration.class);
    private String slf4jBinding;
    private Map<URL, Set<Object>> supported;

    public UnsupportedSlf4jBindingConfiguration(String slf4jBinding, Map<URL, Set<Object>> supported) {
        this.slf4jBinding = slf4jBinding;
        this.supported = supported;
    }

    @Override
    public void activate() {
        this.logger.warn("The SLF4J binding actually used is not supported by Maven: " + this.slf4jBinding);
        this.logger.warn("Maven supported bindings are:");
        String ls = System.getProperty("line.separator");
        for (Map.Entry<URL, Set<Object>> entry : this.supported.entrySet()) {
            StringBuilder sb = new StringBuilder();
            sb.append("(from ").append(entry.getKey().toExternalForm()).append(")");
            for (Object binding : entry.getValue()) {
                sb.append(ls).append("- ").append(binding);
            }
            this.logger.warn(sb.toString());
        }
    }
}

