/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.web.common.sourcemap;

import java.util.Iterator;
import java.util.StringTokenizer;
import org.netbeans.modules.web.common.sourcemap.Mapping;

class MappingTokenizer
implements Iterable<Mapping> {
    private final String mappings;

    MappingTokenizer(String mappings) {
        this.mappings = mappings;
    }

    @Override
    public Iterator<Mapping> iterator() {
        return new MappingIterator(this.mappings);
    }

    static class MappingParser {
        private static final int CONTINUATION_MASK = 32;
        private static final int DATA_MASK = 31;
        private final String mapping;
        private int index = 0;

        MappingParser(String mapping) {
            this.mapping = mapping;
        }

        boolean hasNext() {
            return this.mapping.length() > this.index;
        }

        int next() {
            int result = 0;
            int shift = 0;
            boolean continuation = true;
            while (continuation) {
                char c = this.mapping.charAt(this.index);
                int data = this.decode(c);
                continuation = (data & 0x20) != 0;
                result += (data &= 0x1F) << shift;
                shift += 5;
                ++this.index;
            }
            boolean negative = result % 2 == 1;
            return negative ? -result : (result >>= 1);
        }

        private int decode(char c) {
            if (c >= 'A' && c <= 'Z') {
                return c - 65;
            }
            if (c >= 'a' && c <= 'z') {
                return c - 71;
            }
            if (c >= '0' && c <= '9') {
                return c + 4;
            }
            switch (c) {
                case '+': {
                    return 62;
                }
                case '/': {
                    return 63;
                }
                case '=': {
                    return 0;
                }
            }
            throw new IllegalArgumentException("Illegal character: " + c);
        }
    }

    static class MappingIterator
    implements Iterator<Mapping> {
        private final StringTokenizer st;
        private int lastColumn = 0;
        private int lastSourceIndex = 0;
        private int lastOriginalLine = 0;
        private int lastOriginalColumn = 0;
        private int lastNameIndex = 0;

        MappingIterator(String mappings) {
            this.st = new StringTokenizer(mappings, ";,", true);
        }

        @Override
        public boolean hasNext() {
            return this.st.hasMoreTokens();
        }

        @Override
        public Mapping next() {
            Mapping mapping;
            String token = this.st.nextToken();
            if (",".equals(token)) {
                token = this.st.nextToken();
            }
            if (";".equals(token)) {
                this.lastColumn = 0;
                mapping = Mapping.NEW_LINE;
            } else {
                MappingParser parser = new MappingParser(token);
                mapping = new Mapping();
                this.lastColumn += parser.next();
                mapping.setColumn(this.lastColumn);
                if (parser.hasNext()) {
                    this.lastSourceIndex += parser.next();
                    mapping.setSourceIndex(this.lastSourceIndex);
                    this.lastOriginalLine += parser.next();
                    mapping.setOriginalLine(this.lastOriginalLine);
                    this.lastOriginalColumn += parser.next();
                    mapping.setOriginalColumn(this.lastOriginalColumn);
                    if (parser.hasNext()) {
                        this.lastNameIndex += parser.next();
                        mapping.setNameIndex(this.lastNameIndex);
                    }
                } else {
                    return this.next();
                }
            }
            return mapping;
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }
    }
}

