/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.xml.catalog;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.File;
import java.io.IOException;
import java.util.Arrays;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.AbstractButton;
import javax.swing.Action;
import javax.swing.ActionMap;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSeparator;
import javax.swing.JTree;
import org.netbeans.modules.xml.catalog.AddCatalogEntryAction;
import org.netbeans.modules.xml.catalog.CatalogEntryNode;
import org.netbeans.modules.xml.catalog.CatalogNode;
import org.netbeans.modules.xml.catalog.CatalogRootNode;
import org.netbeans.modules.xml.catalog.spi.CatalogWriter;
import org.openide.awt.Mnemonics;
import org.openide.explorer.ExplorerManager;
import org.openide.explorer.ExplorerUtils;
import org.openide.explorer.view.BeanTreeView;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.loaders.DataFilter;
import org.openide.loaders.DataFolder;
import org.openide.loaders.DataObject;
import org.openide.loaders.DataObjectNotFoundException;
import org.openide.nodes.Index;
import org.openide.nodes.Node;
import org.openide.util.NbBundle;
import org.openide.windows.TopComponent;

public class CatalogPanel
extends TopComponent
implements ExplorerManager.Provider {
    private ExplorerManager manager;
    private CatalogTreeView view;
    private JTree tree;
    private static Set newlyCreatedFolders;
    private static FileObject catalogRoot;
    private JButton addButton;
    private JButton addLocalButton;
    private JPanel buttonsPanel;
    private JSeparator jSeparator2;
    private JSeparator jSeparator3;
    private JButton removeButton;
    private JLabel templatesLabel;
    private JPanel treePanel;

    public CatalogPanel() {
        ActionMap map = this.getActionMap();
        map.put("copy-to-clipboard", ExplorerUtils.actionCopy((ExplorerManager)this.getExplorerManager()));
        map.put("cut-to-clipboard", ExplorerUtils.actionCut((ExplorerManager)this.getExplorerManager()));
        map.put("paste-from-clipboard", ExplorerUtils.actionPaste((ExplorerManager)this.getExplorerManager()));
        map.put("delete", ExplorerUtils.actionDelete((ExplorerManager)this.getExplorerManager(), (boolean)true));
        this.initComponents();
        this.createCatalogView();
        this.treePanel.add((Component)((Object)this.view), "Center");
        this.associateLookup(ExplorerUtils.createLookup((ExplorerManager)this.getExplorerManager(), (ActionMap)map));
        this.initialize();
    }

    public ExplorerManager getExplorerManager() {
        if (this.manager == null) {
            this.manager = new ExplorerManager();
        }
        return this.manager;
    }

    private void createCatalogView() {
        if (this.view == null) {
            this.view = new CatalogTreeView();
        }
        this.view.setRootVisible(true);
        this.view.setPopupAllowed(true);
        this.view.setDefaultActionAllowed(false);
    }

    private void initialize() {
        this.getExplorerManager().setRootContext(CatalogPanel.getCatalogRootNode());
        this.getExplorerManager().addPropertyChangeListener((PropertyChangeListener)new SelectionListener());
        this.removeButton.setEnabled(false);
        this.addButton.setEnabled(true);
        this.addLocalButton.setEnabled(false);
    }

    static Node getCatalogRootNode() {
        return new CatalogRootNode();
    }

    private void initComponents() {
        this.templatesLabel = new JLabel();
        this.treePanel = new JPanel();
        this.buttonsPanel = new JPanel();
        this.addButton = new JButton();
        this.addLocalButton = new JButton();
        this.removeButton = new JButton();
        this.jSeparator2 = new JSeparator();
        this.jSeparator3 = new JSeparator();
        this.setPreferredSize(new Dimension(500, 300));
        this.setLayout(new GridBagLayout());
        Mnemonics.setLocalizedText((JLabel)this.templatesLabel, (String)NbBundle.getBundle(CatalogPanel.class).getString("LBL_CatalogPanel_CatalogLabel"));
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(12, 12, 0, 0);
        this.add(this.templatesLabel, gridBagConstraints);
        this.treePanel.setBorder(BorderFactory.createEtchedBorder());
        this.treePanel.setLayout(new BorderLayout());
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridheight = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(0, 12, 11, 0);
        this.add(this.treePanel, gridBagConstraints);
        this.buttonsPanel.setLayout(new GridBagLayout());
        Mnemonics.setLocalizedText((AbstractButton)this.addButton, (String)NbBundle.getBundle(CatalogPanel.class).getString("BTN_CatalogPanel_Add"));
        this.addButton.setToolTipText(NbBundle.getMessage(CatalogPanel.class, (String)"ACD_CatalogPanel_Add"));
        this.addButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                CatalogPanel.this.addButtonActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(0, 8, 3, 0);
        this.buttonsPanel.add((Component)this.addButton, gridBagConstraints);
        this.addButton.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(CatalogPanel.class, (String)"ACD_CatalogPanel_Add"));
        Mnemonics.setLocalizedText((AbstractButton)this.addLocalButton, (String)NbBundle.getBundle(CatalogPanel.class).getString("BTN_CatalogPanel_AddLocal"));
        this.addLocalButton.setToolTipText(NbBundle.getMessage(CatalogPanel.class, (String)"ACD_CatalogPanel_AddLocal"));
        this.addLocalButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                CatalogPanel.this.addLocalButtonActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(0, 8, 3, 0);
        this.buttonsPanel.add((Component)this.addLocalButton, gridBagConstraints);
        this.addLocalButton.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(CatalogPanel.class, (String)"ACD_CatalogPanel_AddLocal"));
        Mnemonics.setLocalizedText((AbstractButton)this.removeButton, (String)NbBundle.getBundle(CatalogPanel.class).getString("BTN_CatalogPanel_RemoveButton"));
        this.removeButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                CatalogPanel.this.removeButtonActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(0, 8, 3, 0);
        this.buttonsPanel.add((Component)this.removeButton, gridBagConstraints);
        this.removeButton.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(CatalogPanel.class, (String)"ACD_CatalogPanel_Remove"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 8;
        gridBagConstraints.insets = new Insets(4, 8, 4, 0);
        this.buttonsPanel.add((Component)this.jSeparator2, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 5;
        gridBagConstraints.insets = new Insets(4, 8, 4, 0);
        this.buttonsPanel.add((Component)this.jSeparator3, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.gridheight = 0;
        gridBagConstraints.anchor = 11;
        gridBagConstraints.insets = new Insets(0, 11, 11, 8);
        this.add(this.buttonsPanel, gridBagConstraints);
    }

    private void addLocalButtonActionPerformed(ActionEvent evt) {
        AddCatalogEntryAction.perform(this.manager.getSelectedNodes());
    }

    private void removeButtonActionPerformed(ActionEvent evt) {
        Node[] nodes = this.manager.getSelectedNodes();
        try {
            for (Node n : nodes) {
                n.destroy();
            }
        }
        catch (IOException e) {
            Logger.getLogger(CatalogPanel.class.getName()).log(Level.SEVERE, e.getLocalizedMessage(), e);
        }
    }

    private void addButtonActionPerformed(ActionEvent evt) {
        CatalogRootNode.mountCatalog(new Node[]{this.manager.getRootContext()});
    }

    private static DataObject getDOFromNode(Node n) {
        DataObject dobj = (DataObject)n.getLookup().lookup(DataObject.class);
        assert (dobj != null) : "DataObject for node " + n;
        return dobj;
    }

    private static DataFolder getTargetFolder(Node[] nodes) {
        DataFolder folder = null;
        if (nodes == null || nodes.length == 0) {
            folder = DataFolder.findFolder((FileObject)CatalogPanel.getCatalogRoot());
        } else {
            folder = (DataFolder)nodes[0].getLookup().lookup(DataFolder.class);
            if (folder == null && nodes[0].isLeaf()) {
                Node parent = nodes[0].getParentNode();
                folder = (DataFolder)parent.getLookup().lookup(DataFolder.class);
            }
        }
        return folder;
    }

    static DataObject createTemplateFromFile(File file, DataFolder preferred) {
        if (file == null) {
            throw new IllegalArgumentException("Argument file cannot be null!");
        }
        FileObject sourceFO = FileUtil.toFileObject((File)FileUtil.normalizeFile((File)file));
        assert (sourceFO != null) : "FileObject found for file " + file;
        DataObject sourceDO = null;
        try {
            sourceDO = DataObject.find((FileObject)sourceFO);
        }
        catch (DataObjectNotFoundException donfe) {
            Logger.getLogger(CatalogPanel.class.getName()).log(Level.WARNING, null, donfe);
        }
        assert (sourceDO != null) : "DataObject found for FileObject " + sourceFO;
        DataFolder folder = preferred == null ? DataFolder.findFolder((FileObject)CatalogPanel.getCatalogRoot()) : preferred;
        DataObject template = null;
        try {
            template = sourceDO.copy(folder);
            template.setTemplate(true);
        }
        catch (IOException ioe) {
            Logger.getLogger(CatalogPanel.class.getName()).log(Level.WARNING, null, ioe);
        }
        return template;
    }

    private static DataFolder doNewFolder(Node[] nodes) {
        DataFolder df = null;
        DataFolder pref = CatalogPanel.getTargetFolder(nodes);
        if (pref == null) {
            pref = DataFolder.findFolder((FileObject)CatalogPanel.getCatalogRoot());
            assert (pref != null) : "DataFolder found for FO " + CatalogPanel.getCatalogRoot();
        }
        try {
            df = DataFolder.create((DataFolder)pref, (String)NbBundle.getBundle(CatalogPanel.class).getString("TXT_CatalogPanel_NewFolderName"));
            assert (df != null) : "New subfolder found in folder " + pref;
        }
        catch (IOException ioe) {
            Logger.getLogger(CatalogPanel.class.getName()).log(Level.WARNING, null, ioe);
        }
        return df;
    }

    static DataObject createDuplicateFromNode(Node n) {
        DataObject source = CatalogPanel.getDOFromNode(n);
        try {
            return source.copy(source.getFolder());
        }
        catch (IOException ioe) {
            Logger.getLogger(CatalogPanel.class.getName()).log(Level.WARNING, null, ioe);
            return null;
        }
    }

    static FileObject getCatalogRoot() {
        if (catalogRoot == null) {
            catalogRoot = FileUtil.getConfigFile((String)"Catalog");
        }
        return catalogRoot;
    }

    private int getNodePosition(Node n) {
        Index supp = this.getIndexSupport(n);
        DataFolder df = (DataFolder)n.getParentNode().getLookup().lookup(DataFolder.class);
        df.getNodeDelegate().getChildren().getNodes(true);
        int pos = supp.indexOf(n);
        assert (pos != -1) : "Node " + n + " has position " + pos + " in children " + Arrays.asList(n.getParentNode().getChildren().getNodes());
        return pos;
    }

    private Index getIndexSupport(Node n) {
        Node parent = n.getParentNode();
        assert (parent != null) : "Node " + n + " has a parent.";
        Index index = (Index)parent.getLookup().lookup(Index.class);
        assert (index != null) : "Node " + parent + " has Index cookie.";
        return index;
    }

    private static final class TemplateFilter
    implements DataFilter {
        private TemplateFilter() {
        }

        public boolean acceptDataObject(DataObject obj) {
            return this.acceptTemplate(obj);
        }

        private boolean acceptTemplate(DataObject d) {
            if (d.isTemplate() || d instanceof DataFolder) {
                Object o = d.getPrimaryFile().getAttribute("simple");
                return o == null || Boolean.TRUE.equals(o);
            }
            return false;
        }
    }

    private class SelectionListener
    implements PropertyChangeListener {
        private SelectionListener() {
        }

        @Override
        public void propertyChange(PropertyChangeEvent evt) {
            if ("selectedNodes".equals(evt.getPropertyName())) {
                Node[] nodes = (Node[])evt.getNewValue();
                boolean res = nodes != null && nodes.length > 0;
                int i = 0;
                while (res && i < nodes.length) {
                    Node n;
                    if ((n = nodes[i++]) instanceof CatalogNode && ((CatalogNode)n).isRemovable()) {
                        res = true;
                        break;
                    }
                    Node.Cookie node = n.getCookie(CatalogEntryNode.class);
                    res = node instanceof CatalogEntryNode && ((CatalogEntryNode)node).isCatalogWriter();
                }
                CatalogPanel.this.removeButton.setEnabled(res);
                if (nodes.length > 0) {
                    Node.Cookie node = nodes[0].getCookie(CatalogNode.class);
                    CatalogPanel.this.addLocalButton.setEnabled(node instanceof CatalogNode && ((CatalogNode)node).getCatalogReader() instanceof CatalogWriter);
                }
            }
        }
    }

    private static class CatalogTreeView
    extends BeanTreeView {
        private Action startEditing;

        private CatalogTreeView() {
        }

        private void invokeInplaceEditing() {
            Action o;
            if (this.startEditing == null && (o = this.tree.getActionMap().get("startEditing")) != null && o instanceof Action) {
                this.startEditing = o;
            }
            assert (this.startEditing != null) : "startEditing is on tree ActionMap " + Arrays.asList(this.tree.getActionMap().keys());
            this.startEditing.actionPerformed(new ActionEvent(this.tree, 0, "startEditing"));
        }
    }
}

