/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.shared.dependency.graph.internal;

import org.apache.maven.artifact.resolver.filter.ArtifactFilter;
import org.apache.maven.project.MavenProject;
import org.apache.maven.shared.dependency.graph.DependencyGraphBuilder;
import org.apache.maven.shared.dependency.graph.DependencyGraphBuilderException;
import org.apache.maven.shared.dependency.graph.DependencyNode;
import org.codehaus.plexus.PlexusContainer;
import org.codehaus.plexus.component.annotations.Component;
import org.codehaus.plexus.component.repository.exception.ComponentLookupException;
import org.codehaus.plexus.context.Context;
import org.codehaus.plexus.context.ContextException;
import org.codehaus.plexus.logging.AbstractLogEnabled;
import org.codehaus.plexus.personality.plexus.lifecycle.phase.Contextualizable;

@Component(role=DependencyGraphBuilder.class)
public class DefaultDependencyGraphBuilder
extends AbstractLogEnabled
implements DependencyGraphBuilder,
Contextualizable {
    protected PlexusContainer container;

    public DependencyNode buildDependencyGraph(MavenProject project, ArtifactFilter filter) throws DependencyGraphBuilderException {
        try {
            String hint = DefaultDependencyGraphBuilder.isMaven2x() ? "maven2" : "maven3";
            this.getLogger().debug("building " + hint + " dependency graph for " + project.getId());
            DependencyGraphBuilder effectiveGraphBuilder = (DependencyGraphBuilder)this.container.lookup(DependencyGraphBuilder.class.getCanonicalName(), hint);
            return effectiveGraphBuilder.buildDependencyGraph(project, filter);
        }
        catch (ComponentLookupException e) {
            throw new DependencyGraphBuilderException(e.getMessage(), e);
        }
    }

    protected static boolean isMaven2x() {
        try {
            Class.forName("org.apache.maven.project.DependencyResolutionRequest");
            return false;
        }
        catch (ClassNotFoundException e) {
            return true;
        }
    }

    public void contextualize(Context context) throws ContextException {
        this.container = (PlexusContainer)context.get((Object)"plexus");
    }
}

