/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.web.servlet.mvc.method.annotation;

import java.io.IOException;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.List;
import java.util.Map;
import org.springframework.core.MethodParameter;
import org.springframework.http.HttpEntity;
import org.springframework.http.HttpHeaders;
import org.springframework.http.ResponseEntity;
import org.springframework.http.converter.HttpMessageConverter;
import org.springframework.http.server.ServletServerHttpRequest;
import org.springframework.http.server.ServletServerHttpResponse;
import org.springframework.util.Assert;
import org.springframework.util.MultiValueMap;
import org.springframework.web.HttpMediaTypeNotSupportedException;
import org.springframework.web.accept.ContentNegotiationManager;
import org.springframework.web.bind.support.WebDataBinderFactory;
import org.springframework.web.context.request.NativeWebRequest;
import org.springframework.web.method.support.ModelAndViewContainer;
import org.springframework.web.servlet.mvc.method.annotation.AbstractMessageConverterMethodProcessor;

public class HttpEntityMethodProcessor
extends AbstractMessageConverterMethodProcessor {
    public HttpEntityMethodProcessor(List<HttpMessageConverter<?>> messageConverters) {
        super(messageConverters);
    }

    public HttpEntityMethodProcessor(List<HttpMessageConverter<?>> messageConverters, ContentNegotiationManager contentNegotiationManager) {
        super(messageConverters, contentNegotiationManager);
    }

    public boolean supportsParameter(MethodParameter parameter) {
        return HttpEntity.class.equals((Object)parameter.getParameterType());
    }

    public boolean supportsReturnType(MethodParameter returnType) {
        return HttpEntity.class.isAssignableFrom(returnType.getParameterType());
    }

    public Object resolveArgument(MethodParameter parameter, ModelAndViewContainer mavContainer, NativeWebRequest webRequest, WebDataBinderFactory binderFactory) throws IOException, HttpMediaTypeNotSupportedException {
        ServletServerHttpRequest inputMessage = this.createInputMessage(webRequest);
        Type paramType = this.getHttpEntityType(parameter);
        Object body = this.readWithMessageConverters(webRequest, parameter, paramType);
        return new HttpEntity(body, (MultiValueMap)inputMessage.getHeaders());
    }

    private Type getHttpEntityType(MethodParameter parameter) {
        ParameterizedType type;
        Assert.isAssignable(HttpEntity.class, (Class)parameter.getParameterType());
        Type parameterType = parameter.getGenericParameterType();
        if (parameterType instanceof ParameterizedType && (type = (ParameterizedType)parameterType).getActualTypeArguments().length == 1) {
            return type.getActualTypeArguments()[0];
        }
        throw new IllegalArgumentException("HttpEntity parameter '" + parameter.getParameterName() + "' in method " + parameter.getMethod() + " is not parameterized or has more than one parameter");
    }

    public void handleReturnValue(Object returnValue, MethodParameter returnType, ModelAndViewContainer mavContainer, NativeWebRequest webRequest) throws Exception {
        Object body;
        HttpHeaders entityHeaders;
        mavContainer.setRequestHandled(true);
        if (returnValue == null) {
            return;
        }
        ServletServerHttpRequest inputMessage = this.createInputMessage(webRequest);
        ServletServerHttpResponse outputMessage = this.createOutputMessage(webRequest);
        Assert.isInstanceOf(HttpEntity.class, (Object)returnValue);
        HttpEntity responseEntity = (HttpEntity)returnValue;
        if (responseEntity instanceof ResponseEntity) {
            outputMessage.setStatusCode(((ResponseEntity)responseEntity).getStatusCode());
        }
        if (!(entityHeaders = responseEntity.getHeaders()).isEmpty()) {
            outputMessage.getHeaders().putAll((Map)entityHeaders);
        }
        if ((body = responseEntity.getBody()) != null) {
            this.writeWithMessageConverters(body, returnType, inputMessage, outputMessage);
        } else {
            outputMessage.getBody();
        }
    }
}

