/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.impl.io;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.RandomAccessFile;
import java.nio.channels.AsynchronousCloseException;
import java.nio.channels.FileChannel;
import java.nio.channels.FileLock;
import java.nio.channels.OverlappingFileLockException;
import org.apache.derby.iapi.error.StandardException;
import org.apache.derby.iapi.services.io.FileUtil;
import org.apache.derby.iapi.util.InterruptStatus;
import org.apache.derby.impl.io.DirRandomAccessFile;
import org.apache.derby.io.StorageFile;
import org.apache.derby.io.StorageRandomAccessFile;

class DirFile
extends File
implements StorageFile {
    private RandomAccessFile lockFileOpen;
    private FileChannel lockFileChannel;
    private FileLock dbLock;

    DirFile(String string) {
        super(string);
    }

    DirFile(String string, String string2) {
        super(string, string2);
    }

    DirFile(DirFile dirFile, String string) {
        super(dirFile, string);
    }

    @Override
    public StorageFile getParentDir() {
        String string = this.getParent();
        if (string == null) {
            return null;
        }
        return new DirFile(string);
    }

    @Override
    public OutputStream getOutputStream() throws FileNotFoundException {
        return this.getOutputStream(false);
    }

    @Override
    public OutputStream getOutputStream(boolean bl) throws FileNotFoundException {
        boolean bl2 = this.exists();
        FileOutputStream fileOutputStream = new FileOutputStream(this, bl);
        if (!bl2) {
            try {
                this.limitAccessToOwner();
            }
            catch (FileNotFoundException fileNotFoundException) {
                throw fileNotFoundException;
            }
            catch (IOException iOException) {
                FileNotFoundException fileNotFoundException = new FileNotFoundException();
                fileNotFoundException.initCause(iOException);
                throw fileNotFoundException;
            }
        }
        return fileOutputStream;
    }

    @Override
    public InputStream getInputStream() throws FileNotFoundException {
        return new FileInputStream(this);
    }

    @Override
    public synchronized int getExclusiveFileLock() throws StandardException {
        int n;
        block14: {
            boolean bl = false;
            try {
                if (this.createNewFile()) {
                    bl = true;
                } else if (this.length() > 0L) {
                    bl = true;
                }
                if (bl) {
                    int n2 = 120;
                    while (true) {
                        this.lockFileOpen = new RandomAccessFile(this, "rw");
                        this.limitAccessToOwner();
                        this.lockFileChannel = this.lockFileOpen.getChannel();
                        try {
                            this.dbLock = this.lockFileChannel.tryLock();
                            if (this.dbLock == null) {
                                this.lockFileChannel.close();
                                this.lockFileChannel = null;
                                this.lockFileOpen.close();
                                this.lockFileOpen = null;
                                n = 2;
                            } else {
                                this.lockFileOpen.writeInt(1);
                                this.lockFileChannel.force(true);
                                n = 1;
                            }
                            break block14;
                        }
                        catch (AsynchronousCloseException asynchronousCloseException) {
                            InterruptStatus.setInterrupted();
                            this.lockFileOpen.close();
                            if (n2-- > 0) continue;
                            throw asynchronousCloseException;
                        }
                        break;
                    }
                }
                n = 0;
            }
            catch (IOException iOException) {
                this.releaseExclusiveFileLock();
                n = 0;
            }
            catch (OverlappingFileLockException overlappingFileLockException) {
                try {
                    this.lockFileChannel.close();
                    this.lockFileOpen.close();
                }
                catch (IOException iOException) {
                    // empty catch block
                }
                this.lockFileChannel = null;
                this.lockFileOpen = null;
                n = 2;
            }
        }
        return n;
    }

    @Override
    public synchronized void releaseExclusiveFileLock() {
        try {
            if (this.dbLock != null) {
                this.dbLock.release();
                this.dbLock = null;
            }
            if (this.lockFileChannel != null) {
                this.lockFileChannel.close();
                this.lockFileChannel = null;
            }
            if (this.lockFileOpen != null) {
                this.lockFileOpen.close();
                this.lockFileOpen = null;
            }
            if (this.exists()) {
                this.delete();
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    @Override
    public StorageRandomAccessFile getRandomAccessFile(String string) throws FileNotFoundException {
        return new DirRandomAccessFile(this, string);
    }

    @Override
    public boolean renameTo(StorageFile storageFile) {
        boolean bl = super.renameTo((File)((Object)storageFile));
        for (int i = 1; !bl && i <= 5; ++i) {
            try {
                Thread.sleep(1000 * i);
            }
            catch (InterruptedException interruptedException) {
                InterruptStatus.setInterrupted();
            }
            bl = super.renameTo((File)((Object)storageFile));
        }
        return bl;
    }

    @Override
    public boolean deleteAll() {
        if (!this.exists()) {
            return false;
        }
        String[] stringArray = super.list();
        if (stringArray != null) {
            String string = this.getPath();
            for (int i = 0; i < stringArray.length; ++i) {
                DirFile dirFile;
                if (stringArray[i].equals(".") || stringArray[i].equals("..") || (dirFile = new DirFile(string, stringArray[i])).deleteAll()) continue;
                return false;
            }
        }
        return this.delete();
    }

    @Override
    public void limitAccessToOwner() throws IOException {
        FileUtil.limitAccessToOwner(this);
    }
}

