/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.script;

import com.intellij.ide.highlighter.JavaClassFileType;
import com.intellij.openapi.fileTypes.FileTypeRegistry;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.idea.KotlinFileType;
import org.jetbrains.kotlin.psi.KtFile;
import org.jetbrains.kotlin.script.KotlinScriptDefinition;
import org.jetbrains.kotlin.script.ScriptDefinitionProvider;

@Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=2, d1={"\u0000*\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\u001a\u0018\u0010\u0000\u001a\u0004\u0018\u00010\u00012\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0005\u001a\u0016\u0010\u0006\u001a\u00020\u00012\u0006\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0007\u001a\u00020\b\u001a\f\u0010\t\u001a\u00020\n*\u00020\u0003H\u0002\u001a\f\u0010\u000b\u001a\u00020\n*\u00020\u0003H\u0002\u001a\f\u0010\f\u001a\u0004\u0018\u00010\u0001*\u00020\r\u00a8\u0006\u000e"}, d2={"findScriptDefinition", "Lorg/jetbrains/kotlin/script/KotlinScriptDefinition;", "file", "Lcom/intellij/openapi/vfs/VirtualFile;", "project", "Lcom/intellij/openapi/project/Project;", "scriptDefinitionByFileName", "fileName", "", "isKotlinFileType", "", "isNonScript", "scriptDefinition", "Lcom/intellij/psi/PsiFile;", "psi"})
public final class KotlinScriptDefinitionProviderKt {
    @Nullable
    public static final KotlinScriptDefinition scriptDefinition(@NotNull PsiFile $this$scriptDefinition) {
        Intrinsics.checkParameterIsNotNull($this$scriptDefinition, "$this$scriptDefinition");
        if (!($this$scriptDefinition instanceof KtFile)) {
            return null;
        }
        VirtualFile virtualFile2 = ((KtFile)$this$scriptDefinition).getVirtualFile();
        if (virtualFile2 == null) {
            PsiFile psiFile = ((KtFile)$this$scriptDefinition).getOriginalFile();
            Intrinsics.checkExpressionValueIsNotNull(psiFile, "originalFile");
            virtualFile2 = psiFile.getVirtualFile();
        }
        if (virtualFile2 == null) {
            return null;
        }
        VirtualFile file2 = virtualFile2;
        if (KotlinScriptDefinitionProviderKt.isNonScript(file2)) {
            return null;
        }
        Project project = ((KtFile)$this$scriptDefinition).getProject();
        Intrinsics.checkExpressionValueIsNotNull(project, "project");
        String string = file2.getName();
        Intrinsics.checkExpressionValueIsNotNull(string, "file.name");
        return KotlinScriptDefinitionProviderKt.scriptDefinitionByFileName(project, string);
    }

    @Nullable
    public static final KotlinScriptDefinition findScriptDefinition(@NotNull VirtualFile file2, @NotNull Project project) {
        Intrinsics.checkParameterIsNotNull(file2, "file");
        Intrinsics.checkParameterIsNotNull(project, "project");
        if (KotlinScriptDefinitionProviderKt.isNonScript(file2)) {
            return null;
        }
        PsiFile psiFile = PsiManager.getInstance(project).findFile(file2);
        if (!(psiFile instanceof KtFile)) {
            psiFile = null;
        }
        if ((KtFile)psiFile == null) {
            return null;
        }
        String string = file2.getName();
        Intrinsics.checkExpressionValueIsNotNull(string, "file.name");
        return KotlinScriptDefinitionProviderKt.scriptDefinitionByFileName(project, string);
    }

    @NotNull
    public static final KotlinScriptDefinition scriptDefinitionByFileName(@NotNull Project project, @NotNull String fileName) {
        Intrinsics.checkParameterIsNotNull(project, "project");
        Intrinsics.checkParameterIsNotNull(fileName, "fileName");
        ScriptDefinitionProvider scriptDefinitionProvider = ScriptDefinitionProvider.Companion.getInstance(project);
        if (scriptDefinitionProvider == null) {
            throw (Throwable)new IllegalStateException("Unable to get script definition: ScriptDefinitionProvider is not configured.");
        }
        ScriptDefinitionProvider scriptDefinitionProvider2 = scriptDefinitionProvider;
        KotlinScriptDefinition kotlinScriptDefinition = scriptDefinitionProvider2.findScriptDefinition(fileName);
        if (kotlinScriptDefinition == null) {
            kotlinScriptDefinition = scriptDefinitionProvider2.getDefaultScriptDefinition();
        }
        return kotlinScriptDefinition;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static final boolean isNonScript(@NotNull VirtualFile $this$isNonScript) {
        if ($this$isNonScript.isDirectory()) return true;
        if (Intrinsics.areEqual($this$isNonScript.getExtension(), "kt")) return true;
        String string = $this$isNonScript.getExtension();
        JavaClassFileType javaClassFileType = JavaClassFileType.INSTANCE;
        Intrinsics.checkExpressionValueIsNotNull(javaClassFileType, "JavaClassFileType.INSTANCE");
        if (Intrinsics.areEqual(string, javaClassFileType.getDefaultExtension())) return true;
        if (KotlinScriptDefinitionProviderKt.isKotlinFileType($this$isNonScript)) return false;
        return true;
    }

    private static final boolean isKotlinFileType(@NotNull VirtualFile $this$isKotlinFileType) {
        FileTypeRegistry typeRegistry = FileTypeRegistry.getInstance();
        return Intrinsics.areEqual(typeRegistry.getFileTypeByFile($this$isKotlinFileType), KotlinFileType.INSTANCE) || Intrinsics.areEqual(typeRegistry.getFileTypeByFileName($this$isKotlinFileType.getName()), KotlinFileType.INSTANCE);
    }
}

