/*
 * Decompiled with CFR 0.152.
 */
package com.drew.metadata.test;

import com.drew.imaging.jpeg.JpegMetadataReader;
import com.drew.imaging.jpeg.JpegProcessingException;
import com.drew.imaging.jpeg.JpegSegmentData;
import com.drew.imaging.jpeg.JpegSegmentReader;
import java.io.File;
import java.io.FileOutputStream;
import java.io.ObjectOutputStream;
import junit.framework.TestCase;

public class SpecialTests
extends TestCase {
    public void testExtractMetadataToASeparateFile() throws Exception {
        String filename = "src/com/drew/metadata/exif/test/nikonMakernoteType2";
        JpegSegmentData segmentData = new JpegSegmentReader(new File(String.valueOf(filename) + ".jpg")).getSegmentData();
        segmentData.removeSegment((byte)-60);
        segmentData.removeSegment((byte)-37);
        segmentData.removeSegment((byte)-64);
        segmentData.removeSegment((byte)-40);
        ObjectOutputStream outputStream = null;
        try {
            outputStream = new ObjectOutputStream(new FileOutputStream(new File(String.valueOf(filename) + ".metadata")));
            outputStream.writeObject(segmentData);
        }
        finally {
            if (outputStream != null) {
                outputStream.close();
            }
        }
    }

    public void testScanFoldersForImagesThatCauseFailures() throws Exception {
        String directory = "\\\\annie\\htdocs\\drewnoakes.com\\code\\exif\\exifImages";
        this.processDirectory(directory);
        System.out.println("Complete test successfully.");
    }

    private void processDirectory(String pathName) {
        File directory = new File(pathName);
        String[] directoryItems = directory.list();
        if (directoryItems == null) {
            return;
        }
        int i = 0;
        while (i < directoryItems.length) {
            String subItem = directoryItems[i].toLowerCase();
            File file = new File(directory, subItem);
            if (!file.exists()) {
                throw new RuntimeException("World gone nuts.");
            }
            if (file.isDirectory()) {
                this.processDirectory(file.getAbsolutePath());
            } else if (subItem.endsWith(".jpg") || subItem.endsWith(".jpeg")) {
                try {
                    JpegSegmentReader segmentReader = new JpegSegmentReader(file);
                    try {
                        JpegMetadataReader.extractMetadataFromJpegSegmentReader(segmentReader);
                    }
                    catch (Throwable t) {
                        System.err.println(file + "[BadMetadata]");
                        System.err.println(t);
                        System.err.println(t.getMessage());
                        t.printStackTrace(System.err);
                    }
                }
                catch (JpegProcessingException e) {
                    System.err.println(file + "[BadSegments]");
                }
                catch (Throwable t) {
                    System.err.println(file + "[FAILURE]");
                    System.err.println(t);
                    System.err.println(t.getMessage());
                    t.printStackTrace(System.err);
                }
            }
            ++i;
        }
    }
}

