/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.xsd.ui.internal.adt.typeviz.design.figures;

import org.eclipse.draw2d.Graphics;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.LineBorder;
import org.eclipse.draw2d.geometry.Insets;
import org.eclipse.swt.graphics.Color;

public class RoundedLineBorder
extends LineBorder {
    protected int arcLength;
    protected int lineStyle = 1;

    public RoundedLineBorder(Color c, int width, int arcLength) {
        super(c, width);
        this.arcLength = arcLength;
    }

    public RoundedLineBorder(int width, int arcLength) {
        super(width);
        this.arcLength = arcLength;
    }

    public RoundedLineBorder(Color c, int width, int arcLength, int lineStyle) {
        super(c, width);
        this.arcLength = arcLength;
        this.lineStyle = lineStyle;
    }

    public RoundedLineBorder(int width, int arcLength, int lineStyle) {
        super(width);
        this.arcLength = arcLength;
        this.lineStyle = lineStyle;
    }

    public void paint(IFigure figure, Graphics graphics, Insets insets) {
        int rlbWidth = this.getWidth();
        tempRect.setBounds(RoundedLineBorder.getPaintRectangle((IFigure)figure, (Insets)insets));
        if (rlbWidth % 2 == 1) {
            --RoundedLineBorder.tempRect.width;
            --RoundedLineBorder.tempRect.height;
        }
        tempRect.shrink(rlbWidth / 2, rlbWidth / 2);
        graphics.setLineWidth(rlbWidth);
        graphics.setLineStyle(this.lineStyle);
        if (this.getColor() != null) {
            graphics.setForegroundColor(this.getColor());
        }
        graphics.drawRoundRectangle(tempRect, this.arcLength, this.arcLength);
    }
}

