/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.internal.lttng2.kernel.ui.views.vm.vcpuview;

import com.google.common.collect.Multimap;
import java.util.Collection;
import java.util.Comparator;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.osgi.util.NLS;
import org.eclipse.tracecompass.common.core.NonNullUtils;
import org.eclipse.tracecompass.internal.lttng2.kernel.core.analysis.vm.trace.VirtualMachineExperiment;
import org.eclipse.tracecompass.internal.lttng2.kernel.ui.views.vm.vcpuview.Messages;
import org.eclipse.tracecompass.internal.lttng2.kernel.ui.views.vm.vcpuview.VirtualMachineCommon;
import org.eclipse.tracecompass.statesystem.core.interval.ITmfStateInterval;
import org.eclipse.tracecompass.tmf.core.trace.ITmfTrace;
import org.eclipse.tracecompass.tmf.ui.widgets.timegraph.model.ITimeGraphEntry;
import org.eclipse.tracecompass.tmf.ui.widgets.timegraph.model.TimeGraphEntry;

public final class VirtualMachineViewEntry
extends TimeGraphEntry {
    private static final Comparator<ITimeGraphEntry> COMPARATOR = new Comparator<ITimeGraphEntry>(){

        @Override
        public int compare(@Nullable ITimeGraphEntry o1, @Nullable ITimeGraphEntry o2) {
            if (!(o1 instanceof VirtualMachineViewEntry) || !(o2 instanceof VirtualMachineViewEntry)) {
                return 0;
            }
            VirtualMachineViewEntry entry1 = (VirtualMachineViewEntry)o1;
            VirtualMachineViewEntry entry2 = (VirtualMachineViewEntry)o2;
            int result = entry1.getType().compareTo(entry2.getType());
            if (result == 0) {
                result = entry1.getNumericId() != -1 ? entry1.getNumericId().compareTo(entry2.getNumericId()) : entry1.getId().compareTo(entry2.getId());
            }
            return result;
        }
    };
    private final String fId;
    private final @Nullable String fVmName;
    private final ITmfTrace fTrace;
    private final VirtualMachineExperiment fExperiment;
    private final VirtualMachineCommon.Type fType;
    private final Integer fNid;
    private @Nullable Multimap<Integer, ITmfStateInterval> fThreadIntervals = null;

    private VirtualMachineViewEntry(VmEntryBuilder builder) {
        super(builder.fbEntryName, builder.fbStartTime, builder.fbEndTime);
        this.fId = builder.fbId;
        this.fExperiment = builder.fbExperiment;
        ITmfTrace trace = builder.fbTrace;
        if (trace == null) {
            trace = this.fExperiment;
        }
        this.fTrace = trace;
        this.fType = builder.fbType;
        Integer nid = builder.fbNid;
        if (nid == null) {
            nid = -1;
        }
        this.fNid = nid;
        this.fVmName = builder.fbVmName;
        this.sortChildren(COMPARATOR);
    }

    public String getId() {
        return this.fId;
    }

    public @Nullable String getVmName() {
        return this.fVmName;
    }

    public ITmfTrace getTrace() {
        return this.fTrace;
    }

    public VirtualMachineExperiment getExperiment() {
        return this.fExperiment;
    }

    public VirtualMachineCommon.Type getType() {
        return this.fType;
    }

    public Integer getNumericId() {
        return this.fNid;
    }

    public boolean hasTimeEvents() {
        return this.fType != VirtualMachineCommon.Type.NULL;
    }

    public @Nullable Collection<ITmfStateInterval> getThreadIntervals(Integer threadId) {
        Multimap<Integer, ITmfStateInterval> threadIntervals = this.fThreadIntervals;
        if (threadIntervals == null) {
            return null;
        }
        return threadIntervals.get((Object)threadId);
    }

    public void setThreadIntervals(Multimap<Integer, ITmfStateInterval> threadIntervals) {
        this.fThreadIntervals = threadIntervals;
    }

    public static Comparator<ITimeGraphEntry> getComparator() {
        return COMPARATOR;
    }

    /* synthetic */ VirtualMachineViewEntry(VmEntryBuilder vmEntryBuilder, VirtualMachineViewEntry virtualMachineViewEntry) {
        this(vmEntryBuilder);
    }

    public static class VmEntryBuilder {
        private final long fbStartTime;
        private final long fbEndTime;
        private final VirtualMachineExperiment fbExperiment;
        private String fbEntryName;
        private String fbId;
        private VirtualMachineCommon.Type fbType;
        private @Nullable String fbVmName;
        private @Nullable ITmfTrace fbTrace;
        private @Nullable Integer fbNid;

        public VmEntryBuilder(String name, long startTime, long endTime, VirtualMachineExperiment experiment) {
            this.fbEntryName = name;
            this.fbStartTime = startTime;
            this.fbEndTime = endTime;
            this.fbExperiment = experiment;
            this.fbId = name;
            this.fbType = VirtualMachineCommon.Type.NULL;
        }

        public VmEntryBuilder setId(String id) {
            this.fbId = id;
            return this;
        }

        public VmEntryBuilder setVmName(String vmName) {
            this.fbVmName = vmName;
            return this;
        }

        public VmEntryBuilder setTrace(ITmfTrace trace) {
            this.fbTrace = trace;
            return this;
        }

        public VmEntryBuilder setType(VirtualMachineCommon.Type type) {
            this.fbType = type;
            return this;
        }

        public VmEntryBuilder setNumericId(Integer nid) {
            this.fbNid = nid;
            return this;
        }

        public VirtualMachineViewEntry build() {
            switch (this.fbType) {
                case VCPU: {
                    this.fbEntryName = String.valueOf(Messages.VmView_VCpu) + ' ' + this.fbEntryName;
                    break;
                }
                case VM: {
                    this.fbEntryName = NonNullUtils.nullToEmptyString((Object)NLS.bind((String)Messages.VmView_virtualMachine, (Object)this.fbEntryName));
                    break;
                }
            }
            return new VirtualMachineViewEntry(this, null);
        }
    }
}

