/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.zest.core.viewers.internal;

import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import org.eclipse.zest.core.viewers.EntityConnectionData;
import org.eclipse.zest.core.viewers.IFigureProvider;
import org.eclipse.zest.core.viewers.IGraphEntityContentProvider;
import org.eclipse.zest.core.viewers.internal.AbstractStructuredGraphViewer;
import org.eclipse.zest.core.viewers.internal.AbstractStylingModelFactory;
import org.eclipse.zest.core.widgets.Graph;
import org.eclipse.zest.core.widgets.GraphConnection;
import org.eclipse.zest.core.widgets.GraphItem;
import org.eclipse.zest.core.widgets.GraphNode;

public class GraphModelEntityFactory
extends AbstractStylingModelFactory {
    AbstractStructuredGraphViewer viewer = null;

    public GraphModelEntityFactory(AbstractStructuredGraphViewer viewer) {
        super(viewer);
        this.viewer = viewer;
    }

    public Graph createGraphModel(Graph model) {
        this.doBuildGraph(model);
        return model;
    }

    protected void doBuildGraph(Graph model) {
        super.doBuildGraph(model);
        Object inputElement = this.getViewer().getInput();
        Object[] entities = this.getContentProvider().getElements(inputElement);
        if (entities == null) {
            return;
        }
        int i = 0;
        while (i < entities.length) {
            Object data = entities[i];
            IFigureProvider figureProvider = null;
            if (this.getLabelProvider() instanceof IFigureProvider) {
                figureProvider = (IFigureProvider)this.getLabelProvider();
            }
            if (!this.filterElement(inputElement, data)) {
                if (figureProvider != null) {
                    this.createNode(model, data, figureProvider.getFigure(data));
                } else {
                    this.createNode(model, data);
                }
            }
            ++i;
        }
        Set keySet = ((AbstractStructuredGraphViewer)this.getViewer()).getNodesMap().keySet();
        entities = keySet.toArray();
        int i2 = 0;
        while (i2 < entities.length) {
            Object[] related;
            Object data = entities[i2];
            if (!this.filterElement(inputElement, data) && (related = ((IGraphEntityContentProvider)this.getContentProvider()).getConnectedTo(data)) != null) {
                int j = 0;
                while (j < related.length) {
                    EntityConnectionData connectionData;
                    if (!this.filterElement(inputElement, related[j]) && !this.filterElement(inputElement, connectionData = new EntityConnectionData(data, related[j]))) {
                        this.createConnection(model, connectionData, data, related[j]);
                    }
                    ++j;
                }
            }
            ++i2;
        }
    }

    public void refresh(Graph graph, Object element, boolean refreshLabels) {
        GraphConnection conn;
        if (element == null) {
            return;
        }
        GraphNode node = this.viewer.getGraphModelNode(element);
        if (node == null && (conn = this.viewer.getGraphModelConnection(element)) != null) {
            this.refresh(graph, conn.getSource().getData(), refreshLabels);
            this.refresh(graph, conn.getDestination().getData(), refreshLabels);
            return;
        }
        if (node == null) {
            return;
        }
        this.reconnect(graph, element, refreshLabels);
        if (refreshLabels) {
            this.update(node);
            Iterator it = node.getSourceConnections().iterator();
            while (it.hasNext()) {
                this.update((GraphItem)((Object)it.next()));
            }
            it = node.getTargetConnections().iterator();
            while (it.hasNext()) {
                this.update((GraphItem)((Object)it.next()));
            }
        }
    }

    private void reconnect(Graph graph, Object element, boolean refreshLabels) {
        Object next;
        GraphNode node = this.viewer.getGraphModelNode(element);
        Object[] related = ((IGraphEntityContentProvider)this.getContentProvider()).getConnectedTo(element);
        List connections = node.getSourceConnections();
        LinkedList toAdd = new LinkedList();
        LinkedList toDelete = new LinkedList();
        LinkedList toKeep = new LinkedList();
        HashSet<Object> oldExternalConnections = new HashSet<Object>();
        HashSet<EntityConnectionData> newExternalConnections = new HashSet<EntityConnectionData>();
        Iterator it = connections.iterator();
        while (it.hasNext()) {
            oldExternalConnections.add(((GraphConnection)((Object)it.next())).getExternalConnection());
        }
        int i = 0;
        while (i < related.length) {
            newExternalConnections.add(new EntityConnectionData(element, related[i]));
            ++i;
        }
        it = oldExternalConnections.iterator();
        while (it.hasNext()) {
            next = it.next();
            if (!newExternalConnections.contains(next)) {
                toDelete.add(next);
                continue;
            }
            toKeep.add(next);
        }
        it = newExternalConnections.iterator();
        while (it.hasNext()) {
            next = it.next();
            if (oldExternalConnections.contains(next)) continue;
            toAdd.add(next);
        }
        it = toDelete.iterator();
        while (it.hasNext()) {
            this.viewer.removeGraphModelConnection(it.next());
        }
        toDelete.clear();
        LinkedList<Object> newNodeList = new LinkedList<Object>();
        Iterator it2 = toAdd.iterator();
        while (it2.hasNext()) {
            EntityConnectionData data = (EntityConnectionData)it2.next();
            GraphNode dest = this.viewer.getGraphModelNode(data.dest);
            if (dest == null) {
                newNodeList.add(data.dest);
            }
            this.createConnection(graph, data, data.source, data.dest);
        }
        toAdd.clear();
        if (refreshLabels) {
            Iterator i2 = toKeep.iterator();
            while (i2.hasNext()) {
                this.styleItem(this.viewer.getGraphModelConnection(i2.next()));
            }
        }
        it2 = newNodeList.iterator();
        while (it2.hasNext()) {
            this.refresh(graph, it2.next());
        }
    }

    public void refresh(Graph graph, Object element) {
        this.refresh(graph, element, false);
    }
}

