/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.linuxtools.internal.docker.ui.launch;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.eclipse.core.databinding.beans.BeanProperties;
import org.eclipse.core.databinding.property.value.IValueProperty;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.ILaunchConfigurationWorkingCopy;
import org.eclipse.debug.ui.AbstractLaunchConfigurationTab;
import org.eclipse.jface.databinding.viewers.ObservableListContentProvider;
import org.eclipse.jface.databinding.viewers.ViewerSupport;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.layout.GridLayoutFactory;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredViewer;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.TableViewerColumn;
import org.eclipse.linuxtools.internal.docker.ui.SWTImagesFactory;
import org.eclipse.linuxtools.internal.docker.ui.launch.LaunchMessages;
import org.eclipse.linuxtools.internal.docker.ui.wizards.ContainerLinkDialog;
import org.eclipse.linuxtools.internal.docker.ui.wizards.ImageRunSelectionModel;
import org.eclipse.linuxtools.internal.docker.ui.wizards.WizardMessages;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;

public class RunImageLinksTab
extends AbstractLaunchConfigurationTab {
    private static final String TAB_NAME = "RunLinksTab.name";
    private static final int COLUMNS = 3;
    private ImageRunSelectionModel model = null;

    public RunImageLinksTab(ImageRunSelectionModel model) {
        this.model = model;
    }

    public void createControl(Composite parent) {
        Composite container = new Composite(parent, 0);
        GridDataFactory.fillDefaults().align(4, 4).span(1, 1).grab(true, false).applyTo((Control)container);
        GridLayoutFactory.fillDefaults().numColumns(3).margins(6, 6).applyTo(container);
        if (this.model == null) {
            this.setErrorMessage(LaunchMessages.getString("NoConnectionError.msg"));
        } else {
            this.setErrorMessage(null);
            this.createLinkSettingsSection(container);
        }
        this.setControl((Control)container);
    }

    private TableViewerColumn createTableViewerColumn(TableViewer tableViewer, String title, int width) {
        TableViewerColumn viewerColumn = new TableViewerColumn(tableViewer, 0);
        TableColumn column = viewerColumn.getColumn();
        if (title != null) {
            column.setText(title);
        }
        column.setWidth(width);
        return viewerColumn;
    }

    private void createLinkSettingsSection(Composite container) {
        GridDataFactory.fillDefaults().align(4, 0x1000000).grab(false, false).span(3, 1).applyTo((Control)new Label(container, 0));
        Label linksLabel = new Label(container, 0);
        linksLabel.setText(WizardMessages.getString("ImageRunSelectionPage.links"));
        GridDataFactory.fillDefaults().align(4, 0x1000000).grab(false, false).span(3, 1).applyTo((Control)linksLabel);
        TableViewer linksTableViewer = this.createLinksTable(container);
        GridDataFactory.fillDefaults().align(4, 4).grab(true, true).hint(200, 100).applyTo((Control)linksTableViewer.getTable());
        Composite buttonsContainers = new Composite(container, 0);
        GridDataFactory.fillDefaults().align(4, 128).grab(false, false).applyTo((Control)buttonsContainers);
        GridLayoutFactory.fillDefaults().numColumns(1).margins(0, 0).spacing(-1, 0).applyTo(buttonsContainers);
        Button addButton = new Button(buttonsContainers, 0);
        GridDataFactory.fillDefaults().align(4, 128).grab(true, false).applyTo((Control)addButton);
        addButton.setText(WizardMessages.getString("ImageRunSelectionPage.addButton"));
        addButton.addSelectionListener(this.onAddLink());
        Button editButton = new Button(buttonsContainers, 0);
        GridDataFactory.fillDefaults().align(4, 128).grab(true, false).applyTo((Control)editButton);
        editButton.setText(WizardMessages.getString("ImageRunSelectionPage.editButton"));
        editButton.setEnabled(false);
        editButton.addSelectionListener(this.onEditLink(linksTableViewer));
        Button removeButton = new Button(buttonsContainers, 0);
        GridDataFactory.fillDefaults().align(4, 128).grab(true, false).applyTo((Control)removeButton);
        removeButton.setText(WizardMessages.getString("ImageRunSelectionPage.remove"));
        removeButton.addSelectionListener(this.onRemoveLinks(linksTableViewer));
        removeButton.setEnabled(false);
        ViewerSupport.bind((StructuredViewer)linksTableViewer, this.model.getLinks(), (IValueProperty[])BeanProperties.values(ImageRunSelectionModel.ContainerLinkModel.class, (String[])new String[]{"containerName", "containerAlias"}));
        linksTableViewer.addSelectionChangedListener(this.onSelectionChanged(editButton, removeButton));
    }

    private ISelectionChangedListener onSelectionChanged(Button ... targetButtons) {
        return e -> {
            if (e.getSelection().isEmpty()) {
                RunImageLinksTab.setControlsEnabled((Control[])targetButtons, false);
            } else {
                RunImageLinksTab.setControlsEnabled((Control[])targetButtons, true);
            }
            this.updateLaunchConfigurationDialog();
        };
    }

    private TableViewer createLinksTable(Composite container) {
        Table table = new Table(container, 68352);
        TableViewer tableViewer = new TableViewer(table);
        table.setHeaderVisible(true);
        table.setLinesVisible(true);
        this.createTableViewerColumn(tableViewer, WizardMessages.getString("ImageRunSelectionPage.containerNameColumn"), 200);
        this.createTableViewerColumn(tableViewer, WizardMessages.getString("ImageRunSelectionPage.aliasColumn"), 150);
        tableViewer.setContentProvider((IContentProvider)new ObservableListContentProvider());
        return tableViewer;
    }

    private SelectionListener onAddLink() {
        return SelectionListener.widgetSelectedAdapter(e -> {
            ContainerLinkDialog dialog = new ContainerLinkDialog(this.getShell(), this.model.getSelectedConnection());
            dialog.create();
            if (dialog.open() == 0) {
                this.model.addLink(dialog.getContainerName(), dialog.getContainerAlias());
            }
            this.updateLaunchConfigurationDialog();
        });
    }

    private SelectionListener onEditLink(TableViewer linksTableViewer) {
        return SelectionListener.widgetSelectedAdapter(e -> {
            IStructuredSelection selection = linksTableViewer.getStructuredSelection();
            ImageRunSelectionModel.ContainerLinkModel selectedContainerLink = (ImageRunSelectionModel.ContainerLinkModel)selection.getFirstElement();
            ContainerLinkDialog dialog = new ContainerLinkDialog(this.getShell(), this.model.getSelectedConnection(), selectedContainerLink);
            dialog.create();
            if (dialog.open() == 0) {
                selectedContainerLink.setContainerName(dialog.getContainerName());
                selectedContainerLink.setContainerAlias(dialog.getContainerAlias());
                linksTableViewer.refresh();
                this.updateLaunchConfigurationDialog();
            }
        });
    }

    private SelectionListener onRemoveLinks(TableViewer linksTableViewer) {
        return SelectionListener.widgetSelectedAdapter(e -> {
            IStructuredSelection selection = linksTableViewer.getStructuredSelection();
            Iterator iterator = selection.iterator();
            while (iterator.hasNext()) {
                this.model.removeLink((ImageRunSelectionModel.ContainerLinkModel)iterator.next());
            }
            this.updateLaunchConfigurationDialog();
        });
    }

    private static void setControlsEnabled(Control[] controls, boolean enabled) {
        Control[] controlArray = controls;
        int n = controls.length;
        int n2 = 0;
        while (n2 < n) {
            Control control = controlArray[n2];
            control.setEnabled(enabled);
            ++n2;
        }
    }

    public Image getImage() {
        return SWTImagesFactory.get("org.eclipse.linuxtools.docker.ui.container_link.png");
    }

    public void setDefaults(ILaunchConfigurationWorkingCopy configuration) {
    }

    public void initializeFrom(ILaunchConfiguration configuration) {
        if (this.model == null) {
            return;
        }
        try {
            this.model.removeLinks();
            List containerLinks = configuration.getAttribute("links", new ArrayList());
            for (String containerLink : containerLinks) {
                this.model.addLink(ImageRunSelectionModel.ContainerLinkModel.createContainerLinkModel(containerLink));
            }
        }
        catch (CoreException coreException) {
            // empty catch block
        }
        this.model.addPropertyChangeListener(new LaunchConfigurationChangeListener());
    }

    public void performApply(ILaunchConfigurationWorkingCopy configuration) {
        if (this.model == null) {
            return;
        }
        ArrayList<String> linksList = new ArrayList<String>();
        for (Object o : this.model.getLinks()) {
            ImageRunSelectionModel.ContainerLinkModel m = (ImageRunSelectionModel.ContainerLinkModel)o;
            linksList.add(m.toString());
        }
        configuration.setAttribute("links", linksList);
    }

    public String getName() {
        return LaunchMessages.getString(TAB_NAME);
    }

    private class LaunchConfigurationChangeListener
    implements PropertyChangeListener {
        private LaunchConfigurationChangeListener() {
        }

        @Override
        public void propertyChange(PropertyChangeEvent evt) {
            RunImageLinksTab.this.updateLaunchConfigurationDialog();
        }
    }
}

