/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.tmf.ui.project.wizards;

import java.lang.reflect.InvocationTargetException;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Status;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.tracecompass.internal.tmf.ui.project.operations.NewExperimentOperation;
import org.eclipse.tracecompass.tmf.ui.project.model.TmfExperimentFolder;
import org.eclipse.tracecompass.tmf.ui.project.model.TraceUtils;
import org.eclipse.tracecompass.tmf.ui.project.wizards.Messages;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.actions.WorkspaceModifyOperation;
import org.eclipse.ui.dialogs.SelectionStatusDialog;

public class NewExperimentDialog
extends SelectionStatusDialog {
    private Text fExperimentName;
    private final IContainer fExperimentFolder;
    private final TmfExperimentFolder fExperimentFolderRoot;

    public NewExperimentDialog(Shell shell, TmfExperimentFolder experimentFolder) {
        super(shell);
        this.fExperimentFolderRoot = experimentFolder;
        this.fExperimentFolder = experimentFolder.getResource();
        this.setTitle(Messages.NewExperimentDialog_DialogTitle);
        this.setStatusLineAboveButtons(true);
    }

    protected Control createDialogArea(Composite parent) {
        Composite composite = (Composite)super.createDialogArea(parent);
        composite.setLayout((Layout)new GridLayout());
        composite.setLayoutData((Object)new GridData(1808));
        this.createExperimentNameGroup(composite);
        return composite;
    }

    private void createExperimentNameGroup(Composite parent) {
        Font font = parent.getFont();
        Composite folderGroup = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        layout.numColumns = 2;
        folderGroup.setLayout((Layout)layout);
        folderGroup.setLayoutData((Object)new GridData(768));
        Label experimentLabel = new Label(folderGroup, 0);
        experimentLabel.setFont(font);
        experimentLabel.setText(Messages.NewExperimentDialog_ExperimentName);
        this.fExperimentName = new Text(folderGroup, 2048);
        GridData data = new GridData(768);
        data.widthHint = 200;
        this.fExperimentName.setLayoutData((Object)data);
        this.fExperimentName.setFont(font);
        this.fExperimentName.addListener(24, new Listener(){

            public void handleEvent(Event event) {
                NewExperimentDialog.this.validateNewExperimentName();
            }
        });
    }

    private void validateNewExperimentName() {
        String name = this.fExperimentName.getText();
        IWorkspace workspace = this.fExperimentFolder.getWorkspace();
        IStatus nameStatus = workspace.validateName(name, 2);
        if ("".equals(name)) {
            this.updateStatus((IStatus)new Status(4, "org.eclipse.tracecompass.tmf.ui", 4, Messages.Dialog_EmptyNameError, null));
            return;
        }
        if (!nameStatus.isOK()) {
            this.updateStatus(nameStatus);
            return;
        }
        Path path = new Path(name);
        if (this.fExperimentFolder.getFolder((IPath)path).exists() || this.fExperimentFolder.getFile((IPath)path).exists()) {
            this.updateStatus((IStatus)new Status(4, "org.eclipse.tracecompass.tmf.ui", 4, Messages.Dialog_ExistingNameError, null));
            return;
        }
        this.updateStatus((IStatus)new Status(0, "org.eclipse.tracecompass.tmf.ui", ""));
    }

    protected void computeResult() {
    }

    public void create() {
        super.create();
        this.getButton(0).setEnabled(false);
    }

    protected void okPressed() {
        String experimentName = this.fExperimentName.getText();
        if (experimentName == null) {
            return;
        }
        IFolder folder = this.createNewExperiment(experimentName);
        if (folder == null) {
            return;
        }
        this.setSelectionResult(new IFolder[]{folder});
        super.okPressed();
    }

    private IFolder createNewExperiment(final @NonNull String experimentName) {
        final IFolder[] experimentFolders = new IFolder[1];
        final TmfExperimentFolder root = this.fExperimentFolderRoot;
        if (root == null) {
            return null;
        }
        WorkspaceModifyOperation operation = new WorkspaceModifyOperation(){

            public void execute(IProgressMonitor monitor) throws InterruptedException, InvocationTargetException {
                NewExperimentOperation createOperation = new NewExperimentOperation(root, experimentName);
                createOperation.run(monitor);
                IStatus status = createOperation.getStatus();
                if (!status.isOK()) {
                    if (status.getSeverity() == 8) {
                        throw new OperationCanceledException();
                    }
                    Throwable exception = status.getException();
                    if (exception != null) {
                        throw new InvocationTargetException(exception);
                    }
                    return;
                }
                experimentFolders[0] = createOperation.getExperimentFolder();
            }
        };
        try {
            PlatformUI.getWorkbench().getProgressService().busyCursorWhile((IRunnableWithProgress)operation);
        }
        catch (InterruptedException | RuntimeException exception) {
            return null;
        }
        catch (InvocationTargetException exception) {
            TraceUtils.displayErrorMsg("", NLS.bind((String)"", (Object)exception.getTargetException().getMessage()));
            return null;
        }
        return experimentFolders[0];
    }
}

