/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ext.postgresql.model.plan;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.jkiss.code.Nullable;
import org.jkiss.dbeaver.ext.postgresql.model.PostgreDataSource;
import org.jkiss.dbeaver.model.exec.plan.DBCPlanCostNode;
import org.jkiss.dbeaver.model.impl.PropertyDescriptor;
import org.jkiss.dbeaver.model.impl.plan.AbstractExecutionPlanNode;
import org.jkiss.dbeaver.model.meta.Property;
import org.jkiss.dbeaver.model.preferences.DBPPropertyDescriptor;
import org.jkiss.dbeaver.model.preferences.DBPPropertySource;
import org.jkiss.dbeaver.model.runtime.DBRProgressMonitor;
import org.jkiss.dbeaver.model.sql.SQLDataSource;
import org.jkiss.dbeaver.model.sql.SQLUtils;
import org.jkiss.utils.CommonUtils;

public abstract class PostgrePlanNodeBase<NODE extends PostgrePlanNodeBase>
extends AbstractExecutionPlanNode
implements DBCPlanCostNode,
DBPPropertySource {
    public static final String ATTR_NODE_TYPE = "Node-Type";
    public static final String ATTR_RELATION_NAME = "Relation-Name";
    public static final String ATTR_FUNCTION_NAME = "Function-Name";
    public static final String ATTR_ALIAS = "Alias";
    public static final String ATTR_TOTAL_COST = "Total-Cost";
    public static final String ATTR_STARTUP_COST = "Startup-Cost";
    public static final String ATTR_INDEX_NAME = "Index-Name";
    public static final String ATTR_ACTUAL_TOTAL_TIME = "Actual-Total-Time";
    public static final String ATTR_ACTUAL_ROWS = "Actual-Rows";
    public static final String ATTR_PLAN_ROWS = "Plan-Rows";
    public static final String ATTR_FILTER = "Filter";
    private PostgreDataSource dataSource;
    protected NODE parent;
    protected final List<NODE> nested = new ArrayList<NODE>();
    protected String nodeType;
    private String entity;
    private String cost;
    protected Map<String, String> attributes = Collections.emptyMap();

    protected PostgrePlanNodeBase(PostgreDataSource dataSource, NODE parent) {
        this.parent = parent;
        this.dataSource = dataSource;
    }

    protected void setAttributes(Map<String, String> attributes) {
        this.attributes = attributes;
        this.nodeType = attributes.remove(ATTR_NODE_TYPE);
        this.entity = attributes.get(ATTR_RELATION_NAME);
        if (this.entity == null) {
            this.entity = attributes.get(ATTR_FUNCTION_NAME);
        }
        if (this.entity == null) {
            this.entity = attributes.get(ATTR_INDEX_NAME);
        }
        String startCost = attributes.get(ATTR_STARTUP_COST);
        String totalCost = attributes.get(ATTR_TOTAL_COST);
        this.cost = String.valueOf(startCost) + " - " + totalCost;
    }

    public String getNodeName() {
        return this.entity;
    }

    @Property(order=0, viewable=true)
    public String getNodeType() {
        return this.nodeType;
    }

    public String getNodeDescription() {
        return this.attributes.get(ATTR_FILTER);
    }

    @Property(order=2, viewable=true)
    public String getEntity() {
        return this.entity;
    }

    @Property(order=3, viewable=true)
    public String getCost() {
        return this.cost;
    }

    @Property(order=21, viewable=true)
    public String getActualRows() {
        String rows = this.attributes.get(ATTR_ACTUAL_ROWS);
        if (rows == null) {
            rows = this.attributes.get(ATTR_PLAN_ROWS);
        }
        return rows;
    }

    @Property(order=22, viewable=true)
    public String getTotalTime() {
        return this.attributes.get(ATTR_ACTUAL_TOTAL_TIME);
    }

    @Property(order=23, viewable=true)
    public String getNodeCondition() {
        String cond = this.attributes.get("Index-Cond");
        if (cond == null) {
            cond = this.attributes.get("Hash-Cond");
        }
        if (cond == null) {
            cond = this.attributes.get(ATTR_FILTER);
        }
        if (!CommonUtils.isEmpty((String)cond)) {
            cond = SQLUtils.formatSQL((SQLDataSource)this.dataSource, (String)cond);
        }
        return cond;
    }

    public NODE getParent() {
        return this.parent;
    }

    public List<NODE> getNested() {
        return this.nested;
    }

    public Number getNodeCost() {
        String totalCost = this.attributes.get(ATTR_TOTAL_COST);
        return totalCost == null ? null : Double.valueOf(CommonUtils.toDouble((Object)totalCost));
    }

    public Number getNodePercent() {
        return null;
    }

    public Number getNodeDuration() {
        String time = this.attributes.get(ATTR_ACTUAL_TOTAL_TIME);
        return time == null ? null : Double.valueOf(CommonUtils.toDouble((Object)time));
    }

    public Number getNodeRowCount() {
        String rows = this.attributes.get(ATTR_ACTUAL_ROWS);
        return rows == null ? null : Long.valueOf(CommonUtils.toLong((Object)rows));
    }

    public String toString() {
        StringBuilder title = new StringBuilder();
        title.append("Type: ").append(this.nodeType);
        String joinType = this.attributes.get("Join-Type");
        if (!CommonUtils.isEmpty((String)joinType)) {
            title.append(" (").append(joinType).append(")");
        }
        title.append("; ");
        if (!CommonUtils.isEmpty((String)this.entity)) {
            title.append("Rel: ").append(this.entity).append(" ");
        }
        title.append("; Cost: ").append(this.cost);
        return title.toString();
    }

    public Object getEditableValue() {
        return this;
    }

    public DBPPropertyDescriptor[] getPropertyDescriptors2() {
        DBPPropertyDescriptor[] props = new DBPPropertyDescriptor[this.attributes.size()];
        int index = 0;
        for (Map.Entry<String, String> attr : this.attributes.entrySet()) {
            props[index++] = new PropertyDescriptor("Details", (Object)attr.getKey(), attr.getKey(), null, String.class, false, null, null, false);
        }
        return props;
    }

    public Object getPropertyValue(@Nullable DBRProgressMonitor monitor, Object id) {
        return this.attributes.get(id.toString());
    }

    public boolean isPropertySet(Object id) {
        return false;
    }

    public boolean isPropertyResettable(Object id) {
        return false;
    }

    public void resetPropertyValue(@Nullable DBRProgressMonitor monitor, Object id) {
    }

    public void resetPropertyValueToDefault(Object id) {
    }

    public void setPropertyValue(@Nullable DBRProgressMonitor monitor, Object id, Object value) {
    }

    public boolean isDirty(Object id) {
        return false;
    }
}

