/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.tools.transfer.wizard;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.jface.dialogs.DialogSettings;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.jface.operation.IRunnableContext;
import org.eclipse.jface.wizard.IWizardPage;
import org.jkiss.code.Nullable;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.Log;
import org.jkiss.dbeaver.model.runtime.DBRProgressMonitor;
import org.jkiss.dbeaver.model.struct.DBSObject;
import org.jkiss.dbeaver.runtime.DBWorkbench;
import org.jkiss.dbeaver.tools.transfer.IDataTransferConsumer;
import org.jkiss.dbeaver.tools.transfer.IDataTransferNode;
import org.jkiss.dbeaver.tools.transfer.IDataTransferProducer;
import org.jkiss.dbeaver.tools.transfer.IDataTransferSettings;
import org.jkiss.dbeaver.tools.transfer.registry.DataTransferNodeDescriptor;
import org.jkiss.dbeaver.tools.transfer.registry.DataTransferPageDescriptor;
import org.jkiss.dbeaver.tools.transfer.registry.DataTransferPageType;
import org.jkiss.dbeaver.tools.transfer.registry.DataTransferProcessorDescriptor;
import org.jkiss.dbeaver.tools.transfer.registry.DataTransferRegistry;
import org.jkiss.dbeaver.tools.transfer.wizard.DataTransferPageSettings;
import org.jkiss.dbeaver.tools.transfer.wizard.DataTransferPipe;
import org.jkiss.dbeaver.tools.transfer.wizard.DataTransferWizard;
import org.jkiss.utils.ArrayUtils;
import org.jkiss.utils.CommonUtils;

public class DataTransferSettings {
    private static final Log log = Log.getLog(DataTransferSettings.class);
    private static final int DEFAULT_THREADS_NUM = 1;
    private List<DataTransferPipe> dataPipes;
    private DataTransferNodeDescriptor producer;
    private DataTransferNodeDescriptor consumer;
    private DataTransferProcessorDescriptor processor;
    private Map<DataTransferProcessorDescriptor, Map<Object, Object>> processorPropsHistory = new HashMap<DataTransferProcessorDescriptor, Map<Object, Object>>();
    private boolean producerProcessor;
    private Map<Class, NodeSettings> nodeSettings = new LinkedHashMap<Class, NodeSettings>();
    private List<DBSObject> initObjects = new ArrayList<DBSObject>();
    private boolean consumerOptional;
    private boolean producerOptional;
    private int maxJobCount = 1;
    private transient int curPipeNum = 0;
    private boolean showFinalMessage = true;

    public DataTransferSettings(@Nullable IDataTransferProducer[] producers, @Nullable IDataTransferConsumer[] consumers) {
        DataTransferNodeDescriptor node;
        int n;
        int n2;
        IDataTransferNode<SETTINGS>[] iDataTransferNodeArray;
        int n3;
        IDataTransferNode<SETTINGS>[] iDataTransferNodeArray2;
        this.dataPipes = new ArrayList<DataTransferPipe>();
        if (!ArrayUtils.isEmpty((Object[])producers) && !ArrayUtils.isEmpty((Object[])consumers)) {
            if (producers.length != consumers.length) {
                throw new IllegalArgumentException("Producers number must match consumers number");
            }
            int i = 0;
            while (i < producers.length) {
                if (producers[i].getDatabaseObject() != null) {
                    this.initObjects.add(producers[i].getDatabaseObject());
                }
                this.dataPipes.add(new DataTransferPipe(producers[i], consumers[i]));
                ++i;
            }
            this.consumerOptional = false;
        } else if (!ArrayUtils.isEmpty((Object[])producers)) {
            iDataTransferNodeArray2 = producers;
            n3 = producers.length;
            int n4 = 0;
            while (n4 < n3) {
                IDataTransferNode source = iDataTransferNodeArray2[n4];
                if (source.getDatabaseObject() != null) {
                    this.initObjects.add(source.getDatabaseObject());
                }
                this.dataPipes.add(new DataTransferPipe((IDataTransferProducer)source, null));
                ++n4;
            }
            Class<?> producerType = this.dataPipes.get(0).getProducer().getClass();
            DataTransferNodeDescriptor producerDesc = DataTransferRegistry.getInstance().getNodeByType(producerType);
            if (producerDesc != null) {
                this.selectProducer(producerDesc);
                this.consumerOptional = true;
            } else {
                DBWorkbench.getPlatformUI().showError("Can't find producer", "Can't find data propducer descriptor in registry");
            }
        } else if (!ArrayUtils.isEmpty((Object[])consumers)) {
            iDataTransferNodeArray2 = consumers;
            n3 = consumers.length;
            int producerDesc = 0;
            while (producerDesc < n3) {
                IDataTransferNode target = iDataTransferNodeArray2[producerDesc];
                if (target.getDatabaseObject() != null) {
                    this.initObjects.add(target.getDatabaseObject());
                }
                this.dataPipes.add(new DataTransferPipe(null, (IDataTransferConsumer)target));
                ++producerDesc;
            }
            Class<?> consumerType = this.dataPipes.get(0).getConsumer().getClass();
            DataTransferNodeDescriptor consumerDesc = DataTransferRegistry.getInstance().getNodeByType(consumerType);
            if (consumerDesc != null) {
                this.selectConsumer(consumerDesc, null, false);
                this.consumerOptional = false;
            } else {
                DBWorkbench.getPlatformUI().showError("Can't find producer", "Can't find data propducer descriptor in registry");
            }
            this.producerOptional = true;
        } else {
            throw new IllegalArgumentException("Producers or consumers must be specified");
        }
        List<DBSObject> objectTypes = this.getSourceObjects();
        ArrayList<DataTransferNodeDescriptor> nodes = new ArrayList<DataTransferNodeDescriptor>();
        DataTransferRegistry registry = DataTransferRegistry.getInstance();
        if (ArrayUtils.isEmpty((Object[])producers)) {
            nodes.addAll(registry.getAvailableProducers(objectTypes));
        } else {
            iDataTransferNodeArray = producers;
            n2 = producers.length;
            n = 0;
            while (n < n2) {
                IDataTransferProducer source = iDataTransferNodeArray[n];
                node = registry.getNodeByType(source.getClass());
                if (node != null && !nodes.contains((Object)node)) {
                    nodes.add(node);
                }
                ++n;
            }
        }
        if (ArrayUtils.isEmpty((Object[])consumers)) {
            nodes.addAll(registry.getAvailableConsumers(objectTypes));
        } else {
            iDataTransferNodeArray = consumers;
            n2 = consumers.length;
            n = 0;
            while (n < n2) {
                IDataTransferNode target = iDataTransferNodeArray[n];
                node = registry.getNodeByType(target.getClass());
                if (node != null && !nodes.contains((Object)node)) {
                    nodes.add(node);
                    this.consumer = node;
                }
                ++n;
            }
        }
        for (DataTransferNodeDescriptor node2 : nodes) {
            this.addNodeSettings(node2);
        }
    }

    private void addNodeSettings(DataTransferNodeDescriptor node) {
        if (node == null) {
            return;
        }
        Class<? extends IDataTransferNode> nodeClass = node.getNodeClass();
        if (this.nodeSettings.containsKey(nodeClass)) {
            return;
        }
        try {
            this.nodeSettings.put(nodeClass, new NodeSettings(node, this.consumerOptional, this.producerOptional));
        }
        catch (DBException e) {
            log.error((Object)("Can't add node '" + node.getId() + "'"), (Throwable)e);
        }
    }

    void addWizardPages(DataTransferWizard wizard) {
        IWizardPage page;
        int n;
        int n2;
        IWizardPage[] iWizardPageArray;
        ArrayList<IWizardPage> settingPages = new ArrayList<IWizardPage>();
        for (NodeSettings nodeSettings : this.nodeSettings.values()) {
            iWizardPageArray = nodeSettings.pages;
            n2 = nodeSettings.pages.length;
            n = 0;
            while (n < n2) {
                page = iWizardPageArray[n];
                if (nodeSettings.sourceNode.getPageDescriptor(page).getPageType() != DataTransferPageType.PREVIEW) {
                    wizard.addPage(page);
                }
                ++n;
            }
            if (nodeSettings.settingsPage == null) continue;
            settingPages.add(nodeSettings.settingsPage);
        }
        if (!CommonUtils.isEmpty(settingPages)) {
            wizard.addPage((IWizardPage)new DataTransferPageSettings());
        }
        for (NodeSettings nodeSettings : this.nodeSettings.values()) {
            iWizardPageArray = nodeSettings.pages;
            n2 = nodeSettings.pages.length;
            n = 0;
            while (n < n2) {
                page = iWizardPageArray[n];
                if (nodeSettings.sourceNode.getPageDescriptor(page).getPageType() == DataTransferPageType.PREVIEW) {
                    wizard.addPage(page);
                }
                ++n;
            }
        }
    }

    public boolean isConsumerOptional() {
        return this.consumerOptional;
    }

    public boolean isProducerOptional() {
        return this.producerOptional;
    }

    public boolean isPageValid(IWizardPage page) {
        return page instanceof DataTransferPageSettings || this.isPageValid(page, this.producer) || this.isPageValid(page, this.consumer);
    }

    private boolean isPageValid(IWizardPage page, DataTransferNodeDescriptor node) {
        NodeSettings nodeSettings;
        NodeSettings nodeSettings2 = nodeSettings = node == null ? null : this.nodeSettings.get(node.getNodeClass());
        if (nodeSettings != null && ArrayUtils.contains((Object[])nodeSettings.pages, (Object)page)) {
            for (NodeSettings ns : this.nodeSettings.values()) {
                DataTransferPageDescriptor pd = ns.sourceNode.getPageDescriptor(page);
                if (pd == null) continue;
                if (pd.getProducerType() != null && this.producer != null && !this.producer.getId().equals(pd.getProducerType())) {
                    return false;
                }
                if (pd.getConsumerType() == null || this.consumer == null || this.consumer.getId().equals(pd.getConsumerType())) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    public List<DBSObject> getSourceObjects() {
        return this.initObjects;
    }

    NodeSettings getNodeInfo(IDataTransferNode node) {
        return this.nodeSettings.get(node.getClass());
    }

    public IDataTransferSettings getNodeSettings(IWizardPage page) {
        for (NodeSettings nodeSettings : this.nodeSettings.values()) {
            if (page == nodeSettings.settingsPage) {
                return nodeSettings.settings;
            }
            if (nodeSettings.pages == null) continue;
            IWizardPage[] iWizardPageArray = nodeSettings.pages;
            int n = nodeSettings.pages.length;
            int n2 = 0;
            while (n2 < n) {
                IWizardPage nodePage = iWizardPageArray[n2];
                if (nodePage == page) {
                    return nodeSettings.settings;
                }
                ++n2;
            }
        }
        return null;
    }

    public IDataTransferSettings getNodeSettings(IDataTransferNode node) {
        NodeSettings nodeSettings = this.nodeSettings.get(node.getClass());
        return nodeSettings == null ? null : nodeSettings.settings;
    }

    public Map<Object, Object> getProcessorProperties() {
        if (this.processor == null) {
            throw new IllegalStateException("No processor selected");
        }
        return this.processorPropsHistory.get((Object)this.processor);
    }

    public void setProcessorProperties(Map<Object, Object> properties) {
        if (this.processor == null) {
            throw new IllegalStateException("No processor selected");
        }
        this.processorPropsHistory.put(this.processor, properties);
    }

    public List<DataTransferPipe> getDataPipes() {
        return this.dataPipes;
    }

    public synchronized DataTransferPipe acquireDataPipe(DBRProgressMonitor monitor) {
        if (this.curPipeNum >= this.dataPipes.size()) {
            if (!this.dataPipes.isEmpty()) {
                this.dataPipes.get(this.dataPipes.size() - 1).getConsumer().finishTransfer(monitor, true);
            }
            return null;
        }
        DataTransferPipe result = this.dataPipes.get(this.curPipeNum);
        ++this.curPipeNum;
        return result;
    }

    public DataTransferNodeDescriptor getProducer() {
        return this.producer;
    }

    public DataTransferNodeDescriptor getConsumer() {
        return this.consumer;
    }

    public DataTransferProcessorDescriptor getProcessor() {
        return this.processor;
    }

    public boolean isProducerProcessor() {
        return this.producerProcessor;
    }

    private void selectProducer(DataTransferNodeDescriptor producer) {
        this.producer = producer;
    }

    void selectConsumer(DataTransferNodeDescriptor consumer, DataTransferProcessorDescriptor processor, boolean rewrite) {
        this.consumer = consumer;
        this.processor = processor;
        this.producerProcessor = false;
        if (consumer != null && processor != null && !this.processorPropsHistory.containsKey((Object)processor)) {
            this.processorPropsHistory.put(processor, new HashMap());
        }
        int i = 0;
        while (i < this.dataPipes.size()) {
            DataTransferPipe pipe = this.dataPipes.get(i);
            if (rewrite || pipe.getConsumer() == null) {
                if (consumer != null) {
                    try {
                        IDataTransferConsumer consumerNode = (IDataTransferConsumer)consumer.createNode();
                        if (pipe.getProducer() != null) {
                            IDataTransferConsumer.TransferParameters parameters = new IDataTransferConsumer.TransferParameters(processor != null && processor.isBinaryFormat());
                            parameters.orderNumber = i;
                            parameters.totalConsumers = this.dataPipes.size();
                            consumerNode.initTransfer(pipe.getProducer().getDatabaseObject(), this.getNodeSettings(consumerNode), parameters, processor != null ? processor.getInstance() : null, processor != null ? this.getProcessorProperties() : null);
                        }
                        pipe.setConsumer(consumerNode);
                    }
                    catch (DBException e) {
                        log.error((Object)e);
                        pipe.setConsumer(null);
                    }
                } else {
                    pipe.setConsumer(null);
                }
            }
            ++i;
        }
    }

    void selectProducer(DataTransferNodeDescriptor producer, DataTransferProcessorDescriptor processor, boolean rewrite) {
        this.producer = producer;
        this.processor = processor;
        if (producer != null && processor != null) {
            this.producerProcessor = true;
            if (!this.processorPropsHistory.containsKey((Object)processor)) {
                this.processorPropsHistory.put(processor, new HashMap());
            }
        }
        for (DataTransferPipe pipe : this.dataPipes) {
            if (!rewrite && pipe.getProducer() != null) continue;
            if (producer != null) {
                try {
                    pipe.setProducer((IDataTransferProducer)producer.createNode());
                }
                catch (DBException e) {
                    log.error((Object)e);
                    pipe.setProducer(null);
                }
                continue;
            }
            pipe.setProducer(null);
        }
    }

    public int getMaxJobCount() {
        return this.maxJobCount;
    }

    public void setMaxJobCount(int maxJobCount) {
        if (maxJobCount > 0) {
            this.maxJobCount = maxJobCount;
        }
    }

    public boolean isShowFinalMessage() {
        return this.showFinalMessage;
    }

    public void setShowFinalMessage(boolean showFinalMessage) {
        this.showFinalMessage = showFinalMessage;
    }

    void loadFrom(IRunnableContext runnableContext, IDialogSettings dialogSettings) {
        try {
            this.maxJobCount = dialogSettings.getInt("maxJobCount");
        }
        catch (NumberFormatException numberFormatException) {
            this.maxJobCount = 1;
        }
        if (dialogSettings.get("showFinalMessage") != null) {
            this.showFinalMessage = dialogSettings.getBoolean("showFinalMessage");
        }
        if (this.consumerOptional || this.producerOptional) {
            String processorId;
            DataTransferNodeDescriptor producerNode;
            String producerId;
            DataTransferNodeDescriptor consumerNode;
            String consumerId;
            DataTransferNodeDescriptor savedConsumer = null;
            Object savedProducer = null;
            DataTransferNodeDescriptor savedNode = null;
            if (this.consumerOptional && !CommonUtils.isEmpty((String)(consumerId = dialogSettings.get("consumer"))) && (consumerNode = DataTransferRegistry.getInstance().getNodeById(consumerId)) != null) {
                savedConsumer = this.consumer = consumerNode;
                savedNode = this.consumer;
            }
            if (this.producerOptional && !CommonUtils.isEmpty((String)(producerId = dialogSettings.get("producer"))) && (producerNode = DataTransferRegistry.getInstance().getNodeById(producerId)) != null) {
                this.producer = producerNode;
                savedProducer = this.producer;
                savedNode = this.producer;
            }
            DataTransferProcessorDescriptor savedProcessor = null;
            if (savedNode != null && !CommonUtils.isEmpty((String)(processorId = dialogSettings.get("processor")))) {
                savedProcessor = savedNode.getProcessor(processorId);
            }
            if (savedConsumer != null) {
                this.selectConsumer(savedConsumer, savedProcessor, false);
            }
            if (savedProducer != null) {
                this.selectProducer((DataTransferNodeDescriptor)((Object)savedProducer), savedProcessor, false);
            }
        }
        for (Map.Entry<Class, NodeSettings> entry : this.nodeSettings.entrySet()) {
            IDialogSettings nodeSection = DialogSettings.getOrCreateSection((IDialogSettings)dialogSettings, (String)entry.getKey().getSimpleName());
            entry.getValue().settings.loadSettings(runnableContext, this, nodeSection);
        }
        IDialogSettings processorsSection = dialogSettings.getSection("processors");
        if (processorsSection != null) {
            for (IDialogSettings procSection : ArrayUtils.safeArray((Object[])processorsSection.getSections())) {
                int divPos;
                String processorId = procSection.getName();
                String nodeId = procSection.get("@node");
                if (CommonUtils.isEmpty((String)nodeId) && (divPos = processorId.indexOf(58)) != -1) {
                    nodeId = processorId.substring(0, divPos);
                    processorId = processorId.substring(divPos + 1);
                }
                String propNamesId = procSection.get("@propNames");
                DataTransferNodeDescriptor node = DataTransferRegistry.getInstance().getNodeById(nodeId);
                if (node == null) continue;
                HashMap<String, String> props = new HashMap<String, String>();
                DataTransferProcessorDescriptor nodeProcessor = node.getProcessor(processorId);
                if (nodeProcessor == null) continue;
                for (String prop : CommonUtils.splitString((String)propNamesId, (char)',')) {
                    props.put(prop, procSection.get(prop));
                }
                this.processorPropsHistory.put(nodeProcessor, props);
                NodeSettings nodeSettings = this.nodeSettings.get(node.getNodeClass());
            }
        }
    }

    void saveTo(IDialogSettings dialogSettings) {
        dialogSettings.put("maxJobCount", this.maxJobCount);
        dialogSettings.put("showFinalMessage", this.showFinalMessage);
        for (Map.Entry<Class, NodeSettings> entry : this.nodeSettings.entrySet()) {
            IDialogSettings nodeSection = DialogSettings.getOrCreateSection((IDialogSettings)dialogSettings, (String)entry.getKey().getSimpleName());
            entry.getValue().settings.saveSettings(nodeSection);
        }
        if (this.producer != null) {
            dialogSettings.put("producer", this.producer.getId());
        }
        if (this.consumer != null) {
            dialogSettings.put("consumer", this.consumer.getId());
        }
        if (this.processor != null) {
            dialogSettings.put("processor", this.processor.getId());
        }
        IDialogSettings processorsSection = dialogSettings.addNewSection("processors");
        for (DataTransferProcessorDescriptor procDescriptor : this.processorPropsHistory.keySet()) {
            IDialogSettings procSettings = processorsSection.addNewSection(procDescriptor.getFullId());
            Map<Object, Object> props = this.processorPropsHistory.get((Object)procDescriptor);
            if (CommonUtils.isEmpty(props)) continue;
            StringBuilder propNames = new StringBuilder();
            for (Map.Entry<Object, Object> prop : props.entrySet()) {
                propNames.append(prop.getKey()).append(',');
            }
            procSettings.put("@propNames", propNames.toString());
            for (Map.Entry<Object, Object> prop : props.entrySet()) {
                procSettings.put(CommonUtils.toString((Object)prop.getKey()), CommonUtils.toString((Object)prop.getValue()));
            }
        }
    }

    public static class NodeSettings {
        DataTransferNodeDescriptor sourceNode;
        IDataTransferSettings settings;
        IWizardPage[] pages;
        IWizardPage settingsPage;

        private NodeSettings(DataTransferNodeDescriptor sourceNode, boolean consumerOptional, boolean producerOptional) throws DBException {
            this.sourceNode = sourceNode;
            this.settings = sourceNode.createSettings();
            this.pages = sourceNode.createWizardPages(consumerOptional, producerOptional, false);
            IWizardPage[] sPages = sourceNode.createWizardPages(consumerOptional, producerOptional, true);
            this.settingsPage = sPages.length == 0 ? null : sPages[0];
        }
    }
}

