/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ext.exasol.model;

import java.sql.ResultSet;
import java.sql.Timestamp;
import java.util.Collection;
import java.util.Map;
import org.jkiss.code.NotNull;
import org.jkiss.code.Nullable;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.ext.exasol.editors.ExasolSourceObject;
import org.jkiss.dbeaver.ext.exasol.model.ExasolDataSource;
import org.jkiss.dbeaver.ext.exasol.model.ExasolSchema;
import org.jkiss.dbeaver.model.DBPDataSource;
import org.jkiss.dbeaver.model.DBPEvaluationContext;
import org.jkiss.dbeaver.model.DBPNamedObject;
import org.jkiss.dbeaver.model.DBPRefreshableObject;
import org.jkiss.dbeaver.model.DBUtils;
import org.jkiss.dbeaver.model.impl.jdbc.JDBCUtils;
import org.jkiss.dbeaver.model.impl.struct.AbstractProcedure;
import org.jkiss.dbeaver.model.meta.Property;
import org.jkiss.dbeaver.model.runtime.DBRProgressMonitor;
import org.jkiss.dbeaver.model.struct.DBSObject;
import org.jkiss.dbeaver.model.struct.DBSObjectContainer;
import org.jkiss.dbeaver.model.struct.rdb.DBSProcedure;
import org.jkiss.dbeaver.model.struct.rdb.DBSProcedureParameter;
import org.jkiss.dbeaver.model.struct.rdb.DBSProcedureType;

public class ExasolFunction
extends AbstractProcedure<ExasolDataSource, ExasolSchema>
implements DBSProcedure,
DBPRefreshableObject,
ExasolSourceObject {
    private String remarks;
    private String owner;
    private String sql;
    private ExasolSchema exasolSchema;
    private Timestamp createTime;

    public ExasolFunction(ExasolSchema schema, ResultSet dbResult) {
        super((DBSObjectContainer)schema, true);
        this.owner = JDBCUtils.safeGetString((ResultSet)dbResult, (String)"FUNCTION_OWNER");
        this.remarks = JDBCUtils.safeGetString((ResultSet)dbResult, (String)"FUNCTION_COMMENT");
        this.name = JDBCUtils.safeGetString((ResultSet)dbResult, (String)"FUNCTION_NAME");
        this.sql = JDBCUtils.safeGetString((ResultSet)dbResult, (String)"FUNCTION_TEXT");
        this.createTime = JDBCUtils.safeGetTimestamp((ResultSet)dbResult, (String)"CREATED");
        this.exasolSchema = schema;
    }

    public ExasolFunction(ExasolSchema schema) {
        super((DBSObjectContainer)schema, false);
        this.exasolSchema = schema;
        this.sql = "";
    }

    public DBSObject refreshObject(DBRProgressMonitor monitor) throws DBException {
        ((ExasolSchema)this.getContainer()).functionCache.clearCache();
        ((ExasolSchema)this.getContainer()).functionCache.getAllObjects(monitor, (DBSObject)this.exasolSchema);
        return ((ExasolSchema)this.getContainer()).functionCache.getObject(monitor, (DBSObject)this.exasolSchema, this.getName());
    }

    public DBSProcedureType getProcedureType() {
        return DBSProcedureType.FUNCTION;
    }

    public Collection<? extends DBSProcedureParameter> getParameters(DBRProgressMonitor monitor) throws DBException {
        return null;
    }

    public String getFullyQualifiedName(DBPEvaluationContext context) {
        return DBUtils.getFullQualifiedName((DBPDataSource)this.getDataSource(), (DBPNamedObject[])new DBPNamedObject[]{this.getContainer(), this});
    }

    @Property(hidden=true, editable=true, updatable=true, order=-1)
    public String getObjectDefinitionText(DBRProgressMonitor monitor, Map<String, Object> options) throws DBException {
        return this.sql;
    }

    @Override
    public void setObjectDefinitionText(String sourceText) throws DBException {
        this.sql = sourceText;
    }

    @Property(viewable=true, order=1)
    @NotNull
    public String getName() {
        return this.name;
    }

    @Property(viewable=true, order=2)
    public ExasolSchema getSchema() {
        return this.exasolSchema;
    }

    @Property(viewable=true, editable=true, updatable=true, multiline=true, order=11)
    @Nullable
    public String getDescription() {
        return this.remarks;
    }

    public void setDescription(String description) {
        this.remarks = description;
    }

    @Property(hidden=true, editable=true, updatable=true)
    @NotNull
    public String getSql() {
        return this.sql;
    }

    @Property(viewable=true, order=6)
    @NotNull
    public Timestamp getCreationTime() {
        return this.createTime;
    }

    @Property(viewable=false, category="Owner")
    public String getOwner() {
        return this.owner;
    }
}

