/*
 * Decompiled with CFR 0.152.
 */
package proguard;

import java.io.File;
import proguard.ClassPath;
import proguard.ClassPathEntry;
import proguard.Configuration;

public class UpToDateChecker {
    private final Configuration configuration;

    public UpToDateChecker(Configuration configuration) {
        this.configuration = configuration;
    }

    public boolean check() {
        try {
            ClassPathEntry classPathEntry;
            int n;
            ModificationTimeChecker modificationTimeChecker = new ModificationTimeChecker();
            modificationTimeChecker.updateInputModificationTime(this.configuration.lastModified);
            ClassPath classPath = this.configuration.programJars;
            ClassPath classPath2 = this.configuration.libraryJars;
            if (classPath != null) {
                for (n = 0; n < classPath.size(); ++n) {
                    classPathEntry = classPath.get(n);
                    modificationTimeChecker.updateModificationTime(classPathEntry.getFile(), classPathEntry.isOutput());
                }
            }
            if (classPath2 != null) {
                for (n = 0; n < classPath2.size(); ++n) {
                    classPathEntry = classPath2.get(n);
                    modificationTimeChecker.updateModificationTime(classPathEntry.getFile(), false);
                }
            }
            modificationTimeChecker.updateInputModificationTime(this.configuration.applyMapping);
            modificationTimeChecker.updateInputModificationTime(this.configuration.obfuscationDictionary);
            modificationTimeChecker.updateInputModificationTime(this.configuration.classObfuscationDictionary);
            modificationTimeChecker.updateInputModificationTime(this.configuration.packageObfuscationDictionary);
            modificationTimeChecker.updateOutputModificationTime(this.configuration.printSeeds);
            modificationTimeChecker.updateOutputModificationTime(this.configuration.printUsage);
            modificationTimeChecker.updateOutputModificationTime(this.configuration.printMapping);
            modificationTimeChecker.updateOutputModificationTime(this.configuration.printConfiguration);
            modificationTimeChecker.updateOutputModificationTime(this.configuration.dump);
        }
        catch (IllegalStateException illegalStateException) {
            return false;
        }
        System.out.println("The output seems up to date");
        return true;
    }

    private static class ModificationTimeChecker {
        private long inputModificationTime = Long.MIN_VALUE;
        private long outputModificationTime = Long.MAX_VALUE;

        private ModificationTimeChecker() {
        }

        public void updateInputModificationTime(File file) {
            if (file != null) {
                this.updateModificationTime(file, false);
            }
        }

        public void updateOutputModificationTime(File file) {
            if (file != null && file.getName().length() > 0) {
                this.updateModificationTime(file, true);
            }
        }

        public void updateModificationTime(File file, boolean bl) {
            if (file.isDirectory()) {
                File[] fileArray = file.listFiles();
                if (fileArray.length == 0 && bl) {
                    this.updateOutputModificationTime(Long.MIN_VALUE);
                }
                for (int i = 0; i < fileArray.length; ++i) {
                    this.updateModificationTime(fileArray[i], bl);
                }
            } else {
                this.updateModificationTime(file.lastModified(), bl);
            }
        }

        public void updateModificationTime(long l, boolean bl) {
            if (bl) {
                this.updateOutputModificationTime(l);
            } else {
                this.updateInputModificationTime(l);
            }
        }

        public void updateInputModificationTime(long l) {
            if (this.inputModificationTime < l) {
                this.inputModificationTime = l;
                this.checkModificationTimes();
            }
        }

        public void updateOutputModificationTime(long l) {
            if (this.outputModificationTime > l) {
                this.outputModificationTime = l;
                this.checkModificationTimes();
            }
        }

        private void checkModificationTimes() {
            if (this.inputModificationTime > this.outputModificationTime) {
                throw new IllegalStateException("The output is outdated");
            }
        }
    }
}

