/*
 * Decompiled with CFR 0.152.
 */
package com.google.auto.value.extension.memoized.processor;

import autovalue.shaded.com.google$.auto.common.$GeneratedAnnotationSpecs;
import autovalue.shaded.com.google$.auto.common.$MoreElements;
import autovalue.shaded.com.google$.common.base.$Joiner;
import autovalue.shaded.com.google$.common.base.$Predicates;
import autovalue.shaded.com.google$.common.collect.$ImmutableList;
import autovalue.shaded.com.google$.common.collect.$ImmutableSet;
import autovalue.shaded.com.google$.common.collect.$Iterables;
import autovalue.shaded.com.squareup.javapoet$.$AnnotationSpec;
import autovalue.shaded.com.squareup.javapoet$.$ClassName;
import autovalue.shaded.com.squareup.javapoet$.$CodeBlock;
import autovalue.shaded.com.squareup.javapoet$.$FieldSpec;
import autovalue.shaded.com.squareup.javapoet$.$JavaFile;
import autovalue.shaded.com.squareup.javapoet$.$MethodSpec;
import autovalue.shaded.com.squareup.javapoet$.$ParameterizedTypeName;
import autovalue.shaded.com.squareup.javapoet$.$TypeName;
import autovalue.shaded.com.squareup.javapoet$.$TypeSpec;
import autovalue.shaded.com.squareup.javapoet$.$TypeVariableName;
import com.google.auto.value.extension.AutoValueExtension;
import com.google.auto.value.extension.memoized.processor.MemoizedValidator;
import java.util.ArrayList;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import javax.annotation.processing.Messager;
import javax.annotation.processing.ProcessingEnvironment;
import javax.lang.model.SourceVersion;
import javax.lang.model.element.AnnotationMirror;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.Modifier;
import javax.lang.model.element.TypeElement;
import javax.lang.model.element.TypeParameterElement;
import javax.lang.model.type.TypeKind;
import javax.lang.model.util.ElementFilter;
import javax.lang.model.util.Elements;
import javax.tools.Diagnostic;

public final class MemoizeExtension
extends AutoValueExtension {
    private static final $ImmutableSet<String> DO_NOT_PULL_DOWN_ANNOTATIONS = $ImmutableSet.of(Override.class.getCanonicalName(), "com.google.auto.value.extension.memoized.Memoized");
    private static final $ClassName LAZY_INIT = $ClassName.get("autovalue.shaded.com.google$.errorprone.annotations.$concurrent", "LazyInit", new String[0]);
    private static final $AnnotationSpec SUPPRESS_WARNINGS = $AnnotationSpec.builder(SuppressWarnings.class).addMember("value", "$S", "Immutable").build();

    @Override
    public AutoValueExtension.IncrementalExtensionType incrementalType(ProcessingEnvironment processingEnvironment) {
        return AutoValueExtension.IncrementalExtensionType.ISOLATING;
    }

    @Override
    public boolean applicable(AutoValueExtension.Context context) {
        return !MemoizeExtension.memoizedMethods(context).isEmpty();
    }

    @Override
    public String generateClass(AutoValueExtension.Context context, String className, String classToExtend, boolean isFinal) {
        return new Generator(context, className, classToExtend, isFinal).generate();
    }

    private static $ImmutableSet<ExecutableElement> memoizedMethods(AutoValueExtension.Context context) {
        $ImmutableSet.Builder memoizedMethods = $ImmutableSet.builder();
        for (ExecutableElement method : ElementFilter.methodsIn(context.autoValueClass().getEnclosedElements())) {
            if (!MemoizedValidator.getAnnotationMirror(method, "com.google.auto.value.extension.memoized.Memoized").isPresent()) continue;
            memoizedMethods.add(method);
        }
        return memoizedMethods.build();
    }

    private static Optional<$AnnotationSpec> getLazyInitAnnotation(Elements elements) {
        if (elements.getTypeElement(LAZY_INIT.toString()) == null) {
            return Optional.empty();
        }
        return Optional.of($AnnotationSpec.builder(LAZY_INIT).build());
    }

    static final class Generator {
        private final AutoValueExtension.Context context;
        private final String className;
        private final String classToExtend;
        private final boolean isFinal;
        private final Elements elements;
        private final SourceVersion sourceVersion;
        private final Messager messager;
        private final Optional<$AnnotationSpec> lazyInitAnnotation;
        private boolean hasErrors;

        Generator(AutoValueExtension.Context context, String className, String classToExtend, boolean isFinal) {
            this.context = context;
            this.className = className;
            this.classToExtend = classToExtend;
            this.isFinal = isFinal;
            this.elements = context.processingEnvironment().getElementUtils();
            this.sourceVersion = context.processingEnvironment().getSourceVersion();
            this.messager = context.processingEnvironment().getMessager();
            this.lazyInitAnnotation = MemoizeExtension.getLazyInitAnnotation(this.elements);
        }

        String generate() {
            $TypeSpec.Builder generated = $TypeSpec.classBuilder(this.className).superclass(this.superType()).addTypeVariables(this.typeVariableNames()).addModifiers(this.isFinal ? Modifier.FINAL : Modifier.ABSTRACT).addMethod(this.constructor());
            $GeneratedAnnotationSpecs.generatedAnnotationSpec(this.elements, this.sourceVersion, MemoizeExtension.class).ifPresent(generated::addAnnotation);
            for (ExecutableElement method : MemoizeExtension.memoizedMethods(this.context)) {
                MethodOverrider methodOverrider = new MethodOverrider(method);
                generated.addFields(methodOverrider.fields());
                generated.addMethod(methodOverrider.method());
            }
            if (this.hasErrors) {
                return null;
            }
            return $JavaFile.builder(this.context.packageName(), generated.build()).build().toString();
        }

        private $TypeName superType() {
            $ClassName superType = $ClassName.get(this.context.packageName(), this.classToExtend, new String[0]);
            $ImmutableList<$TypeVariableName> typeVariableNames = this.typeVariableNames();
            return typeVariableNames.isEmpty() ? superType : $ParameterizedTypeName.get(superType, typeVariableNames.toArray(new $TypeName[0]));
        }

        private $ImmutableList<$TypeVariableName> typeVariableNames() {
            $ImmutableList.Builder typeVariableNamesBuilder = $ImmutableList.builder();
            for (TypeParameterElement typeParameterElement : this.context.autoValueClass().getTypeParameters()) {
                typeVariableNamesBuilder.add($TypeVariableName.get(typeParameterElement));
            }
            return typeVariableNamesBuilder.build();
        }

        private $MethodSpec constructor() {
            $MethodSpec.Builder constructor = $MethodSpec.constructorBuilder();
            for (Map.Entry<String, ExecutableElement> property : this.context.properties().entrySet()) {
                constructor.addParameter($TypeName.get(property.getValue().getReturnType()), property.getKey() + "$", new Modifier[0]);
            }
            ArrayList<String> namesWithDollars = new ArrayList<String>();
            for (String property : this.context.properties().keySet()) {
                namesWithDollars.add(property + "$");
            }
            constructor.addStatement("super($L)", $Joiner.on(", ").join(namesWithDollars));
            return constructor.build();
        }

        private final class MethodOverrider {
            private final ExecutableElement method;
            private final $MethodSpec.Builder override;
            private final $FieldSpec cacheField;
            private final $ImmutableList.Builder<$FieldSpec> fields = $ImmutableList.builder();

            MethodOverrider(ExecutableElement method) {
                this.method = method;
                this.validate();
                this.cacheField = this.buildCacheField($TypeName.get(method.getReturnType()), method.getSimpleName().toString());
                this.fields.add((Object)this.cacheField);
                this.override = $MethodSpec.methodBuilder(method.getSimpleName().toString()).addAnnotation(Override.class).returns(this.cacheField.type).addExceptions(method.getThrownTypes().stream().map($TypeName::get).collect(Collectors.toList())).addModifiers($Iterables.filter(method.getModifiers(), $Predicates.not($Predicates.equalTo(Modifier.ABSTRACT))));
                for (AnnotationMirror annotationMirror : method.getAnnotationMirrors()) {
                    $AnnotationSpec annotationSpec = $AnnotationSpec.get(annotationMirror);
                    if (!this.pullDownMethodAnnotation(annotationMirror)) continue;
                    this.override.addAnnotation(annotationSpec);
                }
                InitializationStrategy checkStrategy = this.strategy();
                this.fields.addAll((Iterable)checkStrategy.additionalFields());
                this.override.beginControlFlow("if ($L)", checkStrategy.checkMemoized()).beginControlFlow("synchronized (this)", new Object[0]).beginControlFlow("if ($L)", checkStrategy.checkMemoized()).addStatement("$N = super.$L()", this.cacheField, method.getSimpleName()).addCode(checkStrategy.setMemoized()).endControlFlow().endControlFlow().endControlFlow().addStatement("return $N", this.cacheField);
            }

            Iterable<$FieldSpec> fields() {
                return this.fields.build();
            }

            $MethodSpec method() {
                return this.override.build();
            }

            private void validate() {
                if (this.method.getReturnType().getKind().equals((Object)TypeKind.VOID)) {
                    this.printMessage(Diagnostic.Kind.ERROR, "@Memoized methods cannot be void", new Object[0]);
                }
                if (!this.method.getParameters().isEmpty()) {
                    this.printMessage(Diagnostic.Kind.ERROR, "@Memoized methods cannot have parameters", new Object[0]);
                }
                this.checkIllegalModifier(Modifier.PRIVATE);
                this.checkIllegalModifier(Modifier.FINAL);
                this.checkIllegalModifier(Modifier.STATIC);
                if (!this.overridesObjectMethod("hashCode") && !this.overridesObjectMethod("toString")) {
                    this.checkIllegalModifier(Modifier.ABSTRACT);
                }
            }

            private void checkIllegalModifier(Modifier modifier) {
                if (this.method.getModifiers().contains((Object)modifier)) {
                    this.printMessage(Diagnostic.Kind.ERROR, "@Memoized methods cannot be " + modifier.toString(), new Object[0]);
                }
            }

            private void printMessage(Diagnostic.Kind kind, String format, Object ... args) {
                if (kind.equals((Object)Diagnostic.Kind.ERROR)) {
                    Generator.this.hasErrors = true;
                }
                Generator.this.messager.printMessage(kind, String.format(format, args), this.method);
            }

            private boolean overridesObjectMethod(String methodName) {
                return Generator.this.elements.overrides(this.method, this.objectMethod(methodName), Generator.this.context.autoValueClass());
            }

            private ExecutableElement objectMethod(String methodName) {
                TypeElement object = Generator.this.elements.getTypeElement(Object.class.getName());
                for (ExecutableElement method : ElementFilter.methodsIn(object.getEnclosedElements())) {
                    if (!method.getSimpleName().contentEquals(methodName)) continue;
                    return method;
                }
                throw new IllegalArgumentException(String.format("No method in Object named \"%s\"", methodName));
            }

            private boolean pullDownMethodAnnotation(AnnotationMirror annotation) {
                return !DO_NOT_PULL_DOWN_ANNOTATIONS.contains($MoreElements.asType(annotation.getAnnotationType().asElement()).getQualifiedName().toString());
            }

            private $FieldSpec buildCacheField($TypeName type, String name) {
                $FieldSpec.Builder builder = $FieldSpec.builder(type, name, Modifier.PRIVATE, Modifier.VOLATILE);
                if (Generator.this.lazyInitAnnotation.isPresent()) {
                    builder.addAnnotation(($AnnotationSpec)Generator.this.lazyInitAnnotation.get());
                    builder.addAnnotation(SUPPRESS_WARNINGS);
                }
                return builder.build();
            }

            InitializationStrategy strategy() {
                if (this.method.getReturnType().getKind().isPrimitive()) {
                    return new CheckBooleanField();
                }
                for (AnnotationMirror annotationMirror : this.method.getAnnotationMirrors()) {
                    if (!annotationMirror.getAnnotationType().asElement().getSimpleName().contentEquals("Nullable")) continue;
                    return new CheckBooleanField();
                }
                return new NullMeansUninitialized();
            }

            private final class CheckBooleanField
            extends InitializationStrategy {
                private final $FieldSpec field;

                private CheckBooleanField() {
                    this.field = MethodOverrider.this.buildCacheField($TypeName.BOOLEAN, MethodOverrider.this.method.getSimpleName() + "$Memoized");
                }

                @Override
                Iterable<$FieldSpec> additionalFields() {
                    return $ImmutableList.of(this.field);
                }

                @Override
                $CodeBlock checkMemoized() {
                    return $CodeBlock.of("!$N", this.field);
                }

                @Override
                $CodeBlock setMemoized() {
                    return $CodeBlock.builder().addStatement("$N = true", this.field).build();
                }
            }

            private final class NullMeansUninitialized
            extends InitializationStrategy {
                private NullMeansUninitialized() {
                }

                @Override
                Iterable<$FieldSpec> additionalFields() {
                    return $ImmutableList.of();
                }

                @Override
                $CodeBlock checkMemoized() {
                    return $CodeBlock.of("$N == null", MethodOverrider.this.cacheField);
                }

                @Override
                $CodeBlock setMemoized() {
                    return $CodeBlock.builder().beginControlFlow("if ($N == null)", MethodOverrider.this.cacheField).addStatement("throw new NullPointerException($S)", MethodOverrider.this.method.getSimpleName() + "() cannot return null").endControlFlow().build();
                }
            }

            private abstract class InitializationStrategy {
                private InitializationStrategy() {
                }

                abstract Iterable<$FieldSpec> additionalFields();

                abstract $CodeBlock checkMemoized();

                abstract $CodeBlock setMemoized();
            }
        }
    }
}

