"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports["default"] = void 0;

var _react = _interopRequireDefault(require("react"));

var _propTypes = _interopRequireDefault(require("prop-types"));

var _reactRelay = require("react-relay");

var _eventKit = require("event-kit");

var _helpers = require("../helpers");

var _propTypes2 = require("../prop-types");

var _issueishListController = _interopRequireWildcard(require("../controllers/issueish-list-controller"));

var _createPullRequestTile = _interopRequireDefault(require("../views/create-pull-request-tile"));

var _relayNetworkLayerManager = _interopRequireDefault(require("../relay-network-layer-manager"));

var _graphql;

function _interopRequireWildcard(obj) { if (obj && obj.__esModule) { return obj; } else { var newObj = {}; if (obj != null) { for (var key in obj) { if (Object.prototype.hasOwnProperty.call(obj, key)) { var desc = Object.defineProperty && Object.getOwnPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : {}; if (desc.get || desc.set) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } } newObj["default"] = obj; return newObj; } }

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { "default": obj }; }

function _extends() { _extends = Object.assign || function (target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i]; for (var key in source) { if (Object.prototype.hasOwnProperty.call(source, key)) { target[key] = source[key]; } } } return target; }; return _extends.apply(this, arguments); }

function _defineProperty(obj, key, value) { if (key in obj) { Object.defineProperty(obj, key, { value: value, enumerable: true, configurable: true, writable: true }); } else { obj[key] = value; } return obj; }

class CurrentPullRequestContainer extends _react["default"].Component {
  constructor(props) {
    super(props);
    (0, _helpers.autobind)(this, 'renderQueryResult', 'renderEmptyTile');
    this.sub = new _eventKit.Disposable();
  }

  render() {
    const environment = _relayNetworkLayerManager["default"].getEnvironmentForHost(this.props.endpoint, this.props.token);

    const head = this.props.branches.getHeadBranch();

    if (!head.isPresent()) {
      return this.renderEmptyResult();
    }

    const push = head.getPush();

    if (!push.isPresent() || !push.isRemoteTracking()) {
      return this.renderEmptyResult();
    }

    const pushRemote = this.props.remotes.withName(push.getRemoteName());

    if (!pushRemote.isPresent() || !pushRemote.isGithubRepo()) {
      return this.renderEmptyResult();
    }

    const query = _graphql || (_graphql = function () {
      const node = require("./__generated__/currentPullRequestContainerQuery.graphql");

      if (node.hash && node.hash !== "ade50c0777277f2032b27dfced670a2d") {
        console.error("The definition of 'currentPullRequestContainerQuery' appears to have changed. Run `relay-compiler` to update the generated files to receive the expected data.");
      }

      return require("./__generated__/currentPullRequestContainerQuery.graphql");
    });

    const variables = {
      headOwner: pushRemote.getOwner(),
      headName: pushRemote.getRepo(),
      headRef: push.getRemoteRef(),
      first: this.props.limit
    };
    return _react["default"].createElement(_reactRelay.QueryRenderer, {
      environment: environment,
      variables: variables,
      query: query,
      render: this.renderQueryResult
    });
  }

  renderEmptyResult() {
    this.sub.dispose();
    this.sub = this.props.remoteOperationObserver.onDidComplete(() => this.forceUpdate());
    return _react["default"].createElement(_issueishListController.BareIssueishListController, _extends({
      isLoading: false
    }, this.controllerProps()));
  }

  renderQueryResult({
    error,
    props,
    retry
  }) {
    if (retry) {
      this.sub.dispose();
      this.sub = this.props.remoteOperationObserver.onDidComplete(retry);
    }

    if (error) {
      return _react["default"].createElement(_issueishListController.BareIssueishListController, _extends({
        isLoading: false,
        error: error
      }, this.controllerProps()));
    }

    if (props === null) {
      return _react["default"].createElement(_issueishListController.BareIssueishListController, _extends({
        isLoading: true
      }, this.controllerProps()));
    }

    if (!props.repository || !props.repository.ref) {
      return _react["default"].createElement(_issueishListController.BareIssueishListController, _extends({
        isLoading: false
      }, this.controllerProps()));
    }

    const associatedPullRequests = props.repository.ref.associatedPullRequests;
    return _react["default"].createElement(_issueishListController["default"], _extends({
      total: associatedPullRequests.totalCount,
      results: associatedPullRequests.nodes,
      isLoading: false,
      workspace: this.props.workspace,
      workingDirectory: this.props.workingDirectory,
      endpoint: this.props.endpoint,
      resultFilter: issueish => issueish.getHeadRepositoryID() === this.props.repository.id
    }, this.controllerProps()));
  }

  renderEmptyTile() {
    return _react["default"].createElement(_createPullRequestTile["default"], {
      repository: this.props.repository,
      remote: this.props.remote,
      branches: this.props.branches,
      aheadCount: this.props.aheadCount,
      pushInProgress: this.props.pushInProgress,
      onCreatePr: this.props.onCreatePr
    });
  }

  componentWillUnmount() {
    this.sub.dispose();
  }

  controllerProps() {
    return {
      title: 'Checked out pull request',
      onOpenIssueish: this.props.onOpenIssueish,
      emptyComponent: this.renderEmptyTile,
      needReviewsButton: true,
      workingDirectory: this.props.workingDirectory
    };
  }

}

exports["default"] = CurrentPullRequestContainer;

_defineProperty(CurrentPullRequestContainer, "propTypes", {
  // Relay payload
  repository: _propTypes["default"].shape({
    id: _propTypes["default"].string.isRequired,
    defaultBranchRef: _propTypes["default"].shape({
      prefix: _propTypes["default"].string.isRequired,
      name: _propTypes["default"].string.isRequired
    })
  }).isRequired,
  // Connection
  endpoint: _propTypes2.EndpointPropType.isRequired,
  token: _propTypes["default"].string.isRequired,
  // Search constraints
  limit: _propTypes["default"].number,
  // Repository model attributes
  remoteOperationObserver: _propTypes2.OperationStateObserverPropType.isRequired,
  remote: _propTypes2.RemotePropType.isRequired,
  remotes: _propTypes2.RemoteSetPropType.isRequired,
  branches: _propTypes2.BranchSetPropType.isRequired,
  aheadCount: _propTypes["default"].number,
  pushInProgress: _propTypes["default"].bool.isRequired,
  workspace: _propTypes["default"].object.isRequired,
  workingDirectory: _propTypes["default"].string.isRequired,
  // Actions
  onOpenIssueish: _propTypes["default"].func.isRequired,
  onCreatePr: _propTypes["default"].func.isRequired
});

_defineProperty(CurrentPullRequestContainer, "defaultProps", {
  limit: 5
});
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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