/**
 * module used to cache static information about parsers,
 */
"use strict";
var lang_extensions_1 = require("../lang/lang_extensions");
var utils_1 = require("./../utils/utils");
exports.CLASS_TO_DEFINITION_ERRORS = new lang_extensions_1.HashTable();
exports.CLASS_TO_SELF_ANALYSIS_DONE = new lang_extensions_1.HashTable();
exports.CLASS_TO_GRAMMAR_PRODUCTIONS = new lang_extensions_1.HashTable();
function getProductionsForClass(className) {
    return getFromNestedHashTable(className, exports.CLASS_TO_GRAMMAR_PRODUCTIONS);
}
exports.getProductionsForClass = getProductionsForClass;
exports.CLASS_TO_RESYNC_FOLLOW_SETS = new lang_extensions_1.HashTable();
function getResyncFollowsForClass(className) {
    return getFromNestedHashTable(className, exports.CLASS_TO_RESYNC_FOLLOW_SETS);
}
exports.getResyncFollowsForClass = getResyncFollowsForClass;
function setResyncFollowsForClass(className, followSet) {
    exports.CLASS_TO_RESYNC_FOLLOW_SETS.put(className, followSet);
}
exports.setResyncFollowsForClass = setResyncFollowsForClass;
exports.CLASS_TO_LOOKAHEAD_FUNCS = new lang_extensions_1.HashTable();
function getLookaheadFuncsForClass(className) {
    return getFromNestedHashTable(className, exports.CLASS_TO_LOOKAHEAD_FUNCS);
}
exports.getLookaheadFuncsForClass = getLookaheadFuncsForClass;
exports.CLASS_TO_FIRST_AFTER_REPETITION = new lang_extensions_1.HashTable();
function getFirstAfterRepForClass(className) {
    return getFromNestedHashTable(className, exports.CLASS_TO_FIRST_AFTER_REPETITION);
}
exports.getFirstAfterRepForClass = getFirstAfterRepForClass;
exports.CLASS_TO_PRODUCTION_OVERRIDEN = new lang_extensions_1.HashTable();
function getProductionOverriddenForClass(className) {
    return getFromNestedHashTable(className, exports.CLASS_TO_PRODUCTION_OVERRIDEN);
}
exports.getProductionOverriddenForClass = getProductionOverriddenForClass;
// TODO reflective test to verify this has not changed, for example (OPTION6 added)
exports.MAX_OCCURRENCE_INDEX = 5;
function getFromNestedHashTable(className, hashTable) {
    var result = hashTable.get(className);
    if (result === undefined) {
        hashTable.put(className, new lang_extensions_1.HashTable());
        result = hashTable.get(className);
    }
    return result;
}
function clearCache() {
    var hasTables = utils_1.filter(utils_1.values(module.exports), function (currHashTable) { return currHashTable instanceof lang_extensions_1.HashTable; });
    utils_1.forEach(hasTables, function (currHashTable) { return currHashTable.clear(); });
}
exports.clearCache = clearCache;
