/*
 * Decompiled with CFR 0.152.
 */
package com.dickimawbooks.texparserlib.html;

import com.dickimawbooks.texparserlib.ControlSequence;
import com.dickimawbooks.texparserlib.EndDeclaration;
import com.dickimawbooks.texparserlib.Expandable;
import com.dickimawbooks.texparserlib.FixedUnit;
import com.dickimawbooks.texparserlib.GenericCommand;
import com.dickimawbooks.texparserlib.Ignoreable;
import com.dickimawbooks.texparserlib.Letter;
import com.dickimawbooks.texparserlib.MathGroup;
import com.dickimawbooks.texparserlib.Other;
import com.dickimawbooks.texparserlib.Par;
import com.dickimawbooks.texparserlib.PercentUnit;
import com.dickimawbooks.texparserlib.TeXApp;
import com.dickimawbooks.texparserlib.TeXCsRef;
import com.dickimawbooks.texparserlib.TeXDimension;
import com.dickimawbooks.texparserlib.TeXObject;
import com.dickimawbooks.texparserlib.TeXObjectList;
import com.dickimawbooks.texparserlib.TeXParser;
import com.dickimawbooks.texparserlib.TeXPath;
import com.dickimawbooks.texparserlib.TeXSettings;
import com.dickimawbooks.texparserlib.TeXSyntaxException;
import com.dickimawbooks.texparserlib.TeXUnit;
import com.dickimawbooks.texparserlib.Writeable;
import com.dickimawbooks.texparserlib.aux.AuxData;
import com.dickimawbooks.texparserlib.generic.BigOperator;
import com.dickimawbooks.texparserlib.generic.MathSymbol;
import com.dickimawbooks.texparserlib.generic.SpaceCs;
import com.dickimawbooks.texparserlib.html.HCode;
import com.dickimawbooks.texparserlib.html.HtmlTag;
import com.dickimawbooks.texparserlib.html.L2HAbstract;
import com.dickimawbooks.texparserlib.html.L2HAlignRow;
import com.dickimawbooks.texparserlib.html.L2HAmp;
import com.dickimawbooks.texparserlib.html.L2HAtMakeCaption;
import com.dickimawbooks.texparserlib.html.L2HBibItem;
import com.dickimawbooks.texparserlib.html.L2HBigOperator;
import com.dickimawbooks.texparserlib.html.L2HCaption;
import com.dickimawbooks.texparserlib.html.L2HContentsLine;
import com.dickimawbooks.texparserlib.html.L2HDescriptionItem;
import com.dickimawbooks.texparserlib.html.L2HDescriptionLabel;
import com.dickimawbooks.texparserlib.html.L2HEqnarray;
import com.dickimawbooks.texparserlib.html.L2HFloat;
import com.dickimawbooks.texparserlib.html.L2HFontFamilyDeclaration;
import com.dickimawbooks.texparserlib.html.L2HFontShapeDeclaration;
import com.dickimawbooks.texparserlib.html.L2HFontSizeDeclaration;
import com.dickimawbooks.texparserlib.html.L2HFontWeightDeclaration;
import com.dickimawbooks.texparserlib.html.L2HHyperlink;
import com.dickimawbooks.texparserlib.html.L2HHypertarget;
import com.dickimawbooks.texparserlib.html.L2HImage;
import com.dickimawbooks.texparserlib.html.L2HItem;
import com.dickimawbooks.texparserlib.html.L2HLetter;
import com.dickimawbooks.texparserlib.html.L2HMaketitle;
import com.dickimawbooks.texparserlib.html.L2HMathAlignRow;
import com.dickimawbooks.texparserlib.html.L2HMathDeclaration;
import com.dickimawbooks.texparserlib.html.L2HMathGroup;
import com.dickimawbooks.texparserlib.html.L2HMathSymbol;
import com.dickimawbooks.texparserlib.html.L2HNoBreakSpace;
import com.dickimawbooks.texparserlib.html.L2HNormalFont;
import com.dickimawbooks.texparserlib.html.L2HNumberline;
import com.dickimawbooks.texparserlib.html.L2HOther;
import com.dickimawbooks.texparserlib.html.L2HPar;
import com.dickimawbooks.texparserlib.html.L2HSection;
import com.dickimawbooks.texparserlib.html.L2HTableOfContents;
import com.dickimawbooks.texparserlib.html.L2HTabular;
import com.dickimawbooks.texparserlib.html.L2HTextSubscript;
import com.dickimawbooks.texparserlib.html.L2HTextSuperscript;
import com.dickimawbooks.texparserlib.html.L2HTheBibliography;
import com.dickimawbooks.texparserlib.html.L2HToImage;
import com.dickimawbooks.texparserlib.html.L2HUndefined;
import com.dickimawbooks.texparserlib.html.L2Hhfill;
import com.dickimawbooks.texparserlib.latex.AlignRow;
import com.dickimawbooks.texparserlib.latex.AtFirstOfTwo;
import com.dickimawbooks.texparserlib.latex.DescriptionDec;
import com.dickimawbooks.texparserlib.latex.FontFamilyDeclaration;
import com.dickimawbooks.texparserlib.latex.FontShapeDeclaration;
import com.dickimawbooks.texparserlib.latex.FontSizeDeclaration;
import com.dickimawbooks.texparserlib.latex.FontWeightDeclaration;
import com.dickimawbooks.texparserlib.latex.FrameBox;
import com.dickimawbooks.texparserlib.latex.IndexLocation;
import com.dickimawbooks.texparserlib.latex.KeyValList;
import com.dickimawbooks.texparserlib.latex.LaTeXFile;
import com.dickimawbooks.texparserlib.latex.LaTeXParserListener;
import com.dickimawbooks.texparserlib.latex.LaTeXSty;
import com.dickimawbooks.texparserlib.latex.LaTeXSyntaxException;
import com.dickimawbooks.texparserlib.latex.TrivListDec;
import com.dickimawbooks.texparserlib.primitives.Relax;
import com.dickimawbooks.texparserlib.primitives.Undefined;
import java.awt.Color;
import java.awt.Dimension;
import java.io.EOFException;
import java.io.File;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.Serializable;
import java.io.Writer;
import java.net.URI;
import java.net.URISyntaxException;
import java.nio.charset.Charset;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.HashMap;
import java.util.Stack;
import java.util.Vector;

public class L2HConverter
extends LaTeXParserListener
implements Writeable {
    private Vector<String> styCs;
    private int indexLoc = 0;
    private Writer writer;
    private Charset htmlCharSet = null;
    private TeXApp texApp;
    private Path outPath;
    private Path basePath;
    private boolean useMathJax = true;
    private boolean unicodeScriptSupport = true;
    private String suffix = "html";
    private Vector<String> extraHead = null;
    private Vector<String> extraCssStyles = new Vector();
    private HashMap<String, TeXObject> internalReferences;
    private HashMap<String, String> defaultStyles;
    private Stack<TrivListDec> trivListStack = new Stack();
    public static final String MIME_TYPE_PDF = "application/pdf";
    public static final String MIME_TYPE_PNG = "image/png";
    public static final String MIME_TYPE_JPEG = "image/jpeg";

    public L2HConverter(TeXApp teXApp) {
        this(teXApp, true, null, null, false, null, false);
    }

    public L2HConverter(TeXApp teXApp, Vector<AuxData> vector) {
        this(teXApp, true, null, vector, false, null, false);
    }

    public L2HConverter(TeXApp teXApp, boolean bl, boolean bl2) {
        this(teXApp, bl, null, null, bl2, null, false);
    }

    public L2HConverter(TeXApp teXApp, boolean bl, Vector<AuxData> vector) {
        this(teXApp, bl, null, vector, false, null, false);
    }

    public L2HConverter(TeXApp teXApp, File file) {
        this(teXApp, true, file, null, false, null, false);
    }

    public L2HConverter(TeXApp teXApp, File file, Vector<AuxData> vector) {
        this(teXApp, true, file, vector, false, null, false);
    }

    public L2HConverter(TeXApp teXApp, boolean bl, File file) {
        this(teXApp, bl, file, null, false, null, false);
    }

    public L2HConverter(TeXApp teXApp, boolean bl, File file, Vector<AuxData> vector) {
        this(teXApp, bl, file, vector, false, null, false);
    }

    public L2HConverter(TeXApp teXApp, boolean bl, File file, boolean bl2) {
        this(teXApp, bl, file, null, bl2, null, false);
    }

    public L2HConverter(TeXApp teXApp, boolean bl, File file, Vector<AuxData> vector, boolean bl2) {
        this(teXApp, bl, file, vector, bl2, null, false);
    }

    public L2HConverter(TeXApp teXApp, boolean bl, File file, Vector<AuxData> vector, boolean bl2, Charset charset) {
        this(teXApp, bl, file, vector, bl2, charset, false);
    }

    public L2HConverter(TeXApp teXApp, boolean bl, File file, Vector<AuxData> vector, boolean bl2, Charset charset, boolean bl3) {
        super(null, vector, bl2, bl3);
        this.texApp = teXApp;
        this.outPath = file == null ? null : file.toPath();
        this.htmlCharSet = charset;
        this.styCs = new Vector();
        this.defaultStyles = new HashMap();
        this.internalReferences = new HashMap();
        this.setWriteable(this);
        this.setUseMathJax(bl);
    }

    @Override
    protected void addPredefined() {
        super.addPredefined();
        ControlSequence controlSequence = this.getParser().getControlSequence("fbox");
        if (controlSequence instanceof FrameBox) {
            try {
                this.defaultStyles.put(this.getFrameBoxSpecs((FrameBox)controlSequence), "fbox");
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        if ((controlSequence = this.getParser().getControlSequence("mbox")) instanceof FrameBox) {
            try {
                this.defaultStyles.put(this.getFrameBoxSpecs((FrameBox)controlSequence), "mbox");
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        if ((controlSequence = this.getParser().getControlSequence("frame")) instanceof FrameBox) {
            try {
                this.defaultStyles.put(this.getFrameBoxSpecs((FrameBox)controlSequence), "frame");
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        this.putControlSequence(new AtFirstOfTwo("IfTeXParserLib"));
        this.putControlSequence(new L2HToImage());
        this.putControlSequence(new HCode());
        this.parser.putControlSequence(new GenericCommand("TeX", null, this.createString("TeX")));
        this.parser.putControlSequence(new GenericCommand("LaTeX", null, this.createString("LaTeX")));
        this.putControlSequence(new L2HHypertarget());
        this.putControlSequence(new L2HHyperlink());
        this.putControlSequence(new L2HAmp());
        this.putControlSequence(new L2HNoBreakSpace());
        this.putControlSequence(new SpaceCs("newblock"));
        this.putControlSequence(new L2HTheBibliography());
        this.addToBibliographySection(new TeXCsRef("label"));
        this.addToBibliographySection(this.createGroup("bib"));
        this.addInternalReference("bib", new TeXCsRef("refname"));
        this.addInternalReference("toc", new TeXCsRef("contentsname"));
        this.putControlSequence(new L2HTableOfContents());
        this.putControlSequence(new L2HContentsLine());
        this.putControlSequence(new L2HBibItem());
        this.putControlSequence(new L2HMaketitle());
        this.putControlSequence(new L2HTextSuperscript());
        this.putControlSequence(new L2HTextSubscript());
        this.putControlSequence(new L2HSection());
        this.putControlSequence(new L2HSection("subsection"));
        this.putControlSequence(new L2HSection("subsubsection"));
        this.putControlSequence(new L2HSection("paragraph"));
        this.putControlSequence(new L2HSection("subparagraph"));
        this.putControlSequence(new L2HSection("part"));
        this.putControlSequence(new L2HNumberline());
        this.putControlSequence(new L2HCaption());
        this.putControlSequence(new L2HAtMakeCaption());
        this.putControlSequence(new L2HFloat("figure"));
        this.putControlSequence(new L2HFloat("table"));
        this.putControlSequence(new L2HAbstract());
        this.putControlSequence(new L2HItem());
        this.putControlSequence(new L2HDescriptionLabel());
        this.putControlSequence(new L2HDescriptionItem());
        this.putControlSequence(new L2HMathDeclaration("math"));
        L2HMathDeclaration l2HMathDeclaration = new L2HMathDeclaration("(");
        this.parser.putControlSequence(l2HMathDeclaration);
        this.parser.putControlSequence(new EndDeclaration(")", l2HMathDeclaration));
        this.parser.putControlSequence(new L2HMathDeclaration("displaymath", 2));
        L2HMathDeclaration l2HMathDeclaration2 = new L2HMathDeclaration("[", 2);
        this.parser.putControlSequence(l2HMathDeclaration2);
        this.parser.putControlSequence(new EndDeclaration("]", l2HMathDeclaration2));
        this.parser.putControlSequence(new L2HMathDeclaration("equation", 2, true));
        this.parser.putControlSequence(new L2HTabular());
        this.parser.putControlSequence(new L2HTabular("array"));
        this.parser.putControlSequence(new L2HEqnarray());
        this.parser.putControlSequence(new L2HEqnarray("eqnarray*", false));
        this.putControlSequence(new GenericCommand(true, "bigskip", null, new TeXObject[]{new HtmlTag("<div class=\"bigskip\"></div>")}));
        this.putControlSequence(new GenericCommand(true, "medskip", null, new TeXObject[]{new HtmlTag("<div class=\"medskip\"></div>")}));
        this.putControlSequence(new GenericCommand(true, "smallskip", null, new TeXObject[]{new HtmlTag("<div class=\"smallskip\"></div>")}));
        this.putControlSequence(new L2Hhfill("hfill"));
        this.putControlSequence(new L2Hhfill("hfil"));
        this.putControlSequence(new GenericCommand(true, "quad", null, new TeXObject[]{new HtmlTag("<span class=\"quad\"></span>")}));
        this.putControlSequence(new GenericCommand(true, "qquad", null, new TeXObject[]{new HtmlTag("<span class=\"qquad\"></span>")}));
        this.putControlSequence(new L2HNormalFont());
        this.putControlSequence(new GenericCommand(true, "labelitemii", null, new HtmlTag("&#x2013;")));
        this.putControlSequence(new Relax("indent"));
        this.putControlSequence(new Relax("noindent"));
        try {
            LaTeXSty laTeXSty = this.requirepackage("hyperref");
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public void addInternalReference(String string, TeXObject teXObject) {
        this.internalReferences.put(string, teXObject);
    }

    @Override
    public TeXObject createUnknownReference(String string) {
        TeXObject teXObject = this.internalReferences.get(string);
        if (teXObject != null) {
            return teXObject;
        }
        return super.createUnknownReference(string);
    }

    @Override
    public TeXObject createUnknownReference(TeXObject teXObject) {
        try {
            TeXObjectList teXObjectList;
            if (teXObject instanceof Expandable && (teXObjectList = ((Expandable)((Object)teXObject)).expandfully(this.parser)) != null) {
                teXObject = teXObjectList;
            }
            return this.createUnknownReference(teXObject.toString(this.parser));
        }
        catch (IOException iOException) {
            this.getTeXApp().error(iOException);
            return super.createUnknownReference(teXObject);
        }
    }

    public L2HImage toImage(String string, String string2, String string3, TeXObject teXObject, String string4, boolean bl) throws IOException {
        return null;
    }

    @Override
    public BigOperator createBigOperator(String string, int n, int n2) {
        return new L2HBigOperator(string, n, n2);
    }

    @Override
    public BigOperator createBigOperator(String string, int n) {
        return new L2HBigOperator(string, n);
    }

    @Override
    public MathSymbol createMathSymbol(String string, int n) {
        return new L2HMathSymbol(string, n);
    }

    @Override
    public Letter getLetter(int n) {
        return new L2HLetter(n);
    }

    @Override
    public Other getOther(int n) {
        return new L2HOther(n);
    }

    @Override
    public Par getPar() {
        return new L2HPar();
    }

    @Override
    public MathGroup createMathGroup() {
        return new L2HMathGroup();
    }

    @Override
    public AlignRow createAlignRow(TeXObjectList teXObjectList) throws IOException {
        return new L2HAlignRow(this.getParser(), teXObjectList);
    }

    public AlignRow createMathAlignRow(TeXObjectList teXObjectList, boolean bl) throws IOException {
        return new L2HMathAlignRow(this.getParser(), teXObjectList, bl);
    }

    @Override
    public void cr(boolean bl, TeXObject teXObject) throws IOException {
        TeXSettings teXSettings = this.getParser().getSettings();
        if (teXSettings.getAlignMode() == 1) {
            teXSettings.startRow();
        } else {
            this.writeln("<br>\n");
        }
    }

    public void setWriter(Writer writer) {
        this.writer = writer;
    }

    public Writer getWriter() {
        return this.writer;
    }

    public String getStyle() {
        String string = "";
        if (this.parser != null) {
            TeXSettings teXSettings = this.parser.getSettings();
            switch (teXSettings.getCurrentFontFamily()) {
                case 0: {
                    string = "font-family: serif; ";
                    break;
                }
                case 1: {
                    string = "font-family: sans-serif; ";
                    break;
                }
                case 2: {
                    string = "font-family: monospace; ";
                }
            }
            switch (teXSettings.getCurrentFontShape()) {
                case 0: {
                    string = string + "font-style: normal; font-variant: normal; ";
                    break;
                }
                case 1: {
                    string = string + "font-style: italic; font-variant: normal; ";
                    break;
                }
                case 2: {
                    string = string + "font-style: oblique; font-variant: normal; ";
                    break;
                }
                case 3: {
                    int n;
                    TeXSettings teXSettings2 = teXSettings.getParent();
                    string = teXSettings2 != null ? ((n = teXSettings2.getFontShape()) == 0 || n == -1 ? (teXSettings.getFontFamily() == 1 ? string + "font-style: oblique; " : string + "font-style: italic; ") : string + "font-style: normal; ") : (teXSettings.getFontFamily() == 1 ? string + "font-style: oblique; " : string + "font-style: italic; ");
                    string = string + "font-variant: normal; ";
                    break;
                }
                case 4: {
                    string = string + "font-style: normal; font-variant: small-caps; ";
                }
            }
            switch (teXSettings.getCurrentFontWeight()) {
                case 0: {
                    string = string + "font-weight: normal; ";
                    break;
                }
                case 1: {
                    string = string + "font-weight: bold; ";
                }
            }
        }
        return string;
    }

    @Override
    public FontWeightDeclaration getFontWeightDeclaration(String string, int n) {
        return new L2HFontWeightDeclaration(string, n);
    }

    @Override
    public FontSizeDeclaration getFontSizeDeclaration(String string, int n) {
        return new L2HFontSizeDeclaration(string, n);
    }

    @Override
    public FontShapeDeclaration getFontShapeDeclaration(String string, int n) {
        return new L2HFontShapeDeclaration(string, n);
    }

    @Override
    public FontFamilyDeclaration getFontFamilyDeclaration(String string, int n) {
        return new L2HFontFamilyDeclaration(string, n);
    }

    @Override
    public void writeCodePoint(int n) throws IOException {
        if (this.writer == null) {
            return;
        }
        if (n >= 32 && n <= 126) {
            this.writer.write((char)n);
        } else {
            this.writer.write("&#x" + Integer.toHexString(n) + ";");
        }
    }

    @Override
    public void write(String string) throws IOException {
        if (this.writer == null) {
            return;
        }
        this.writer.write(string);
    }

    @Override
    public void write(char c) throws IOException {
        if (this.writer == null) {
            return;
        }
        this.write(String.format("%c", Character.valueOf(c)));
    }

    @Override
    public void writeln(String string) throws IOException {
        if (this.writer == null) {
            return;
        }
        this.write(String.format("%s%n", string));
        this.writer.flush();
    }

    @Override
    public void href(String string, TeXObject teXObject) throws IOException {
        if (this.writer == null) {
            return;
        }
        this.writer.write("<a href=\"" + string + "\">");
        teXObject.process(this.parser);
        this.writer.write("</a>");
    }

    @Override
    public void substituting(String string, String string2) {
        this.texApp.substituting(this.parser, string, string2);
    }

    @Override
    public void skipping(Ignoreable ignoreable) throws IOException {
    }

    public boolean supportUnicodeScript() {
        return this.unicodeScriptSupport;
    }

    public void setSupportUnicodeScript(boolean bl) {
        this.unicodeScriptSupport = bl;
    }

    public boolean useMathJax() {
        return this.useMathJax;
    }

    public void setUseMathJax(boolean bl) {
        this.useMathJax = bl;
    }

    public String mathJaxStartInline() {
        return "\\(";
    }

    public String mathJaxEndInline() {
        return "\\)";
    }

    public String mathJaxStartDisplay() {
        return "\\[";
    }

    public String mathJaxEndDisplay() {
        return "\\]";
    }

    public void writeMathJaxHeader() throws IOException {
        this.setUseMathJax(true);
        this.writeable.writeln("<!-- MathJax -->");
        this.writeable.writeln("<script type=\"text/x-mathjax-config\">");
        this.writeable.writeln("MathJax.Hub.Config({tex2jax:");
        this.writeable.writeln("{");
        this.writeable.writeln(String.format("  inlineMath: [['%s','%s']],", this.mathJaxStartInline().replace("\\", "\\\\"), this.mathJaxEndInline().replace("\\", "\\\\")));
        this.writeable.writeln(String.format("  displayMath: [ ['%s','%s'] ]", this.mathJaxStartDisplay().replace("\\", "\\\\"), this.mathJaxEndDisplay().replace("\\", "\\\\")));
        this.writeable.writeln("}});");
        this.writeable.writeln("</script>");
        this.writeable.write("<script type=\"text/javascript\" src=");
        this.writeable.writeln("\"http://cdn.mathjax.org/mathjax/latest/MathJax.js?config=TeX-AMS-MML_HTMLorMML\">");
        this.writeable.writeln("</script>");
    }

    protected void writeTabularCss(String string, String string2) throws IOException {
        String string3 = "";
        if (string != null) {
            string3 = string3 + string.charAt(0);
        }
        if (string2 != null) {
            string3 = string3 + string2.charAt(0);
        }
        this.writeln("table.tabular-" + string3);
        this.writeln("{");
        this.writeln("  display: inline-table;");
        this.writeln("  border-collapse: collapse;");
        if (string != null) {
            this.writeln("  align: " + string + ";");
        }
        if (string2 != null) {
            this.writeln("  vertical-align: " + string2 + ";");
        }
        this.writeln("}");
    }

    public void writeCssStyles() throws IOException {
        this.writeln("#main {margin-left: 5%; margin-right: 15%}");
        this.writeln("div.tomain {position: absolute; left: 0pt; width: 5%; text-align: right; font-size: x-small;}");
        this.writeln("div.tomain a {text-decoration: none;}");
        this.writeln("div.labellink {display: inline; font-size: x-small; margin-left: 1em; margin-right: 1em;}");
        this.writeln("div.marginleft {position: absolute; left: 0pt; width: 5%;}");
        this.writeln("div.marginright {position: absolute; right: 0pt; width: 15%;}");
        this.writeln("div.displaymath { display: block; text-align: center; }");
        this.writeln("span.eqno { float: right; }");
        this.writeln("div.table { display: block; text-align: center; }");
        this.writeTabularCss("center", "middle");
        this.writeTabularCss("center", "bottom");
        this.writeTabularCss("center", "top");
        this.writeTabularCss("left", "middle");
        this.writeTabularCss("left", "bottom");
        this.writeTabularCss("left", "top");
        this.writeTabularCss("right", "middle");
        this.writeTabularCss("right", "bottom");
        this.writeTabularCss("right", "top");
        this.writeTabularCss(null, "middle");
        this.writeTabularCss(null, "bottom");
        this.writeTabularCss(null, "top");
        this.writeTabularCss("left", null);
        this.writeTabularCss("center", null);
        this.writeTabularCss("right", null);
        this.writeln("div.figure { display: block; text-align: center; }");
        this.writeln("div.caption { display: block; text-align: center; }");
        this.writeln("div.marginpar { float: right; }");
        this.writeln("div.abstract { display: block; margin-right: 4em; margin-left: 4em;}");
        this.writeln("div.title { display: block; text-align: center; font-size: x-large;}");
        this.writeln("div.author { display: block; text-align: center; font-size: large;}");
        this.writeln("div.date { display: block; text-align: center; font-size: medium;}");
        this.writeln("div.bibliography { display: block; margin-left: 4em; }");
        this.writeln("div.bibitem { display: inline; float: left; text-indent: -3em; }");
        this.writeln("span.numberline { display: inline-block; width: 3em; }");
        this.writeln("div.toc-part { padding-left: .5em; padding-bottom: 2ex; font-weight: bold; font-size: large;}");
        this.writeln("div.toc-chapter { padding-left: .5em; padding-bottom: 2ex; font-weight: bold; font-size: large;}");
        this.writeln("div.toc-section { padding-left: 1em; font-weight: bold;}");
        this.writeln("div.toc-subsection { padding-left: 1.5em; }");
        this.writeln("div.toc-subsubsection { padding-left: 2em; }");
        this.writeln("div.toc-paragraph { padding-left: 2.5em; }");
        this.writeln("div.toc-subparagraph { padding-left: 3em; }");
        this.writeln("div.bigskip { padding-left: 0pt; padding-right: 0pt; padding-top: 0pt; padding-bottom: 2ex;}");
        this.writeln("div.medskip { padding-left: 0pt; padding-right: 0pt; padding-top: 0pt; padding-bottom: 1ex;}");
        this.writeln("div.smallskip { padding-left: 0pt; padding-right: 0pt; padding-top: 0pt; padding-bottom: .5ex;}");
        this.writeln("span.quad { padding-left: 0pt; padding-right: 1em; padding-top: 0pt; padding-bottom: 0pt;}");
        this.writeln("span.qquad { padding-left: 0pt; padding-right: 2em; padding-top: 0pt; padding-bottom: 0pt;}");
        this.writeln(".displaylist { display: block; list-style-type: none; }");
        this.writeln(".inlinelist { display: inline; }");
        this.writeln("span.inlineitem { margin-right: .5em; margin-left: .5em; }");
        this.writeln("span.numitem { float: left; margin-left: -3em; text-align: right; min-width: 2.5em; }");
        this.writeln("span.bulletitem { float: left; margin-left: -1em; }");
        this.writeln("span.descitem { font: normal; font-weight: bold; }");
        for (String string : this.defaultStyles.keySet()) {
            this.writeln(String.format(".%s {%s}", this.defaultStyles.get(string), string));
        }
        for (String string : this.extraCssStyles) {
            this.writeln(string);
        }
    }

    public void addCssStyle(String string) {
        this.extraCssStyles.add(string);
    }

    public void addToHead(String string) {
        if (this.extraHead == null) {
            this.extraHead = new Vector();
        }
        this.extraHead.add(string);
    }

    @Override
    public void documentclass(KeyValList keyValList, String string, boolean bl) throws IOException {
        super.documentclass(keyValList, string, bl);
        this.writeable.writeln("<!DOCTYPE HTML PUBLIC \"-//W3C//DTD HTML 3.2 Final//EN\">");
        this.writeable.writeln("<html>");
        this.writeable.writeln("<head>");
        this.writeable.writeln(String.format("<meta http-equiv=\"Content-Type\" content=\"text/html; charset=%s\">", this.htmlCharSet == null ? Charset.defaultCharset().name() : this.htmlCharSet.name()));
        this.writeable.writeln("<style type=\"text/css\">");
        this.writeCssStyles();
        this.writeable.writeln("</style>");
        if (this.useMathJax()) {
            this.writeMathJaxHeader();
        }
        if (this.extraHead != null) {
            for (String string2 : this.extraHead) {
                this.writeable.writeln(string2);
            }
        }
    }

    @Override
    public void beginDocument() throws IOException {
        Serializable serializable;
        Object object = this.getParser().getControlSequence("@title");
        if (!(object instanceof Undefined) && object != null) {
            if (object instanceof Expandable && (serializable = ((Expandable)object).expandfully(this.getParser())) != null) {
                object = serializable;
            }
            this.writeable.write("<title>");
            this.writeable.write(object.toString(this.getParser()));
            this.writeable.writeln("</title>");
        }
        this.writeable.writeln("</head>");
        this.writeable.write("<body");
        serializable = this.getParser().getSettings().getFgColor();
        Color color = this.getParser().getSettings().getBgColor();
        if (serializable != null && serializable != Color.BLACK) {
            this.writeable.write(String.format(" text=\"%s\"", this.getHtmlColor((Color)serializable)));
        }
        if (color != null && color != Color.WHITE) {
            this.writeable.write(String.format(" background=\"%s\"", this.getHtmlColor(color)));
        }
        this.writeable.writeln(">");
        super.beginDocument();
        this.writeable.writeln("<div id=\"main\">");
        this.getParser().getSettings().setCharMapMode(1);
    }

    @Override
    public void endDocument() throws IOException {
        if (!this.isInDocEnv()) {
            throw new LaTeXSyntaxException(this.parser, "latex.error.no_begin_doc", new Object[0]);
        }
        this.processFootnotes();
        this.writeable.writeln("</div>");
        ControlSequence controlSequence = this.parser.getControlSequence("@enddocumenthook");
        if (controlSequence != null) {
            try {
                controlSequence.process(this.parser);
            }
            catch (IOException iOException) {
                this.getTeXApp().error(iOException);
            }
        }
        this.writeable.writeln("</body>");
        this.writeable.writeln("</html>");
        throw new EOFException();
    }

    @Override
    public void overwithdelims(TeXObject teXObject, TeXObject teXObject2, TeXObject teXObject3, TeXObject teXObject4) throws IOException {
        if (this.useMathJax()) {
            if (teXObject != null || teXObject2 != null) {
                this.write("\\left");
                this.write(teXObject == null ? "." : teXObject.toString(this.getParser()));
            }
            this.write("\\frac{");
            teXObject3.process(this.getParser());
            this.write("}{");
            teXObject4.process(this.getParser());
            this.write("}");
            if (teXObject != null || teXObject2 != null) {
                this.write("\\right");
                this.write(teXObject2 == null ? "." : teXObject2.toString(this.getParser()));
            }
            return;
        }
        if (teXObject != null) {
            teXObject.process(this.parser);
        }
        this.write("<table style=\"display: inline;\"><tr style=\"border-bottom-style: solid;\"><td>");
        teXObject3.process(this.parser);
        this.write("</td></tr>");
        this.write("<tr><td>");
        teXObject4.process(this.parser);
        this.write("</td></tr><table>");
        if (teXObject2 != null) {
            teXObject2.process(this.parser);
        }
    }

    @Override
    public void abovewithdelims(TeXObject teXObject, TeXObject teXObject2, TeXDimension teXDimension, TeXObject teXObject3, TeXObject teXObject4) throws IOException {
        if (this.useMathJax()) {
            this.write(teXObject3.toString(this.getParser()));
            this.write("\\abovewithdelims ");
            this.write(teXObject == null ? "." : teXObject.toString(this.getParser()));
            this.write(teXObject2 == null ? "." : teXObject2.toString(this.getParser()));
            this.write(teXDimension.toString(this.getParser()));
            this.write(teXObject4.toString(this.getParser()));
            return;
        }
        if (teXObject != null) {
            teXObject.process(this.parser);
        }
        this.write("<table><tr><td>");
        teXObject3.process(this.parser);
        this.write("</td></tr>");
        this.write("<tr><td>");
        teXObject4.process(this.parser);
        this.write("</td></tr><table>");
        if (teXObject2 != null) {
            teXObject2.process(this.parser);
        }
    }

    @Override
    public void subscript(TeXObject teXObject) throws IOException {
        if (this.useMathJax()) {
            this.write("_{");
            teXObject.process(this.parser);
            this.write("}");
        } else {
            this.write("<sub>");
            teXObject.process(this.parser);
            this.write("</sub>");
        }
    }

    @Override
    public void superscript(TeXObject teXObject) throws IOException {
        if (this.useMathJax()) {
            this.write("^{");
            teXObject.process(this.parser);
            this.write("}");
        } else {
            this.write("<sup>");
            teXObject.process(this.parser);
            this.write("</sup>");
        }
    }

    public void verb(String string, boolean bl, char c, String string2) throws IOException {
        this.write("<code style=\"white-space: pre;\">");
        super.verb(string, bl, c, string2);
        this.write("</code>");
    }

    public String getImagePreamble() throws IOException {
        Object object;
        String string = null;
        ControlSequence controlSequence = this.parser.getControlSequence("TeXParserLibToImagePreamble");
        if (controlSequence != null && controlSequence instanceof Expandable && (object = ((Expandable)((Object)controlSequence)).expandonce(this.parser)) != null) {
            string = ((TeXObjectList)object).toString(this.parser);
        }
        if (string == null) {
            object = this.getDocumentClass();
            StringBuilder stringBuilder = new StringBuilder();
            if (object == null) {
                stringBuilder.append("\\documentclass{article}");
            } else {
                stringBuilder.append("\\documentclass");
                KeyValList keyValList = ((LaTeXFile)object).getOptions();
                if (keyValList != null) {
                    stringBuilder.append(String.format("[%s]", keyValList.format()));
                }
                stringBuilder.append(String.format("{%s}%n", ((LaTeXFile)object).getName()));
            }
            for (LaTeXFile laTeXFile : this.getLoadedPackages()) {
                stringBuilder.append("\\usepackage");
                KeyValList keyValList = laTeXFile.getOptions();
                if (keyValList != null) {
                    stringBuilder.append(String.format("[%s]", keyValList.format()));
                }
                stringBuilder.append(String.format("{%s}%n", laTeXFile.getName()));
            }
            stringBuilder.append("\\pagestyle{empty}%n");
            string = stringBuilder.toString();
        }
        return string;
    }

    public static String getMimeType(String string) {
        int n = string.lastIndexOf(".");
        if (n < 0) {
            return null;
        }
        String string2 = string.substring(n).toLowerCase();
        if (string2.equals("pdf")) {
            return MIME_TYPE_PDF;
        }
        if (string2.equals("png")) {
            return MIME_TYPE_PNG;
        }
        if (string2.equals("jpeg") || string2.equals("jpg")) {
            return MIME_TYPE_JPEG;
        }
        return null;
    }

    public Dimension getImageSize(File file, String string) {
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void includegraphics(KeyValList keyValList, String string) throws IOException {
        Object object;
        Object object2;
        Comparable<StringBuilder> comparable;
        TeXPath teXPath = new TeXPath(this.parser, string, true, "png", "jpeg", "pdf");
        File file = teXPath.getFile();
        if (!file.exists()) {
            throw new TeXSyntaxException(this.parser, "tex.error.file.not.found", string);
        }
        TeXObject teXObject = null;
        String string2 = L2HConverter.getMimeType(file.getName());
        L2HImage l2HImage = null;
        int n = 0;
        if (keyValList != null) {
            n = keyValList.size();
            teXObject = keyValList.getValue("alt");
            if (teXObject != null) {
                --n;
            }
        }
        if (n > 0) {
            comparable = new StringBuilder("\\includegraphics[");
            object2 = null;
            object = keyValList.getOrderedKeyIterator();
            while (object.hasNext()) {
                String string3 = object.next();
                if (object2 != null) {
                    ((StringBuilder)comparable).append((String)object2);
                }
                if (!string3.equals("alt")) {
                    ((StringBuilder)comparable).append(String.format("%s={%s}", string3, keyValList.getValue(string3).toString(this.parser)));
                }
                object2 = ",";
            }
            ((StringBuilder)comparable).append("]{");
            ((StringBuilder)comparable).append(string);
            ((StringBuilder)comparable).append('}');
            l2HImage = this.toImage(this.getImagePreamble(), ((StringBuilder)comparable).toString(), string2, teXObject, null, true);
        }
        if (l2HImage != null) {
            l2HImage.process(this.parser);
        } else {
            comparable = teXPath.getRelative();
            if (teXPath.isAbsolute()) {
                object2 = this.outPath == null ? new File(file.getName()) : new File(this.outPath.toFile(), file.getName());
                comparable = teXPath.getLeaf();
            } else {
                object2 = (this.outPath == null ? teXPath.getRelative() : this.outPath.resolve(teXPath.getRelative())).toFile();
            }
            object = this.getImageSize(file, string2);
            this.write(String.format("<object data=\"%s\"", this.getUri((Path)comparable)));
            if (string2 != null) {
                this.write(String.format(" type=\"%s\"", string2));
            }
            if (object != null) {
                this.write(String.format(" width=\"%d\" height=\"%d\"", ((Dimension)object).width, ((Dimension)object).height));
            }
            this.write(">");
            try {
                if (teXObject != null) {
                    teXObject.process(this.parser);
                }
            }
            finally {
                this.write("</object>");
            }
            try {
                this.getTeXApp().copyFile(file, (File)object2);
            }
            catch (InterruptedException interruptedException) {
                this.getTeXApp().error(interruptedException);
            }
        }
    }

    protected void writeTransform(String string, String string2) throws IOException {
        this.writeTransform(string, string2, null);
    }

    protected void writeTransform(String string, String string2, String string3) throws IOException {
        this.write(String.format("<%s style=\"display: inline-block; transform: %s; -ms-transform: %s; -webkit-transform: %s;", string, string2, string2, string2));
        if (string3 != null) {
            this.write(String.format(" transform-origin: %s; -ms-transform-origin: %s; -webkit-transform-origin: %s;", string3, string3, string3));
        }
        this.write("\">");
    }

    public void transform(String string, TeXParser teXParser, TeXObjectList teXObjectList, TeXObject teXObject) throws IOException {
        this.writeTransform("div", string);
        if (teXObjectList == teXParser || teXObjectList == null) {
            teXObject.process(teXParser);
        } else {
            teXObject.process(teXParser, teXObjectList);
        }
        this.write("</div>");
    }

    @Override
    public void rotate(double d, TeXParser teXParser, TeXObjectList teXObjectList, TeXObject teXObject) throws IOException {
        this.transform(String.format("rotate(%fdeg)", -d), teXParser, teXObjectList, teXObject);
    }

    @Override
    public void rotate(double d, double d2, double d3, TeXParser teXParser, TeXObjectList teXObjectList, TeXObject teXObject) throws IOException {
        if (d2 == 0.0 && d3 == 0.0) {
            this.transform(String.format("rotate(%fdeg)", -d), teXParser, teXObjectList, teXObject);
        } else {
            this.transform(String.format("rotate(%fdeg)", -d, String.format("%d%% %d%%", d2, d3)), teXParser, teXObjectList, teXObject);
        }
    }

    @Override
    public void rotate(double d, TeXDimension teXDimension, TeXDimension teXDimension2, TeXParser teXParser, TeXObjectList teXObjectList, TeXObject teXObject) throws IOException {
        if (teXDimension == null && teXDimension == null) {
            this.transform(String.format("rotate(%fdeg)", -d), teXParser, teXObjectList, teXObject);
        } else {
            String string = "0%";
            String string2 = "0%";
            if (teXDimension != null) {
                string = String.format("%f%s", teXDimension.format());
            }
            if (teXDimension2 != null) {
                string2 = String.format("%f%s", teXDimension2.format());
            }
            this.transform(String.format("rotate(%fdeg)", -d, String.format("%s %s", string, string2)), teXParser, teXObjectList, teXObject);
        }
    }

    @Override
    public void scale(double d, double d2, TeXParser teXParser, TeXObjectList teXObjectList, TeXObject teXObject) throws IOException {
        this.transform(String.format("scale(%f,%f)", d, d2), teXParser, teXObjectList, teXObject);
    }

    @Override
    public void scaleX(double d, TeXParser teXParser, TeXObjectList teXObjectList, TeXObject teXObject) throws IOException {
        this.transform(String.format("scaleX(%f)", d), teXParser, teXObjectList, teXObject);
    }

    @Override
    public void scaleY(double d, TeXParser teXParser, TeXObjectList teXObjectList, TeXObject teXObject) throws IOException {
        this.transform(String.format("scaleY(%f)", d), teXParser, teXObjectList, teXObject);
    }

    @Override
    public void resize(TeXDimension teXDimension, TeXDimension teXDimension2, TeXParser teXParser, TeXObjectList teXObjectList, TeXObject teXObject) throws IOException {
        this.write("<div style=\"display: inline-block;");
        if (teXDimension != null) {
            this.write(String.format(" width: %s;", teXDimension.format()));
        }
        if (teXDimension2 != null) {
            this.write(String.format(" height: %s;", teXDimension2.format()));
        }
        this.write("\">");
        if (teXObjectList == teXParser || teXObjectList == null) {
            teXObject.process(teXParser);
        } else {
            teXObject.process(teXParser, teXObjectList);
        }
        this.write("</div>");
    }

    @Override
    public TeXApp getTeXApp() {
        return this.texApp;
    }

    @Override
    public void endParse(File file) throws IOException {
    }

    @Override
    public void beginParse(File file, Charset charset) throws IOException {
        this.getTeXApp().message(this.getTeXApp().getMessage("message.reading", file));
        if (charset != null) {
            this.getTeXApp().message(this.getTeXApp().getMessage("message.charset", charset));
        }
        this.basePath = file.getParentFile().toPath();
        if (this.writer == null) {
            Files.createDirectories(this.outPath, new FileAttribute[0]);
            String string = file.getName();
            int n = string.lastIndexOf(".");
            if (n > -1) {
                string = string.substring(0, n);
            }
            File file2 = new File(this.outPath.toFile(), string + "." + this.getSuffix());
            this.getTeXApp().message(this.getTeXApp().getMessage("message.writing", file2));
            if (this.htmlCharSet == null) {
                this.writer = new PrintWriter(file2);
            } else {
                this.getTeXApp().message(this.getTeXApp().getMessage("message.charset", this.htmlCharSet));
                this.writer = new PrintWriter(file2, this.htmlCharSet.name());
            }
        }
    }

    public void setSuffix(String string) {
        this.suffix = string;
    }

    public String getSuffix() {
        return this.suffix;
    }

    @Override
    public ControlSequence createUndefinedCs(String string) {
        return new L2HUndefined(string, this.getUndefinedAction());
    }

    @Override
    public void marginpar(TeXObject teXObject, TeXObject teXObject2) throws IOException {
        this.write("<div class=\"margin");
        try {
            if (this.isMarginRight()) {
                this.write("right\">");
                teXObject2.process(this.parser);
            } else {
                this.write("left\">");
                teXObject.process(this.parser);
            }
        }
        finally {
            this.write("</div>");
        }
    }

    @Override
    public void doFootnoteRule() throws IOException {
        this.writeln("<p><hr><p>");
    }

    @Override
    public IndexLocation createIndexLocation(String string) throws IOException {
        ++this.indexLoc;
        String string2 = String.format("idx-%s-%d", HtmlTag.getUriFragment(string), this.indexLoc);
        this.write(String.format("<a name=\"%s\"></a>", string2));
        return new IndexLocation(new HtmlTag(String.format("<a ref=\"#%s\">%d</a>", string2, this.indexLoc)));
    }

    @Override
    public void registerControlSequence(LaTeXSty laTeXSty, ControlSequence controlSequence) {
        this.styCs.add(controlSequence.getName());
        this.putControlSequence(controlSequence);
    }

    public boolean isStyControlSequence(ControlSequence controlSequence) {
        return this.styCs.contains(controlSequence.getName());
    }

    @Override
    public void startList(TrivListDec trivListDec) throws IOException {
        super.startList(trivListDec);
        if (trivListDec instanceof DescriptionDec) {
            this.write(String.format("%n<dl>%n", new Object[0]));
        } else if (trivListDec.isInLine()) {
            this.write("<div class=\"inlinelist\">");
        } else if (this.isIfTrue(this.getControlSequence("if@nmbrlist"))) {
            this.write(String.format("%n<ol class=\"displaylist\">%n", new Object[0]));
        } else {
            this.write(String.format("%n<ul class=\"displaylist\">%n", new Object[0]));
        }
    }

    @Override
    public void endList(TrivListDec trivListDec) throws IOException {
        if (trivListDec instanceof DescriptionDec) {
            this.write(String.format("%n</dl>%n", new Object[0]));
        } else if (trivListDec.isInLine()) {
            this.write("</div>");
        } else if (this.isIfTrue(this.getControlSequence("if@nmbrlist"))) {
            this.write(String.format("%n</ol>%n", new Object[0]));
        } else {
            this.write(String.format("%n</ul>%n", new Object[0]));
        }
        super.endList(trivListDec);
    }

    public String getHtmlColor(Color color) {
        if (color == Color.BLACK) {
            return "black";
        }
        if (color == Color.BLUE) {
            return "blue";
        }
        if (color == Color.CYAN) {
            return "cyan";
        }
        if (color == Color.GRAY) {
            return "gray";
        }
        if (color == Color.GREEN) {
            return "green";
        }
        if (color == Color.MAGENTA) {
            return "magenta";
        }
        if (color == Color.ORANGE) {
            return "orange";
        }
        if (color == Color.PINK) {
            return "pink";
        }
        if (color == Color.RED) {
            return "red";
        }
        if (color == Color.WHITE) {
            return "white";
        }
        if (color == Color.YELLOW) {
            return "yellow";
        }
        return String.format("rgb(%d,%d,%d)", color.getRed(), color.getGreen(), color.getBlue());
    }

    public String getHtmlDimension(TeXDimension teXDimension) throws IOException {
        float f = teXDimension.getValue();
        TeXUnit teXUnit = teXDimension.getUnit();
        if (teXUnit instanceof FixedUnit) {
            int n = ((FixedUnit)teXUnit).getId();
            switch (n) {
                case 2: 
                case 4: 
                case 5: {
                    return String.format("%f%s", Float.valueOf(f), FixedUnit.UNIT_NAMES[n]);
                }
                case 3: {
                    return String.format("%fpt", Float.valueOf(f));
                }
            }
        }
        if (teXUnit == TeXUnit.EM) {
            return String.format("%fem", Float.valueOf(f));
        }
        if (teXUnit == TeXUnit.EX) {
            return String.format("%fex", Float.valueOf(f));
        }
        if (teXUnit instanceof PercentUnit) {
            return String.format("%f%%", Float.valueOf(f));
        }
        return String.format("%fpt", Float.valueOf(teXUnit.toUnit(this.getParser(), f, TeXUnit.BP)));
    }

    public String getUri(Path path) {
        String string;
        if (path.isAbsolute()) {
            return path.toUri().toString();
        }
        int n = path.getNameCount();
        if (n == 1) {
            string = path.toString();
        } else {
            StringBuilder stringBuilder = new StringBuilder(path.getName(0).toString());
            for (int i = 1; i < n; ++i) {
                stringBuilder.append('/');
                stringBuilder.append(path.getName(i).toString());
            }
            string = stringBuilder.toString();
        }
        try {
            return new URI(string).toString();
        }
        catch (URISyntaxException uRISyntaxException) {
            this.getTeXApp().error(uRISyntaxException);
            return string;
        }
    }

    @Override
    public void startColor(Color color, boolean bl) throws IOException {
        if (this.isInDocEnv()) {
            this.write("<span style=\"");
            if (bl) {
                this.write("color: ");
            } else {
                this.write("background-color: ");
            }
            this.write(String.format(" %s\">", this.getHtmlColor(color)));
        }
    }

    @Override
    public void endColor(boolean bl) throws IOException {
        if (this.isInDocEnv()) {
            this.write("</span>");
        }
    }

    protected String getFrameBoxSpecs(FrameBox frameBox) throws IOException {
        TeXDimension teXDimension;
        TeXDimension teXDimension2;
        TeXDimension teXDimension3;
        TeXDimension teXDimension4;
        StringBuilder stringBuilder = new StringBuilder();
        if (frameBox.isInLine()) {
            stringBuilder.append("display: inline-block; ");
        }
        switch (frameBox.getHAlign()) {
            case 1: {
                stringBuilder.append("text-align: left; ");
                break;
            }
            case 2: {
                stringBuilder.append("text-align: center; ");
                break;
            }
            case 3: {
                stringBuilder.append("text-align: right; ");
            }
        }
        switch (frameBox.getVAlign()) {
            case 1: {
                stringBuilder.append("vertical-align: top; ");
                break;
            }
            case 2: {
                stringBuilder.append("vertical-align: middle; ");
                break;
            }
            case 3: {
                stringBuilder.append("vertical-align: bottom; ");
                break;
            }
            case 4: {
                stringBuilder.append("vertical-align: base; ");
            }
        }
        switch (frameBox.getStyle()) {
            case 1: {
                stringBuilder.append("border-style: solid; ");
                break;
            }
            case 2: {
                stringBuilder.append("border-style: double; ");
            }
        }
        Color color = frameBox.getBorderColor(this.getParser());
        if (color != null) {
            stringBuilder.append(String.format("border-color: %s; ", this.getHtmlColor(color)));
        }
        if ((teXDimension4 = frameBox.getBorderWidth(this.getParser())) != null) {
            stringBuilder.append(String.format("border-width: %s; ", this.getHtmlDimension(teXDimension4)));
        }
        if ((teXDimension3 = frameBox.getInnerMargin(this.getParser())) != null) {
            stringBuilder.append(String.format("padding: %s; ", this.getHtmlDimension(teXDimension3)));
        }
        if ((color = frameBox.getForegroundColor(this.getParser())) != null) {
            stringBuilder.append(String.format("color: %s; ", this.getHtmlColor(color)));
        }
        if ((color = frameBox.getBackgroundColor(this.getParser())) != null) {
            stringBuilder.append(String.format("background-color: %s; ", this.getHtmlColor(color)));
        }
        if ((teXDimension2 = frameBox.getWidth(this.getParser())) != null) {
            stringBuilder.append(String.format("width: %s; ", this.getHtmlDimension(teXDimension2)));
        }
        if ((teXDimension = frameBox.getHeight(this.getParser())) != null) {
            stringBuilder.append(String.format("height: %s; ", this.getHtmlDimension(teXDimension)));
        }
        return stringBuilder.toString();
    }

    @Override
    public void startFrameBox(FrameBox frameBox) throws IOException {
        String string = this.getFrameBoxSpecs(frameBox);
        if (frameBox.isInLine()) {
            this.write("<span ");
        } else {
            this.write("<div ");
        }
        String string2 = this.defaultStyles.get(string);
        if (string2 == null) {
            this.write(String.format("style=\"%s\"", string));
        } else {
            this.write(String.format("class=\"%s\"", string2));
        }
        this.write(">");
    }

    @Override
    public void endFrameBox(FrameBox frameBox) throws IOException {
        if (frameBox.isInLine()) {
            this.write("</span>");
        } else {
            this.write("</div>");
        }
    }

    @Override
    public void startTheorem(String string) throws IOException {
        this.write("<div class=\"");
        this.write(string);
        this.write("\">");
    }

    @Override
    public void endTheorem(String string) throws IOException {
        this.write("</div>");
    }

    public HtmlTag createLinkBox(String string) {
        ControlSequence controlSequence = this.parser.getControlSequence("TeXParserLibLinkName");
        String string2 = "[link]";
        if (controlSequence instanceof Expandable) {
            try {
                TeXObjectList teXObjectList = this.parser.expandfully(this.parser);
                if (teXObjectList != null) {
                    string2 = teXObjectList.toString(this.parser);
                }
            }
            catch (IOException iOException) {
                this.getTeXApp().error(iOException);
            }
        }
        return new HtmlTag(String.format("<div class=\"labellink\"><a href=\"#%s\">%s</a></div>", string, string2));
    }

    public void startSection(boolean bl, String string, String string2) throws IOException {
        ControlSequence controlSequence = this.parser.getControlSequence("TeXParserLibToTopName");
        String string3 = "[top]";
        if (controlSequence instanceof Expandable) {
            try {
                TeXObjectList teXObjectList = this.parser.expandfully(this.parser);
                if (teXObjectList != null) {
                    string3 = teXObjectList.toString(this.parser);
                }
            }
            catch (IOException iOException) {
                this.getTeXApp().error(iOException);
            }
        }
        this.write(String.format("<div class=\"tomain\"><a href=\"#main\">%s</a></div>", string3));
    }

    @Override
    public TeXObject getAnchor(String string) {
        return new HtmlTag(String.format("<a name=\"%s\"></a>", string));
    }
}

