/*
 * Decompiled with CFR 0.152.
 */
package sun.jvm.hotspot.tools.jcore;

import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.jar.JarEntry;
import java.util.jar.JarOutputStream;
import java.util.jar.Manifest;
import sun.jvm.hotspot.debugger.AddressException;
import sun.jvm.hotspot.memory.SystemDictionary;
import sun.jvm.hotspot.oops.InstanceKlass;
import sun.jvm.hotspot.oops.Klass;
import sun.jvm.hotspot.runtime.VM;
import sun.jvm.hotspot.tools.Tool;
import sun.jvm.hotspot.tools.jcore.ClassFilter;
import sun.jvm.hotspot.tools.jcore.ClassWriter;

public class ClassDump
extends Tool {
    private ClassFilter classFilter;
    private String outputDirectory;
    private JarOutputStream jarStream;

    public void setClassFilter(ClassFilter cf) {
        this.classFilter = cf;
    }

    public void setOutputDirectory(String od) {
        this.outputDirectory = od;
        if (this.jarStream != null) {
            try {
                this.jarStream.close();
            }
            catch (IOException ioe) {
                ioe.printStackTrace();
            }
        }
        this.jarStream = null;
    }

    public void setJarOutput(String jarFileName) throws IOException {
        this.jarStream = new JarOutputStream((OutputStream)new FileOutputStream(jarFileName), new Manifest());
        this.outputDirectory = null;
    }

    @Override
    public void run() {
        try {
            SystemDictionary dict = VM.getVM().getSystemDictionary();
            dict.classesDo(new SystemDictionary.ClassVisitor(){

                @Override
                public void visit(Klass k) {
                    if (k instanceof InstanceKlass) {
                        try {
                            ClassDump.this.dumpKlass((InstanceKlass)k);
                        }
                        catch (Exception e) {
                            System.out.println(k.getName().asString());
                            e.printStackTrace();
                        }
                    }
                }
            });
        }
        catch (AddressException e) {
            System.err.println("Error accessing address 0x" + Long.toHexString(e.getAddress()));
            e.printStackTrace();
        }
        if (this.jarStream != null) {
            try {
                this.jarStream.close();
            }
            catch (IOException ioe) {
                ioe.printStackTrace();
            }
            this.jarStream = null;
        }
    }

    @Override
    public String getName() {
        return "jcore";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void dumpKlass(InstanceKlass kls) {
        if (this.classFilter != null && !this.classFilter.canInclude(kls)) {
            return;
        }
        String klassName = kls.getName().asString();
        klassName = klassName.replace('/', File.separatorChar);
        try {
            FilterOutputStream os = null;
            if (this.jarStream != null) {
                this.jarStream.putNextEntry(new JarEntry(klassName + ".class"));
                os = this.jarStream;
            } else {
                int index = klassName.lastIndexOf(File.separatorChar);
                File dir = null;
                if (index != -1) {
                    String dirName = klassName.substring(0, index);
                    dir = new File(this.outputDirectory, dirName);
                } else {
                    dir = new File(this.outputDirectory);
                }
                dir.mkdirs();
                File f = new File(dir, klassName.substring(index + 1) + ".class");
                f.createNewFile();
                os = new BufferedOutputStream(new FileOutputStream(f));
            }
            try {
                ClassWriter cw = new ClassWriter(kls, os);
                cw.write();
            }
            finally {
                if (os != this.jarStream) {
                    ((OutputStream)os).close();
                }
            }
        }
        catch (IOException exp) {
            exp.printStackTrace();
        }
    }

    public static void main(String[] args) {
        String outputDirectory;
        ClassFilter classFilter = null;
        String filterClassName = System.getProperty("sun.jvm.hotspot.tools.jcore.filter");
        if (filterClassName != null) {
            try {
                Class<?> filterClass = Class.forName(filterClassName);
                classFilter = (ClassFilter)filterClass.newInstance();
            }
            catch (Exception exp) {
                System.err.println("Warning: Can not create class filter!");
            }
        }
        if ((outputDirectory = System.getProperty("sun.jvm.hotspot.tools.jcore.outputDir")) == null) {
            outputDirectory = ".";
        }
        ClassDump cd = new ClassDump();
        cd.setClassFilter(classFilter);
        cd.setOutputDirectory(outputDirectory);
        cd.start(args);
        cd.stop();
    }
}

