/*
 * Decompiled with CFR 0.152.
 */
package com.sun.scenario.effect.impl.sw.sse;

import com.sun.javafx.geom.Rectangle;
import com.sun.javafx.geom.transform.BaseTransform;
import com.sun.scenario.effect.Effect;
import com.sun.scenario.effect.FilterContext;
import com.sun.scenario.effect.ImageData;
import com.sun.scenario.effect.impl.HeapImage;
import com.sun.scenario.effect.impl.Renderer;
import com.sun.scenario.effect.impl.state.LinearConvolveRenderState;
import com.sun.scenario.effect.impl.sw.sse.SSEEffectPeer;
import java.nio.FloatBuffer;

public class SSELinearConvolvePeer
extends SSEEffectPeer<LinearConvolveRenderState> {
    public SSELinearConvolvePeer(FilterContext fctx, Renderer r, String uniqueName) {
        super(fctx, r, uniqueName);
    }

    @Override
    public ImageData filter(Effect effect, LinearConvolveRenderState lcrstate, BaseTransform transform, Rectangle outputClip, ImageData ... inputs) {
        this.setRenderState(lcrstate);
        Rectangle inputBounds = inputs[0].getTransformedBounds(null);
        Rectangle dstRawBounds = lcrstate.getPassResultBounds(inputBounds, null);
        Rectangle dstBounds = lcrstate.getPassResultBounds(inputBounds, outputClip);
        this.setDestBounds(dstBounds);
        int dstw = dstBounds.width;
        int dsth = dstBounds.height;
        HeapImage src = (HeapImage)inputs[0].getUntransformedImage();
        int srcw = src.getPhysicalWidth();
        int srch = src.getPhysicalHeight();
        int srcscan = src.getScanlineStride();
        int[] srcPixels = src.getPixelArray();
        Rectangle src0Bounds = inputs[0].getUntransformedBounds();
        BaseTransform src0Transform = inputs[0].getTransform();
        Rectangle src0NativeBounds = new Rectangle(0, 0, srcw, srch);
        this.setInputBounds(0, src0Bounds);
        this.setInputTransform(0, src0Transform);
        this.setInputNativeBounds(0, src0NativeBounds);
        HeapImage dst = (HeapImage)((Object)this.getRenderer().getCompatibleImage(dstw, dsth));
        this.setDestNativeBounds(dst.getPhysicalWidth(), dst.getPhysicalHeight());
        int dstscan = dst.getScanlineStride();
        int[] dstPixels = dst.getPixelArray();
        int count = lcrstate.getPassKernelSize();
        FloatBuffer weights_buf = lcrstate.getPassWeights();
        LinearConvolveRenderState.PassType type = lcrstate.getPassType();
        if (!src0Transform.isIdentity() || !dstBounds.contains(dstRawBounds.x, dstRawBounds.y)) {
            type = LinearConvolveRenderState.PassType.GENERAL_VECTOR;
        }
        if (type == LinearConvolveRenderState.PassType.HORIZONTAL_CENTERED) {
            float[] weights_arr = new float[count * 2];
            weights_buf.get(weights_arr, 0, count);
            weights_buf.rewind();
            weights_buf.get(weights_arr, count, count);
            this.filterHV(dstPixels, dstw, dsth, 1, dstscan, srcPixels, srcw, srch, 1, srcscan, weights_arr);
        } else if (type == LinearConvolveRenderState.PassType.VERTICAL_CENTERED) {
            float[] weights_arr = new float[count * 2];
            weights_buf.get(weights_arr, 0, count);
            weights_buf.rewind();
            weights_buf.get(weights_arr, count, count);
            this.filterHV(dstPixels, dsth, dstw, dstscan, 1, srcPixels, srch, srcw, srcscan, 1, weights_arr);
        } else {
            float dyrow;
            float dxrow;
            float dycol;
            float dxcol;
            float[] weights_arr = new float[count];
            weights_buf.get(weights_arr, 0, count);
            float[] srcRect = new float[8];
            int nCoords = this.getTextureCoordinates(0, srcRect, src0Bounds.x, src0Bounds.y, src0NativeBounds.width, src0NativeBounds.height, dstBounds, src0Transform);
            float srcx0 = srcRect[0] * (float)srcw;
            float srcy0 = srcRect[1] * (float)srch;
            if (nCoords < 8) {
                dxcol = (srcRect[2] - srcRect[0]) * (float)srcw / (float)dstBounds.width;
                dycol = 0.0f;
                dxrow = 0.0f;
                dyrow = (srcRect[3] - srcRect[1]) * (float)srch / (float)dstBounds.height;
            } else {
                dxcol = (srcRect[4] - srcRect[0]) * (float)srcw / (float)dstBounds.width;
                dycol = (srcRect[5] - srcRect[1]) * (float)srch / (float)dstBounds.height;
                dxrow = (srcRect[6] - srcRect[0]) * (float)srcw / (float)dstBounds.width;
                dyrow = (srcRect[7] - srcRect[1]) * (float)srch / (float)dstBounds.height;
            }
            float[] offset_arr = lcrstate.getPassVector();
            float deltax = offset_arr[0] * (float)srcw;
            float deltay = offset_arr[1] * (float)srch;
            float offsetx = offset_arr[2] * (float)srcw;
            float offsety = offset_arr[3] * (float)srch;
            this.filterVector(dstPixels, dstw, dsth, dstscan, srcPixels, srcw, srch, srcscan, weights_arr, count, srcx0, srcy0, offsetx, offsety, deltax, deltay, dxcol, dycol, dxrow, dyrow);
        }
        return new ImageData(this.getFilterContext(), dst, dstBounds);
    }

    native void filterVector(int[] var1, int var2, int var3, int var4, int[] var5, int var6, int var7, int var8, float[] var9, int var10, float var11, float var12, float var13, float var14, float var15, float var16, float var17, float var18, float var19, float var20);

    native void filterHV(int[] var1, int var2, int var3, int var4, int var5, int[] var6, int var7, int var8, int var9, int var10, float[] var11);
}

