/* Clutter
 *
 * Copyright (C) 2006, 2007, 2008  OpenedHand Ltd
 * Copyright (C) 2009, 2010  Intel Corp
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library. If not, see <http://www.gnu.org/licenses>.
 */

/*
 * Compatibility version of clutter-keysyms.h.
 *
 * Since Clutter 1.4, the key symbol defines have been changed to have
 * a KEY_ prefix. This is a compatibility header that is included when
 * deprecated symbols are enabled. Consider porting to the new names
 * instead.
 */

#ifndef __CLUTTER_KEYSYMS_DEPRECATED_H__
#define __CLUTTER_KEYSYMS_DEPRECATED_H__

#ifndef CLUTTER_DISABLE_DEPRECATED

#define CLUTTER_VoidSymbol 0xffffff CLUTTER_DEPRECATED_MACRO_FOR("Deprecated key symbol. Use CLUTTER_KEY_VoidSymbol instead.")
#define CLUTTER_BackSpace 0xff08 CLUTTER_DEPRECATED_MACRO_FOR("Deprecated key symbol. Use CLUTTER_KEY_BackSpace instead.")
#define CLUTTER_Tab 0xff09 CLUTTER_DEPRECATED_MACRO_FOR("Deprecated key symbol. Use CLUTTER_KEY_Tab instead.")
#define CLUTTER_Linefeed 0xff0a CLUTTER_DEPRECATED_MACRO_FOR("Deprecated key symbol. Use CLUTTER_KEY_Linefeed instead.")
#define CLUTTER_Clear 0xff0b CLUTTER_DEPRECATED_MACRO_FOR("Deprecated key symbol. Use CLUTTER_KEY_Clear instead.")
#define CLUTTER_Return 0xff0d CLUTTER_DEPRECATED_MACRO_FOR("Deprecated key symbol. Use CLUTTER_KEY_Return instead.")
#define CLUTTER_Pause 0xff13 CLUTTER_DEPRECATED_MACRO_FOR("Deprecated key symbol. Use CLUTTER_KEY_Pause instead.")
#define CLUTTER_Scroll_Lock 0xff14 CLUTTER_DEPRECATED_MACRO_FOR("Deprecated key symbol. Use CLUTTER_KEY_Scroll_Lock instead.")
#define CLUTTER_Sys_Req 0xff15 CLUTTER_DEPRECATED_MACRO_FOR("Deprecated key symbol. Use CLUTTER_KEY_Sys_Req instead.")
#define CLUTTER_Escape 0xff1b CLUTTER_DEPRECATED_MACRO_FOR("Deprecated key symbol. Use CLUTTER_KEY_Escape instead.")
#define CLUTTER_Delete 0xffff CLUTTER_DEPRECATED_MACRO_FOR("Deprecated key symbol. Use CLUTTER_KEY_Delete instead.")
#define CLUTTER_Multi_key 0xff20 CLUTTER_DEPRECATED_MACRO_FOR("Deprecated key symbol. Use CLUTTER_KEY_Multi_key instead.")
#define CLUTTER_Codeinput 0xff37 CLUTTER_DEPRECATED_MACRO_FOR("Deprecated key symbol. Use CLUTTER_KEY_Codeinput instead.")
#define CLUTTER_SingleCandidate 0xff3c CLUTTER_DEPRECATED_MACRO_FOR("Deprecated key symbol. Use CLUTTER_KEY_SingleCandidate instead.")
#define CLUTTER_MultipleCandidate 0xff3d CLUTTER_DEPRECATED_MACRO_FOR("Deprecated key symbol. Use CLUTTER_KEY_MultipleCandidate instead.")
#define CLUTTER_PreviousCandidate 0xff3e CLUTTER_DEPRECATED_MACRO_FOR("Deprecated key symbol. Use CLUTTER_KEY_PreviousCandidate instead.")
#define CLUTTER_Kanji 0xff21 CLUTTER_DEPRECATED_MACRO_FOR("Deprecated key symbol. Use CLUTTER_KEY_Kanji instead.")
#define CLUTTER_Muhenkan 0xff22 CLUTTER_DEPRECATED_MACRO_FOR("Deprecated key symbol. Use CLUTTER_KEY_Muhenkan instead.")
#define CLUTTER_Henkan_Mode 0xff23 CLUTTER_DEPRECATED_MACRO_FOR("Deprecated key symbol. Use CLUTTER_KEY_Henkan_Mode instead.")
#define CLUTTER_Henkan 0xff23 CLUTTER_DEPRECATED_MACRO_FOR("Deprecated key symbol. Use CLUTTER_KEY_Henkan instead.")
#define CLUTTER_Romaji 0xff24 CLUTTER_DEPRECATED_MACRO_FOR("Deprecated key symbol. Use CLUTTER_KEY_Romaji instead.")
#define CLUTTER_Hiragana 0xff25 CLUTTER_DEPRECATED_MACRO_FOR("Deprecated key symbol. Use CLUTTER_KEY_Hiragana instead.")
#define CLUTTER_Katakana 0xff26 CLUTTER_DEPRECATED_MACRO_FOR("Deprecated key symbol. Use CLUTTER_KEY_Katakana instead.")
#define CLUTTER_Hiragana_Katakana 0xff27 CLUTTER_DEPRECATED_MACRO_FOR("Deprecated key symbol. Use CLUTTER_KEY_Hiragana_Katakana instead.")
#define CLUTTER_Zenkaku 0xff28 CLUTTER_DEPRECATED_MACRO_FOR("Deprecated key symbol. Use CLUTTER_KEY_Zenkaku instead.")
#define CLUTTER_Hankaku 0xff29 CLUTTER_DEPRECATED_MACRO_FOR("Deprecated key symbol. Use CLUTTER_KEY_Hankaku instead.")
#define CLUTTER_Zenkaku_Hankaku 0xff2a CLUTTER_DEPRECATED_MACRO_FOR("Deprecated key symbol. Use CLUTTER_KEY_Zenkaku_Hankaku instead.")
#define CLUTTER_Touroku 0xff2b CLUTTER_DEPRECATED_MACRO_FOR("Deprecated key symbol. Use CLUTTER_KEY_Touroku instead.")
#define CLUTTER_Massyo 0xff2c CLUTTER_DEPRECATED_MACRO_FOR("Deprecated key symbol. Use CLUTTER_KEY_Massyo instead.")
#define CLUTTER_Kana_Lock 0xff2d CLUTTER_DEPRECATED_MACRO_FOR("Deprecated key symbol. Use CLUTTER_KEY_Kana_Lock instead.")
#define CLUTTER_Kana_Shift 0xff2e CLUTTER_DEPRECATED_MACRO_FOR("Deprecated key symbol. Use CLUTTER_KEY_Kana_Shift instead.")
#define CLUTTER_Eisu_Shift 0xff2f CLUTTER_DEPRECATED_MACRO_FOR("Deprecated key symbol. Use CLUTTER_KEY_Eisu_Shift instead.")
#define CLUTTER_Eisu_toggle 0xff30 CLUTTER_DEPRECATED_MACRO_FOR("Deprecated key symbol. Use CLUTTER_KEY_Eisu_toggle instead.")
#define CLUTTER_Kanji_Bangou 0xff37 CLUTTER_DEPRECATED_MACRO_FOR("Deprecated key symbol. Use CLUTTER_KEY_Kanji_Bangou instead.")
#define CLUTTER_Zen_Koho 0xff3d CLUTTER_DEPRECATED_MACRO_FOR("Deprecated key symbol. Use CLUTTER_KEY_Zen_Koho instead.")
#define CLUTTER_Mae_Koho 0xff3e CLUTTER_DEPRECATED_MACRO_FOR("Deprecated key symbol. Use CLUTTER_KEY_Mae_Koho instead.")
#define CLUTTER_Home 0xff50 CLUTTER_DEPRECATED_MACRO_FOR("Deprecated key symbol. Use CLUTTER_KEY_Home instead.")
#define CLUTTER_Left 0xff51 CLUTTER_DEPRECATED_MACRO_FOR("Deprecated key symbol. Use CLUTTER_KEY_Left instead.")
#define CLUTTER_Up 0xff52 CLUTTER_DEPRECATED_MACRO_FOR("Deprecated key symbol. Use CLUTTER_KEY_Up instead.")
#define CLUTTER_Right 0xff53 CLUTTER_DEPRECATED_MACRO_FOR("Deprecated key symbol. Use CLUTTER_KEY_Right instead.")
#define CLUTTER_Down 0xff54 CLUTTER_DEPRECATED_MACRO_FOR("Deprecated key symbol. Use CLUTTER_KEY_Down instead.")
#define CLUTTER_Prior 0xff55 CLUTTER_DEPRECATED_MACRO_FOR("Deprecated key symbol. Use CLUTTER_KEY_Prior instead.")
#define CLUTTER_Page_Up 0xff55 CLUTTER_DEPRECATED_MACRO_FOR("Deprecated key symbol. Use CLUTTER_KEY_Page_Up instead.")
#define CLUTTER_Next 0xff56 CLUTTER_DEPRECATED_MACRO_FOR("Deprecated key symbol. Use CLUTTER_KEY_Next instead.")
#define CLUTTER_Page_Down 0xff56 CLUTTER_DEPRECATED_MACRO_FOR("Deprecated key symbol. Use CLUTTER_KEY_Page_Down instead.")
#define CLUTTER_End 0xff57 CLUTTER_DEPRECATED_MACRO_FOR("Deprecated key symbol. Use CLUTTER_KEY_End instead.")
#define CLUTTER_Begin 0xff58 CLUTTER_DEPRECATED_MACRO_FOR("Deprecated key symbol. Use CLUTTER_KEY_Begin instead.")
#define CLUTTER_Select 0xff60 CLUTTER_DEPRECATED_MACRO_FOR("Deprecated key symbol. Use CLUTTER_KEY_Select instead.")
#define CLUTTER_Print 0xff61 CLUTTER_DEPRECATED_MACRO_FOR("Deprecated key symbol. Use CLUTTER_KEY_Print instead.")
#define CLUTTER_Execute 0xff62 CLUTTER_DEPRECATED_MACRO_FOR("Deprecated key symbol. Use CLUTTER_KEY_Execute instead.")
#define CLUTTER_Insert 0xff63 CLUTTER_DEPRECATED_MACRO_FOR("Deprecated key symbol. Use CLUTTER_KEY_Insert instead.")
#define CLUTTER_Undo 0xff65 CLUTTER_DEPRECATED_MACRO_FOR("Deprecated key symbol. Use CLUTTER_KEY_Undo instead.")
#define CLUTTER_Redo 0xff66 CLUTTER_DEPRECATED_MACRO_FOR("Deprecated key symbol. Use CLUTTER_KEY_Redo instead.")
#define CLUTTER_Menu 0xff67 CLUTTER_DEPRECATED_MACRO_FOR("Deprecated key symbol. Use CLUTTER_KEY_Menu instead.")
#define CLUTTER_Find 0xff68 CLUTTER_DEPRECATED_MACRO_FOR("Deprecated key symbol. Use CLUTTER_KEY_Find instead.")
#define CLUTTER_Cancel 0xff69 CLUTTER_DEPRECATED_MACRO_FOR("Deprecated key symbol. Use CLUTTER_KEY_Cancel instead.")
#define CLUTTER_Help 0xff6a CLUTTER_DEPRECATED_MACRO_FOR("Deprecated key symbol. Use CLUTTER_KEY_Help instead.")
#define CLUTTER_Break 0xff6b CLUTTER_DEPRECATED_MACRO_FOR("Deprecated key symbol. Use CLUTTER_KEY_Break instead.")
#define CLUTTER_Mode_switch 0xff7e CLUTTER_DEPRECATED_MACRO_FOR("Deprecated key symbol. Use CLUTTER_KEY_Mode_switch instead.")
#define CLUTTER_script_switch 0xff7e CLUTTER_DEPRECATED_MACRO_FOR("Deprecated key symbol. Use CLUTTER_KEY_script_switch instead.")
#define CLUTTER_Num_Lock 0xff7f CLUTTER_DEPRECATED_MACRO_FOR("Deprecated key symbol. Use CLUTTER_KEY_Num_Lock instead.")
#define CLUTTER_KP_Space 0xff80 CLUTTER_DEPRECATED_MACRO_FOR("Deprecated key symbol. Use CLUTTER_KEY_KP_Space instead.")
#define CLUTTER_KP_Tab 0xff89 CLUTTER_DEPRECATED_MACRO_FOR("Deprecated key symbol. Use CLUTTER_KEY_KP_Tab instead.")
#define CLUTTER_KP_Enter 0xff8d CLUTTER_DEPRECATED_MACRO_FOR("Deprecated key symbol. Use CLUTTER_KEY_KP_Enter instead.")
#define CLUTTER_KP_F1 0xff91 CLUTTER_DEPRECATED_MACRO_FOR("Deprecated key symbol. Use CLUTTER_KEY_KP_F1 instead.")
#define CLUTTER_KP_F2 0xff92 CLUTTER_DEPRECATED_MACRO_FOR("Deprecated key symbol. Use CLUTTER_KEY_KP_F2 instead.")
#define CLUTTER_KP_F3 0xff93 CLUTTER_DEPRECATED_MACRO_FOR("Deprecated key symbol. Use CLUTTER_KEY_KP_F3 instead.")
#define CLUTTER_KP_F4 0xff94 CLUTTER_DEPRECATED_MACRO_FOR("Deprecated key symbol. Use CLUTTER_KEY_KP_F4 instead.")
#define CLUTTER_KP_Home 0xff95 CLUTTER_DEPRECATED_MACRO_FOR("Deprecated key symbol. Use CLUTTER_KEY_KP_Home instead.")
#define CLUTTER_KP_Left 0xff96 CLUTTER_DEPRECATED_MACRO_FOR("Deprecated key symbol. Use CLUTTER_KEY_KP_Left instead.")
#define CLUTTER_KP_Up 0xff97 CLUTTER_DEPRECATED_MACRO_FOR("Deprecated key symbol. Use CLUTTER_KEY_KP_Up instead.")
#define CLUTTER_KP_Right 0xff98 CLUTTER_DEPRECATED_MACRO_FOR("Deprecated key symbol. Use CLUTTER_KEY_KP_Right instead.")
#define CLUTTER_KP_Down 0xff99 CLUTTER_DEPRECATED_MACRO_FOR("Deprecated key symbol. Use CLUTTER_KEY_KP_Down instead.")
#define CLUTTER_KP_Prior 0xff9a CLUTTER_DEPRECATED_MACRO_FOR("Deprecated key symbol. Use CLUTTER_KEY_KP_Prior instead.")
#define CLUTTER_KP_Page_Up 0xff9a CLUTTER_DEPRECATED_MACRO_FOR("Deprecated key symbol. Use CLUTTER_KEY_KP_Page_Up instead.")
#define CLUTTER_KP_Next 0xff9b CLUTTER_DEPRECATED_MACRO_FOR("Deprecated key symbol. Use CLUTTER_KEY_KP_Next instead.")
#define CLUTTER_KP_Page_Down 0xff9b CLUTTER_DEPRECATED_MACRO_FOR("Deprecated key symbol. Use CLUTTER_KEY_KP_Page_Down instead.")
#define CLUTTER_KP_End 0xff9c CLUTTER_DEPRECATED_MACRO_FOR("Deprecated key symbol. Use CLUTTER_KEY_KP_End instead.")
#define CLUTTER_KP_Begin 0xff9d CLUTTER_DEPRECATED_MACRO_FOR("Deprecated key symbol. Use CLUTTER_KEY_KP_Begin instead.")
#define CLUTTER_KP_Insert 0xff9e CLUTTER_DEPRECATED_MACRO_FOR("Deprecated key symbol. Use CLUTTER_KEY_KP_Insert instead.")
#define CLUTTER_KP_Delete 0xff9f CLUTTER_DEPRECATED_MACRO_FOR("Deprecated key symbol. Use CLUTTER_KEY_KP_Delete instead.")
#define CLUTTER_KP_Equal 0xffbd CLUTTER_DEPRECATED_MACRO_FOR("Deprecated key symbol. Use CLUTTER_KEY_KP_Equal instead.")
#define CLUTTER_KP_Multiply 0xffaa CLUTTER_DEPRECATED_MACRO_FOR("Deprecated key symbol. Use CLUTTER_KEY_KP_Multiply instead.")
#define CLUTTER_KP_Add 0xffab CLUTTER_DEPRECATED_MACRO_FOR("Deprecated key symbol. Use CLUTTER_KEY_KP_Add instead.")
#define CLUTTER_KP_Separator 0xffac CLUTTER_DEPRECATED_MACRO_FOR("Deprecated key symbol. Use CLUTTER_KEY_KP_Separator instead.")
#define CLUTTER_KP_Subtract 0xffad CLUTTER_DEPRECATED_MACRO_FOR("Deprecated key symbol. Use CLUTTER_KEY_KP_Subtract instead.")
#define CLUTTER_KP_Decimal 0xffae CLUTTER_DEPRECATED_MACRO_FOR("Deprecated key symbol. Use CLUTTER_KEY_KP_Decimal instead.")
#define CLUTTER_KP_Divide 0xffaf CLUTTER_DEPRECATED_MACRO_FOR("Deprecated key symbol. Use CLUTTER_KEY_KP_Divide instead.")
#define CLUTTER_KP_0 0xffb0 CLUTTER_DEPRECATED_MACRO_FOR("Deprecated key symbol. Use CLUTTER_KEY_KP_0 instead.")
#define CLUTTER_KP_1 0xffb1 CLUTTER_DEPRECATED_MACRO_FOR("Deprecated key symbol. Use CLUTTER_KEY_KP_1 instead.")
#define CLUTTER_KP_2 0xffb2 CLUTTER_DEPRECATED_MACRO_FOR("Deprecated key symbol. Use CLUTTER_KEY_KP_2 instead.")
#define CLUTTER_KP_3 0xffb3 CLUTTER_DEPRECATED_MACRO_FOR("Deprecated key symbol. Use CLUTTER_KEY_KP_3 instead.")
#define CLUTTER_KP_4 0xffb4 CLUTTER_DEPRECATED_MACRO_FOR("Deprecated key symbol. Use CLUTTER_KEY_KP_4 instead.")
#define CLUTTER_KP_5 0xffb5 CLUTTER_DEPRECATED_MACRO_FOR("Deprecated key symbol. Use CLUTTER_KEY_KP_5 instead.")
#define CLUTTER_KP_6 0xffb6 CLUTTER_DEPRECATED_MACRO_FOR("Deprecated key symbol. Use CLUTTER_KEY_KP_6 instead.")
#define CLUTTER_KP_7 0xffb7 CLUTTER_DEPRECATED_MACRO_FOR("Deprecated key symbol. Use CLUTTER_KEY_KP_7 instead.")
#define CLUTTER_KP_8 0xffb8 CLUTTER_DEPRECATED_MACRO_FOR("Deprecated key symbol. Use CLUTTER_KEY_KP_8 instead.")
#define CLUTTER_KP_9 0xffb9 CLUTTER_DEPRECATED_MACRO_FOR("Deprecated key symbol. Use CLUTTER_KEY_KP_9 instead.")
#define CLUTTER_F1 0xffbe CLUTTER_DEPRECATED_MACRO_FOR("Deprecated key symbol. Use CLUTTER_KEY_F1 instead.")
#define CLUTTER_F2 0xffbf CLUTTER_DEPRECATED_MACRO_FOR("Deprecated key symbol. Use CLUTTER_KEY_F2 instead.")
#define CLUTTER_F3 0xffc0 CLUTTER_DEPRECATED_MACRO_FOR("Deprecated key symbol. Use CLUTTER_KEY_F3 instead.")
#define CLUTTER_F4 0xffc1 CLUTTER_DEPRECATED_MACRO_FOR("Deprecated key symbol. Use CLUTTER_KEY_F4 instead.")
#define CLUTTER_F5 0xffc2 CLUTTER_DEPRECATED_MACRO_FOR("Deprecated key symbol. Use CLUTTER_KEY_F5 instead.")
#define CLUTTER_F6 0xffc3 CLUTTER_DEPRECATED_MACRO_FOR("Deprecated key symbol. Use CLUTTER_KEY_F6 instead.")
#define CLUTTER_F7 0xffc4 CLUTTER_DEPRECATED_MACRO_FOR("Deprecated key symbol. Use CLUTTER_KEY_F7 instead.")
#define CLUTTER_F8 0xffc5 CLUTTER_DEPRECATED_MACRO_FOR("Deprecated key symbol. Use CLUTTER_KEY_F8 instead.")
#define CLUTTER_F9 0xffc6 CLUTTER_DEPRECATED_MACRO_FOR("Deprecated key symbol. Use CLUTTER_KEY_F9 instead.")
#define CLUTTER_F10 0xffc7 CLUTTER_DEPRECATED_MACRO_FOR("Deprecated key symbol. Use CLUTTER_KEY_F10 instead.")
#define CLUTTER_F11 0xffc8 CLUTTER_DEPRECATED_MACRO_FOR("Deprecated key symbol. Use CLUTTER_KEY_F11 instead.")
#define CLUTTER_L1 0xffc8 CLUTTER_DEPRECATED_MACRO_FOR("Deprecated key symbol. Use CLUTTER_KEY_L1 instead.")
#define CLUTTER_F12 0xffc9 CLUTTER_DEPRECATED_MACRO_FOR("Deprecated key symbol. Use CLUTTER_KEY_F12 instead.")
#define CLUTTER_L2 0xffc9 CLUTTER_DEPRECATED_MACRO_FOR("Deprecated key symbol. Use CLUTTER_KEY_L2 instead.")
#define CLUTTER_F13 0xffca CLUTTER_DEPRECATED_MACRO_FOR("Deprecated key symbol. Use CLUTTER_KEY_F13 instead.")
#define CLUTTER_L3 0xffca CLUTTER_DEPRECATED_MACRO_FOR("Deprecated key symbol. Use CLUTTER_KEY_L3 instead.")
#define CLUTTER_F14 0xffcb CLUTTER_DEPRECATED_MACRO_FOR("Deprecated key symbol. Use CLUTTER_KEY_F14 instead.")
#define CLUTTER_L4 0xffcb CLUTTER_DEPRECATED_MACRO_FOR("Deprecated key symbol. Use CLUTTER_KEY_L4 instead.")
#define CLUTTER_F15 0xffcc CLUTTER_DEPRECATED_MACRO_FOR("Deprecated key symbol. Use CLUTTER_KEY_F15 instead.")
#define CLUTTER_L5 0xffcc CLUTTER_DEPRECATED_MACRO_FOR("Deprecated key symbol. Use CLUTTER_KEY_L5 instead.")
#define CLUTTER_F16 0xffcd CLUTTER_DEPRECATED_MACRO_FOR("Deprecated key symbol. Use CLUTTER_KEY_F16 instead.")
#define CLUTTER_L6 0xffcd CLUTTER_DEPRECATED_MACRO_FOR("Deprecated key symbol. Use CLUTTER_KEY_L6 instead.")
#define CLUTTER_F17 0xffce CLUTTER_DEPRECATED_MACRO_FOR("Deprecated key symbol. Use CLUTTER_KEY_F17 instead.")
#define CLUTTER_L7 0xffce CLUTTER_DEPRECATED_MACRO_FOR("Deprecated key symbol. Use CLUTTER_KEY_L7 instead.")
#define CLUTTER_F18 0xffcf CLUTTER_DEPRECATED_MACRO_FOR("Deprecated key symbol. Use CLUTTER_KEY_F18 instead.")
#define CLUTTER_L8 0xffcf CLUTTER_DEPRECATED_MACRO_FOR("Deprecated key symbol. Use CLUTTER_KEY_L8 instead.")
#define CLUTTER_F19 0xffd0 CLUTTER_DEPRECATED_MACRO_FOR("Deprecated key symbol. Use CLUTTER_KEY_F19 instead.")
#define CLUTTER_L9 0xffd0 CLUTTER_DEPRECATED_MACRO_FOR("Deprecated key symbol. Use CLUTTER_KEY_L9 instead.")
#define CLUTTER_F20 0xffd1 CLUTTER_DEPRECATED_MACRO_FOR("Deprecated key symbol. Use CLUTTER_KEY_F20 instead.")
#define CLUTTER_L10 0xffd1 CLUTTER_DEPRECATED_MACRO_FOR("Deprecated key symbol. Use CLUTTER_KEY_L10 instead.")
#define CLUTTER_F21 0xffd2 CLUTTER_DEPRECATED_MACRO_FOR("Deprecated key symbol. Use CLUTTER_KEY_F21 instead.")
#define CLUTTER_R1 0xffd2 CLUTTER_DEPRECATED_MACRO_FOR("Deprecated key symbol. Use CLUTTER_KEY_R1 instead.")
#define CLUTTER_F22 0xffd3 CLUTTER_DEPRECATED_MACRO_FOR("Deprecated key symbol. Use CLUTTER_KEY_F22 instead.")
#define CLUTTER_R2 0xffd3 CLUTTER_DEPRECATED_MACRO_FOR("Deprecated key symbol. Use CLUTTER_KEY_R2 instead.")
#define CLUTTER_F23 0xffd4 CLUTTER_DEPRECATED_MACRO_FOR("Deprecated key symbol. Use CLUTTER_KEY_F23 instead.")
#define CLUTTER_R3 0xffd4 CLUTTER_DEPRECATED_MACRO_FOR("Deprecated key symbol. Use CLUTTER_KEY_R3 instead.")
#define CLUTTER_F24 0xffd5 CLUTTER_DEPRECATED_MACRO_FOR("Deprecated key symbol. Use CLUTTER_KEY_F24 instead.")
#define CLUTTER_R4 0xffd5 CLUTTER_DEPRECATED_MACRO_FOR("Deprecated key symbol. Use CLUTTER_KEY_R4 instead.")
#define CLUTTER_F25 0xffd6 CLUTTER_DEPRECATED_MACRO_FOR("Deprecated key symbol. Use CLUTTER_KEY_F25 instead.")
#define CLUTTER_R5 0xffd6 CLUTTER_DEPRECATED_MACRO_FOR("Deprecated key symbol. Use CLUTTER_KEY_R5 instead.")
#define CLUTTER_F26 0xffd7 CLUTTER_DEPRECATED_MACRO_FOR("Deprecated key symbol. Use CLUTTER_KEY_F26 instead.")
#define CLUTTER_R6 0xffd7 CLUTTER_DEPRECATED_MACRO_FOR("Deprecated key symbol. Use CLUTTER_KEY_R6 instead.")
#define CLUTTER_F27 0xffd8 CLUTTER_DEPRECATED_MACRO_FOR("Deprecated key symbol. Use CLUTTER_KEY_F27 instead.")
#define CLUTTER_R7 0xffd8 CLUTTER_DEPRECATED_MACRO_FOR("Deprecated key symbol. Use CLUTTER_KEY_R7 instead.")
#define CLUTTER_F28 0xffd9 CLUTTER_DEPRECATED_MACRO_FOR("Deprecated key symbol. Use CLUTTER_KEY_F28 instead.")
#define CLUTTER_R8 0xffd9 CLUTTER_DEPRECATED_MACRO_FOR("Deprecated key symbol. Use CLUTTER_KEY_R8 instead.")
#define CLUTTER_F29 0xffda CLUTTER_DEPRECATED_MACRO_FOR("Deprecated key symbol. Use CLUTTER_KEY_F29 instead.")
#define CLUTTER_R9 0xffda CLUTTER_DEPRECATED_MACRO_FOR("Deprecated key symbol. Use CLUTTER_KEY_R9 instead.")
#define CLUTTER_F30 0xffdb CLUTTER_DEPRECATED_MACRO_FOR("Deprecated key symbol. Use CLUTTER_KEY_F30 instead.")
#define CLUTTER_R10 0xffdb CLUTTER_DEPRECATED_MACRO_FOR("Deprecated key symbol. Use CLUTTER_KEY_R10 instead.")
#define CLUTTER_F31 0xffdc CLUTTER_DEPRECATED_MACRO_FOR("Deprecated key symbol. Use CLUTTER_KEY_F31 instead.")
#define CLUTTER_R11 0xffdc CLUTTER_DEPRECATED_MACRO_FOR("Deprecated key symbol. Use CLUTTER_KEY_R11 instead.")
#define CLUTTER_F32 0xffdd CLUTTER_DEPRECATED_MACRO_FOR("Deprecated key symbol. Use CLUTTER_KEY_F32 instead.")
#define CLUTTER_R12 0xffdd CLUTTER_DEPRECATED_MACRO_FOR("Deprecated key symbol. Use CLUTTER_KEY_R12 instead.")
#define CLUTTER_F33 0xffde CLUTTER_DEPRECATED_MACRO_FOR("Deprecated key symbol. Use CLUTTER_KEY_F33 instead.")
#define CLUTTER_R13 0xffde CLUTTER_DEPRECATED_MACRO_FOR("Deprecated key symbol. Use CLUTTER_KEY_R13 instead.")
#define CLUTTER_F34 0xffdf CLUTTER_DEPRECATED_MACRO_FOR("Deprecated key symbol. Use CLUTTER_KEY_F34 instead.")
#define CLUTTER_R14 0xffdf CLUTTER_DEPRECATED_MACRO_FOR("Deprecated key symbol. Use CLUTTER_KEY_R14 instead.")
#define CLUTTER_F35 0xffe0 CLUTTER_DEPRECATED_MACRO_FOR("Deprecated key symbol. Use CLUTTER_KEY_F35 instead.")
#define CLUTTER_R15 0xffe0 CLUTTER_DEPRECATED_MACRO_FOR("Deprecated key symbol. Use CLUTTER_KEY_R15 instead.")
#define CLUTTER_Shift_L 0xffe1 CLUTTER_DEPRECATED_MACRO_FOR("Deprecated key symbol. Use CLUTTER_KEY_Shift_L instead.")
#define CLUTTER_Shift_R 0xffe2 CLUTTER_DEPRECATED_MACRO_FOR("Deprecated key symbol. Use CLUTTER_KEY_Shift_R instead.")
#define CLUTTER_Control_L 0xffe3 CLUTTER_DEPRECATED_MACRO_FOR("Deprecated key symbol. Use CLUTTER_KEY_Control_L instead.")
#define CLUTTER_Control_R 0xffe4 CLUTTER_DEPRECATED_MACRO_FOR("Deprecated key symbol. Use CLUTTER_KEY_Control_R instead.")
#define CLUTTER_Caps_Lock 0xffe5 CLUTTER_DEPRECATED_MACRO_FOR("Deprecated key symbol. Use CLUTTER_KEY_Caps_Lock instead.")
#define CLUTTER_Shift_Lock 0xffe6 CLUTTER_DEPRECATED_MACRO_FOR("Deprecated key symbol. Use CLUTTER_KEY_Shift_Lock instead.")
#define CLUTTER_Meta_L 0xffe7 CLUTTER_DEPRECATED_MACRO_FOR("Deprecated key symbol. Use CLUTTER_KEY_Meta_L instead.")
#define CLUTTER_Meta_R 0xffe8 CLUTTER_DEPRECATED_MACRO_FOR("Deprecated key symbol. Use CLUTTER_KEY_Meta_R instead.")
#define CLUTTER_Alt_L 0xffe9 CLUTTER_DEPRECATED_MACRO_FOR("Deprecated key symbol. Use CLUTTER_KEY_Alt_L instead.")
#define CLUTTER_Alt_R 0xffea CLUTTER_DEPRECATED_MACRO_FOR("Deprecated key symbol. Use CLUTTER_KEY_Alt_R instead.")
#define CLUTTER_Super_L 0xffeb CLUTTER_DEPRECATED_MACRO_FOR("Deprecated key symbol. Use CLUTTER_KEY_Super_L instead.")
#define CLUTTER_Super_R 0xffec CLUTTER_DEPRECATED_MACRO_FOR("Deprecated key symbol. Use CLUTTER_KEY_Super_R instead.")
#define CLUTTER_Hyper_L 0xffed CLUTTER_DEPRECATED_MACRO_FOR("Deprecated key symbol. Use CLUTTER_KEY_Hyper_L instead.")
#define CLUTTER_Hyper_R 0xffee CLUTTER_DEPRECATED_MACRO_FOR("Deprecated key symbol. Use CLUTTER_KEY_Hyper_R instead.")
#define CLUTTER_ISO_Lock 0xfe01 CLUTTER_DEPRECATED_MACRO_FOR("Deprecated key symbol. Use CLUTTER_KEY_ISO_Lock instead.")
#define CLUTTER_ISO_Level2_Latch 0xfe02 CLUTTER_DEPRECATED_MACRO_FOR("Deprecated key symbol. Use CLUTTER_KEY_ISO_Level2_Latch instead.")
#define CLUTTER_ISO_Level3_Shift 0xfe03 CLUTTER_DEPRECATED_MACRO_FOR("Deprecated key symbol. Use CLUTTER_KEY_ISO_Level3_Shift instead.")
#define CLUTTER_ISO_Level3_Latch 0xfe04 CLUTTER_DEPRECATED_MACRO_FOR("Deprecated key symbol. Use CLUTTER_KEY_ISO_Level3_Latch instead.")
#define CLUTTER_ISO_Level3_Lock 0xfe05 CLUTTER_DEPRECATED_MACRO_FOR("Deprecated key symbol. Use CLUTTER_KEY_ISO_Level3_Lock instead.")
#define CLUTTER_ISO_Level5_Shift 0xfe11 CLUTTER_DEPRECATED_MACRO_FOR("Deprecated key symbol. Use CLUTTER_KEY_ISO_Level5_Shift instead.")
#define CLUTTER_ISO_Level5_Latch 0xfe12 CLUTTER_DEPRECATED_MACRO_FOR("Deprecated key symbol. Use CLUTTER_KEY_ISO_Level5_Latch instead.")
#define CLUTTER_ISO_Level5_Lock 0xfe13 CLUTTER_DEPRECATED_MACRO_FOR("Deprecated key symbol. Use CLUTTER_KEY_ISO_Level5_Lock instead.")
#define CLUTTER_ISO_Group_Shift 0xff7e CLUTTER_DEPRECATED_MACRO_FOR("Deprecated key symbol. Use CLUTTER_KEY_ISO_Group_Shift instead.")
#define CLUTTER_ISO_Group_Latch 0xfe06 CLUTTER_DEPRECATED_MACRO_FOR("Deprecated key symbol. Use CLUTTER_KEY_ISO_Group_Latch instead.")
#define CLUTTER_ISO_Group_Lock 0xfe07 CLUTTER_DEPRECATED_MACRO_FOR("Deprecated key symbol. Use CLUTTER_KEY_ISO_Group_Lock instead.")
#define CLUTTER_ISO_Next_Group 0xfe08 CLUTTER_DEPRECATED_MACRO_FOR("Deprecated key symbol. Use CLUTTER_KEY_ISO_Next_Group instead.")
#define CLUTTER_ISO_Next_Group_Lock 0xfe09 CLUTTER_DEPRECATED_MACRO_FOR("Deprecated key symbol. Use CLUTTER_KEY_ISO_Next_Group_Lock instead.")
#define CLUTTER_ISO_Prev_Group 0xfe0a CLUTTER_DEPRECATED_MACRO_FOR("Deprecated key symbol. Use CLUTTER_KEY_ISO_Prev_Group instead.")
#define CLUTTER_ISO_Prev_Group_Lock 0xfe0b CLUTTER_DEPRECATED_MACRO_FOR("Deprecated key symbol. Use CLUTTER_KEY_ISO_Prev_Group_Lock instead.")
#define CLUTTER_ISO_First_Group 0xfe0c CLUTTER_DEPRECATED_MACRO_FOR("Deprecated key symbol. Use CLUTTER_KEY_ISO_First_Group instead.")
#define CLUTTER_ISO_First_Group_Lock 0xfe0d CLUTTER_DEPRECATED_MACRO_FOR("Deprecated key symbol. Use CLUTTER_KEY_ISO_First_Group_Lock instead.")
#define CLUTTER_ISO_Last_Group 0xfe0e CLUTTER_DEPRECATED_MACRO_FOR("Deprecated key symbol. Use CLUTTER_KEY_ISO_Last_Group instead.")
#define CLUTTER_ISO_Last_Group_Lock 0xfe0f CLUTTER_DEPRECATED_MACRO_FOR("Deprecated key symbol. Use CLUTTER_KEY_ISO_Last_Group_Lock instead.")
#define CLUTTER_ISO_Left_Tab 0xfe20 CLUTTER_DEPRECATED_MACRO_FOR("Deprecated key symbol. Use CLUTTER_KEY_ISO_Left_Tab instead.")
#define CLUTTER_ISO_Move_Line_Up 0xfe21 CLUTTER_DEPRECATED_MACRO_FOR("Deprecated key symbol. Use CLUTTER_KEY_ISO_Move_Line_Up instead.")
#define CLUTTER_ISO_Move_Line_Down 0xfe22 CLUTTER_DEPRECATED_MACRO_FOR("Deprecated key symbol. Use CLUTTER_KEY_ISO_Move_Line_Down instead.")
#define CLUTTER_ISO_Partial_Line_Up 0xfe23 CLUTTER_DEPRECATED_MACRO_FOR("Deprecated key symbol. Use CLUTTER_KEY_ISO_Partial_Line_Up instead.")
#define CLUTTER_ISO_Partial_Line_Down 0xfe24 CLUTTER_DEPRECATED_MACRO_FOR("Deprecated key symbol. Use CLUTTER_KEY_ISO_Partial_Line_Down instead.")
#define CLUTTER_ISO_Partial_Space_Left 0xfe25 CLUTTER_DEPRECATED_MACRO_FOR("Deprecated key symbol. Use CLUTTER_KEY_ISO_Partial_Space_Left instead.")
#define CLUTTER_ISO_Partial_Space_Right 0xfe26 CLUTTER_DEPRECATED_MACRO_FOR("Deprecated key symbol. Use CLUTTER_KEY_ISO_Partial_Space_Right instead.")
#define CLUTTER_ISO_Set_Margin_Left 0xfe27 CLUTTER_DEPRECATED_MACRO_FOR("Deprecated key symbol. Use CLUTTER_KEY_ISO_Set_Margin_Left instead.")
#define CLUTTER_ISO_Set_Margin_Right 0xfe28 CLUTTER_DEPRECATED_MACRO_FOR("Deprecated key symbol. Use CLUTTER_KEY_ISO_Set_Margin_Right instead.")
#define CLUTTER_ISO_Release_Margin_Left 0xfe29 CLUTTER_DEPRECATED_MACRO_FOR("Deprecated key symbol. Use CLUTTER_KEY_ISO_Release_Margin_Left instead.")
#define CLUTTER_ISO_Release_Margin_Right 0xfe2a CLUTTER_DEPRECATED_MACRO_FOR("Deprecated key symbol. Use CLUTTER_KEY_ISO_Release_Margin_Right instead.")
#define CLUTTER_ISO_Release_Both_Margins 0xfe2b CLUTTER_DEPRECATED_MACRO_FOR("Deprecated key symbol. Use CLUTTER_KEY_ISO_Release_Both_Margins instead.")
#define CLUTTER_ISO_Fast_Cursor_Left 0xfe2c CLUTTER_DEPRECATED_MACRO_FOR("Deprecated key symbol. Use CLUTTER_KEY_ISO_Fast_Cursor_Left instead.")
#define CLUTTER_ISO_Fast_Cursor_Right 0xfe2d CLUTTER_DEPRECATED_MACRO_FOR("Deprecated key symbol. Use CLUTTER_KEY_ISO_Fast_Cursor_Right instead.")
#define CLUTTER_ISO_Fast_Cursor_Up 0xfe2e CLUTTER_DEPRECATED_MACRO_FOR("Deprecated key symbol. Use CLUTTER_KEY_ISO_Fast_Cursor_Up instead.")
#define CLUTTER_ISO_Fast_Cursor_Down 0xfe2f CLUTTER_DEPRECATED_MACRO_FOR("Deprecated key symbol. Use CLUTTER_KEY_ISO_Fast_Cursor_Down instead.")
#define CLUTTER_ISO_Continuous_Underline 0xfe30 CLUTTER_DEPRECATED_MACRO_FOR("Deprecated key symbol. Use CLUTTER_KEY_ISO_Continuous_Underline instead.")
#define CLUTTER_ISO_Discontinuous_Underline 0xfe31 CLUTTER_DEPRECATED_MACRO_FOR("Deprecated key symbol. Use CLUTTER_KEY_ISO_Discontinuous_Underline instead.")
#define CLUTTER_ISO_Emphasize 0xfe32 CLUTTER_DEPRECATED_MACRO_FOR("Deprecated key symbol. Use CLUTTER_KEY_ISO_Emphasize instead.")
#define CLUTTER_ISO_Center_Object 0xfe33 CLUTTER_DEPRECATED_MACRO_FOR("Deprecated key symbol. Use CLUTTER_KEY_ISO_Center_Object instead.")
#define CLUTTER_ISO_Enter 0xfe34 CLUTTER_DEPRECATED_MACRO_FOR("Deprecated key symbol. Use CLUTTER_KEY_ISO_Enter instead.")
#define CLUTTER_dead_grave 0xfe50 CLUTTER_DEPRECATED_MACRO_FOR("Deprecated key symbol. Use CLUTTER_KEY_dead_grave instead.")
#define CLUTTER_dead_acute 0xfe51 CLUTTER_DEPRECATED_MACRO_FOR("Deprecated key symbol. Use CLUTTER_KEY_dead_acute instead.")
#define CLUTTER_dead_circumflex 0xfe52 CLUTTER_DEPRECATED_MACRO_FOR("Deprecated key symbol. Use CLUTTER_KEY_dead_circumflex instead.")
#define CLUTTER_dead_tilde 0xfe53 CLUTTER_DEPRECATED_MACRO_FOR("Deprecated key symbol. Use CLUTTER_KEY_dead_tilde instead.")
#define CLUTTER_dead_perispomeni 0xfe53 CLUTTER_DEPRECATED_MACRO_FOR("Deprecated key symbol. Use CLUTTER_KEY_dead_perispomeni instead.")
#define CLUTTER_dead_macron 0xfe54 CLUTTER_DEPRECATED_MACRO_FOR("Deprecated key symbol. Use CLUTTER_KEY_dead_macron instead.")
#define CLUTTER_dead_breve 0xfe55 CLUTTER_DEPRECATED_MACRO_FOR("Deprecated key symbol. Use CLUTTER_KEY_dead_breve instead.")
#define CLUTTER_dead_abovedot 0xfe56 CLUTTER_DEPRECATED_MACRO_FOR("Deprecated key symbol. Use CLUTTER_KEY_dead_abovedot instead.")
#define CLUTTER_dead_diaeresis 0xfe57 CLUTTER_DEPRECATED_MACRO_FOR("Deprecated key symbol. Use CLUTTER_KEY_dead_diaeresis instead.")
#define CLUTTER_dead_abovering 0xfe58 CLUTTER_DEPRECATED_MACRO_FOR("Deprecated key symbol. Use CLUTTER_KEY_dead_abovering instead.")
#define CLUTTER_dead_doubleacute 0xfe59 CLUTTER_DEPRECATED_MACRO_FOR("Deprecated key symbol. Use CLUTTER_KEY_dead_doubleacute instead.")
#define CLUTTER_dead_caron 0xfe5a CLUTTER_DEPRECATED_MACRO_FOR("Deprecated key symbol. Use CLUTTER_KEY_dead_caron instead.")
#define CLUTTER_dead_cedilla 0xfe5b CLUTTER_DEPRECATED_MACRO_FOR("Deprecated key symbol. Use CLUTTER_KEY_dead_cedilla instead.")
#define CLUTTER_dead_ogonek 0xfe5c CLUTTER_DEPRECATED_MACRO_FOR("Deprecated key symbol. Use CLUTTER_KEY_dead_ogonek instead.")
#define CLUTTER_dead_iota 0xfe5d CLUTTER_DEPRECATED_MACRO_FOR("Deprecated key symbol. Use CLUTTER_KEY_dead_iota instead.")
#define CLUTTER_dead_voiced_sound 0xfe5e CLUTTER_DEPRECATED_MACRO_FOR("Deprecated key symbol. Use CLUTTER_KEY_dead_voiced_sound instead.")
#define CLUTTER_dead_semivoiced_sound 0xfe5f CLUTTER_DEPRECATED_MACRO_FOR("Deprecated key symbol. Use CLUTTER_KEY_dead_semivoiced_sound instead.")
#define CLUTTER_dead_belowdot 0xfe60 CLUTTER_DEPRECATED_MACRO_FOR("Deprecated key symbol. Use CLUTTER_KEY_dead_belowdot instead.")
#define CLUTTER_dead_hook 0xfe61 CLUTTER_DEPRECATED_MACRO_FOR("Deprecated key symbol. Use CLUTTER_KEY_dead_hook instead.")
#define CLUTTER_dead_horn 0xfe62 CLUTTER_DEPRECATED_MACRO_FOR("Deprecated key symbol. Use CLUTTER_KEY_dead_horn instead.")
#define CLUTTER_dead_stroke 0xfe63 CLUTTER_DEPRECATED_MACRO_FOR("Deprecated key symbol. Use CLUTTER_KEY_dead_stroke instead.")
#define CLUTTER_dead_abovecomma 0xfe64 CLUTTER_DEPRECATED_MACRO_FOR("Deprecated key symbol. Use CLUTTER_KEY_dead_abovecomma instead.")
#define CLUTTER_dead_psili 0xfe64 CLUTTER_DEPRECATED_MACRO_FOR("Deprecated key symbol. Use CLUTTER_KEY_dead_psili instead.")
#define CLUTTER_dead_abovereversedcomma 0xfe65 CLUTTER_DEPRECATED_MACRO_FOR("Deprecated key symbol. Use CLUTTER_KEY_dead_abovereversedcomma instead.")
#define CLUTTER_dead_dasia 0xfe65 CLUTTER_DEPRECATED_MACRO_FOR("Deprecated key symbol. Use CLUTTER_KEY_dead_dasia instead.")
#define CLUTTER_dead_doublegrave 0xfe66 CLUTTER_DEPRECATED_MACRO_FOR("Deprecated key symbol. Use CLUTTER_KEY_dead_doublegrave instead.")
#define CLUTTER_dead_belowring 0xfe67 CLUTTER_DEPRECATED_MACRO_FOR("Deprecated key symbol. Use CLUTTER_KEY_dead_belowring instead.")
#define CLUTTER_dead_belowmacron 0xfe68 CLUTTER_DEPRECATED_MACRO_FOR("Deprecated key symbol. Use CLUTTER_KEY_dead_belowmacron instead.")
#define CLUTTER_dead_belowcircumflex 0xfe69 CLUTTER_DEPRECATED_MACRO_FOR("Deprecated key symbol. Use CLUTTER_KEY_dead_belowcircumflex instead.")
#define CLUTTER_dead_belowtilde 0xfe6a CLUTTER_DEPRECATED_MACRO_FOR("Deprecated key symbol. Use CLUTTER_KEY_dead_belowtilde instead.")
#define CLUTTER_dead_belowbreve 0xfe6b CLUTTER_DEPRECATED_MACRO_FOR("Deprecated key symbol. Use CLUTTER_KEY_dead_belowbreve instead.")
#define CLUTTER_dead_belowdiaeresis 0xfe6c CLUTTER_DEPRECATED_MACRO_FOR("Deprecated key symbol. Use CLUTTER_KEY_dead_belowdiaeresis instead.")
#define CLUTTER_dead_invertedbreve 0xfe6d CLUTTER_DEPRECATED_MACRO_FOR("Deprecated key symbol. Use CLUTTER_KEY_dead_invertedbreve instead.")
#define CLUTTER_dead_belowcomma 0xfe6e CLUTTER_DEPRECATED_MACRO_FOR("Deprecated key symbol. Use CLUTTER_KEY_dead_belowcomma instead.")
#define CLUTTER_dead_currency 0xfe6f CLUTTER_DEPRECATED_MACRO_FOR("Deprecated key symbol. Use CLUTTER_KEY_dead_currency instead.")
#define CLUTTER_dead_lowline 0xfe90 CLUTTER_DEPRECATED_MACRO_FOR("Deprecated key symbol. Use CLUTTER_KEY_dead_lowline instead.")
#define CLUTTER_dead_aboveverticalline 0xfe91 CLUTTER_DEPRECATED_MACRO_FOR("Deprecated key symbol. Use CLUTTER_KEY_dead_aboveverticalline instead.")
#define CLUTTER_dead_belowverticalline 0xfe92 CLUTTER_DEPRECATED_MACRO_FOR("Deprecated key symbol. Use CLUTTER_KEY_dead_belowverticalline instead.")
#define CLUTTER_dead_longsolidusoverlay 0xfe93 CLUTTER_DEPRECATED_MACRO_FOR("Deprecated key symbol. Use CLUTTER_KEY_dead_longsolidusoverlay instead.")
#define CLUTTER_dead_a 0xfe80 CLUTTER_DEPRECATED_MACRO_FOR("Deprecated key symbol. Use CLUTTER_KEY_dead_a instead.")
#define CLUTTER_dead_A 0xfe81 CLUTTER_DEPRECATED_MACRO_FOR("Deprecated key symbol. Use CLUTTER_KEY_dead_A instead.")
#define CLUTTER_dead_e 0xfe82 CLUTTER_DEPRECATED_MACRO_FOR("Deprecated key symbol. Use CLUTTER_KEY_dead_e instead.")
#define CLUTTER_dead_E 0xfe83 CLUTTER_DEPRECATED_MACRO_FOR("Deprecated key symbol. Use CLUTTER_KEY_dead_E instead.")
#define CLUTTER_dead_i 0xfe84 CLUTTER_DEPRECATED_MACRO_FOR("Deprecated key symbol. Use CLUTTER_KEY_dead_i instead.")
#define CLUTTER_dead_I 0xfe85 CLUTTER_DEPRECATED_MACRO_FOR("Deprecated key symbol. Use CLUTTER_KEY_dead_I instead.")
#define CLUTTER_dead_o 0xfe86 CLUTTER_DEPRECATED_MACRO_FOR("Deprecated key symbol. Use CLUTTER_KEY_dead_o instead.")
#define CLUTTER_dead_O 0xfe87 CLUTTER_DEPRECATED_MACRO_FOR("Deprecated key symbol. Use CLUTTER_KEY_dead_O instead.")
#define CLUTTER_dead_u 0xfe88 CLUTTER_DEPRECATED_MACRO_FOR("Deprecated key symbol. Use CLUTTER_KEY_dead_u instead.")
#define CLUTTER_dead_U 0xfe89 CLUTTER_DEPRECATED_MACRO_FOR("Deprecated key symbol. Use CLUTTER_KEY_dead_U instead.")
#define CLUTTER_dead_small_schwa 0xfe8a CLUTTER_DEPRECATED_MACRO_FOR("Deprecated key symbol. Use CLUTTER_KEY_dead_small_schwa instead.")
#define CLUTTER_dead_capital_schwa 0xfe8b CLUTTER_DEPRECATED_MACRO_FOR("Deprecated key symbol. Use CLUTTER_KEY_dead_capital_schwa instead.")
#define CLUTTER_dead_greek 0xfe8c CLUTTER_DEPRECATED_MACRO_FOR("Deprecated key symbol. Use CLUTTER_KEY_dead_greek instead.")
#define CLUTTER_First_Virtual_Screen 0xfed0 CLUTTER_DEPRECATED_MACRO_FOR("Deprecated key symbol. Use CLUTTER_KEY_First_Virtual_Screen instead.")
#define CLUTTER_Prev_Virtual_Screen 0xfed1 CLUTTER_DEPRECATED_MACRO_FOR("Deprecated key symbol. Use CLUTTER_KEY_Prev_Virtual_Screen instead.")
#define CLUTTER_Next_Virtual_Screen 0xfed2 CLUTTER_DEPRECATED_MACRO_FOR("Deprecated key symbol. Use CLUTTER_KEY_Next_Virtual_Screen instead.")
#define CLUTTER_Last_Virtual_Screen 0xfed4 CLUTTER_DEPRECATED_MACRO_FOR("Deprecated key symbol. Use CLUTTER_KEY_Last_Virtual_Screen instead.")
#define CLUTTER_Terminate_Server 0xfed5 CLUTTER_DEPRECATED_MACRO_FOR("Deprecated key symbol. Use CLUTTER_KEY_Terminate_Server instead.")
#define CLUTTER_AccessX_Enable 0xfe70 CLUTTER_DEPRECATED_MACRO_FOR("Deprecated key symbol. Use CLUTTER_KEY_AccessX_Enable instead.")
#define CLUTTER_AccessX_Feedback_Enable 0xfe71 CLUTTER_DEPRECATED_MACRO_FOR("Deprecated key symbol. Use CLUTTER_KEY_AccessX_Feedback_Enable instead.")
#define CLUTTER_RepeatKeys_Enable 0xfe72 CLUTTER_DEPRECATED_MACRO_FOR("Deprecated key symbol. Use CLUTTER_KEY_RepeatKeys_Enable instead.")
#define CLUTTER_SlowKeys_Enable 0xfe73 CLUTTER_DEPRECATED_MACRO_FOR("Deprecated key symbol. Use CLUTTER_KEY_SlowKeys_Enable instead.")
#define CLUTTER_BounceKeys_Enable 0xfe74 CLUTTER_DEPRECATED_MACRO_FOR("Deprecated key symbol. Use CLUTTER_KEY_BounceKeys_Enable instead.")
#define CLUTTER_StickyKeys_Enable 0xfe75 CLUTTER_DEPRECATED_MACRO_FOR("Deprecated key symbol. Use CLUTTER_KEY_StickyKeys_Enable instead.")
#define CLUTTER_MouseKeys_Enable 0xfe76 CLUTTER_DEPRECATED_MACRO_FOR("Deprecated key symbol. Use CLUTTER_KEY_MouseKeys_Enable instead.")
#define CLUTTER_MouseKeys_Accel_Enable 0xfe77 CLUTTER_DEPRECATED_MACRO_FOR("Deprecated key symbol. Use CLUTTER_KEY_MouseKeys_Accel_Enable instead.")
#define CLUTTER_Overlay1_Enable 0xfe78 CLUTTER_DEPRECATED_MACRO_FOR("Deprecated key symbol. Use CLUTTER_KEY_Overlay1_Enable instead.")
#define CLUTTER_Overlay2_Enable 0xfe79 CLUTTER_DEPRECATED_MACRO_FOR("Deprecated key symbol. Use CLUTTER_KEY_Overlay2_Enable instead.")
#define CLUTTER_AudibleBell_Enable 0xfe7a CLUTTER_DEPRECATED_MACRO_FOR("Deprecated key symbol. Use CLUTTER_KEY_AudibleBell_Enable instead.")
#define CLUTTER_Pointer_Left 0xfee0 CLUTTER_DEPRECATED_MACRO_FOR("Deprecated key symbol. Use CLUTTER_KEY_Pointer_Left instead.")
#define CLUTTER_Pointer_Right 0xfee1 CLUTTER_DEPRECATED_MACRO_FOR("Deprecated key symbol. Use CLUTTER_KEY_Pointer_Right instead.")
#define CLUTTER_Pointer_Up 0xfee2 CLUTTER_DEPRECATED_MACRO_FOR("Deprecated key symbol. Use CLUTTER_KEY_Pointer_Up instead.")
#define CLUTTER_Pointer_Down 0xfee3 CLUTTER_DEPRECATED_MACRO_FOR("Deprecated key symbol. Use CLUTTER_KEY_Pointer_Down instead.")
#define CLUTTER_Pointer_UpLeft 0xfee4 CLUTTER_DEPRECATED_MACRO_FOR("Deprecated key symbol. Use CLUTTER_KEY_Pointer_UpLeft instead.")
#define CLUTTER_Pointer_UpRight 0xfee5 CLUTTER_DEPRECATED_MACRO_FOR("Deprecated key symbol. Use CLUTTER_KEY_Pointer_UpRight instead.")
#define CLUTTER_Pointer_DownLeft 0xfee6 CLUTTER_DEPRECATED_MACRO_FOR("Deprecated key symbol. Use CLUTTER_KEY_Pointer_DownLeft instead.")
#define CLUTTER_Pointer_DownRight 0xfee7 CLUTTER_DEPRECATED_MACRO_FOR("Deprecated key symbol. Use CLUTTER_KEY_Pointer_DownRight instead.")
#define CLUTTER_Pointer_Button_Dflt 0xfee8 CLUTTER_DEPRECATED_MACRO_FOR("Deprecated key symbol. Use CLUTTER_KEY_Pointer_Button_Dflt instead.")
#define CLUTTER_Pointer_Button1 0xfee9 CLUTTER_DEPRECATED_MACRO_FOR("Deprecated key symbol. Use CLUTTER_KEY_Pointer_Button1 instead.")
#define CLUTTER_Pointer_Button2 0xfeea CLUTTER_DEPRECATED_MACRO_FOR("Deprecated key symbol. Use CLUTTER_KEY_Pointer_Button2 instead.")
#define CLUTTER_Pointer_Button3 0xfeeb CLUTTER_DEPRECATED_MACRO_FOR("Deprecated key symbol. Use CLUTTER_KEY_Pointer_Button3 instead.")
#define CLUTTER_Pointer_Button4 0xfeec CLUTTER_DEPRECATED_MACRO_FOR("Deprecated key symbol. Use CLUTTER_KEY_Pointer_Button4 instead.")
#define CLUTTER_Pointer_Button5 0xfeed CLUTTER_DEPRECATED_MACRO_FOR("Deprecated key symbol. Use CLUTTER_KEY_Pointer_Button5 instead.")
#define CLUTTER_Pointer_DblClick_Dflt 0xfeee CLUTTER_DEPRECATED_MACRO_FOR("Deprecated key symbol. Use CLUTTER_KEY_Pointer_DblClick_Dflt instead.")
#define CLUTTER_Pointer_DblClick1 0xfeef CLUTTER_DEPRECATED_MACRO_FOR("Deprecated key symbol. Use CLUTTER_KEY_Pointer_DblClick1 instead.")
#define CLUTTER_Pointer_DblClick2 0xfef0 CLUTTER_DEPRECATED_MACRO_FOR("Deprecated key symbol. Use CLUTTER_KEY_Pointer_DblClick2 instead.")
#define CLUTTER_Pointer_DblClick3 0xfef1 CLUTTER_DEPRECATED_MACRO_FOR("Deprecated key symbol. Use CLUTTER_KEY_Pointer_DblClick3 instead.")
#define CLUTTER_Pointer_DblClick4 0xfef2 CLUTTER_DEPRECATED_MACRO_FOR("Deprecated key symbol. Use CLUTTER_KEY_Pointer_DblClick4 instead.")
#define CLUTTER_Pointer_DblClick5 0xfef3 CLUTTER_DEPRECATED_MACRO_FOR("Deprecated key symbol. Use CLUTTER_KEY_Pointer_DblClick5 instead.")
#define CLUTTER_Pointer_Drag_Dflt 0xfef4 CLUTTER_DEPRECATED_MACRO_FOR("Deprecated key symbol. Use CLUTTER_KEY_Pointer_Drag_Dflt instead.")
#define CLUTTER_Pointer_Drag1 0xfef5 CLUTTER_DEPRECATED_MACRO_FOR("Deprecated key symbol. Use CLUTTER_KEY_Pointer_Drag1 instead.")
#define CLUTTER_Pointer_Drag2 0xfef6 CLUTTER_DEPRECATED_MACRO_FOR("Deprecated key symbol. Use CLUTTER_KEY_Pointer_Drag2 instead.")
#define CLUTTER_Pointer_Drag3 0xfef7 CLUTTER_DEPRECATED_MACRO_FOR("Deprecated key symbol. Use CLUTTER_KEY_Pointer_Drag3 instead.")
#define CLUTTER_Pointer_Drag4 0xfef8 CLUTTER_DEPRECATED_MACRO_FOR("Deprecated key symbol. Use CLUTTER_KEY_Pointer_Drag4 instead.")
#define CLUTTER_Pointer_Drag5 0xfefd CLUTTER_DEPRECATED_MACRO_FOR("Deprecated key symbol. Use CLUTTER_KEY_Pointer_Drag5 instead.")
#define CLUTTER_Pointer_EnableKeys 0xfef9 CLUTTER_DEPRECATED_MACRO_FOR("Deprecated key symbol. Use CLUTTER_KEY_Pointer_EnableKeys instead.")
#define CLUTTER_Pointer_Accelerate 0xfefa CLUTTER_DEPRECATED_MACRO_FOR("Deprecated key symbol. Use CLUTTER_KEY_Pointer_Accelerate instead.")
#define CLUTTER_Pointer_DfltBtnNext 0xfefb CLUTTER_DEPRECATED_MACRO_FOR("Deprecated key symbol. Use CLUTTER_KEY_Pointer_DfltBtnNext instead.")
#define CLUTTER_Pointer_DfltBtnPrev 0xfefc CLUTTER_DEPRECATED_MACRO_FOR("Deprecated key symbol. Use CLUTTER_KEY_Pointer_DfltBtnPrev instead.")
#define CLUTTER_ch 0xfea0 CLUTTER_DEPRECATED_MACRO_FOR("Deprecated key symbol. Use CLUTTER_KEY_ch instead.")
#define CLUTTER_Ch 0xfea1 CLUTTER_DEPRECATED_MACRO_FOR("Deprecated key symbol. Use CLUTTER_KEY_Ch instead.")
#define CLUTTER_CH 0xfea2 CLUTTER_DEPRECATED_MACRO_FOR("Deprecated key symbol. Use CLUTTER_KEY_CH instead.")
#define CLUTTER_c_h 0xfea3 CLUTTER_DEPRECATED_MACRO_FOR("Deprecated key symbol. Use CLUTTER_KEY_c_h instead.")
#define CLUTTER_C_h 0xfea4 CLUTTER_DEPRECATED_MACRO_FOR("Deprecated key symbol. Use CLUTTER_KEY_C_h instead.")
#define CLUTTER_C_H 0xfea5 CLUTTER_DEPRECATED_MACRO_FOR("Deprecated key symbol. Use CLUTTER_KEY_C_H instead.")
#define CLUTTER_3270_Duplicate 0xfd01 CLUTTER_DEPRECATED_MACRO_FOR("Deprecated key symbol. Use CLUTTER_KEY_3270_Duplicate instead.")
#define CLUTTER_3270_FieldMark 0xfd02 CLUTTER_DEPRECATED_MACRO_FOR("Deprecated key symbol. Use CLUTTER_KEY_3270_FieldMark instead.")
#define CLUTTER_3270_Right2 0xfd03 CLUTTER_DEPRECATED_MACRO_FOR("Deprecated key symbol. Use CLUTTER_KEY_3270_Right2 instead.")
#define CLUTTER_3270_Left2 0xfd04 CLUTTER_DEPRECATED_MACRO_FOR("Deprecated key symbol. Use CLUTTER_KEY_3270_Left2 instead.")
#define CLUTTER_3270_BackTab 0xfd05 CLUTTER_DEPRECATED_MACRO_FOR("Deprecated key symbol. Use CLUTTER_KEY_3270_BackTab instead.")
#define CLUTTER_3270_EraseEOF 0xfd06 CLUTTER_DEPRECATED_MACRO_FOR("Deprecated key symbol. Use CLUTTER_KEY_3270_EraseEOF instead.")
#define CLUTTER_3270_EraseInput 0xfd07 CLUTTER_DEPRECATED_MACRO_FOR("Deprecated key symbol. Use CLUTTER_KEY_3270_EraseInput instead.")
#define CLUTTER_3270_Reset 0xfd08 CLUTTER_DEPRECATED_MACRO_FOR("Deprecated key symbol. Use CLUTTER_KEY_3270_Reset instead.")
#define CLUTTER_3270_Quit 0xfd09 CLUTTER_DEPRECATED_MACRO_FOR("Deprecated key symbol. Use CLUTTER_KEY_3270_Quit instead.")
#define CLUTTER_3270_PA1 0xfd0a CLUTTER_DEPRECATED_MACRO_FOR("Deprecated key symbol. Use CLUTTER_KEY_3270_PA1 instead.")
#define CLUTTER_3270_PA2 0xfd0b CLUTTER_DEPRECATED_MACRO_FOR("Deprecated key symbol. Use CLUTTER_KEY_3270_PA2 instead.")
#define CLUTTER_3270_PA3 0xfd0c CLUTTER_DEPRECATED_MACRO_FOR("Deprecated key symbol. Use CLUTTER_KEY_3270_PA3 instead.")
#define CLUTTER_3270_Test 0xfd0d CLUTTER_DEPRECATED_MACRO_FOR("Deprecated key symbol. Use CLUTTER_KEY_3270_Test instead.")
#define CLUTTER_3270_Attn 0xfd0e CLUTTER_DEPRECATED_MACRO_FOR("Deprecated key symbol. Use CLUTTER_KEY_3270_Attn instead.")
#define CLUTTER_3270_CursorBlink 0xfd0f CLUTTER_DEPRECATED_MACRO_FOR("Deprecated key symbol. Use CLUTTER_KEY_3270_CursorBlink instead.")
#define CLUTTER_3270_AltCursor 0xfd10 CLUTTER_DEPRECATED_MACRO_FOR("Deprecated key symbol. Use CLUTTER_KEY_3270_AltCursor instead.")
#define CLUTTER_3270_KeyClick 0xfd11 CLUTTER_DEPRECATED_MACRO_FOR("Deprecated key symbol. Use CLUTTER_KEY_3270_KeyClick instead.")
#define CLUTTER_3270_Jump 0xfd12 CLUTTER_DEPRECATED_MACRO_FOR("Deprecated key symbol. Use CLUTTER_KEY_3270_Jump instead.")
#define CLUTTER_3270_Ident 0xfd13 CLUTTER_DEPRECATED_MACRO_FOR("Deprecated key symbol. Use CLUTTER_KEY_3270_Ident instead.")
#define CLUTTER_3270_Rule 0xfd14 CLUTTER_DEPRECATED_MACRO_FOR("Deprecated key symbol. Use CLUTTER_KEY_3270_Rule instead.")
#define CLUTTER_3270_Copy 0xfd15 CLUTTER_DEPRECATED_MACRO_FOR("Deprecated key symbol. Use CLUTTER_KEY_3270_Copy instead.")
#define CLUTTER_3270_Play 0xfd16 CLUTTER_DEPRECATED_MACRO_FOR("Deprecated key symbol. Use CLUTTER_KEY_3270_Play instead.")
#define CLUTTER_3270_Setup 0xfd17 CLUTTER_DEPRECATED_MACRO_FOR("Deprecated key symbol. Use CLUTTER_KEY_3270_Setup instead.")
#define CLUTTER_3270_Record 0xfd18 CLUTTER_DEPRECATED_MACRO_FOR("Deprecated key symbol. Use CLUTTER_KEY_3270_Record instead.")
#define CLUTTER_3270_ChangeScreen 0xfd19 CLUTTER_DEPRECATED_MACRO_FOR("Deprecated key symbol. Use CLUTTER_KEY_3270_ChangeScreen instead.")
#define CLUTTER_3270_DeleteWord 0xfd1a CLUTTER_DEPRECATED_MACRO_FOR("Deprecated key symbol. Use CLUTTER_KEY_3270_DeleteWord instead.")
#define CLUTTER_3270_ExSelect 0xfd1b CLUTTER_DEPRECATED_MACRO_FOR("Deprecated key symbol. Use CLUTTER_KEY_3270_ExSelect instead.")
#define CLUTTER_3270_CursorSelect 0xfd1c CLUTTER_DEPRECATED_MACRO_FOR("Deprecated key symbol. Use CLUTTER_KEY_3270_CursorSelect instead.")
#define CLUTTER_3270_PrintScreen 0xfd1d CLUTTER_DEPRECATED_MACRO_FOR("Deprecated key symbol. Use CLUTTER_KEY_3270_PrintScreen instead.")
#define CLUTTER_3270_Enter 0xfd1e CLUTTER_DEPRECATED_MACRO_FOR("Deprecated key symbol. Use CLUTTER_KEY_3270_Enter instead.")
#define CLUTTER_space 0x020 CLUTTER_DEPRECATED_MACRO_FOR("Deprecated key symbol. Use CLUTTER_KEY_space instead.")
#define CLUTTER_exclam 0x021 CLUTTER_DEPRECATED_MACRO_FOR("Deprecated key symbol. Use CLUTTER_KEY_exclam instead.")
#define CLUTTER_quotedbl 0x022 CLUTTER_DEPRECATED_MACRO_FOR("Deprecated key symbol. Use CLUTTER_KEY_quotedbl instead.")
#define CLUTTER_numbersign 0x023 CLUTTER_DEPRECATED_MACRO_FOR("Deprecated key symbol. Use CLUTTER_KEY_numbersign instead.")
#define CLUTTER_dollar 0x024 CLUTTER_DEPRECATED_MACRO_FOR("Deprecated key symbol. Use CLUTTER_KEY_dollar instead.")
#define CLUTTER_percent 0x025 CLUTTER_DEPRECATED_MACRO_FOR("Deprecated key symbol. Use CLUTTER_KEY_percent instead.")
#define CLUTTER_ampersand 0x026 CLUTTER_DEPRECATED_MACRO_FOR("Deprecated key symbol. Use CLUTTER_KEY_ampersand instead.")
#define CLUTTER_apostrophe 0x027 CLUTTER_DEPRECATED_MACRO_FOR("Deprecated key symbol. Use CLUTTER_KEY_apostrophe instead.")
#define CLUTTER_quoteright 0x027 CLUTTER_DEPRECATED_MACRO_FOR("Deprecated key symbol. Use CLUTTER_KEY_quoteright instead.")
#define CLUTTER_parenleft 0x028 CLUTTER_DEPRECATED_MACRO_FOR("Deprecated key symbol. Use CLUTTER_KEY_parenleft instead.")
#define CLUTTER_parenright 0x029 CLUTTER_DEPRECATED_MACRO_FOR("Deprecated key symbol. Use CLUTTER_KEY_parenright instead.")
#define CLUTTER_asterisk 0x02a CLUTTER_DEPRECATED_MACRO_FOR("Deprecated key symbol. Use CLUTTER_KEY_asterisk instead.")
#define CLUTTER_plus 0x02b CLUTTER_DEPRECATED_MACRO_FOR("Deprecated key symbol. Use CLUTTER_KEY_plus instead.")
#define CLUTTER_comma 0x02c CLUTTER_DEPRECATED_MACRO_FOR("Deprecated key symbol. Use CLUTTER_KEY_comma instead.")
#define CLUTTER_minus 0x02d CLUTTER_DEPRECATED_MACRO_FOR("Deprecated key symbol. Use CLUTTER_KEY_minus instead.")
#define CLUTTER_period 0x02e CLUTTER_DEPRECATED_MACRO_FOR("Deprecated key symbol. Use CLUTTER_KEY_period instead.")
#define CLUTTER_slash 0x02f CLUTTER_DEPRECATED_MACRO_FOR("Deprecated key symbol. Use CLUTTER_KEY_slash instead.")
#define CLUTTER_0 0x030 CLUTTER_DEPRECATED_MACRO_FOR("Deprecated key symbol. Use CLUTTER_KEY_0 instead.")
#define CLUTTER_1 0x031 CLUTTER_DEPRECATED_MACRO_FOR("Deprecated key symbol. Use CLUTTER_KEY_1 instead.")
#define CLUTTER_2 0x032 CLUTTER_DEPRECATED_MACRO_FOR("Deprecated key symbol. Use CLUTTER_KEY_2 instead.")
#define CLUTTER_3 0x033 CLUTTER_DEPRECATED_MACRO_FOR("Deprecated key symbol. Use CLUTTER_KEY_3 instead.")
#define CLUTTER_4 0x034 CLUTTER_DEPRECATED_MACRO_FOR("Deprecated key symbol. Use CLUTTER_KEY_4 instead.")
#define CLUTTER_5 0x035 CLUTTER_DEPRECATED_MACRO_FOR("Deprecated key symbol. Use CLUTTER_KEY_5 instead.")
#define CLUTTER_6 0x036 CLUTTER_DEPRECATED_MACRO_FOR("Deprecated key symbol. Use CLUTTER_KEY_6 instead.")
#define CLUTTER_7 0x037 CLUTTER_DEPRECATED_MACRO_FOR("Deprecated key symbol. Use CLUTTER_KEY_7 instead.")
#define CLUTTER_8 0x038 CLUTTER_DEPRECATED_MACRO_FOR("Deprecated key symbol. Use CLUTTER_KEY_8 instead.")
#define CLUTTER_9 0x039 CLUTTER_DEPRECATED_MACRO_FOR("Deprecated key symbol. Use CLUTTER_KEY_9 instead.")
#define CLUTTER_colon 0x03a CLUTTER_DEPRECATED_MACRO_FOR("Deprecated key symbol. Use CLUTTER_KEY_colon instead.")
#define CLUTTER_semicolon 0x03b CLUTTER_DEPRECATED_MACRO_FOR("Deprecated key symbol. Use CLUTTER_KEY_semicolon instead.")
#define CLUTTER_less 0x03c CLUTTER_DEPRECATED_MACRO_FOR("Deprecated key symbol. Use CLUTTER_KEY_less instead.")
#define CLUTTER_equal 0x03d CLUTTER_DEPRECATED_MACRO_FOR("Deprecated key symbol. Use CLUTTER_KEY_equal instead.")
#define CLUTTER_greater 0x03e CLUTTER_DEPRECATED_MACRO_FOR("Deprecated key symbol. Use CLUTTER_KEY_greater instead.")
#define CLUTTER_question 0x03f CLUTTER_DEPRECATED_MACRO_FOR("Deprecated key symbol. Use CLUTTER_KEY_question instead.")
#define CLUTTER_at 0x040 CLUTTER_DEPRECATED_MACRO_FOR("Deprecated key symbol. Use CLUTTER_KEY_at instead.")
#define CLUTTER_A 0x041 CLUTTER_DEPRECATED_MACRO_FOR("Deprecated key symbol. Use CLUTTER_KEY_A instead.")
#define CLUTTER_B 0x042 CLUTTER_DEPRECATED_MACRO_FOR("Deprecated key symbol. Use CLUTTER_KEY_B instead.")
#define CLUTTER_C 0x043 CLUTTER_DEPRECATED_MACRO_FOR("Deprecated key symbol. Use CLUTTER_KEY_C instead.")
#define CLUTTER_D 0x044 CLUTTER_DEPRECATED_MACRO_FOR("Deprecated key symbol. Use CLUTTER_KEY_D instead.")
#define CLUTTER_E 0x045 CLUTTER_DEPRECATED_MACRO_FOR("Deprecated key symbol. Use CLUTTER_KEY_E instead.")
#define CLUTTER_F 0x046 CLUTTER_DEPRECATED_MACRO_FOR("Deprecated key symbol. Use CLUTTER_KEY_F instead.")
#define CLUTTER_G 0x047 CLUTTER_DEPRECATED_MACRO_FOR("Deprecated key symbol. Use CLUTTER_KEY_G instead.")
#define CLUTTER_H 0x048 CLUTTER_DEPRECATED_MACRO_FOR("Deprecated key symbol. Use CLUTTER_KEY_H instead.")
#define CLUTTER_I 0x049 CLUTTER_DEPRECATED_MACRO_FOR("Deprecated key symbol. Use CLUTTER_KEY_I instead.")
#define CLUTTER_J 0x04a CLUTTER_DEPRECATED_MACRO_FOR("Deprecated key symbol. Use CLUTTER_KEY_J instead.")
#define CLUTTER_K 0x04b CLUTTER_DEPRECATED_MACRO_FOR("Deprecated key symbol. Use CLUTTER_KEY_K instead.")
#define CLUTTER_L 0x04c CLUTTER_DEPRECATED_MACRO_FOR("Deprecated key symbol. Use CLUTTER_KEY_L instead.")
#define CLUTTER_M 0x04d CLUTTER_DEPRECATED_MACRO_FOR("Deprecated key symbol. Use CLUTTER_KEY_M instead.")
#define CLUTTER_N 0x04e CLUTTER_DEPRECATED_MACRO_FOR("Deprecated key symbol. Use CLUTTER_KEY_N instead.")
#define CLUTTER_O 0x04f CLUTTER_DEPRECATED_MACRO_FOR("Deprecated key symbol. Use CLUTTER_KEY_O instead.")
#define CLUTTER_P 0x050 CLUTTER_DEPRECATED_MACRO_FOR("Deprecated key symbol. Use CLUTTER_KEY_P instead.")
#define CLUTTER_Q 0x051 CLUTTER_DEPRECATED_MACRO_FOR("Deprecated key symbol. Use CLUTTER_KEY_Q instead.")
#define CLUTTER_R 0x052 CLUTTER_DEPRECATED_MACRO_FOR("Deprecated key symbol. Use CLUTTER_KEY_R instead.")
#define CLUTTER_S 0x053 CLUTTER_DEPRECATED_MACRO_FOR("Deprecated key symbol. Use CLUTTER_KEY_S instead.")
#define CLUTTER_T 0x054 CLUTTER_DEPRECATED_MACRO_FOR("Deprecated key symbol. Use CLUTTER_KEY_T instead.")
#define CLUTTER_U 0x055 CLUTTER_DEPRECATED_MACRO_FOR("Deprecated key symbol. Use CLUTTER_KEY_U instead.")
#define CLUTTER_V 0x056 CLUTTER_DEPRECATED_MACRO_FOR("Deprecated key symbol. Use CLUTTER_KEY_V instead.")
#define CLUTTER_W 0x057 CLUTTER_DEPRECATED_MACRO_FOR("Deprecated key symbol. Use CLUTTER_KEY_W instead.")
#define CLUTTER_X 0x058 CLUTTER_DEPRECATED_MACRO_FOR("Deprecated key symbol. Use CLUTTER_KEY_X instead.")
#define CLUTTER_Y 0x059 CLUTTER_DEPRECATED_MACRO_FOR("Deprecated key symbol. Use CLUTTER_KEY_Y instead.")
#define CLUTTER_Z 0x05a CLUTTER_DEPRECATED_MACRO_FOR("Deprecated key symbol. Use CLUTTER_KEY_Z instead.")
#define CLUTTER_bracketleft 0x05b CLUTTER_DEPRECATED_MACRO_FOR("Deprecated key symbol. Use CLUTTER_KEY_bracketleft instead.")
#define CLUTTER_backslash 0x05c CLUTTER_DEPRECATED_MACRO_FOR("Deprecated key symbol. Use CLUTTER_KEY_backslash instead.")
#define CLUTTER_bracketright 0x05d CLUTTER_DEPRECATED_MACRO_FOR("Deprecated key symbol. Use CLUTTER_KEY_bracketright instead.")
#define CLUTTER_asciicircum 0x05e CLUTTER_DEPRECATED_MACRO_FOR("Deprecated key symbol. Use CLUTTER_KEY_asciicircum instead.")
#define CLUTTER_underscore 0x05f CLUTTER_DEPRECATED_MACRO_FOR("Deprecated key symbol. Use CLUTTER_KEY_underscore instead.")
#define CLUTTER_grave 0x060 CLUTTER_DEPRECATED_MACRO_FOR("Deprecated key symbol. Use CLUTTER_KEY_grave instead.")
#define CLUTTER_quoteleft 0x060 CLUTTER_DEPRECATED_MACRO_FOR("Deprecated key symbol. Use CLUTTER_KEY_quoteleft instead.")
#define CLUTTER_a 0x061 CLUTTER_DEPRECATED_MACRO_FOR("Deprecated key symbol. Use CLUTTER_KEY_a instead.")
#define CLUTTER_b 0x062 CLUTTER_DEPRECATED_MACRO_FOR("Deprecated key symbol. Use CLUTTER_KEY_b instead.")
#define CLUTTER_c 0x063 CLUTTER_DEPRECATED_MACRO_FOR("Deprecated key symbol. Use CLUTTER_KEY_c instead.")
#define CLUTTER_d 0x064 CLUTTER_DEPRECATED_MACRO_FOR("Deprecated key symbol. Use CLUTTER_KEY_d instead.")
#define CLUTTER_e 0x065 CLUTTER_DEPRECATED_MACRO_FOR("Deprecated key symbol. Use CLUTTER_KEY_e instead.")
#define CLUTTER_f 0x066 CLUTTER_DEPRECATED_MACRO_FOR("Deprecated key symbol. Use CLUTTER_KEY_f instead.")
#define CLUTTER_g 0x067 CLUTTER_DEPRECATED_MACRO_FOR("Deprecated key symbol. Use CLUTTER_KEY_g instead.")
#define CLUTTER_h 0x068 CLUTTER_DEPRECATED_MACRO_FOR("Deprecated key symbol. Use CLUTTER_KEY_h instead.")
#define CLUTTER_i 0x069 CLUTTER_DEPRECATED_MACRO_FOR("Deprecated key symbol. Use CLUTTER_KEY_i instead.")
#define CLUTTER_j 0x06a CLUTTER_DEPRECATED_MACRO_FOR("Deprecated key symbol. Use CLUTTER_KEY_j instead.")
#define CLUTTER_k 0x06b CLUTTER_DEPRECATED_MACRO_FOR("Deprecated key symbol. Use CLUTTER_KEY_k instead.")
#define CLUTTER_l 0x06c CLUTTER_DEPRECATED_MACRO_FOR("Deprecated key symbol. Use CLUTTER_KEY_l instead.")
#define CLUTTER_m 0x06d CLUTTER_DEPRECATED_MACRO_FOR("Deprecated key symbol. Use CLUTTER_KEY_m instead.")
#define CLUTTER_n 0x06e CLUTTER_DEPRECATED_MACRO_FOR("Deprecated key symbol. Use CLUTTER_KEY_n instead.")
#define CLUTTER_o 0x06f CLUTTER_DEPRECATED_MACRO_FOR("Deprecated key symbol. Use CLUTTER_KEY_o instead.")
#define CLUTTER_p 0x070 CLUTTER_DEPRECATED_MACRO_FOR("Deprecated key symbol. Use CLUTTER_KEY_p instead.")
#define CLUTTER_q 0x071 CLUTTER_DEPRECATED_MACRO_FOR("Deprecated key symbol. Use CLUTTER_KEY_q instead.")
#define CLUTTER_r 0x072 CLUTTER_DEPRECATED_MACRO_FOR("Deprecated key symbol. Use CLUTTER_KEY_r instead.")
#define CLUTTER_s 0x073 CLUTTER_DEPRECATED_MACRO_FOR("Deprecated key symbol. Use CLUTTER_KEY_s instead.")
#define CLUTTER_t 0x074 CLUTTER_DEPRECATED_MACRO_FOR("Deprecated key symbol. Use CLUTTER_KEY_t instead.")
#define CLUTTER_u 0x075 CLUTTER_DEPRECATED_MACRO_FOR("Deprecated key symbol. Use CLUTTER_KEY_u instead.")
#define CLUTTER_v 0x076 CLUTTER_DEPRECATED_MACRO_FOR("Deprecated key symbol. Use CLUTTER_KEY_v instead.")
#define CLUTTER_w 0x077 CLUTTER_DEPRECATED_MACRO_FOR("Deprecated key symbol. Use CLUTTER_KEY_w instead.")
#define CLUTTER_x 0x078 CLUTTER_DEPRECATED_MACRO_FOR("Deprecated key symbol. Use CLUTTER_KEY_x instead.")
#define CLUTTER_y 0x079 CLUTTER_DEPRECATED_MACRO_FOR("Deprecated key symbol. Use CLUTTER_KEY_y instead.")
#define CLUTTER_z 0x07a CLUTTER_DEPRECATED_MACRO_FOR("Deprecated key symbol. Use CLUTTER_KEY_z instead.")
#define CLUTTER_braceleft 0x07b CLUTTER_DEPRECATED_MACRO_FOR("Deprecated key symbol. Use CLUTTER_KEY_braceleft instead.")
#define CLUTTER_bar 0x07c CLUTTER_DEPRECATED_MACRO_FOR("Deprecated key symbol. Use CLUTTER_KEY_bar instead.")
#define CLUTTER_braceright 0x07d CLUTTER_DEPRECATED_MACRO_FOR("Deprecated key symbol. Use CLUTTER_KEY_braceright instead.")
#define CLUTTER_asciitilde 0x07e CLUTTER_DEPRECATED_MACRO_FOR("Deprecated key symbol. Use CLUTTER_KEY_asciitilde instead.")
#define CLUTTER_nobreakspace 0x0a0 CLUTTER_DEPRECATED_MACRO_FOR("Deprecated key symbol. Use CLUTTER_KEY_nobreakspace instead.")
#define CLUTTER_exclamdown 0x0a1 CLUTTER_DEPRECATED_MACRO_FOR("Deprecated key symbol. Use CLUTTER_KEY_exclamdown instead.")
#define CLUTTER_cent 0x0a2 CLUTTER_DEPRECATED_MACRO_FOR("Deprecated key symbol. Use CLUTTER_KEY_cent instead.")
#define CLUTTER_sterling 0x0a3 CLUTTER_DEPRECATED_MACRO_FOR("Deprecated key symbol. Use CLUTTER_KEY_sterling instead.")
#define CLUTTER_currency 0x0a4 CLUTTER_DEPRECATED_MACRO_FOR("Deprecated key symbol. Use CLUTTER_KEY_currency instead.")
#define CLUTTER_yen 0x0a5 CLUTTER_DEPRECATED_MACRO_FOR("Deprecated key symbol. Use CLUTTER_KEY_yen instead.")
#define CLUTTER_brokenbar 0x0a6 CLUTTER_DEPRECATED_MACRO_FOR("Deprecated key symbol. Use CLUTTER_KEY_brokenbar instead.")
#define CLUTTER_section 0x0a7 CLUTTER_DEPRECATED_MACRO_FOR("Deprecated key symbol. Use CLUTTER_KEY_section instead.")
#define CLUTTER_diaeresis 0x0a8 CLUTTER_DEPRECATED_MACRO_FOR("Deprecated key symbol. Use CLUTTER_KEY_diaeresis instead.")
#define CLUTTER_copyright 0x0a9 CLUTTER_DEPRECATED_MACRO_FOR("Deprecated key symbol. Use CLUTTER_KEY_copyright instead.")
#define CLUTTER_ordfeminine 0x0aa CLUTTER_DEPRECATED_MACRO_FOR("Deprecated key symbol. Use CLUTTER_KEY_ordfeminine instead.")
#define CLUTTER_guillemotleft 0x0ab CLUTTER_DEPRECATED_MACRO_FOR("Deprecated key symbol. Use CLUTTER_KEY_guillemotleft instead.")
#define CLUTTER_notsign 0x0ac CLUTTER_DEPRECATED_MACRO_FOR("Deprecated key symbol. Use CLUTTER_KEY_notsign instead.")
#define CLUTTER_hyphen 0x0ad CLUTTER_DEPRECATED_MACRO_FOR("Deprecated key symbol. Use CLUTTER_KEY_hyphen instead.")
#define CLUTTER_registered 0x0ae CLUTTER_DEPRECATED_MACRO_FOR("Deprecated key symbol. Use CLUTTER_KEY_registered instead.")
#define CLUTTER_macron 0x0af CLUTTER_DEPRECATED_MACRO_FOR("Deprecated key symbol. Use CLUTTER_KEY_macron instead.")
#define CLUTTER_degree 0x0b0 CLUTTER_DEPRECATED_MACRO_FOR("Deprecated key symbol. Use CLUTTER_KEY_degree instead.")
#define CLUTTER_plusminus 0x0b1 CLUTTER_DEPRECATED_MACRO_FOR("Deprecated key symbol. Use CLUTTER_KEY_plusminus instead.")
#define CLUTTER_twosuperior 0x0b2 CLUTTER_DEPRECATED_MACRO_FOR("Deprecated key symbol. Use CLUTTER_KEY_twosuperior instead.")
#define CLUTTER_threesuperior 0x0b3 CLUTTER_DEPRECATED_MACRO_FOR("Deprecated key symbol. Use CLUTTER_KEY_threesuperior instead.")
#define CLUTTER_acute 0x0b4 CLUTTER_DEPRECATED_MACRO_FOR("Deprecated key symbol. Use CLUTTER_KEY_acute instead.")
#define CLUTTER_mu 0x0b5 CLUTTER_DEPRECATED_MACRO_FOR("Deprecated key symbol. Use CLUTTER_KEY_mu instead.")
#define CLUTTER_paragraph 0x0b6 CLUTTER_DEPRECATED_MACRO_FOR("Deprecated key symbol. Use CLUTTER_KEY_paragraph instead.")
#define CLUTTER_periodcentered 0x0b7 CLUTTER_DEPRECATED_MACRO_FOR("Deprecated key symbol. Use CLUTTER_KEY_periodcentered instead.")
#define CLUTTER_cedilla 0x0b8 CLUTTER_DEPRECATED_MACRO_FOR("Deprecated key symbol. Use CLUTTER_KEY_cedilla instead.")
#define CLUTTER_onesuperior 0x0b9 CLUTTER_DEPRECATED_MACRO_FOR("Deprecated key symbol. Use CLUTTER_KEY_onesuperior instead.")
#define CLUTTER_masculine 0x0ba CLUTTER_DEPRECATED_MACRO_FOR("Deprecated key symbol. Use CLUTTER_KEY_masculine instead.")
#define CLUTTER_guillemotright 0x0bb CLUTTER_DEPRECATED_MACRO_FOR("Deprecated key symbol. Use CLUTTER_KEY_guillemotright instead.")
#define CLUTTER_onequarter 0x0bc CLUTTER_DEPRECATED_MACRO_FOR("Deprecated key symbol. Use CLUTTER_KEY_onequarter instead.")
#define CLUTTER_onehalf 0x0bd CLUTTER_DEPRECATED_MACRO_FOR("Deprecated key symbol. Use CLUTTER_KEY_onehalf instead.")
#define CLUTTER_threequarters 0x0be CLUTTER_DEPRECATED_MACRO_FOR("Deprecated key symbol. Use CLUTTER_KEY_threequarters instead.")
#define CLUTTER_questiondown 0x0bf CLUTTER_DEPRECATED_MACRO_FOR("Deprecated key symbol. Use CLUTTER_KEY_questiondown instead.")
#define CLUTTER_Agrave 0x0c0 CLUTTER_DEPRECATED_MACRO_FOR("Deprecated key symbol. Use CLUTTER_KEY_Agrave instead.")
#define CLUTTER_Aacute 0x0c1 CLUTTER_DEPRECATED_MACRO_FOR("Deprecated key symbol. Use CLUTTER_KEY_Aacute instead.")
#define CLUTTER_Acircumflex 0x0c2 CLUTTER_DEPRECATED_MACRO_FOR("Deprecated key symbol. Use CLUTTER_KEY_Acircumflex instead.")
#define CLUTTER_Atilde 0x0c3 CLUTTER_DEPRECATED_MACRO_FOR("Deprecated key symbol. Use CLUTTER_KEY_Atilde instead.")
#define CLUTTER_Adiaeresis 0x0c4 CLUTTER_DEPRECATED_MACRO_FOR("Deprecated key symbol. Use CLUTTER_KEY_Adiaeresis instead.")
#define CLUTTER_Aring 0x0c5 CLUTTER_DEPRECATED_MACRO_FOR("Deprecated key symbol. Use CLUTTER_KEY_Aring instead.")
#define CLUTTER_AE 0x0c6 CLUTTER_DEPRECATED_MACRO_FOR("Deprecated key symbol. Use CLUTTER_KEY_AE instead.")
#define CLUTTER_Ccedilla 0x0c7 CLUTTER_DEPRECATED_MACRO_FOR("Deprecated key symbol. Use CLUTTER_KEY_Ccedilla instead.")
#define CLUTTER_Egrave 0x0c8 CLUTTER_DEPRECATED_MACRO_FOR("Deprecated key symbol. Use CLUTTER_KEY_Egrave instead.")
#define CLUTTER_Eacute 0x0c9 CLUTTER_DEPRECATED_MACRO_FOR("Deprecated key symbol. Use CLUTTER_KEY_Eacute instead.")
#define CLUTTER_Ecircumflex 0x0ca CLUTTER_DEPRECATED_MACRO_FOR("Deprecated key symbol. Use CLUTTER_KEY_Ecircumflex instead.")
#define CLUTTER_Ediaeresis 0x0cb CLUTTER_DEPRECATED_MACRO_FOR("Deprecated key symbol. Use CLUTTER_KEY_Ediaeresis instead.")
#define CLUTTER_Igrave 0x0cc CLUTTER_DEPRECATED_MACRO_FOR("Deprecated key symbol. Use CLUTTER_KEY_Igrave instead.")
#define CLUTTER_Iacute 0x0cd CLUTTER_DEPRECATED_MACRO_FOR("Deprecated key symbol. Use CLUTTER_KEY_Iacute instead.")
#define CLUTTER_Icircumflex 0x0ce CLUTTER_DEPRECATED_MACRO_FOR("Deprecated key symbol. Use CLUTTER_KEY_Icircumflex instead.")
#define CLUTTER_Idiaeresis 0x0cf CLUTTER_DEPRECATED_MACRO_FOR("Deprecated key symbol. Use CLUTTER_KEY_Idiaeresis instead.")
#define CLUTTER_ETH 0x0d0 CLUTTER_DEPRECATED_MACRO_FOR("Deprecated key symbol. Use CLUTTER_KEY_ETH instead.")
#define CLUTTER_Eth 0x0d0 CLUTTER_DEPRECATED_MACRO_FOR("Deprecated key symbol. Use CLUTTER_KEY_Eth instead.")
#define CLUTTER_Ntilde 0x0d1 CLUTTER_DEPRECATED_MACRO_FOR("Deprecated key symbol. Use CLUTTER_KEY_Ntilde instead.")
#define CLUTTER_Ograve 0x0d2 CLUTTER_DEPRECATED_MACRO_FOR("Deprecated key symbol. Use CLUTTER_KEY_Ograve instead.")
#define CLUTTER_Oacute 0x0d3 CLUTTER_DEPRECATED_MACRO_FOR("Deprecated key symbol. Use CLUTTER_KEY_Oacute instead.")
#define CLUTTER_Ocircumflex 0x0d4 CLUTTER_DEPRECATED_MACRO_FOR("Deprecated key symbol. Use CLUTTER_KEY_Ocircumflex instead.")
#define CLUTTER_Otilde 0x0d5 CLUTTER_DEPRECATED_MACRO_FOR("Deprecated key symbol. Use CLUTTER_KEY_Otilde instead.")
#define CLUTTER_Odiaeresis 0x0d6 CLUTTER_DEPRECATED_MACRO_FOR("Deprecated key symbol. Use CLUTTER_KEY_Odiaeresis instead.")
#define CLUTTER_multiply 0x0d7 CLUTTER_DEPRECATED_MACRO_FOR("Deprecated key symbol. Use CLUTTER_KEY_multiply instead.")
#define CLUTTER_Oslash 0x0d8 CLUTTER_DEPRECATED_MACRO_FOR("Deprecated key symbol. Use CLUTTER_KEY_Oslash instead.")
#define CLUTTER_Ooblique 0x0d8 CLUTTER_DEPRECATED_MACRO_FOR("Deprecated key symbol. Use CLUTTER_KEY_Ooblique instead.")
#define CLUTTER_Ugrave 0x0d9 CLUTTER_DEPRECATED_MACRO_FOR("Deprecated key symbol. Use CLUTTER_KEY_Ugrave instead.")
#define CLUTTER_Uacute 0x0da CLUTTER_DEPRECATED_MACRO_FOR("Deprecated key symbol. Use CLUTTER_KEY_Uacute instead.")
#define CLUTTER_Ucircumflex 0x0db CLUTTER_DEPRECATED_MACRO_FOR("Deprecated key symbol. Use CLUTTER_KEY_Ucircumflex instead.")
#define CLUTTER_Udiaeresis 0x0dc CLUTTER_DEPRECATED_MACRO_FOR("Deprecated key symbol. Use CLUTTER_KEY_Udiaeresis instead.")
#define CLUTTER_Yacute 0x0dd CLUTTER_DEPRECATED_MACRO_FOR("Deprecated key symbol. Use CLUTTER_KEY_Yacute instead.")
#define CLUTTER_THORN 0x0de CLUTTER_DEPRECATED_MACRO_FOR("Deprecated key symbol. Use CLUTTER_KEY_THORN instead.")
#define CLUTTER_Thorn 0x0de CLUTTER_DEPRECATED_MACRO_FOR("Deprecated key symbol. Use CLUTTER_KEY_Thorn instead.")
#define CLUTTER_ssharp 0x0df CLUTTER_DEPRECATED_MACRO_FOR("Deprecated key symbol. Use CLUTTER_KEY_ssharp instead.")
#define CLUTTER_agrave 0x0e0 CLUTTER_DEPRECATED_MACRO_FOR("Deprecated key symbol. Use CLUTTER_KEY_agrave instead.")
#define CLUTTER_aacute 0x0e1 CLUTTER_DEPRECATED_MACRO_FOR("Deprecated key symbol. Use CLUTTER_KEY_aacute instead.")
#define CLUTTER_acircumflex 0x0e2 CLUTTER_DEPRECATED_MACRO_FOR("Deprecated key symbol. Use CLUTTER_KEY_acircumflex instead.")
#define CLUTTER_atilde 0x0e3 CLUTTER_DEPRECATED_MACRO_FOR("Deprecated key symbol. Use CLUTTER_KEY_atilde instead.")
#define CLUTTER_adiaeresis 0x0e4 CLUTTER_DEPRECATED_MACRO_FOR("Deprecated key symbol. Use CLUTTER_KEY_adiaeresis instead.")
#define CLUTTER_aring 0x0e5 CLUTTER_DEPRECATED_MACRO_FOR("Deprecated key symbol. Use CLUTTER_KEY_aring instead.")
#define CLUTTER_ae 0x0e6 CLUTTER_DEPRECATED_MACRO_FOR("Deprecated key symbol. Use CLUTTER_KEY_ae instead.")
#define CLUTTER_ccedilla 0x0e7 CLUTTER_DEPRECATED_MACRO_FOR("Deprecated key symbol. Use CLUTTER_KEY_ccedilla instead.")
#define CLUTTER_egrave 0x0e8 CLUTTER_DEPRECATED_MACRO_FOR("Deprecated key symbol. Use CLUTTER_KEY_egrave instead.")
#define CLUTTER_eacute 0x0e9 CLUTTER_DEPRECATED_MACRO_FOR("Deprecated key symbol. Use CLUTTER_KEY_eacute instead.")
#define CLUTTER_ecircumflex 0x0ea CLUTTER_DEPRECATED_MACRO_FOR("Deprecated key symbol. Use CLUTTER_KEY_ecircumflex instead.")
#define CLUTTER_ediaeresis 0x0eb CLUTTER_DEPRECATED_MACRO_FOR("Deprecated key symbol. Use CLUTTER_KEY_ediaeresis instead.")
#define CLUTTER_igrave 0x0ec CLUTTER_DEPRECATED_MACRO_FOR("Deprecated key symbol. Use CLUTTER_KEY_igrave instead.")
#define CLUTTER_iacute 0x0ed CLUTTER_DEPRECATED_MACRO_FOR("Deprecated key symbol. Use CLUTTER_KEY_iacute instead.")
#define CLUTTER_icircumflex 0x0ee CLUTTER_DEPRECATED_MACRO_FOR("Deprecated key symbol. Use CLUTTER_KEY_icircumflex instead.")
#define CLUTTER_idiaeresis 0x0ef CLUTTER_DEPRECATED_MACRO_FOR("Deprecated key symbol. Use CLUTTER_KEY_idiaeresis instead.")
#define CLUTTER_eth 0x0f0 CLUTTER_DEPRECATED_MACRO_FOR("Deprecated key symbol. Use CLUTTER_KEY_eth instead.")
#define CLUTTER_ntilde 0x0f1 CLUTTER_DEPRECATED_MACRO_FOR("Deprecated key symbol. Use CLUTTER_KEY_ntilde instead.")
#define CLUTTER_ograve 0x0f2 CLUTTER_DEPRECATED_MACRO_FOR("Deprecated key symbol. Use CLUTTER_KEY_ograve instead.")
#define CLUTTER_oacute 0x0f3 CLUTTER_DEPRECATED_MACRO_FOR("Deprecated key symbol. Use CLUTTER_KEY_oacute instead.")
#define CLUTTER_ocircumflex 0x0f4 CLUTTER_DEPRECATED_MACRO_FOR("Deprecated key symbol. Use CLUTTER_KEY_ocircumflex instead.")
#define CLUTTER_otilde 0x0f5 CLUTTER_DEPRECATED_MACRO_FOR("Deprecated key symbol. Use CLUTTER_KEY_otilde instead.")
#define CLUTTER_odiaeresis 0x0f6 CLUTTER_DEPRECATED_MACRO_FOR("Deprecated key symbol. Use CLUTTER_KEY_odiaeresis instead.")
#define CLUTTER_division 0x0f7 CLUTTER_DEPRECATED_MACRO_FOR("Deprecated key symbol. Use CLUTTER_KEY_division instead.")
#define CLUTTER_oslash 0x0f8 CLUTTER_DEPRECATED_MACRO_FOR("Deprecated key symbol. Use CLUTTER_KEY_oslash instead.")
#define CLUTTER_ooblique 0x0f8 CLUTTER_DEPRECATED_MACRO_FOR("Deprecated key symbol. Use CLUTTER_KEY_ooblique instead.")
#define CLUTTER_ugrave 0x0f9 CLUTTER_DEPRECATED_MACRO_FOR("Deprecated key symbol. Use CLUTTER_KEY_ugrave instead.")
#define CLUTTER_uacute 0x0fa CLUTTER_DEPRECATED_MACRO_FOR("Deprecated key symbol. Use CLUTTER_KEY_uacute instead.")
#define CLUTTER_ucircumflex 0x0fb CLUTTER_DEPRECATED_MACRO_FOR("Deprecated key symbol. Use CLUTTER_KEY_ucircumflex instead.")
#define CLUTTER_udiaeresis 0x0fc CLUTTER_DEPRECATED_MACRO_FOR("Deprecated key symbol. Use CLUTTER_KEY_udiaeresis instead.")
#define CLUTTER_yacute 0x0fd CLUTTER_DEPRECATED_MACRO_FOR("Deprecated key symbol. Use CLUTTER_KEY_yacute instead.")
#define CLUTTER_thorn 0x0fe CLUTTER_DEPRECATED_MACRO_FOR("Deprecated key symbol. Use CLUTTER_KEY_thorn instead.")
#define CLUTTER_ydiaeresis 0x0ff CLUTTER_DEPRECATED_MACRO_FOR("Deprecated key symbol. Use CLUTTER_KEY_ydiaeresis instead.")
#define CLUTTER_Aogonek 0x1a1 CLUTTER_DEPRECATED_MACRO_FOR("Deprecated key symbol. Use CLUTTER_KEY_Aogonek instead.")
#define CLUTTER_breve 0x1a2 CLUTTER_DEPRECATED_MACRO_FOR("Deprecated key symbol. Use CLUTTER_KEY_breve instead.")
#define CLUTTER_Lstroke 0x1a3 CLUTTER_DEPRECATED_MACRO_FOR("Deprecated key symbol. Use CLUTTER_KEY_Lstroke instead.")
#define CLUTTER_Lcaron 0x1a5 CLUTTER_DEPRECATED_MACRO_FOR("Deprecated key symbol. Use CLUTTER_KEY_Lcaron instead.")
#define CLUTTER_Sacute 0x1a6 CLUTTER_DEPRECATED_MACRO_FOR("Deprecated key symbol. Use CLUTTER_KEY_Sacute instead.")
#define CLUTTER_Scaron 0x1a9 CLUTTER_DEPRECATED_MACRO_FOR("Deprecated key symbol. Use CLUTTER_KEY_Scaron instead.")
#define CLUTTER_Scedilla 0x1aa CLUTTER_DEPRECATED_MACRO_FOR("Deprecated key symbol. Use CLUTTER_KEY_Scedilla instead.")
#define CLUTTER_Tcaron 0x1ab CLUTTER_DEPRECATED_MACRO_FOR("Deprecated key symbol. Use CLUTTER_KEY_Tcaron instead.")
#define CLUTTER_Zacute 0x1ac CLUTTER_DEPRECATED_MACRO_FOR("Deprecated key symbol. Use CLUTTER_KEY_Zacute instead.")
#define CLUTTER_Zcaron 0x1ae CLUTTER_DEPRECATED_MACRO_FOR("Deprecated key symbol. Use CLUTTER_KEY_Zcaron instead.")
#define CLUTTER_Zabovedot 0x1af CLUTTER_DEPRECATED_MACRO_FOR("Deprecated key symbol. Use CLUTTER_KEY_Zabovedot instead.")
#define CLUTTER_aogonek 0x1b1 CLUTTER_DEPRECATED_MACRO_FOR("Deprecated key symbol. Use CLUTTER_KEY_aogonek instead.")
#define CLUTTER_ogonek 0x1b2 CLUTTER_DEPRECATED_MACRO_FOR("Deprecated key symbol. Use CLUTTER_KEY_ogonek instead.")
#define CLUTTER_lstroke 0x1b3 CLUTTER_DEPRECATED_MACRO_FOR("Deprecated key symbol. Use CLUTTER_KEY_lstroke instead.")
#define CLUTTER_lcaron 0x1b5 CLUTTER_DEPRECATED_MACRO_FOR("Deprecated key symbol. Use CLUTTER_KEY_lcaron instead.")
#define CLUTTER_sacute 0x1b6 CLUTTER_DEPRECATED_MACRO_FOR("Deprecated key symbol. Use CLUTTER_KEY_sacute instead.")
#define CLUTTER_caron 0x1b7 CLUTTER_DEPRECATED_MACRO_FOR("Deprecated key symbol. Use CLUTTER_KEY_caron instead.")
#define CLUTTER_scaron 0x1b9 CLUTTER_DEPRECATED_MACRO_FOR("Deprecated key symbol. Use CLUTTER_KEY_scaron instead.")
#define CLUTTER_scedilla 0x1ba CLUTTER_DEPRECATED_MACRO_FOR("Deprecated key symbol. Use CLUTTER_KEY_scedilla instead.")
#define CLUTTER_tcaron 0x1bb CLUTTER_DEPRECATED_MACRO_FOR("Deprecated key symbol. Use CLUTTER_KEY_tcaron instead.")
#define CLUTTER_zacute 0x1bc CLUTTER_DEPRECATED_MACRO_FOR("Deprecated key symbol. Use CLUTTER_KEY_zacute instead.")
#define CLUTTER_doubleacute 0x1bd CLUTTER_DEPRECATED_MACRO_FOR("Deprecated key symbol. Use CLUTTER_KEY_doubleacute instead.")
#define CLUTTER_zcaron 0x1be CLUTTER_DEPRECATED_MACRO_FOR("Deprecated key symbol. Use CLUTTER_KEY_zcaron instead.")
#define CLUTTER_zabovedot 0x1bf CLUTTER_DEPRECATED_MACRO_FOR("Deprecated key symbol. Use CLUTTER_KEY_zabovedot instead.")
#define CLUTTER_Racute 0x1c0 CLUTTER_DEPRECATED_MACRO_FOR("Deprecated key symbol. Use CLUTTER_KEY_Racute instead.")
#define CLUTTER_Abreve 0x1c3 CLUTTER_DEPRECATED_MACRO_FOR("Deprecated key symbol. Use CLUTTER_KEY_Abreve instead.")
#define CLUTTER_Lacute 0x1c5 CLUTTER_DEPRECATED_MACRO_FOR("Deprecated key symbol. Use CLUTTER_KEY_Lacute instead.")
#define CLUTTER_Cacute 0x1c6 CLUTTER_DEPRECATED_MACRO_FOR("Deprecated key symbol. Use CLUTTER_KEY_Cacute instead.")
#define CLUTTER_Ccaron 0x1c8 CLUTTER_DEPRECATED_MACRO_FOR("Deprecated key symbol. Use CLUTTER_KEY_Ccaron instead.")
#define CLUTTER_Eogonek 0x1ca CLUTTER_DEPRECATED_MACRO_FOR("Deprecated key symbol. Use CLUTTER_KEY_Eogonek instead.")
#define CLUTTER_Ecaron 0x1cc CLUTTER_DEPRECATED_MACRO_FOR("Deprecated key symbol. Use CLUTTER_KEY_Ecaron instead.")
#define CLUTTER_Dcaron 0x1cf CLUTTER_DEPRECATED_MACRO_FOR("Deprecated key symbol. Use CLUTTER_KEY_Dcaron instead.")
#define CLUTTER_Dstroke 0x1d0 CLUTTER_DEPRECATED_MACRO_FOR("Deprecated key symbol. Use CLUTTER_KEY_Dstroke instead.")
#define CLUTTER_Nacute 0x1d1 CLUTTER_DEPRECATED_MACRO_FOR("Deprecated key symbol. Use CLUTTER_KEY_Nacute instead.")
#define CLUTTER_Ncaron 0x1d2 CLUTTER_DEPRECATED_MACRO_FOR("Deprecated key symbol. Use CLUTTER_KEY_Ncaron instead.")
#define CLUTTER_Odoubleacute 0x1d5 CLUTTER_DEPRECATED_MACRO_FOR("Deprecated key symbol. Use CLUTTER_KEY_Odoubleacute instead.")
#define CLUTTER_Rcaron 0x1d8 CLUTTER_DEPRECATED_MACRO_FOR("Deprecated key symbol. Use CLUTTER_KEY_Rcaron instead.")
#define CLUTTER_Uring 0x1d9 CLUTTER_DEPRECATED_MACRO_FOR("Deprecated key symbol. Use CLUTTER_KEY_Uring instead.")
#define CLUTTER_Udoubleacute 0x1db CLUTTER_DEPRECATED_MACRO_FOR("Deprecated key symbol. Use CLUTTER_KEY_Udoubleacute instead.")
#define CLUTTER_Tcedilla 0x1de CLUTTER_DEPRECATED_MACRO_FOR("Deprecated key symbol. Use CLUTTER_KEY_Tcedilla instead.")
#define CLUTTER_racute 0x1e0 CLUTTER_DEPRECATED_MACRO_FOR("Deprecated key symbol. Use CLUTTER_KEY_racute instead.")
#define CLUTTER_abreve 0x1e3 CLUTTER_DEPRECATED_MACRO_FOR("Deprecated key symbol. Use CLUTTER_KEY_abreve instead.")
#define CLUTTER_lacute 0x1e5 CLUTTER_DEPRECATED_MACRO_FOR("Deprecated key symbol. Use CLUTTER_KEY_lacute instead.")
#define CLUTTER_cacute 0x1e6 CLUTTER_DEPRECATED_MACRO_FOR("Deprecated key symbol. Use CLUTTER_KEY_cacute instead.")
#define CLUTTER_ccaron 0x1e8 CLUTTER_DEPRECATED_MACRO_FOR("Deprecated key symbol. Use CLUTTER_KEY_ccaron instead.")
#define CLUTTER_eogonek 0x1ea CLUTTER_DEPRECATED_MACRO_FOR("Deprecated key symbol. Use CLUTTER_KEY_eogonek instead.")
#define CLUTTER_ecaron 0x1ec CLUTTER_DEPRECATED_MACRO_FOR("Deprecated key symbol. Use CLUTTER_KEY_ecaron instead.")
#define CLUTTER_dcaron 0x1ef CLUTTER_DEPRECATED_MACRO_FOR("Deprecated key symbol. Use CLUTTER_KEY_dcaron instead.")
#define CLUTTER_dstroke 0x1f0 CLUTTER_DEPRECATED_MACRO_FOR("Deprecated key symbol. Use CLUTTER_KEY_dstroke instead.")
#define CLUTTER_nacute 0x1f1 CLUTTER_DEPRECATED_MACRO_FOR("Deprecated key symbol. Use CLUTTER_KEY_nacute instead.")
#define CLUTTER_ncaron 0x1f2 CLUTTER_DEPRECATED_MACRO_FOR("Deprecated key symbol. Use CLUTTER_KEY_ncaron instead.")
#define CLUTTER_odoubleacute 0x1f5 CLUTTER_DEPRECATED_MACRO_FOR("Deprecated key symbol. Use CLUTTER_KEY_odoubleacute instead.")
#define CLUTTER_rcaron 0x1f8 CLUTTER_DEPRECATED_MACRO_FOR("Deprecated key symbol. Use CLUTTER_KEY_rcaron instead.")
#define CLUTTER_uring 0x1f9 CLUTTER_DEPRECATED_MACRO_FOR("Deprecated key symbol. Use CLUTTER_KEY_uring instead.")
#define CLUTTER_udoubleacute 0x1fb CLUTTER_DEPRECATED_MACRO_FOR("Deprecated key symbol. Use CLUTTER_KEY_udoubleacute instead.")
#define CLUTTER_tcedilla 0x1fe CLUTTER_DEPRECATED_MACRO_FOR("Deprecated key symbol. Use CLUTTER_KEY_tcedilla instead.")
#define CLUTTER_abovedot 0x1ff CLUTTER_DEPRECATED_MACRO_FOR("Deprecated key symbol. Use CLUTTER_KEY_abovedot instead.")
#define CLUTTER_Hstroke 0x2a1 CLUTTER_DEPRECATED_MACRO_FOR("Deprecated key symbol. Use CLUTTER_KEY_Hstroke instead.")
#define CLUTTER_Hcircumflex 0x2a6 CLUTTER_DEPRECATED_MACRO_FOR("Deprecated key symbol. Use CLUTTER_KEY_Hcircumflex instead.")
#define CLUTTER_Iabovedot 0x2a9 CLUTTER_DEPRECATED_MACRO_FOR("Deprecated key symbol. Use CLUTTER_KEY_Iabovedot instead.")
#define CLUTTER_Gbreve 0x2ab CLUTTER_DEPRECATED_MACRO_FOR("Deprecated key symbol. Use CLUTTER_KEY_Gbreve instead.")
#define CLUTTER_Jcircumflex 0x2ac CLUTTER_DEPRECATED_MACRO_FOR("Deprecated key symbol. Use CLUTTER_KEY_Jcircumflex instead.")
#define CLUTTER_hstroke 0x2b1 CLUTTER_DEPRECATED_MACRO_FOR("Deprecated key symbol. Use CLUTTER_KEY_hstroke instead.")
#define CLUTTER_hcircumflex 0x2b6 CLUTTER_DEPRECATED_MACRO_FOR("Deprecated key symbol. Use CLUTTER_KEY_hcircumflex instead.")
#define CLUTTER_idotless 0x2b9 CLUTTER_DEPRECATED_MACRO_FOR("Deprecated key symbol. Use CLUTTER_KEY_idotless instead.")
#define CLUTTER_gbreve 0x2bb CLUTTER_DEPRECATED_MACRO_FOR("Deprecated key symbol. Use CLUTTER_KEY_gbreve instead.")
#define CLUTTER_jcircumflex 0x2bc CLUTTER_DEPRECATED_MACRO_FOR("Deprecated key symbol. Use CLUTTER_KEY_jcircumflex instead.")
#define CLUTTER_Cabovedot 0x2c5 CLUTTER_DEPRECATED_MACRO_FOR("Deprecated key symbol. Use CLUTTER_KEY_Cabovedot instead.")
#define CLUTTER_Ccircumflex 0x2c6 CLUTTER_DEPRECATED_MACRO_FOR("Deprecated key symbol. Use CLUTTER_KEY_Ccircumflex instead.")
#define CLUTTER_Gabovedot 0x2d5 CLUTTER_DEPRECATED_MACRO_FOR("Deprecated key symbol. Use CLUTTER_KEY_Gabovedot instead.")
#define CLUTTER_Gcircumflex 0x2d8 CLUTTER_DEPRECATED_MACRO_FOR("Deprecated key symbol. Use CLUTTER_KEY_Gcircumflex instead.")
#define CLUTTER_Ubreve 0x2dd CLUTTER_DEPRECATED_MACRO_FOR("Deprecated key symbol. Use CLUTTER_KEY_Ubreve instead.")
#define CLUTTER_Scircumflex 0x2de CLUTTER_DEPRECATED_MACRO_FOR("Deprecated key symbol. Use CLUTTER_KEY_Scircumflex instead.")
#define CLUTTER_cabovedot 0x2e5 CLUTTER_DEPRECATED_MACRO_FOR("Deprecated key symbol. Use CLUTTER_KEY_cabovedot instead.")
#define CLUTTER_ccircumflex 0x2e6 CLUTTER_DEPRECATED_MACRO_FOR("Deprecated key symbol. Use CLUTTER_KEY_ccircumflex instead.")
#define CLUTTER_gabovedot 0x2f5 CLUTTER_DEPRECATED_MACRO_FOR("Deprecated key symbol. Use CLUTTER_KEY_gabovedot instead.")
#define CLUTTER_gcircumflex 0x2f8 CLUTTER_DEPRECATED_MACRO_FOR("Deprecated key symbol. Use CLUTTER_KEY_gcircumflex instead.")
#define CLUTTER_ubreve 0x2fd CLUTTER_DEPRECATED_MACRO_FOR("Deprecated key symbol. Use CLUTTER_KEY_ubreve instead.")
#define CLUTTER_scircumflex 0x2fe CLUTTER_DEPRECATED_MACRO_FOR("Deprecated key symbol. Use CLUTTER_KEY_scircumflex instead.")
#define CLUTTER_kra 0x3a2 CLUTTER_DEPRECATED_MACRO_FOR("Deprecated key symbol. Use CLUTTER_KEY_kra instead.")
#define CLUTTER_kappa 0x3a2 CLUTTER_DEPRECATED_MACRO_FOR("Deprecated key symbol. Use CLUTTER_KEY_kappa instead.")
#define CLUTTER_Rcedilla 0x3a3 CLUTTER_DEPRECATED_MACRO_FOR("Deprecated key symbol. Use CLUTTER_KEY_Rcedilla instead.")
#define CLUTTER_Itilde 0x3a5 CLUTTER_DEPRECATED_MACRO_FOR("Deprecated key symbol. Use CLUTTER_KEY_Itilde instead.")
#define CLUTTER_Lcedilla 0x3a6 CLUTTER_DEPRECATED_MACRO_FOR("Deprecated key symbol. Use CLUTTER_KEY_Lcedilla instead.")
#define CLUTTER_Emacron 0x3aa CLUTTER_DEPRECATED_MACRO_FOR("Deprecated key symbol. Use CLUTTER_KEY_Emacron instead.")
#define CLUTTER_Gcedilla 0x3ab CLUTTER_DEPRECATED_MACRO_FOR("Deprecated key symbol. Use CLUTTER_KEY_Gcedilla instead.")
#define CLUTTER_Tslash 0x3ac CLUTTER_DEPRECATED_MACRO_FOR("Deprecated key symbol. Use CLUTTER_KEY_Tslash instead.")
#define CLUTTER_rcedilla 0x3b3 CLUTTER_DEPRECATED_MACRO_FOR("Deprecated key symbol. Use CLUTTER_KEY_rcedilla instead.")
#define CLUTTER_itilde 0x3b5 CLUTTER_DEPRECATED_MACRO_FOR("Deprecated key symbol. Use CLUTTER_KEY_itilde instead.")
#define CLUTTER_lcedilla 0x3b6 CLUTTER_DEPRECATED_MACRO_FOR("Deprecated key symbol. Use CLUTTER_KEY_lcedilla instead.")
#define CLUTTER_emacron 0x3ba CLUTTER_DEPRECATED_MACRO_FOR("Deprecated key symbol. Use CLUTTER_KEY_emacron instead.")
#define CLUTTER_gcedilla 0x3bb CLUTTER_DEPRECATED_MACRO_FOR("Deprecated key symbol. Use CLUTTER_KEY_gcedilla instead.")
#define CLUTTER_tslash 0x3bc CLUTTER_DEPRECATED_MACRO_FOR("Deprecated key symbol. Use CLUTTER_KEY_tslash instead.")
#define CLUTTER_ENG 0x3bd CLUTTER_DEPRECATED_MACRO_FOR("Deprecated key symbol. Use CLUTTER_KEY_ENG instead.")
#define CLUTTER_eng 0x3bf CLUTTER_DEPRECATED_MACRO_FOR("Deprecated key symbol. Use CLUTTER_KEY_eng instead.")
#define CLUTTER_Amacron 0x3c0 CLUTTER_DEPRECATED_MACRO_FOR("Deprecated key symbol. Use CLUTTER_KEY_Amacron instead.")
#define CLUTTER_Iogonek 0x3c7 CLUTTER_DEPRECATED_MACRO_FOR("Deprecated key symbol. Use CLUTTER_KEY_Iogonek instead.")
#define CLUTTER_Eabovedot 0x3cc CLUTTER_DEPRECATED_MACRO_FOR("Deprecated key symbol. Use CLUTTER_KEY_Eabovedot instead.")
#define CLUTTER_Imacron 0x3cf CLUTTER_DEPRECATED_MACRO_FOR("Deprecated key symbol. Use CLUTTER_KEY_Imacron instead.")
#define CLUTTER_Ncedilla 0x3d1 CLUTTER_DEPRECATED_MACRO_FOR("Deprecated key symbol. Use CLUTTER_KEY_Ncedilla instead.")
#define CLUTTER_Omacron 0x3d2 CLUTTER_DEPRECATED_MACRO_FOR("Deprecated key symbol. Use CLUTTER_KEY_Omacron instead.")
#define CLUTTER_Kcedilla 0x3d3 CLUTTER_DEPRECATED_MACRO_FOR("Deprecated key symbol. Use CLUTTER_KEY_Kcedilla instead.")
#define CLUTTER_Uogonek 0x3d9 CLUTTER_DEPRECATED_MACRO_FOR("Deprecated key symbol. Use CLUTTER_KEY_Uogonek instead.")
#define CLUTTER_Utilde 0x3dd CLUTTER_DEPRECATED_MACRO_FOR("Deprecated key symbol. Use CLUTTER_KEY_Utilde instead.")
#define CLUTTER_Umacron 0x3de CLUTTER_DEPRECATED_MACRO_FOR("Deprecated key symbol. Use CLUTTER_KEY_Umacron instead.")
#define CLUTTER_amacron 0x3e0 CLUTTER_DEPRECATED_MACRO_FOR("Deprecated key symbol. Use CLUTTER_KEY_amacron instead.")
#define CLUTTER_iogonek 0x3e7 CLUTTER_DEPRECATED_MACRO_FOR("Deprecated key symbol. Use CLUTTER_KEY_iogonek instead.")
#define CLUTTER_eabovedot 0x3ec CLUTTER_DEPRECATED_MACRO_FOR("Deprecated key symbol. Use CLUTTER_KEY_eabovedot instead.")
#define CLUTTER_imacron 0x3ef CLUTTER_DEPRECATED_MACRO_FOR("Deprecated key symbol. Use CLUTTER_KEY_imacron instead.")
#define CLUTTER_ncedilla 0x3f1 CLUTTER_DEPRECATED_MACRO_FOR("Deprecated key symbol. Use CLUTTER_KEY_ncedilla instead.")
#define CLUTTER_omacron 0x3f2 CLUTTER_DEPRECATED_MACRO_FOR("Deprecated key symbol. Use CLUTTER_KEY_omacron instead.")
#define CLUTTER_kcedilla 0x3f3 CLUTTER_DEPRECATED_MACRO_FOR("Deprecated key symbol. Use CLUTTER_KEY_kcedilla instead.")
#define CLUTTER_uogonek 0x3f9 CLUTTER_DEPRECATED_MACRO_FOR("Deprecated key symbol. Use CLUTTER_KEY_uogonek instead.")
#define CLUTTER_utilde 0x3fd CLUTTER_DEPRECATED_MACRO_FOR("Deprecated key symbol. Use CLUTTER_KEY_utilde instead.")
#define CLUTTER_umacron 0x3fe CLUTTER_DEPRECATED_MACRO_FOR("Deprecated key symbol. Use CLUTTER_KEY_umacron instead.")
#define CLUTTER_Wcircumflex 0x1000174 CLUTTER_DEPRECATED_MACRO_FOR("Deprecated key symbol. Use CLUTTER_KEY_Wcircumflex instead.")
#define CLUTTER_wcircumflex 0x1000175 CLUTTER_DEPRECATED_MACRO_FOR("Deprecated key symbol. Use CLUTTER_KEY_wcircumflex instead.")
#define CLUTTER_Ycircumflex 0x1000176 CLUTTER_DEPRECATED_MACRO_FOR("Deprecated key symbol. Use CLUTTER_KEY_Ycircumflex instead.")
#define CLUTTER_ycircumflex 0x1000177 CLUTTER_DEPRECATED_MACRO_FOR("Deprecated key symbol. Use CLUTTER_KEY_ycircumflex instead.")
#define CLUTTER_Babovedot 0x1001e02 CLUTTER_DEPRECATED_MACRO_FOR("Deprecated key symbol. Use CLUTTER_KEY_Babovedot instead.")
#define CLUTTER_babovedot 0x1001e03 CLUTTER_DEPRECATED_MACRO_FOR("Deprecated key symbol. Use CLUTTER_KEY_babovedot instead.")
#define CLUTTER_Dabovedot 0x1001e0a CLUTTER_DEPRECATED_MACRO_FOR("Deprecated key symbol. Use CLUTTER_KEY_Dabovedot instead.")
#define CLUTTER_dabovedot 0x1001e0b CLUTTER_DEPRECATED_MACRO_FOR("Deprecated key symbol. Use CLUTTER_KEY_dabovedot instead.")
#define CLUTTER_Fabovedot 0x1001e1e CLUTTER_DEPRECATED_MACRO_FOR("Deprecated key symbol. Use CLUTTER_KEY_Fabovedot instead.")
#define CLUTTER_fabovedot 0x1001e1f CLUTTER_DEPRECATED_MACRO_FOR("Deprecated key symbol. Use CLUTTER_KEY_fabovedot instead.")
#define CLUTTER_Mabovedot 0x1001e40 CLUTTER_DEPRECATED_MACRO_FOR("Deprecated key symbol. Use CLUTTER_KEY_Mabovedot instead.")
#define CLUTTER_mabovedot 0x1001e41 CLUTTER_DEPRECATED_MACRO_FOR("Deprecated key symbol. Use CLUTTER_KEY_mabovedot instead.")
#define CLUTTER_Pabovedot 0x1001e56 CLUTTER_DEPRECATED_MACRO_FOR("Deprecated key symbol. Use CLUTTER_KEY_Pabovedot instead.")
#define CLUTTER_pabovedot 0x1001e57 CLUTTER_DEPRECATED_MACRO_FOR("Deprecated key symbol. Use CLUTTER_KEY_pabovedot instead.")
#define CLUTTER_Sabovedot 0x1001e60 CLUTTER_DEPRECATED_MACRO_FOR("Deprecated key symbol. Use CLUTTER_KEY_Sabovedot instead.")
#define CLUTTER_sabovedot 0x1001e61 CLUTTER_DEPRECATED_MACRO_FOR("Deprecated key symbol. Use CLUTTER_KEY_sabovedot instead.")
#define CLUTTER_Tabovedot 0x1001e6a CLUTTER_DEPRECATED_MACRO_FOR("Deprecated key symbol. Use CLUTTER_KEY_Tabovedot instead.")
#define CLUTTER_tabovedot 0x1001e6b CLUTTER_DEPRECATED_MACRO_FOR("Deprecated key symbol. Use CLUTTER_KEY_tabovedot instead.")
#define CLUTTER_Wgrave 0x1001e80 CLUTTER_DEPRECATED_MACRO_FOR("Deprecated key symbol. Use CLUTTER_KEY_Wgrave instead.")
#define CLUTTER_wgrave 0x1001e81 CLUTTER_DEPRECATED_MACRO_FOR("Deprecated key symbol. Use CLUTTER_KEY_wgrave instead.")
#define CLUTTER_Wacute 0x1001e82 CLUTTER_DEPRECATED_MACRO_FOR("Deprecated key symbol. Use CLUTTER_KEY_Wacute instead.")
#define CLUTTER_wacute 0x1001e83 CLUTTER_DEPRECATED_MACRO_FOR("Deprecated key symbol. Use CLUTTER_KEY_wacute instead.")
#define CLUTTER_Wdiaeresis 0x1001e84 CLUTTER_DEPRECATED_MACRO_FOR("Deprecated key symbol. Use CLUTTER_KEY_Wdiaeresis instead.")
#define CLUTTER_wdiaeresis 0x1001e85 CLUTTER_DEPRECATED_MACRO_FOR("Deprecated key symbol. Use CLUTTER_KEY_wdiaeresis instead.")
#define CLUTTER_Ygrave 0x1001ef2 CLUTTER_DEPRECATED_MACRO_FOR("Deprecated key symbol. Use CLUTTER_KEY_Ygrave instead.")
#define CLUTTER_ygrave 0x1001ef3 CLUTTER_DEPRECATED_MACRO_FOR("Deprecated key symbol. Use CLUTTER_KEY_ygrave instead.")
#define CLUTTER_OE 0x13bc CLUTTER_DEPRECATED_MACRO_FOR("Deprecated key symbol. Use CLUTTER_KEY_OE instead.")
#define CLUTTER_oe 0x13bd CLUTTER_DEPRECATED_MACRO_FOR("Deprecated key symbol. Use CLUTTER_KEY_oe instead.")
#define CLUTTER_Ydiaeresis 0x13be CLUTTER_DEPRECATED_MACRO_FOR("Deprecated key symbol. Use CLUTTER_KEY_Ydiaeresis instead.")
#define CLUTTER_overline 0x47e CLUTTER_DEPRECATED_MACRO_FOR("Deprecated key symbol. Use CLUTTER_KEY_overline instead.")
#define CLUTTER_kana_fullstop 0x4a1 CLUTTER_DEPRECATED_MACRO_FOR("Deprecated key symbol. Use CLUTTER_KEY_kana_fullstop instead.")
#define CLUTTER_kana_openingbracket 0x4a2 CLUTTER_DEPRECATED_MACRO_FOR("Deprecated key symbol. Use CLUTTER_KEY_kana_openingbracket instead.")
#define CLUTTER_kana_closingbracket 0x4a3 CLUTTER_DEPRECATED_MACRO_FOR("Deprecated key symbol. Use CLUTTER_KEY_kana_closingbracket instead.")
#define CLUTTER_kana_comma 0x4a4 CLUTTER_DEPRECATED_MACRO_FOR("Deprecated key symbol. Use CLUTTER_KEY_kana_comma instead.")
#define CLUTTER_kana_conjunctive 0x4a5 CLUTTER_DEPRECATED_MACRO_FOR("Deprecated key symbol. Use CLUTTER_KEY_kana_conjunctive instead.")
#define CLUTTER_kana_middledot 0x4a5 CLUTTER_DEPRECATED_MACRO_FOR("Deprecated key symbol. Use CLUTTER_KEY_kana_middledot instead.")
#define CLUTTER_kana_WO 0x4a6 CLUTTER_DEPRECATED_MACRO_FOR("Deprecated key symbol. Use CLUTTER_KEY_kana_WO instead.")
#define CLUTTER_kana_a 0x4a7 CLUTTER_DEPRECATED_MACRO_FOR("Deprecated key symbol. Use CLUTTER_KEY_kana_a instead.")
#define CLUTTER_kana_i 0x4a8 CLUTTER_DEPRECATED_MACRO_FOR("Deprecated key symbol. Use CLUTTER_KEY_kana_i instead.")
#define CLUTTER_kana_u 0x4a9 CLUTTER_DEPRECATED_MACRO_FOR("Deprecated key symbol. Use CLUTTER_KEY_kana_u instead.")
#define CLUTTER_kana_e 0x4aa CLUTTER_DEPRECATED_MACRO_FOR("Deprecated key symbol. Use CLUTTER_KEY_kana_e instead.")
#define CLUTTER_kana_o 0x4ab CLUTTER_DEPRECATED_MACRO_FOR("Deprecated key symbol. Use CLUTTER_KEY_kana_o instead.")
#define CLUTTER_kana_ya 0x4ac CLUTTER_DEPRECATED_MACRO_FOR("Deprecated key symbol. Use CLUTTER_KEY_kana_ya instead.")
#define CLUTTER_kana_yu 0x4ad CLUTTER_DEPRECATED_MACRO_FOR("Deprecated key symbol. Use CLUTTER_KEY_kana_yu instead.")
#define CLUTTER_kana_yo 0x4ae CLUTTER_DEPRECATED_MACRO_FOR("Deprecated key symbol. Use CLUTTER_KEY_kana_yo instead.")
#define CLUTTER_kana_tsu 0x4af CLUTTER_DEPRECATED_MACRO_FOR("Deprecated key symbol. Use CLUTTER_KEY_kana_tsu instead.")
#define CLUTTER_kana_tu 0x4af CLUTTER_DEPRECATED_MACRO_FOR("Deprecated key symbol. Use CLUTTER_KEY_kana_tu instead.")
#define CLUTTER_prolongedsound 0x4b0 CLUTTER_DEPRECATED_MACRO_FOR("Deprecated key symbol. Use CLUTTER_KEY_prolongedsound instead.")
#define CLUTTER_kana_A 0x4b1 CLUTTER_DEPRECATED_MACRO_FOR("Deprecated key symbol. Use CLUTTER_KEY_kana_A instead.")
#define CLUTTER_kana_I 0x4b2 CLUTTER_DEPRECATED_MACRO_FOR("Deprecated key symbol. Use CLUTTER_KEY_kana_I instead.")
#define CLUTTER_kana_U 0x4b3 CLUTTER_DEPRECATED_MACRO_FOR("Deprecated key symbol. Use CLUTTER_KEY_kana_U instead.")
#define CLUTTER_kana_E 0x4b4 CLUTTER_DEPRECATED_MACRO_FOR("Deprecated key symbol. Use CLUTTER_KEY_kana_E instead.")
#define CLUTTER_kana_O 0x4b5 CLUTTER_DEPRECATED_MACRO_FOR("Deprecated key symbol. Use CLUTTER_KEY_kana_O instead.")
#define CLUTTER_kana_KA 0x4b6 CLUTTER_DEPRECATED_MACRO_FOR("Deprecated key symbol. Use CLUTTER_KEY_kana_KA instead.")
#define CLUTTER_kana_KI 0x4b7 CLUTTER_DEPRECATED_MACRO_FOR("Deprecated key symbol. Use CLUTTER_KEY_kana_KI instead.")
#define CLUTTER_kana_KU 0x4b8 CLUTTER_DEPRECATED_MACRO_FOR("Deprecated key symbol. Use CLUTTER_KEY_kana_KU instead.")
#define CLUTTER_kana_KE 0x4b9 CLUTTER_DEPRECATED_MACRO_FOR("Deprecated key symbol. Use CLUTTER_KEY_kana_KE instead.")
#define CLUTTER_kana_KO 0x4ba CLUTTER_DEPRECATED_MACRO_FOR("Deprecated key symbol. Use CLUTTER_KEY_kana_KO instead.")
#define CLUTTER_kana_SA 0x4bb CLUTTER_DEPRECATED_MACRO_FOR("Deprecated key symbol. Use CLUTTER_KEY_kana_SA instead.")
#define CLUTTER_kana_SHI 0x4bc CLUTTER_DEPRECATED_MACRO_FOR("Deprecated key symbol. Use CLUTTER_KEY_kana_SHI instead.")
#define CLUTTER_kana_SU 0x4bd CLUTTER_DEPRECATED_MACRO_FOR("Deprecated key symbol. Use CLUTTER_KEY_kana_SU instead.")
#define CLUTTER_kana_SE 0x4be CLUTTER_DEPRECATED_MACRO_FOR("Deprecated key symbol. Use CLUTTER_KEY_kana_SE instead.")
#define CLUTTER_kana_SO 0x4bf CLUTTER_DEPRECATED_MACRO_FOR("Deprecated key symbol. Use CLUTTER_KEY_kana_SO instead.")
#define CLUTTER_kana_TA 0x4c0 CLUTTER_DEPRECATED_MACRO_FOR("Deprecated key symbol. Use CLUTTER_KEY_kana_TA instead.")
#define CLUTTER_kana_CHI 0x4c1 CLUTTER_DEPRECATED_MACRO_FOR("Deprecated key symbol. Use CLUTTER_KEY_kana_CHI instead.")
#define CLUTTER_kana_TI 0x4c1 CLUTTER_DEPRECATED_MACRO_FOR("Deprecated key symbol. Use CLUTTER_KEY_kana_TI instead.")
#define CLUTTER_kana_TSU 0x4c2 CLUTTER_DEPRECATED_MACRO_FOR("Deprecated key symbol. Use CLUTTER_KEY_kana_TSU instead.")
#define CLUTTER_kana_TU 0x4c2 CLUTTER_DEPRECATED_MACRO_FOR("Deprecated key symbol. Use CLUTTER_KEY_kana_TU instead.")
#define CLUTTER_kana_TE 0x4c3 CLUTTER_DEPRECATED_MACRO_FOR("Deprecated key symbol. Use CLUTTER_KEY_kana_TE instead.")
#define CLUTTER_kana_TO 0x4c4 CLUTTER_DEPRECATED_MACRO_FOR("Deprecated key symbol. Use CLUTTER_KEY_kana_TO instead.")
#define CLUTTER_kana_NA 0x4c5 CLUTTER_DEPRECATED_MACRO_FOR("Deprecated key symbol. Use CLUTTER_KEY_kana_NA instead.")
#define CLUTTER_kana_NI 0x4c6 CLUTTER_DEPRECATED_MACRO_FOR("Deprecated key symbol. Use CLUTTER_KEY_kana_NI instead.")
#define CLUTTER_kana_NU 0x4c7 CLUTTER_DEPRECATED_MACRO_FOR("Deprecated key symbol. Use CLUTTER_KEY_kana_NU instead.")
#define CLUTTER_kana_NE 0x4c8 CLUTTER_DEPRECATED_MACRO_FOR("Deprecated key symbol. Use CLUTTER_KEY_kana_NE instead.")
#define CLUTTER_kana_NO 0x4c9 CLUTTER_DEPRECATED_MACRO_FOR("Deprecated key symbol. Use CLUTTER_KEY_kana_NO instead.")
#define CLUTTER_kana_HA 0x4ca CLUTTER_DEPRECATED_MACRO_FOR("Deprecated key symbol. Use CLUTTER_KEY_kana_HA instead.")
#define CLUTTER_kana_HI 0x4cb CLUTTER_DEPRECATED_MACRO_FOR("Deprecated key symbol. Use CLUTTER_KEY_kana_HI instead.")
#define CLUTTER_kana_FU 0x4cc CLUTTER_DEPRECATED_MACRO_FOR("Deprecated key symbol. Use CLUTTER_KEY_kana_FU instead.")
#define CLUTTER_kana_HU 0x4cc CLUTTER_DEPRECATED_MACRO_FOR("Deprecated key symbol. Use CLUTTER_KEY_kana_HU instead.")
#define CLUTTER_kana_HE 0x4cd CLUTTER_DEPRECATED_MACRO_FOR("Deprecated key symbol. Use CLUTTER_KEY_kana_HE instead.")
#define CLUTTER_kana_HO 0x4ce CLUTTER_DEPRECATED_MACRO_FOR("Deprecated key symbol. Use CLUTTER_KEY_kana_HO instead.")
#define CLUTTER_kana_MA 0x4cf CLUTTER_DEPRECATED_MACRO_FOR("Deprecated key symbol. Use CLUTTER_KEY_kana_MA instead.")
#define CLUTTER_kana_MI 0x4d0 CLUTTER_DEPRECATED_MACRO_FOR("Deprecated key symbol. Use CLUTTER_KEY_kana_MI instead.")
#define CLUTTER_kana_MU 0x4d1 CLUTTER_DEPRECATED_MACRO_FOR("Deprecated key symbol. Use CLUTTER_KEY_kana_MU instead.")
#define CLUTTER_kana_ME 0x4d2 CLUTTER_DEPRECATED_MACRO_FOR("Deprecated key symbol. Use CLUTTER_KEY_kana_ME instead.")
#define CLUTTER_kana_MO 0x4d3 CLUTTER_DEPRECATED_MACRO_FOR("Deprecated key symbol. Use CLUTTER_KEY_kana_MO instead.")
#define CLUTTER_kana_YA 0x4d4 CLUTTER_DEPRECATED_MACRO_FOR("Deprecated key symbol. Use CLUTTER_KEY_kana_YA instead.")
#define CLUTTER_kana_YU 0x4d5 CLUTTER_DEPRECATED_MACRO_FOR("Deprecated key symbol. Use CLUTTER_KEY_kana_YU instead.")
#define CLUTTER_kana_YO 0x4d6 CLUTTER_DEPRECATED_MACRO_FOR("Deprecated key symbol. Use CLUTTER_KEY_kana_YO instead.")
#define CLUTTER_kana_RA 0x4d7 CLUTTER_DEPRECATED_MACRO_FOR("Deprecated key symbol. Use CLUTTER_KEY_kana_RA instead.")
#define CLUTTER_kana_RI 0x4d8 CLUTTER_DEPRECATED_MACRO_FOR("Deprecated key symbol. Use CLUTTER_KEY_kana_RI instead.")
#define CLUTTER_kana_RU 0x4d9 CLUTTER_DEPRECATED_MACRO_FOR("Deprecated key symbol. Use CLUTTER_KEY_kana_RU instead.")
#define CLUTTER_kana_RE 0x4da CLUTTER_DEPRECATED_MACRO_FOR("Deprecated key symbol. Use CLUTTER_KEY_kana_RE instead.")
#define CLUTTER_kana_RO 0x4db CLUTTER_DEPRECATED_MACRO_FOR("Deprecated key symbol. Use CLUTTER_KEY_kana_RO instead.")
#define CLUTTER_kana_WA 0x4dc CLUTTER_DEPRECATED_MACRO_FOR("Deprecated key symbol. Use CLUTTER_KEY_kana_WA instead.")
#define CLUTTER_kana_N 0x4dd CLUTTER_DEPRECATED_MACRO_FOR("Deprecated key symbol. Use CLUTTER_KEY_kana_N instead.")
#define CLUTTER_voicedsound 0x4de CLUTTER_DEPRECATED_MACRO_FOR("Deprecated key symbol. Use CLUTTER_KEY_voicedsound instead.")
#define CLUTTER_semivoicedsound 0x4df CLUTTER_DEPRECATED_MACRO_FOR("Deprecated key symbol. Use CLUTTER_KEY_semivoicedsound instead.")
#define CLUTTER_kana_switch 0xff7e CLUTTER_DEPRECATED_MACRO_FOR("Deprecated key symbol. Use CLUTTER_KEY_kana_switch instead.")
#define CLUTTER_Farsi_0 0x10006f0 CLUTTER_DEPRECATED_MACRO_FOR("Deprecated key symbol. Use CLUTTER_KEY_Farsi_0 instead.")
#define CLUTTER_Farsi_1 0x10006f1 CLUTTER_DEPRECATED_MACRO_FOR("Deprecated key symbol. Use CLUTTER_KEY_Farsi_1 instead.")
#define CLUTTER_Farsi_2 0x10006f2 CLUTTER_DEPRECATED_MACRO_FOR("Deprecated key symbol. Use CLUTTER_KEY_Farsi_2 instead.")
#define CLUTTER_Farsi_3 0x10006f3 CLUTTER_DEPRECATED_MACRO_FOR("Deprecated key symbol. Use CLUTTER_KEY_Farsi_3 instead.")
#define CLUTTER_Farsi_4 0x10006f4 CLUTTER_DEPRECATED_MACRO_FOR("Deprecated key symbol. Use CLUTTER_KEY_Farsi_4 instead.")
#define CLUTTER_Farsi_5 0x10006f5 CLUTTER_DEPRECATED_MACRO_FOR("Deprecated key symbol. Use CLUTTER_KEY_Farsi_5 instead.")
#define CLUTTER_Farsi_6 0x10006f6 CLUTTER_DEPRECATED_MACRO_FOR("Deprecated key symbol. Use CLUTTER_KEY_Farsi_6 instead.")
#define CLUTTER_Farsi_7 0x10006f7 CLUTTER_DEPRECATED_MACRO_FOR("Deprecated key symbol. Use CLUTTER_KEY_Farsi_7 instead.")
#define CLUTTER_Farsi_8 0x10006f8 CLUTTER_DEPRECATED_MACRO_FOR("Deprecated key symbol. Use CLUTTER_KEY_Farsi_8 instead.")
#define CLUTTER_Farsi_9 0x10006f9 CLUTTER_DEPRECATED_MACRO_FOR("Deprecated key symbol. Use CLUTTER_KEY_Farsi_9 instead.")
#define CLUTTER_Arabic_percent 0x100066a CLUTTER_DEPRECATED_MACRO_FOR("Deprecated key symbol. Use CLUTTER_KEY_Arabic_percent instead.")
#define CLUTTER_Arabic_superscript_alef 0x1000670 CLUTTER_DEPRECATED_MACRO_FOR("Deprecated key symbol. Use CLUTTER_KEY_Arabic_superscript_alef instead.")
#define CLUTTER_Arabic_tteh 0x1000679 CLUTTER_DEPRECATED_MACRO_FOR("Deprecated key symbol. Use CLUTTER_KEY_Arabic_tteh instead.")
#define CLUTTER_Arabic_peh 0x100067e CLUTTER_DEPRECATED_MACRO_FOR("Deprecated key symbol. Use CLUTTER_KEY_Arabic_peh instead.")
#define CLUTTER_Arabic_tcheh 0x1000686 CLUTTER_DEPRECATED_MACRO_FOR("Deprecated key symbol. Use CLUTTER_KEY_Arabic_tcheh instead.")
#define CLUTTER_Arabic_ddal 0x1000688 CLUTTER_DEPRECATED_MACRO_FOR("Deprecated key symbol. Use CLUTTER_KEY_Arabic_ddal instead.")
#define CLUTTER_Arabic_rreh 0x1000691 CLUTTER_DEPRECATED_MACRO_FOR("Deprecated key symbol. Use CLUTTER_KEY_Arabic_rreh instead.")
#define CLUTTER_Arabic_comma 0x5ac CLUTTER_DEPRECATED_MACRO_FOR("Deprecated key symbol. Use CLUTTER_KEY_Arabic_comma instead.")
#define CLUTTER_Arabic_fullstop 0x10006d4 CLUTTER_DEPRECATED_MACRO_FOR("Deprecated key symbol. Use CLUTTER_KEY_Arabic_fullstop instead.")
#define CLUTTER_Arabic_0 0x1000660 CLUTTER_DEPRECATED_MACRO_FOR("Deprecated key symbol. Use CLUTTER_KEY_Arabic_0 instead.")
#define CLUTTER_Arabic_1 0x1000661 CLUTTER_DEPRECATED_MACRO_FOR("Deprecated key symbol. Use CLUTTER_KEY_Arabic_1 instead.")
#define CLUTTER_Arabic_2 0x1000662 CLUTTER_DEPRECATED_MACRO_FOR("Deprecated key symbol. Use CLUTTER_KEY_Arabic_2 instead.")
#define CLUTTER_Arabic_3 0x1000663 CLUTTER_DEPRECATED_MACRO_FOR("Deprecated key symbol. Use CLUTTER_KEY_Arabic_3 instead.")
#define CLUTTER_Arabic_4 0x1000664 CLUTTER_DEPRECATED_MACRO_FOR("Deprecated key symbol. Use CLUTTER_KEY_Arabic_4 instead.")
#define CLUTTER_Arabic_5 0x1000665 CLUTTER_DEPRECATED_MACRO_FOR("Deprecated key symbol. Use CLUTTER_KEY_Arabic_5 instead.")
#define CLUTTER_Arabic_6 0x1000666 CLUTTER_DEPRECATED_MACRO_FOR("Deprecated key symbol. Use CLUTTER_KEY_Arabic_6 instead.")
#define CLUTTER_Arabic_7 0x1000667 CLUTTER_DEPRECATED_MACRO_FOR("Deprecated key symbol. Use CLUTTER_KEY_Arabic_7 instead.")
#define CLUTTER_Arabic_8 0x1000668 CLUTTER_DEPRECATED_MACRO_FOR("Deprecated key symbol. Use CLUTTER_KEY_Arabic_8 instead.")
#define CLUTTER_Arabic_9 0x1000669 CLUTTER_DEPRECATED_MACRO_FOR("Deprecated key symbol. Use CLUTTER_KEY_Arabic_9 instead.")
#define CLUTTER_Arabic_semicolon 0x5bb CLUTTER_DEPRECATED_MACRO_FOR("Deprecated key symbol. Use CLUTTER_KEY_Arabic_semicolon instead.")
#define CLUTTER_Arabic_question_mark 0x5bf CLUTTER_DEPRECATED_MACRO_FOR("Deprecated key symbol. Use CLUTTER_KEY_Arabic_question_mark instead.")
#define CLUTTER_Arabic_hamza 0x5c1 CLUTTER_DEPRECATED_MACRO_FOR("Deprecated key symbol. Use CLUTTER_KEY_Arabic_hamza instead.")
#define CLUTTER_Arabic_maddaonalef 0x5c2 CLUTTER_DEPRECATED_MACRO_FOR("Deprecated key symbol. Use CLUTTER_KEY_Arabic_maddaonalef instead.")
#define CLUTTER_Arabic_hamzaonalef 0x5c3 CLUTTER_DEPRECATED_MACRO_FOR("Deprecated key symbol. Use CLUTTER_KEY_Arabic_hamzaonalef instead.")
#define CLUTTER_Arabic_hamzaonwaw 0x5c4 CLUTTER_DEPRECATED_MACRO_FOR("Deprecated key symbol. Use CLUTTER_KEY_Arabic_hamzaonwaw instead.")
#define CLUTTER_Arabic_hamzaunderalef 0x5c5 CLUTTER_DEPRECATED_MACRO_FOR("Deprecated key symbol. Use CLUTTER_KEY_Arabic_hamzaunderalef instead.")
#define CLUTTER_Arabic_hamzaonyeh 0x5c6 CLUTTER_DEPRECATED_MACRO_FOR("Deprecated key symbol. Use CLUTTER_KEY_Arabic_hamzaonyeh instead.")
#define CLUTTER_Arabic_alef 0x5c7 CLUTTER_DEPRECATED_MACRO_FOR("Deprecated key symbol. Use CLUTTER_KEY_Arabic_alef instead.")
#define CLUTTER_Arabic_beh 0x5c8 CLUTTER_DEPRECATED_MACRO_FOR("Deprecated key symbol. Use CLUTTER_KEY_Arabic_beh instead.")
#define CLUTTER_Arabic_tehmarbuta 0x5c9 CLUTTER_DEPRECATED_MACRO_FOR("Deprecated key symbol. Use CLUTTER_KEY_Arabic_tehmarbuta instead.")
#define CLUTTER_Arabic_teh 0x5ca CLUTTER_DEPRECATED_MACRO_FOR("Deprecated key symbol. Use CLUTTER_KEY_Arabic_teh instead.")
#define CLUTTER_Arabic_theh 0x5cb CLUTTER_DEPRECATED_MACRO_FOR("Deprecated key symbol. Use CLUTTER_KEY_Arabic_theh instead.")
#define CLUTTER_Arabic_jeem 0x5cc CLUTTER_DEPRECATED_MACRO_FOR("Deprecated key symbol. Use CLUTTER_KEY_Arabic_jeem instead.")
#define CLUTTER_Arabic_hah 0x5cd CLUTTER_DEPRECATED_MACRO_FOR("Deprecated key symbol. Use CLUTTER_KEY_Arabic_hah instead.")
#define CLUTTER_Arabic_khah 0x5ce CLUTTER_DEPRECATED_MACRO_FOR("Deprecated key symbol. Use CLUTTER_KEY_Arabic_khah instead.")
#define CLUTTER_Arabic_dal 0x5cf CLUTTER_DEPRECATED_MACRO_FOR("Deprecated key symbol. Use CLUTTER_KEY_Arabic_dal instead.")
#define CLUTTER_Arabic_thal 0x5d0 CLUTTER_DEPRECATED_MACRO_FOR("Deprecated key symbol. Use CLUTTER_KEY_Arabic_thal instead.")
#define CLUTTER_Arabic_ra 0x5d1 CLUTTER_DEPRECATED_MACRO_FOR("Deprecated key symbol. Use CLUTTER_KEY_Arabic_ra instead.")
#define CLUTTER_Arabic_zain 0x5d2 CLUTTER_DEPRECATED_MACRO_FOR("Deprecated key symbol. Use CLUTTER_KEY_Arabic_zain instead.")
#define CLUTTER_Arabic_seen 0x5d3 CLUTTER_DEPRECATED_MACRO_FOR("Deprecated key symbol. Use CLUTTER_KEY_Arabic_seen instead.")
#define CLUTTER_Arabic_sheen 0x5d4 CLUTTER_DEPRECATED_MACRO_FOR("Deprecated key symbol. Use CLUTTER_KEY_Arabic_sheen instead.")
#define CLUTTER_Arabic_sad 0x5d5 CLUTTER_DEPRECATED_MACRO_FOR("Deprecated key symbol. Use CLUTTER_KEY_Arabic_sad instead.")
#define CLUTTER_Arabic_dad 0x5d6 CLUTTER_DEPRECATED_MACRO_FOR("Deprecated key symbol. Use CLUTTER_KEY_Arabic_dad instead.")
#define CLUTTER_Arabic_tah 0x5d7 CLUTTER_DEPRECATED_MACRO_FOR("Deprecated key symbol. Use CLUTTER_KEY_Arabic_tah instead.")
#define CLUTTER_Arabic_zah 0x5d8 CLUTTER_DEPRECATED_MACRO_FOR("Deprecated key symbol. Use CLUTTER_KEY_Arabic_zah instead.")
#define CLUTTER_Arabic_ain 0x5d9 CLUTTER_DEPRECATED_MACRO_FOR("Deprecated key symbol. Use CLUTTER_KEY_Arabic_ain instead.")
#define CLUTTER_Arabic_ghain 0x5da CLUTTER_DEPRECATED_MACRO_FOR("Deprecated key symbol. Use CLUTTER_KEY_Arabic_ghain instead.")
#define CLUTTER_Arabic_tatweel 0x5e0 CLUTTER_DEPRECATED_MACRO_FOR("Deprecated key symbol. Use CLUTTER_KEY_Arabic_tatweel instead.")
#define CLUTTER_Arabic_feh 0x5e1 CLUTTER_DEPRECATED_MACRO_FOR("Deprecated key symbol. Use CLUTTER_KEY_Arabic_feh instead.")
#define CLUTTER_Arabic_qaf 0x5e2 CLUTTER_DEPRECATED_MACRO_FOR("Deprecated key symbol. Use CLUTTER_KEY_Arabic_qaf instead.")
#define CLUTTER_Arabic_kaf 0x5e3 CLUTTER_DEPRECATED_MACRO_FOR("Deprecated key symbol. Use CLUTTER_KEY_Arabic_kaf instead.")
#define CLUTTER_Arabic_lam 0x5e4 CLUTTER_DEPRECATED_MACRO_FOR("Deprecated key symbol. Use CLUTTER_KEY_Arabic_lam instead.")
#define CLUTTER_Arabic_meem 0x5e5 CLUTTER_DEPRECATED_MACRO_FOR("Deprecated key symbol. Use CLUTTER_KEY_Arabic_meem instead.")
#define CLUTTER_Arabic_noon 0x5e6 CLUTTER_DEPRECATED_MACRO_FOR("Deprecated key symbol. Use CLUTTER_KEY_Arabic_noon instead.")
#define CLUTTER_Arabic_ha 0x5e7 CLUTTER_DEPRECATED_MACRO_FOR("Deprecated key symbol. Use CLUTTER_KEY_Arabic_ha instead.")
#define CLUTTER_Arabic_heh 0x5e7 CLUTTER_DEPRECATED_MACRO_FOR("Deprecated key symbol. Use CLUTTER_KEY_Arabic_heh instead.")
#define CLUTTER_Arabic_waw 0x5e8 CLUTTER_DEPRECATED_MACRO_FOR("Deprecated key symbol. Use CLUTTER_KEY_Arabic_waw instead.")
#define CLUTTER_Arabic_alefmaksura 0x5e9 CLUTTER_DEPRECATED_MACRO_FOR("Deprecated key symbol. Use CLUTTER_KEY_Arabic_alefmaksura instead.")
#define CLUTTER_Arabic_yeh 0x5ea CLUTTER_DEPRECATED_MACRO_FOR("Deprecated key symbol. Use CLUTTER_KEY_Arabic_yeh instead.")
#define CLUTTER_Arabic_fathatan 0x5eb CLUTTER_DEPRECATED_MACRO_FOR("Deprecated key symbol. Use CLUTTER_KEY_Arabic_fathatan instead.")
#define CLUTTER_Arabic_dammatan 0x5ec CLUTTER_DEPRECATED_MACRO_FOR("Deprecated key symbol. Use CLUTTER_KEY_Arabic_dammatan instead.")
#define CLUTTER_Arabic_kasratan 0x5ed CLUTTER_DEPRECATED_MACRO_FOR("Deprecated key symbol. Use CLUTTER_KEY_Arabic_kasratan instead.")
#define CLUTTER_Arabic_fatha 0x5ee CLUTTER_DEPRECATED_MACRO_FOR("Deprecated key symbol. Use CLUTTER_KEY_Arabic_fatha instead.")
#define CLUTTER_Arabic_damma 0x5ef CLUTTER_DEPRECATED_MACRO_FOR("Deprecated key symbol. Use CLUTTER_KEY_Arabic_damma instead.")
#define CLUTTER_Arabic_kasra 0x5f0 CLUTTER_DEPRECATED_MACRO_FOR("Deprecated key symbol. Use CLUTTER_KEY_Arabic_kasra instead.")
#define CLUTTER_Arabic_shadda 0x5f1 CLUTTER_DEPRECATED_MACRO_FOR("Deprecated key symbol. Use CLUTTER_KEY_Arabic_shadda instead.")
#define CLUTTER_Arabic_sukun 0x5f2 CLUTTER_DEPRECATED_MACRO_FOR("Deprecated key symbol. Use CLUTTER_KEY_Arabic_sukun instead.")
#define CLUTTER_Arabic_madda_above 0x1000653 CLUTTER_DEPRECATED_MACRO_FOR("Deprecated key symbol. Use CLUTTER_KEY_Arabic_madda_above instead.")
#define CLUTTER_Arabic_hamza_above 0x1000654 CLUTTER_DEPRECATED_MACRO_FOR("Deprecated key symbol. Use CLUTTER_KEY_Arabic_hamza_above instead.")
#define CLUTTER_Arabic_hamza_below 0x1000655 CLUTTER_DEPRECATED_MACRO_FOR("Deprecated key symbol. Use CLUTTER_KEY_Arabic_hamza_below instead.")
#define CLUTTER_Arabic_jeh 0x1000698 CLUTTER_DEPRECATED_MACRO_FOR("Deprecated key symbol. Use CLUTTER_KEY_Arabic_jeh instead.")
#define CLUTTER_Arabic_veh 0x10006a4 CLUTTER_DEPRECATED_MACRO_FOR("Deprecated key symbol. Use CLUTTER_KEY_Arabic_veh instead.")
#define CLUTTER_Arabic_keheh 0x10006a9 CLUTTER_DEPRECATED_MACRO_FOR("Deprecated key symbol. Use CLUTTER_KEY_Arabic_keheh instead.")
#define CLUTTER_Arabic_gaf 0x10006af CLUTTER_DEPRECATED_MACRO_FOR("Deprecated key symbol. Use CLUTTER_KEY_Arabic_gaf instead.")
#define CLUTTER_Arabic_noon_ghunna 0x10006ba CLUTTER_DEPRECATED_MACRO_FOR("Deprecated key symbol. Use CLUTTER_KEY_Arabic_noon_ghunna instead.")
#define CLUTTER_Arabic_heh_doachashmee 0x10006be CLUTTER_DEPRECATED_MACRO_FOR("Deprecated key symbol. Use CLUTTER_KEY_Arabic_heh_doachashmee instead.")
#define CLUTTER_Farsi_yeh 0x10006cc CLUTTER_DEPRECATED_MACRO_FOR("Deprecated key symbol. Use CLUTTER_KEY_Farsi_yeh instead.")
#define CLUTTER_Arabic_farsi_yeh 0x10006cc CLUTTER_DEPRECATED_MACRO_FOR("Deprecated key symbol. Use CLUTTER_KEY_Arabic_farsi_yeh instead.")
#define CLUTTER_Arabic_yeh_baree 0x10006d2 CLUTTER_DEPRECATED_MACRO_FOR("Deprecated key symbol. Use CLUTTER_KEY_Arabic_yeh_baree instead.")
#define CLUTTER_Arabic_heh_goal 0x10006c1 CLUTTER_DEPRECATED_MACRO_FOR("Deprecated key symbol. Use CLUTTER_KEY_Arabic_heh_goal instead.")
#define CLUTTER_Arabic_switch 0xff7e CLUTTER_DEPRECATED_MACRO_FOR("Deprecated key symbol. Use CLUTTER_KEY_Arabic_switch instead.")
#define CLUTTER_Cyrillic_GHE_bar 0x1000492 CLUTTER_DEPRECATED_MACRO_FOR("Deprecated key symbol. Use CLUTTER_KEY_Cyrillic_GHE_bar instead.")
#define CLUTTER_Cyrillic_ghe_bar 0x1000493 CLUTTER_DEPRECATED_MACRO_FOR("Deprecated key symbol. Use CLUTTER_KEY_Cyrillic_ghe_bar instead.")
#define CLUTTER_Cyrillic_ZHE_descender 0x1000496 CLUTTER_DEPRECATED_MACRO_FOR("Deprecated key symbol. Use CLUTTER_KEY_Cyrillic_ZHE_descender instead.")
#define CLUTTER_Cyrillic_zhe_descender 0x1000497 CLUTTER_DEPRECATED_MACRO_FOR("Deprecated key symbol. Use CLUTTER_KEY_Cyrillic_zhe_descender instead.")
#define CLUTTER_Cyrillic_KA_descender 0x100049a CLUTTER_DEPRECATED_MACRO_FOR("Deprecated key symbol. Use CLUTTER_KEY_Cyrillic_KA_descender instead.")
#define CLUTTER_Cyrillic_ka_descender 0x100049b CLUTTER_DEPRECATED_MACRO_FOR("Deprecated key symbol. Use CLUTTER_KEY_Cyrillic_ka_descender instead.")
#define CLUTTER_Cyrillic_KA_vertstroke 0x100049c CLUTTER_DEPRECATED_MACRO_FOR("Deprecated key symbol. Use CLUTTER_KEY_Cyrillic_KA_vertstroke instead.")
#define CLUTTER_Cyrillic_ka_vertstroke 0x100049d CLUTTER_DEPRECATED_MACRO_FOR("Deprecated key symbol. Use CLUTTER_KEY_Cyrillic_ka_vertstroke instead.")
#define CLUTTER_Cyrillic_EN_descender 0x10004a2 CLUTTER_DEPRECATED_MACRO_FOR("Deprecated key symbol. Use CLUTTER_KEY_Cyrillic_EN_descender instead.")
#define CLUTTER_Cyrillic_en_descender 0x10004a3 CLUTTER_DEPRECATED_MACRO_FOR("Deprecated key symbol. Use CLUTTER_KEY_Cyrillic_en_descender instead.")
#define CLUTTER_Cyrillic_U_straight 0x10004ae CLUTTER_DEPRECATED_MACRO_FOR("Deprecated key symbol. Use CLUTTER_KEY_Cyrillic_U_straight instead.")
#define CLUTTER_Cyrillic_u_straight 0x10004af CLUTTER_DEPRECATED_MACRO_FOR("Deprecated key symbol. Use CLUTTER_KEY_Cyrillic_u_straight instead.")
#define CLUTTER_Cyrillic_U_straight_bar 0x10004b0 CLUTTER_DEPRECATED_MACRO_FOR("Deprecated key symbol. Use CLUTTER_KEY_Cyrillic_U_straight_bar instead.")
#define CLUTTER_Cyrillic_u_straight_bar 0x10004b1 CLUTTER_DEPRECATED_MACRO_FOR("Deprecated key symbol. Use CLUTTER_KEY_Cyrillic_u_straight_bar instead.")
#define CLUTTER_Cyrillic_HA_descender 0x10004b2 CLUTTER_DEPRECATED_MACRO_FOR("Deprecated key symbol. Use CLUTTER_KEY_Cyrillic_HA_descender instead.")
#define CLUTTER_Cyrillic_ha_descender 0x10004b3 CLUTTER_DEPRECATED_MACRO_FOR("Deprecated key symbol. Use CLUTTER_KEY_Cyrillic_ha_descender instead.")
#define CLUTTER_Cyrillic_CHE_descender 0x10004b6 CLUTTER_DEPRECATED_MACRO_FOR("Deprecated key symbol. Use CLUTTER_KEY_Cyrillic_CHE_descender instead.")
#define CLUTTER_Cyrillic_che_descender 0x10004b7 CLUTTER_DEPRECATED_MACRO_FOR("Deprecated key symbol. Use CLUTTER_KEY_Cyrillic_che_descender instead.")
#define CLUTTER_Cyrillic_CHE_vertstroke 0x10004b8 CLUTTER_DEPRECATED_MACRO_FOR("Deprecated key symbol. Use CLUTTER_KEY_Cyrillic_CHE_vertstroke instead.")
#define CLUTTER_Cyrillic_che_vertstroke 0x10004b9 CLUTTER_DEPRECATED_MACRO_FOR("Deprecated key symbol. Use CLUTTER_KEY_Cyrillic_che_vertstroke instead.")
#define CLUTTER_Cyrillic_SHHA 0x10004ba CLUTTER_DEPRECATED_MACRO_FOR("Deprecated key symbol. Use CLUTTER_KEY_Cyrillic_SHHA instead.")
#define CLUTTER_Cyrillic_shha 0x10004bb CLUTTER_DEPRECATED_MACRO_FOR("Deprecated key symbol. Use CLUTTER_KEY_Cyrillic_shha instead.")
#define CLUTTER_Cyrillic_SCHWA 0x10004d8 CLUTTER_DEPRECATED_MACRO_FOR("Deprecated key symbol. Use CLUTTER_KEY_Cyrillic_SCHWA instead.")
#define CLUTTER_Cyrillic_schwa 0x10004d9 CLUTTER_DEPRECATED_MACRO_FOR("Deprecated key symbol. Use CLUTTER_KEY_Cyrillic_schwa instead.")
#define CLUTTER_Cyrillic_I_macron 0x10004e2 CLUTTER_DEPRECATED_MACRO_FOR("Deprecated key symbol. Use CLUTTER_KEY_Cyrillic_I_macron instead.")
#define CLUTTER_Cyrillic_i_macron 0x10004e3 CLUTTER_DEPRECATED_MACRO_FOR("Deprecated key symbol. Use CLUTTER_KEY_Cyrillic_i_macron instead.")
#define CLUTTER_Cyrillic_O_bar 0x10004e8 CLUTTER_DEPRECATED_MACRO_FOR("Deprecated key symbol. Use CLUTTER_KEY_Cyrillic_O_bar instead.")
#define CLUTTER_Cyrillic_o_bar 0x10004e9 CLUTTER_DEPRECATED_MACRO_FOR("Deprecated key symbol. Use CLUTTER_KEY_Cyrillic_o_bar instead.")
#define CLUTTER_Cyrillic_U_macron 0x10004ee CLUTTER_DEPRECATED_MACRO_FOR("Deprecated key symbol. Use CLUTTER_KEY_Cyrillic_U_macron instead.")
#define CLUTTER_Cyrillic_u_macron 0x10004ef CLUTTER_DEPRECATED_MACRO_FOR("Deprecated key symbol. Use CLUTTER_KEY_Cyrillic_u_macron instead.")
#define CLUTTER_Serbian_dje 0x6a1 CLUTTER_DEPRECATED_MACRO_FOR("Deprecated key symbol. Use CLUTTER_KEY_Serbian_dje instead.")
#define CLUTTER_Macedonia_gje 0x6a2 CLUTTER_DEPRECATED_MACRO_FOR("Deprecated key symbol. Use CLUTTER_KEY_Macedonia_gje instead.")
#define CLUTTER_Cyrillic_io 0x6a3 CLUTTER_DEPRECATED_MACRO_FOR("Deprecated key symbol. Use CLUTTER_KEY_Cyrillic_io instead.")
#define CLUTTER_Ukrainian_ie 0x6a4 CLUTTER_DEPRECATED_MACRO_FOR("Deprecated key symbol. Use CLUTTER_KEY_Ukrainian_ie instead.")
#define CLUTTER_Ukranian_je 0x6a4 CLUTTER_DEPRECATED_MACRO_FOR("Deprecated key symbol. Use CLUTTER_KEY_Ukranian_je instead.")
#define CLUTTER_Macedonia_dse 0x6a5 CLUTTER_DEPRECATED_MACRO_FOR("Deprecated key symbol. Use CLUTTER_KEY_Macedonia_dse instead.")
#define CLUTTER_Ukrainian_i 0x6a6 CLUTTER_DEPRECATED_MACRO_FOR("Deprecated key symbol. Use CLUTTER_KEY_Ukrainian_i instead.")
#define CLUTTER_Ukranian_i 0x6a6 CLUTTER_DEPRECATED_MACRO_FOR("Deprecated key symbol. Use CLUTTER_KEY_Ukranian_i instead.")
#define CLUTTER_Ukrainian_yi 0x6a7 CLUTTER_DEPRECATED_MACRO_FOR("Deprecated key symbol. Use CLUTTER_KEY_Ukrainian_yi instead.")
#define CLUTTER_Ukranian_yi 0x6a7 CLUTTER_DEPRECATED_MACRO_FOR("Deprecated key symbol. Use CLUTTER_KEY_Ukranian_yi instead.")
#define CLUTTER_Cyrillic_je 0x6a8 CLUTTER_DEPRECATED_MACRO_FOR("Deprecated key symbol. Use CLUTTER_KEY_Cyrillic_je instead.")
#define CLUTTER_Serbian_je 0x6a8 CLUTTER_DEPRECATED_MACRO_FOR("Deprecated key symbol. Use CLUTTER_KEY_Serbian_je instead.")
#define CLUTTER_Cyrillic_lje 0x6a9 CLUTTER_DEPRECATED_MACRO_FOR("Deprecated key symbol. Use CLUTTER_KEY_Cyrillic_lje instead.")
#define CLUTTER_Serbian_lje 0x6a9 CLUTTER_DEPRECATED_MACRO_FOR("Deprecated key symbol. Use CLUTTER_KEY_Serbian_lje instead.")
#define CLUTTER_Cyrillic_nje 0x6aa CLUTTER_DEPRECATED_MACRO_FOR("Deprecated key symbol. Use CLUTTER_KEY_Cyrillic_nje instead.")
#define CLUTTER_Serbian_nje 0x6aa CLUTTER_DEPRECATED_MACRO_FOR("Deprecated key symbol. Use CLUTTER_KEY_Serbian_nje instead.")
#define CLUTTER_Serbian_tshe 0x6ab CLUTTER_DEPRECATED_MACRO_FOR("Deprecated key symbol. Use CLUTTER_KEY_Serbian_tshe instead.")
#define CLUTTER_Macedonia_kje 0x6ac CLUTTER_DEPRECATED_MACRO_FOR("Deprecated key symbol. Use CLUTTER_KEY_Macedonia_kje instead.")
#define CLUTTER_Ukrainian_ghe_with_upturn 0x6ad CLUTTER_DEPRECATED_MACRO_FOR("Deprecated key symbol. Use CLUTTER_KEY_Ukrainian_ghe_with_upturn instead.")
#define CLUTTER_Byelorussian_shortu 0x6ae CLUTTER_DEPRECATED_MACRO_FOR("Deprecated key symbol. Use CLUTTER_KEY_Byelorussian_shortu instead.")
#define CLUTTER_Cyrillic_dzhe 0x6af CLUTTER_DEPRECATED_MACRO_FOR("Deprecated key symbol. Use CLUTTER_KEY_Cyrillic_dzhe instead.")
#define CLUTTER_Serbian_dze 0x6af CLUTTER_DEPRECATED_MACRO_FOR("Deprecated key symbol. Use CLUTTER_KEY_Serbian_dze instead.")
#define CLUTTER_numerosign 0x6b0 CLUTTER_DEPRECATED_MACRO_FOR("Deprecated key symbol. Use CLUTTER_KEY_numerosign instead.")
#define CLUTTER_Serbian_DJE 0x6b1 CLUTTER_DEPRECATED_MACRO_FOR("Deprecated key symbol. Use CLUTTER_KEY_Serbian_DJE instead.")
#define CLUTTER_Macedonia_GJE 0x6b2 CLUTTER_DEPRECATED_MACRO_FOR("Deprecated key symbol. Use CLUTTER_KEY_Macedonia_GJE instead.")
#define CLUTTER_Cyrillic_IO 0x6b3 CLUTTER_DEPRECATED_MACRO_FOR("Deprecated key symbol. Use CLUTTER_KEY_Cyrillic_IO instead.")
#define CLUTTER_Ukrainian_IE 0x6b4 CLUTTER_DEPRECATED_MACRO_FOR("Deprecated key symbol. Use CLUTTER_KEY_Ukrainian_IE instead.")
#define CLUTTER_Ukranian_JE 0x6b4 CLUTTER_DEPRECATED_MACRO_FOR("Deprecated key symbol. Use CLUTTER_KEY_Ukranian_JE instead.")
#define CLUTTER_Macedonia_DSE 0x6b5 CLUTTER_DEPRECATED_MACRO_FOR("Deprecated key symbol. Use CLUTTER_KEY_Macedonia_DSE instead.")
#define CLUTTER_Ukrainian_I 0x6b6 CLUTTER_DEPRECATED_MACRO_FOR("Deprecated key symbol. Use CLUTTER_KEY_Ukrainian_I instead.")
#define CLUTTER_Ukranian_I 0x6b6 CLUTTER_DEPRECATED_MACRO_FOR("Deprecated key symbol. Use CLUTTER_KEY_Ukranian_I instead.")
#define CLUTTER_Ukrainian_YI 0x6b7 CLUTTER_DEPRECATED_MACRO_FOR("Deprecated key symbol. Use CLUTTER_KEY_Ukrainian_YI instead.")
#define CLUTTER_Ukranian_YI 0x6b7 CLUTTER_DEPRECATED_MACRO_FOR("Deprecated key symbol. Use CLUTTER_KEY_Ukranian_YI instead.")
#define CLUTTER_Cyrillic_JE 0x6b8 CLUTTER_DEPRECATED_MACRO_FOR("Deprecated key symbol. Use CLUTTER_KEY_Cyrillic_JE instead.")
#define CLUTTER_Serbian_JE 0x6b8 CLUTTER_DEPRECATED_MACRO_FOR("Deprecated key symbol. Use CLUTTER_KEY_Serbian_JE instead.")
#define CLUTTER_Cyrillic_LJE 0x6b9 CLUTTER_DEPRECATED_MACRO_FOR("Deprecated key symbol. Use CLUTTER_KEY_Cyrillic_LJE instead.")
#define CLUTTER_Serbian_LJE 0x6b9 CLUTTER_DEPRECATED_MACRO_FOR("Deprecated key symbol. Use CLUTTER_KEY_Serbian_LJE instead.")
#define CLUTTER_Cyrillic_NJE 0x6ba CLUTTER_DEPRECATED_MACRO_FOR("Deprecated key symbol. Use CLUTTER_KEY_Cyrillic_NJE instead.")
#define CLUTTER_Serbian_NJE 0x6ba CLUTTER_DEPRECATED_MACRO_FOR("Deprecated key symbol. Use CLUTTER_KEY_Serbian_NJE instead.")
#define CLUTTER_Serbian_TSHE 0x6bb CLUTTER_DEPRECATED_MACRO_FOR("Deprecated key symbol. Use CLUTTER_KEY_Serbian_TSHE instead.")
#define CLUTTER_Macedonia_KJE 0x6bc CLUTTER_DEPRECATED_MACRO_FOR("Deprecated key symbol. Use CLUTTER_KEY_Macedonia_KJE instead.")
#define CLUTTER_Ukrainian_GHE_WITH_UPTURN 0x6bd CLUTTER_DEPRECATED_MACRO_FOR("Deprecated key symbol. Use CLUTTER_KEY_Ukrainian_GHE_WITH_UPTURN instead.")
#define CLUTTER_Byelorussian_SHORTU 0x6be CLUTTER_DEPRECATED_MACRO_FOR("Deprecated key symbol. Use CLUTTER_KEY_Byelorussian_SHORTU instead.")
#define CLUTTER_Cyrillic_DZHE 0x6bf CLUTTER_DEPRECATED_MACRO_FOR("Deprecated key symbol. Use CLUTTER_KEY_Cyrillic_DZHE instead.")
#define CLUTTER_Serbian_DZE 0x6bf CLUTTER_DEPRECATED_MACRO_FOR("Deprecated key symbol. Use CLUTTER_KEY_Serbian_DZE instead.")
#define CLUTTER_Cyrillic_yu 0x6c0 CLUTTER_DEPRECATED_MACRO_FOR("Deprecated key symbol. Use CLUTTER_KEY_Cyrillic_yu instead.")
#define CLUTTER_Cyrillic_a 0x6c1 CLUTTER_DEPRECATED_MACRO_FOR("Deprecated key symbol. Use CLUTTER_KEY_Cyrillic_a instead.")
#define CLUTTER_Cyrillic_be 0x6c2 CLUTTER_DEPRECATED_MACRO_FOR("Deprecated key symbol. Use CLUTTER_KEY_Cyrillic_be instead.")
#define CLUTTER_Cyrillic_tse 0x6c3 CLUTTER_DEPRECATED_MACRO_FOR("Deprecated key symbol. Use CLUTTER_KEY_Cyrillic_tse instead.")
#define CLUTTER_Cyrillic_de 0x6c4 CLUTTER_DEPRECATED_MACRO_FOR("Deprecated key symbol. Use CLUTTER_KEY_Cyrillic_de instead.")
#define CLUTTER_Cyrillic_ie 0x6c5 CLUTTER_DEPRECATED_MACRO_FOR("Deprecated key symbol. Use CLUTTER_KEY_Cyrillic_ie instead.")
#define CLUTTER_Cyrillic_ef 0x6c6 CLUTTER_DEPRECATED_MACRO_FOR("Deprecated key symbol. Use CLUTTER_KEY_Cyrillic_ef instead.")
#define CLUTTER_Cyrillic_ghe 0x6c7 CLUTTER_DEPRECATED_MACRO_FOR("Deprecated key symbol. Use CLUTTER_KEY_Cyrillic_ghe instead.")
#define CLUTTER_Cyrillic_ha 0x6c8 CLUTTER_DEPRECATED_MACRO_FOR("Deprecated key symbol. Use CLUTTER_KEY_Cyrillic_ha instead.")
#define CLUTTER_Cyrillic_i 0x6c9 CLUTTER_DEPRECATED_MACRO_FOR("Deprecated key symbol. Use CLUTTER_KEY_Cyrillic_i instead.")
#define CLUTTER_Cyrillic_shorti 0x6ca CLUTTER_DEPRECATED_MACRO_FOR("Deprecated key symbol. Use CLUTTER_KEY_Cyrillic_shorti instead.")
#define CLUTTER_Cyrillic_ka 0x6cb CLUTTER_DEPRECATED_MACRO_FOR("Deprecated key symbol. Use CLUTTER_KEY_Cyrillic_ka instead.")
#define CLUTTER_Cyrillic_el 0x6cc CLUTTER_DEPRECATED_MACRO_FOR("Deprecated key symbol. Use CLUTTER_KEY_Cyrillic_el instead.")
#define CLUTTER_Cyrillic_em 0x6cd CLUTTER_DEPRECATED_MACRO_FOR("Deprecated key symbol. Use CLUTTER_KEY_Cyrillic_em instead.")
#define CLUTTER_Cyrillic_en 0x6ce CLUTTER_DEPRECATED_MACRO_FOR("Deprecated key symbol. Use CLUTTER_KEY_Cyrillic_en instead.")
#define CLUTTER_Cyrillic_o 0x6cf CLUTTER_DEPRECATED_MACRO_FOR("Deprecated key symbol. Use CLUTTER_KEY_Cyrillic_o instead.")
#define CLUTTER_Cyrillic_pe 0x6d0 CLUTTER_DEPRECATED_MACRO_FOR("Deprecated key symbol. Use CLUTTER_KEY_Cyrillic_pe instead.")
#define CLUTTER_Cyrillic_ya 0x6d1 CLUTTER_DEPRECATED_MACRO_FOR("Deprecated key symbol. Use CLUTTER_KEY_Cyrillic_ya instead.")
#define CLUTTER_Cyrillic_er 0x6d2 CLUTTER_DEPRECATED_MACRO_FOR("Deprecated key symbol. Use CLUTTER_KEY_Cyrillic_er instead.")
#define CLUTTER_Cyrillic_es 0x6d3 CLUTTER_DEPRECATED_MACRO_FOR("Deprecated key symbol. Use CLUTTER_KEY_Cyrillic_es instead.")
#define CLUTTER_Cyrillic_te 0x6d4 CLUTTER_DEPRECATED_MACRO_FOR("Deprecated key symbol. Use CLUTTER_KEY_Cyrillic_te instead.")
#define CLUTTER_Cyrillic_u 0x6d5 CLUTTER_DEPRECATED_MACRO_FOR("Deprecated key symbol. Use CLUTTER_KEY_Cyrillic_u instead.")
#define CLUTTER_Cyrillic_zhe 0x6d6 CLUTTER_DEPRECATED_MACRO_FOR("Deprecated key symbol. Use CLUTTER_KEY_Cyrillic_zhe instead.")
#define CLUTTER_Cyrillic_ve 0x6d7 CLUTTER_DEPRECATED_MACRO_FOR("Deprecated key symbol. Use CLUTTER_KEY_Cyrillic_ve instead.")
#define CLUTTER_Cyrillic_softsign 0x6d8 CLUTTER_DEPRECATED_MACRO_FOR("Deprecated key symbol. Use CLUTTER_KEY_Cyrillic_softsign instead.")
#define CLUTTER_Cyrillic_yeru 0x6d9 CLUTTER_DEPRECATED_MACRO_FOR("Deprecated key symbol. Use CLUTTER_KEY_Cyrillic_yeru instead.")
#define CLUTTER_Cyrillic_ze 0x6da CLUTTER_DEPRECATED_MACRO_FOR("Deprecated key symbol. Use CLUTTER_KEY_Cyrillic_ze instead.")
#define CLUTTER_Cyrillic_sha 0x6db CLUTTER_DEPRECATED_MACRO_FOR("Deprecated key symbol. Use CLUTTER_KEY_Cyrillic_sha instead.")
#define CLUTTER_Cyrillic_e 0x6dc CLUTTER_DEPRECATED_MACRO_FOR("Deprecated key symbol. Use CLUTTER_KEY_Cyrillic_e instead.")
#define CLUTTER_Cyrillic_shcha 0x6dd CLUTTER_DEPRECATED_MACRO_FOR("Deprecated key symbol. Use CLUTTER_KEY_Cyrillic_shcha instead.")
#define CLUTTER_Cyrillic_che 0x6de CLUTTER_DEPRECATED_MACRO_FOR("Deprecated key symbol. Use CLUTTER_KEY_Cyrillic_che instead.")
#define CLUTTER_Cyrillic_hardsign 0x6df CLUTTER_DEPRECATED_MACRO_FOR("Deprecated key symbol. Use CLUTTER_KEY_Cyrillic_hardsign instead.")
#define CLUTTER_Cyrillic_YU 0x6e0 CLUTTER_DEPRECATED_MACRO_FOR("Deprecated key symbol. Use CLUTTER_KEY_Cyrillic_YU instead.")
#define CLUTTER_Cyrillic_A 0x6e1 CLUTTER_DEPRECATED_MACRO_FOR("Deprecated key symbol. Use CLUTTER_KEY_Cyrillic_A instead.")
#define CLUTTER_Cyrillic_BE 0x6e2 CLUTTER_DEPRECATED_MACRO_FOR("Deprecated key symbol. Use CLUTTER_KEY_Cyrillic_BE instead.")
#define CLUTTER_Cyrillic_TSE 0x6e3 CLUTTER_DEPRECATED_MACRO_FOR("Deprecated key symbol. Use CLUTTER_KEY_Cyrillic_TSE instead.")
#define CLUTTER_Cyrillic_DE 0x6e4 CLUTTER_DEPRECATED_MACRO_FOR("Deprecated key symbol. Use CLUTTER_KEY_Cyrillic_DE instead.")
#define CLUTTER_Cyrillic_IE 0x6e5 CLUTTER_DEPRECATED_MACRO_FOR("Deprecated key symbol. Use CLUTTER_KEY_Cyrillic_IE instead.")
#define CLUTTER_Cyrillic_EF 0x6e6 CLUTTER_DEPRECATED_MACRO_FOR("Deprecated key symbol. Use CLUTTER_KEY_Cyrillic_EF instead.")
#define CLUTTER_Cyrillic_GHE 0x6e7 CLUTTER_DEPRECATED_MACRO_FOR("Deprecated key symbol. Use CLUTTER_KEY_Cyrillic_GHE instead.")
#define CLUTTER_Cyrillic_HA 0x6e8 CLUTTER_DEPRECATED_MACRO_FOR("Deprecated key symbol. Use CLUTTER_KEY_Cyrillic_HA instead.")
#define CLUTTER_Cyrillic_I 0x6e9 CLUTTER_DEPRECATED_MACRO_FOR("Deprecated key symbol. Use CLUTTER_KEY_Cyrillic_I instead.")
#define CLUTTER_Cyrillic_SHORTI 0x6ea CLUTTER_DEPRECATED_MACRO_FOR("Deprecated key symbol. Use CLUTTER_KEY_Cyrillic_SHORTI instead.")
#define CLUTTER_Cyrillic_KA 0x6eb CLUTTER_DEPRECATED_MACRO_FOR("Deprecated key symbol. Use CLUTTER_KEY_Cyrillic_KA instead.")
#define CLUTTER_Cyrillic_EL 0x6ec CLUTTER_DEPRECATED_MACRO_FOR("Deprecated key symbol. Use CLUTTER_KEY_Cyrillic_EL instead.")
#define CLUTTER_Cyrillic_EM 0x6ed CLUTTER_DEPRECATED_MACRO_FOR("Deprecated key symbol. Use CLUTTER_KEY_Cyrillic_EM instead.")
#define CLUTTER_Cyrillic_EN 0x6ee CLUTTER_DEPRECATED_MACRO_FOR("Deprecated key symbol. Use CLUTTER_KEY_Cyrillic_EN instead.")
#define CLUTTER_Cyrillic_O 0x6ef CLUTTER_DEPRECATED_MACRO_FOR("Deprecated key symbol. Use CLUTTER_KEY_Cyrillic_O instead.")
#define CLUTTER_Cyrillic_PE 0x6f0 CLUTTER_DEPRECATED_MACRO_FOR("Deprecated key symbol. Use CLUTTER_KEY_Cyrillic_PE instead.")
#define CLUTTER_Cyrillic_YA 0x6f1 CLUTTER_DEPRECATED_MACRO_FOR("Deprecated key symbol. Use CLUTTER_KEY_Cyrillic_YA instead.")
#define CLUTTER_Cyrillic_ER 0x6f2 CLUTTER_DEPRECATED_MACRO_FOR("Deprecated key symbol. Use CLUTTER_KEY_Cyrillic_ER instead.")
#define CLUTTER_Cyrillic_ES 0x6f3 CLUTTER_DEPRECATED_MACRO_FOR("Deprecated key symbol. Use CLUTTER_KEY_Cyrillic_ES instead.")
#define CLUTTER_Cyrillic_TE 0x6f4 CLUTTER_DEPRECATED_MACRO_FOR("Deprecated key symbol. Use CLUTTER_KEY_Cyrillic_TE instead.")
#define CLUTTER_Cyrillic_U 0x6f5 CLUTTER_DEPRECATED_MACRO_FOR("Deprecated key symbol. Use CLUTTER_KEY_Cyrillic_U instead.")
#define CLUTTER_Cyrillic_ZHE 0x6f6 CLUTTER_DEPRECATED_MACRO_FOR("Deprecated key symbol. Use CLUTTER_KEY_Cyrillic_ZHE instead.")
#define CLUTTER_Cyrillic_VE 0x6f7 CLUTTER_DEPRECATED_MACRO_FOR("Deprecated key symbol. Use CLUTTER_KEY_Cyrillic_VE instead.")
#define CLUTTER_Cyrillic_SOFTSIGN 0x6f8 CLUTTER_DEPRECATED_MACRO_FOR("Deprecated key symbol. Use CLUTTER_KEY_Cyrillic_SOFTSIGN instead.")
#define CLUTTER_Cyrillic_YERU 0x6f9 CLUTTER_DEPRECATED_MACRO_FOR("Deprecated key symbol. Use CLUTTER_KEY_Cyrillic_YERU instead.")
#define CLUTTER_Cyrillic_ZE 0x6fa CLUTTER_DEPRECATED_MACRO_FOR("Deprecated key symbol. Use CLUTTER_KEY_Cyrillic_ZE instead.")
#define CLUTTER_Cyrillic_SHA 0x6fb CLUTTER_DEPRECATED_MACRO_FOR("Deprecated key symbol. Use CLUTTER_KEY_Cyrillic_SHA instead.")
#define CLUTTER_Cyrillic_E 0x6fc CLUTTER_DEPRECATED_MACRO_FOR("Deprecated key symbol. Use CLUTTER_KEY_Cyrillic_E instead.")
#define CLUTTER_Cyrillic_SHCHA 0x6fd CLUTTER_DEPRECATED_MACRO_FOR("Deprecated key symbol. Use CLUTTER_KEY_Cyrillic_SHCHA instead.")
#define CLUTTER_Cyrillic_CHE 0x6fe CLUTTER_DEPRECATED_MACRO_FOR("Deprecated key symbol. Use CLUTTER_KEY_Cyrillic_CHE instead.")
#define CLUTTER_Cyrillic_HARDSIGN 0x6ff CLUTTER_DEPRECATED_MACRO_FOR("Deprecated key symbol. Use CLUTTER_KEY_Cyrillic_HARDSIGN instead.")
#define CLUTTER_Greek_ALPHAaccent 0x7a1 CLUTTER_DEPRECATED_MACRO_FOR("Deprecated key symbol. Use CLUTTER_KEY_Greek_ALPHAaccent instead.")
#define CLUTTER_Greek_EPSILONaccent 0x7a2 CLUTTER_DEPRECATED_MACRO_FOR("Deprecated key symbol. Use CLUTTER_KEY_Greek_EPSILONaccent instead.")
#define CLUTTER_Greek_ETAaccent 0x7a3 CLUTTER_DEPRECATED_MACRO_FOR("Deprecated key symbol. Use CLUTTER_KEY_Greek_ETAaccent instead.")
#define CLUTTER_Greek_IOTAaccent 0x7a4 CLUTTER_DEPRECATED_MACRO_FOR("Deprecated key symbol. Use CLUTTER_KEY_Greek_IOTAaccent instead.")
#define CLUTTER_Greek_IOTAdieresis 0x7a5 CLUTTER_DEPRECATED_MACRO_FOR("Deprecated key symbol. Use CLUTTER_KEY_Greek_IOTAdieresis instead.")
#define CLUTTER_Greek_IOTAdiaeresis 0x7a5 CLUTTER_DEPRECATED_MACRO_FOR("Deprecated key symbol. Use CLUTTER_KEY_Greek_IOTAdiaeresis instead.")
#define CLUTTER_Greek_OMICRONaccent 0x7a7 CLUTTER_DEPRECATED_MACRO_FOR("Deprecated key symbol. Use CLUTTER_KEY_Greek_OMICRONaccent instead.")
#define CLUTTER_Greek_UPSILONaccent 0x7a8 CLUTTER_DEPRECATED_MACRO_FOR("Deprecated key symbol. Use CLUTTER_KEY_Greek_UPSILONaccent instead.")
#define CLUTTER_Greek_UPSILONdieresis 0x7a9 CLUTTER_DEPRECATED_MACRO_FOR("Deprecated key symbol. Use CLUTTER_KEY_Greek_UPSILONdieresis instead.")
#define CLUTTER_Greek_OMEGAaccent 0x7ab CLUTTER_DEPRECATED_MACRO_FOR("Deprecated key symbol. Use CLUTTER_KEY_Greek_OMEGAaccent instead.")
#define CLUTTER_Greek_accentdieresis 0x7ae CLUTTER_DEPRECATED_MACRO_FOR("Deprecated key symbol. Use CLUTTER_KEY_Greek_accentdieresis instead.")
#define CLUTTER_Greek_horizbar 0x7af CLUTTER_DEPRECATED_MACRO_FOR("Deprecated key symbol. Use CLUTTER_KEY_Greek_horizbar instead.")
#define CLUTTER_Greek_alphaaccent 0x7b1 CLUTTER_DEPRECATED_MACRO_FOR("Deprecated key symbol. Use CLUTTER_KEY_Greek_alphaaccent instead.")
#define CLUTTER_Greek_epsilonaccent 0x7b2 CLUTTER_DEPRECATED_MACRO_FOR("Deprecated key symbol. Use CLUTTER_KEY_Greek_epsilonaccent instead.")
#define CLUTTER_Greek_etaaccent 0x7b3 CLUTTER_DEPRECATED_MACRO_FOR("Deprecated key symbol. Use CLUTTER_KEY_Greek_etaaccent instead.")
#define CLUTTER_Greek_iotaaccent 0x7b4 CLUTTER_DEPRECATED_MACRO_FOR("Deprecated key symbol. Use CLUTTER_KEY_Greek_iotaaccent instead.")
#define CLUTTER_Greek_iotadieresis 0x7b5 CLUTTER_DEPRECATED_MACRO_FOR("Deprecated key symbol. Use CLUTTER_KEY_Greek_iotadieresis instead.")
#define CLUTTER_Greek_iotaaccentdieresis 0x7b6 CLUTTER_DEPRECATED_MACRO_FOR("Deprecated key symbol. Use CLUTTER_KEY_Greek_iotaaccentdieresis instead.")
#define CLUTTER_Greek_omicronaccent 0x7b7 CLUTTER_DEPRECATED_MACRO_FOR("Deprecated key symbol. Use CLUTTER_KEY_Greek_omicronaccent instead.")
#define CLUTTER_Greek_upsilonaccent 0x7b8 CLUTTER_DEPRECATED_MACRO_FOR("Deprecated key symbol. Use CLUTTER_KEY_Greek_upsilonaccent instead.")
#define CLUTTER_Greek_upsilondieresis 0x7b9 CLUTTER_DEPRECATED_MACRO_FOR("Deprecated key symbol. Use CLUTTER_KEY_Greek_upsilondieresis instead.")
#define CLUTTER_Greek_upsilonaccentdieresis 0x7ba CLUTTER_DEPRECATED_MACRO_FOR("Deprecated key symbol. Use CLUTTER_KEY_Greek_upsilonaccentdieresis instead.")
#define CLUTTER_Greek_omegaaccent 0x7bb CLUTTER_DEPRECATED_MACRO_FOR("Deprecated key symbol. Use CLUTTER_KEY_Greek_omegaaccent instead.")
#define CLUTTER_Greek_ALPHA 0x7c1 CLUTTER_DEPRECATED_MACRO_FOR("Deprecated key symbol. Use CLUTTER_KEY_Greek_ALPHA instead.")
#define CLUTTER_Greek_BETA 0x7c2 CLUTTER_DEPRECATED_MACRO_FOR("Deprecated key symbol. Use CLUTTER_KEY_Greek_BETA instead.")
#define CLUTTER_Greek_GAMMA 0x7c3 CLUTTER_DEPRECATED_MACRO_FOR("Deprecated key symbol. Use CLUTTER_KEY_Greek_GAMMA instead.")
#define CLUTTER_Greek_DELTA 0x7c4 CLUTTER_DEPRECATED_MACRO_FOR("Deprecated key symbol. Use CLUTTER_KEY_Greek_DELTA instead.")
#define CLUTTER_Greek_EPSILON 0x7c5 CLUTTER_DEPRECATED_MACRO_FOR("Deprecated key symbol. Use CLUTTER_KEY_Greek_EPSILON instead.")
#define CLUTTER_Greek_ZETA 0x7c6 CLUTTER_DEPRECATED_MACRO_FOR("Deprecated key symbol. Use CLUTTER_KEY_Greek_ZETA instead.")
#define CLUTTER_Greek_ETA 0x7c7 CLUTTER_DEPRECATED_MACRO_FOR("Deprecated key symbol. Use CLUTTER_KEY_Greek_ETA instead.")
#define CLUTTER_Greek_THETA 0x7c8 CLUTTER_DEPRECATED_MACRO_FOR("Deprecated key symbol. Use CLUTTER_KEY_Greek_THETA instead.")
#define CLUTTER_Greek_IOTA 0x7c9 CLUTTER_DEPRECATED_MACRO_FOR("Deprecated key symbol. Use CLUTTER_KEY_Greek_IOTA instead.")
#define CLUTTER_Greek_KAPPA 0x7ca CLUTTER_DEPRECATED_MACRO_FOR("Deprecated key symbol. Use CLUTTER_KEY_Greek_KAPPA instead.")
#define CLUTTER_Greek_LAMDA 0x7cb CLUTTER_DEPRECATED_MACRO_FOR("Deprecated key symbol. Use CLUTTER_KEY_Greek_LAMDA instead.")
#define CLUTTER_Greek_LAMBDA 0x7cb CLUTTER_DEPRECATED_MACRO_FOR("Deprecated key symbol. Use CLUTTER_KEY_Greek_LAMBDA instead.")
#define CLUTTER_Greek_MU 0x7cc CLUTTER_DEPRECATED_MACRO_FOR("Deprecated key symbol. Use CLUTTER_KEY_Greek_MU instead.")
#define CLUTTER_Greek_NU 0x7cd CLUTTER_DEPRECATED_MACRO_FOR("Deprecated key symbol. Use CLUTTER_KEY_Greek_NU instead.")
#define CLUTTER_Greek_XI 0x7ce CLUTTER_DEPRECATED_MACRO_FOR("Deprecated key symbol. Use CLUTTER_KEY_Greek_XI instead.")
#define CLUTTER_Greek_OMICRON 0x7cf CLUTTER_DEPRECATED_MACRO_FOR("Deprecated key symbol. Use CLUTTER_KEY_Greek_OMICRON instead.")
#define CLUTTER_Greek_PI 0x7d0 CLUTTER_DEPRECATED_MACRO_FOR("Deprecated key symbol. Use CLUTTER_KEY_Greek_PI instead.")
#define CLUTTER_Greek_RHO 0x7d1 CLUTTER_DEPRECATED_MACRO_FOR("Deprecated key symbol. Use CLUTTER_KEY_Greek_RHO instead.")
#define CLUTTER_Greek_SIGMA 0x7d2 CLUTTER_DEPRECATED_MACRO_FOR("Deprecated key symbol. Use CLUTTER_KEY_Greek_SIGMA instead.")
#define CLUTTER_Greek_TAU 0x7d4 CLUTTER_DEPRECATED_MACRO_FOR("Deprecated key symbol. Use CLUTTER_KEY_Greek_TAU instead.")
#define CLUTTER_Greek_UPSILON 0x7d5 CLUTTER_DEPRECATED_MACRO_FOR("Deprecated key symbol. Use CLUTTER_KEY_Greek_UPSILON instead.")
#define CLUTTER_Greek_PHI 0x7d6 CLUTTER_DEPRECATED_MACRO_FOR("Deprecated key symbol. Use CLUTTER_KEY_Greek_PHI instead.")
#define CLUTTER_Greek_CHI 0x7d7 CLUTTER_DEPRECATED_MACRO_FOR("Deprecated key symbol. Use CLUTTER_KEY_Greek_CHI instead.")
#define CLUTTER_Greek_PSI 0x7d8 CLUTTER_DEPRECATED_MACRO_FOR("Deprecated key symbol. Use CLUTTER_KEY_Greek_PSI instead.")
#define CLUTTER_Greek_OMEGA 0x7d9 CLUTTER_DEPRECATED_MACRO_FOR("Deprecated key symbol. Use CLUTTER_KEY_Greek_OMEGA instead.")
#define CLUTTER_Greek_alpha 0x7e1 CLUTTER_DEPRECATED_MACRO_FOR("Deprecated key symbol. Use CLUTTER_KEY_Greek_alpha instead.")
#define CLUTTER_Greek_beta 0x7e2 CLUTTER_DEPRECATED_MACRO_FOR("Deprecated key symbol. Use CLUTTER_KEY_Greek_beta instead.")
#define CLUTTER_Greek_gamma 0x7e3 CLUTTER_DEPRECATED_MACRO_FOR("Deprecated key symbol. Use CLUTTER_KEY_Greek_gamma instead.")
#define CLUTTER_Greek_delta 0x7e4 CLUTTER_DEPRECATED_MACRO_FOR("Deprecated key symbol. Use CLUTTER_KEY_Greek_delta instead.")
#define CLUTTER_Greek_epsilon 0x7e5 CLUTTER_DEPRECATED_MACRO_FOR("Deprecated key symbol. Use CLUTTER_KEY_Greek_epsilon instead.")
#define CLUTTER_Greek_zeta 0x7e6 CLUTTER_DEPRECATED_MACRO_FOR("Deprecated key symbol. Use CLUTTER_KEY_Greek_zeta instead.")
#define CLUTTER_Greek_eta 0x7e7 CLUTTER_DEPRECATED_MACRO_FOR("Deprecated key symbol. Use CLUTTER_KEY_Greek_eta instead.")
#define CLUTTER_Greek_theta 0x7e8 CLUTTER_DEPRECATED_MACRO_FOR("Deprecated key symbol. Use CLUTTER_KEY_Greek_theta instead.")
#define CLUTTER_Greek_iota 0x7e9 CLUTTER_DEPRECATED_MACRO_FOR("Deprecated key symbol. Use CLUTTER_KEY_Greek_iota instead.")
#define CLUTTER_Greek_kappa 0x7ea CLUTTER_DEPRECATED_MACRO_FOR("Deprecated key symbol. Use CLUTTER_KEY_Greek_kappa instead.")
#define CLUTTER_Greek_lamda 0x7eb CLUTTER_DEPRECATED_MACRO_FOR("Deprecated key symbol. Use CLUTTER_KEY_Greek_lamda instead.")
#define CLUTTER_Greek_lambda 0x7eb CLUTTER_DEPRECATED_MACRO_FOR("Deprecated key symbol. Use CLUTTER_KEY_Greek_lambda instead.")
#define CLUTTER_Greek_mu 0x7ec CLUTTER_DEPRECATED_MACRO_FOR("Deprecated key symbol. Use CLUTTER_KEY_Greek_mu instead.")
#define CLUTTER_Greek_nu 0x7ed CLUTTER_DEPRECATED_MACRO_FOR("Deprecated key symbol. Use CLUTTER_KEY_Greek_nu instead.")
#define CLUTTER_Greek_xi 0x7ee CLUTTER_DEPRECATED_MACRO_FOR("Deprecated key symbol. Use CLUTTER_KEY_Greek_xi instead.")
#define CLUTTER_Greek_omicron 0x7ef CLUTTER_DEPRECATED_MACRO_FOR("Deprecated key symbol. Use CLUTTER_KEY_Greek_omicron instead.")
#define CLUTTER_Greek_pi 0x7f0 CLUTTER_DEPRECATED_MACRO_FOR("Deprecated key symbol. Use CLUTTER_KEY_Greek_pi instead.")
#define CLUTTER_Greek_rho 0x7f1 CLUTTER_DEPRECATED_MACRO_FOR("Deprecated key symbol. Use CLUTTER_KEY_Greek_rho instead.")
#define CLUTTER_Greek_sigma 0x7f2 CLUTTER_DEPRECATED_MACRO_FOR("Deprecated key symbol. Use CLUTTER_KEY_Greek_sigma instead.")
#define CLUTTER_Greek_finalsmallsigma 0x7f3 CLUTTER_DEPRECATED_MACRO_FOR("Deprecated key symbol. Use CLUTTER_KEY_Greek_finalsmallsigma instead.")
#define CLUTTER_Greek_tau 0x7f4 CLUTTER_DEPRECATED_MACRO_FOR("Deprecated key symbol. Use CLUTTER_KEY_Greek_tau instead.")
#define CLUTTER_Greek_upsilon 0x7f5 CLUTTER_DEPRECATED_MACRO_FOR("Deprecated key symbol. Use CLUTTER_KEY_Greek_upsilon instead.")
#define CLUTTER_Greek_phi 0x7f6 CLUTTER_DEPRECATED_MACRO_FOR("Deprecated key symbol. Use CLUTTER_KEY_Greek_phi instead.")
#define CLUTTER_Greek_chi 0x7f7 CLUTTER_DEPRECATED_MACRO_FOR("Deprecated key symbol. Use CLUTTER_KEY_Greek_chi instead.")
#define CLUTTER_Greek_psi 0x7f8 CLUTTER_DEPRECATED_MACRO_FOR("Deprecated key symbol. Use CLUTTER_KEY_Greek_psi instead.")
#define CLUTTER_Greek_omega 0x7f9 CLUTTER_DEPRECATED_MACRO_FOR("Deprecated key symbol. Use CLUTTER_KEY_Greek_omega instead.")
#define CLUTTER_Greek_switch 0xff7e CLUTTER_DEPRECATED_MACRO_FOR("Deprecated key symbol. Use CLUTTER_KEY_Greek_switch instead.")
#define CLUTTER_leftradical 0x8a1 CLUTTER_DEPRECATED_MACRO_FOR("Deprecated key symbol. Use CLUTTER_KEY_leftradical instead.")
#define CLUTTER_topleftradical 0x8a2 CLUTTER_DEPRECATED_MACRO_FOR("Deprecated key symbol. Use CLUTTER_KEY_topleftradical instead.")
#define CLUTTER_horizconnector 0x8a3 CLUTTER_DEPRECATED_MACRO_FOR("Deprecated key symbol. Use CLUTTER_KEY_horizconnector instead.")
#define CLUTTER_topintegral 0x8a4 CLUTTER_DEPRECATED_MACRO_FOR("Deprecated key symbol. Use CLUTTER_KEY_topintegral instead.")
#define CLUTTER_botintegral 0x8a5 CLUTTER_DEPRECATED_MACRO_FOR("Deprecated key symbol. Use CLUTTER_KEY_botintegral instead.")
#define CLUTTER_vertconnector 0x8a6 CLUTTER_DEPRECATED_MACRO_FOR("Deprecated key symbol. Use CLUTTER_KEY_vertconnector instead.")
#define CLUTTER_topleftsqbracket 0x8a7 CLUTTER_DEPRECATED_MACRO_FOR("Deprecated key symbol. Use CLUTTER_KEY_topleftsqbracket instead.")
#define CLUTTER_botleftsqbracket 0x8a8 CLUTTER_DEPRECATED_MACRO_FOR("Deprecated key symbol. Use CLUTTER_KEY_botleftsqbracket instead.")
#define CLUTTER_toprightsqbracket 0x8a9 CLUTTER_DEPRECATED_MACRO_FOR("Deprecated key symbol. Use CLUTTER_KEY_toprightsqbracket instead.")
#define CLUTTER_botrightsqbracket 0x8aa CLUTTER_DEPRECATED_MACRO_FOR("Deprecated key symbol. Use CLUTTER_KEY_botrightsqbracket instead.")
#define CLUTTER_topleftparens 0x8ab CLUTTER_DEPRECATED_MACRO_FOR("Deprecated key symbol. Use CLUTTER_KEY_topleftparens instead.")
#define CLUTTER_botleftparens 0x8ac CLUTTER_DEPRECATED_MACRO_FOR("Deprecated key symbol. Use CLUTTER_KEY_botleftparens instead.")
#define CLUTTER_toprightparens 0x8ad CLUTTER_DEPRECATED_MACRO_FOR("Deprecated key symbol. Use CLUTTER_KEY_toprightparens instead.")
#define CLUTTER_botrightparens 0x8ae CLUTTER_DEPRECATED_MACRO_FOR("Deprecated key symbol. Use CLUTTER_KEY_botrightparens instead.")
#define CLUTTER_leftmiddlecurlybrace 0x8af CLUTTER_DEPRECATED_MACRO_FOR("Deprecated key symbol. Use CLUTTER_KEY_leftmiddlecurlybrace instead.")
#define CLUTTER_rightmiddlecurlybrace 0x8b0 CLUTTER_DEPRECATED_MACRO_FOR("Deprecated key symbol. Use CLUTTER_KEY_rightmiddlecurlybrace instead.")
#define CLUTTER_topleftsummation 0x8b1 CLUTTER_DEPRECATED_MACRO_FOR("Deprecated key symbol. Use CLUTTER_KEY_topleftsummation instead.")
#define CLUTTER_botleftsummation 0x8b2 CLUTTER_DEPRECATED_MACRO_FOR("Deprecated key symbol. Use CLUTTER_KEY_botleftsummation instead.")
#define CLUTTER_topvertsummationconnector 0x8b3 CLUTTER_DEPRECATED_MACRO_FOR("Deprecated key symbol. Use CLUTTER_KEY_topvertsummationconnector instead.")
#define CLUTTER_botvertsummationconnector 0x8b4 CLUTTER_DEPRECATED_MACRO_FOR("Deprecated key symbol. Use CLUTTER_KEY_botvertsummationconnector instead.")
#define CLUTTER_toprightsummation 0x8b5 CLUTTER_DEPRECATED_MACRO_FOR("Deprecated key symbol. Use CLUTTER_KEY_toprightsummation instead.")
#define CLUTTER_botrightsummation 0x8b6 CLUTTER_DEPRECATED_MACRO_FOR("Deprecated key symbol. Use CLUTTER_KEY_botrightsummation instead.")
#define CLUTTER_rightmiddlesummation 0x8b7 CLUTTER_DEPRECATED_MACRO_FOR("Deprecated key symbol. Use CLUTTER_KEY_rightmiddlesummation instead.")
#define CLUTTER_lessthanequal 0x8bc CLUTTER_DEPRECATED_MACRO_FOR("Deprecated key symbol. Use CLUTTER_KEY_lessthanequal instead.")
#define CLUTTER_notequal 0x8bd CLUTTER_DEPRECATED_MACRO_FOR("Deprecated key symbol. Use CLUTTER_KEY_notequal instead.")
#define CLUTTER_greaterthanequal 0x8be CLUTTER_DEPRECATED_MACRO_FOR("Deprecated key symbol. Use CLUTTER_KEY_greaterthanequal instead.")
#define CLUTTER_integral 0x8bf CLUTTER_DEPRECATED_MACRO_FOR("Deprecated key symbol. Use CLUTTER_KEY_integral instead.")
#define CLUTTER_therefore 0x8c0 CLUTTER_DEPRECATED_MACRO_FOR("Deprecated key symbol. Use CLUTTER_KEY_therefore instead.")
#define CLUTTER_variation 0x8c1 CLUTTER_DEPRECATED_MACRO_FOR("Deprecated key symbol. Use CLUTTER_KEY_variation instead.")
#define CLUTTER_infinity 0x8c2 CLUTTER_DEPRECATED_MACRO_FOR("Deprecated key symbol. Use CLUTTER_KEY_infinity instead.")
#define CLUTTER_nabla 0x8c5 CLUTTER_DEPRECATED_MACRO_FOR("Deprecated key symbol. Use CLUTTER_KEY_nabla instead.")
#define CLUTTER_approximate 0x8c8 CLUTTER_DEPRECATED_MACRO_FOR("Deprecated key symbol. Use CLUTTER_KEY_approximate instead.")
#define CLUTTER_similarequal 0x8c9 CLUTTER_DEPRECATED_MACRO_FOR("Deprecated key symbol. Use CLUTTER_KEY_similarequal instead.")
#define CLUTTER_ifonlyif 0x8cd CLUTTER_DEPRECATED_MACRO_FOR("Deprecated key symbol. Use CLUTTER_KEY_ifonlyif instead.")
#define CLUTTER_implies 0x8ce CLUTTER_DEPRECATED_MACRO_FOR("Deprecated key symbol. Use CLUTTER_KEY_implies instead.")
#define CLUTTER_identical 0x8cf CLUTTER_DEPRECATED_MACRO_FOR("Deprecated key symbol. Use CLUTTER_KEY_identical instead.")
#define CLUTTER_radical 0x8d6 CLUTTER_DEPRECATED_MACRO_FOR("Deprecated key symbol. Use CLUTTER_KEY_radical instead.")
#define CLUTTER_includedin 0x8da CLUTTER_DEPRECATED_MACRO_FOR("Deprecated key symbol. Use CLUTTER_KEY_includedin instead.")
#define CLUTTER_includes 0x8db CLUTTER_DEPRECATED_MACRO_FOR("Deprecated key symbol. Use CLUTTER_KEY_includes instead.")
#define CLUTTER_intersection 0x8dc CLUTTER_DEPRECATED_MACRO_FOR("Deprecated key symbol. Use CLUTTER_KEY_intersection instead.")
#define CLUTTER_union 0x8dd CLUTTER_DEPRECATED_MACRO_FOR("Deprecated key symbol. Use CLUTTER_KEY_union instead.")
#define CLUTTER_logicaland 0x8de CLUTTER_DEPRECATED_MACRO_FOR("Deprecated key symbol. Use CLUTTER_KEY_logicaland instead.")
#define CLUTTER_logicalor 0x8df CLUTTER_DEPRECATED_MACRO_FOR("Deprecated key symbol. Use CLUTTER_KEY_logicalor instead.")
#define CLUTTER_partialderivative 0x8ef CLUTTER_DEPRECATED_MACRO_FOR("Deprecated key symbol. Use CLUTTER_KEY_partialderivative instead.")
#define CLUTTER_function 0x8f6 CLUTTER_DEPRECATED_MACRO_FOR("Deprecated key symbol. Use CLUTTER_KEY_function instead.")
#define CLUTTER_leftarrow 0x8fb CLUTTER_DEPRECATED_MACRO_FOR("Deprecated key symbol. Use CLUTTER_KEY_leftarrow instead.")
#define CLUTTER_uparrow 0x8fc CLUTTER_DEPRECATED_MACRO_FOR("Deprecated key symbol. Use CLUTTER_KEY_uparrow instead.")
#define CLUTTER_rightarrow 0x8fd CLUTTER_DEPRECATED_MACRO_FOR("Deprecated key symbol. Use CLUTTER_KEY_rightarrow instead.")
#define CLUTTER_downarrow 0x8fe CLUTTER_DEPRECATED_MACRO_FOR("Deprecated key symbol. Use CLUTTER_KEY_downarrow instead.")
#define CLUTTER_blank 0x9df CLUTTER_DEPRECATED_MACRO_FOR("Deprecated key symbol. Use CLUTTER_KEY_blank instead.")
#define CLUTTER_soliddiamond 0x9e0 CLUTTER_DEPRECATED_MACRO_FOR("Deprecated key symbol. Use CLUTTER_KEY_soliddiamond instead.")
#define CLUTTER_checkerboard 0x9e1 CLUTTER_DEPRECATED_MACRO_FOR("Deprecated key symbol. Use CLUTTER_KEY_checkerboard instead.")
#define CLUTTER_ht 0x9e2 CLUTTER_DEPRECATED_MACRO_FOR("Deprecated key symbol. Use CLUTTER_KEY_ht instead.")
#define CLUTTER_ff 0x9e3 CLUTTER_DEPRECATED_MACRO_FOR("Deprecated key symbol. Use CLUTTER_KEY_ff instead.")
#define CLUTTER_cr 0x9e4 CLUTTER_DEPRECATED_MACRO_FOR("Deprecated key symbol. Use CLUTTER_KEY_cr instead.")
#define CLUTTER_lf 0x9e5 CLUTTER_DEPRECATED_MACRO_FOR("Deprecated key symbol. Use CLUTTER_KEY_lf instead.")
#define CLUTTER_nl 0x9e8 CLUTTER_DEPRECATED_MACRO_FOR("Deprecated key symbol. Use CLUTTER_KEY_nl instead.")
#define CLUTTER_vt 0x9e9 CLUTTER_DEPRECATED_MACRO_FOR("Deprecated key symbol. Use CLUTTER_KEY_vt instead.")
#define CLUTTER_lowrightcorner 0x9ea CLUTTER_DEPRECATED_MACRO_FOR("Deprecated key symbol. Use CLUTTER_KEY_lowrightcorner instead.")
#define CLUTTER_uprightcorner 0x9eb CLUTTER_DEPRECATED_MACRO_FOR("Deprecated key symbol. Use CLUTTER_KEY_uprightcorner instead.")
#define CLUTTER_upleftcorner 0x9ec CLUTTER_DEPRECATED_MACRO_FOR("Deprecated key symbol. Use CLUTTER_KEY_upleftcorner instead.")
#define CLUTTER_lowleftcorner 0x9ed CLUTTER_DEPRECATED_MACRO_FOR("Deprecated key symbol. Use CLUTTER_KEY_lowleftcorner instead.")
#define CLUTTER_crossinglines 0x9ee CLUTTER_DEPRECATED_MACRO_FOR("Deprecated key symbol. Use CLUTTER_KEY_crossinglines instead.")
#define CLUTTER_horizlinescan1 0x9ef CLUTTER_DEPRECATED_MACRO_FOR("Deprecated key symbol. Use CLUTTER_KEY_horizlinescan1 instead.")
#define CLUTTER_horizlinescan3 0x9f0 CLUTTER_DEPRECATED_MACRO_FOR("Deprecated key symbol. Use CLUTTER_KEY_horizlinescan3 instead.")
#define CLUTTER_horizlinescan5 0x9f1 CLUTTER_DEPRECATED_MACRO_FOR("Deprecated key symbol. Use CLUTTER_KEY_horizlinescan5 instead.")
#define CLUTTER_horizlinescan7 0x9f2 CLUTTER_DEPRECATED_MACRO_FOR("Deprecated key symbol. Use CLUTTER_KEY_horizlinescan7 instead.")
#define CLUTTER_horizlinescan9 0x9f3 CLUTTER_DEPRECATED_MACRO_FOR("Deprecated key symbol. Use CLUTTER_KEY_horizlinescan9 instead.")
#define CLUTTER_leftt 0x9f4 CLUTTER_DEPRECATED_MACRO_FOR("Deprecated key symbol. Use CLUTTER_KEY_leftt instead.")
#define CLUTTER_rightt 0x9f5 CLUTTER_DEPRECATED_MACRO_FOR("Deprecated key symbol. Use CLUTTER_KEY_rightt instead.")
#define CLUTTER_bott 0x9f6 CLUTTER_DEPRECATED_MACRO_FOR("Deprecated key symbol. Use CLUTTER_KEY_bott instead.")
#define CLUTTER_topt 0x9f7 CLUTTER_DEPRECATED_MACRO_FOR("Deprecated key symbol. Use CLUTTER_KEY_topt instead.")
#define CLUTTER_vertbar 0x9f8 CLUTTER_DEPRECATED_MACRO_FOR("Deprecated key symbol. Use CLUTTER_KEY_vertbar instead.")
#define CLUTTER_emspace 0xaa1 CLUTTER_DEPRECATED_MACRO_FOR("Deprecated key symbol. Use CLUTTER_KEY_emspace instead.")
#define CLUTTER_enspace 0xaa2 CLUTTER_DEPRECATED_MACRO_FOR("Deprecated key symbol. Use CLUTTER_KEY_enspace instead.")
#define CLUTTER_em3space 0xaa3 CLUTTER_DEPRECATED_MACRO_FOR("Deprecated key symbol. Use CLUTTER_KEY_em3space instead.")
#define CLUTTER_em4space 0xaa4 CLUTTER_DEPRECATED_MACRO_FOR("Deprecated key symbol. Use CLUTTER_KEY_em4space instead.")
#define CLUTTER_digitspace 0xaa5 CLUTTER_DEPRECATED_MACRO_FOR("Deprecated key symbol. Use CLUTTER_KEY_digitspace instead.")
#define CLUTTER_punctspace 0xaa6 CLUTTER_DEPRECATED_MACRO_FOR("Deprecated key symbol. Use CLUTTER_KEY_punctspace instead.")
#define CLUTTER_thinspace 0xaa7 CLUTTER_DEPRECATED_MACRO_FOR("Deprecated key symbol. Use CLUTTER_KEY_thinspace instead.")
#define CLUTTER_hairspace 0xaa8 CLUTTER_DEPRECATED_MACRO_FOR("Deprecated key symbol. Use CLUTTER_KEY_hairspace instead.")
#define CLUTTER_emdash 0xaa9 CLUTTER_DEPRECATED_MACRO_FOR("Deprecated key symbol. Use CLUTTER_KEY_emdash instead.")
#define CLUTTER_endash 0xaaa CLUTTER_DEPRECATED_MACRO_FOR("Deprecated key symbol. Use CLUTTER_KEY_endash instead.")
#define CLUTTER_signifblank 0xaac CLUTTER_DEPRECATED_MACRO_FOR("Deprecated key symbol. Use CLUTTER_KEY_signifblank instead.")
#define CLUTTER_ellipsis 0xaae CLUTTER_DEPRECATED_MACRO_FOR("Deprecated key symbol. Use CLUTTER_KEY_ellipsis instead.")
#define CLUTTER_doubbaselinedot 0xaaf CLUTTER_DEPRECATED_MACRO_FOR("Deprecated key symbol. Use CLUTTER_KEY_doubbaselinedot instead.")
#define CLUTTER_onethird 0xab0 CLUTTER_DEPRECATED_MACRO_FOR("Deprecated key symbol. Use CLUTTER_KEY_onethird instead.")
#define CLUTTER_twothirds 0xab1 CLUTTER_DEPRECATED_MACRO_FOR("Deprecated key symbol. Use CLUTTER_KEY_twothirds instead.")
#define CLUTTER_onefifth 0xab2 CLUTTER_DEPRECATED_MACRO_FOR("Deprecated key symbol. Use CLUTTER_KEY_onefifth instead.")
#define CLUTTER_twofifths 0xab3 CLUTTER_DEPRECATED_MACRO_FOR("Deprecated key symbol. Use CLUTTER_KEY_twofifths instead.")
#define CLUTTER_threefifths 0xab4 CLUTTER_DEPRECATED_MACRO_FOR("Deprecated key symbol. Use CLUTTER_KEY_threefifths instead.")
#define CLUTTER_fourfifths 0xab5 CLUTTER_DEPRECATED_MACRO_FOR("Deprecated key symbol. Use CLUTTER_KEY_fourfifths instead.")
#define CLUTTER_onesixth 0xab6 CLUTTER_DEPRECATED_MACRO_FOR("Deprecated key symbol. Use CLUTTER_KEY_onesixth instead.")
#define CLUTTER_fivesixths 0xab7 CLUTTER_DEPRECATED_MACRO_FOR("Deprecated key symbol. Use CLUTTER_KEY_fivesixths instead.")
#define CLUTTER_careof 0xab8 CLUTTER_DEPRECATED_MACRO_FOR("Deprecated key symbol. Use CLUTTER_KEY_careof instead.")
#define CLUTTER_figdash 0xabb CLUTTER_DEPRECATED_MACRO_FOR("Deprecated key symbol. Use CLUTTER_KEY_figdash instead.")
#define CLUTTER_leftanglebracket 0xabc CLUTTER_DEPRECATED_MACRO_FOR("Deprecated key symbol. Use CLUTTER_KEY_leftanglebracket instead.")
#define CLUTTER_decimalpoint 0xabd CLUTTER_DEPRECATED_MACRO_FOR("Deprecated key symbol. Use CLUTTER_KEY_decimalpoint instead.")
#define CLUTTER_rightanglebracket 0xabe CLUTTER_DEPRECATED_MACRO_FOR("Deprecated key symbol. Use CLUTTER_KEY_rightanglebracket instead.")
#define CLUTTER_marker 0xabf CLUTTER_DEPRECATED_MACRO_FOR("Deprecated key symbol. Use CLUTTER_KEY_marker instead.")
#define CLUTTER_oneeighth 0xac3 CLUTTER_DEPRECATED_MACRO_FOR("Deprecated key symbol. Use CLUTTER_KEY_oneeighth instead.")
#define CLUTTER_threeeighths 0xac4 CLUTTER_DEPRECATED_MACRO_FOR("Deprecated key symbol. Use CLUTTER_KEY_threeeighths instead.")
#define CLUTTER_fiveeighths 0xac5 CLUTTER_DEPRECATED_MACRO_FOR("Deprecated key symbol. Use CLUTTER_KEY_fiveeighths instead.")
#define CLUTTER_seveneighths 0xac6 CLUTTER_DEPRECATED_MACRO_FOR("Deprecated key symbol. Use CLUTTER_KEY_seveneighths instead.")
#define CLUTTER_trademark 0xac9 CLUTTER_DEPRECATED_MACRO_FOR("Deprecated key symbol. Use CLUTTER_KEY_trademark instead.")
#define CLUTTER_signaturemark 0xaca CLUTTER_DEPRECATED_MACRO_FOR("Deprecated key symbol. Use CLUTTER_KEY_signaturemark instead.")
#define CLUTTER_trademarkincircle 0xacb CLUTTER_DEPRECATED_MACRO_FOR("Deprecated key symbol. Use CLUTTER_KEY_trademarkincircle instead.")
#define CLUTTER_leftopentriangle 0xacc CLUTTER_DEPRECATED_MACRO_FOR("Deprecated key symbol. Use CLUTTER_KEY_leftopentriangle instead.")
#define CLUTTER_rightopentriangle 0xacd CLUTTER_DEPRECATED_MACRO_FOR("Deprecated key symbol. Use CLUTTER_KEY_rightopentriangle instead.")
#define CLUTTER_emopencircle 0xace CLUTTER_DEPRECATED_MACRO_FOR("Deprecated key symbol. Use CLUTTER_KEY_emopencircle instead.")
#define CLUTTER_emopenrectangle 0xacf CLUTTER_DEPRECATED_MACRO_FOR("Deprecated key symbol. Use CLUTTER_KEY_emopenrectangle instead.")
#define CLUTTER_leftsinglequotemark 0xad0 CLUTTER_DEPRECATED_MACRO_FOR("Deprecated key symbol. Use CLUTTER_KEY_leftsinglequotemark instead.")
#define CLUTTER_rightsinglequotemark 0xad1 CLUTTER_DEPRECATED_MACRO_FOR("Deprecated key symbol. Use CLUTTER_KEY_rightsinglequotemark instead.")
#define CLUTTER_leftdoublequotemark 0xad2 CLUTTER_DEPRECATED_MACRO_FOR("Deprecated key symbol. Use CLUTTER_KEY_leftdoublequotemark instead.")
#define CLUTTER_rightdoublequotemark 0xad3 CLUTTER_DEPRECATED_MACRO_FOR("Deprecated key symbol. Use CLUTTER_KEY_rightdoublequotemark instead.")
#define CLUTTER_prescription 0xad4 CLUTTER_DEPRECATED_MACRO_FOR("Deprecated key symbol. Use CLUTTER_KEY_prescription instead.")
#define CLUTTER_permille 0xad5 CLUTTER_DEPRECATED_MACRO_FOR("Deprecated key symbol. Use CLUTTER_KEY_permille instead.")
#define CLUTTER_minutes 0xad6 CLUTTER_DEPRECATED_MACRO_FOR("Deprecated key symbol. Use CLUTTER_KEY_minutes instead.")
#define CLUTTER_seconds 0xad7 CLUTTER_DEPRECATED_MACRO_FOR("Deprecated key symbol. Use CLUTTER_KEY_seconds instead.")
#define CLUTTER_latincross 0xad9 CLUTTER_DEPRECATED_MACRO_FOR("Deprecated key symbol. Use CLUTTER_KEY_latincross instead.")
#define CLUTTER_hexagram 0xada CLUTTER_DEPRECATED_MACRO_FOR("Deprecated key symbol. Use CLUTTER_KEY_hexagram instead.")
#define CLUTTER_filledrectbullet 0xadb CLUTTER_DEPRECATED_MACRO_FOR("Deprecated key symbol. Use CLUTTER_KEY_filledrectbullet instead.")
#define CLUTTER_filledlefttribullet 0xadc CLUTTER_DEPRECATED_MACRO_FOR("Deprecated key symbol. Use CLUTTER_KEY_filledlefttribullet instead.")
#define CLUTTER_filledrighttribullet 0xadd CLUTTER_DEPRECATED_MACRO_FOR("Deprecated key symbol. Use CLUTTER_KEY_filledrighttribullet instead.")
#define CLUTTER_emfilledcircle 0xade CLUTTER_DEPRECATED_MACRO_FOR("Deprecated key symbol. Use CLUTTER_KEY_emfilledcircle instead.")
#define CLUTTER_emfilledrect 0xadf CLUTTER_DEPRECATED_MACRO_FOR("Deprecated key symbol. Use CLUTTER_KEY_emfilledrect instead.")
#define CLUTTER_enopencircbullet 0xae0 CLUTTER_DEPRECATED_MACRO_FOR("Deprecated key symbol. Use CLUTTER_KEY_enopencircbullet instead.")
#define CLUTTER_enopensquarebullet 0xae1 CLUTTER_DEPRECATED_MACRO_FOR("Deprecated key symbol. Use CLUTTER_KEY_enopensquarebullet instead.")
#define CLUTTER_openrectbullet 0xae2 CLUTTER_DEPRECATED_MACRO_FOR("Deprecated key symbol. Use CLUTTER_KEY_openrectbullet instead.")
#define CLUTTER_opentribulletup 0xae3 CLUTTER_DEPRECATED_MACRO_FOR("Deprecated key symbol. Use CLUTTER_KEY_opentribulletup instead.")
#define CLUTTER_opentribulletdown 0xae4 CLUTTER_DEPRECATED_MACRO_FOR("Deprecated key symbol. Use CLUTTER_KEY_opentribulletdown instead.")
#define CLUTTER_openstar 0xae5 CLUTTER_DEPRECATED_MACRO_FOR("Deprecated key symbol. Use CLUTTER_KEY_openstar instead.")
#define CLUTTER_enfilledcircbullet 0xae6 CLUTTER_DEPRECATED_MACRO_FOR("Deprecated key symbol. Use CLUTTER_KEY_enfilledcircbullet instead.")
#define CLUTTER_enfilledsqbullet 0xae7 CLUTTER_DEPRECATED_MACRO_FOR("Deprecated key symbol. Use CLUTTER_KEY_enfilledsqbullet instead.")
#define CLUTTER_filledtribulletup 0xae8 CLUTTER_DEPRECATED_MACRO_FOR("Deprecated key symbol. Use CLUTTER_KEY_filledtribulletup instead.")
#define CLUTTER_filledtribulletdown 0xae9 CLUTTER_DEPRECATED_MACRO_FOR("Deprecated key symbol. Use CLUTTER_KEY_filledtribulletdown instead.")
#define CLUTTER_leftpointer 0xaea CLUTTER_DEPRECATED_MACRO_FOR("Deprecated key symbol. Use CLUTTER_KEY_leftpointer instead.")
#define CLUTTER_rightpointer 0xaeb CLUTTER_DEPRECATED_MACRO_FOR("Deprecated key symbol. Use CLUTTER_KEY_rightpointer instead.")
#define CLUTTER_club 0xaec CLUTTER_DEPRECATED_MACRO_FOR("Deprecated key symbol. Use CLUTTER_KEY_club instead.")
#define CLUTTER_diamond 0xaed CLUTTER_DEPRECATED_MACRO_FOR("Deprecated key symbol. Use CLUTTER_KEY_diamond instead.")
#define CLUTTER_heart 0xaee CLUTTER_DEPRECATED_MACRO_FOR("Deprecated key symbol. Use CLUTTER_KEY_heart instead.")
#define CLUTTER_maltesecross 0xaf0 CLUTTER_DEPRECATED_MACRO_FOR("Deprecated key symbol. Use CLUTTER_KEY_maltesecross instead.")
#define CLUTTER_dagger 0xaf1 CLUTTER_DEPRECATED_MACRO_FOR("Deprecated key symbol. Use CLUTTER_KEY_dagger instead.")
#define CLUTTER_doubledagger 0xaf2 CLUTTER_DEPRECATED_MACRO_FOR("Deprecated key symbol. Use CLUTTER_KEY_doubledagger instead.")
#define CLUTTER_checkmark 0xaf3 CLUTTER_DEPRECATED_MACRO_FOR("Deprecated key symbol. Use CLUTTER_KEY_checkmark instead.")
#define CLUTTER_ballotcross 0xaf4 CLUTTER_DEPRECATED_MACRO_FOR("Deprecated key symbol. Use CLUTTER_KEY_ballotcross instead.")
#define CLUTTER_musicalsharp 0xaf5 CLUTTER_DEPRECATED_MACRO_FOR("Deprecated key symbol. Use CLUTTER_KEY_musicalsharp instead.")
#define CLUTTER_musicalflat 0xaf6 CLUTTER_DEPRECATED_MACRO_FOR("Deprecated key symbol. Use CLUTTER_KEY_musicalflat instead.")
#define CLUTTER_malesymbol 0xaf7 CLUTTER_DEPRECATED_MACRO_FOR("Deprecated key symbol. Use CLUTTER_KEY_malesymbol instead.")
#define CLUTTER_femalesymbol 0xaf8 CLUTTER_DEPRECATED_MACRO_FOR("Deprecated key symbol. Use CLUTTER_KEY_femalesymbol instead.")
#define CLUTTER_telephone 0xaf9 CLUTTER_DEPRECATED_MACRO_FOR("Deprecated key symbol. Use CLUTTER_KEY_telephone instead.")
#define CLUTTER_telephonerecorder 0xafa CLUTTER_DEPRECATED_MACRO_FOR("Deprecated key symbol. Use CLUTTER_KEY_telephonerecorder instead.")
#define CLUTTER_phonographcopyright 0xafb CLUTTER_DEPRECATED_MACRO_FOR("Deprecated key symbol. Use CLUTTER_KEY_phonographcopyright instead.")
#define CLUTTER_caret 0xafc CLUTTER_DEPRECATED_MACRO_FOR("Deprecated key symbol. Use CLUTTER_KEY_caret instead.")
#define CLUTTER_singlelowquotemark 0xafd CLUTTER_DEPRECATED_MACRO_FOR("Deprecated key symbol. Use CLUTTER_KEY_singlelowquotemark instead.")
#define CLUTTER_doublelowquotemark 0xafe CLUTTER_DEPRECATED_MACRO_FOR("Deprecated key symbol. Use CLUTTER_KEY_doublelowquotemark instead.")
#define CLUTTER_cursor 0xaff CLUTTER_DEPRECATED_MACRO_FOR("Deprecated key symbol. Use CLUTTER_KEY_cursor instead.")
#define CLUTTER_leftcaret 0xba3 CLUTTER_DEPRECATED_MACRO_FOR("Deprecated key symbol. Use CLUTTER_KEY_leftcaret instead.")
#define CLUTTER_rightcaret 0xba6 CLUTTER_DEPRECATED_MACRO_FOR("Deprecated key symbol. Use CLUTTER_KEY_rightcaret instead.")
#define CLUTTER_downcaret 0xba8 CLUTTER_DEPRECATED_MACRO_FOR("Deprecated key symbol. Use CLUTTER_KEY_downcaret instead.")
#define CLUTTER_upcaret 0xba9 CLUTTER_DEPRECATED_MACRO_FOR("Deprecated key symbol. Use CLUTTER_KEY_upcaret instead.")
#define CLUTTER_overbar 0xbc0 CLUTTER_DEPRECATED_MACRO_FOR("Deprecated key symbol. Use CLUTTER_KEY_overbar instead.")
#define CLUTTER_downtack 0xbc2 CLUTTER_DEPRECATED_MACRO_FOR("Deprecated key symbol. Use CLUTTER_KEY_downtack instead.")
#define CLUTTER_upshoe 0xbc3 CLUTTER_DEPRECATED_MACRO_FOR("Deprecated key symbol. Use CLUTTER_KEY_upshoe instead.")
#define CLUTTER_downstile 0xbc4 CLUTTER_DEPRECATED_MACRO_FOR("Deprecated key symbol. Use CLUTTER_KEY_downstile instead.")
#define CLUTTER_underbar 0xbc6 CLUTTER_DEPRECATED_MACRO_FOR("Deprecated key symbol. Use CLUTTER_KEY_underbar instead.")
#define CLUTTER_jot 0xbca CLUTTER_DEPRECATED_MACRO_FOR("Deprecated key symbol. Use CLUTTER_KEY_jot instead.")
#define CLUTTER_quad 0xbcc CLUTTER_DEPRECATED_MACRO_FOR("Deprecated key symbol. Use CLUTTER_KEY_quad instead.")
#define CLUTTER_uptack 0xbce CLUTTER_DEPRECATED_MACRO_FOR("Deprecated key symbol. Use CLUTTER_KEY_uptack instead.")
#define CLUTTER_circle 0xbcf CLUTTER_DEPRECATED_MACRO_FOR("Deprecated key symbol. Use CLUTTER_KEY_circle instead.")
#define CLUTTER_upstile 0xbd3 CLUTTER_DEPRECATED_MACRO_FOR("Deprecated key symbol. Use CLUTTER_KEY_upstile instead.")
#define CLUTTER_downshoe 0xbd6 CLUTTER_DEPRECATED_MACRO_FOR("Deprecated key symbol. Use CLUTTER_KEY_downshoe instead.")
#define CLUTTER_rightshoe 0xbd8 CLUTTER_DEPRECATED_MACRO_FOR("Deprecated key symbol. Use CLUTTER_KEY_rightshoe instead.")
#define CLUTTER_leftshoe 0xbda CLUTTER_DEPRECATED_MACRO_FOR("Deprecated key symbol. Use CLUTTER_KEY_leftshoe instead.")
#define CLUTTER_lefttack 0xbdc CLUTTER_DEPRECATED_MACRO_FOR("Deprecated key symbol. Use CLUTTER_KEY_lefttack instead.")
#define CLUTTER_righttack 0xbfc CLUTTER_DEPRECATED_MACRO_FOR("Deprecated key symbol. Use CLUTTER_KEY_righttack instead.")
#define CLUTTER_hebrew_doublelowline 0xcdf CLUTTER_DEPRECATED_MACRO_FOR("Deprecated key symbol. Use CLUTTER_KEY_hebrew_doublelowline instead.")
#define CLUTTER_hebrew_aleph 0xce0 CLUTTER_DEPRECATED_MACRO_FOR("Deprecated key symbol. Use CLUTTER_KEY_hebrew_aleph instead.")
#define CLUTTER_hebrew_bet 0xce1 CLUTTER_DEPRECATED_MACRO_FOR("Deprecated key symbol. Use CLUTTER_KEY_hebrew_bet instead.")
#define CLUTTER_hebrew_beth 0xce1 CLUTTER_DEPRECATED_MACRO_FOR("Deprecated key symbol. Use CLUTTER_KEY_hebrew_beth instead.")
#define CLUTTER_hebrew_gimel 0xce2 CLUTTER_DEPRECATED_MACRO_FOR("Deprecated key symbol. Use CLUTTER_KEY_hebrew_gimel instead.")
#define CLUTTER_hebrew_gimmel 0xce2 CLUTTER_DEPRECATED_MACRO_FOR("Deprecated key symbol. Use CLUTTER_KEY_hebrew_gimmel instead.")
#define CLUTTER_hebrew_dalet 0xce3 CLUTTER_DEPRECATED_MACRO_FOR("Deprecated key symbol. Use CLUTTER_KEY_hebrew_dalet instead.")
#define CLUTTER_hebrew_daleth 0xce3 CLUTTER_DEPRECATED_MACRO_FOR("Deprecated key symbol. Use CLUTTER_KEY_hebrew_daleth instead.")
#define CLUTTER_hebrew_he 0xce4 CLUTTER_DEPRECATED_MACRO_FOR("Deprecated key symbol. Use CLUTTER_KEY_hebrew_he instead.")
#define CLUTTER_hebrew_waw 0xce5 CLUTTER_DEPRECATED_MACRO_FOR("Deprecated key symbol. Use CLUTTER_KEY_hebrew_waw instead.")
#define CLUTTER_hebrew_zain 0xce6 CLUTTER_DEPRECATED_MACRO_FOR("Deprecated key symbol. Use CLUTTER_KEY_hebrew_zain instead.")
#define CLUTTER_hebrew_zayin 0xce6 CLUTTER_DEPRECATED_MACRO_FOR("Deprecated key symbol. Use CLUTTER_KEY_hebrew_zayin instead.")
#define CLUTTER_hebrew_chet 0xce7 CLUTTER_DEPRECATED_MACRO_FOR("Deprecated key symbol. Use CLUTTER_KEY_hebrew_chet instead.")
#define CLUTTER_hebrew_het 0xce7 CLUTTER_DEPRECATED_MACRO_FOR("Deprecated key symbol. Use CLUTTER_KEY_hebrew_het instead.")
#define CLUTTER_hebrew_tet 0xce8 CLUTTER_DEPRECATED_MACRO_FOR("Deprecated key symbol. Use CLUTTER_KEY_hebrew_tet instead.")
#define CLUTTER_hebrew_teth 0xce8 CLUTTER_DEPRECATED_MACRO_FOR("Deprecated key symbol. Use CLUTTER_KEY_hebrew_teth instead.")
#define CLUTTER_hebrew_yod 0xce9 CLUTTER_DEPRECATED_MACRO_FOR("Deprecated key symbol. Use CLUTTER_KEY_hebrew_yod instead.")
#define CLUTTER_hebrew_finalkaph 0xcea CLUTTER_DEPRECATED_MACRO_FOR("Deprecated key symbol. Use CLUTTER_KEY_hebrew_finalkaph instead.")
#define CLUTTER_hebrew_kaph 0xceb CLUTTER_DEPRECATED_MACRO_FOR("Deprecated key symbol. Use CLUTTER_KEY_hebrew_kaph instead.")
#define CLUTTER_hebrew_lamed 0xcec CLUTTER_DEPRECATED_MACRO_FOR("Deprecated key symbol. Use CLUTTER_KEY_hebrew_lamed instead.")
#define CLUTTER_hebrew_finalmem 0xced CLUTTER_DEPRECATED_MACRO_FOR("Deprecated key symbol. Use CLUTTER_KEY_hebrew_finalmem instead.")
#define CLUTTER_hebrew_mem 0xcee CLUTTER_DEPRECATED_MACRO_FOR("Deprecated key symbol. Use CLUTTER_KEY_hebrew_mem instead.")
#define CLUTTER_hebrew_finalnun 0xcef CLUTTER_DEPRECATED_MACRO_FOR("Deprecated key symbol. Use CLUTTER_KEY_hebrew_finalnun instead.")
#define CLUTTER_hebrew_nun 0xcf0 CLUTTER_DEPRECATED_MACRO_FOR("Deprecated key symbol. Use CLUTTER_KEY_hebrew_nun instead.")
#define CLUTTER_hebrew_samech 0xcf1 CLUTTER_DEPRECATED_MACRO_FOR("Deprecated key symbol. Use CLUTTER_KEY_hebrew_samech instead.")
#define CLUTTER_hebrew_samekh 0xcf1 CLUTTER_DEPRECATED_MACRO_FOR("Deprecated key symbol. Use CLUTTER_KEY_hebrew_samekh instead.")
#define CLUTTER_hebrew_ayin 0xcf2 CLUTTER_DEPRECATED_MACRO_FOR("Deprecated key symbol. Use CLUTTER_KEY_hebrew_ayin instead.")
#define CLUTTER_hebrew_finalpe 0xcf3 CLUTTER_DEPRECATED_MACRO_FOR("Deprecated key symbol. Use CLUTTER_KEY_hebrew_finalpe instead.")
#define CLUTTER_hebrew_pe 0xcf4 CLUTTER_DEPRECATED_MACRO_FOR("Deprecated key symbol. Use CLUTTER_KEY_hebrew_pe instead.")
#define CLUTTER_hebrew_finalzade 0xcf5 CLUTTER_DEPRECATED_MACRO_FOR("Deprecated key symbol. Use CLUTTER_KEY_hebrew_finalzade instead.")
#define CLUTTER_hebrew_finalzadi 0xcf5 CLUTTER_DEPRECATED_MACRO_FOR("Deprecated key symbol. Use CLUTTER_KEY_hebrew_finalzadi instead.")
#define CLUTTER_hebrew_zade 0xcf6 CLUTTER_DEPRECATED_MACRO_FOR("Deprecated key symbol. Use CLUTTER_KEY_hebrew_zade instead.")
#define CLUTTER_hebrew_zadi 0xcf6 CLUTTER_DEPRECATED_MACRO_FOR("Deprecated key symbol. Use CLUTTER_KEY_hebrew_zadi instead.")
#define CLUTTER_hebrew_qoph 0xcf7 CLUTTER_DEPRECATED_MACRO_FOR("Deprecated key symbol. Use CLUTTER_KEY_hebrew_qoph instead.")
#define CLUTTER_hebrew_kuf 0xcf7 CLUTTER_DEPRECATED_MACRO_FOR("Deprecated key symbol. Use CLUTTER_KEY_hebrew_kuf instead.")
#define CLUTTER_hebrew_resh 0xcf8 CLUTTER_DEPRECATED_MACRO_FOR("Deprecated key symbol. Use CLUTTER_KEY_hebrew_resh instead.")
#define CLUTTER_hebrew_shin 0xcf9 CLUTTER_DEPRECATED_MACRO_FOR("Deprecated key symbol. Use CLUTTER_KEY_hebrew_shin instead.")
#define CLUTTER_hebrew_taw 0xcfa CLUTTER_DEPRECATED_MACRO_FOR("Deprecated key symbol. Use CLUTTER_KEY_hebrew_taw instead.")
#define CLUTTER_hebrew_taf 0xcfa CLUTTER_DEPRECATED_MACRO_FOR("Deprecated key symbol. Use CLUTTER_KEY_hebrew_taf instead.")
#define CLUTTER_Hebrew_switch 0xff7e CLUTTER_DEPRECATED_MACRO_FOR("Deprecated key symbol. Use CLUTTER_KEY_Hebrew_switch instead.")
#define CLUTTER_Thai_kokai 0xda1 CLUTTER_DEPRECATED_MACRO_FOR("Deprecated key symbol. Use CLUTTER_KEY_Thai_kokai instead.")
#define CLUTTER_Thai_khokhai 0xda2 CLUTTER_DEPRECATED_MACRO_FOR("Deprecated key symbol. Use CLUTTER_KEY_Thai_khokhai instead.")
#define CLUTTER_Thai_khokhuat 0xda3 CLUTTER_DEPRECATED_MACRO_FOR("Deprecated key symbol. Use CLUTTER_KEY_Thai_khokhuat instead.")
#define CLUTTER_Thai_khokhwai 0xda4 CLUTTER_DEPRECATED_MACRO_FOR("Deprecated key symbol. Use CLUTTER_KEY_Thai_khokhwai instead.")
#define CLUTTER_Thai_khokhon 0xda5 CLUTTER_DEPRECATED_MACRO_FOR("Deprecated key symbol. Use CLUTTER_KEY_Thai_khokhon instead.")
#define CLUTTER_Thai_khorakhang 0xda6 CLUTTER_DEPRECATED_MACRO_FOR("Deprecated key symbol. Use CLUTTER_KEY_Thai_khorakhang instead.")
#define CLUTTER_Thai_ngongu 0xda7 CLUTTER_DEPRECATED_MACRO_FOR("Deprecated key symbol. Use CLUTTER_KEY_Thai_ngongu instead.")
#define CLUTTER_Thai_chochan 0xda8 CLUTTER_DEPRECATED_MACRO_FOR("Deprecated key symbol. Use CLUTTER_KEY_Thai_chochan instead.")
#define CLUTTER_Thai_choching 0xda9 CLUTTER_DEPRECATED_MACRO_FOR("Deprecated key symbol. Use CLUTTER_KEY_Thai_choching instead.")
#define CLUTTER_Thai_chochang 0xdaa CLUTTER_DEPRECATED_MACRO_FOR("Deprecated key symbol. Use CLUTTER_KEY_Thai_chochang instead.")
#define CLUTTER_Thai_soso 0xdab CLUTTER_DEPRECATED_MACRO_FOR("Deprecated key symbol. Use CLUTTER_KEY_Thai_soso instead.")
#define CLUTTER_Thai_chochoe 0xdac CLUTTER_DEPRECATED_MACRO_FOR("Deprecated key symbol. Use CLUTTER_KEY_Thai_chochoe instead.")
#define CLUTTER_Thai_yoying 0xdad CLUTTER_DEPRECATED_MACRO_FOR("Deprecated key symbol. Use CLUTTER_KEY_Thai_yoying instead.")
#define CLUTTER_Thai_dochada 0xdae CLUTTER_DEPRECATED_MACRO_FOR("Deprecated key symbol. Use CLUTTER_KEY_Thai_dochada instead.")
#define CLUTTER_Thai_topatak 0xdaf CLUTTER_DEPRECATED_MACRO_FOR("Deprecated key symbol. Use CLUTTER_KEY_Thai_topatak instead.")
#define CLUTTER_Thai_thothan 0xdb0 CLUTTER_DEPRECATED_MACRO_FOR("Deprecated key symbol. Use CLUTTER_KEY_Thai_thothan instead.")
#define CLUTTER_Thai_thonangmontho 0xdb1 CLUTTER_DEPRECATED_MACRO_FOR("Deprecated key symbol. Use CLUTTER_KEY_Thai_thonangmontho instead.")
#define CLUTTER_Thai_thophuthao 0xdb2 CLUTTER_DEPRECATED_MACRO_FOR("Deprecated key symbol. Use CLUTTER_KEY_Thai_thophuthao instead.")
#define CLUTTER_Thai_nonen 0xdb3 CLUTTER_DEPRECATED_MACRO_FOR("Deprecated key symbol. Use CLUTTER_KEY_Thai_nonen instead.")
#define CLUTTER_Thai_dodek 0xdb4 CLUTTER_DEPRECATED_MACRO_FOR("Deprecated key symbol. Use CLUTTER_KEY_Thai_dodek instead.")
#define CLUTTER_Thai_totao 0xdb5 CLUTTER_DEPRECATED_MACRO_FOR("Deprecated key symbol. Use CLUTTER_KEY_Thai_totao instead.")
#define CLUTTER_Thai_thothung 0xdb6 CLUTTER_DEPRECATED_MACRO_FOR("Deprecated key symbol. Use CLUTTER_KEY_Thai_thothung instead.")
#define CLUTTER_Thai_thothahan 0xdb7 CLUTTER_DEPRECATED_MACRO_FOR("Deprecated key symbol. Use CLUTTER_KEY_Thai_thothahan instead.")
#define CLUTTER_Thai_thothong 0xdb8 CLUTTER_DEPRECATED_MACRO_FOR("Deprecated key symbol. Use CLUTTER_KEY_Thai_thothong instead.")
#define CLUTTER_Thai_nonu 0xdb9 CLUTTER_DEPRECATED_MACRO_FOR("Deprecated key symbol. Use CLUTTER_KEY_Thai_nonu instead.")
#define CLUTTER_Thai_bobaimai 0xdba CLUTTER_DEPRECATED_MACRO_FOR("Deprecated key symbol. Use CLUTTER_KEY_Thai_bobaimai instead.")
#define CLUTTER_Thai_popla 0xdbb CLUTTER_DEPRECATED_MACRO_FOR("Deprecated key symbol. Use CLUTTER_KEY_Thai_popla instead.")
#define CLUTTER_Thai_phophung 0xdbc CLUTTER_DEPRECATED_MACRO_FOR("Deprecated key symbol. Use CLUTTER_KEY_Thai_phophung instead.")
#define CLUTTER_Thai_fofa 0xdbd CLUTTER_DEPRECATED_MACRO_FOR("Deprecated key symbol. Use CLUTTER_KEY_Thai_fofa instead.")
#define CLUTTER_Thai_phophan 0xdbe CLUTTER_DEPRECATED_MACRO_FOR("Deprecated key symbol. Use CLUTTER_KEY_Thai_phophan instead.")
#define CLUTTER_Thai_fofan 0xdbf CLUTTER_DEPRECATED_MACRO_FOR("Deprecated key symbol. Use CLUTTER_KEY_Thai_fofan instead.")
#define CLUTTER_Thai_phosamphao 0xdc0 CLUTTER_DEPRECATED_MACRO_FOR("Deprecated key symbol. Use CLUTTER_KEY_Thai_phosamphao instead.")
#define CLUTTER_Thai_moma 0xdc1 CLUTTER_DEPRECATED_MACRO_FOR("Deprecated key symbol. Use CLUTTER_KEY_Thai_moma instead.")
#define CLUTTER_Thai_yoyak 0xdc2 CLUTTER_DEPRECATED_MACRO_FOR("Deprecated key symbol. Use CLUTTER_KEY_Thai_yoyak instead.")
#define CLUTTER_Thai_rorua 0xdc3 CLUTTER_DEPRECATED_MACRO_FOR("Deprecated key symbol. Use CLUTTER_KEY_Thai_rorua instead.")
#define CLUTTER_Thai_ru 0xdc4 CLUTTER_DEPRECATED_MACRO_FOR("Deprecated key symbol. Use CLUTTER_KEY_Thai_ru instead.")
#define CLUTTER_Thai_loling 0xdc5 CLUTTER_DEPRECATED_MACRO_FOR("Deprecated key symbol. Use CLUTTER_KEY_Thai_loling instead.")
#define CLUTTER_Thai_lu 0xdc6 CLUTTER_DEPRECATED_MACRO_FOR("Deprecated key symbol. Use CLUTTER_KEY_Thai_lu instead.")
#define CLUTTER_Thai_wowaen 0xdc7 CLUTTER_DEPRECATED_MACRO_FOR("Deprecated key symbol. Use CLUTTER_KEY_Thai_wowaen instead.")
#define CLUTTER_Thai_sosala 0xdc8 CLUTTER_DEPRECATED_MACRO_FOR("Deprecated key symbol. Use CLUTTER_KEY_Thai_sosala instead.")
#define CLUTTER_Thai_sorusi 0xdc9 CLUTTER_DEPRECATED_MACRO_FOR("Deprecated key symbol. Use CLUTTER_KEY_Thai_sorusi instead.")
#define CLUTTER_Thai_sosua 0xdca CLUTTER_DEPRECATED_MACRO_FOR("Deprecated key symbol. Use CLUTTER_KEY_Thai_sosua instead.")
#define CLUTTER_Thai_hohip 0xdcb CLUTTER_DEPRECATED_MACRO_FOR("Deprecated key symbol. Use CLUTTER_KEY_Thai_hohip instead.")
#define CLUTTER_Thai_lochula 0xdcc CLUTTER_DEPRECATED_MACRO_FOR("Deprecated key symbol. Use CLUTTER_KEY_Thai_lochula instead.")
#define CLUTTER_Thai_oang 0xdcd CLUTTER_DEPRECATED_MACRO_FOR("Deprecated key symbol. Use CLUTTER_KEY_Thai_oang instead.")
#define CLUTTER_Thai_honokhuk 0xdce CLUTTER_DEPRECATED_MACRO_FOR("Deprecated key symbol. Use CLUTTER_KEY_Thai_honokhuk instead.")
#define CLUTTER_Thai_paiyannoi 0xdcf CLUTTER_DEPRECATED_MACRO_FOR("Deprecated key symbol. Use CLUTTER_KEY_Thai_paiyannoi instead.")
#define CLUTTER_Thai_saraa 0xdd0 CLUTTER_DEPRECATED_MACRO_FOR("Deprecated key symbol. Use CLUTTER_KEY_Thai_saraa instead.")
#define CLUTTER_Thai_maihanakat 0xdd1 CLUTTER_DEPRECATED_MACRO_FOR("Deprecated key symbol. Use CLUTTER_KEY_Thai_maihanakat instead.")
#define CLUTTER_Thai_saraaa 0xdd2 CLUTTER_DEPRECATED_MACRO_FOR("Deprecated key symbol. Use CLUTTER_KEY_Thai_saraaa instead.")
#define CLUTTER_Thai_saraam 0xdd3 CLUTTER_DEPRECATED_MACRO_FOR("Deprecated key symbol. Use CLUTTER_KEY_Thai_saraam instead.")
#define CLUTTER_Thai_sarai 0xdd4 CLUTTER_DEPRECATED_MACRO_FOR("Deprecated key symbol. Use CLUTTER_KEY_Thai_sarai instead.")
#define CLUTTER_Thai_saraii 0xdd5 CLUTTER_DEPRECATED_MACRO_FOR("Deprecated key symbol. Use CLUTTER_KEY_Thai_saraii instead.")
#define CLUTTER_Thai_saraue 0xdd6 CLUTTER_DEPRECATED_MACRO_FOR("Deprecated key symbol. Use CLUTTER_KEY_Thai_saraue instead.")
#define CLUTTER_Thai_sarauee 0xdd7 CLUTTER_DEPRECATED_MACRO_FOR("Deprecated key symbol. Use CLUTTER_KEY_Thai_sarauee instead.")
#define CLUTTER_Thai_sarau 0xdd8 CLUTTER_DEPRECATED_MACRO_FOR("Deprecated key symbol. Use CLUTTER_KEY_Thai_sarau instead.")
#define CLUTTER_Thai_sarauu 0xdd9 CLUTTER_DEPRECATED_MACRO_FOR("Deprecated key symbol. Use CLUTTER_KEY_Thai_sarauu instead.")
#define CLUTTER_Thai_phinthu 0xdda CLUTTER_DEPRECATED_MACRO_FOR("Deprecated key symbol. Use CLUTTER_KEY_Thai_phinthu instead.")
#define CLUTTER_Thai_maihanakat_maitho 0xdde CLUTTER_DEPRECATED_MACRO_FOR("Deprecated key symbol. Use CLUTTER_KEY_Thai_maihanakat_maitho instead.")
#define CLUTTER_Thai_baht 0xddf CLUTTER_DEPRECATED_MACRO_FOR("Deprecated key symbol. Use CLUTTER_KEY_Thai_baht instead.")
#define CLUTTER_Thai_sarae 0xde0 CLUTTER_DEPRECATED_MACRO_FOR("Deprecated key symbol. Use CLUTTER_KEY_Thai_sarae instead.")
#define CLUTTER_Thai_saraae 0xde1 CLUTTER_DEPRECATED_MACRO_FOR("Deprecated key symbol. Use CLUTTER_KEY_Thai_saraae instead.")
#define CLUTTER_Thai_sarao 0xde2 CLUTTER_DEPRECATED_MACRO_FOR("Deprecated key symbol. Use CLUTTER_KEY_Thai_sarao instead.")
#define CLUTTER_Thai_saraaimaimuan 0xde3 CLUTTER_DEPRECATED_MACRO_FOR("Deprecated key symbol. Use CLUTTER_KEY_Thai_saraaimaimuan instead.")
#define CLUTTER_Thai_saraaimaimalai 0xde4 CLUTTER_DEPRECATED_MACRO_FOR("Deprecated key symbol. Use CLUTTER_KEY_Thai_saraaimaimalai instead.")
#define CLUTTER_Thai_lakkhangyao 0xde5 CLUTTER_DEPRECATED_MACRO_FOR("Deprecated key symbol. Use CLUTTER_KEY_Thai_lakkhangyao instead.")
#define CLUTTER_Thai_maiyamok 0xde6 CLUTTER_DEPRECATED_MACRO_FOR("Deprecated key symbol. Use CLUTTER_KEY_Thai_maiyamok instead.")
#define CLUTTER_Thai_maitaikhu 0xde7 CLUTTER_DEPRECATED_MACRO_FOR("Deprecated key symbol. Use CLUTTER_KEY_Thai_maitaikhu instead.")
#define CLUTTER_Thai_maiek 0xde8 CLUTTER_DEPRECATED_MACRO_FOR("Deprecated key symbol. Use CLUTTER_KEY_Thai_maiek instead.")
#define CLUTTER_Thai_maitho 0xde9 CLUTTER_DEPRECATED_MACRO_FOR("Deprecated key symbol. Use CLUTTER_KEY_Thai_maitho instead.")
#define CLUTTER_Thai_maitri 0xdea CLUTTER_DEPRECATED_MACRO_FOR("Deprecated key symbol. Use CLUTTER_KEY_Thai_maitri instead.")
#define CLUTTER_Thai_maichattawa 0xdeb CLUTTER_DEPRECATED_MACRO_FOR("Deprecated key symbol. Use CLUTTER_KEY_Thai_maichattawa instead.")
#define CLUTTER_Thai_thanthakhat 0xdec CLUTTER_DEPRECATED_MACRO_FOR("Deprecated key symbol. Use CLUTTER_KEY_Thai_thanthakhat instead.")
#define CLUTTER_Thai_nikhahit 0xded CLUTTER_DEPRECATED_MACRO_FOR("Deprecated key symbol. Use CLUTTER_KEY_Thai_nikhahit instead.")
#define CLUTTER_Thai_leksun 0xdf0 CLUTTER_DEPRECATED_MACRO_FOR("Deprecated key symbol. Use CLUTTER_KEY_Thai_leksun instead.")
#define CLUTTER_Thai_leknung 0xdf1 CLUTTER_DEPRECATED_MACRO_FOR("Deprecated key symbol. Use CLUTTER_KEY_Thai_leknung instead.")
#define CLUTTER_Thai_leksong 0xdf2 CLUTTER_DEPRECATED_MACRO_FOR("Deprecated key symbol. Use CLUTTER_KEY_Thai_leksong instead.")
#define CLUTTER_Thai_leksam 0xdf3 CLUTTER_DEPRECATED_MACRO_FOR("Deprecated key symbol. Use CLUTTER_KEY_Thai_leksam instead.")
#define CLUTTER_Thai_leksi 0xdf4 CLUTTER_DEPRECATED_MACRO_FOR("Deprecated key symbol. Use CLUTTER_KEY_Thai_leksi instead.")
#define CLUTTER_Thai_lekha 0xdf5 CLUTTER_DEPRECATED_MACRO_FOR("Deprecated key symbol. Use CLUTTER_KEY_Thai_lekha instead.")
#define CLUTTER_Thai_lekhok 0xdf6 CLUTTER_DEPRECATED_MACRO_FOR("Deprecated key symbol. Use CLUTTER_KEY_Thai_lekhok instead.")
#define CLUTTER_Thai_lekchet 0xdf7 CLUTTER_DEPRECATED_MACRO_FOR("Deprecated key symbol. Use CLUTTER_KEY_Thai_lekchet instead.")
#define CLUTTER_Thai_lekpaet 0xdf8 CLUTTER_DEPRECATED_MACRO_FOR("Deprecated key symbol. Use CLUTTER_KEY_Thai_lekpaet instead.")
#define CLUTTER_Thai_lekkao 0xdf9 CLUTTER_DEPRECATED_MACRO_FOR("Deprecated key symbol. Use CLUTTER_KEY_Thai_lekkao instead.")
#define CLUTTER_Hangul 0xff31 CLUTTER_DEPRECATED_MACRO_FOR("Deprecated key symbol. Use CLUTTER_KEY_Hangul instead.")
#define CLUTTER_Hangul_Start 0xff32 CLUTTER_DEPRECATED_MACRO_FOR("Deprecated key symbol. Use CLUTTER_KEY_Hangul_Start instead.")
#define CLUTTER_Hangul_End 0xff33 CLUTTER_DEPRECATED_MACRO_FOR("Deprecated key symbol. Use CLUTTER_KEY_Hangul_End instead.")
#define CLUTTER_Hangul_Hanja 0xff34 CLUTTER_DEPRECATED_MACRO_FOR("Deprecated key symbol. Use CLUTTER_KEY_Hangul_Hanja instead.")
#define CLUTTER_Hangul_Jamo 0xff35 CLUTTER_DEPRECATED_MACRO_FOR("Deprecated key symbol. Use CLUTTER_KEY_Hangul_Jamo instead.")
#define CLUTTER_Hangul_Romaja 0xff36 CLUTTER_DEPRECATED_MACRO_FOR("Deprecated key symbol. Use CLUTTER_KEY_Hangul_Romaja instead.")
#define CLUTTER_Hangul_Codeinput 0xff37 CLUTTER_DEPRECATED_MACRO_FOR("Deprecated key symbol. Use CLUTTER_KEY_Hangul_Codeinput instead.")
#define CLUTTER_Hangul_Jeonja 0xff38 CLUTTER_DEPRECATED_MACRO_FOR("Deprecated key symbol. Use CLUTTER_KEY_Hangul_Jeonja instead.")
#define CLUTTER_Hangul_Banja 0xff39 CLUTTER_DEPRECATED_MACRO_FOR("Deprecated key symbol. Use CLUTTER_KEY_Hangul_Banja instead.")
#define CLUTTER_Hangul_PreHanja 0xff3a CLUTTER_DEPRECATED_MACRO_FOR("Deprecated key symbol. Use CLUTTER_KEY_Hangul_PreHanja instead.")
#define CLUTTER_Hangul_PostHanja 0xff3b CLUTTER_DEPRECATED_MACRO_FOR("Deprecated key symbol. Use CLUTTER_KEY_Hangul_PostHanja instead.")
#define CLUTTER_Hangul_SingleCandidate 0xff3c CLUTTER_DEPRECATED_MACRO_FOR("Deprecated key symbol. Use CLUTTER_KEY_Hangul_SingleCandidate instead.")
#define CLUTTER_Hangul_MultipleCandidate 0xff3d CLUTTER_DEPRECATED_MACRO_FOR("Deprecated key symbol. Use CLUTTER_KEY_Hangul_MultipleCandidate instead.")
#define CLUTTER_Hangul_PreviousCandidate 0xff3e CLUTTER_DEPRECATED_MACRO_FOR("Deprecated key symbol. Use CLUTTER_KEY_Hangul_PreviousCandidate instead.")
#define CLUTTER_Hangul_Special 0xff3f CLUTTER_DEPRECATED_MACRO_FOR("Deprecated key symbol. Use CLUTTER_KEY_Hangul_Special instead.")
#define CLUTTER_Hangul_switch 0xff7e CLUTTER_DEPRECATED_MACRO_FOR("Deprecated key symbol. Use CLUTTER_KEY_Hangul_switch instead.")
#define CLUTTER_Hangul_Kiyeog 0xea1 CLUTTER_DEPRECATED_MACRO_FOR("Deprecated key symbol. Use CLUTTER_KEY_Hangul_Kiyeog instead.")
#define CLUTTER_Hangul_SsangKiyeog 0xea2 CLUTTER_DEPRECATED_MACRO_FOR("Deprecated key symbol. Use CLUTTER_KEY_Hangul_SsangKiyeog instead.")
#define CLUTTER_Hangul_KiyeogSios 0xea3 CLUTTER_DEPRECATED_MACRO_FOR("Deprecated key symbol. Use CLUTTER_KEY_Hangul_KiyeogSios instead.")
#define CLUTTER_Hangul_Nieun 0xea4 CLUTTER_DEPRECATED_MACRO_FOR("Deprecated key symbol. Use CLUTTER_KEY_Hangul_Nieun instead.")
#define CLUTTER_Hangul_NieunJieuj 0xea5 CLUTTER_DEPRECATED_MACRO_FOR("Deprecated key symbol. Use CLUTTER_KEY_Hangul_NieunJieuj instead.")
#define CLUTTER_Hangul_NieunHieuh 0xea6 CLUTTER_DEPRECATED_MACRO_FOR("Deprecated key symbol. Use CLUTTER_KEY_Hangul_NieunHieuh instead.")
#define CLUTTER_Hangul_Dikeud 0xea7 CLUTTER_DEPRECATED_MACRO_FOR("Deprecated key symbol. Use CLUTTER_KEY_Hangul_Dikeud instead.")
#define CLUTTER_Hangul_SsangDikeud 0xea8 CLUTTER_DEPRECATED_MACRO_FOR("Deprecated key symbol. Use CLUTTER_KEY_Hangul_SsangDikeud instead.")
#define CLUTTER_Hangul_Rieul 0xea9 CLUTTER_DEPRECATED_MACRO_FOR("Deprecated key symbol. Use CLUTTER_KEY_Hangul_Rieul instead.")
#define CLUTTER_Hangul_RieulKiyeog 0xeaa CLUTTER_DEPRECATED_MACRO_FOR("Deprecated key symbol. Use CLUTTER_KEY_Hangul_RieulKiyeog instead.")
#define CLUTTER_Hangul_RieulMieum 0xeab CLUTTER_DEPRECATED_MACRO_FOR("Deprecated key symbol. Use CLUTTER_KEY_Hangul_RieulMieum instead.")
#define CLUTTER_Hangul_RieulPieub 0xeac CLUTTER_DEPRECATED_MACRO_FOR("Deprecated key symbol. Use CLUTTER_KEY_Hangul_RieulPieub instead.")
#define CLUTTER_Hangul_RieulSios 0xead CLUTTER_DEPRECATED_MACRO_FOR("Deprecated key symbol. Use CLUTTER_KEY_Hangul_RieulSios instead.")
#define CLUTTER_Hangul_RieulTieut 0xeae CLUTTER_DEPRECATED_MACRO_FOR("Deprecated key symbol. Use CLUTTER_KEY_Hangul_RieulTieut instead.")
#define CLUTTER_Hangul_RieulPhieuf 0xeaf CLUTTER_DEPRECATED_MACRO_FOR("Deprecated key symbol. Use CLUTTER_KEY_Hangul_RieulPhieuf instead.")
#define CLUTTER_Hangul_RieulHieuh 0xeb0 CLUTTER_DEPRECATED_MACRO_FOR("Deprecated key symbol. Use CLUTTER_KEY_Hangul_RieulHieuh instead.")
#define CLUTTER_Hangul_Mieum 0xeb1 CLUTTER_DEPRECATED_MACRO_FOR("Deprecated key symbol. Use CLUTTER_KEY_Hangul_Mieum instead.")
#define CLUTTER_Hangul_Pieub 0xeb2 CLUTTER_DEPRECATED_MACRO_FOR("Deprecated key symbol. Use CLUTTER_KEY_Hangul_Pieub instead.")
#define CLUTTER_Hangul_SsangPieub 0xeb3 CLUTTER_DEPRECATED_MACRO_FOR("Deprecated key symbol. Use CLUTTER_KEY_Hangul_SsangPieub instead.")
#define CLUTTER_Hangul_PieubSios 0xeb4 CLUTTER_DEPRECATED_MACRO_FOR("Deprecated key symbol. Use CLUTTER_KEY_Hangul_PieubSios instead.")
#define CLUTTER_Hangul_Sios 0xeb5 CLUTTER_DEPRECATED_MACRO_FOR("Deprecated key symbol. Use CLUTTER_KEY_Hangul_Sios instead.")
#define CLUTTER_Hangul_SsangSios 0xeb6 CLUTTER_DEPRECATED_MACRO_FOR("Deprecated key symbol. Use CLUTTER_KEY_Hangul_SsangSios instead.")
#define CLUTTER_Hangul_Ieung 0xeb7 CLUTTER_DEPRECATED_MACRO_FOR("Deprecated key symbol. Use CLUTTER_KEY_Hangul_Ieung instead.")
#define CLUTTER_Hangul_Jieuj 0xeb8 CLUTTER_DEPRECATED_MACRO_FOR("Deprecated key symbol. Use CLUTTER_KEY_Hangul_Jieuj instead.")
#define CLUTTER_Hangul_SsangJieuj 0xeb9 CLUTTER_DEPRECATED_MACRO_FOR("Deprecated key symbol. Use CLUTTER_KEY_Hangul_SsangJieuj instead.")
#define CLUTTER_Hangul_Cieuc 0xeba CLUTTER_DEPRECATED_MACRO_FOR("Deprecated key symbol. Use CLUTTER_KEY_Hangul_Cieuc instead.")
#define CLUTTER_Hangul_Khieuq 0xebb CLUTTER_DEPRECATED_MACRO_FOR("Deprecated key symbol. Use CLUTTER_KEY_Hangul_Khieuq instead.")
#define CLUTTER_Hangul_Tieut 0xebc CLUTTER_DEPRECATED_MACRO_FOR("Deprecated key symbol. Use CLUTTER_KEY_Hangul_Tieut instead.")
#define CLUTTER_Hangul_Phieuf 0xebd CLUTTER_DEPRECATED_MACRO_FOR("Deprecated key symbol. Use CLUTTER_KEY_Hangul_Phieuf instead.")
#define CLUTTER_Hangul_Hieuh 0xebe CLUTTER_DEPRECATED_MACRO_FOR("Deprecated key symbol. Use CLUTTER_KEY_Hangul_Hieuh instead.")
#define CLUTTER_Hangul_A 0xebf CLUTTER_DEPRECATED_MACRO_FOR("Deprecated key symbol. Use CLUTTER_KEY_Hangul_A instead.")
#define CLUTTER_Hangul_AE 0xec0 CLUTTER_DEPRECATED_MACRO_FOR("Deprecated key symbol. Use CLUTTER_KEY_Hangul_AE instead.")
#define CLUTTER_Hangul_YA 0xec1 CLUTTER_DEPRECATED_MACRO_FOR("Deprecated key symbol. Use CLUTTER_KEY_Hangul_YA instead.")
#define CLUTTER_Hangul_YAE 0xec2 CLUTTER_DEPRECATED_MACRO_FOR("Deprecated key symbol. Use CLUTTER_KEY_Hangul_YAE instead.")
#define CLUTTER_Hangul_EO 0xec3 CLUTTER_DEPRECATED_MACRO_FOR("Deprecated key symbol. Use CLUTTER_KEY_Hangul_EO instead.")
#define CLUTTER_Hangul_E 0xec4 CLUTTER_DEPRECATED_MACRO_FOR("Deprecated key symbol. Use CLUTTER_KEY_Hangul_E instead.")
#define CLUTTER_Hangul_YEO 0xec5 CLUTTER_DEPRECATED_MACRO_FOR("Deprecated key symbol. Use CLUTTER_KEY_Hangul_YEO instead.")
#define CLUTTER_Hangul_YE 0xec6 CLUTTER_DEPRECATED_MACRO_FOR("Deprecated key symbol. Use CLUTTER_KEY_Hangul_YE instead.")
#define CLUTTER_Hangul_O 0xec7 CLUTTER_DEPRECATED_MACRO_FOR("Deprecated key symbol. Use CLUTTER_KEY_Hangul_O instead.")
#define CLUTTER_Hangul_WA 0xec8 CLUTTER_DEPRECATED_MACRO_FOR("Deprecated key symbol. Use CLUTTER_KEY_Hangul_WA instead.")
#define CLUTTER_Hangul_WAE 0xec9 CLUTTER_DEPRECATED_MACRO_FOR("Deprecated key symbol. Use CLUTTER_KEY_Hangul_WAE instead.")
#define CLUTTER_Hangul_OE 0xeca CLUTTER_DEPRECATED_MACRO_FOR("Deprecated key symbol. Use CLUTTER_KEY_Hangul_OE instead.")
#define CLUTTER_Hangul_YO 0xecb CLUTTER_DEPRECATED_MACRO_FOR("Deprecated key symbol. Use CLUTTER_KEY_Hangul_YO instead.")
#define CLUTTER_Hangul_U 0xecc CLUTTER_DEPRECATED_MACRO_FOR("Deprecated key symbol. Use CLUTTER_KEY_Hangul_U instead.")
#define CLUTTER_Hangul_WEO 0xecd CLUTTER_DEPRECATED_MACRO_FOR("Deprecated key symbol. Use CLUTTER_KEY_Hangul_WEO instead.")
#define CLUTTER_Hangul_WE 0xece CLUTTER_DEPRECATED_MACRO_FOR("Deprecated key symbol. Use CLUTTER_KEY_Hangul_WE instead.")
#define CLUTTER_Hangul_WI 0xecf CLUTTER_DEPRECATED_MACRO_FOR("Deprecated key symbol. Use CLUTTER_KEY_Hangul_WI instead.")
#define CLUTTER_Hangul_YU 0xed0 CLUTTER_DEPRECATED_MACRO_FOR("Deprecated key symbol. Use CLUTTER_KEY_Hangul_YU instead.")
#define CLUTTER_Hangul_EU 0xed1 CLUTTER_DEPRECATED_MACRO_FOR("Deprecated key symbol. Use CLUTTER_KEY_Hangul_EU instead.")
#define CLUTTER_Hangul_YI 0xed2 CLUTTER_DEPRECATED_MACRO_FOR("Deprecated key symbol. Use CLUTTER_KEY_Hangul_YI instead.")
#define CLUTTER_Hangul_I 0xed3 CLUTTER_DEPRECATED_MACRO_FOR("Deprecated key symbol. Use CLUTTER_KEY_Hangul_I instead.")
#define CLUTTER_Hangul_J_Kiyeog 0xed4 CLUTTER_DEPRECATED_MACRO_FOR("Deprecated key symbol. Use CLUTTER_KEY_Hangul_J_Kiyeog instead.")
#define CLUTTER_Hangul_J_SsangKiyeog 0xed5 CLUTTER_DEPRECATED_MACRO_FOR("Deprecated key symbol. Use CLUTTER_KEY_Hangul_J_SsangKiyeog instead.")
#define CLUTTER_Hangul_J_KiyeogSios 0xed6 CLUTTER_DEPRECATED_MACRO_FOR("Deprecated key symbol. Use CLUTTER_KEY_Hangul_J_KiyeogSios instead.")
#define CLUTTER_Hangul_J_Nieun 0xed7 CLUTTER_DEPRECATED_MACRO_FOR("Deprecated key symbol. Use CLUTTER_KEY_Hangul_J_Nieun instead.")
#define CLUTTER_Hangul_J_NieunJieuj 0xed8 CLUTTER_DEPRECATED_MACRO_FOR("Deprecated key symbol. Use CLUTTER_KEY_Hangul_J_NieunJieuj instead.")
#define CLUTTER_Hangul_J_NieunHieuh 0xed9 CLUTTER_DEPRECATED_MACRO_FOR("Deprecated key symbol. Use CLUTTER_KEY_Hangul_J_NieunHieuh instead.")
#define CLUTTER_Hangul_J_Dikeud 0xeda CLUTTER_DEPRECATED_MACRO_FOR("Deprecated key symbol. Use CLUTTER_KEY_Hangul_J_Dikeud instead.")
#define CLUTTER_Hangul_J_Rieul 0xedb CLUTTER_DEPRECATED_MACRO_FOR("Deprecated key symbol. Use CLUTTER_KEY_Hangul_J_Rieul instead.")
#define CLUTTER_Hangul_J_RieulKiyeog 0xedc CLUTTER_DEPRECATED_MACRO_FOR("Deprecated key symbol. Use CLUTTER_KEY_Hangul_J_RieulKiyeog instead.")
#define CLUTTER_Hangul_J_RieulMieum 0xedd CLUTTER_DEPRECATED_MACRO_FOR("Deprecated key symbol. Use CLUTTER_KEY_Hangul_J_RieulMieum instead.")
#define CLUTTER_Hangul_J_RieulPieub 0xede CLUTTER_DEPRECATED_MACRO_FOR("Deprecated key symbol. Use CLUTTER_KEY_Hangul_J_RieulPieub instead.")
#define CLUTTER_Hangul_J_RieulSios 0xedf CLUTTER_DEPRECATED_MACRO_FOR("Deprecated key symbol. Use CLUTTER_KEY_Hangul_J_RieulSios instead.")
#define CLUTTER_Hangul_J_RieulTieut 0xee0 CLUTTER_DEPRECATED_MACRO_FOR("Deprecated key symbol. Use CLUTTER_KEY_Hangul_J_RieulTieut instead.")
#define CLUTTER_Hangul_J_RieulPhieuf 0xee1 CLUTTER_DEPRECATED_MACRO_FOR("Deprecated key symbol. Use CLUTTER_KEY_Hangul_J_RieulPhieuf instead.")
#define CLUTTER_Hangul_J_RieulHieuh 0xee2 CLUTTER_DEPRECATED_MACRO_FOR("Deprecated key symbol. Use CLUTTER_KEY_Hangul_J_RieulHieuh instead.")
#define CLUTTER_Hangul_J_Mieum 0xee3 CLUTTER_DEPRECATED_MACRO_FOR("Deprecated key symbol. Use CLUTTER_KEY_Hangul_J_Mieum instead.")
#define CLUTTER_Hangul_J_Pieub 0xee4 CLUTTER_DEPRECATED_MACRO_FOR("Deprecated key symbol. Use CLUTTER_KEY_Hangul_J_Pieub instead.")
#define CLUTTER_Hangul_J_PieubSios 0xee5 CLUTTER_DEPRECATED_MACRO_FOR("Deprecated key symbol. Use CLUTTER_KEY_Hangul_J_PieubSios instead.")
#define CLUTTER_Hangul_J_Sios 0xee6 CLUTTER_DEPRECATED_MACRO_FOR("Deprecated key symbol. Use CLUTTER_KEY_Hangul_J_Sios instead.")
#define CLUTTER_Hangul_J_SsangSios 0xee7 CLUTTER_DEPRECATED_MACRO_FOR("Deprecated key symbol. Use CLUTTER_KEY_Hangul_J_SsangSios instead.")
#define CLUTTER_Hangul_J_Ieung 0xee8 CLUTTER_DEPRECATED_MACRO_FOR("Deprecated key symbol. Use CLUTTER_KEY_Hangul_J_Ieung instead.")
#define CLUTTER_Hangul_J_Jieuj 0xee9 CLUTTER_DEPRECATED_MACRO_FOR("Deprecated key symbol. Use CLUTTER_KEY_Hangul_J_Jieuj instead.")
#define CLUTTER_Hangul_J_Cieuc 0xeea CLUTTER_DEPRECATED_MACRO_FOR("Deprecated key symbol. Use CLUTTER_KEY_Hangul_J_Cieuc instead.")
#define CLUTTER_Hangul_J_Khieuq 0xeeb CLUTTER_DEPRECATED_MACRO_FOR("Deprecated key symbol. Use CLUTTER_KEY_Hangul_J_Khieuq instead.")
#define CLUTTER_Hangul_J_Tieut 0xeec CLUTTER_DEPRECATED_MACRO_FOR("Deprecated key symbol. Use CLUTTER_KEY_Hangul_J_Tieut instead.")
#define CLUTTER_Hangul_J_Phieuf 0xeed CLUTTER_DEPRECATED_MACRO_FOR("Deprecated key symbol. Use CLUTTER_KEY_Hangul_J_Phieuf instead.")
#define CLUTTER_Hangul_J_Hieuh 0xeee CLUTTER_DEPRECATED_MACRO_FOR("Deprecated key symbol. Use CLUTTER_KEY_Hangul_J_Hieuh instead.")
#define CLUTTER_Hangul_RieulYeorinHieuh 0xeef CLUTTER_DEPRECATED_MACRO_FOR("Deprecated key symbol. Use CLUTTER_KEY_Hangul_RieulYeorinHieuh instead.")
#define CLUTTER_Hangul_SunkyeongeumMieum 0xef0 CLUTTER_DEPRECATED_MACRO_FOR("Deprecated key symbol. Use CLUTTER_KEY_Hangul_SunkyeongeumMieum instead.")
#define CLUTTER_Hangul_SunkyeongeumPieub 0xef1 CLUTTER_DEPRECATED_MACRO_FOR("Deprecated key symbol. Use CLUTTER_KEY_Hangul_SunkyeongeumPieub instead.")
#define CLUTTER_Hangul_PanSios 0xef2 CLUTTER_DEPRECATED_MACRO_FOR("Deprecated key symbol. Use CLUTTER_KEY_Hangul_PanSios instead.")
#define CLUTTER_Hangul_KkogjiDalrinIeung 0xef3 CLUTTER_DEPRECATED_MACRO_FOR("Deprecated key symbol. Use CLUTTER_KEY_Hangul_KkogjiDalrinIeung instead.")
#define CLUTTER_Hangul_SunkyeongeumPhieuf 0xef4 CLUTTER_DEPRECATED_MACRO_FOR("Deprecated key symbol. Use CLUTTER_KEY_Hangul_SunkyeongeumPhieuf instead.")
#define CLUTTER_Hangul_YeorinHieuh 0xef5 CLUTTER_DEPRECATED_MACRO_FOR("Deprecated key symbol. Use CLUTTER_KEY_Hangul_YeorinHieuh instead.")
#define CLUTTER_Hangul_AraeA 0xef6 CLUTTER_DEPRECATED_MACRO_FOR("Deprecated key symbol. Use CLUTTER_KEY_Hangul_AraeA instead.")
#define CLUTTER_Hangul_AraeAE 0xef7 CLUTTER_DEPRECATED_MACRO_FOR("Deprecated key symbol. Use CLUTTER_KEY_Hangul_AraeAE instead.")
#define CLUTTER_Hangul_J_PanSios 0xef8 CLUTTER_DEPRECATED_MACRO_FOR("Deprecated key symbol. Use CLUTTER_KEY_Hangul_J_PanSios instead.")
#define CLUTTER_Hangul_J_KkogjiDalrinIeung 0xef9 CLUTTER_DEPRECATED_MACRO_FOR("Deprecated key symbol. Use CLUTTER_KEY_Hangul_J_KkogjiDalrinIeung instead.")
#define CLUTTER_Hangul_J_YeorinHieuh 0xefa CLUTTER_DEPRECATED_MACRO_FOR("Deprecated key symbol. Use CLUTTER_KEY_Hangul_J_YeorinHieuh instead.")
#define CLUTTER_Korean_Won 0xeff CLUTTER_DEPRECATED_MACRO_FOR("Deprecated key symbol. Use CLUTTER_KEY_Korean_Won instead.")
#define CLUTTER_Armenian_ligature_ew 0x1000587 CLUTTER_DEPRECATED_MACRO_FOR("Deprecated key symbol. Use CLUTTER_KEY_Armenian_ligature_ew instead.")
#define CLUTTER_Armenian_full_stop 0x1000589 CLUTTER_DEPRECATED_MACRO_FOR("Deprecated key symbol. Use CLUTTER_KEY_Armenian_full_stop instead.")
#define CLUTTER_Armenian_verjaket 0x1000589 CLUTTER_DEPRECATED_MACRO_FOR("Deprecated key symbol. Use CLUTTER_KEY_Armenian_verjaket instead.")
#define CLUTTER_Armenian_separation_mark 0x100055d CLUTTER_DEPRECATED_MACRO_FOR("Deprecated key symbol. Use CLUTTER_KEY_Armenian_separation_mark instead.")
#define CLUTTER_Armenian_but 0x100055d CLUTTER_DEPRECATED_MACRO_FOR("Deprecated key symbol. Use CLUTTER_KEY_Armenian_but instead.")
#define CLUTTER_Armenian_hyphen 0x100058a CLUTTER_DEPRECATED_MACRO_FOR("Deprecated key symbol. Use CLUTTER_KEY_Armenian_hyphen instead.")
#define CLUTTER_Armenian_yentamna 0x100058a CLUTTER_DEPRECATED_MACRO_FOR("Deprecated key symbol. Use CLUTTER_KEY_Armenian_yentamna instead.")
#define CLUTTER_Armenian_exclam 0x100055c CLUTTER_DEPRECATED_MACRO_FOR("Deprecated key symbol. Use CLUTTER_KEY_Armenian_exclam instead.")
#define CLUTTER_Armenian_amanak 0x100055c CLUTTER_DEPRECATED_MACRO_FOR("Deprecated key symbol. Use CLUTTER_KEY_Armenian_amanak instead.")
#define CLUTTER_Armenian_accent 0x100055b CLUTTER_DEPRECATED_MACRO_FOR("Deprecated key symbol. Use CLUTTER_KEY_Armenian_accent instead.")
#define CLUTTER_Armenian_shesht 0x100055b CLUTTER_DEPRECATED_MACRO_FOR("Deprecated key symbol. Use CLUTTER_KEY_Armenian_shesht instead.")
#define CLUTTER_Armenian_question 0x100055e CLUTTER_DEPRECATED_MACRO_FOR("Deprecated key symbol. Use CLUTTER_KEY_Armenian_question instead.")
#define CLUTTER_Armenian_paruyk 0x100055e CLUTTER_DEPRECATED_MACRO_FOR("Deprecated key symbol. Use CLUTTER_KEY_Armenian_paruyk instead.")
#define CLUTTER_Armenian_AYB 0x1000531 CLUTTER_DEPRECATED_MACRO_FOR("Deprecated key symbol. Use CLUTTER_KEY_Armenian_AYB instead.")
#define CLUTTER_Armenian_ayb 0x1000561 CLUTTER_DEPRECATED_MACRO_FOR("Deprecated key symbol. Use CLUTTER_KEY_Armenian_ayb instead.")
#define CLUTTER_Armenian_BEN 0x1000532 CLUTTER_DEPRECATED_MACRO_FOR("Deprecated key symbol. Use CLUTTER_KEY_Armenian_BEN instead.")
#define CLUTTER_Armenian_ben 0x1000562 CLUTTER_DEPRECATED_MACRO_FOR("Deprecated key symbol. Use CLUTTER_KEY_Armenian_ben instead.")
#define CLUTTER_Armenian_GIM 0x1000533 CLUTTER_DEPRECATED_MACRO_FOR("Deprecated key symbol. Use CLUTTER_KEY_Armenian_GIM instead.")
#define CLUTTER_Armenian_gim 0x1000563 CLUTTER_DEPRECATED_MACRO_FOR("Deprecated key symbol. Use CLUTTER_KEY_Armenian_gim instead.")
#define CLUTTER_Armenian_DA 0x1000534 CLUTTER_DEPRECATED_MACRO_FOR("Deprecated key symbol. Use CLUTTER_KEY_Armenian_DA instead.")
#define CLUTTER_Armenian_da 0x1000564 CLUTTER_DEPRECATED_MACRO_FOR("Deprecated key symbol. Use CLUTTER_KEY_Armenian_da instead.")
#define CLUTTER_Armenian_YECH 0x1000535 CLUTTER_DEPRECATED_MACRO_FOR("Deprecated key symbol. Use CLUTTER_KEY_Armenian_YECH instead.")
#define CLUTTER_Armenian_yech 0x1000565 CLUTTER_DEPRECATED_MACRO_FOR("Deprecated key symbol. Use CLUTTER_KEY_Armenian_yech instead.")
#define CLUTTER_Armenian_ZA 0x1000536 CLUTTER_DEPRECATED_MACRO_FOR("Deprecated key symbol. Use CLUTTER_KEY_Armenian_ZA instead.")
#define CLUTTER_Armenian_za 0x1000566 CLUTTER_DEPRECATED_MACRO_FOR("Deprecated key symbol. Use CLUTTER_KEY_Armenian_za instead.")
#define CLUTTER_Armenian_E 0x1000537 CLUTTER_DEPRECATED_MACRO_FOR("Deprecated key symbol. Use CLUTTER_KEY_Armenian_E instead.")
#define CLUTTER_Armenian_e 0x1000567 CLUTTER_DEPRECATED_MACRO_FOR("Deprecated key symbol. Use CLUTTER_KEY_Armenian_e instead.")
#define CLUTTER_Armenian_AT 0x1000538 CLUTTER_DEPRECATED_MACRO_FOR("Deprecated key symbol. Use CLUTTER_KEY_Armenian_AT instead.")
#define CLUTTER_Armenian_at 0x1000568 CLUTTER_DEPRECATED_MACRO_FOR("Deprecated key symbol. Use CLUTTER_KEY_Armenian_at instead.")
#define CLUTTER_Armenian_TO 0x1000539 CLUTTER_DEPRECATED_MACRO_FOR("Deprecated key symbol. Use CLUTTER_KEY_Armenian_TO instead.")
#define CLUTTER_Armenian_to 0x1000569 CLUTTER_DEPRECATED_MACRO_FOR("Deprecated key symbol. Use CLUTTER_KEY_Armenian_to instead.")
#define CLUTTER_Armenian_ZHE 0x100053a CLUTTER_DEPRECATED_MACRO_FOR("Deprecated key symbol. Use CLUTTER_KEY_Armenian_ZHE instead.")
#define CLUTTER_Armenian_zhe 0x100056a CLUTTER_DEPRECATED_MACRO_FOR("Deprecated key symbol. Use CLUTTER_KEY_Armenian_zhe instead.")
#define CLUTTER_Armenian_INI 0x100053b CLUTTER_DEPRECATED_MACRO_FOR("Deprecated key symbol. Use CLUTTER_KEY_Armenian_INI instead.")
#define CLUTTER_Armenian_ini 0x100056b CLUTTER_DEPRECATED_MACRO_FOR("Deprecated key symbol. Use CLUTTER_KEY_Armenian_ini instead.")
#define CLUTTER_Armenian_LYUN 0x100053c CLUTTER_DEPRECATED_MACRO_FOR("Deprecated key symbol. Use CLUTTER_KEY_Armenian_LYUN instead.")
#define CLUTTER_Armenian_lyun 0x100056c CLUTTER_DEPRECATED_MACRO_FOR("Deprecated key symbol. Use CLUTTER_KEY_Armenian_lyun instead.")
#define CLUTTER_Armenian_KHE 0x100053d CLUTTER_DEPRECATED_MACRO_FOR("Deprecated key symbol. Use CLUTTER_KEY_Armenian_KHE instead.")
#define CLUTTER_Armenian_khe 0x100056d CLUTTER_DEPRECATED_MACRO_FOR("Deprecated key symbol. Use CLUTTER_KEY_Armenian_khe instead.")
#define CLUTTER_Armenian_TSA 0x100053e CLUTTER_DEPRECATED_MACRO_FOR("Deprecated key symbol. Use CLUTTER_KEY_Armenian_TSA instead.")
#define CLUTTER_Armenian_tsa 0x100056e CLUTTER_DEPRECATED_MACRO_FOR("Deprecated key symbol. Use CLUTTER_KEY_Armenian_tsa instead.")
#define CLUTTER_Armenian_KEN 0x100053f CLUTTER_DEPRECATED_MACRO_FOR("Deprecated key symbol. Use CLUTTER_KEY_Armenian_KEN instead.")
#define CLUTTER_Armenian_ken 0x100056f CLUTTER_DEPRECATED_MACRO_FOR("Deprecated key symbol. Use CLUTTER_KEY_Armenian_ken instead.")
#define CLUTTER_Armenian_HO 0x1000540 CLUTTER_DEPRECATED_MACRO_FOR("Deprecated key symbol. Use CLUTTER_KEY_Armenian_HO instead.")
#define CLUTTER_Armenian_ho 0x1000570 CLUTTER_DEPRECATED_MACRO_FOR("Deprecated key symbol. Use CLUTTER_KEY_Armenian_ho instead.")
#define CLUTTER_Armenian_DZA 0x1000541 CLUTTER_DEPRECATED_MACRO_FOR("Deprecated key symbol. Use CLUTTER_KEY_Armenian_DZA instead.")
#define CLUTTER_Armenian_dza 0x1000571 CLUTTER_DEPRECATED_MACRO_FOR("Deprecated key symbol. Use CLUTTER_KEY_Armenian_dza instead.")
#define CLUTTER_Armenian_GHAT 0x1000542 CLUTTER_DEPRECATED_MACRO_FOR("Deprecated key symbol. Use CLUTTER_KEY_Armenian_GHAT instead.")
#define CLUTTER_Armenian_ghat 0x1000572 CLUTTER_DEPRECATED_MACRO_FOR("Deprecated key symbol. Use CLUTTER_KEY_Armenian_ghat instead.")
#define CLUTTER_Armenian_TCHE 0x1000543 CLUTTER_DEPRECATED_MACRO_FOR("Deprecated key symbol. Use CLUTTER_KEY_Armenian_TCHE instead.")
#define CLUTTER_Armenian_tche 0x1000573 CLUTTER_DEPRECATED_MACRO_FOR("Deprecated key symbol. Use CLUTTER_KEY_Armenian_tche instead.")
#define CLUTTER_Armenian_MEN 0x1000544 CLUTTER_DEPRECATED_MACRO_FOR("Deprecated key symbol. Use CLUTTER_KEY_Armenian_MEN instead.")
#define CLUTTER_Armenian_men 0x1000574 CLUTTER_DEPRECATED_MACRO_FOR("Deprecated key symbol. Use CLUTTER_KEY_Armenian_men instead.")
#define CLUTTER_Armenian_HI 0x1000545 CLUTTER_DEPRECATED_MACRO_FOR("Deprecated key symbol. Use CLUTTER_KEY_Armenian_HI instead.")
#define CLUTTER_Armenian_hi 0x1000575 CLUTTER_DEPRECATED_MACRO_FOR("Deprecated key symbol. Use CLUTTER_KEY_Armenian_hi instead.")
#define CLUTTER_Armenian_NU 0x1000546 CLUTTER_DEPRECATED_MACRO_FOR("Deprecated key symbol. Use CLUTTER_KEY_Armenian_NU instead.")
#define CLUTTER_Armenian_nu 0x1000576 CLUTTER_DEPRECATED_MACRO_FOR("Deprecated key symbol. Use CLUTTER_KEY_Armenian_nu instead.")
#define CLUTTER_Armenian_SHA 0x1000547 CLUTTER_DEPRECATED_MACRO_FOR("Deprecated key symbol. Use CLUTTER_KEY_Armenian_SHA instead.")
#define CLUTTER_Armenian_sha 0x1000577 CLUTTER_DEPRECATED_MACRO_FOR("Deprecated key symbol. Use CLUTTER_KEY_Armenian_sha instead.")
#define CLUTTER_Armenian_VO 0x1000548 CLUTTER_DEPRECATED_MACRO_FOR("Deprecated key symbol. Use CLUTTER_KEY_Armenian_VO instead.")
#define CLUTTER_Armenian_vo 0x1000578 CLUTTER_DEPRECATED_MACRO_FOR("Deprecated key symbol. Use CLUTTER_KEY_Armenian_vo instead.")
#define CLUTTER_Armenian_CHA 0x1000549 CLUTTER_DEPRECATED_MACRO_FOR("Deprecated key symbol. Use CLUTTER_KEY_Armenian_CHA instead.")
#define CLUTTER_Armenian_cha 0x1000579 CLUTTER_DEPRECATED_MACRO_FOR("Deprecated key symbol. Use CLUTTER_KEY_Armenian_cha instead.")
#define CLUTTER_Armenian_PE 0x100054a CLUTTER_DEPRECATED_MACRO_FOR("Deprecated key symbol. Use CLUTTER_KEY_Armenian_PE instead.")
#define CLUTTER_Armenian_pe 0x100057a CLUTTER_DEPRECATED_MACRO_FOR("Deprecated key symbol. Use CLUTTER_KEY_Armenian_pe instead.")
#define CLUTTER_Armenian_JE 0x100054b CLUTTER_DEPRECATED_MACRO_FOR("Deprecated key symbol. Use CLUTTER_KEY_Armenian_JE instead.")
#define CLUTTER_Armenian_je 0x100057b CLUTTER_DEPRECATED_MACRO_FOR("Deprecated key symbol. Use CLUTTER_KEY_Armenian_je instead.")
#define CLUTTER_Armenian_RA 0x100054c CLUTTER_DEPRECATED_MACRO_FOR("Deprecated key symbol. Use CLUTTER_KEY_Armenian_RA instead.")
#define CLUTTER_Armenian_ra 0x100057c CLUTTER_DEPRECATED_MACRO_FOR("Deprecated key symbol. Use CLUTTER_KEY_Armenian_ra instead.")
#define CLUTTER_Armenian_SE 0x100054d CLUTTER_DEPRECATED_MACRO_FOR("Deprecated key symbol. Use CLUTTER_KEY_Armenian_SE instead.")
#define CLUTTER_Armenian_se 0x100057d CLUTTER_DEPRECATED_MACRO_FOR("Deprecated key symbol. Use CLUTTER_KEY_Armenian_se instead.")
#define CLUTTER_Armenian_VEV 0x100054e CLUTTER_DEPRECATED_MACRO_FOR("Deprecated key symbol. Use CLUTTER_KEY_Armenian_VEV instead.")
#define CLUTTER_Armenian_vev 0x100057e CLUTTER_DEPRECATED_MACRO_FOR("Deprecated key symbol. Use CLUTTER_KEY_Armenian_vev instead.")
#define CLUTTER_Armenian_TYUN 0x100054f CLUTTER_DEPRECATED_MACRO_FOR("Deprecated key symbol. Use CLUTTER_KEY_Armenian_TYUN instead.")
#define CLUTTER_Armenian_tyun 0x100057f CLUTTER_DEPRECATED_MACRO_FOR("Deprecated key symbol. Use CLUTTER_KEY_Armenian_tyun instead.")
#define CLUTTER_Armenian_RE 0x1000550 CLUTTER_DEPRECATED_MACRO_FOR("Deprecated key symbol. Use CLUTTER_KEY_Armenian_RE instead.")
#define CLUTTER_Armenian_re 0x1000580 CLUTTER_DEPRECATED_MACRO_FOR("Deprecated key symbol. Use CLUTTER_KEY_Armenian_re instead.")
#define CLUTTER_Armenian_TSO 0x1000551 CLUTTER_DEPRECATED_MACRO_FOR("Deprecated key symbol. Use CLUTTER_KEY_Armenian_TSO instead.")
#define CLUTTER_Armenian_tso 0x1000581 CLUTTER_DEPRECATED_MACRO_FOR("Deprecated key symbol. Use CLUTTER_KEY_Armenian_tso instead.")
#define CLUTTER_Armenian_VYUN 0x1000552 CLUTTER_DEPRECATED_MACRO_FOR("Deprecated key symbol. Use CLUTTER_KEY_Armenian_VYUN instead.")
#define CLUTTER_Armenian_vyun 0x1000582 CLUTTER_DEPRECATED_MACRO_FOR("Deprecated key symbol. Use CLUTTER_KEY_Armenian_vyun instead.")
#define CLUTTER_Armenian_PYUR 0x1000553 CLUTTER_DEPRECATED_MACRO_FOR("Deprecated key symbol. Use CLUTTER_KEY_Armenian_PYUR instead.")
#define CLUTTER_Armenian_pyur 0x1000583 CLUTTER_DEPRECATED_MACRO_FOR("Deprecated key symbol. Use CLUTTER_KEY_Armenian_pyur instead.")
#define CLUTTER_Armenian_KE 0x1000554 CLUTTER_DEPRECATED_MACRO_FOR("Deprecated key symbol. Use CLUTTER_KEY_Armenian_KE instead.")
#define CLUTTER_Armenian_ke 0x1000584 CLUTTER_DEPRECATED_MACRO_FOR("Deprecated key symbol. Use CLUTTER_KEY_Armenian_ke instead.")
#define CLUTTER_Armenian_O 0x1000555 CLUTTER_DEPRECATED_MACRO_FOR("Deprecated key symbol. Use CLUTTER_KEY_Armenian_O instead.")
#define CLUTTER_Armenian_o 0x1000585 CLUTTER_DEPRECATED_MACRO_FOR("Deprecated key symbol. Use CLUTTER_KEY_Armenian_o instead.")
#define CLUTTER_Armenian_FE 0x1000556 CLUTTER_DEPRECATED_MACRO_FOR("Deprecated key symbol. Use CLUTTER_KEY_Armenian_FE instead.")
#define CLUTTER_Armenian_fe 0x1000586 CLUTTER_DEPRECATED_MACRO_FOR("Deprecated key symbol. Use CLUTTER_KEY_Armenian_fe instead.")
#define CLUTTER_Armenian_apostrophe 0x100055a CLUTTER_DEPRECATED_MACRO_FOR("Deprecated key symbol. Use CLUTTER_KEY_Armenian_apostrophe instead.")
#define CLUTTER_Georgian_an 0x10010d0 CLUTTER_DEPRECATED_MACRO_FOR("Deprecated key symbol. Use CLUTTER_KEY_Georgian_an instead.")
#define CLUTTER_Georgian_ban 0x10010d1 CLUTTER_DEPRECATED_MACRO_FOR("Deprecated key symbol. Use CLUTTER_KEY_Georgian_ban instead.")
#define CLUTTER_Georgian_gan 0x10010d2 CLUTTER_DEPRECATED_MACRO_FOR("Deprecated key symbol. Use CLUTTER_KEY_Georgian_gan instead.")
#define CLUTTER_Georgian_don 0x10010d3 CLUTTER_DEPRECATED_MACRO_FOR("Deprecated key symbol. Use CLUTTER_KEY_Georgian_don instead.")
#define CLUTTER_Georgian_en 0x10010d4 CLUTTER_DEPRECATED_MACRO_FOR("Deprecated key symbol. Use CLUTTER_KEY_Georgian_en instead.")
#define CLUTTER_Georgian_vin 0x10010d5 CLUTTER_DEPRECATED_MACRO_FOR("Deprecated key symbol. Use CLUTTER_KEY_Georgian_vin instead.")
#define CLUTTER_Georgian_zen 0x10010d6 CLUTTER_DEPRECATED_MACRO_FOR("Deprecated key symbol. Use CLUTTER_KEY_Georgian_zen instead.")
#define CLUTTER_Georgian_tan 0x10010d7 CLUTTER_DEPRECATED_MACRO_FOR("Deprecated key symbol. Use CLUTTER_KEY_Georgian_tan instead.")
#define CLUTTER_Georgian_in 0x10010d8 CLUTTER_DEPRECATED_MACRO_FOR("Deprecated key symbol. Use CLUTTER_KEY_Georgian_in instead.")
#define CLUTTER_Georgian_kan 0x10010d9 CLUTTER_DEPRECATED_MACRO_FOR("Deprecated key symbol. Use CLUTTER_KEY_Georgian_kan instead.")
#define CLUTTER_Georgian_las 0x10010da CLUTTER_DEPRECATED_MACRO_FOR("Deprecated key symbol. Use CLUTTER_KEY_Georgian_las instead.")
#define CLUTTER_Georgian_man 0x10010db CLUTTER_DEPRECATED_MACRO_FOR("Deprecated key symbol. Use CLUTTER_KEY_Georgian_man instead.")
#define CLUTTER_Georgian_nar 0x10010dc CLUTTER_DEPRECATED_MACRO_FOR("Deprecated key symbol. Use CLUTTER_KEY_Georgian_nar instead.")
#define CLUTTER_Georgian_on 0x10010dd CLUTTER_DEPRECATED_MACRO_FOR("Deprecated key symbol. Use CLUTTER_KEY_Georgian_on instead.")
#define CLUTTER_Georgian_par 0x10010de CLUTTER_DEPRECATED_MACRO_FOR("Deprecated key symbol. Use CLUTTER_KEY_Georgian_par instead.")
#define CLUTTER_Georgian_zhar 0x10010df CLUTTER_DEPRECATED_MACRO_FOR("Deprecated key symbol. Use CLUTTER_KEY_Georgian_zhar instead.")
#define CLUTTER_Georgian_rae 0x10010e0 CLUTTER_DEPRECATED_MACRO_FOR("Deprecated key symbol. Use CLUTTER_KEY_Georgian_rae instead.")
#define CLUTTER_Georgian_san 0x10010e1 CLUTTER_DEPRECATED_MACRO_FOR("Deprecated key symbol. Use CLUTTER_KEY_Georgian_san instead.")
#define CLUTTER_Georgian_tar 0x10010e2 CLUTTER_DEPRECATED_MACRO_FOR("Deprecated key symbol. Use CLUTTER_KEY_Georgian_tar instead.")
#define CLUTTER_Georgian_un 0x10010e3 CLUTTER_DEPRECATED_MACRO_FOR("Deprecated key symbol. Use CLUTTER_KEY_Georgian_un instead.")
#define CLUTTER_Georgian_phar 0x10010e4 CLUTTER_DEPRECATED_MACRO_FOR("Deprecated key symbol. Use CLUTTER_KEY_Georgian_phar instead.")
#define CLUTTER_Georgian_khar 0x10010e5 CLUTTER_DEPRECATED_MACRO_FOR("Deprecated key symbol. Use CLUTTER_KEY_Georgian_khar instead.")
#define CLUTTER_Georgian_ghan 0x10010e6 CLUTTER_DEPRECATED_MACRO_FOR("Deprecated key symbol. Use CLUTTER_KEY_Georgian_ghan instead.")
#define CLUTTER_Georgian_qar 0x10010e7 CLUTTER_DEPRECATED_MACRO_FOR("Deprecated key symbol. Use CLUTTER_KEY_Georgian_qar instead.")
#define CLUTTER_Georgian_shin 0x10010e8 CLUTTER_DEPRECATED_MACRO_FOR("Deprecated key symbol. Use CLUTTER_KEY_Georgian_shin instead.")
#define CLUTTER_Georgian_chin 0x10010e9 CLUTTER_DEPRECATED_MACRO_FOR("Deprecated key symbol. Use CLUTTER_KEY_Georgian_chin instead.")
#define CLUTTER_Georgian_can 0x10010ea CLUTTER_DEPRECATED_MACRO_FOR("Deprecated key symbol. Use CLUTTER_KEY_Georgian_can instead.")
#define CLUTTER_Georgian_jil 0x10010eb CLUTTER_DEPRECATED_MACRO_FOR("Deprecated key symbol. Use CLUTTER_KEY_Georgian_jil instead.")
#define CLUTTER_Georgian_cil 0x10010ec CLUTTER_DEPRECATED_MACRO_FOR("Deprecated key symbol. Use CLUTTER_KEY_Georgian_cil instead.")
#define CLUTTER_Georgian_char 0x10010ed CLUTTER_DEPRECATED_MACRO_FOR("Deprecated key symbol. Use CLUTTER_KEY_Georgian_char instead.")
#define CLUTTER_Georgian_xan 0x10010ee CLUTTER_DEPRECATED_MACRO_FOR("Deprecated key symbol. Use CLUTTER_KEY_Georgian_xan instead.")
#define CLUTTER_Georgian_jhan 0x10010ef CLUTTER_DEPRECATED_MACRO_FOR("Deprecated key symbol. Use CLUTTER_KEY_Georgian_jhan instead.")
#define CLUTTER_Georgian_hae 0x10010f0 CLUTTER_DEPRECATED_MACRO_FOR("Deprecated key symbol. Use CLUTTER_KEY_Georgian_hae instead.")
#define CLUTTER_Georgian_he 0x10010f1 CLUTTER_DEPRECATED_MACRO_FOR("Deprecated key symbol. Use CLUTTER_KEY_Georgian_he instead.")
#define CLUTTER_Georgian_hie 0x10010f2 CLUTTER_DEPRECATED_MACRO_FOR("Deprecated key symbol. Use CLUTTER_KEY_Georgian_hie instead.")
#define CLUTTER_Georgian_we 0x10010f3 CLUTTER_DEPRECATED_MACRO_FOR("Deprecated key symbol. Use CLUTTER_KEY_Georgian_we instead.")
#define CLUTTER_Georgian_har 0x10010f4 CLUTTER_DEPRECATED_MACRO_FOR("Deprecated key symbol. Use CLUTTER_KEY_Georgian_har instead.")
#define CLUTTER_Georgian_hoe 0x10010f5 CLUTTER_DEPRECATED_MACRO_FOR("Deprecated key symbol. Use CLUTTER_KEY_Georgian_hoe instead.")
#define CLUTTER_Georgian_fi 0x10010f6 CLUTTER_DEPRECATED_MACRO_FOR("Deprecated key symbol. Use CLUTTER_KEY_Georgian_fi instead.")
#define CLUTTER_Xabovedot 0x1001e8a CLUTTER_DEPRECATED_MACRO_FOR("Deprecated key symbol. Use CLUTTER_KEY_Xabovedot instead.")
#define CLUTTER_Ibreve 0x100012c CLUTTER_DEPRECATED_MACRO_FOR("Deprecated key symbol. Use CLUTTER_KEY_Ibreve instead.")
#define CLUTTER_Zstroke 0x10001b5 CLUTTER_DEPRECATED_MACRO_FOR("Deprecated key symbol. Use CLUTTER_KEY_Zstroke instead.")
#define CLUTTER_Gcaron 0x10001e6 CLUTTER_DEPRECATED_MACRO_FOR("Deprecated key symbol. Use CLUTTER_KEY_Gcaron instead.")
#define CLUTTER_Ocaron 0x10001d1 CLUTTER_DEPRECATED_MACRO_FOR("Deprecated key symbol. Use CLUTTER_KEY_Ocaron instead.")
#define CLUTTER_Obarred 0x100019f CLUTTER_DEPRECATED_MACRO_FOR("Deprecated key symbol. Use CLUTTER_KEY_Obarred instead.")
#define CLUTTER_xabovedot 0x1001e8b CLUTTER_DEPRECATED_MACRO_FOR("Deprecated key symbol. Use CLUTTER_KEY_xabovedot instead.")
#define CLUTTER_ibreve 0x100012d CLUTTER_DEPRECATED_MACRO_FOR("Deprecated key symbol. Use CLUTTER_KEY_ibreve instead.")
#define CLUTTER_zstroke 0x10001b6 CLUTTER_DEPRECATED_MACRO_FOR("Deprecated key symbol. Use CLUTTER_KEY_zstroke instead.")
#define CLUTTER_gcaron 0x10001e7 CLUTTER_DEPRECATED_MACRO_FOR("Deprecated key symbol. Use CLUTTER_KEY_gcaron instead.")
#define CLUTTER_ocaron 0x10001d2 CLUTTER_DEPRECATED_MACRO_FOR("Deprecated key symbol. Use CLUTTER_KEY_ocaron instead.")
#define CLUTTER_obarred 0x1000275 CLUTTER_DEPRECATED_MACRO_FOR("Deprecated key symbol. Use CLUTTER_KEY_obarred instead.")
#define CLUTTER_SCHWA 0x100018f CLUTTER_DEPRECATED_MACRO_FOR("Deprecated key symbol. Use CLUTTER_KEY_SCHWA instead.")
#define CLUTTER_schwa 0x1000259 CLUTTER_DEPRECATED_MACRO_FOR("Deprecated key symbol. Use CLUTTER_KEY_schwa instead.")
#define CLUTTER_EZH 0x10001b7 CLUTTER_DEPRECATED_MACRO_FOR("Deprecated key symbol. Use CLUTTER_KEY_EZH instead.")
#define CLUTTER_ezh 0x1000292 CLUTTER_DEPRECATED_MACRO_FOR("Deprecated key symbol. Use CLUTTER_KEY_ezh instead.")
#define CLUTTER_Lbelowdot 0x1001e36 CLUTTER_DEPRECATED_MACRO_FOR("Deprecated key symbol. Use CLUTTER_KEY_Lbelowdot instead.")
#define CLUTTER_lbelowdot 0x1001e37 CLUTTER_DEPRECATED_MACRO_FOR("Deprecated key symbol. Use CLUTTER_KEY_lbelowdot instead.")
#define CLUTTER_Abelowdot 0x1001ea0 CLUTTER_DEPRECATED_MACRO_FOR("Deprecated key symbol. Use CLUTTER_KEY_Abelowdot instead.")
#define CLUTTER_abelowdot 0x1001ea1 CLUTTER_DEPRECATED_MACRO_FOR("Deprecated key symbol. Use CLUTTER_KEY_abelowdot instead.")
#define CLUTTER_Ahook 0x1001ea2 CLUTTER_DEPRECATED_MACRO_FOR("Deprecated key symbol. Use CLUTTER_KEY_Ahook instead.")
#define CLUTTER_ahook 0x1001ea3 CLUTTER_DEPRECATED_MACRO_FOR("Deprecated key symbol. Use CLUTTER_KEY_ahook instead.")
#define CLUTTER_Acircumflexacute 0x1001ea4 CLUTTER_DEPRECATED_MACRO_FOR("Deprecated key symbol. Use CLUTTER_KEY_Acircumflexacute instead.")
#define CLUTTER_acircumflexacute 0x1001ea5 CLUTTER_DEPRECATED_MACRO_FOR("Deprecated key symbol. Use CLUTTER_KEY_acircumflexacute instead.")
#define CLUTTER_Acircumflexgrave 0x1001ea6 CLUTTER_DEPRECATED_MACRO_FOR("Deprecated key symbol. Use CLUTTER_KEY_Acircumflexgrave instead.")
#define CLUTTER_acircumflexgrave 0x1001ea7 CLUTTER_DEPRECATED_MACRO_FOR("Deprecated key symbol. Use CLUTTER_KEY_acircumflexgrave instead.")
#define CLUTTER_Acircumflexhook 0x1001ea8 CLUTTER_DEPRECATED_MACRO_FOR("Deprecated key symbol. Use CLUTTER_KEY_Acircumflexhook instead.")
#define CLUTTER_acircumflexhook 0x1001ea9 CLUTTER_DEPRECATED_MACRO_FOR("Deprecated key symbol. Use CLUTTER_KEY_acircumflexhook instead.")
#define CLUTTER_Acircumflextilde 0x1001eaa CLUTTER_DEPRECATED_MACRO_FOR("Deprecated key symbol. Use CLUTTER_KEY_Acircumflextilde instead.")
#define CLUTTER_acircumflextilde 0x1001eab CLUTTER_DEPRECATED_MACRO_FOR("Deprecated key symbol. Use CLUTTER_KEY_acircumflextilde instead.")
#define CLUTTER_Acircumflexbelowdot 0x1001eac CLUTTER_DEPRECATED_MACRO_FOR("Deprecated key symbol. Use CLUTTER_KEY_Acircumflexbelowdot instead.")
#define CLUTTER_acircumflexbelowdot 0x1001ead CLUTTER_DEPRECATED_MACRO_FOR("Deprecated key symbol. Use CLUTTER_KEY_acircumflexbelowdot instead.")
#define CLUTTER_Abreveacute 0x1001eae CLUTTER_DEPRECATED_MACRO_FOR("Deprecated key symbol. Use CLUTTER_KEY_Abreveacute instead.")
#define CLUTTER_abreveacute 0x1001eaf CLUTTER_DEPRECATED_MACRO_FOR("Deprecated key symbol. Use CLUTTER_KEY_abreveacute instead.")
#define CLUTTER_Abrevegrave 0x1001eb0 CLUTTER_DEPRECATED_MACRO_FOR("Deprecated key symbol. Use CLUTTER_KEY_Abrevegrave instead.")
#define CLUTTER_abrevegrave 0x1001eb1 CLUTTER_DEPRECATED_MACRO_FOR("Deprecated key symbol. Use CLUTTER_KEY_abrevegrave instead.")
#define CLUTTER_Abrevehook 0x1001eb2 CLUTTER_DEPRECATED_MACRO_FOR("Deprecated key symbol. Use CLUTTER_KEY_Abrevehook instead.")
#define CLUTTER_abrevehook 0x1001eb3 CLUTTER_DEPRECATED_MACRO_FOR("Deprecated key symbol. Use CLUTTER_KEY_abrevehook instead.")
#define CLUTTER_Abrevetilde 0x1001eb4 CLUTTER_DEPRECATED_MACRO_FOR("Deprecated key symbol. Use CLUTTER_KEY_Abrevetilde instead.")
#define CLUTTER_abrevetilde 0x1001eb5 CLUTTER_DEPRECATED_MACRO_FOR("Deprecated key symbol. Use CLUTTER_KEY_abrevetilde instead.")
#define CLUTTER_Abrevebelowdot 0x1001eb6 CLUTTER_DEPRECATED_MACRO_FOR("Deprecated key symbol. Use CLUTTER_KEY_Abrevebelowdot instead.")
#define CLUTTER_abrevebelowdot 0x1001eb7 CLUTTER_DEPRECATED_MACRO_FOR("Deprecated key symbol. Use CLUTTER_KEY_abrevebelowdot instead.")
#define CLUTTER_Ebelowdot 0x1001eb8 CLUTTER_DEPRECATED_MACRO_FOR("Deprecated key symbol. Use CLUTTER_KEY_Ebelowdot instead.")
#define CLUTTER_ebelowdot 0x1001eb9 CLUTTER_DEPRECATED_MACRO_FOR("Deprecated key symbol. Use CLUTTER_KEY_ebelowdot instead.")
#define CLUTTER_Ehook 0x1001eba CLUTTER_DEPRECATED_MACRO_FOR("Deprecated key symbol. Use CLUTTER_KEY_Ehook instead.")
#define CLUTTER_ehook 0x1001ebb CLUTTER_DEPRECATED_MACRO_FOR("Deprecated key symbol. Use CLUTTER_KEY_ehook instead.")
#define CLUTTER_Etilde 0x1001ebc CLUTTER_DEPRECATED_MACRO_FOR("Deprecated key symbol. Use CLUTTER_KEY_Etilde instead.")
#define CLUTTER_etilde 0x1001ebd CLUTTER_DEPRECATED_MACRO_FOR("Deprecated key symbol. Use CLUTTER_KEY_etilde instead.")
#define CLUTTER_Ecircumflexacute 0x1001ebe CLUTTER_DEPRECATED_MACRO_FOR("Deprecated key symbol. Use CLUTTER_KEY_Ecircumflexacute instead.")
#define CLUTTER_ecircumflexacute 0x1001ebf CLUTTER_DEPRECATED_MACRO_FOR("Deprecated key symbol. Use CLUTTER_KEY_ecircumflexacute instead.")
#define CLUTTER_Ecircumflexgrave 0x1001ec0 CLUTTER_DEPRECATED_MACRO_FOR("Deprecated key symbol. Use CLUTTER_KEY_Ecircumflexgrave instead.")
#define CLUTTER_ecircumflexgrave 0x1001ec1 CLUTTER_DEPRECATED_MACRO_FOR("Deprecated key symbol. Use CLUTTER_KEY_ecircumflexgrave instead.")
#define CLUTTER_Ecircumflexhook 0x1001ec2 CLUTTER_DEPRECATED_MACRO_FOR("Deprecated key symbol. Use CLUTTER_KEY_Ecircumflexhook instead.")
#define CLUTTER_ecircumflexhook 0x1001ec3 CLUTTER_DEPRECATED_MACRO_FOR("Deprecated key symbol. Use CLUTTER_KEY_ecircumflexhook instead.")
#define CLUTTER_Ecircumflextilde 0x1001ec4 CLUTTER_DEPRECATED_MACRO_FOR("Deprecated key symbol. Use CLUTTER_KEY_Ecircumflextilde instead.")
#define CLUTTER_ecircumflextilde 0x1001ec5 CLUTTER_DEPRECATED_MACRO_FOR("Deprecated key symbol. Use CLUTTER_KEY_ecircumflextilde instead.")
#define CLUTTER_Ecircumflexbelowdot 0x1001ec6 CLUTTER_DEPRECATED_MACRO_FOR("Deprecated key symbol. Use CLUTTER_KEY_Ecircumflexbelowdot instead.")
#define CLUTTER_ecircumflexbelowdot 0x1001ec7 CLUTTER_DEPRECATED_MACRO_FOR("Deprecated key symbol. Use CLUTTER_KEY_ecircumflexbelowdot instead.")
#define CLUTTER_Ihook 0x1001ec8 CLUTTER_DEPRECATED_MACRO_FOR("Deprecated key symbol. Use CLUTTER_KEY_Ihook instead.")
#define CLUTTER_ihook 0x1001ec9 CLUTTER_DEPRECATED_MACRO_FOR("Deprecated key symbol. Use CLUTTER_KEY_ihook instead.")
#define CLUTTER_Ibelowdot 0x1001eca CLUTTER_DEPRECATED_MACRO_FOR("Deprecated key symbol. Use CLUTTER_KEY_Ibelowdot instead.")
#define CLUTTER_ibelowdot 0x1001ecb CLUTTER_DEPRECATED_MACRO_FOR("Deprecated key symbol. Use CLUTTER_KEY_ibelowdot instead.")
#define CLUTTER_Obelowdot 0x1001ecc CLUTTER_DEPRECATED_MACRO_FOR("Deprecated key symbol. Use CLUTTER_KEY_Obelowdot instead.")
#define CLUTTER_obelowdot 0x1001ecd CLUTTER_DEPRECATED_MACRO_FOR("Deprecated key symbol. Use CLUTTER_KEY_obelowdot instead.")
#define CLUTTER_Ohook 0x1001ece CLUTTER_DEPRECATED_MACRO_FOR("Deprecated key symbol. Use CLUTTER_KEY_Ohook instead.")
#define CLUTTER_ohook 0x1001ecf CLUTTER_DEPRECATED_MACRO_FOR("Deprecated key symbol. Use CLUTTER_KEY_ohook instead.")
#define CLUTTER_Ocircumflexacute 0x1001ed0 CLUTTER_DEPRECATED_MACRO_FOR("Deprecated key symbol. Use CLUTTER_KEY_Ocircumflexacute instead.")
#define CLUTTER_ocircumflexacute 0x1001ed1 CLUTTER_DEPRECATED_MACRO_FOR("Deprecated key symbol. Use CLUTTER_KEY_ocircumflexacute instead.")
#define CLUTTER_Ocircumflexgrave 0x1001ed2 CLUTTER_DEPRECATED_MACRO_FOR("Deprecated key symbol. Use CLUTTER_KEY_Ocircumflexgrave instead.")
#define CLUTTER_ocircumflexgrave 0x1001ed3 CLUTTER_DEPRECATED_MACRO_FOR("Deprecated key symbol. Use CLUTTER_KEY_ocircumflexgrave instead.")
#define CLUTTER_Ocircumflexhook 0x1001ed4 CLUTTER_DEPRECATED_MACRO_FOR("Deprecated key symbol. Use CLUTTER_KEY_Ocircumflexhook instead.")
#define CLUTTER_ocircumflexhook 0x1001ed5 CLUTTER_DEPRECATED_MACRO_FOR("Deprecated key symbol. Use CLUTTER_KEY_ocircumflexhook instead.")
#define CLUTTER_Ocircumflextilde 0x1001ed6 CLUTTER_DEPRECATED_MACRO_FOR("Deprecated key symbol. Use CLUTTER_KEY_Ocircumflextilde instead.")
#define CLUTTER_ocircumflextilde 0x1001ed7 CLUTTER_DEPRECATED_MACRO_FOR("Deprecated key symbol. Use CLUTTER_KEY_ocircumflextilde instead.")
#define CLUTTER_Ocircumflexbelowdot 0x1001ed8 CLUTTER_DEPRECATED_MACRO_FOR("Deprecated key symbol. Use CLUTTER_KEY_Ocircumflexbelowdot instead.")
#define CLUTTER_ocircumflexbelowdot 0x1001ed9 CLUTTER_DEPRECATED_MACRO_FOR("Deprecated key symbol. Use CLUTTER_KEY_ocircumflexbelowdot instead.")
#define CLUTTER_Ohornacute 0x1001eda CLUTTER_DEPRECATED_MACRO_FOR("Deprecated key symbol. Use CLUTTER_KEY_Ohornacute instead.")
#define CLUTTER_ohornacute 0x1001edb CLUTTER_DEPRECATED_MACRO_FOR("Deprecated key symbol. Use CLUTTER_KEY_ohornacute instead.")
#define CLUTTER_Ohorngrave 0x1001edc CLUTTER_DEPRECATED_MACRO_FOR("Deprecated key symbol. Use CLUTTER_KEY_Ohorngrave instead.")
#define CLUTTER_ohorngrave 0x1001edd CLUTTER_DEPRECATED_MACRO_FOR("Deprecated key symbol. Use CLUTTER_KEY_ohorngrave instead.")
#define CLUTTER_Ohornhook 0x1001ede CLUTTER_DEPRECATED_MACRO_FOR("Deprecated key symbol. Use CLUTTER_KEY_Ohornhook instead.")
#define CLUTTER_ohornhook 0x1001edf CLUTTER_DEPRECATED_MACRO_FOR("Deprecated key symbol. Use CLUTTER_KEY_ohornhook instead.")
#define CLUTTER_Ohorntilde 0x1001ee0 CLUTTER_DEPRECATED_MACRO_FOR("Deprecated key symbol. Use CLUTTER_KEY_Ohorntilde instead.")
#define CLUTTER_ohorntilde 0x1001ee1 CLUTTER_DEPRECATED_MACRO_FOR("Deprecated key symbol. Use CLUTTER_KEY_ohorntilde instead.")
#define CLUTTER_Ohornbelowdot 0x1001ee2 CLUTTER_DEPRECATED_MACRO_FOR("Deprecated key symbol. Use CLUTTER_KEY_Ohornbelowdot instead.")
#define CLUTTER_ohornbelowdot 0x1001ee3 CLUTTER_DEPRECATED_MACRO_FOR("Deprecated key symbol. Use CLUTTER_KEY_ohornbelowdot instead.")
#define CLUTTER_Ubelowdot 0x1001ee4 CLUTTER_DEPRECATED_MACRO_FOR("Deprecated key symbol. Use CLUTTER_KEY_Ubelowdot instead.")
#define CLUTTER_ubelowdot 0x1001ee5 CLUTTER_DEPRECATED_MACRO_FOR("Deprecated key symbol. Use CLUTTER_KEY_ubelowdot instead.")
#define CLUTTER_Uhook 0x1001ee6 CLUTTER_DEPRECATED_MACRO_FOR("Deprecated key symbol. Use CLUTTER_KEY_Uhook instead.")
#define CLUTTER_uhook 0x1001ee7 CLUTTER_DEPRECATED_MACRO_FOR("Deprecated key symbol. Use CLUTTER_KEY_uhook instead.")
#define CLUTTER_Uhornacute 0x1001ee8 CLUTTER_DEPRECATED_MACRO_FOR("Deprecated key symbol. Use CLUTTER_KEY_Uhornacute instead.")
#define CLUTTER_uhornacute 0x1001ee9 CLUTTER_DEPRECATED_MACRO_FOR("Deprecated key symbol. Use CLUTTER_KEY_uhornacute instead.")
#define CLUTTER_Uhorngrave 0x1001eea CLUTTER_DEPRECATED_MACRO_FOR("Deprecated key symbol. Use CLUTTER_KEY_Uhorngrave instead.")
#define CLUTTER_uhorngrave 0x1001eeb CLUTTER_DEPRECATED_MACRO_FOR("Deprecated key symbol. Use CLUTTER_KEY_uhorngrave instead.")
#define CLUTTER_Uhornhook 0x1001eec CLUTTER_DEPRECATED_MACRO_FOR("Deprecated key symbol. Use CLUTTER_KEY_Uhornhook instead.")
#define CLUTTER_uhornhook 0x1001eed CLUTTER_DEPRECATED_MACRO_FOR("Deprecated key symbol. Use CLUTTER_KEY_uhornhook instead.")
#define CLUTTER_Uhorntilde 0x1001eee CLUTTER_DEPRECATED_MACRO_FOR("Deprecated key symbol. Use CLUTTER_KEY_Uhorntilde instead.")
#define CLUTTER_uhorntilde 0x1001eef CLUTTER_DEPRECATED_MACRO_FOR("Deprecated key symbol. Use CLUTTER_KEY_uhorntilde instead.")
#define CLUTTER_Uhornbelowdot 0x1001ef0 CLUTTER_DEPRECATED_MACRO_FOR("Deprecated key symbol. Use CLUTTER_KEY_Uhornbelowdot instead.")
#define CLUTTER_uhornbelowdot 0x1001ef1 CLUTTER_DEPRECATED_MACRO_FOR("Deprecated key symbol. Use CLUTTER_KEY_uhornbelowdot instead.")
#define CLUTTER_Ybelowdot 0x1001ef4 CLUTTER_DEPRECATED_MACRO_FOR("Deprecated key symbol. Use CLUTTER_KEY_Ybelowdot instead.")
#define CLUTTER_ybelowdot 0x1001ef5 CLUTTER_DEPRECATED_MACRO_FOR("Deprecated key symbol. Use CLUTTER_KEY_ybelowdot instead.")
#define CLUTTER_Yhook 0x1001ef6 CLUTTER_DEPRECATED_MACRO_FOR("Deprecated key symbol. Use CLUTTER_KEY_Yhook instead.")
#define CLUTTER_yhook 0x1001ef7 CLUTTER_DEPRECATED_MACRO_FOR("Deprecated key symbol. Use CLUTTER_KEY_yhook instead.")
#define CLUTTER_Ytilde 0x1001ef8 CLUTTER_DEPRECATED_MACRO_FOR("Deprecated key symbol. Use CLUTTER_KEY_Ytilde instead.")
#define CLUTTER_ytilde 0x1001ef9 CLUTTER_DEPRECATED_MACRO_FOR("Deprecated key symbol. Use CLUTTER_KEY_ytilde instead.")
#define CLUTTER_Ohorn 0x10001a0 CLUTTER_DEPRECATED_MACRO_FOR("Deprecated key symbol. Use CLUTTER_KEY_Ohorn instead.")
#define CLUTTER_ohorn 0x10001a1 CLUTTER_DEPRECATED_MACRO_FOR("Deprecated key symbol. Use CLUTTER_KEY_ohorn instead.")
#define CLUTTER_Uhorn 0x10001af CLUTTER_DEPRECATED_MACRO_FOR("Deprecated key symbol. Use CLUTTER_KEY_Uhorn instead.")
#define CLUTTER_uhorn 0x10001b0 CLUTTER_DEPRECATED_MACRO_FOR("Deprecated key symbol. Use CLUTTER_KEY_uhorn instead.")
#define CLUTTER_EcuSign 0x10020a0 CLUTTER_DEPRECATED_MACRO_FOR("Deprecated key symbol. Use CLUTTER_KEY_EcuSign instead.")
#define CLUTTER_ColonSign 0x10020a1 CLUTTER_DEPRECATED_MACRO_FOR("Deprecated key symbol. Use CLUTTER_KEY_ColonSign instead.")
#define CLUTTER_CruzeiroSign 0x10020a2 CLUTTER_DEPRECATED_MACRO_FOR("Deprecated key symbol. Use CLUTTER_KEY_CruzeiroSign instead.")
#define CLUTTER_FFrancSign 0x10020a3 CLUTTER_DEPRECATED_MACRO_FOR("Deprecated key symbol. Use CLUTTER_KEY_FFrancSign instead.")
#define CLUTTER_LiraSign 0x10020a4 CLUTTER_DEPRECATED_MACRO_FOR("Deprecated key symbol. Use CLUTTER_KEY_LiraSign instead.")
#define CLUTTER_MillSign 0x10020a5 CLUTTER_DEPRECATED_MACRO_FOR("Deprecated key symbol. Use CLUTTER_KEY_MillSign instead.")
#define CLUTTER_NairaSign 0x10020a6 CLUTTER_DEPRECATED_MACRO_FOR("Deprecated key symbol. Use CLUTTER_KEY_NairaSign instead.")
#define CLUTTER_PesetaSign 0x10020a7 CLUTTER_DEPRECATED_MACRO_FOR("Deprecated key symbol. Use CLUTTER_KEY_PesetaSign instead.")
#define CLUTTER_RupeeSign 0x10020a8 CLUTTER_DEPRECATED_MACRO_FOR("Deprecated key symbol. Use CLUTTER_KEY_RupeeSign instead.")
#define CLUTTER_WonSign 0x10020a9 CLUTTER_DEPRECATED_MACRO_FOR("Deprecated key symbol. Use CLUTTER_KEY_WonSign instead.")
#define CLUTTER_NewSheqelSign 0x10020aa CLUTTER_DEPRECATED_MACRO_FOR("Deprecated key symbol. Use CLUTTER_KEY_NewSheqelSign instead.")
#define CLUTTER_DongSign 0x10020ab CLUTTER_DEPRECATED_MACRO_FOR("Deprecated key symbol. Use CLUTTER_KEY_DongSign instead.")
#define CLUTTER_EuroSign 0x20ac CLUTTER_DEPRECATED_MACRO_FOR("Deprecated key symbol. Use CLUTTER_KEY_EuroSign instead.")
#define CLUTTER_zerosuperior 0x1002070 CLUTTER_DEPRECATED_MACRO_FOR("Deprecated key symbol. Use CLUTTER_KEY_zerosuperior instead.")
#define CLUTTER_foursuperior 0x1002074 CLUTTER_DEPRECATED_MACRO_FOR("Deprecated key symbol. Use CLUTTER_KEY_foursuperior instead.")
#define CLUTTER_fivesuperior 0x1002075 CLUTTER_DEPRECATED_MACRO_FOR("Deprecated key symbol. Use CLUTTER_KEY_fivesuperior instead.")
#define CLUTTER_sixsuperior 0x1002076 CLUTTER_DEPRECATED_MACRO_FOR("Deprecated key symbol. Use CLUTTER_KEY_sixsuperior instead.")
#define CLUTTER_sevensuperior 0x1002077 CLUTTER_DEPRECATED_MACRO_FOR("Deprecated key symbol. Use CLUTTER_KEY_sevensuperior instead.")
#define CLUTTER_eightsuperior 0x1002078 CLUTTER_DEPRECATED_MACRO_FOR("Deprecated key symbol. Use CLUTTER_KEY_eightsuperior instead.")
#define CLUTTER_ninesuperior 0x1002079 CLUTTER_DEPRECATED_MACRO_FOR("Deprecated key symbol. Use CLUTTER_KEY_ninesuperior instead.")
#define CLUTTER_zerosubscript 0x1002080 CLUTTER_DEPRECATED_MACRO_FOR("Deprecated key symbol. Use CLUTTER_KEY_zerosubscript instead.")
#define CLUTTER_onesubscript 0x1002081 CLUTTER_DEPRECATED_MACRO_FOR("Deprecated key symbol. Use CLUTTER_KEY_onesubscript instead.")
#define CLUTTER_twosubscript 0x1002082 CLUTTER_DEPRECATED_MACRO_FOR("Deprecated key symbol. Use CLUTTER_KEY_twosubscript instead.")
#define CLUTTER_threesubscript 0x1002083 CLUTTER_DEPRECATED_MACRO_FOR("Deprecated key symbol. Use CLUTTER_KEY_threesubscript instead.")
#define CLUTTER_foursubscript 0x1002084 CLUTTER_DEPRECATED_MACRO_FOR("Deprecated key symbol. Use CLUTTER_KEY_foursubscript instead.")
#define CLUTTER_fivesubscript 0x1002085 CLUTTER_DEPRECATED_MACRO_FOR("Deprecated key symbol. Use CLUTTER_KEY_fivesubscript instead.")
#define CLUTTER_sixsubscript 0x1002086 CLUTTER_DEPRECATED_MACRO_FOR("Deprecated key symbol. Use CLUTTER_KEY_sixsubscript instead.")
#define CLUTTER_sevensubscript 0x1002087 CLUTTER_DEPRECATED_MACRO_FOR("Deprecated key symbol. Use CLUTTER_KEY_sevensubscript instead.")
#define CLUTTER_eightsubscript 0x1002088 CLUTTER_DEPRECATED_MACRO_FOR("Deprecated key symbol. Use CLUTTER_KEY_eightsubscript instead.")
#define CLUTTER_ninesubscript 0x1002089 CLUTTER_DEPRECATED_MACRO_FOR("Deprecated key symbol. Use CLUTTER_KEY_ninesubscript instead.")
#define CLUTTER_partdifferential 0x1002202 CLUTTER_DEPRECATED_MACRO_FOR("Deprecated key symbol. Use CLUTTER_KEY_partdifferential instead.")
#define CLUTTER_emptyset 0x1002205 CLUTTER_DEPRECATED_MACRO_FOR("Deprecated key symbol. Use CLUTTER_KEY_emptyset instead.")
#define CLUTTER_elementof 0x1002208 CLUTTER_DEPRECATED_MACRO_FOR("Deprecated key symbol. Use CLUTTER_KEY_elementof instead.")
#define CLUTTER_notelementof 0x1002209 CLUTTER_DEPRECATED_MACRO_FOR("Deprecated key symbol. Use CLUTTER_KEY_notelementof instead.")
#define CLUTTER_containsas 0x100220b CLUTTER_DEPRECATED_MACRO_FOR("Deprecated key symbol. Use CLUTTER_KEY_containsas instead.")
#define CLUTTER_squareroot 0x100221a CLUTTER_DEPRECATED_MACRO_FOR("Deprecated key symbol. Use CLUTTER_KEY_squareroot instead.")
#define CLUTTER_cuberoot 0x100221b CLUTTER_DEPRECATED_MACRO_FOR("Deprecated key symbol. Use CLUTTER_KEY_cuberoot instead.")
#define CLUTTER_fourthroot 0x100221c CLUTTER_DEPRECATED_MACRO_FOR("Deprecated key symbol. Use CLUTTER_KEY_fourthroot instead.")
#define CLUTTER_dintegral 0x100222c CLUTTER_DEPRECATED_MACRO_FOR("Deprecated key symbol. Use CLUTTER_KEY_dintegral instead.")
#define CLUTTER_tintegral 0x100222d CLUTTER_DEPRECATED_MACRO_FOR("Deprecated key symbol. Use CLUTTER_KEY_tintegral instead.")
#define CLUTTER_because 0x1002235 CLUTTER_DEPRECATED_MACRO_FOR("Deprecated key symbol. Use CLUTTER_KEY_because instead.")
#define CLUTTER_approxeq 0x1002248 CLUTTER_DEPRECATED_MACRO_FOR("Deprecated key symbol. Use CLUTTER_KEY_approxeq instead.")
#define CLUTTER_notapproxeq 0x1002247 CLUTTER_DEPRECATED_MACRO_FOR("Deprecated key symbol. Use CLUTTER_KEY_notapproxeq instead.")
#define CLUTTER_notidentical 0x1002262 CLUTTER_DEPRECATED_MACRO_FOR("Deprecated key symbol. Use CLUTTER_KEY_notidentical instead.")
#define CLUTTER_stricteq 0x1002263 CLUTTER_DEPRECATED_MACRO_FOR("Deprecated key symbol. Use CLUTTER_KEY_stricteq instead.")
#define CLUTTER_braille_dot_1 0xfff1 CLUTTER_DEPRECATED_MACRO_FOR("Deprecated key symbol. Use CLUTTER_KEY_braille_dot_1 instead.")
#define CLUTTER_braille_dot_2 0xfff2 CLUTTER_DEPRECATED_MACRO_FOR("Deprecated key symbol. Use CLUTTER_KEY_braille_dot_2 instead.")
#define CLUTTER_braille_dot_3 0xfff3 CLUTTER_DEPRECATED_MACRO_FOR("Deprecated key symbol. Use CLUTTER_KEY_braille_dot_3 instead.")
#define CLUTTER_braille_dot_4 0xfff4 CLUTTER_DEPRECATED_MACRO_FOR("Deprecated key symbol. Use CLUTTER_KEY_braille_dot_4 instead.")
#define CLUTTER_braille_dot_5 0xfff5 CLUTTER_DEPRECATED_MACRO_FOR("Deprecated key symbol. Use CLUTTER_KEY_braille_dot_5 instead.")
#define CLUTTER_braille_dot_6 0xfff6 CLUTTER_DEPRECATED_MACRO_FOR("Deprecated key symbol. Use CLUTTER_KEY_braille_dot_6 instead.")
#define CLUTTER_braille_dot_7 0xfff7 CLUTTER_DEPRECATED_MACRO_FOR("Deprecated key symbol. Use CLUTTER_KEY_braille_dot_7 instead.")
#define CLUTTER_braille_dot_8 0xfff8 CLUTTER_DEPRECATED_MACRO_FOR("Deprecated key symbol. Use CLUTTER_KEY_braille_dot_8 instead.")
#define CLUTTER_braille_dot_9 0xfff9 CLUTTER_DEPRECATED_MACRO_FOR("Deprecated key symbol. Use CLUTTER_KEY_braille_dot_9 instead.")
#define CLUTTER_braille_dot_10 0xfffa CLUTTER_DEPRECATED_MACRO_FOR("Deprecated key symbol. Use CLUTTER_KEY_braille_dot_10 instead.")
#define CLUTTER_braille_blank 0x1002800 CLUTTER_DEPRECATED_MACRO_FOR("Deprecated key symbol. Use CLUTTER_KEY_braille_blank instead.")
#define CLUTTER_braille_dots_1 0x1002801 CLUTTER_DEPRECATED_MACRO_FOR("Deprecated key symbol. Use CLUTTER_KEY_braille_dots_1 instead.")
#define CLUTTER_braille_dots_2 0x1002802 CLUTTER_DEPRECATED_MACRO_FOR("Deprecated key symbol. Use CLUTTER_KEY_braille_dots_2 instead.")
#define CLUTTER_braille_dots_12 0x1002803 CLUTTER_DEPRECATED_MACRO_FOR("Deprecated key symbol. Use CLUTTER_KEY_braille_dots_12 instead.")
#define CLUTTER_braille_dots_3 0x1002804 CLUTTER_DEPRECATED_MACRO_FOR("Deprecated key symbol. Use CLUTTER_KEY_braille_dots_3 instead.")
#define CLUTTER_braille_dots_13 0x1002805 CLUTTER_DEPRECATED_MACRO_FOR("Deprecated key symbol. Use CLUTTER_KEY_braille_dots_13 instead.")
#define CLUTTER_braille_dots_23 0x1002806 CLUTTER_DEPRECATED_MACRO_FOR("Deprecated key symbol. Use CLUTTER_KEY_braille_dots_23 instead.")
#define CLUTTER_braille_dots_123 0x1002807 CLUTTER_DEPRECATED_MACRO_FOR("Deprecated key symbol. Use CLUTTER_KEY_braille_dots_123 instead.")
#define CLUTTER_braille_dots_4 0x1002808 CLUTTER_DEPRECATED_MACRO_FOR("Deprecated key symbol. Use CLUTTER_KEY_braille_dots_4 instead.")
#define CLUTTER_braille_dots_14 0x1002809 CLUTTER_DEPRECATED_MACRO_FOR("Deprecated key symbol. Use CLUTTER_KEY_braille_dots_14 instead.")
#define CLUTTER_braille_dots_24 0x100280a CLUTTER_DEPRECATED_MACRO_FOR("Deprecated key symbol. Use CLUTTER_KEY_braille_dots_24 instead.")
#define CLUTTER_braille_dots_124 0x100280b CLUTTER_DEPRECATED_MACRO_FOR("Deprecated key symbol. Use CLUTTER_KEY_braille_dots_124 instead.")
#define CLUTTER_braille_dots_34 0x100280c CLUTTER_DEPRECATED_MACRO_FOR("Deprecated key symbol. Use CLUTTER_KEY_braille_dots_34 instead.")
#define CLUTTER_braille_dots_134 0x100280d CLUTTER_DEPRECATED_MACRO_FOR("Deprecated key symbol. Use CLUTTER_KEY_braille_dots_134 instead.")
#define CLUTTER_braille_dots_234 0x100280e CLUTTER_DEPRECATED_MACRO_FOR("Deprecated key symbol. Use CLUTTER_KEY_braille_dots_234 instead.")
#define CLUTTER_braille_dots_1234 0x100280f CLUTTER_DEPRECATED_MACRO_FOR("Deprecated key symbol. Use CLUTTER_KEY_braille_dots_1234 instead.")
#define CLUTTER_braille_dots_5 0x1002810 CLUTTER_DEPRECATED_MACRO_FOR("Deprecated key symbol. Use CLUTTER_KEY_braille_dots_5 instead.")
#define CLUTTER_braille_dots_15 0x1002811 CLUTTER_DEPRECATED_MACRO_FOR("Deprecated key symbol. Use CLUTTER_KEY_braille_dots_15 instead.")
#define CLUTTER_braille_dots_25 0x1002812 CLUTTER_DEPRECATED_MACRO_FOR("Deprecated key symbol. Use CLUTTER_KEY_braille_dots_25 instead.")
#define CLUTTER_braille_dots_125 0x1002813 CLUTTER_DEPRECATED_MACRO_FOR("Deprecated key symbol. Use CLUTTER_KEY_braille_dots_125 instead.")
#define CLUTTER_braille_dots_35 0x1002814 CLUTTER_DEPRECATED_MACRO_FOR("Deprecated key symbol. Use CLUTTER_KEY_braille_dots_35 instead.")
#define CLUTTER_braille_dots_135 0x1002815 CLUTTER_DEPRECATED_MACRO_FOR("Deprecated key symbol. Use CLUTTER_KEY_braille_dots_135 instead.")
#define CLUTTER_braille_dots_235 0x1002816 CLUTTER_DEPRECATED_MACRO_FOR("Deprecated key symbol. Use CLUTTER_KEY_braille_dots_235 instead.")
#define CLUTTER_braille_dots_1235 0x1002817 CLUTTER_DEPRECATED_MACRO_FOR("Deprecated key symbol. Use CLUTTER_KEY_braille_dots_1235 instead.")
#define CLUTTER_braille_dots_45 0x1002818 CLUTTER_DEPRECATED_MACRO_FOR("Deprecated key symbol. Use CLUTTER_KEY_braille_dots_45 instead.")
#define CLUTTER_braille_dots_145 0x1002819 CLUTTER_DEPRECATED_MACRO_FOR("Deprecated key symbol. Use CLUTTER_KEY_braille_dots_145 instead.")
#define CLUTTER_braille_dots_245 0x100281a CLUTTER_DEPRECATED_MACRO_FOR("Deprecated key symbol. Use CLUTTER_KEY_braille_dots_245 instead.")
#define CLUTTER_braille_dots_1245 0x100281b CLUTTER_DEPRECATED_MACRO_FOR("Deprecated key symbol. Use CLUTTER_KEY_braille_dots_1245 instead.")
#define CLUTTER_braille_dots_345 0x100281c CLUTTER_DEPRECATED_MACRO_FOR("Deprecated key symbol. Use CLUTTER_KEY_braille_dots_345 instead.")
#define CLUTTER_braille_dots_1345 0x100281d CLUTTER_DEPRECATED_MACRO_FOR("Deprecated key symbol. Use CLUTTER_KEY_braille_dots_1345 instead.")
#define CLUTTER_braille_dots_2345 0x100281e CLUTTER_DEPRECATED_MACRO_FOR("Deprecated key symbol. Use CLUTTER_KEY_braille_dots_2345 instead.")
#define CLUTTER_braille_dots_12345 0x100281f CLUTTER_DEPRECATED_MACRO_FOR("Deprecated key symbol. Use CLUTTER_KEY_braille_dots_12345 instead.")
#define CLUTTER_braille_dots_6 0x1002820 CLUTTER_DEPRECATED_MACRO_FOR("Deprecated key symbol. Use CLUTTER_KEY_braille_dots_6 instead.")
#define CLUTTER_braille_dots_16 0x1002821 CLUTTER_DEPRECATED_MACRO_FOR("Deprecated key symbol. Use CLUTTER_KEY_braille_dots_16 instead.")
#define CLUTTER_braille_dots_26 0x1002822 CLUTTER_DEPRECATED_MACRO_FOR("Deprecated key symbol. Use CLUTTER_KEY_braille_dots_26 instead.")
#define CLUTTER_braille_dots_126 0x1002823 CLUTTER_DEPRECATED_MACRO_FOR("Deprecated key symbol. Use CLUTTER_KEY_braille_dots_126 instead.")
#define CLUTTER_braille_dots_36 0x1002824 CLUTTER_DEPRECATED_MACRO_FOR("Deprecated key symbol. Use CLUTTER_KEY_braille_dots_36 instead.")
#define CLUTTER_braille_dots_136 0x1002825 CLUTTER_DEPRECATED_MACRO_FOR("Deprecated key symbol. Use CLUTTER_KEY_braille_dots_136 instead.")
#define CLUTTER_braille_dots_236 0x1002826 CLUTTER_DEPRECATED_MACRO_FOR("Deprecated key symbol. Use CLUTTER_KEY_braille_dots_236 instead.")
#define CLUTTER_braille_dots_1236 0x1002827 CLUTTER_DEPRECATED_MACRO_FOR("Deprecated key symbol. Use CLUTTER_KEY_braille_dots_1236 instead.")
#define CLUTTER_braille_dots_46 0x1002828 CLUTTER_DEPRECATED_MACRO_FOR("Deprecated key symbol. Use CLUTTER_KEY_braille_dots_46 instead.")
#define CLUTTER_braille_dots_146 0x1002829 CLUTTER_DEPRECATED_MACRO_FOR("Deprecated key symbol. Use CLUTTER_KEY_braille_dots_146 instead.")
#define CLUTTER_braille_dots_246 0x100282a CLUTTER_DEPRECATED_MACRO_FOR("Deprecated key symbol. Use CLUTTER_KEY_braille_dots_246 instead.")
#define CLUTTER_braille_dots_1246 0x100282b CLUTTER_DEPRECATED_MACRO_FOR("Deprecated key symbol. Use CLUTTER_KEY_braille_dots_1246 instead.")
#define CLUTTER_braille_dots_346 0x100282c CLUTTER_DEPRECATED_MACRO_FOR("Deprecated key symbol. Use CLUTTER_KEY_braille_dots_346 instead.")
#define CLUTTER_braille_dots_1346 0x100282d CLUTTER_DEPRECATED_MACRO_FOR("Deprecated key symbol. Use CLUTTER_KEY_braille_dots_1346 instead.")
#define CLUTTER_braille_dots_2346 0x100282e CLUTTER_DEPRECATED_MACRO_FOR("Deprecated key symbol. Use CLUTTER_KEY_braille_dots_2346 instead.")
#define CLUTTER_braille_dots_12346 0x100282f CLUTTER_DEPRECATED_MACRO_FOR("Deprecated key symbol. Use CLUTTER_KEY_braille_dots_12346 instead.")
#define CLUTTER_braille_dots_56 0x1002830 CLUTTER_DEPRECATED_MACRO_FOR("Deprecated key symbol. Use CLUTTER_KEY_braille_dots_56 instead.")
#define CLUTTER_braille_dots_156 0x1002831 CLUTTER_DEPRECATED_MACRO_FOR("Deprecated key symbol. Use CLUTTER_KEY_braille_dots_156 instead.")
#define CLUTTER_braille_dots_256 0x1002832 CLUTTER_DEPRECATED_MACRO_FOR("Deprecated key symbol. Use CLUTTER_KEY_braille_dots_256 instead.")
#define CLUTTER_braille_dots_1256 0x1002833 CLUTTER_DEPRECATED_MACRO_FOR("Deprecated key symbol. Use CLUTTER_KEY_braille_dots_1256 instead.")
#define CLUTTER_braille_dots_356 0x1002834 CLUTTER_DEPRECATED_MACRO_FOR("Deprecated key symbol. Use CLUTTER_KEY_braille_dots_356 instead.")
#define CLUTTER_braille_dots_1356 0x1002835 CLUTTER_DEPRECATED_MACRO_FOR("Deprecated key symbol. Use CLUTTER_KEY_braille_dots_1356 instead.")
#define CLUTTER_braille_dots_2356 0x1002836 CLUTTER_DEPRECATED_MACRO_FOR("Deprecated key symbol. Use CLUTTER_KEY_braille_dots_2356 instead.")
#define CLUTTER_braille_dots_12356 0x1002837 CLUTTER_DEPRECATED_MACRO_FOR("Deprecated key symbol. Use CLUTTER_KEY_braille_dots_12356 instead.")
#define CLUTTER_braille_dots_456 0x1002838 CLUTTER_DEPRECATED_MACRO_FOR("Deprecated key symbol. Use CLUTTER_KEY_braille_dots_456 instead.")
#define CLUTTER_braille_dots_1456 0x1002839 CLUTTER_DEPRECATED_MACRO_FOR("Deprecated key symbol. Use CLUTTER_KEY_braille_dots_1456 instead.")
#define CLUTTER_braille_dots_2456 0x100283a CLUTTER_DEPRECATED_MACRO_FOR("Deprecated key symbol. Use CLUTTER_KEY_braille_dots_2456 instead.")
#define CLUTTER_braille_dots_12456 0x100283b CLUTTER_DEPRECATED_MACRO_FOR("Deprecated key symbol. Use CLUTTER_KEY_braille_dots_12456 instead.")
#define CLUTTER_braille_dots_3456 0x100283c CLUTTER_DEPRECATED_MACRO_FOR("Deprecated key symbol. Use CLUTTER_KEY_braille_dots_3456 instead.")
#define CLUTTER_braille_dots_13456 0x100283d CLUTTER_DEPRECATED_MACRO_FOR("Deprecated key symbol. Use CLUTTER_KEY_braille_dots_13456 instead.")
#define CLUTTER_braille_dots_23456 0x100283e CLUTTER_DEPRECATED_MACRO_FOR("Deprecated key symbol. Use CLUTTER_KEY_braille_dots_23456 instead.")
#define CLUTTER_braille_dots_123456 0x100283f CLUTTER_DEPRECATED_MACRO_FOR("Deprecated key symbol. Use CLUTTER_KEY_braille_dots_123456 instead.")
#define CLUTTER_braille_dots_7 0x1002840 CLUTTER_DEPRECATED_MACRO_FOR("Deprecated key symbol. Use CLUTTER_KEY_braille_dots_7 instead.")
#define CLUTTER_braille_dots_17 0x1002841 CLUTTER_DEPRECATED_MACRO_FOR("Deprecated key symbol. Use CLUTTER_KEY_braille_dots_17 instead.")
#define CLUTTER_braille_dots_27 0x1002842 CLUTTER_DEPRECATED_MACRO_FOR("Deprecated key symbol. Use CLUTTER_KEY_braille_dots_27 instead.")
#define CLUTTER_braille_dots_127 0x1002843 CLUTTER_DEPRECATED_MACRO_FOR("Deprecated key symbol. Use CLUTTER_KEY_braille_dots_127 instead.")
#define CLUTTER_braille_dots_37 0x1002844 CLUTTER_DEPRECATED_MACRO_FOR("Deprecated key symbol. Use CLUTTER_KEY_braille_dots_37 instead.")
#define CLUTTER_braille_dots_137 0x1002845 CLUTTER_DEPRECATED_MACRO_FOR("Deprecated key symbol. Use CLUTTER_KEY_braille_dots_137 instead.")
#define CLUTTER_braille_dots_237 0x1002846 CLUTTER_DEPRECATED_MACRO_FOR("Deprecated key symbol. Use CLUTTER_KEY_braille_dots_237 instead.")
#define CLUTTER_braille_dots_1237 0x1002847 CLUTTER_DEPRECATED_MACRO_FOR("Deprecated key symbol. Use CLUTTER_KEY_braille_dots_1237 instead.")
#define CLUTTER_braille_dots_47 0x1002848 CLUTTER_DEPRECATED_MACRO_FOR("Deprecated key symbol. Use CLUTTER_KEY_braille_dots_47 instead.")
#define CLUTTER_braille_dots_147 0x1002849 CLUTTER_DEPRECATED_MACRO_FOR("Deprecated key symbol. Use CLUTTER_KEY_braille_dots_147 instead.")
#define CLUTTER_braille_dots_247 0x100284a CLUTTER_DEPRECATED_MACRO_FOR("Deprecated key symbol. Use CLUTTER_KEY_braille_dots_247 instead.")
#define CLUTTER_braille_dots_1247 0x100284b CLUTTER_DEPRECATED_MACRO_FOR("Deprecated key symbol. Use CLUTTER_KEY_braille_dots_1247 instead.")
#define CLUTTER_braille_dots_347 0x100284c CLUTTER_DEPRECATED_MACRO_FOR("Deprecated key symbol. Use CLUTTER_KEY_braille_dots_347 instead.")
#define CLUTTER_braille_dots_1347 0x100284d CLUTTER_DEPRECATED_MACRO_FOR("Deprecated key symbol. Use CLUTTER_KEY_braille_dots_1347 instead.")
#define CLUTTER_braille_dots_2347 0x100284e CLUTTER_DEPRECATED_MACRO_FOR("Deprecated key symbol. Use CLUTTER_KEY_braille_dots_2347 instead.")
#define CLUTTER_braille_dots_12347 0x100284f CLUTTER_DEPRECATED_MACRO_FOR("Deprecated key symbol. Use CLUTTER_KEY_braille_dots_12347 instead.")
#define CLUTTER_braille_dots_57 0x1002850 CLUTTER_DEPRECATED_MACRO_FOR("Deprecated key symbol. Use CLUTTER_KEY_braille_dots_57 instead.")
#define CLUTTER_braille_dots_157 0x1002851 CLUTTER_DEPRECATED_MACRO_FOR("Deprecated key symbol. Use CLUTTER_KEY_braille_dots_157 instead.")
#define CLUTTER_braille_dots_257 0x1002852 CLUTTER_DEPRECATED_MACRO_FOR("Deprecated key symbol. Use CLUTTER_KEY_braille_dots_257 instead.")
#define CLUTTER_braille_dots_1257 0x1002853 CLUTTER_DEPRECATED_MACRO_FOR("Deprecated key symbol. Use CLUTTER_KEY_braille_dots_1257 instead.")
#define CLUTTER_braille_dots_357 0x1002854 CLUTTER_DEPRECATED_MACRO_FOR("Deprecated key symbol. Use CLUTTER_KEY_braille_dots_357 instead.")
#define CLUTTER_braille_dots_1357 0x1002855 CLUTTER_DEPRECATED_MACRO_FOR("Deprecated key symbol. Use CLUTTER_KEY_braille_dots_1357 instead.")
#define CLUTTER_braille_dots_2357 0x1002856 CLUTTER_DEPRECATED_MACRO_FOR("Deprecated key symbol. Use CLUTTER_KEY_braille_dots_2357 instead.")
#define CLUTTER_braille_dots_12357 0x1002857 CLUTTER_DEPRECATED_MACRO_FOR("Deprecated key symbol. Use CLUTTER_KEY_braille_dots_12357 instead.")
#define CLUTTER_braille_dots_457 0x1002858 CLUTTER_DEPRECATED_MACRO_FOR("Deprecated key symbol. Use CLUTTER_KEY_braille_dots_457 instead.")
#define CLUTTER_braille_dots_1457 0x1002859 CLUTTER_DEPRECATED_MACRO_FOR("Deprecated key symbol. Use CLUTTER_KEY_braille_dots_1457 instead.")
#define CLUTTER_braille_dots_2457 0x100285a CLUTTER_DEPRECATED_MACRO_FOR("Deprecated key symbol. Use CLUTTER_KEY_braille_dots_2457 instead.")
#define CLUTTER_braille_dots_12457 0x100285b CLUTTER_DEPRECATED_MACRO_FOR("Deprecated key symbol. Use CLUTTER_KEY_braille_dots_12457 instead.")
#define CLUTTER_braille_dots_3457 0x100285c CLUTTER_DEPRECATED_MACRO_FOR("Deprecated key symbol. Use CLUTTER_KEY_braille_dots_3457 instead.")
#define CLUTTER_braille_dots_13457 0x100285d CLUTTER_DEPRECATED_MACRO_FOR("Deprecated key symbol. Use CLUTTER_KEY_braille_dots_13457 instead.")
#define CLUTTER_braille_dots_23457 0x100285e CLUTTER_DEPRECATED_MACRO_FOR("Deprecated key symbol. Use CLUTTER_KEY_braille_dots_23457 instead.")
#define CLUTTER_braille_dots_123457 0x100285f CLUTTER_DEPRECATED_MACRO_FOR("Deprecated key symbol. Use CLUTTER_KEY_braille_dots_123457 instead.")
#define CLUTTER_braille_dots_67 0x1002860 CLUTTER_DEPRECATED_MACRO_FOR("Deprecated key symbol. Use CLUTTER_KEY_braille_dots_67 instead.")
#define CLUTTER_braille_dots_167 0x1002861 CLUTTER_DEPRECATED_MACRO_FOR("Deprecated key symbol. Use CLUTTER_KEY_braille_dots_167 instead.")
#define CLUTTER_braille_dots_267 0x1002862 CLUTTER_DEPRECATED_MACRO_FOR("Deprecated key symbol. Use CLUTTER_KEY_braille_dots_267 instead.")
#define CLUTTER_braille_dots_1267 0x1002863 CLUTTER_DEPRECATED_MACRO_FOR("Deprecated key symbol. Use CLUTTER_KEY_braille_dots_1267 instead.")
#define CLUTTER_braille_dots_367 0x1002864 CLUTTER_DEPRECATED_MACRO_FOR("Deprecated key symbol. Use CLUTTER_KEY_braille_dots_367 instead.")
#define CLUTTER_braille_dots_1367 0x1002865 CLUTTER_DEPRECATED_MACRO_FOR("Deprecated key symbol. Use CLUTTER_KEY_braille_dots_1367 instead.")
#define CLUTTER_braille_dots_2367 0x1002866 CLUTTER_DEPRECATED_MACRO_FOR("Deprecated key symbol. Use CLUTTER_KEY_braille_dots_2367 instead.")
#define CLUTTER_braille_dots_12367 0x1002867 CLUTTER_DEPRECATED_MACRO_FOR("Deprecated key symbol. Use CLUTTER_KEY_braille_dots_12367 instead.")
#define CLUTTER_braille_dots_467 0x1002868 CLUTTER_DEPRECATED_MACRO_FOR("Deprecated key symbol. Use CLUTTER_KEY_braille_dots_467 instead.")
#define CLUTTER_braille_dots_1467 0x1002869 CLUTTER_DEPRECATED_MACRO_FOR("Deprecated key symbol. Use CLUTTER_KEY_braille_dots_1467 instead.")
#define CLUTTER_braille_dots_2467 0x100286a CLUTTER_DEPRECATED_MACRO_FOR("Deprecated key symbol. Use CLUTTER_KEY_braille_dots_2467 instead.")
#define CLUTTER_braille_dots_12467 0x100286b CLUTTER_DEPRECATED_MACRO_FOR("Deprecated key symbol. Use CLUTTER_KEY_braille_dots_12467 instead.")
#define CLUTTER_braille_dots_3467 0x100286c CLUTTER_DEPRECATED_MACRO_FOR("Deprecated key symbol. Use CLUTTER_KEY_braille_dots_3467 instead.")
#define CLUTTER_braille_dots_13467 0x100286d CLUTTER_DEPRECATED_MACRO_FOR("Deprecated key symbol. Use CLUTTER_KEY_braille_dots_13467 instead.")
#define CLUTTER_braille_dots_23467 0x100286e CLUTTER_DEPRECATED_MACRO_FOR("Deprecated key symbol. Use CLUTTER_KEY_braille_dots_23467 instead.")
#define CLUTTER_braille_dots_123467 0x100286f CLUTTER_DEPRECATED_MACRO_FOR("Deprecated key symbol. Use CLUTTER_KEY_braille_dots_123467 instead.")
#define CLUTTER_braille_dots_567 0x1002870 CLUTTER_DEPRECATED_MACRO_FOR("Deprecated key symbol. Use CLUTTER_KEY_braille_dots_567 instead.")
#define CLUTTER_braille_dots_1567 0x1002871 CLUTTER_DEPRECATED_MACRO_FOR("Deprecated key symbol. Use CLUTTER_KEY_braille_dots_1567 instead.")
#define CLUTTER_braille_dots_2567 0x1002872 CLUTTER_DEPRECATED_MACRO_FOR("Deprecated key symbol. Use CLUTTER_KEY_braille_dots_2567 instead.")
#define CLUTTER_braille_dots_12567 0x1002873 CLUTTER_DEPRECATED_MACRO_FOR("Deprecated key symbol. Use CLUTTER_KEY_braille_dots_12567 instead.")
#define CLUTTER_braille_dots_3567 0x1002874 CLUTTER_DEPRECATED_MACRO_FOR("Deprecated key symbol. Use CLUTTER_KEY_braille_dots_3567 instead.")
#define CLUTTER_braille_dots_13567 0x1002875 CLUTTER_DEPRECATED_MACRO_FOR("Deprecated key symbol. Use CLUTTER_KEY_braille_dots_13567 instead.")
#define CLUTTER_braille_dots_23567 0x1002876 CLUTTER_DEPRECATED_MACRO_FOR("Deprecated key symbol. Use CLUTTER_KEY_braille_dots_23567 instead.")
#define CLUTTER_braille_dots_123567 0x1002877 CLUTTER_DEPRECATED_MACRO_FOR("Deprecated key symbol. Use CLUTTER_KEY_braille_dots_123567 instead.")
#define CLUTTER_braille_dots_4567 0x1002878 CLUTTER_DEPRECATED_MACRO_FOR("Deprecated key symbol. Use CLUTTER_KEY_braille_dots_4567 instead.")
#define CLUTTER_braille_dots_14567 0x1002879 CLUTTER_DEPRECATED_MACRO_FOR("Deprecated key symbol. Use CLUTTER_KEY_braille_dots_14567 instead.")
#define CLUTTER_braille_dots_24567 0x100287a CLUTTER_DEPRECATED_MACRO_FOR("Deprecated key symbol. Use CLUTTER_KEY_braille_dots_24567 instead.")
#define CLUTTER_braille_dots_124567 0x100287b CLUTTER_DEPRECATED_MACRO_FOR("Deprecated key symbol. Use CLUTTER_KEY_braille_dots_124567 instead.")
#define CLUTTER_braille_dots_34567 0x100287c CLUTTER_DEPRECATED_MACRO_FOR("Deprecated key symbol. Use CLUTTER_KEY_braille_dots_34567 instead.")
#define CLUTTER_braille_dots_134567 0x100287d CLUTTER_DEPRECATED_MACRO_FOR("Deprecated key symbol. Use CLUTTER_KEY_braille_dots_134567 instead.")
#define CLUTTER_braille_dots_234567 0x100287e CLUTTER_DEPRECATED_MACRO_FOR("Deprecated key symbol. Use CLUTTER_KEY_braille_dots_234567 instead.")
#define CLUTTER_braille_dots_1234567 0x100287f CLUTTER_DEPRECATED_MACRO_FOR("Deprecated key symbol. Use CLUTTER_KEY_braille_dots_1234567 instead.")
#define CLUTTER_braille_dots_8 0x1002880 CLUTTER_DEPRECATED_MACRO_FOR("Deprecated key symbol. Use CLUTTER_KEY_braille_dots_8 instead.")
#define CLUTTER_braille_dots_18 0x1002881 CLUTTER_DEPRECATED_MACRO_FOR("Deprecated key symbol. Use CLUTTER_KEY_braille_dots_18 instead.")
#define CLUTTER_braille_dots_28 0x1002882 CLUTTER_DEPRECATED_MACRO_FOR("Deprecated key symbol. Use CLUTTER_KEY_braille_dots_28 instead.")
#define CLUTTER_braille_dots_128 0x1002883 CLUTTER_DEPRECATED_MACRO_FOR("Deprecated key symbol. Use CLUTTER_KEY_braille_dots_128 instead.")
#define CLUTTER_braille_dots_38 0x1002884 CLUTTER_DEPRECATED_MACRO_FOR("Deprecated key symbol. Use CLUTTER_KEY_braille_dots_38 instead.")
#define CLUTTER_braille_dots_138 0x1002885 CLUTTER_DEPRECATED_MACRO_FOR("Deprecated key symbol. Use CLUTTER_KEY_braille_dots_138 instead.")
#define CLUTTER_braille_dots_238 0x1002886 CLUTTER_DEPRECATED_MACRO_FOR("Deprecated key symbol. Use CLUTTER_KEY_braille_dots_238 instead.")
#define CLUTTER_braille_dots_1238 0x1002887 CLUTTER_DEPRECATED_MACRO_FOR("Deprecated key symbol. Use CLUTTER_KEY_braille_dots_1238 instead.")
#define CLUTTER_braille_dots_48 0x1002888 CLUTTER_DEPRECATED_MACRO_FOR("Deprecated key symbol. Use CLUTTER_KEY_braille_dots_48 instead.")
#define CLUTTER_braille_dots_148 0x1002889 CLUTTER_DEPRECATED_MACRO_FOR("Deprecated key symbol. Use CLUTTER_KEY_braille_dots_148 instead.")
#define CLUTTER_braille_dots_248 0x100288a CLUTTER_DEPRECATED_MACRO_FOR("Deprecated key symbol. Use CLUTTER_KEY_braille_dots_248 instead.")
#define CLUTTER_braille_dots_1248 0x100288b CLUTTER_DEPRECATED_MACRO_FOR("Deprecated key symbol. Use CLUTTER_KEY_braille_dots_1248 instead.")
#define CLUTTER_braille_dots_348 0x100288c CLUTTER_DEPRECATED_MACRO_FOR("Deprecated key symbol. Use CLUTTER_KEY_braille_dots_348 instead.")
#define CLUTTER_braille_dots_1348 0x100288d CLUTTER_DEPRECATED_MACRO_FOR("Deprecated key symbol. Use CLUTTER_KEY_braille_dots_1348 instead.")
#define CLUTTER_braille_dots_2348 0x100288e CLUTTER_DEPRECATED_MACRO_FOR("Deprecated key symbol. Use CLUTTER_KEY_braille_dots_2348 instead.")
#define CLUTTER_braille_dots_12348 0x100288f CLUTTER_DEPRECATED_MACRO_FOR("Deprecated key symbol. Use CLUTTER_KEY_braille_dots_12348 instead.")
#define CLUTTER_braille_dots_58 0x1002890 CLUTTER_DEPRECATED_MACRO_FOR("Deprecated key symbol. Use CLUTTER_KEY_braille_dots_58 instead.")
#define CLUTTER_braille_dots_158 0x1002891 CLUTTER_DEPRECATED_MACRO_FOR("Deprecated key symbol. Use CLUTTER_KEY_braille_dots_158 instead.")
#define CLUTTER_braille_dots_258 0x1002892 CLUTTER_DEPRECATED_MACRO_FOR("Deprecated key symbol. Use CLUTTER_KEY_braille_dots_258 instead.")
#define CLUTTER_braille_dots_1258 0x1002893 CLUTTER_DEPRECATED_MACRO_FOR("Deprecated key symbol. Use CLUTTER_KEY_braille_dots_1258 instead.")
#define CLUTTER_braille_dots_358 0x1002894 CLUTTER_DEPRECATED_MACRO_FOR("Deprecated key symbol. Use CLUTTER_KEY_braille_dots_358 instead.")
#define CLUTTER_braille_dots_1358 0x1002895 CLUTTER_DEPRECATED_MACRO_FOR("Deprecated key symbol. Use CLUTTER_KEY_braille_dots_1358 instead.")
#define CLUTTER_braille_dots_2358 0x1002896 CLUTTER_DEPRECATED_MACRO_FOR("Deprecated key symbol. Use CLUTTER_KEY_braille_dots_2358 instead.")
#define CLUTTER_braille_dots_12358 0x1002897 CLUTTER_DEPRECATED_MACRO_FOR("Deprecated key symbol. Use CLUTTER_KEY_braille_dots_12358 instead.")
#define CLUTTER_braille_dots_458 0x1002898 CLUTTER_DEPRECATED_MACRO_FOR("Deprecated key symbol. Use CLUTTER_KEY_braille_dots_458 instead.")
#define CLUTTER_braille_dots_1458 0x1002899 CLUTTER_DEPRECATED_MACRO_FOR("Deprecated key symbol. Use CLUTTER_KEY_braille_dots_1458 instead.")
#define CLUTTER_braille_dots_2458 0x100289a CLUTTER_DEPRECATED_MACRO_FOR("Deprecated key symbol. Use CLUTTER_KEY_braille_dots_2458 instead.")
#define CLUTTER_braille_dots_12458 0x100289b CLUTTER_DEPRECATED_MACRO_FOR("Deprecated key symbol. Use CLUTTER_KEY_braille_dots_12458 instead.")
#define CLUTTER_braille_dots_3458 0x100289c CLUTTER_DEPRECATED_MACRO_FOR("Deprecated key symbol. Use CLUTTER_KEY_braille_dots_3458 instead.")
#define CLUTTER_braille_dots_13458 0x100289d CLUTTER_DEPRECATED_MACRO_FOR("Deprecated key symbol. Use CLUTTER_KEY_braille_dots_13458 instead.")
#define CLUTTER_braille_dots_23458 0x100289e CLUTTER_DEPRECATED_MACRO_FOR("Deprecated key symbol. Use CLUTTER_KEY_braille_dots_23458 instead.")
#define CLUTTER_braille_dots_123458 0x100289f CLUTTER_DEPRECATED_MACRO_FOR("Deprecated key symbol. Use CLUTTER_KEY_braille_dots_123458 instead.")
#define CLUTTER_braille_dots_68 0x10028a0 CLUTTER_DEPRECATED_MACRO_FOR("Deprecated key symbol. Use CLUTTER_KEY_braille_dots_68 instead.")
#define CLUTTER_braille_dots_168 0x10028a1 CLUTTER_DEPRECATED_MACRO_FOR("Deprecated key symbol. Use CLUTTER_KEY_braille_dots_168 instead.")
#define CLUTTER_braille_dots_268 0x10028a2 CLUTTER_DEPRECATED_MACRO_FOR("Deprecated key symbol. Use CLUTTER_KEY_braille_dots_268 instead.")
#define CLUTTER_braille_dots_1268 0x10028a3 CLUTTER_DEPRECATED_MACRO_FOR("Deprecated key symbol. Use CLUTTER_KEY_braille_dots_1268 instead.")
#define CLUTTER_braille_dots_368 0x10028a4 CLUTTER_DEPRECATED_MACRO_FOR("Deprecated key symbol. Use CLUTTER_KEY_braille_dots_368 instead.")
#define CLUTTER_braille_dots_1368 0x10028a5 CLUTTER_DEPRECATED_MACRO_FOR("Deprecated key symbol. Use CLUTTER_KEY_braille_dots_1368 instead.")
#define CLUTTER_braille_dots_2368 0x10028a6 CLUTTER_DEPRECATED_MACRO_FOR("Deprecated key symbol. Use CLUTTER_KEY_braille_dots_2368 instead.")
#define CLUTTER_braille_dots_12368 0x10028a7 CLUTTER_DEPRECATED_MACRO_FOR("Deprecated key symbol. Use CLUTTER_KEY_braille_dots_12368 instead.")
#define CLUTTER_braille_dots_468 0x10028a8 CLUTTER_DEPRECATED_MACRO_FOR("Deprecated key symbol. Use CLUTTER_KEY_braille_dots_468 instead.")
#define CLUTTER_braille_dots_1468 0x10028a9 CLUTTER_DEPRECATED_MACRO_FOR("Deprecated key symbol. Use CLUTTER_KEY_braille_dots_1468 instead.")
#define CLUTTER_braille_dots_2468 0x10028aa CLUTTER_DEPRECATED_MACRO_FOR("Deprecated key symbol. Use CLUTTER_KEY_braille_dots_2468 instead.")
#define CLUTTER_braille_dots_12468 0x10028ab CLUTTER_DEPRECATED_MACRO_FOR("Deprecated key symbol. Use CLUTTER_KEY_braille_dots_12468 instead.")
#define CLUTTER_braille_dots_3468 0x10028ac CLUTTER_DEPRECATED_MACRO_FOR("Deprecated key symbol. Use CLUTTER_KEY_braille_dots_3468 instead.")
#define CLUTTER_braille_dots_13468 0x10028ad CLUTTER_DEPRECATED_MACRO_FOR("Deprecated key symbol. Use CLUTTER_KEY_braille_dots_13468 instead.")
#define CLUTTER_braille_dots_23468 0x10028ae CLUTTER_DEPRECATED_MACRO_FOR("Deprecated key symbol. Use CLUTTER_KEY_braille_dots_23468 instead.")
#define CLUTTER_braille_dots_123468 0x10028af CLUTTER_DEPRECATED_MACRO_FOR("Deprecated key symbol. Use CLUTTER_KEY_braille_dots_123468 instead.")
#define CLUTTER_braille_dots_568 0x10028b0 CLUTTER_DEPRECATED_MACRO_FOR("Deprecated key symbol. Use CLUTTER_KEY_braille_dots_568 instead.")
#define CLUTTER_braille_dots_1568 0x10028b1 CLUTTER_DEPRECATED_MACRO_FOR("Deprecated key symbol. Use CLUTTER_KEY_braille_dots_1568 instead.")
#define CLUTTER_braille_dots_2568 0x10028b2 CLUTTER_DEPRECATED_MACRO_FOR("Deprecated key symbol. Use CLUTTER_KEY_braille_dots_2568 instead.")
#define CLUTTER_braille_dots_12568 0x10028b3 CLUTTER_DEPRECATED_MACRO_FOR("Deprecated key symbol. Use CLUTTER_KEY_braille_dots_12568 instead.")
#define CLUTTER_braille_dots_3568 0x10028b4 CLUTTER_DEPRECATED_MACRO_FOR("Deprecated key symbol. Use CLUTTER_KEY_braille_dots_3568 instead.")
#define CLUTTER_braille_dots_13568 0x10028b5 CLUTTER_DEPRECATED_MACRO_FOR("Deprecated key symbol. Use CLUTTER_KEY_braille_dots_13568 instead.")
#define CLUTTER_braille_dots_23568 0x10028b6 CLUTTER_DEPRECATED_MACRO_FOR("Deprecated key symbol. Use CLUTTER_KEY_braille_dots_23568 instead.")
#define CLUTTER_braille_dots_123568 0x10028b7 CLUTTER_DEPRECATED_MACRO_FOR("Deprecated key symbol. Use CLUTTER_KEY_braille_dots_123568 instead.")
#define CLUTTER_braille_dots_4568 0x10028b8 CLUTTER_DEPRECATED_MACRO_FOR("Deprecated key symbol. Use CLUTTER_KEY_braille_dots_4568 instead.")
#define CLUTTER_braille_dots_14568 0x10028b9 CLUTTER_DEPRECATED_MACRO_FOR("Deprecated key symbol. Use CLUTTER_KEY_braille_dots_14568 instead.")
#define CLUTTER_braille_dots_24568 0x10028ba CLUTTER_DEPRECATED_MACRO_FOR("Deprecated key symbol. Use CLUTTER_KEY_braille_dots_24568 instead.")
#define CLUTTER_braille_dots_124568 0x10028bb CLUTTER_DEPRECATED_MACRO_FOR("Deprecated key symbol. Use CLUTTER_KEY_braille_dots_124568 instead.")
#define CLUTTER_braille_dots_34568 0x10028bc CLUTTER_DEPRECATED_MACRO_FOR("Deprecated key symbol. Use CLUTTER_KEY_braille_dots_34568 instead.")
#define CLUTTER_braille_dots_134568 0x10028bd CLUTTER_DEPRECATED_MACRO_FOR("Deprecated key symbol. Use CLUTTER_KEY_braille_dots_134568 instead.")
#define CLUTTER_braille_dots_234568 0x10028be CLUTTER_DEPRECATED_MACRO_FOR("Deprecated key symbol. Use CLUTTER_KEY_braille_dots_234568 instead.")
#define CLUTTER_braille_dots_1234568 0x10028bf CLUTTER_DEPRECATED_MACRO_FOR("Deprecated key symbol. Use CLUTTER_KEY_braille_dots_1234568 instead.")
#define CLUTTER_braille_dots_78 0x10028c0 CLUTTER_DEPRECATED_MACRO_FOR("Deprecated key symbol. Use CLUTTER_KEY_braille_dots_78 instead.")
#define CLUTTER_braille_dots_178 0x10028c1 CLUTTER_DEPRECATED_MACRO_FOR("Deprecated key symbol. Use CLUTTER_KEY_braille_dots_178 instead.")
#define CLUTTER_braille_dots_278 0x10028c2 CLUTTER_DEPRECATED_MACRO_FOR("Deprecated key symbol. Use CLUTTER_KEY_braille_dots_278 instead.")
#define CLUTTER_braille_dots_1278 0x10028c3 CLUTTER_DEPRECATED_MACRO_FOR("Deprecated key symbol. Use CLUTTER_KEY_braille_dots_1278 instead.")
#define CLUTTER_braille_dots_378 0x10028c4 CLUTTER_DEPRECATED_MACRO_FOR("Deprecated key symbol. Use CLUTTER_KEY_braille_dots_378 instead.")
#define CLUTTER_braille_dots_1378 0x10028c5 CLUTTER_DEPRECATED_MACRO_FOR("Deprecated key symbol. Use CLUTTER_KEY_braille_dots_1378 instead.")
#define CLUTTER_braille_dots_2378 0x10028c6 CLUTTER_DEPRECATED_MACRO_FOR("Deprecated key symbol. Use CLUTTER_KEY_braille_dots_2378 instead.")
#define CLUTTER_braille_dots_12378 0x10028c7 CLUTTER_DEPRECATED_MACRO_FOR("Deprecated key symbol. Use CLUTTER_KEY_braille_dots_12378 instead.")
#define CLUTTER_braille_dots_478 0x10028c8 CLUTTER_DEPRECATED_MACRO_FOR("Deprecated key symbol. Use CLUTTER_KEY_braille_dots_478 instead.")
#define CLUTTER_braille_dots_1478 0x10028c9 CLUTTER_DEPRECATED_MACRO_FOR("Deprecated key symbol. Use CLUTTER_KEY_braille_dots_1478 instead.")
#define CLUTTER_braille_dots_2478 0x10028ca CLUTTER_DEPRECATED_MACRO_FOR("Deprecated key symbol. Use CLUTTER_KEY_braille_dots_2478 instead.")
#define CLUTTER_braille_dots_12478 0x10028cb CLUTTER_DEPRECATED_MACRO_FOR("Deprecated key symbol. Use CLUTTER_KEY_braille_dots_12478 instead.")
#define CLUTTER_braille_dots_3478 0x10028cc CLUTTER_DEPRECATED_MACRO_FOR("Deprecated key symbol. Use CLUTTER_KEY_braille_dots_3478 instead.")
#define CLUTTER_braille_dots_13478 0x10028cd CLUTTER_DEPRECATED_MACRO_FOR("Deprecated key symbol. Use CLUTTER_KEY_braille_dots_13478 instead.")
#define CLUTTER_braille_dots_23478 0x10028ce CLUTTER_DEPRECATED_MACRO_FOR("Deprecated key symbol. Use CLUTTER_KEY_braille_dots_23478 instead.")
#define CLUTTER_braille_dots_123478 0x10028cf CLUTTER_DEPRECATED_MACRO_FOR("Deprecated key symbol. Use CLUTTER_KEY_braille_dots_123478 instead.")
#define CLUTTER_braille_dots_578 0x10028d0 CLUTTER_DEPRECATED_MACRO_FOR("Deprecated key symbol. Use CLUTTER_KEY_braille_dots_578 instead.")
#define CLUTTER_braille_dots_1578 0x10028d1 CLUTTER_DEPRECATED_MACRO_FOR("Deprecated key symbol. Use CLUTTER_KEY_braille_dots_1578 instead.")
#define CLUTTER_braille_dots_2578 0x10028d2 CLUTTER_DEPRECATED_MACRO_FOR("Deprecated key symbol. Use CLUTTER_KEY_braille_dots_2578 instead.")
#define CLUTTER_braille_dots_12578 0x10028d3 CLUTTER_DEPRECATED_MACRO_FOR("Deprecated key symbol. Use CLUTTER_KEY_braille_dots_12578 instead.")
#define CLUTTER_braille_dots_3578 0x10028d4 CLUTTER_DEPRECATED_MACRO_FOR("Deprecated key symbol. Use CLUTTER_KEY_braille_dots_3578 instead.")
#define CLUTTER_braille_dots_13578 0x10028d5 CLUTTER_DEPRECATED_MACRO_FOR("Deprecated key symbol. Use CLUTTER_KEY_braille_dots_13578 instead.")
#define CLUTTER_braille_dots_23578 0x10028d6 CLUTTER_DEPRECATED_MACRO_FOR("Deprecated key symbol. Use CLUTTER_KEY_braille_dots_23578 instead.")
#define CLUTTER_braille_dots_123578 0x10028d7 CLUTTER_DEPRECATED_MACRO_FOR("Deprecated key symbol. Use CLUTTER_KEY_braille_dots_123578 instead.")
#define CLUTTER_braille_dots_4578 0x10028d8 CLUTTER_DEPRECATED_MACRO_FOR("Deprecated key symbol. Use CLUTTER_KEY_braille_dots_4578 instead.")
#define CLUTTER_braille_dots_14578 0x10028d9 CLUTTER_DEPRECATED_MACRO_FOR("Deprecated key symbol. Use CLUTTER_KEY_braille_dots_14578 instead.")
#define CLUTTER_braille_dots_24578 0x10028da CLUTTER_DEPRECATED_MACRO_FOR("Deprecated key symbol. Use CLUTTER_KEY_braille_dots_24578 instead.")
#define CLUTTER_braille_dots_124578 0x10028db CLUTTER_DEPRECATED_MACRO_FOR("Deprecated key symbol. Use CLUTTER_KEY_braille_dots_124578 instead.")
#define CLUTTER_braille_dots_34578 0x10028dc CLUTTER_DEPRECATED_MACRO_FOR("Deprecated key symbol. Use CLUTTER_KEY_braille_dots_34578 instead.")
#define CLUTTER_braille_dots_134578 0x10028dd CLUTTER_DEPRECATED_MACRO_FOR("Deprecated key symbol. Use CLUTTER_KEY_braille_dots_134578 instead.")
#define CLUTTER_braille_dots_234578 0x10028de CLUTTER_DEPRECATED_MACRO_FOR("Deprecated key symbol. Use CLUTTER_KEY_braille_dots_234578 instead.")
#define CLUTTER_braille_dots_1234578 0x10028df CLUTTER_DEPRECATED_MACRO_FOR("Deprecated key symbol. Use CLUTTER_KEY_braille_dots_1234578 instead.")
#define CLUTTER_braille_dots_678 0x10028e0 CLUTTER_DEPRECATED_MACRO_FOR("Deprecated key symbol. Use CLUTTER_KEY_braille_dots_678 instead.")
#define CLUTTER_braille_dots_1678 0x10028e1 CLUTTER_DEPRECATED_MACRO_FOR("Deprecated key symbol. Use CLUTTER_KEY_braille_dots_1678 instead.")
#define CLUTTER_braille_dots_2678 0x10028e2 CLUTTER_DEPRECATED_MACRO_FOR("Deprecated key symbol. Use CLUTTER_KEY_braille_dots_2678 instead.")
#define CLUTTER_braille_dots_12678 0x10028e3 CLUTTER_DEPRECATED_MACRO_FOR("Deprecated key symbol. Use CLUTTER_KEY_braille_dots_12678 instead.")
#define CLUTTER_braille_dots_3678 0x10028e4 CLUTTER_DEPRECATED_MACRO_FOR("Deprecated key symbol. Use CLUTTER_KEY_braille_dots_3678 instead.")
#define CLUTTER_braille_dots_13678 0x10028e5 CLUTTER_DEPRECATED_MACRO_FOR("Deprecated key symbol. Use CLUTTER_KEY_braille_dots_13678 instead.")
#define CLUTTER_braille_dots_23678 0x10028e6 CLUTTER_DEPRECATED_MACRO_FOR("Deprecated key symbol. Use CLUTTER_KEY_braille_dots_23678 instead.")
#define CLUTTER_braille_dots_123678 0x10028e7 CLUTTER_DEPRECATED_MACRO_FOR("Deprecated key symbol. Use CLUTTER_KEY_braille_dots_123678 instead.")
#define CLUTTER_braille_dots_4678 0x10028e8 CLUTTER_DEPRECATED_MACRO_FOR("Deprecated key symbol. Use CLUTTER_KEY_braille_dots_4678 instead.")
#define CLUTTER_braille_dots_14678 0x10028e9 CLUTTER_DEPRECATED_MACRO_FOR("Deprecated key symbol. Use CLUTTER_KEY_braille_dots_14678 instead.")
#define CLUTTER_braille_dots_24678 0x10028ea CLUTTER_DEPRECATED_MACRO_FOR("Deprecated key symbol. Use CLUTTER_KEY_braille_dots_24678 instead.")
#define CLUTTER_braille_dots_124678 0x10028eb CLUTTER_DEPRECATED_MACRO_FOR("Deprecated key symbol. Use CLUTTER_KEY_braille_dots_124678 instead.")
#define CLUTTER_braille_dots_34678 0x10028ec CLUTTER_DEPRECATED_MACRO_FOR("Deprecated key symbol. Use CLUTTER_KEY_braille_dots_34678 instead.")
#define CLUTTER_braille_dots_134678 0x10028ed CLUTTER_DEPRECATED_MACRO_FOR("Deprecated key symbol. Use CLUTTER_KEY_braille_dots_134678 instead.")
#define CLUTTER_braille_dots_234678 0x10028ee CLUTTER_DEPRECATED_MACRO_FOR("Deprecated key symbol. Use CLUTTER_KEY_braille_dots_234678 instead.")
#define CLUTTER_braille_dots_1234678 0x10028ef CLUTTER_DEPRECATED_MACRO_FOR("Deprecated key symbol. Use CLUTTER_KEY_braille_dots_1234678 instead.")
#define CLUTTER_braille_dots_5678 0x10028f0 CLUTTER_DEPRECATED_MACRO_FOR("Deprecated key symbol. Use CLUTTER_KEY_braille_dots_5678 instead.")
#define CLUTTER_braille_dots_15678 0x10028f1 CLUTTER_DEPRECATED_MACRO_FOR("Deprecated key symbol. Use CLUTTER_KEY_braille_dots_15678 instead.")
#define CLUTTER_braille_dots_25678 0x10028f2 CLUTTER_DEPRECATED_MACRO_FOR("Deprecated key symbol. Use CLUTTER_KEY_braille_dots_25678 instead.")
#define CLUTTER_braille_dots_125678 0x10028f3 CLUTTER_DEPRECATED_MACRO_FOR("Deprecated key symbol. Use CLUTTER_KEY_braille_dots_125678 instead.")
#define CLUTTER_braille_dots_35678 0x10028f4 CLUTTER_DEPRECATED_MACRO_FOR("Deprecated key symbol. Use CLUTTER_KEY_braille_dots_35678 instead.")
#define CLUTTER_braille_dots_135678 0x10028f5 CLUTTER_DEPRECATED_MACRO_FOR("Deprecated key symbol. Use CLUTTER_KEY_braille_dots_135678 instead.")
#define CLUTTER_braille_dots_235678 0x10028f6 CLUTTER_DEPRECATED_MACRO_FOR("Deprecated key symbol. Use CLUTTER_KEY_braille_dots_235678 instead.")
#define CLUTTER_braille_dots_1235678 0x10028f7 CLUTTER_DEPRECATED_MACRO_FOR("Deprecated key symbol. Use CLUTTER_KEY_braille_dots_1235678 instead.")
#define CLUTTER_braille_dots_45678 0x10028f8 CLUTTER_DEPRECATED_MACRO_FOR("Deprecated key symbol. Use CLUTTER_KEY_braille_dots_45678 instead.")
#define CLUTTER_braille_dots_145678 0x10028f9 CLUTTER_DEPRECATED_MACRO_FOR("Deprecated key symbol. Use CLUTTER_KEY_braille_dots_145678 instead.")
#define CLUTTER_braille_dots_245678 0x10028fa CLUTTER_DEPRECATED_MACRO_FOR("Deprecated key symbol. Use CLUTTER_KEY_braille_dots_245678 instead.")
#define CLUTTER_braille_dots_1245678 0x10028fb CLUTTER_DEPRECATED_MACRO_FOR("Deprecated key symbol. Use CLUTTER_KEY_braille_dots_1245678 instead.")
#define CLUTTER_braille_dots_345678 0x10028fc CLUTTER_DEPRECATED_MACRO_FOR("Deprecated key symbol. Use CLUTTER_KEY_braille_dots_345678 instead.")
#define CLUTTER_braille_dots_1345678 0x10028fd CLUTTER_DEPRECATED_MACRO_FOR("Deprecated key symbol. Use CLUTTER_KEY_braille_dots_1345678 instead.")
#define CLUTTER_braille_dots_2345678 0x10028fe CLUTTER_DEPRECATED_MACRO_FOR("Deprecated key symbol. Use CLUTTER_KEY_braille_dots_2345678 instead.")
#define CLUTTER_braille_dots_12345678 0x10028ff CLUTTER_DEPRECATED_MACRO_FOR("Deprecated key symbol. Use CLUTTER_KEY_braille_dots_12345678 instead.")
#define CLUTTER_Sinh_ng 0x1000d82 CLUTTER_DEPRECATED_MACRO_FOR("Deprecated key symbol. Use CLUTTER_KEY_Sinh_ng instead.")
#define CLUTTER_Sinh_h2 0x1000d83 CLUTTER_DEPRECATED_MACRO_FOR("Deprecated key symbol. Use CLUTTER_KEY_Sinh_h2 instead.")
#define CLUTTER_Sinh_a 0x1000d85 CLUTTER_DEPRECATED_MACRO_FOR("Deprecated key symbol. Use CLUTTER_KEY_Sinh_a instead.")
#define CLUTTER_Sinh_aa 0x1000d86 CLUTTER_DEPRECATED_MACRO_FOR("Deprecated key symbol. Use CLUTTER_KEY_Sinh_aa instead.")
#define CLUTTER_Sinh_ae 0x1000d87 CLUTTER_DEPRECATED_MACRO_FOR("Deprecated key symbol. Use CLUTTER_KEY_Sinh_ae instead.")
#define CLUTTER_Sinh_aee 0x1000d88 CLUTTER_DEPRECATED_MACRO_FOR("Deprecated key symbol. Use CLUTTER_KEY_Sinh_aee instead.")
#define CLUTTER_Sinh_i 0x1000d89 CLUTTER_DEPRECATED_MACRO_FOR("Deprecated key symbol. Use CLUTTER_KEY_Sinh_i instead.")
#define CLUTTER_Sinh_ii 0x1000d8a CLUTTER_DEPRECATED_MACRO_FOR("Deprecated key symbol. Use CLUTTER_KEY_Sinh_ii instead.")
#define CLUTTER_Sinh_u 0x1000d8b CLUTTER_DEPRECATED_MACRO_FOR("Deprecated key symbol. Use CLUTTER_KEY_Sinh_u instead.")
#define CLUTTER_Sinh_uu 0x1000d8c CLUTTER_DEPRECATED_MACRO_FOR("Deprecated key symbol. Use CLUTTER_KEY_Sinh_uu instead.")
#define CLUTTER_Sinh_ri 0x1000d8d CLUTTER_DEPRECATED_MACRO_FOR("Deprecated key symbol. Use CLUTTER_KEY_Sinh_ri instead.")
#define CLUTTER_Sinh_rii 0x1000d8e CLUTTER_DEPRECATED_MACRO_FOR("Deprecated key symbol. Use CLUTTER_KEY_Sinh_rii instead.")
#define CLUTTER_Sinh_lu 0x1000d8f CLUTTER_DEPRECATED_MACRO_FOR("Deprecated key symbol. Use CLUTTER_KEY_Sinh_lu instead.")
#define CLUTTER_Sinh_luu 0x1000d90 CLUTTER_DEPRECATED_MACRO_FOR("Deprecated key symbol. Use CLUTTER_KEY_Sinh_luu instead.")
#define CLUTTER_Sinh_e 0x1000d91 CLUTTER_DEPRECATED_MACRO_FOR("Deprecated key symbol. Use CLUTTER_KEY_Sinh_e instead.")
#define CLUTTER_Sinh_ee 0x1000d92 CLUTTER_DEPRECATED_MACRO_FOR("Deprecated key symbol. Use CLUTTER_KEY_Sinh_ee instead.")
#define CLUTTER_Sinh_ai 0x1000d93 CLUTTER_DEPRECATED_MACRO_FOR("Deprecated key symbol. Use CLUTTER_KEY_Sinh_ai instead.")
#define CLUTTER_Sinh_o 0x1000d94 CLUTTER_DEPRECATED_MACRO_FOR("Deprecated key symbol. Use CLUTTER_KEY_Sinh_o instead.")
#define CLUTTER_Sinh_oo 0x1000d95 CLUTTER_DEPRECATED_MACRO_FOR("Deprecated key symbol. Use CLUTTER_KEY_Sinh_oo instead.")
#define CLUTTER_Sinh_au 0x1000d96 CLUTTER_DEPRECATED_MACRO_FOR("Deprecated key symbol. Use CLUTTER_KEY_Sinh_au instead.")
#define CLUTTER_Sinh_ka 0x1000d9a CLUTTER_DEPRECATED_MACRO_FOR("Deprecated key symbol. Use CLUTTER_KEY_Sinh_ka instead.")
#define CLUTTER_Sinh_kha 0x1000d9b CLUTTER_DEPRECATED_MACRO_FOR("Deprecated key symbol. Use CLUTTER_KEY_Sinh_kha instead.")
#define CLUTTER_Sinh_ga 0x1000d9c CLUTTER_DEPRECATED_MACRO_FOR("Deprecated key symbol. Use CLUTTER_KEY_Sinh_ga instead.")
#define CLUTTER_Sinh_gha 0x1000d9d CLUTTER_DEPRECATED_MACRO_FOR("Deprecated key symbol. Use CLUTTER_KEY_Sinh_gha instead.")
#define CLUTTER_Sinh_ng2 0x1000d9e CLUTTER_DEPRECATED_MACRO_FOR("Deprecated key symbol. Use CLUTTER_KEY_Sinh_ng2 instead.")
#define CLUTTER_Sinh_nga 0x1000d9f CLUTTER_DEPRECATED_MACRO_FOR("Deprecated key symbol. Use CLUTTER_KEY_Sinh_nga instead.")
#define CLUTTER_Sinh_ca 0x1000da0 CLUTTER_DEPRECATED_MACRO_FOR("Deprecated key symbol. Use CLUTTER_KEY_Sinh_ca instead.")
#define CLUTTER_Sinh_cha 0x1000da1 CLUTTER_DEPRECATED_MACRO_FOR("Deprecated key symbol. Use CLUTTER_KEY_Sinh_cha instead.")
#define CLUTTER_Sinh_ja 0x1000da2 CLUTTER_DEPRECATED_MACRO_FOR("Deprecated key symbol. Use CLUTTER_KEY_Sinh_ja instead.")
#define CLUTTER_Sinh_jha 0x1000da3 CLUTTER_DEPRECATED_MACRO_FOR("Deprecated key symbol. Use CLUTTER_KEY_Sinh_jha instead.")
#define CLUTTER_Sinh_nya 0x1000da4 CLUTTER_DEPRECATED_MACRO_FOR("Deprecated key symbol. Use CLUTTER_KEY_Sinh_nya instead.")
#define CLUTTER_Sinh_jnya 0x1000da5 CLUTTER_DEPRECATED_MACRO_FOR("Deprecated key symbol. Use CLUTTER_KEY_Sinh_jnya instead.")
#define CLUTTER_Sinh_nja 0x1000da6 CLUTTER_DEPRECATED_MACRO_FOR("Deprecated key symbol. Use CLUTTER_KEY_Sinh_nja instead.")
#define CLUTTER_Sinh_tta 0x1000da7 CLUTTER_DEPRECATED_MACRO_FOR("Deprecated key symbol. Use CLUTTER_KEY_Sinh_tta instead.")
#define CLUTTER_Sinh_ttha 0x1000da8 CLUTTER_DEPRECATED_MACRO_FOR("Deprecated key symbol. Use CLUTTER_KEY_Sinh_ttha instead.")
#define CLUTTER_Sinh_dda 0x1000da9 CLUTTER_DEPRECATED_MACRO_FOR("Deprecated key symbol. Use CLUTTER_KEY_Sinh_dda instead.")
#define CLUTTER_Sinh_ddha 0x1000daa CLUTTER_DEPRECATED_MACRO_FOR("Deprecated key symbol. Use CLUTTER_KEY_Sinh_ddha instead.")
#define CLUTTER_Sinh_nna 0x1000dab CLUTTER_DEPRECATED_MACRO_FOR("Deprecated key symbol. Use CLUTTER_KEY_Sinh_nna instead.")
#define CLUTTER_Sinh_ndda 0x1000dac CLUTTER_DEPRECATED_MACRO_FOR("Deprecated key symbol. Use CLUTTER_KEY_Sinh_ndda instead.")
#define CLUTTER_Sinh_tha 0x1000dad CLUTTER_DEPRECATED_MACRO_FOR("Deprecated key symbol. Use CLUTTER_KEY_Sinh_tha instead.")
#define CLUTTER_Sinh_thha 0x1000dae CLUTTER_DEPRECATED_MACRO_FOR("Deprecated key symbol. Use CLUTTER_KEY_Sinh_thha instead.")
#define CLUTTER_Sinh_dha 0x1000daf CLUTTER_DEPRECATED_MACRO_FOR("Deprecated key symbol. Use CLUTTER_KEY_Sinh_dha instead.")
#define CLUTTER_Sinh_dhha 0x1000db0 CLUTTER_DEPRECATED_MACRO_FOR("Deprecated key symbol. Use CLUTTER_KEY_Sinh_dhha instead.")
#define CLUTTER_Sinh_na 0x1000db1 CLUTTER_DEPRECATED_MACRO_FOR("Deprecated key symbol. Use CLUTTER_KEY_Sinh_na instead.")
#define CLUTTER_Sinh_ndha 0x1000db3 CLUTTER_DEPRECATED_MACRO_FOR("Deprecated key symbol. Use CLUTTER_KEY_Sinh_ndha instead.")
#define CLUTTER_Sinh_pa 0x1000db4 CLUTTER_DEPRECATED_MACRO_FOR("Deprecated key symbol. Use CLUTTER_KEY_Sinh_pa instead.")
#define CLUTTER_Sinh_pha 0x1000db5 CLUTTER_DEPRECATED_MACRO_FOR("Deprecated key symbol. Use CLUTTER_KEY_Sinh_pha instead.")
#define CLUTTER_Sinh_ba 0x1000db6 CLUTTER_DEPRECATED_MACRO_FOR("Deprecated key symbol. Use CLUTTER_KEY_Sinh_ba instead.")
#define CLUTTER_Sinh_bha 0x1000db7 CLUTTER_DEPRECATED_MACRO_FOR("Deprecated key symbol. Use CLUTTER_KEY_Sinh_bha instead.")
#define CLUTTER_Sinh_ma 0x1000db8 CLUTTER_DEPRECATED_MACRO_FOR("Deprecated key symbol. Use CLUTTER_KEY_Sinh_ma instead.")
#define CLUTTER_Sinh_mba 0x1000db9 CLUTTER_DEPRECATED_MACRO_FOR("Deprecated key symbol. Use CLUTTER_KEY_Sinh_mba instead.")
#define CLUTTER_Sinh_ya 0x1000dba CLUTTER_DEPRECATED_MACRO_FOR("Deprecated key symbol. Use CLUTTER_KEY_Sinh_ya instead.")
#define CLUTTER_Sinh_ra 0x1000dbb CLUTTER_DEPRECATED_MACRO_FOR("Deprecated key symbol. Use CLUTTER_KEY_Sinh_ra instead.")
#define CLUTTER_Sinh_la 0x1000dbd CLUTTER_DEPRECATED_MACRO_FOR("Deprecated key symbol. Use CLUTTER_KEY_Sinh_la instead.")
#define CLUTTER_Sinh_va 0x1000dc0 CLUTTER_DEPRECATED_MACRO_FOR("Deprecated key symbol. Use CLUTTER_KEY_Sinh_va instead.")
#define CLUTTER_Sinh_sha 0x1000dc1 CLUTTER_DEPRECATED_MACRO_FOR("Deprecated key symbol. Use CLUTTER_KEY_Sinh_sha instead.")
#define CLUTTER_Sinh_ssha 0x1000dc2 CLUTTER_DEPRECATED_MACRO_FOR("Deprecated key symbol. Use CLUTTER_KEY_Sinh_ssha instead.")
#define CLUTTER_Sinh_sa 0x1000dc3 CLUTTER_DEPRECATED_MACRO_FOR("Deprecated key symbol. Use CLUTTER_KEY_Sinh_sa instead.")
#define CLUTTER_Sinh_ha 0x1000dc4 CLUTTER_DEPRECATED_MACRO_FOR("Deprecated key symbol. Use CLUTTER_KEY_Sinh_ha instead.")
#define CLUTTER_Sinh_lla 0x1000dc5 CLUTTER_DEPRECATED_MACRO_FOR("Deprecated key symbol. Use CLUTTER_KEY_Sinh_lla instead.")
#define CLUTTER_Sinh_fa 0x1000dc6 CLUTTER_DEPRECATED_MACRO_FOR("Deprecated key symbol. Use CLUTTER_KEY_Sinh_fa instead.")
#define CLUTTER_Sinh_al 0x1000dca CLUTTER_DEPRECATED_MACRO_FOR("Deprecated key symbol. Use CLUTTER_KEY_Sinh_al instead.")
#define CLUTTER_Sinh_aa2 0x1000dcf CLUTTER_DEPRECATED_MACRO_FOR("Deprecated key symbol. Use CLUTTER_KEY_Sinh_aa2 instead.")
#define CLUTTER_Sinh_ae2 0x1000dd0 CLUTTER_DEPRECATED_MACRO_FOR("Deprecated key symbol. Use CLUTTER_KEY_Sinh_ae2 instead.")
#define CLUTTER_Sinh_aee2 0x1000dd1 CLUTTER_DEPRECATED_MACRO_FOR("Deprecated key symbol. Use CLUTTER_KEY_Sinh_aee2 instead.")
#define CLUTTER_Sinh_i2 0x1000dd2 CLUTTER_DEPRECATED_MACRO_FOR("Deprecated key symbol. Use CLUTTER_KEY_Sinh_i2 instead.")
#define CLUTTER_Sinh_ii2 0x1000dd3 CLUTTER_DEPRECATED_MACRO_FOR("Deprecated key symbol. Use CLUTTER_KEY_Sinh_ii2 instead.")
#define CLUTTER_Sinh_u2 0x1000dd4 CLUTTER_DEPRECATED_MACRO_FOR("Deprecated key symbol. Use CLUTTER_KEY_Sinh_u2 instead.")
#define CLUTTER_Sinh_uu2 0x1000dd6 CLUTTER_DEPRECATED_MACRO_FOR("Deprecated key symbol. Use CLUTTER_KEY_Sinh_uu2 instead.")
#define CLUTTER_Sinh_ru2 0x1000dd8 CLUTTER_DEPRECATED_MACRO_FOR("Deprecated key symbol. Use CLUTTER_KEY_Sinh_ru2 instead.")
#define CLUTTER_Sinh_e2 0x1000dd9 CLUTTER_DEPRECATED_MACRO_FOR("Deprecated key symbol. Use CLUTTER_KEY_Sinh_e2 instead.")
#define CLUTTER_Sinh_ee2 0x1000dda CLUTTER_DEPRECATED_MACRO_FOR("Deprecated key symbol. Use CLUTTER_KEY_Sinh_ee2 instead.")
#define CLUTTER_Sinh_ai2 0x1000ddb CLUTTER_DEPRECATED_MACRO_FOR("Deprecated key symbol. Use CLUTTER_KEY_Sinh_ai2 instead.")
#define CLUTTER_Sinh_o2 0x1000ddc CLUTTER_DEPRECATED_MACRO_FOR("Deprecated key symbol. Use CLUTTER_KEY_Sinh_o2 instead.")
#define CLUTTER_Sinh_oo2 0x1000ddd CLUTTER_DEPRECATED_MACRO_FOR("Deprecated key symbol. Use CLUTTER_KEY_Sinh_oo2 instead.")
#define CLUTTER_Sinh_au2 0x1000dde CLUTTER_DEPRECATED_MACRO_FOR("Deprecated key symbol. Use CLUTTER_KEY_Sinh_au2 instead.")
#define CLUTTER_Sinh_lu2 0x1000ddf CLUTTER_DEPRECATED_MACRO_FOR("Deprecated key symbol. Use CLUTTER_KEY_Sinh_lu2 instead.")
#define CLUTTER_Sinh_ruu2 0x1000df2 CLUTTER_DEPRECATED_MACRO_FOR("Deprecated key symbol. Use CLUTTER_KEY_Sinh_ruu2 instead.")
#define CLUTTER_Sinh_luu2 0x1000df3 CLUTTER_DEPRECATED_MACRO_FOR("Deprecated key symbol. Use CLUTTER_KEY_Sinh_luu2 instead.")
#define CLUTTER_Sinh_kunddaliya 0x1000df4 CLUTTER_DEPRECATED_MACRO_FOR("Deprecated key symbol. Use CLUTTER_KEY_Sinh_kunddaliya instead.")
#define CLUTTER_ModeLock 0x1008ff01
#define CLUTTER_MonBrightnessUp 0x1008ff02
#define CLUTTER_MonBrightnessDown 0x1008ff03
#define CLUTTER_KbdLightOnOff 0x1008ff04
#define CLUTTER_KbdBrightnessUp 0x1008ff05
#define CLUTTER_KbdBrightnessDown 0x1008ff06
#define CLUTTER_Standby 0x1008ff10
#define CLUTTER_AudioLowerVolume 0x1008ff11
#define CLUTTER_AudioMute 0x1008ff12
#define CLUTTER_AudioRaiseVolume 0x1008ff13
#define CLUTTER_AudioPlay 0x1008ff14
#define CLUTTER_AudioStop 0x1008ff15
#define CLUTTER_AudioPrev 0x1008ff16
#define CLUTTER_AudioNext 0x1008ff17
#define CLUTTER_HomePage 0x1008ff18
#define CLUTTER_Mail 0x1008ff19
#define CLUTTER_Start 0x1008ff1a
#define CLUTTER_Search 0x1008ff1b
#define CLUTTER_AudioRecord 0x1008ff1c
#define CLUTTER_Calculator 0x1008ff1d
#define CLUTTER_Memo 0x1008ff1e
#define CLUTTER_ToDoList 0x1008ff1f
#define CLUTTER_Calendar 0x1008ff20
#define CLUTTER_PowerDown 0x1008ff21
#define CLUTTER_ContrastAdjust 0x1008ff22
#define CLUTTER_RockerUp 0x1008ff23
#define CLUTTER_RockerDown 0x1008ff24
#define CLUTTER_RockerEnter 0x1008ff25
#define CLUTTER_Back 0x1008ff26
#define CLUTTER_Forward 0x1008ff27
#define CLUTTER_Stop 0x1008ff28
#define CLUTTER_Refresh 0x1008ff29
#define CLUTTER_PowerOff 0x1008ff2a
#define CLUTTER_WakeUp 0x1008ff2b
#define CLUTTER_Eject 0x1008ff2c
#define CLUTTER_ScreenSaver 0x1008ff2d
#define CLUTTER_WWW 0x1008ff2e
#define CLUTTER_Sleep 0x1008ff2f
#define CLUTTER_Favorites 0x1008ff30
#define CLUTTER_AudioPause 0x1008ff31
#define CLUTTER_AudioMedia 0x1008ff32
#define CLUTTER_MyComputer 0x1008ff33
#define CLUTTER_VendorHome 0x1008ff34
#define CLUTTER_LightBulb 0x1008ff35
#define CLUTTER_Shop 0x1008ff36
#define CLUTTER_History 0x1008ff37
#define CLUTTER_OpenURL 0x1008ff38
#define CLUTTER_AddFavorite 0x1008ff39
#define CLUTTER_HotLinks 0x1008ff3a
#define CLUTTER_BrightnessAdjust 0x1008ff3b
#define CLUTTER_Finance 0x1008ff3c
#define CLUTTER_Community 0x1008ff3d
#define CLUTTER_AudioRewind 0x1008ff3e
#define CLUTTER_BackForward 0x1008ff3f
#define CLUTTER_Launch0 0x1008ff40
#define CLUTTER_Launch1 0x1008ff41
#define CLUTTER_Launch2 0x1008ff42
#define CLUTTER_Launch3 0x1008ff43
#define CLUTTER_Launch4 0x1008ff44
#define CLUTTER_Launch5 0x1008ff45
#define CLUTTER_Launch6 0x1008ff46
#define CLUTTER_Launch7 0x1008ff47
#define CLUTTER_Launch8 0x1008ff48
#define CLUTTER_Launch9 0x1008ff49
#define CLUTTER_LaunchA 0x1008ff4a
#define CLUTTER_LaunchB 0x1008ff4b
#define CLUTTER_LaunchC 0x1008ff4c
#define CLUTTER_LaunchD 0x1008ff4d
#define CLUTTER_LaunchE 0x1008ff4e
#define CLUTTER_LaunchF 0x1008ff4f
#define CLUTTER_ApplicationLeft 0x1008ff50
#define CLUTTER_ApplicationRight 0x1008ff51
#define CLUTTER_Book 0x1008ff52
#define CLUTTER_CD 0x1008ff53
#define CLUTTER_WindowClear 0x1008ff55
#define CLUTTER_Close 0x1008ff56
#define CLUTTER_Copy 0x1008ff57
#define CLUTTER_Cut 0x1008ff58
#define CLUTTER_Display 0x1008ff59
#define CLUTTER_DOS 0x1008ff5a
#define CLUTTER_Documents 0x1008ff5b
#define CLUTTER_Excel 0x1008ff5c
#define CLUTTER_Explorer 0x1008ff5d
#define CLUTTER_Game 0x1008ff5e
#define CLUTTER_Go 0x1008ff5f
#define CLUTTER_iTouch 0x1008ff60
#define CLUTTER_LogOff 0x1008ff61
#define CLUTTER_Market 0x1008ff62
#define CLUTTER_Meeting 0x1008ff63
#define CLUTTER_MenuKB 0x1008ff65
#define CLUTTER_MenuPB 0x1008ff66
#define CLUTTER_MySites 0x1008ff67
#define CLUTTER_New 0x1008ff68
#define CLUTTER_News 0x1008ff69
#define CLUTTER_OfficeHome 0x1008ff6a
#define CLUTTER_Open 0x1008ff6b
#define CLUTTER_Option 0x1008ff6c
#define CLUTTER_Paste 0x1008ff6d
#define CLUTTER_Phone 0x1008ff6e
#define CLUTTER_Reply 0x1008ff72
#define CLUTTER_Reload 0x1008ff73
#define CLUTTER_RotateWindows 0x1008ff74
#define CLUTTER_RotationPB 0x1008ff75
#define CLUTTER_RotationKB 0x1008ff76
#define CLUTTER_Save 0x1008ff77
#define CLUTTER_ScrollUp 0x1008ff78
#define CLUTTER_ScrollDown 0x1008ff79
#define CLUTTER_ScrollClick 0x1008ff7a
#define CLUTTER_Send 0x1008ff7b
#define CLUTTER_Spell 0x1008ff7c
#define CLUTTER_SplitScreen 0x1008ff7d
#define CLUTTER_Support 0x1008ff7e
#define CLUTTER_TaskPane 0x1008ff7f
#define CLUTTER_Terminal 0x1008ff80
#define CLUTTER_Tools 0x1008ff81
#define CLUTTER_Travel 0x1008ff82
#define CLUTTER_UserPB 0x1008ff84
#define CLUTTER_User1KB 0x1008ff85
#define CLUTTER_User2KB 0x1008ff86
#define CLUTTER_Video 0x1008ff87
#define CLUTTER_WheelButton 0x1008ff88
#define CLUTTER_Word 0x1008ff89
#define CLUTTER_Xfer 0x1008ff8a
#define CLUTTER_ZoomIn 0x1008ff8b
#define CLUTTER_ZoomOut 0x1008ff8c
#define CLUTTER_Away 0x1008ff8d
#define CLUTTER_Messenger 0x1008ff8e
#define CLUTTER_WebCam 0x1008ff8f
#define CLUTTER_MailForward 0x1008ff90
#define CLUTTER_Pictures 0x1008ff91
#define CLUTTER_Music 0x1008ff92
#define CLUTTER_Battery 0x1008ff93
#define CLUTTER_Bluetooth 0x1008ff94
#define CLUTTER_WLAN 0x1008ff95
#define CLUTTER_UWB 0x1008ff96
#define CLUTTER_AudioForward 0x1008ff97
#define CLUTTER_AudioRepeat 0x1008ff98
#define CLUTTER_AudioRandomPlay 0x1008ff99
#define CLUTTER_Subtitle 0x1008ff9a
#define CLUTTER_AudioCycleTrack 0x1008ff9b
#define CLUTTER_CycleAngle 0x1008ff9c
#define CLUTTER_FrameBack 0x1008ff9d
#define CLUTTER_FrameForward 0x1008ff9e
#define CLUTTER_Time 0x1008ff9f
#define CLUTTER_SelectButton 0x1008ffa0
#define CLUTTER_View 0x1008ffa1
#define CLUTTER_TopMenu 0x1008ffa2
#define CLUTTER_Red 0x1008ffa3
#define CLUTTER_Green 0x1008ffa4
#define CLUTTER_Yellow 0x1008ffa5
#define CLUTTER_Blue 0x1008ffa6
#define CLUTTER_Suspend 0x1008ffa7
#define CLUTTER_Hibernate 0x1008ffa8
#define CLUTTER_TouchpadToggle 0x1008ffa9
#define CLUTTER_TouchpadOn 0x1008ffb0
#define CLUTTER_TouchpadOff 0x1008ffb1
#define CLUTTER_AudioMicMute 0x1008ffb2
#define CLUTTER_Switch_VT_1 0x1008fe01
#define CLUTTER_Switch_VT_2 0x1008fe02
#define CLUTTER_Switch_VT_3 0x1008fe03
#define CLUTTER_Switch_VT_4 0x1008fe04
#define CLUTTER_Switch_VT_5 0x1008fe05
#define CLUTTER_Switch_VT_6 0x1008fe06
#define CLUTTER_Switch_VT_7 0x1008fe07
#define CLUTTER_Switch_VT_8 0x1008fe08
#define CLUTTER_Switch_VT_9 0x1008fe09
#define CLUTTER_Switch_VT_10 0x1008fe0a
#define CLUTTER_Switch_VT_11 0x1008fe0b
#define CLUTTER_Switch_VT_12 0x1008fe0c
#define CLUTTER_Ungrab 0x1008fe20
#define CLUTTER_ClearGrab 0x1008fe21
#define CLUTTER_Next_VMode 0x1008fe22
#define CLUTTER_Prev_VMode 0x1008fe23
#define CLUTTER_LogWindowTree 0x1008fe24
#define CLUTTER_LogGrabInfo 0x1008fe25

#endif /* CLUTTER_DISABLE_DEPRECATED */

#endif /* __CLUTTER_KEYSYMS_DEPRECATED_H__ */
