/*
 * Decompiled with CFR 0.152.
 */
package com.dickimawbooks.texparserlib.primitives;

import com.dickimawbooks.texparserlib.AssignedMacro;
import com.dickimawbooks.texparserlib.Expandable;
import com.dickimawbooks.texparserlib.TeXCsRef;
import com.dickimawbooks.texparserlib.TeXObject;
import com.dickimawbooks.texparserlib.TeXObjectList;
import com.dickimawbooks.texparserlib.TeXParser;
import com.dickimawbooks.texparserlib.TeXSyntaxException;
import com.dickimawbooks.texparserlib.primitives.Else;
import com.dickimawbooks.texparserlib.primitives.Fi;
import com.dickimawbooks.texparserlib.primitives.Primitive;
import java.io.IOException;

public class If
extends Primitive
implements Expandable {
    public If() {
        this("if");
    }

    public If(String string) {
        super(string, true);
    }

    @Override
    public Object clone() {
        return new If(this.getName());
    }

    @Override
    public TeXObjectList expandonce(TeXParser teXParser, TeXObjectList teXObjectList) throws IOException {
        TeXObjectList teXObjectList2 = new TeXObjectList();
        if (this.istrue(teXParser, teXObjectList)) {
            this.doTruePart(teXParser, teXObjectList, teXObjectList2);
        } else {
            this.doFalsePart(teXParser, teXObjectList, teXObjectList2);
        }
        return teXObjectList2;
    }

    @Override
    public TeXObjectList expandonce(TeXParser teXParser) throws IOException {
        TeXObjectList teXObjectList = new TeXObjectList();
        if (this.istrue(teXParser, teXParser)) {
            this.doTruePart(teXParser, teXParser, teXObjectList);
        } else {
            this.doFalsePart(teXParser, teXParser, teXObjectList);
        }
        return teXObjectList;
    }

    @Override
    public TeXObjectList expandfully(TeXParser teXParser, TeXObjectList teXObjectList) throws IOException {
        return this.expandonce(teXParser, teXObjectList).expandfully(teXParser, teXObjectList);
    }

    @Override
    public TeXObjectList expandfully(TeXParser teXParser) throws IOException {
        return this.expandonce(teXParser).expandfully(teXParser);
    }

    @Override
    public void process(TeXParser teXParser, TeXObjectList teXObjectList) throws IOException {
        if (this.istrue(teXParser, teXObjectList)) {
            this.doTruePart(teXParser, teXObjectList);
        } else {
            this.doFalsePart(teXParser, teXObjectList);
        }
    }

    @Override
    public void process(TeXParser teXParser) throws IOException {
        if (this.istrue(teXParser, teXParser)) {
            this.doTruePart(teXParser, teXParser);
        } else {
            this.doFalsePart(teXParser, teXParser);
        }
    }

    public boolean istrue(TeXParser teXParser, TeXObjectList teXObjectList) throws IOException {
        byte by = TeXObjectList.POP_IGNORE_LEADING_SPACE;
        TeXObject teXObject = teXParser.popToken(by);
        TeXObject teXObject2 = teXParser.popToken(by);
        if (teXObject instanceof TeXCsRef) {
            teXObject = teXParser.getControlSequence(((TeXCsRef)teXObject).getName());
        }
        if (teXObject2 instanceof TeXCsRef) {
            teXObject2 = teXParser.getControlSequence(((TeXCsRef)teXObject2).getName());
        }
        if (teXObject == teXObject2) {
            return true;
        }
        if (teXObject == null || teXObject2 == null) {
            return false;
        }
        if (teXObject instanceof AssignedMacro) {
            teXObject = ((AssignedMacro)teXObject).getUnderlying();
        }
        if (teXObject2 instanceof AssignedMacro) {
            teXObject2 = ((AssignedMacro)teXObject2).getUnderlying();
        }
        return teXObject.equals(teXObject2);
    }

    protected void doTruePart(TeXParser teXParser, TeXObjectList teXObjectList) throws IOException {
        this.doTruePart(teXParser, teXObjectList, null);
    }

    protected void doTruePart(TeXParser teXParser, TeXObjectList teXObjectList, TeXObjectList teXObjectList2) throws IOException {
        TeXObjectList teXObjectList3;
        TeXObject teXObject = teXObjectList.popToken();
        if (teXObject instanceof Expandable && (teXObjectList3 = teXParser == teXObjectList ? ((Expandable)((Object)teXObject)).expandfully(teXParser) : ((Expandable)((Object)teXObject)).expandfully(teXParser, teXObjectList)) != null) {
            teXObjectList.addAll(0, teXObjectList3);
            teXObject = teXObjectList.popToken();
        }
        if (teXObject instanceof Else) {
            this.skipToFi(teXParser, teXObjectList);
        } else if (!(teXObject instanceof Fi)) {
            if (teXObjectList2 == null) {
                if (teXParser == teXObjectList) {
                    teXObject.process(teXParser);
                } else {
                    teXObject.process(teXParser, teXObjectList);
                }
            } else {
                teXObjectList2.add(teXObject);
            }
            this.doTruePart(teXParser, teXObjectList, teXObjectList2);
        }
    }

    protected void skipToFi(TeXParser teXParser, TeXObjectList teXObjectList) throws IOException {
        TeXObject teXObject = teXObjectList.popToken();
        if (teXObject instanceof TeXCsRef) {
            teXObject = teXParser.getListener().getControlSequence(((TeXCsRef)teXObject).getName());
        }
        if (teXObject == null) {
            throw new TeXSyntaxException(teXParser, "tex.error.expected", "\\fi");
        }
        if (!(teXObject instanceof Fi)) {
            this.skipToFi(teXParser, teXObjectList);
        }
    }

    protected boolean skipToElse(TeXParser teXParser, TeXObjectList teXObjectList) throws IOException {
        TeXObject teXObject = teXObjectList.popToken();
        if (teXObject instanceof TeXCsRef) {
            teXObject = teXParser.getListener().getControlSequence(((TeXCsRef)teXObject).getName());
        }
        if (teXObject == null) {
            throw new TeXSyntaxException(teXParser, "tex.error.expected", "\\fi");
        }
        if (teXObject instanceof Fi) {
            return false;
        }
        if (teXObject instanceof Else) {
            return true;
        }
        return this.skipToElse(teXParser, teXObjectList);
    }

    protected void doFalsePart(TeXParser teXParser, TeXObjectList teXObjectList) throws IOException {
        this.doFalsePart(teXParser, teXObjectList, null);
    }

    protected void doFalsePart(TeXParser teXParser, TeXObjectList teXObjectList, TeXObjectList teXObjectList2) throws IOException {
        if (!this.skipToElse(teXParser, teXObjectList)) {
            return;
        }
        this.doRemainingFalsePart(teXParser, teXObjectList, teXObjectList2);
    }

    protected void doRemainingFalsePart(TeXParser teXParser, TeXObjectList teXObjectList, TeXObjectList teXObjectList2) throws IOException {
        TeXObjectList teXObjectList3;
        TeXObject teXObject = teXObjectList.popToken();
        if (teXObject instanceof Expandable && (teXObjectList3 = teXParser == teXObjectList ? ((Expandable)((Object)teXObject)).expandfully(teXParser) : ((Expandable)((Object)teXObject)).expandfully(teXParser, teXObjectList)) != null) {
            teXObjectList.addAll(0, teXObjectList3);
            teXObject = teXObjectList.popToken();
        }
        if (!(teXObject instanceof Fi)) {
            if (teXObjectList2 == null) {
                if (teXParser == teXObjectList) {
                    teXObject.process(teXParser);
                } else {
                    teXObject.process(teXParser, teXObjectList);
                }
            } else {
                teXObjectList2.add(teXObject);
            }
            this.doFalsePart(teXParser, teXObjectList, teXObjectList2);
        }
    }

    @Override
    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (object == null || !(object instanceof TeXObject)) {
            return false;
        }
        if (object instanceof AssignedMacro) {
            return ((AssignedMacro)object).getUnderlying().equals(this);
        }
        return object.getClass().getName().equals(this.getClass().getName());
    }
}

