/*
 * Decompiled with CFR 0.152.
 */
package javafx.scene.paint;

import com.sun.javafx.beans.event.AbstractNotifyListener;
import com.sun.javafx.tk.Toolkit;
import javafx.beans.NamedArg;
import javafx.scene.image.Image;
import javafx.scene.paint.Paint;

public final class ImagePattern
extends Paint {
    private Image image;
    private double x;
    private double y;
    private double width = 1.0;
    private double height = 1.0;
    private boolean proportional = true;
    private Object platformPaint;

    public final Image getImage() {
        return this.image;
    }

    public final double getX() {
        return this.x;
    }

    public final double getY() {
        return this.y;
    }

    public final double getWidth() {
        return this.width;
    }

    public final double getHeight() {
        return this.height;
    }

    public final boolean isProportional() {
        return this.proportional;
    }

    @Override
    public final boolean isOpaque() {
        return ((com.sun.prism.paint.ImagePattern)this.acc_getPlatformPaint()).isOpaque();
    }

    public ImagePattern(@NamedArg(value="image") Image image) {
        if (image == null) {
            throw new NullPointerException("Image must be non-null.");
        }
        if (image.getProgress() < 1.0) {
            throw new IllegalArgumentException("Image not yet loaded");
        }
        this.image = image;
    }

    public ImagePattern(@NamedArg(value="image") Image image, @NamedArg(value="x") double x, @NamedArg(value="y") double y, @NamedArg(value="width") double width, @NamedArg(value="height") double height, @NamedArg(value="proportional") boolean proportional) {
        if (image == null) {
            throw new NullPointerException("Image must be non-null.");
        }
        if (image.getProgress() < 1.0) {
            throw new IllegalArgumentException("Image not yet loaded");
        }
        this.image = image;
        this.x = x;
        this.y = y;
        this.width = width;
        this.height = height;
        this.proportional = proportional;
    }

    @Override
    boolean acc_isMutable() {
        return Toolkit.getImageAccessor().isAnimation(this.image);
    }

    @Override
    void acc_addListener(AbstractNotifyListener platformChangeListener) {
        Toolkit.getImageAccessor().getImageProperty(this.image).addListener(platformChangeListener);
    }

    @Override
    void acc_removeListener(AbstractNotifyListener platformChangeListener) {
        Toolkit.getImageAccessor().getImageProperty(this.image).removeListener(platformChangeListener);
    }

    @Override
    Object acc_getPlatformPaint() {
        if (this.acc_isMutable() || this.platformPaint == null) {
            this.platformPaint = Toolkit.getToolkit().getPaint(this);
            assert (this.platformPaint != null);
        }
        return this.platformPaint;
    }
}

