/*
 * Decompiled with CFR 0.152.
 */
package javafx.geometry;

import javafx.beans.NamedArg;

public class Point3D {
    public static final Point3D ZERO = new Point3D(0.0, 0.0, 0.0);
    private double x;
    private double y;
    private double z;
    private int hash = 0;

    public final double getX() {
        return this.x;
    }

    public final double getY() {
        return this.y;
    }

    public final double getZ() {
        return this.z;
    }

    public Point3D(@NamedArg(value="x") double x, @NamedArg(value="y") double y, @NamedArg(value="z") double z) {
        this.x = x;
        this.y = y;
        this.z = z;
    }

    public double distance(double x1, double y1, double z1) {
        double a = this.getX() - x1;
        double b = this.getY() - y1;
        double c = this.getZ() - z1;
        return Math.sqrt(a * a + b * b + c * c);
    }

    public double distance(Point3D point) {
        return this.distance(point.getX(), point.getY(), point.getZ());
    }

    public Point3D add(double x, double y, double z) {
        return new Point3D(this.getX() + x, this.getY() + y, this.getZ() + z);
    }

    public Point3D add(Point3D point) {
        return this.add(point.getX(), point.getY(), point.getZ());
    }

    public Point3D subtract(double x, double y, double z) {
        return new Point3D(this.getX() - x, this.getY() - y, this.getZ() - z);
    }

    public Point3D subtract(Point3D point) {
        return this.subtract(point.getX(), point.getY(), point.getZ());
    }

    public Point3D multiply(double factor) {
        return new Point3D(this.getX() * factor, this.getY() * factor, this.getZ() * factor);
    }

    public Point3D normalize() {
        double mag = this.magnitude();
        if (mag == 0.0) {
            return new Point3D(0.0, 0.0, 0.0);
        }
        return new Point3D(this.getX() / mag, this.getY() / mag, this.getZ() / mag);
    }

    public Point3D midpoint(double x, double y, double z) {
        return new Point3D(x + (this.getX() - x) / 2.0, y + (this.getY() - y) / 2.0, z + (this.getZ() - z) / 2.0);
    }

    public Point3D midpoint(Point3D point) {
        return this.midpoint(point.getX(), point.getY(), point.getZ());
    }

    public double angle(double x, double y, double z) {
        double az;
        double ay;
        double ax = this.getX();
        double delta = (ax * x + (ay = this.getY()) * y + (az = this.getZ()) * z) / Math.sqrt((ax * ax + ay * ay + az * az) * (x * x + y * y + z * z));
        if (delta > 1.0) {
            return 0.0;
        }
        if (delta < -1.0) {
            return 180.0;
        }
        return Math.toDegrees(Math.acos(delta));
    }

    public double angle(Point3D point) {
        return this.angle(point.getX(), point.getY(), point.getZ());
    }

    public double angle(Point3D p1, Point3D p2) {
        double bz;
        double by;
        double x = this.getX();
        double y = this.getY();
        double z = this.getZ();
        double ax = p1.getX() - x;
        double ay = p1.getY() - y;
        double az = p1.getZ() - z;
        double bx = p2.getX() - x;
        double delta = (ax * bx + ay * (by = p2.getY() - y) + az * (bz = p2.getZ() - z)) / Math.sqrt((ax * ax + ay * ay + az * az) * (bx * bx + by * by + bz * bz));
        if (delta > 1.0) {
            return 0.0;
        }
        if (delta < -1.0) {
            return 180.0;
        }
        return Math.toDegrees(Math.acos(delta));
    }

    public double magnitude() {
        double x = this.getX();
        double y = this.getY();
        double z = this.getZ();
        return Math.sqrt(x * x + y * y + z * z);
    }

    public double dotProduct(double x, double y, double z) {
        return this.getX() * x + this.getY() * y + this.getZ() * z;
    }

    public double dotProduct(Point3D vector) {
        return this.dotProduct(vector.getX(), vector.getY(), vector.getZ());
    }

    public Point3D crossProduct(double x, double y, double z) {
        double ax = this.getX();
        double ay = this.getY();
        double az = this.getZ();
        return new Point3D(ay * z - az * y, az * x - ax * z, ax * y - ay * x);
    }

    public Point3D crossProduct(Point3D vector) {
        return this.crossProduct(vector.getX(), vector.getY(), vector.getZ());
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj instanceof Point3D) {
            Point3D other = (Point3D)obj;
            return this.getX() == other.getX() && this.getY() == other.getY() && this.getZ() == other.getZ();
        }
        return false;
    }

    public int hashCode() {
        if (this.hash == 0) {
            long bits = 7L;
            bits = 31L * bits + Double.doubleToLongBits(this.getX());
            bits = 31L * bits + Double.doubleToLongBits(this.getY());
            bits = 31L * bits + Double.doubleToLongBits(this.getZ());
            this.hash = (int)(bits ^ bits >> 32);
        }
        return this.hash;
    }

    public String toString() {
        return "Point3D [x = " + this.getX() + ", y = " + this.getY() + ", z = " + this.getZ() + "]";
    }
}

