/*
 * Decompiled with CFR 0.152.
 */
package org.parosproxy.paros.extension.report;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.IOException;
import java.io.StringReader;
import java.io.StringWriter;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.text.SimpleDateFormat;
import java.util.Date;
import javax.swing.JOptionPane;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import javax.xml.transform.stream.StreamSource;
import net.sf.json.xml.XMLSerializer;
import org.apache.commons.lang.StringEscapeUtils;
import org.apache.log4j.Logger;
import org.parosproxy.paros.Constant;
import org.parosproxy.paros.view.View;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.zaproxy.zap.utils.XMLStringUtil;
import org.zaproxy.zap.utils.XmlUtils;

public class ReportGenerator {
    private static final Logger logger = Logger.getLogger(ReportGenerator.class);
    private static final SimpleDateFormat staticDateFormat = new SimpleDateFormat("EEE, d MMM yyyy HH:mm:ss");

    public static File XMLToHtml(Document xmlDocument, String infilexsl, File outFile) {
        File stylesheet = null;
        outFile = new File(outFile.getAbsolutePath());
        try {
            stylesheet = new File(infilexsl);
            DOMSource source = new DOMSource(xmlDocument);
            TransformerFactory tFactory = TransformerFactory.newInstance();
            StreamSource stylesource = new StreamSource(stylesheet);
            Transformer transformer = tFactory.newTransformer(stylesource);
            StreamResult result = new StreamResult(outFile);
            transformer.transform(source, result);
        }
        catch (TransformerException e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
        }
        return outFile;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static File stringToHtml(String inxml, String infilexsl, String outfilename) {
        if (infilexsl != null) {
            Document doc = null;
            File stylesheet = null;
            File outfile = null;
            StringReader inReader = new StringReader(inxml);
            String tempOutfilename = outfilename + ".temp";
            try {
                stylesheet = new File(infilexsl);
                outfile = new File(tempOutfilename);
                DocumentBuilder builder = XmlUtils.newXxeDisabledDocumentBuilderFactory().newDocumentBuilder();
                doc = builder.parse(new InputSource(inReader));
                TransformerFactory tFactory = TransformerFactory.newInstance();
                StreamSource stylesource = new StreamSource(stylesheet);
                Transformer transformer = tFactory.newTransformer(stylesource);
                DOMSource source = new DOMSource(doc);
                StreamResult result = new StreamResult(outfile);
                transformer.transform(source, result);
            }
            catch (IOException | ParserConfigurationException | TransformerException | SAXException e) {
                logger.error((Object)e.getMessage(), (Throwable)e);
                BufferedWriter bw = null;
                ReportGenerator.showDialogForGUI();
                try {
                    bw = Files.newBufferedWriter(new File(outfilename + "-orig.xml").toPath(), StandardCharsets.UTF_8, new OpenOption[0]);
                    bw.write(inxml);
                    return new File(outfilename);
                }
                catch (IOException e2) {
                    logger.error((Object)"Failed to write debug XML file", (Throwable)e);
                    File transformer = new File(outfilename);
                    return transformer;
                }
                finally {
                    try {
                        if (bw != null) {
                            bw.close();
                        }
                    }
                    catch (IOException iOException) {}
                }
            }
            BufferedReader br = null;
            BufferedWriter bw = null;
            try {
                String line;
                br = Files.newBufferedReader(new File(tempOutfilename).toPath(), StandardCharsets.UTF_8);
                bw = Files.newBufferedWriter(new File(outfilename).toPath(), StandardCharsets.UTF_8, new OpenOption[0]);
                while ((line = br.readLine()) != null) {
                    bw.write(line.replace("&lt;p&gt;", "<p>").replace("&lt;/p&gt;", "</p>"));
                    bw.newLine();
                }
            }
            catch (IOException e) {
                ReportGenerator.showDialogForGUI();
                logger.error((Object)e.getMessage(), (Throwable)e);
            }
            finally {
                try {
                    if (br != null) {
                        br.close();
                    }
                    if (bw != null) {
                        bw.close();
                    }
                }
                catch (IOException iOException) {}
            }
            outfile.delete();
            return new File(outfilename);
        }
        BufferedWriter bw = null;
        try {
            bw = Files.newBufferedWriter(new File(outfilename).toPath(), StandardCharsets.UTF_8, new OpenOption[0]);
            bw.write(inxml);
            return new File(outfilename);
        }
        catch (IOException e2) {
            ReportGenerator.showDialogForGUI();
            logger.error((Object)e2.getMessage(), (Throwable)e2);
            return new File(outfilename);
        }
        finally {
            try {
                if (bw != null) {
                    bw.close();
                }
            }
            catch (IOException iOException) {}
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static File stringToJson(String inxml, String outfilename) {
        BufferedWriter bw = null;
        try {
            bw = Files.newBufferedWriter(new File(outfilename).toPath(), StandardCharsets.UTF_8, new OpenOption[0]);
            bw.write(ReportGenerator.stringToJson(inxml));
        }
        catch (IOException e2) {
            ReportGenerator.showDialogForGUI();
            logger.error((Object)e2.getMessage(), (Throwable)e2);
        }
        finally {
            try {
                if (bw != null) {
                    bw.close();
                }
            }
            catch (IOException iOException) {}
        }
        return new File(outfilename);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String stringToHtml(String inxml, String infilexsl) {
        Document doc = null;
        File stylesheet = null;
        StringReader inReader = new StringReader(inxml);
        StringWriter writer = new StringWriter();
        try {
            stylesheet = new File(infilexsl);
            DocumentBuilder builder = XmlUtils.newXxeDisabledDocumentBuilderFactory().newDocumentBuilder();
            doc = builder.parse(new InputSource(inReader));
            TransformerFactory tFactory = TransformerFactory.newInstance();
            StreamSource stylesource = new StreamSource(stylesheet);
            Transformer transformer = tFactory.newTransformer(stylesource);
            DOMSource source = new DOMSource(doc);
            StreamResult result = new StreamResult(writer);
            transformer.transform(source, result);
        }
        catch (IOException | ParserConfigurationException | TransformerException | SAXException e) {
            ReportGenerator.showDialogForGUI();
            logger.error((Object)e.getMessage(), (Throwable)e);
        }
        return writer.toString().replace("&lt;p&gt;", "<p>").replace("&lt;/p&gt;", "</p>");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static File fileToHtml(String infilexml, String infilexsl, String outfilename) {
        Document doc = null;
        File stylesheet = null;
        File datafile = null;
        File outfile = null;
        try {
            stylesheet = new File(infilexsl);
            datafile = new File(infilexml);
            outfile = new File(outfilename);
            DocumentBuilder builder = XmlUtils.newXxeDisabledDocumentBuilderFactory().newDocumentBuilder();
            doc = builder.parse(datafile);
            TransformerFactory tFactory = TransformerFactory.newInstance();
            StreamSource stylesource = new StreamSource(stylesheet);
            Transformer transformer = tFactory.newTransformer(stylesource);
            DOMSource source = new DOMSource(doc);
            StreamResult result = new StreamResult(outfile);
            transformer.transform(source, result);
        }
        catch (IOException | ParserConfigurationException | TransformerException | SAXException e) {
            ReportGenerator.showDialogForGUI();
            logger.error((Object)e.getMessage(), (Throwable)e);
        }
        return outfile;
    }

    public static String stringToJson(String inxml) {
        return new XMLSerializer().read(inxml).toString();
    }

    public static String entityEncode(String text) {
        String result = text;
        if (result == null) {
            return result;
        }
        return StringEscapeUtils.escapeXml((String)XMLStringUtil.escapeControlChrs(result));
    }

    public static String getCurrentDateTimeString() {
        Date dateTime = new Date(System.currentTimeMillis());
        return ReportGenerator.getDateTimeString(dateTime);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String getDateTimeString(Date dateTime) {
        SimpleDateFormat simpleDateFormat = staticDateFormat;
        synchronized (simpleDateFormat) {
            return staticDateFormat.format(dateTime);
        }
    }

    public static void addChildTextNode(Document doc, Element parent, String nodeName, String text) {
        Element child = doc.createElement(nodeName);
        child.appendChild(doc.createTextNode(text));
        parent.appendChild(child);
    }

    public static String getDebugXMLString(Document doc) throws TransformerException {
        TransformerFactory tf = TransformerFactory.newInstance();
        Transformer transformer = tf.newTransformer();
        transformer.setOutputProperty("omit-xml-declaration", "yes");
        StringWriter writer = new StringWriter();
        transformer.transform(new DOMSource(doc), new StreamResult(writer));
        return writer.getBuffer().toString().replaceAll("\n|\r", "");
    }

    private static void showDialogForGUI() {
        if (View.isInitialised()) {
            JOptionPane.showMessageDialog(null, Constant.messages.getString("report.write.dialog.message"));
        }
    }
}

