/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.util.gotoByName;

import com.intellij.ide.DataManager;
import com.intellij.ide.SearchTopHitProvider;
import com.intellij.ide.actions.ApplyIntentionAction;
import com.intellij.ide.ui.OptionsTopHitProvider;
import com.intellij.ide.ui.search.ActionFromOptionDescriptorProvider;
import com.intellij.ide.ui.search.OptionDescription;
import com.intellij.ide.ui.search.SearchableOptionsRegistrar;
import com.intellij.ide.ui.search.SearchableOptionsRegistrarImpl;
import com.intellij.ide.util.gotoByName.ChooseByNameBase;
import com.intellij.ide.util.gotoByName.ChooseByNameItemProvider;
import com.intellij.ide.util.gotoByName.GotoActionModel;
import com.intellij.openapi.actionSystem.AbbreviationManager;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.actionSystem.impl.ActionManagerImpl;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.NotNullLazyValue;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.codeStyle.MinusculeMatcher;
import com.intellij.psi.codeStyle.NameUtil;
import com.intellij.ui.switcher.QuickActionProvider;
import com.intellij.util.CollectConsumer;
import com.intellij.util.Consumer;
import com.intellij.util.Processor;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.JBIterable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jetbrains.annotations.NotNull;

public class GotoActionItemProvider
implements ChooseByNameItemProvider {
    private final ActionManager myActionManager = ActionManager.getInstance();
    private final GotoActionModel myModel;
    private final NotNullLazyValue<Map<String, ApplyIntentionAction>> myIntentions;
    private static final Logger LOG = Logger.getInstance(GotoActionItemProvider.class);

    public GotoActionItemProvider(GotoActionModel model) {
        this.myModel = model;
        this.myIntentions = NotNullLazyValue.createValue(() -> (Map)ReadAction.compute(() -> this.myModel.getAvailableIntentions()));
    }

    @Override
    @NotNull
    public List<String> filterNames(@NotNull ChooseByNameBase base, @NotNull String[] names, @NotNull String pattern) {
        if (base == null) {
            GotoActionItemProvider.$$$reportNull$$$0(0);
        }
        if (names == null) {
            GotoActionItemProvider.$$$reportNull$$$0(1);
        }
        if (pattern == null) {
            GotoActionItemProvider.$$$reportNull$$$0(2);
        }
        List<String> list2 = Collections.emptyList();
        if (list2 == null) {
            GotoActionItemProvider.$$$reportNull$$$0(3);
        }
        return list2;
    }

    @Override
    public boolean filterElements(@NotNull ChooseByNameBase base, @NotNull String pattern, boolean everywhere, @NotNull ProgressIndicator cancelled, @NotNull Processor<Object> consumer) {
        if (base == null) {
            GotoActionItemProvider.$$$reportNull$$$0(4);
        }
        if (pattern == null) {
            GotoActionItemProvider.$$$reportNull$$$0(5);
        }
        if (cancelled == null) {
            GotoActionItemProvider.$$$reportNull$$$0(6);
        }
        if (consumer == null) {
            GotoActionItemProvider.$$$reportNull$$$0(7);
        }
        return this.filterElements(pattern, (Processor<GotoActionModel.MatchedValue>)((Processor)value -> {
            if (!everywhere && value.value instanceof GotoActionModel.ActionWrapper && !((GotoActionModel.ActionWrapper)value.value).isAvailable()) {
                return true;
            }
            return consumer.process(value);
        }));
    }

    public boolean filterElements(String pattern, Processor<GotoActionModel.MatchedValue> consumer) {
        DataContext dataContext = DataManager.getInstance().getDataContext(this.myModel.getContextComponent());
        if (!this.processAbbreviations(pattern, consumer, dataContext)) {
            return false;
        }
        if (!this.processIntentions(pattern, consumer, dataContext)) {
            return false;
        }
        if (!this.processActions(pattern, consumer, dataContext)) {
            return false;
        }
        if (Registry.is((String)"goto.action.skip.tophits.and.options")) {
            return true;
        }
        if (!this.processTopHits(pattern, consumer, dataContext)) {
            return false;
        }
        return this.processOptions(pattern, consumer, dataContext);
    }

    private boolean processAbbreviations(String pattern, Processor<? super GotoActionModel.MatchedValue> consumer, DataContext context) {
        List actionIds = AbbreviationManager.getInstance().findActions(pattern);
        JBIterable wrappers = JBIterable.from((Iterable)actionIds).filterMap(arg_0 -> ((ActionManager)this.myActionManager).getAction(arg_0)).transform(action -> {
            GotoActionModel.ActionWrapper wrapper2 = this.wrapAnAction((AnAction)action, context);
            return new GotoActionModel.MatchedValue(wrapper2, pattern){

                @Override
                @NotNull
                public String getValueText() {
                    String string = this.pattern;
                    if (string == null) {
                        1.$$$reportNull$$$0(0);
                    }
                    return string;
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/ide/util/gotoByName/GotoActionItemProvider$1", "getValueText"));
                }
            };
        });
        return GotoActionItemProvider.processItems(pattern, (JBIterable<? extends Comparable>)wrappers, consumer);
    }

    private boolean processTopHits(String pattern, Processor<? super GotoActionModel.MatchedValue> consumer, DataContext dataContext) {
        Project project = (Project)CommonDataKeys.PROJECT.getData(dataContext);
        CollectConsumer collector = new CollectConsumer();
        String commandAccelerator = SearchTopHitProvider.getTopHitAccelerator();
        for (SearchTopHitProvider provider : (SearchTopHitProvider[])SearchTopHitProvider.EP_NAME.getExtensions()) {
            if (provider instanceof OptionsTopHitProvider.CoveredByToggleActions || provider instanceof OptionsTopHitProvider && !((OptionsTopHitProvider)provider).isEnabled(project)) continue;
            if (provider instanceof OptionsTopHitProvider && !StringUtil.startsWith((CharSequence)pattern, (CharSequence)commandAccelerator)) {
                String prefix = commandAccelerator + ((OptionsTopHitProvider)provider).getId() + " ";
                provider.consumeTopHits(prefix + pattern, (Consumer)collector, project);
            }
            provider.consumeTopHits(pattern, (Consumer)collector, project);
        }
        Collection result2 = collector.getResult();
        JBIterable wrappers = JBIterable.from((Iterable)result2).transform(object -> object instanceof AnAction ? this.wrapAnAction((AnAction)object, dataContext) : object).filter(Comparable.class);
        return GotoActionItemProvider.processItems(pattern, (JBIterable<? extends Comparable>)wrappers, consumer);
    }

    private boolean processOptions(String pattern, Processor<? super GotoActionModel.MatchedValue> consumer, DataContext dataContext) {
        Map<String, String> map = this.myModel.getConfigurablesNames();
        SearchableOptionsRegistrarImpl registrar = (SearchableOptionsRegistrarImpl)SearchableOptionsRegistrar.getInstance();
        ArrayList options = ContainerUtil.newArrayList();
        Set<String> words = registrar.getProcessedWords(pattern);
        Set<OptionDescription> optionDescriptions = null;
        String actionManagerName = this.myActionManager.getComponentName();
        for (String string : words) {
            Set<OptionDescription> set = registrar.getAcceptableDescriptions(string);
            if (set != null) {
                Iterator<OptionDescription> iterator = set.iterator();
                while (iterator.hasNext()) {
                    OptionDescription description = iterator.next();
                    if (!actionManagerName.equals(description.getPath())) continue;
                    iterator.remove();
                }
                if (set.isEmpty()) continue;
                if (optionDescriptions == null) {
                    optionDescriptions = set;
                    continue;
                }
                optionDescriptions.retainAll(set);
                continue;
            }
            optionDescriptions = null;
            break;
        }
        if (!StringUtil.isEmptyOrSpaces((String)pattern)) {
            MinusculeMatcher matcher = NameUtil.buildMatcher((String)("*" + pattern)).build();
            if (optionDescriptions == null) {
                optionDescriptions = ContainerUtil.newTroveSet();
            }
            for (Map.Entry<String, String> entry : map.entrySet()) {
                if (!matcher.matches(entry.getValue())) continue;
                optionDescriptions.add(new OptionDescription(null, entry.getKey(), entry.getValue(), null, entry.getValue()));
            }
        }
        if (optionDescriptions != null && !optionDescriptions.isEmpty()) {
            HashSet<String> currentHits = new HashSet<String>();
            Iterator iterator = optionDescriptions.iterator();
            while (iterator.hasNext()) {
                OptionDescription optionDescription = (OptionDescription)iterator.next();
                String hit = optionDescription.getHit();
                if (hit != null && currentHits.add(hit.trim())) continue;
                iterator.remove();
            }
            for (OptionDescription optionDescription : optionDescriptions) {
                for (ActionFromOptionDescriptorProvider converter : (ActionFromOptionDescriptorProvider[])ActionFromOptionDescriptorProvider.EP.getExtensions()) {
                    AnAction action = converter.provide(optionDescription);
                    if (action != null) {
                        options.add(new GotoActionModel.ActionWrapper(action, null, GotoActionModel.MatchMode.NAME, dataContext, this.myModel));
                    }
                    options.add(optionDescription);
                }
            }
        }
        return GotoActionItemProvider.processItems(pattern, (JBIterable<? extends Comparable>)JBIterable.from((Iterable)options), consumer);
    }

    private boolean processActions(String pattern, Processor<? super GotoActionModel.MatchedValue> consumer, DataContext dataContext) {
        Set<String> ids = ((ActionManagerImpl)this.myActionManager).getActionIds();
        JBIterable actions = JBIterable.from(ids).filterMap(arg_0 -> ((ActionManager)this.myActionManager).getAction(arg_0));
        MinusculeMatcher matcher = GotoActionItemProvider.buildMatcher(pattern);
        QuickActionProvider provider = (QuickActionProvider)dataContext.getData(QuickActionProvider.KEY);
        if (provider != null) {
            actions = actions.append((Iterable)provider.getActions(true));
        }
        JBIterable actionWrappers = actions.unique().filterMap(action -> {
            GotoActionModel.MatchMode mode = this.myModel.actionMatches(pattern, matcher, (AnAction)action);
            if (mode == GotoActionModel.MatchMode.NONE) {
                return null;
            }
            return new GotoActionModel.ActionWrapper((AnAction)action, this.myModel.getGroupMapping((AnAction)action), mode, dataContext, this.myModel);
        });
        return GotoActionItemProvider.processItems(pattern, (JBIterable<? extends Comparable>)actionWrappers, consumer);
    }

    @NotNull
    static MinusculeMatcher buildMatcher(String pattern) {
        MinusculeMatcher minusculeMatcher = NameUtil.buildMatcher((String)("*" + pattern), (NameUtil.MatchingCaseSensitivity)NameUtil.MatchingCaseSensitivity.NONE);
        if (minusculeMatcher == null) {
            GotoActionItemProvider.$$$reportNull$$$0(8);
        }
        return minusculeMatcher;
    }

    private boolean processIntentions(String pattern, Processor<? super GotoActionModel.MatchedValue> consumer, DataContext dataContext) {
        MinusculeMatcher matcher = GotoActionItemProvider.buildMatcher(pattern);
        Map intentionMap = (Map)this.myIntentions.getValue();
        JBIterable intentions = JBIterable.from(intentionMap.keySet()).filterMap(intentionText -> {
            ApplyIntentionAction intentionAction = (ApplyIntentionAction)((Object)((Object)intentionMap.get(intentionText)));
            if (this.myModel.actionMatches(pattern, matcher, intentionAction) == GotoActionModel.MatchMode.NONE) {
                return null;
            }
            GotoActionModel.GroupMapping groupMapping = GotoActionModel.GroupMapping.createFromText(intentionText);
            return new GotoActionModel.ActionWrapper(intentionAction, groupMapping, GotoActionModel.MatchMode.INTENTION, dataContext, this.myModel);
        });
        return GotoActionItemProvider.processItems(pattern, (JBIterable<? extends Comparable>)intentions, consumer);
    }

    @NotNull
    private GotoActionModel.ActionWrapper wrapAnAction(@NotNull AnAction action, DataContext dataContext) {
        if (action == null) {
            GotoActionItemProvider.$$$reportNull$$$0(9);
        }
        GotoActionModel.ActionWrapper actionWrapper = new GotoActionModel.ActionWrapper(action, this.myModel.getGroupMapping(action), GotoActionModel.MatchMode.NAME, dataContext, this.myModel);
        if (actionWrapper == null) {
            GotoActionItemProvider.$$$reportNull$$$0(10);
        }
        return actionWrapper;
    }

    private static boolean processItems(String pattern, JBIterable<? extends Comparable> items, Processor<? super GotoActionModel.MatchedValue> consumer) {
        ArrayList matched = ContainerUtil.newArrayList((Iterable)items.map(o -> o instanceof GotoActionModel.MatchedValue ? (GotoActionModel.MatchedValue)o : new GotoActionModel.MatchedValue((Comparable)o, pattern)));
        try {
            Collections.sort(matched);
        }
        catch (IllegalArgumentException e) {
            LOG.error("Comparison method violates its general contract with pattern '" + pattern + "'", (Throwable)e);
        }
        return ContainerUtil.process((List)matched, consumer);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 3: 
            case 8: 
            case 10: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 3: 
            case 8: 
            case 10: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "base";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "names";
                break;
            }
            case 2: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "pattern";
                break;
            }
            case 3: 
            case 8: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/ide/util/gotoByName/GotoActionItemProvider";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "cancelled";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "consumer";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "action";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/ide/util/gotoByName/GotoActionItemProvider";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "filterNames";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "buildMatcher";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "wrapAnAction";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "filterNames";
                break;
            }
            case 3: 
            case 8: 
            case 10: {
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "filterElements";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "wrapAnAction";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 3: 
            case 8: 
            case 10: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

