/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.actions;

import com.intellij.openapi.ui.GraphicsConfig;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.wm.ToolWindow;
import com.intellij.ui.ColoredListCellRenderer;
import com.intellij.ui.SimpleTextAttributes;
import com.intellij.ui.SpeedSearchBase;
import com.intellij.util.IconUtil;
import com.intellij.util.PlatformIcons;
import com.intellij.util.ui.JBUI;
import java.awt.AlphaComposite;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.util.Map;
import javax.swing.Icon;
import javax.swing.JList;
import org.jetbrains.annotations.NotNull;

class SwitcherToolWindowsListRenderer
extends ColoredListCellRenderer {
    private final SpeedSearchBase mySpeedSearch;
    private final Map<ToolWindow, String> shortcuts;
    private final boolean myPinned;
    private boolean hide = false;

    SwitcherToolWindowsListRenderer(SpeedSearchBase speedSearch, Map<ToolWindow, String> shortcuts, boolean pinned) {
        this.mySpeedSearch = speedSearch;
        this.shortcuts = shortcuts;
        this.myPinned = pinned;
    }

    protected void customizeCellRenderer(@NotNull JList list2, Object value, int index, boolean selected, boolean hasFocus) {
        if (list2 == null) {
            SwitcherToolWindowsListRenderer.$$$reportNull$$$0(0);
        }
        this.hide = false;
        this.setPaintFocusBorder(false);
        if (value instanceof ToolWindow) {
            String name;
            ToolWindow tw = (ToolWindow)value;
            this.setIcon(SwitcherToolWindowsListRenderer.getIcon(tw));
            String stripeTitle = tw.getStripeTitle();
            String shortcut = this.shortcuts.get(tw);
            if (this.myPinned || shortcut == null) {
                name = stripeTitle;
            } else {
                this.append(shortcut, new SimpleTextAttributes(16, null));
                name = ": " + stripeTitle;
            }
            this.append(name);
            if (this.mySpeedSearch != null && this.mySpeedSearch.isPopupActive()) {
                this.hide = this.mySpeedSearch.matchingFragments(stripeTitle) == null && !StringUtil.isEmpty((String)this.mySpeedSearch.getEnteredPrefix());
            }
        }
    }

    protected void doPaint(Graphics2D g) {
        GraphicsConfig config2 = new GraphicsConfig((Graphics)g);
        if (this.hide) {
            g.setComposite(AlphaComposite.getInstance(3, 0.15f));
        }
        super.doPaint(g);
        config2.restore();
    }

    private static Icon getIcon(ToolWindow toolWindow) {
        Icon icon = toolWindow.getIcon();
        if (icon == null) {
            return PlatformIcons.UI_FORM_ICON;
        }
        icon = IconUtil.toSize((Icon)icon, (int)JBUI.scale((int)16), (int)JBUI.scale((int)16));
        return icon;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "list", "com/intellij/ide/actions/SwitcherToolWindowsListRenderer", "customizeCellRenderer"));
    }
}

