/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide;

import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationActivationListener;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.impl.ApplicationImpl;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.wm.IdeFrame;
import com.intellij.util.ui.UIUtil;
import java.awt.Component;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowEvent;
import java.util.concurrent.atomic.AtomicLong;
import javax.swing.Timer;

public class ApplicationActivationStateManager {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.ide.ApplicationActivationStateManager");
    private static final AtomicLong requestToDeactivateTime = new AtomicLong(System.currentTimeMillis());
    private static final ApplicationActivationStateManager instance = new ApplicationActivationStateManager();
    private static State state = State.DEACTIVATED;

    public static ApplicationActivationStateManager get() {
        return instance;
    }

    private ApplicationActivationStateManager() {
    }

    public static State getState() {
        return state;
    }

    public static boolean updateState(final WindowEvent windowEvent) {
        final Application application = ApplicationManager.getApplication();
        if (!(application instanceof ApplicationImpl)) {
            return false;
        }
        Window eventWindow = windowEvent.getWindow();
        if (windowEvent.getID() == 205 || windowEvent.getID() == 207) {
            if (state.isInactive()) {
                Window window = windowEvent.getWindow();
                return ApplicationActivationStateManager.setActive(application, window);
            }
        } else if (windowEvent.getID() == 206 && windowEvent.getOppositeWindow() == null) {
            IdeFrame ideFrame;
            requestToDeactivateTime.getAndSet(System.currentTimeMillis());
            if (state.isActive() && (ideFrame = ApplicationActivationStateManager.getIdeFrameFromWindow(windowEvent.getWindow())) != null) {
                ((ApplicationActivationListener)application.getMessageBus().syncPublisher(ApplicationActivationListener.TOPIC)).applicationDeactivated(ideFrame);
            }
            state = State.DEACTIVATING;
            LOG.debug("The app is in the deactivating state");
            Timer timer = UIUtil.createNamedTimer((String)"ApplicationDeactivation", (int)Registry.intValue((String)"application.deactivation.timeout"), (ActionListener)new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent evt) {
                    if (state == State.DEACTIVATING) {
                        state = State.DEACTIVATED;
                        LOG.debug("The app is in the deactivated state");
                        IdeFrame ideFrame = ApplicationActivationStateManager.getIdeFrameFromWindow(windowEvent.getWindow());
                        if (ideFrame != null) {
                            ((ApplicationActivationListener)application.getMessageBus().syncPublisher(ApplicationActivationListener.TOPIC)).delayedApplicationDeactivated(ideFrame);
                        }
                    }
                }
            });
            timer.setRepeats(false);
            timer.start();
            return true;
        }
        return false;
    }

    private static boolean setActive(Application application, Window window) {
        IdeFrame ideFrame = ApplicationActivationStateManager.getIdeFrameFromWindow(window);
        state = State.ACTIVE;
        LOG.debug("The app is in the active state");
        if (ideFrame != null) {
            ((ApplicationActivationListener)application.getMessageBus().syncPublisher(ApplicationActivationListener.TOPIC)).applicationActivated(ideFrame);
            return true;
        }
        return false;
    }

    public static void updateState(Window window) {
        Application application = ApplicationManager.getApplication();
        if (!(application instanceof ApplicationImpl)) {
            return;
        }
        if (state.isInactive() && window != null) {
            ApplicationActivationStateManager.setActive(application, window);
        }
    }

    private static IdeFrame getIdeFrameFromWindow(Window window) {
        Component frame = UIUtil.findUltimateParent((Component)window);
        return frame instanceof IdeFrame ? (IdeFrame)frame : null;
    }

    public static enum State {
        ACTIVE,
        DEACTIVATED,
        DEACTIVATING;


        public boolean isInactive() {
            return this != ACTIVE;
        }

        public boolean isActive() {
            return this == ACTIVE;
        }
    }
}

