/*
 * Decompiled with CFR 0.152.
 */
package processing.app.contrib;

import java.awt.EventQueue;
import java.io.File;
import java.lang.reflect.InvocationTargetException;
import java.net.MalformedURLException;
import java.net.URL;
import java.text.Normalizer;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.locks.ReentrantLock;
import java.util.regex.Pattern;
import processing.app.Base;
import processing.app.Library;
import processing.app.Util;
import processing.app.contrib.AvailableContribution;
import processing.app.contrib.ContribProgressMonitor;
import processing.app.contrib.Contribution;
import processing.app.contrib.ContributionManager;
import processing.app.contrib.ContributionType;
import processing.app.contrib.ExamplesContribution;
import processing.app.contrib.ModeContribution;
import processing.app.contrib.ToolContribution;
import processing.core.PApplet;
import processing.data.StringDict;

public class ContributionListing {
    static volatile ContributionListing singleInstance;
    static final String LISTING_URL = "http://download.processing.org/contribs";
    static final String LOCAL_FILENAME = "contribs.txt";
    File listingFile;
    List<ChangeListener> listeners = new ArrayList<ChangeListener>();
    List<AvailableContribution> advertisedContributions = new ArrayList<AvailableContribution>();
    Map<String, List<Contribution>> librariesByCategory = new HashMap<String, List<Contribution>>();
    Map<String, Contribution> librariesByImportHeader = new HashMap<String, Contribution>();
    Set<Contribution> allContributions = new LinkedHashSet<Contribution>();
    boolean listDownloaded;
    boolean listDownloadFailed;
    ReentrantLock downloadingListingLock = new ReentrantLock();
    public static Comparator<Contribution> COMPARATOR;

    static {
        COMPARATOR = Comparator.comparing(o -> o.getName().toLowerCase());
    }

    private ContributionListing() {
        this.listingFile = Base.getSettingsFile(LOCAL_FILENAME);
        this.listingFile.setWritable(true, false);
        if (this.listingFile.exists()) {
            this.setAdvertisedList(this.listingFile);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static ContributionListing getInstance() {
        if (singleInstance != null) return singleInstance;
        Class<ContributionListing> clazz = ContributionListing.class;
        synchronized (ContributionListing.class) {
            if (singleInstance != null) return singleInstance;
            singleInstance = new ContributionListing();
            // ** MonitorExit[var0] (shouldn't be in output)
            return singleInstance;
        }
    }

    private void setAdvertisedList(File file) {
        this.listingFile = file;
        this.advertisedContributions.clear();
        this.advertisedContributions.addAll(this.parseContribList(this.listingFile));
        for (Contribution contribution : this.advertisedContributions) {
            this.addContribution(contribution);
        }
    }

    protected void updateInstalledList(List<Contribution> installed) {
        for (Contribution contribution : installed) {
            Contribution existingContribution = this.getContribution(contribution);
            if (existingContribution != null) {
                this.replaceContribution(existingContribution, contribution);
                continue;
            }
            this.addContribution(contribution);
        }
    }

    protected void replaceContribution(Contribution oldLib, Contribution newLib) {
        if (oldLib != null && newLib != null) {
            for (String category : oldLib.getCategories()) {
                if (!this.librariesByCategory.containsKey(category)) continue;
                List<Contribution> list = this.librariesByCategory.get(category);
                int i = 0;
                while (i < list.size()) {
                    if (list.get(i) == oldLib) {
                        list.set(i, newLib);
                    }
                    ++i;
                }
            }
            if (oldLib.getImports() != null) {
                for (String importName : oldLib.getImports()) {
                    if (!this.getLibrariesByImportHeader().containsKey(importName)) continue;
                    this.getLibrariesByImportHeader().put(importName, newLib);
                }
            }
            this.allContributions.remove(oldLib);
            this.allContributions.add(newLib);
            this.notifyChange(oldLib, newLib);
        }
    }

    private void addContribution(Contribution contribution) {
        if (contribution.getImports() != null) {
            for (String importName : contribution.getImports()) {
                this.getLibrariesByImportHeader().put(importName, contribution);
            }
        }
        for (String category : contribution.getCategories()) {
            List<Object> list;
            if (this.librariesByCategory.containsKey(category)) {
                list = this.librariesByCategory.get(category);
                list.add(contribution);
                Collections.sort(list, COMPARATOR);
            } else {
                list = new ArrayList<Contribution>();
                ((ArrayList)list).add(contribution);
                this.librariesByCategory.put(category, list);
            }
            this.allContributions.add(contribution);
            this.notifyAdd(contribution);
        }
    }

    protected void removeContribution(Contribution contribution) {
        for (String category : contribution.getCategories()) {
            if (!this.librariesByCategory.containsKey(category)) continue;
            this.librariesByCategory.get(category).remove(contribution);
        }
        if (contribution.getImports() != null) {
            for (String importName : contribution.getImports()) {
                this.getLibrariesByImportHeader().remove(importName);
            }
        }
        this.allContributions.remove(contribution);
        this.notifyRemove(contribution);
    }

    private Contribution getContribution(Contribution contribution) {
        for (Contribution c : this.allContributions) {
            if (!c.getName().equals(contribution.getName()) || c.getType() != contribution.getType()) continue;
            return c;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected AvailableContribution getAvailableContribution(Contribution info) {
        List<AvailableContribution> list = this.advertisedContributions;
        synchronized (list) {
            for (AvailableContribution advertised : this.advertisedContributions) {
                if (advertised.getType() != info.getType() || !advertised.getName().equals(info.getName())) continue;
                return advertised;
            }
        }
        return null;
    }

    protected Set<String> getCategories(Contribution.Filter filter) {
        HashSet<String> outgoing = new HashSet<String>();
        Set<String> categorySet = this.librariesByCategory.keySet();
        block0: for (String categoryName : categorySet) {
            for (Contribution contrib : this.librariesByCategory.get(categoryName)) {
                if (!filter.matches(contrib)) continue;
                if (categoryName == null || categoryName.trim().isEmpty()) continue block0;
                outgoing.add(categoryName);
                continue block0;
            }
        }
        return outgoing;
    }

    public boolean matches(Contribution contrib, String typed) {
        int colon = typed.indexOf(":");
        if (colon != -1) {
            String isText = typed.substring(0, colon);
            String property = typed.substring(colon + 1);
            if (!ContributionListing.isProperty(property)) {
                return true;
            }
            if ("is".equals(isText) || "has".equals(isText)) {
                return this.hasProperty(contrib, typed.substring(colon + 1));
            }
            if ("not".equals(isText)) {
                return !this.hasProperty(contrib, typed.substring(colon + 1));
            }
        }
        typed = ".*" + typed.toLowerCase() + ".*";
        return ContributionListing.matchField(contrib.getName(), typed) || ContributionListing.matchField(contrib.getAuthorList(), typed) || ContributionListing.matchField(contrib.getSentence(), typed) || ContributionListing.matchField(contrib.getParagraph(), typed) || contrib.hasCategory(typed);
    }

    private static boolean matchField(String field, String typed) {
        return field != null && ContributionListing.removeAccents(field.toLowerCase()).matches(typed);
    }

    private static String removeAccents(String str) {
        String nfdNormalizedString = Normalizer.normalize(str, Normalizer.Form.NFD);
        Pattern pattern = Pattern.compile("\\p{InCombiningDiacriticalMarks}+");
        return pattern.matcher(nfdNormalizedString).replaceAll("");
    }

    private static boolean isProperty(String property) {
        return property.startsWith("updat") || property.startsWith("upgrad") || property.startsWith("instal") && !property.startsWith("installabl") || property.equals("tool") || property.startsWith("lib") || property.equals("mode") || property.equals("compilation");
    }

    private boolean hasProperty(Contribution contrib, String property) {
        if (property.startsWith("updat") || property.startsWith("upgrad")) {
            return this.hasUpdates(contrib);
        }
        if (property.startsWith("instal") && !property.startsWith("installabl")) {
            return contrib.isInstalled();
        }
        if (property.equals("tool")) {
            return contrib.getType() == ContributionType.TOOL;
        }
        if (property.startsWith("lib")) {
            return contrib.getType() == ContributionType.LIBRARY;
        }
        if (property.equals("mode")) {
            return contrib.getType() == ContributionType.MODE;
        }
        return false;
    }

    private void notifyRemove(Contribution contribution) {
        for (ChangeListener listener : this.listeners) {
            listener.contributionRemoved(contribution);
        }
    }

    private void notifyAdd(Contribution contribution) {
        for (ChangeListener listener : this.listeners) {
            listener.contributionAdded(contribution);
        }
    }

    private void notifyChange(Contribution oldLib, Contribution newLib) {
        for (ChangeListener listener : this.listeners) {
            listener.contributionChanged(oldLib, newLib);
        }
    }

    protected void addListener(ChangeListener listener) {
        for (Contribution contrib : this.allContributions) {
            listener.contributionAdded(contrib);
        }
        this.listeners.add(listener);
    }

    public void downloadAvailableList(final Base base, final ContribProgressMonitor progress) {
        new Thread(new Runnable(){

            @Override
            public void run() {
                block11: {
                    ContributionListing.this.downloadingListingLock.lock();
                    try {
                        try {
                            URL url = new URL(ContributionListing.LISTING_URL);
                            File tempContribFile = Base.getSettingsFile("contribs.tmp");
                            tempContribFile.setWritable(true, false);
                            ContributionManager.download(url, base.getInstalledContribsInfo(), tempContribFile, progress);
                            if (progress.isCanceled() || progress.isError()) break block11;
                            if (ContributionListing.this.listingFile.exists()) {
                                ContributionListing.this.listingFile.delete();
                            }
                            if (tempContribFile.renameTo(ContributionListing.this.listingFile)) {
                                ContributionListing.this.listDownloaded = true;
                                ContributionListing.this.listDownloadFailed = false;
                                try {
                                    EventQueue.invokeAndWait(new Runnable(){

                                        @Override
                                        public void run() {
                                            ContributionListing.this.setAdvertisedList((this).ContributionListing.this.listingFile);
                                            base.setUpdatesAvailable(ContributionListing.this.countUpdates(base));
                                        }
                                    });
                                }
                                catch (InterruptedException e) {
                                    e.printStackTrace();
                                }
                                catch (InvocationTargetException e) {
                                    Throwable cause = e.getCause();
                                    if (cause instanceof RuntimeException) {
                                        throw (RuntimeException)cause;
                                    }
                                    cause.printStackTrace();
                                }
                                break block11;
                            }
                            ContributionListing.this.listDownloadFailed = true;
                        }
                        catch (MalformedURLException e) {
                            progress.error(e);
                            progress.finished();
                            ContributionListing.this.downloadingListingLock.unlock();
                        }
                    }
                    finally {
                        ContributionListing.this.downloadingListingLock.unlock();
                    }
                }
            }
        }, "Contribution List Downloader").start();
    }

    protected boolean hasUpdates(Contribution contribution) {
        if (contribution.isInstalled()) {
            AvailableContribution advertised = this.getAvailableContribution(contribution);
            if (advertised == null) {
                return false;
            }
            return advertised.getVersion() > contribution.getVersion() && advertised.isCompatible(Base.getRevision());
        }
        return false;
    }

    protected String getLatestPrettyVersion(Contribution contribution) {
        AvailableContribution newestContrib = this.getAvailableContribution(contribution);
        if (newestContrib == null) {
            return null;
        }
        return newestContrib.getPrettyVersion();
    }

    protected boolean hasDownloadedLatestList() {
        return this.listDownloaded;
    }

    protected boolean hasListDownloadFailed() {
        return this.listDownloadFailed;
    }

    private List<AvailableContribution> parseContribList(File file) {
        ArrayList<AvailableContribution> outgoing = new ArrayList<AvailableContribution>();
        if (file != null && file.exists()) {
            String[] lines = PApplet.loadStrings((File)file);
            int start = 0;
            while (start < lines.length) {
                int end2;
                String type = lines[start];
                ContributionType contribType = ContributionType.fromName(type);
                if (contribType == null) {
                    System.err.println("Error in contribution listing file on line " + (start + 1));
                    end2 = ++start;
                    while (end2 < lines.length && !lines[end2].trim().isEmpty()) {
                        ++end2;
                    }
                    start = end2 + 1;
                    continue;
                }
                end2 = ++start;
                while (end2 < lines.length && !lines[end2].trim().isEmpty()) {
                    ++end2;
                }
                String[] contribLines = PApplet.subset((String[])lines, (int)start, (int)(end2 - start));
                StringDict contribParams = Util.readSettings(file.getName(), contribLines);
                outgoing.add(new AvailableContribution(contribType, contribParams));
                start = end2 + 1;
            }
        }
        return outgoing;
    }

    public int countUpdates(Base base) {
        int count = 0;
        for (ModeContribution mc : base.getModeContribs()) {
            if (!this.hasUpdates(mc)) continue;
            ++count;
        }
        for (Library lib : base.getActiveEditor().getMode().contribLibraries) {
            if (!this.hasUpdates(lib)) continue;
            ++count;
        }
        for (Library lib : base.getActiveEditor().getMode().coreLibraries) {
            if (!this.hasUpdates(lib)) continue;
            ++count;
        }
        for (ToolContribution tc : base.getToolContribs()) {
            if (!this.hasUpdates(tc)) continue;
            ++count;
        }
        for (ExamplesContribution ec : base.getExampleContribs()) {
            if (!this.hasUpdates(ec)) continue;
            ++count;
        }
        return count;
    }

    public Map<String, Contribution> getLibrariesByImportHeader() {
        return this.librariesByImportHeader;
    }

    public static interface ChangeListener {
        public void contributionAdded(Contribution var1);

        public void contributionRemoved(Contribution var1);

        public void contributionChanged(Contribution var1, Contribution var2);
    }
}

