/*
 * Decompiled with CFR 0.152.
 */
package processing.app.tools;

import ch.randelshofer.gui.datatransfer.FileTextFieldTransferHandler;
import ch.randelshofer.media.mp3.MP3AudioInputStream;
import ch.randelshofer.media.quicktime.QuickTimeWriter;
import java.awt.Dimension;
import java.awt.EventQueue;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.RenderingHints;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.awt.image.BufferedImage;
import java.awt.image.DataBufferInt;
import java.awt.image.WritableRaster;
import java.io.File;
import java.io.FileFilter;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Arrays;
import java.util.prefs.Preferences;
import javax.imageio.ImageIO;
import javax.sound.sampled.AudioFormat;
import javax.sound.sampled.AudioInputStream;
import javax.sound.sampled.AudioSystem;
import javax.sound.sampled.UnsupportedAudioFileException;
import javax.swing.DefaultComboBoxModel;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JRootPane;
import javax.swing.JTextField;
import javax.swing.KeyStroke;
import javax.swing.LayoutStyle;
import javax.swing.ProgressMonitor;
import javax.swing.SwingWorker;
import javax.swing.border.EmptyBorder;
import javax.swing.filechooser.FileSystemView;
import processing.app.Base;
import processing.app.Language;
import processing.app.tools.Chooser;
import processing.app.tools.Tool;

public class MovieMaker
extends JFrame
implements Tool {
    private Preferences prefs;
    int width;
    int height;
    private JLabel aboutLabel;
    private JButton chooseImageFolderButton;
    private JButton chooseSoundFileButton;
    private JComboBox<String> compressionBox;
    private JLabel compressionLabel;
    private JTextField fpsField;
    private JLabel fpsLabel;
    private JTextField heightField;
    private JLabel heightLabel;
    private JTextField imageFolderField;
    private JLabel imageFolderHelpLabel;
    private JCheckBox originalSizeCheckBox;
    private JTextField soundFileField;
    private JLabel soundFileHelpLabel;
    private JTextField widthField;
    private JLabel widthLabel;
    private JButton createMovieButton;

    public String getMenuTitle() {
        return Language.text((String)"movie_maker");
    }

    public void run() {
        this.setVisible(true);
    }

    public void init(Base base) {
        JComponent[] jComponentArray;
        this.initComponents(base.getActiveEditor() == null);
        ((JComponent)this.getContentPane()).setBorder(new EmptyBorder(12, 18, 18, 18));
        this.imageFolderField.setTransferHandler(new FileTextFieldTransferHandler(1));
        this.soundFileField.setTransferHandler(new FileTextFieldTransferHandler());
        JComponent[] jComponentArray2 = jComponentArray = new JComponent[]{this.compressionBox, this.compressionLabel, this.fpsField, this.fpsLabel, this.widthField, this.widthLabel, this.heightField, this.heightLabel, this.originalSizeCheckBox};
        int n = jComponentArray.length;
        int n2 = 0;
        while (n2 < n) {
            JComponent jComponent = jComponentArray2[n2];
            jComponent.putClientProperty("JComponent.sizeVariant", "small");
            ++n2;
        }
        this.prefs = Preferences.userNodeForPackage(MovieMaker.class);
        this.imageFolderField.setText(this.prefs.get("movie.imageFolder", ""));
        this.soundFileField.setText(this.prefs.get("movie.soundFile", ""));
        this.widthField.setText("" + this.prefs.getInt("movie.width", 640));
        this.heightField.setText("" + this.prefs.getInt("movie.height", 480));
        boolean bl = this.prefs.getBoolean("movie.originalSize", false);
        this.originalSizeCheckBox.setSelected(bl);
        this.widthField.setEnabled(!bl);
        this.heightField.setEnabled(!bl);
        String string = "" + this.prefs.getDouble("movie.fps", 30.0);
        if (string.endsWith(".0")) {
            string = string.substring(0, string.length() - 2);
        }
        this.fpsField.setText(string);
        this.compressionBox.setSelectedIndex(Math.max(0, Math.min(this.compressionBox.getItemCount() - 1, this.prefs.getInt("movie.compression", 0))));
        this.originalSizeCheckBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                boolean bl = !MovieMaker.this.originalSizeCheckBox.isSelected();
                MovieMaker.this.widthField.setEnabled(bl);
                MovieMaker.this.heightField.setEnabled(bl);
            }
        });
        this.pack();
        this.setLocationRelativeTo(null);
    }

    public static void registerWindowCloseKeys(JRootPane jRootPane, ActionListener actionListener) {
        KeyStroke keyStroke = KeyStroke.getKeyStroke(27, 0);
        jRootPane.registerKeyboardAction(actionListener, keyStroke, 2);
        int n = Toolkit.getDefaultToolkit().getMenuShortcutKeyMask();
        keyStroke = KeyStroke.getKeyStroke(87, n);
        jRootPane.registerKeyboardAction(actionListener, keyStroke, 2);
    }

    private void initComponents(final boolean bl) {
        this.imageFolderHelpLabel = new JLabel();
        this.imageFolderField = new JTextField();
        this.chooseImageFolderButton = new JButton();
        this.soundFileHelpLabel = new JLabel();
        this.soundFileField = new JTextField();
        this.chooseSoundFileButton = new JButton();
        this.createMovieButton = new JButton();
        this.widthLabel = new JLabel();
        this.widthField = new JTextField();
        this.heightLabel = new JLabel();
        this.heightField = new JTextField();
        this.compressionLabel = new JLabel();
        this.compressionBox = new JComboBox();
        this.fpsLabel = new JLabel();
        this.fpsField = new JTextField();
        this.originalSizeCheckBox = new JCheckBox();
        this.setDefaultCloseOperation(0);
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent windowEvent) {
                MovieMaker.this.setVisible(false);
            }
        });
        MovieMaker.registerWindowCloseKeys(this.getRootPane(), new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                if (bl) {
                    System.exit(0);
                } else {
                    MovieMaker.this.setVisible(false);
                }
            }
        });
        this.setTitle(Language.text((String)"movie_maker.title"));
        this.aboutLabel = new JLabel(Language.text((String)"movie_maker.blurb"));
        this.imageFolderHelpLabel.setText(Language.text((String)"movie_maker.image_folder_help_label"));
        this.chooseImageFolderButton.setText(Language.text((String)"movie_maker.choose_button"));
        this.chooseImageFolderButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                Chooser.selectFolder(MovieMaker.this, Language.text((String)"movie_maker.select_image_folder"), new File(MovieMaker.this.imageFolderField.getText()), new Chooser.Callback(){

                    @Override
                    void select(File file) {
                        if (file != null) {
                            MovieMaker.this.imageFolderField.setText(file.getAbsolutePath());
                        }
                    }
                });
            }
        });
        this.soundFileHelpLabel.setText(Language.text((String)"movie_maker.sound_file_help_label"));
        this.chooseSoundFileButton.setText(Language.text((String)"movie_maker.choose_button"));
        this.chooseSoundFileButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                Chooser.selectInput(MovieMaker.this, Language.text((String)"movie_maker.select_sound_file"), new File(MovieMaker.this.soundFileField.getText()), new Chooser.Callback(){

                    @Override
                    void select(File file) {
                        if (file != null) {
                            MovieMaker.this.soundFileField.setText(file.getAbsolutePath());
                        }
                    }
                });
            }
        });
        this.createMovieButton.setText(Language.text((String)"movie_maker.create_movie_button"));
        this.createMovieButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                String string = MovieMaker.this.prefs.get("movie.outputFile", null);
                File file = string == null ? null : new File(string);
                Chooser.selectOutput(MovieMaker.this, Language.text((String)"movie_maker.save_dialog_prompt"), file, new Chooser.Callback(){

                    @Override
                    void select(File file) {
                        if (file != null) {
                            String string = file.getAbsolutePath();
                            if (!string.toLowerCase().endsWith(".mov")) {
                                string = String.valueOf(string) + ".mov";
                            }
                            MovieMaker.this.prefs.put("movie.outputFile", string);
                            MovieMaker.this.createMovie(new File(string));
                        }
                    }
                });
            }
        });
        Font font = new Font("Dialog", 0, 11);
        this.widthLabel.setFont(font);
        this.widthLabel.setText(Language.text((String)"movie_maker.width"));
        this.widthField.setColumns(4);
        this.widthField.setFont(font);
        this.widthField.setText("320");
        this.heightLabel.setFont(font);
        this.heightLabel.setText(Language.text((String)"movie_maker.height"));
        this.heightField.setColumns(4);
        this.heightField.setFont(font);
        this.heightField.setText("240");
        this.compressionLabel.setFont(font);
        this.compressionLabel.setText(Language.text((String)"movie_maker.compression"));
        this.compressionBox.setFont(font);
        this.compressionBox.setModel(new DefaultComboBoxModel<String>(new String[]{Language.text((String)"movie_maker.compression.animation"), Language.text((String)"movie_maker.compression.jpeg"), Language.text((String)"movie_maker.compression.png")}));
        this.fpsLabel.setFont(font);
        this.fpsLabel.setText(Language.text((String)"movie_maker.framerate"));
        this.fpsField.setColumns(4);
        this.fpsField.setFont(font);
        this.fpsField.setText("30");
        this.originalSizeCheckBox.setFont(font);
        this.originalSizeCheckBox.setText(Language.text((String)"movie_maker.orig_size_button"));
        this.originalSizeCheckBox.setToolTipText(Language.text((String)"movie_maker.orig_size_tooltip"));
        GroupLayout groupLayout = new GroupLayout(this.getContentPane());
        this.getContentPane().setLayout(groupLayout);
        groupLayout.setHorizontalGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(groupLayout.createSequentialGroup().addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(groupLayout.createSequentialGroup().addGap(61, 61, 61).addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.widthLabel).addComponent(this.fpsLabel)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(groupLayout.createSequentialGroup().addComponent(this.fpsField, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.compressionLabel).addGap(1, 1, 1).addComponent(this.compressionBox, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.originalSizeCheckBox)).addGroup(groupLayout.createSequentialGroup().addComponent(this.widthField, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.heightLabel).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.heightField, -2, -1, -2))).addGap(41, 41, 41)).addGroup(groupLayout.createSequentialGroup().addContainerGap().addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.aboutLabel, -1, 484, Short.MAX_VALUE).addComponent(this.imageFolderHelpLabel).addComponent(this.soundFileHelpLabel).addGroup(groupLayout.createSequentialGroup().addComponent(this.soundFileField, -1, 372, Short.MAX_VALUE).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.chooseSoundFileButton)).addComponent(this.createMovieButton, GroupLayout.Alignment.TRAILING).addGroup(GroupLayout.Alignment.TRAILING, groupLayout.createSequentialGroup().addComponent(this.imageFolderField, -1, 372, Short.MAX_VALUE).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.chooseImageFolderButton)))).addGroup(groupLayout.createSequentialGroup().addContainerGap()))));
        groupLayout.setVerticalGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(groupLayout.createSequentialGroup().addContainerGap().addComponent(this.aboutLabel, -2, -1, -2).addGap(18, 18, 18).addComponent(this.imageFolderHelpLabel).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.imageFolderField, -2, -1, -2).addComponent(this.chooseImageFolderButton)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.widthLabel).addComponent(this.widthField, -2, -1, -2).addComponent(this.heightLabel).addComponent(this.heightField, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.compressionBox, -2, -1, -2).addComponent(this.fpsLabel).addComponent(this.fpsField, -2, -1, -2).addComponent(this.compressionLabel).addComponent(this.originalSizeCheckBox)).addGap(18, 18, 18).addComponent(this.soundFileHelpLabel).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.soundFileField, -2, -1, -2).addComponent(this.chooseSoundFileButton)).addGap(18, 18, 18).addComponent(this.createMovieButton).addContainerGap()));
        this.pack();
    }

    private void createMovie(final File file) {
        QuickTimeWriter.VideoFormat videoFormat;
        double d;
        File file2;
        this.createMovieButton.setEnabled(false);
        final File file3 = this.soundFileField.getText().trim().length() == 0 ? null : new File(this.soundFileField.getText().trim());
        File file4 = file2 = this.imageFolderField.getText().trim().length() == 0 ? null : new File(this.imageFolderField.getText().trim());
        if (file3 == null && file2 == null) {
            JOptionPane.showMessageDialog(this, Language.text((String)"movie_maker.error.need_input"));
            return;
        }
        try {
            this.width = Integer.parseInt(this.widthField.getText());
            this.height = Integer.parseInt(this.heightField.getText());
            d = Double.parseDouble(this.fpsField.getText());
        }
        catch (Throwable throwable) {
            JOptionPane.showMessageDialog(this, Language.text((String)"movie_maker.error.badnumbers"));
            return;
        }
        if (this.width < 1 || this.height < 1 || d < 1.0) {
            JOptionPane.showMessageDialog(this, Language.text((String)"movie_maker.error.badnumbers"));
            return;
        }
        switch (this.compressionBox.getSelectedIndex()) {
            case 0: {
                videoFormat = QuickTimeWriter.VideoFormat.RLE;
                break;
            }
            case 1: {
                videoFormat = QuickTimeWriter.VideoFormat.JPG;
                break;
            }
            default: {
                videoFormat = QuickTimeWriter.VideoFormat.PNG;
            }
        }
        this.prefs.put("movie.imageFolder", this.imageFolderField.getText());
        this.prefs.put("movie.soundFile", this.soundFileField.getText());
        this.prefs.putInt("movie.width", this.width);
        this.prefs.putInt("movie.height", this.height);
        this.prefs.putDouble("movie.fps", d);
        this.prefs.putInt("movie.compression", this.compressionBox.getSelectedIndex());
        this.prefs.putBoolean("movie.originalSize", this.originalSizeCheckBox.isSelected());
        final boolean bl = this.originalSizeCheckBox.isSelected();
        new SwingWorker<Throwable, Object>(){

            @Override
            protected Throwable doInBackground() {
                try {
                    Object[] objectArray = null;
                    if (file2 != null) {
                        objectArray = file2.listFiles(new FileFilter(){
                            FileSystemView fsv = FileSystemView.getFileSystemView();

                            @Override
                            public boolean accept(File file) {
                                return file.isFile() && !this.fsv.isHiddenFile(file) && !file.getName().equals("Thumbs.db");
                            }
                        });
                        if (objectArray == null || objectArray.length == 0) {
                            return new RuntimeException(Language.text((String)"movie_maker.error.no_images_found"));
                        }
                        Arrays.sort(objectArray);
                    }
                    if (bl) {
                        Dimension dimension = this.findSize((File[])objectArray);
                        if (dimension == null) {
                            throw new RuntimeException(Language.text((String)"movie_maker.error.no_images_found"));
                        }
                        MovieMaker.this.width = dimension.width;
                        MovieMaker.this.height = dimension.height;
                    }
                    if (file.exists()) {
                        file.delete();
                    }
                    if (file2 != null && file3 != null) {
                        MovieMaker.this.writeVideoAndAudio(file, (File[])objectArray, file3, MovieMaker.this.width, MovieMaker.this.height, d, videoFormat, "fastStartCompressed");
                    } else if (file2 != null) {
                        MovieMaker.this.writeVideoOnlyVFR(file, (File[])objectArray, MovieMaker.this.width, MovieMaker.this.height, d, videoFormat, "fastStartCompressed");
                    } else {
                        MovieMaker.this.writeAudioOnly(file, file3, "fastStartCompressed");
                    }
                    return null;
                }
                catch (Throwable throwable) {
                    return throwable;
                }
            }

            Dimension findSize(File[] fileArray) {
                int n = 0;
                while (n < fileArray.length) {
                    BufferedImage bufferedImage = MovieMaker.this.readImage(fileArray[n]);
                    if (bufferedImage != null) {
                        return new Dimension(bufferedImage.getWidth(), bufferedImage.getHeight());
                    }
                    fileArray[n] = null;
                    ++n;
                }
                return null;
            }

            @Override
            protected void done() {
                Throwable throwable;
                try {
                    throwable = (Throwable)this.get();
                }
                catch (Exception exception) {
                    throwable = exception;
                }
                if (throwable != null) {
                    throwable.printStackTrace();
                    JOptionPane.showMessageDialog(MovieMaker.this, String.valueOf(Language.text((String)"movie_maker.error.movie_failed")) + "\n" + (throwable.getMessage() == null ? throwable.toString() : throwable.getMessage()), Language.text((String)"movie_maker.error.sorry"), 0);
                }
                MovieMaker.this.createMovieButton.setEnabled(true);
            }
        }.execute();
    }

    private BufferedImage readImage(File file) {
        BufferedImage bufferedImage;
        block14: {
            block11: {
                block13: {
                    String string;
                    block12: {
                        ClassLoader classLoader;
                        Thread thread;
                        try {
                            thread = Thread.currentThread();
                            classLoader = Thread.currentThread().getContextClassLoader();
                            thread.setContextClassLoader(this.getClass().getClassLoader());
                            try {
                                bufferedImage = ImageIO.read(file);
                            }
                            catch (IOException iOException) {
                                System.err.println(Language.interpolate((String)"movie_maker.error.cannot_read", (Object[])new Object[]{file.getAbsolutePath()}));
                                return null;
                            }
                        }
                        catch (RuntimeException runtimeException) {
                            MovieMaker.cannotRead(file);
                            return null;
                        }
                        thread.setContextClassLoader(classLoader);
                        if (bufferedImage != null) break block11;
                        String string2 = file.getAbsolutePath();
                        string = string2.toLowerCase();
                        if (!string.endsWith(".tga")) break block12;
                        try {
                            return MovieMaker.loadImageTGA(file);
                        }
                        catch (IOException iOException) {
                            MovieMaker.cannotRead(file);
                            return null;
                        }
                    }
                    if (!string.endsWith(".tif") && !string.endsWith(".tiff")) break block13;
                    MovieMaker.cannotRead(file);
                    System.err.println(Language.text((String)"movie_maker.error.avoid_tiff"));
                    return null;
                }
                MovieMaker.cannotRead(file);
                return null;
            }
            if (bufferedImage.getWidth() > 0 && bufferedImage.getHeight() > 0) break block14;
            System.err.println(Language.interpolate((String)"movie_maker.error.cannot_read_maybe_bad", (Object[])new Object[]{file.getAbsolutePath()}));
            return null;
        }
        return bufferedImage;
    }

    private static void cannotRead(File file) {
        String string = file.getAbsolutePath();
        String string2 = Language.interpolate((String)"movie_maker.error.cannot_read", (Object[])new Object[]{string});
        System.err.println(string2);
    }

    private void writeVideoOnlyVFR(File file, File[] fileArray, int n, int n2, double d, QuickTimeWriter.VideoFormat videoFormat, String string) throws IOException {
        File file2 = string.equals("none") ? file : new File(String.valueOf(file.getPath()) + ".tmp");
        ProgressMonitor progressMonitor = new ProgressMonitor(this, Language.interpolate((String)"movie_maker.progress.creating_file_name", (Object[])new Object[]{file.getName()}), Language.text((String)"movie_maker.progress.creating_output_file"), 0, fileArray.length);
        Graphics graphics = null;
        Image image = null;
        BufferedImage bufferedImage = null;
        int[] nArray = null;
        int[] nArray2 = null;
        QuickTimeWriter quickTimeWriter = null;
        try {
            int n3 = (int)(d * 100.0);
            int n4 = 100;
            quickTimeWriter = new QuickTimeWriter(videoFormat == QuickTimeWriter.VideoFormat.RAW ? file : file2);
            quickTimeWriter.addVideoTrack(videoFormat, n3, n, n2);
            quickTimeWriter.setSyncInterval(0, 30);
            image = new BufferedImage(n, n2, 1);
            nArray = ((DataBufferInt)((BufferedImage)image).getRaster().getDataBuffer()).getData();
            bufferedImage = new BufferedImage(n, n2, 1);
            nArray2 = ((DataBufferInt)bufferedImage.getRaster().getDataBuffer()).getData();
            graphics = ((BufferedImage)image).createGraphics();
            ((Graphics2D)graphics).setRenderingHint(RenderingHints.KEY_RENDERING, RenderingHints.VALUE_RENDER_QUALITY);
            int n5 = 0;
            int n6 = 0;
            while (n6 < fileArray.length && !progressMonitor.isCanceled()) {
                File file3 = fileArray[n6];
                if (file3 != null) {
                    progressMonitor.setNote(Language.interpolate((String)"movie_maker.progress.processing", (Object[])new Object[]{file3.getName()}));
                    progressMonitor.setProgress(n6);
                    BufferedImage bufferedImage2 = this.readImage(file3);
                    if (bufferedImage2 != null) {
                        graphics.drawImage(bufferedImage2, 0, 0, n, n2, null);
                        if (n6 != 0 && Arrays.equals(nArray, nArray2)) {
                            n5 += n4;
                        } else {
                            if (n5 != 0) {
                                quickTimeWriter.writeFrame(0, bufferedImage, n5);
                            }
                            n5 = n4;
                            System.arraycopy(nArray, 0, nArray2, 0, nArray.length);
                        }
                    }
                }
                ++n6;
            }
            if (n5 != 0) {
                quickTimeWriter.writeFrame(0, bufferedImage, n5);
            }
            if (string.equals("fastStart")) {
                quickTimeWriter.toWebOptimizedMovie(file, false);
                file2.delete();
            } else if (string.equals("fastStartCompressed")) {
                quickTimeWriter.toWebOptimizedMovie(file, true);
                file2.delete();
            }
            quickTimeWriter.close();
            quickTimeWriter = null;
        }
        finally {
            progressMonitor.close();
            if (graphics != null) {
                graphics.dispose();
            }
            if (image != null) {
                image.flush();
            }
            if (quickTimeWriter != null) {
                quickTimeWriter.close();
            }
        }
    }

    private void writeAudioOnly(File file, File file2, String string) throws IOException {
        File file3 = string.equals("none") ? file : new File(String.valueOf(file.getPath()) + ".tmp");
        int n = (int)Math.min(Integer.MAX_VALUE, file2.length());
        ProgressMonitor progressMonitor = new ProgressMonitor(this, Language.interpolate((String)"movie_maker.progress.creating_file_name", (Object[])new Object[]{file.getName()}), Language.text((String)"movie_maker.progress.initializing"), 0, n);
        AudioInputStream audioInputStream = null;
        QuickTimeWriter quickTimeWriter = null;
        try {
            try {
                quickTimeWriter = new QuickTimeWriter(file3);
                audioInputStream = file2.getName().toLowerCase().endsWith(".mp3") ? new MP3AudioInputStream(file2) : AudioSystem.getAudioInputStream(file2);
                AudioFormat audioFormat = audioInputStream.getFormat();
                quickTimeWriter.addAudioTrack(audioFormat);
                boolean bl = audioFormat.getProperty("vbr") != null && (Boolean)audioFormat.getProperty("vbr") != false;
                int n2 = audioFormat.getFrameSize();
                int n3 = bl ? 1 : Math.max(1, 1024 / n2);
                int n4 = (int)(audioFormat.getSampleRate() / audioFormat.getFrameRate());
                long l = 0L;
                byte[] byArray = new byte[n2 * n3];
                int n5 = audioInputStream.read(byArray);
                while (n5 != -1) {
                    if (n5 != 0) {
                        int n6 = n5 / n2;
                        quickTimeWriter.writeSamples(0, n6, byArray, 0, n5, n4);
                        progressMonitor.setProgress((int)(l += (long)n5));
                    }
                    if (bl) {
                        audioFormat = audioInputStream.getFormat();
                        if (audioFormat == null) break;
                        n2 = audioFormat.getFrameSize();
                        n4 = (int)(audioFormat.getSampleRate() / audioFormat.getFrameRate());
                        if (byArray.length < n2) {
                            byArray = new byte[n2];
                        }
                    }
                    n5 = audioInputStream.read(byArray);
                }
                audioInputStream.close();
                audioInputStream = null;
                if (string.equals("fastStart")) {
                    quickTimeWriter.toWebOptimizedMovie(file, false);
                    file3.delete();
                } else if (string.equals("fastStartCompressed")) {
                    quickTimeWriter.toWebOptimizedMovie(file, true);
                    file3.delete();
                }
                quickTimeWriter.close();
                quickTimeWriter = null;
            }
            catch (UnsupportedAudioFileException unsupportedAudioFileException) {
                IOException iOException = new IOException(unsupportedAudioFileException.getMessage());
                iOException.initCause(unsupportedAudioFileException);
                throw iOException;
            }
        }
        finally {
            progressMonitor.close();
            if (audioInputStream != null) {
                audioInputStream.close();
            }
            if (quickTimeWriter != null) {
                quickTimeWriter.close();
            }
        }
    }

    private void writeVideoAndAudio(File file, File[] fileArray, File file2, int n, int n2, double d, QuickTimeWriter.VideoFormat videoFormat, String string) throws IOException {
        File file3 = string.equals("none") ? file : new File(String.valueOf(file.getPath()) + ".tmp");
        ProgressMonitor progressMonitor = new ProgressMonitor(this, Language.interpolate((String)"movie_maker.progress.creating_file_name", (Object[])new Object[]{file.getName()}), Language.text((String)"movie_maker.progress.creating_output_file"), 0, fileArray.length);
        AudioInputStream audioInputStream = null;
        QuickTimeWriter quickTimeWriter = null;
        Image image = null;
        Graphics graphics = null;
        try {
            try {
                byte[] byArray;
                int n3;
                audioInputStream = file2.getName().toLowerCase().endsWith(".mp3") ? new MP3AudioInputStream(file2) : AudioSystem.getAudioInputStream(file2);
                AudioFormat audioFormat = audioInputStream.getFormat();
                boolean bl = audioFormat.getProperty("vbr") != null && (Boolean)audioFormat.getProperty("vbr") != false;
                int n4 = (int)(audioFormat.getSampleRate() / audioFormat.getFrameRate());
                int n5 = 100;
                quickTimeWriter = new QuickTimeWriter(videoFormat == QuickTimeWriter.VideoFormat.RAW ? file : file3);
                quickTimeWriter.addAudioTrack(audioFormat);
                quickTimeWriter.addVideoTrack(videoFormat, (int)(d * (double)n5), n, n2);
                if (bl) {
                    n3 = audioFormat.getFrameSize();
                    byArray = new byte[n3];
                } else {
                    n3 = audioFormat.getChannels() * audioFormat.getSampleSizeInBits() / 8;
                    byArray = new byte[(int)(quickTimeWriter.getMediaTimeScale(0) / 2L * (long)n3)];
                }
                image = new BufferedImage(n, n2, 1);
                graphics = ((BufferedImage)image).createGraphics();
                ((Graphics2D)graphics).setRenderingHint(RenderingHints.KEY_RENDERING, RenderingHints.VALUE_RENDER_QUALITY);
                int n6 = 0;
                int n7 = 0;
                boolean bl2 = false;
                while (!(n7 >= fileArray.length && bl2 || progressMonitor.isCanceled())) {
                    n6 = (int)((long)n6 + quickTimeWriter.getMovieTimeScale() / 2L);
                    while (!bl2 && quickTimeWriter.getTrackDuration(0) < (long)n6 + quickTimeWriter.getMovieTimeScale()) {
                        int n8 = audioInputStream.read(byArray);
                        if (n8 == -1) {
                            bl2 = true;
                        } else {
                            quickTimeWriter.writeSamples(0, n8 / n3, byArray, 0, n8, n4);
                        }
                        if (!bl) continue;
                        audioFormat = audioInputStream.getFormat();
                        if (audioFormat == null) break;
                        n3 = audioFormat.getFrameSize();
                        n4 = (int)(audioFormat.getSampleRate() / audioFormat.getFrameRate());
                        if (byArray.length >= n3) continue;
                        byArray = new byte[n3];
                    }
                    while (n7 < fileArray.length && quickTimeWriter.getTrackDuration(1) < (long)n6) {
                        progressMonitor.setProgress(n7);
                        File file4 = fileArray[n7];
                        if (file4 != null) {
                            progressMonitor.setNote(Language.interpolate((String)"movie_maker.progress.processing", (Object[])new Object[]{file4.getName()}));
                            BufferedImage bufferedImage = this.readImage(file4);
                            if (bufferedImage != null) {
                                graphics.drawImage(bufferedImage, 0, 0, n, n2, null);
                                bufferedImage.flush();
                                quickTimeWriter.writeFrame(1, (BufferedImage)image, n5);
                            }
                        }
                        ++n7;
                    }
                }
                if (string.equals("fastStart")) {
                    quickTimeWriter.toWebOptimizedMovie(file, false);
                    file3.delete();
                } else if (string.equals("fastStartCompressed")) {
                    quickTimeWriter.toWebOptimizedMovie(file, true);
                    file3.delete();
                }
                quickTimeWriter.close();
                quickTimeWriter = null;
            }
            catch (UnsupportedAudioFileException unsupportedAudioFileException) {
                IOException iOException = new IOException(unsupportedAudioFileException.getMessage());
                iOException.initCause(unsupportedAudioFileException);
                throw iOException;
            }
        }
        finally {
            progressMonitor.close();
            if (quickTimeWriter != null) {
                quickTimeWriter.close();
            }
            if (audioInputStream != null) {
                audioInputStream.close();
            }
            if (graphics != null) {
                graphics.dispose();
            }
            if (image != null) {
                image.flush();
            }
        }
    }

    private static BufferedImage loadImageTGA(File file) throws IOException {
        try (FileInputStream fileInputStream = new FileInputStream(file);){
            int n;
            int[] nArray;
            int n2;
            int n3;
            int n4;
            block50: {
                int n5;
                int n6;
                boolean bl;
                block48: {
                    block49: {
                        byte[] byArray = new byte[18];
                        int n7 = 0;
                        do {
                            if ((n4 = ((InputStream)fileInputStream).read(byArray, n7, byArray.length - n7)) != -1) continue;
                            return null;
                        } while ((n7 += n4) < 18);
                        n4 = 0;
                        if (!(byArray[2] != 3 && byArray[2] != 11 || byArray[16] != 8 || byArray[17] != 8 && byArray[17] != 40)) {
                            n4 = 4;
                        } else if (!(byArray[2] != 2 && byArray[2] != 10 || byArray[16] != 24 || byArray[17] != 32 && byArray[17] != 0)) {
                            n4 = 1;
                        } else if (!(byArray[2] != 2 && byArray[2] != 10 || byArray[16] != 32 || byArray[17] != 8 && byArray[17] != 40)) {
                            n4 = 2;
                        }
                        if (n4 == 0) {
                            throw new IOException(Language.interpolate((String)"movie_maker.error.unknown_tga_format", (Object[])new Object[]{file.getName()}));
                        }
                        n3 = ((byArray[13] & 0xFF) << 8) + (byArray[12] & 0xFF);
                        n2 = ((byArray[15] & 0xFF) << 8) + (byArray[14] & 0xFF);
                        nArray = new int[n3 * n2];
                        boolean bl2 = bl = (byArray[17] & 0x20) == 0;
                        if (byArray[2] != 2 && byArray[2] != 3) break block48;
                        if (!bl) break block49;
                        n = (n2 - 1) * n3;
                        switch (n4) {
                            case 4: {
                                int n8 = n2 - 1;
                                while (n8 >= 0) {
                                    n6 = 0;
                                    while (n6 < n3) {
                                        nArray[n + n6] = ((InputStream)fileInputStream).read();
                                        ++n6;
                                    }
                                    n -= n3;
                                    --n8;
                                }
                                break block50;
                            }
                            case 1: {
                                int n9 = n2 - 1;
                                while (n9 >= 0) {
                                    n6 = 0;
                                    while (n6 < n3) {
                                        nArray[n + n6] = ((InputStream)fileInputStream).read() | ((InputStream)fileInputStream).read() << 8 | ((InputStream)fileInputStream).read() << 16 | 0xFF000000;
                                        ++n6;
                                    }
                                    n -= n3;
                                    --n9;
                                }
                                break block50;
                            }
                            case 2: {
                                int n10 = n2 - 1;
                                while (n10 >= 0) {
                                    n6 = 0;
                                    while (n6 < n3) {
                                        nArray[n + n6] = ((InputStream)fileInputStream).read() | ((InputStream)fileInputStream).read() << 8 | ((InputStream)fileInputStream).read() << 16 | ((InputStream)fileInputStream).read() << 24;
                                        ++n6;
                                    }
                                    n -= n3;
                                    --n10;
                                }
                                break block2;
                            }
                        }
                        break block50;
                    }
                    n = n3 * n2;
                    switch (n4) {
                        case 4: {
                            int n11 = 0;
                            while (n11 < n) {
                                nArray[n11] = ((InputStream)fileInputStream).read();
                                ++n11;
                            }
                            break block50;
                        }
                        case 1: {
                            int n12 = 0;
                            while (n12 < n) {
                                nArray[n12] = ((InputStream)fileInputStream).read() | ((InputStream)fileInputStream).read() << 8 | ((InputStream)fileInputStream).read() << 16 | 0xFF000000;
                                ++n12;
                            }
                            break block50;
                        }
                        case 2: {
                            int n13 = 0;
                            while (n13 < n) {
                                nArray[n13] = ((InputStream)fileInputStream).read() | ((InputStream)fileInputStream).read() << 8 | ((InputStream)fileInputStream).read() << 16 | ((InputStream)fileInputStream).read() << 24;
                                ++n13;
                            }
                            break block7;
                        }
                    }
                    break block50;
                }
                n = 0;
                block34: while (n < nArray.length) {
                    int n14 = ((InputStream)fileInputStream).read();
                    int n15 = n6 = (n14 & 0x80) != 0 ? 1 : 0;
                    if (n6 != 0) {
                        n14 -= 127;
                        n5 = 0;
                        switch (n4) {
                            case 4: {
                                n5 = ((InputStream)fileInputStream).read();
                                break;
                            }
                            case 1: {
                                n5 = 0xFF000000 | ((InputStream)fileInputStream).read() | ((InputStream)fileInputStream).read() << 8 | ((InputStream)fileInputStream).read() << 16;
                                break;
                            }
                            case 2: {
                                n5 = ((InputStream)fileInputStream).read() | ((InputStream)fileInputStream).read() << 8 | ((InputStream)fileInputStream).read() << 16 | ((InputStream)fileInputStream).read() << 24;
                            }
                        }
                        int n16 = 0;
                        while (n16 < n14) {
                            nArray[n++] = n5;
                            if (n == nArray.length) continue block34;
                            ++n16;
                        }
                        continue;
                    }
                    ++n14;
                    switch (n4) {
                        case 4: {
                            n5 = 0;
                            while (n5 < n14) {
                                nArray[n++] = ((InputStream)fileInputStream).read();
                                ++n5;
                            }
                            continue block34;
                        }
                        case 1: {
                            n5 = 0;
                            while (n5 < n14) {
                                nArray[n++] = 0xFF000000 | ((InputStream)fileInputStream).read() | ((InputStream)fileInputStream).read() << 8 | ((InputStream)fileInputStream).read() << 16;
                                ++n5;
                            }
                            continue block34;
                        }
                        case 2: {
                            n5 = 0;
                            while (n5 < n14) {
                                nArray[n++] = ((InputStream)fileInputStream).read() | ((InputStream)fileInputStream).read() << 8 | ((InputStream)fileInputStream).read() << 16 | ((InputStream)fileInputStream).read() << 24;
                                ++n5;
                            }
                            continue block34;
                        }
                    }
                }
                if (!bl) {
                    int[] nArray2 = new int[n3];
                    n6 = 0;
                    while (n6 < n2 / 2) {
                        n5 = n2 - 1 - n6;
                        System.arraycopy(nArray, n6 * n3, nArray2, 0, n3);
                        System.arraycopy(nArray, n5 * n3, nArray, n6 * n3, n3);
                        System.arraycopy(nArray2, 0, nArray, n5 * n3, n3);
                        ++n6;
                    }
                }
            }
            n = n4 == 1 ? 1 : 2;
            BufferedImage bufferedImage = new BufferedImage(n3, n2, n);
            WritableRaster writableRaster = bufferedImage.getRaster();
            writableRaster.setDataElements(0, 0, n3, n2, nArray);
            BufferedImage bufferedImage2 = bufferedImage;
            return bufferedImage2;
        }
    }

    public static void main(String[] stringArray) {
        EventQueue.invokeLater(new Runnable(){

            @Override
            public void run() {
                MovieMaker movieMaker = new MovieMaker();
                movieMaker.init(null);
                movieMaker.setVisible(true);
            }
        });
    }
}

