/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.java.hints.errors;

import com.sun.source.tree.AnnotationTree;
import com.sun.source.tree.ModifiersTree;
import com.sun.source.tree.Tree;
import com.sun.source.util.TreePath;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.lang.model.element.Element;
import javax.lang.model.element.TypeElement;
import org.netbeans.api.java.source.CompilationInfo;
import org.netbeans.modules.java.hints.errors.Bundle;
import org.netbeans.modules.java.hints.spi.ErrorRule;
import org.netbeans.spi.editor.hints.Fix;
import org.netbeans.spi.java.hints.JavaFix;

public class RemoveOverride
implements ErrorRule<Void> {
    private static final Set<String> CODES = Collections.unmodifiableSet(new HashSet<String>(Arrays.asList("compiler.err.method.does.not.override.superclass")));

    public Set<String> getCodes() {
        return CODES;
    }

    public List<Fix> run(CompilationInfo compilationInfo, String diagnosticKey, int offset, TreePath treePath, ErrorRule.Data<Void> data) {
        treePath = compilationInfo.getTreeUtilities().pathFor(offset + 1);
        if (treePath.getParentPath() == null) {
            return null;
        }
        if (treePath.getParentPath().getLeaf().getKind() == Tree.Kind.MODIFIERS) {
            return Collections.singletonList(new FixImpl(compilationInfo, treePath.getParentPath()).toEditorFix());
        }
        return null;
    }

    public String getId() {
        return RemoveOverride.class.getName();
    }

    public String getDisplayName() {
        return Bundle.DN_RemoveOverride();
    }

    public void cancel() {
    }

    private static final class FixImpl
    extends JavaFix {
        public FixImpl(CompilationInfo info, TreePath tp) {
            super(info, tp);
        }

        protected String getText() {
            return Bundle.FIX_RemoveOverride();
        }

        protected void performRewrite(JavaFix.TransformationContext ctx) throws Exception {
            ModifiersTree mt = (ModifiersTree)ctx.getPath().getLeaf();
            for (AnnotationTree annotationTree : mt.getAnnotations()) {
                Element el = ctx.getWorkingCopy().getTrees().getElement(new TreePath(ctx.getPath(), annotationTree));
                if (el == null || !el.getKind().isInterface() || !((TypeElement)el).getQualifiedName().contentEquals("java.lang.Override")) continue;
                ctx.getWorkingCopy().rewrite((Tree)mt, (Tree)ctx.getWorkingCopy().getTreeMaker().removeModifiersAnnotation(mt, annotationTree));
                return;
            }
        }
    }
}

