/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.debugger.jpda.projects;

import com.sun.source.tree.BlockTree;
import com.sun.source.tree.CaseTree;
import com.sun.source.tree.CompilationUnitTree;
import com.sun.source.tree.ExpressionStatementTree;
import com.sun.source.tree.StatementTree;
import com.sun.source.tree.Tree;
import com.sun.source.util.SourcePositions;
import com.sun.source.util.TreePath;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.lang.model.element.Element;
import javax.lang.model.element.VariableElement;
import javax.lang.model.type.ExecutableType;
import javax.lang.model.type.TypeKind;
import javax.lang.model.type.TypeMirror;
import org.netbeans.api.java.source.CompilationInfo;
import org.netbeans.api.java.source.TreePathHandle;
import org.netbeans.api.java.source.TreeUtilities;
import org.netbeans.modules.debugger.jpda.projects.ScanLocalVars;
import org.openide.filesystems.FileObject;

class IntroduceClass {
    private static final Logger LOG = Logger.getLogger(IntroduceClass.class.getName());
    private String snippetCode;
    private final int codeOffset;
    private String methodBodyCode;
    private String methodInvokeCode;
    private long classGeneratePosition;
    private final boolean staticContext;

    IntroduceClass(String snippetCode, int codeOffset, boolean staticContext) {
        this.snippetCode = snippetCode;
        this.codeOffset = codeOffset;
        this.staticContext = staticContext;
    }

    boolean computeIntroduceMethod(TreePathHandle h, CompilationInfo info, TreePath treePath, Tree tree) {
        TreePath block = treePath;
        TreePath method = IntroduceClass.findMethod(block);
        if (method == null) {
            TreePath parentPath = treePath.getParentPath();
            if (parentPath == null) {
                return false;
            }
            method = parentPath;
        }
        CompilationUnitTree compilationUnit = info.getCompilationUnit();
        SourcePositions sourcePositions = info.getTrees().getSourcePositions();
        long endPosition = sourcePositions.getEndPosition(compilationUnit, method.getLeaf());
        this.classGeneratePosition = TreeUtilities.CLASS_TREE_KINDS.contains((Object)method.getLeaf().getKind()) ? endPosition - 1L : endPosition + 1L;
        List<? extends StatementTree> blockStatements = IntroduceClass.getStatements(block);
        StatementTree lastStatement = blockStatements.isEmpty() ? null : blockStatements.get(blockStatements.size() - 1);
        ScanLocalVars scanner = new ScanLocalVars(info, lastStatement);
        scanner.scan(block, null);
        HashSet exceptions = new HashSet();
        String returnType = scanner.getReturnType();
        if (returnType == null || !scanner.hasReturns()) {
            Element element;
            Object type = scanner.getReturnTypeMirror();
            if (type == null && lastStatement != null && (element = IntroduceClass.getElement(info, new TreePath(treePath, lastStatement))) != null && TypeKind.EXECUTABLE.equals((Object)(type = element.asType()).getKind())) {
                ExecutableType eType = (ExecutableType)type;
                type = eType.getReturnType();
                long lsEnd = sourcePositions.getEndPosition(compilationUnit, lastStatement);
                lsEnd = lsEnd < 0L ? (long)(this.snippetCode.length() - 1) : (lsEnd -= (long)this.codeOffset);
                if (';' != this.snippetCode.charAt((int)lsEnd)) {
                    this.snippetCode = new StringBuilder(this.snippetCode).insert((int)lsEnd + 1, ";").toString();
                }
            }
            if (type != null && !TypeKind.VOID.equals((Object)type.getKind())) {
                returnType = type.toString();
                long l = sourcePositions.getStartPosition(compilationUnit, lastStatement);
                this.snippetCode = new StringBuilder(this.snippetCode).insert((int)(l -= (long)this.codeOffset), "return ").append(';').toString();
            }
            if (returnType == null) {
                returnType = info.getTypes().getNoType(TypeKind.VOID).toString();
            }
        }
        for (StatementTree statementTree : blockStatements) {
            TreePath path = new TreePath(treePath, statementTree);
            exceptions.addAll(info.getTreeUtilities().getUncaughtExceptions(path));
        }
        Set<VariableElement> referencedVariables = scanner.getReferencedVariables();
        StringBuilder stringBuilder = new StringBuilder(returnType);
        stringBuilder.append(" invoke(");
        boolean isFirst = true;
        for (VariableElement var : referencedVariables) {
            if (!isFirst) {
                stringBuilder.append(", ");
            }
            stringBuilder.append(var.asType().toString());
            stringBuilder.append(" ");
            stringBuilder.append(var.getSimpleName().toString());
            isFirst = false;
        }
        stringBuilder.append(") ");
        if (!exceptions.isEmpty()) {
            stringBuilder.append("throws ");
            isFirst = true;
            for (TypeMirror exc : exceptions) {
                if (!isFirst) {
                    stringBuilder.append(", ");
                }
                stringBuilder.append(exc.toString());
                isFirst = false;
            }
        }
        stringBuilder.append("{\n");
        stringBuilder.append(this.snippetCode);
        stringBuilder.append("\n}");
        this.methodBodyCode = stringBuilder.toString();
        StringBuilder methodInvode = new StringBuilder("invoke(");
        isFirst = true;
        for (VariableElement var : referencedVariables) {
            if (!isFirst) {
                methodInvode.append(", ");
            }
            methodInvode.append(var.getSimpleName().toString());
            isFirst = false;
        }
        methodInvode.append(");");
        this.methodInvokeCode = methodInvode.toString();
        return true;
    }

    private static Element getElement(CompilationInfo info, TreePath path) {
        Element elm = info.getTrees().getElement(path);
        if (elm == null && path.getLeaf() instanceof ExpressionStatementTree) {
            ExpressionStatementTree exp = (ExpressionStatementTree)path.getLeaf();
            path = new TreePath(path, exp.getExpression());
            elm = info.getTrees().getElement(path);
        }
        return elm;
    }

    String getMethodInvoke() {
        return this.methodInvokeCode;
    }

    static TreePath findMethod(TreePath path) {
        while (path != null) {
            Tree leaf = path.getLeaf();
            switch (leaf.getKind()) {
                case BLOCK: {
                    if (path.getParentPath() == null || !TreeUtilities.CLASS_TREE_KINDS.contains((Object)path.getParentPath().getLeaf().getKind())) break;
                    return path.getParentPath();
                }
                case METHOD: 
                case LAMBDA_EXPRESSION: {
                    return path;
                }
            }
            path = path.getParentPath();
        }
        return null;
    }

    private static List<? extends StatementTree> getStatements(TreePath firstLeaf) {
        List<StatementTree> statements;
        Tree parentsLeaf = firstLeaf.getLeaf();
        switch (parentsLeaf.getKind()) {
            case BLOCK: {
                statements = ((BlockTree)parentsLeaf).getStatements();
                break;
            }
            case CASE: {
                statements = ((CaseTree)parentsLeaf).getStatements();
                break;
            }
            default: {
                Tree first = firstLeaf.getLeaf();
                statements = Tree.Kind.EXPRESSION_STATEMENT.equals((Object)first.getKind()) ? Collections.singletonList((StatementTree)firstLeaf.getLeaf()) : Collections.EMPTY_LIST;
            }
        }
        int s = statements.size();
        boolean haveOriginalStatements = true;
        while (s > 0 && ";".equals(statements.get(--s).toString().trim())) {
            if (haveOriginalStatements) {
                statements = new ArrayList<StatementTree>(statements);
                haveOriginalStatements = false;
            }
            statements.remove(s);
        }
        return statements;
    }

    String computeIntroduceClass(String className, FileObject fo) throws IOException {
        String fileText = fo.asText();
        StringBuilder textBuilder = new StringBuilder(fileText);
        String classText = (this.staticContext ? "static " : "") + "class " + className + " {\npublic " + className + "() {}\n" + this.methodBodyCode + "\n}";
        textBuilder.insert((int)this.classGeneratePosition, classText);
        if (LOG.isLoggable(Level.FINE)) {
            LOG.fine("Inserted class: '" + classText + "'");
            LOG.fine("Updated full file content:\n'" + textBuilder.toString() + "'");
        }
        return textBuilder.toString();
    }
}

