/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.lib.jshell.agent;

import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectOutputStream;
import java.lang.instrument.ClassFileTransformer;
import java.lang.instrument.IllegalClassFormatException;
import java.lang.instrument.Instrumentation;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.net.InetAddress;
import java.net.MalformedURLException;
import java.net.ServerSocket;
import java.net.Socket;
import java.net.URL;
import java.net.URLClassLoader;
import java.net.UnknownHostException;
import java.security.ProtectionDomain;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.objectweb.asm.ClassReader;
import org.objectweb.asm.ClassWriter;
import org.objectweb.asm.Type;
import org.objectweb.asm.tree.ClassNode;
import org.objectweb.asm.tree.MethodNode;

public class NbJShellAgent
implements Runnable,
ClassFileTransformer {
    public static volatile String debuggerKey = "";
    private static final Logger LOG = Logger.getLogger(NbJShellAgent.class.getName());
    private InetAddress address;
    private int port;
    private List<String> libraries = Collections.emptyList();
    private String className;
    private String field;
    private String method;
    private String key;
    private Instrumentation instrumentation;
    private ClassLoader agentClassLoader;
    private Class workerClass;
    private Constructor workerCtor;
    private static final String CLASS_INIT_NAME = "<clinit>";
    private static final String CLASS_INIT_DESC = "()V";
    private static final String JAVA_LANG_CLASS = "java/lang/Class";
    private static final String AGENT_CLASS = "jdk/internal/jshell/remote/AgentWorker";
    private static final String AGENT_CLASSLOADER_FIELD = "referenceClassLoader";
    private static final String AGENT_CLASSLOADER_DESC = "Ljava/lang/ClassLoader;";
    private static final String CLASS_GET_CLASSLOADER_DESC = "()Ljava/lang/ClassLoader;";
    private static final String CLASS_GET_CLASSLODER_METHOD = "getClassLoader";

    public Instrumentation getInstrumentation() {
        return this.instrumentation;
    }

    public String getKey() {
        return this.key;
    }

    void setKey(String key) {
        this.key = key;
    }

    public InetAddress getAddress() {
        return this.address;
    }

    void setAddress(InetAddress address) {
        this.address = address;
    }

    public int getPort() {
        return this.port;
    }

    void setPort(int port) {
        this.port = port;
    }

    public List<String> getLibraries() {
        return this.libraries;
    }

    void setLibraries(List<String> libraries) {
        this.libraries = libraries;
    }

    public String getClassName() {
        return this.className;
    }

    void setClassName(String className) {
        this.className = className;
    }

    public String getField() {
        return this.field;
    }

    void setField(String field) {
        this.field = field;
    }

    public String getMethod() {
        return this.method;
    }

    void setMethod(String method) {
        this.method = method;
    }

    public ClassLoader createClassLoader() {
        if (this.agentClassLoader != null) {
            return this.agentClassLoader;
        }
        if (this.libraries.isEmpty()) {
            LOG.log(Level.FINE, "Creating standard classloader");
            return this.getClass().getClassLoader();
        }
        LOG.log(Level.FINE, "Creating custom classloader");
        ArrayList<URL> urls = new ArrayList<URL>(this.libraries.size());
        for (String s : this.libraries) {
            try {
                URL url = new File(s).toURI().toURL();
                urls.add(url);
                LOG.log(Level.FINE, "Adding library: {0}", url);
            }
            catch (MalformedURLException ex) {
                LOG.log(Level.WARNING, "Unable to add library {0}: {1}", new Object[]{s, ex});
            }
        }
        URLClassLoader agentClassLoader = new URLClassLoader(urls.toArray(new URL[urls.size()]), this.getClass().getClassLoader());
        try {
            agentClassLoader.loadClass("org.netbeans.lib.jshell.agent.AgentWorker");
        }
        catch (ClassNotFoundException ex) {
            Logger.getLogger(NbJShellAgent.class.getName()).log(Level.SEVERE, null, ex);
        }
        this.agentClassLoader = agentClassLoader;
        return agentClassLoader;
    }

    public static void premain(String args, Instrumentation inst) {
        String[] pars;
        LOG.log(Level.FINE, "NbJShell agent starting, parameters: {0}", args);
        LOG.log(Level.FINE, "Properties: " + System.getProperties().toString().replace(",", "\n"));
        NbJShellAgent agent = new NbJShellAgent();
        agent.instrumentation = inst;
        for (String param : pars = args.split(",")) {
            String[] nameVal = param.split("=");
            if (nameVal == null || nameVal.length != 2) continue;
            String opt = nameVal[0];
            if ("address".equals(opt)) {
                try {
                    agent.setAddress(InetAddress.getByName(nameVal[1]));
                }
                catch (UnknownHostException ex) {
                    LOG.log(Level.SEVERE, "Invalid host address: {0}", ex);
                }
                continue;
            }
            if ("port".equals(opt)) {
                agent.setPort(Integer.valueOf(nameVal[1]));
                continue;
            }
            if ("libraries".equals(opt)) {
                agent.setLibraries(Arrays.asList(nameVal[1].split(";")));
                continue;
            }
            if ("key".equals(opt)) {
                debuggerKey = nameVal[1];
                LOG.log(Level.FINE, "Association key: " + debuggerKey);
                agent.setKey(nameVal[1]);
                continue;
            }
            if ("class".equals(opt)) {
                agent.setClassName(nameVal[1].replace('.', '/'));
                continue;
            }
            if ("field".equals(opt)) {
                agent.setField(nameVal[1]);
                continue;
            }
            if (!"method".equals(opt)) continue;
            agent.setMethod(nameVal[1]);
        }
        if (agent.needsInstrumentation()) {
            inst.addTransformer(agent, true);
        }
        try {
            ThreadGroup tg = new ThreadGroup("NetBeans JSHell agent support");
            Thread t = new Thread(tg, agent, "JShell VM Agent Connector");
            LOG.log(Level.INFO, "Starting JShell agent loop");
            t.setDaemon(true);
            t.setContextClassLoader(agent.createClassLoader());
            t.start();
        }
        catch (SecurityException ex) {
            LOG.log(Level.SEVERE, null, ex);
        }
    }

    public boolean needsInstrumentation() {
        return this.className != null && this.field == null && this.method == null;
    }

    /*
     * Unable to fully structure code
     */
    @Override
    public void run() {
        try {
            this.workerClass = Class.forName("org.netbeans.lib.jshell.agent.AgentWorker", true, this.createClassLoader());
            this.workerCtor = this.workerClass.getConstructor(new Class[]{NbJShellAgent.class, Socket.class});
        }
        catch (ClassNotFoundException ex) {
            NbJShellAgent.LOG.log(Level.WARNING, "Could not load worker class: ", ex);
        }
        catch (NoSuchMethodException ex) {
            NbJShellAgent.LOG.log(Level.WARNING, "Could not load worker class: ", ex);
        }
        catch (SecurityException ex) {
            NbJShellAgent.LOG.log(Level.WARNING, "Could not load worker class: ", ex);
        }
        try {
            socket = new ServerSocket();
            socket.bind(null);
            NbJShellAgent.LOG.log(Level.FINE, "NetBeans JShell agent starting at port {0}", socket.getLocalPort());
        }
        catch (IOException ex) {
            NbJShellAgent.LOG.log(Level.WARNING, "Failed to allocate callback socket: ", ex);
            return;
        }
        NbJShellAgent.LOG.log(Level.FINE, "Opening socket to {0}:{1}", new Object[]{this.getAddress(), this.getPort()});
        try {
            handshake = new Socket(this.getAddress(), this.getPort());
            NbJShellAgent.LOG.log(Level.FINE, "Connection to master granted, creating OS");
            ostm = new ObjectOutputStream(handshake.getOutputStream());
            NbJShellAgent.LOG.log(Level.FINE, "Authorizing with key {0}, local port for callback is: {1}", new Object[]{this.key, socket.getLocalPort()});
            ostm.writeUTF(this.key);
            ostm.writeInt(socket.getLocalPort());
            ostm.flush();
        }
        catch (IOException ex) {
            NbJShellAgent.LOG.log(Level.WARNING, "Initial handshake failed: ", ex);
            return;
        }
        counter = 1;
        try {
            while (true) lbl-1000:
            // 6 sources

            {
                try {
                    while (true) {
                        newConnection = socket.accept();
                        r = (Runnable)this.workerCtor.newInstance(new Object[]{this, newConnection});
                        t = new Thread(r, "JShell agent #" + counter++);
                        t.setDaemon(true);
                        NbJShellAgent.LOG.log(Level.FINE, "Forking JShell agent " + r.hashCode());
                        t.start();
                    }
                }
                catch (IOException ex) {
                    NbJShellAgent.LOG.log(Level.WARNING, "Error during accept: ", ex);
                }
                catch (IllegalArgumentException ex) {
                    NbJShellAgent.LOG.log(Level.WARNING, "Could not initialize the worker", ex);
                }
                catch (InstantiationException ex) {
                    NbJShellAgent.LOG.log(Level.WARNING, "Could not initialize the worker", ex);
                }
                catch (IllegalAccessException ex) {
                    NbJShellAgent.LOG.log(Level.WARNING, "Could not initialize the worker", ex);
                }
                catch (InvocationTargetException ex) {
                    NbJShellAgent.LOG.log(Level.WARNING, "Could not initialize the worker", ex);
                    continue;
                }
                break;
            }
        }
        catch (Throwable var7_18) {
            try {
                handshake.close();
            }
            catch (IOException ex) {
                Logger.getLogger(NbJShellAgent.class.getName()).log(Level.SEVERE, null, ex);
            }
            throw var7_18;
        }
        ** GOTO lbl-1000
    }

    private void transformClassInit(String className, MethodNode target) {
        Type classType = Type.getObjectType(className);
        if (target.instructions.size() > 0 && target.instructions.getLast().getOpcode() == 177) {
            target.instructions.remove(target.instructions.getLast());
        }
        target.visitLdcInsn(classType);
        target.visitMethodInsn(182, JAVA_LANG_CLASS, CLASS_GET_CLASSLODER_METHOD, CLASS_GET_CLASSLOADER_DESC, false);
        target.visitFieldInsn(179, AGENT_CLASS, AGENT_CLASSLOADER_FIELD, AGENT_CLASSLOADER_DESC);
        target.visitInsn(177);
        target.maxStack = Math.max(target.maxStack, 1);
        target.maxLocals = Math.max(target.maxLocals, 1);
        target.visitEnd();
    }

    private void insertClassInit(String className, ClassNode target) {
        MethodNode clinit = new MethodNode(327680, 4104, CLASS_INIT_NAME, CLASS_INIT_DESC, null, new String[0]);
        this.transformClassInit(className, clinit);
        target.methods.add(clinit);
    }

    @Override
    public byte[] transform(ClassLoader loader, String className, Class<?> classBeingRedefined, ProtectionDomain protectionDomain, byte[] classfileBuffer) throws IllegalClassFormatException {
        if (!className.equals(this.getClassName())) {
            return null;
        }
        ByteArrayInputStream istm = null;
        try {
            istm = new ByteArrayInputStream(classfileBuffer);
            ClassReader reader = new ClassReader(istm);
            ClassWriter wr = new ClassWriter(reader, 0);
            ClassNode clazz = new ClassNode();
            reader.accept(clazz, 0);
            boolean found = false;
            for (MethodNode m : clazz.methods) {
                if (!CLASS_INIT_NAME.equals(m.name)) continue;
                this.transformClassInit(className, m);
                found = true;
                break;
            }
            if (!found) {
                this.insertClassInit(className, clazz);
            }
            clazz.accept(wr);
            Object object = wr.toByteArray();
            return object;
        }
        catch (IOException ex) {
            IllegalClassFormatException x = new IllegalClassFormatException("I/O error");
            x.initCause(ex);
            throw x;
        }
        finally {
            if (istm != null) {
                try {
                    ((InputStream)istm).close();
                }
                catch (IOException iOException) {}
            }
        }
    }
}

