/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.apisupport.project;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.io.File;
import java.io.FilenameFilter;
import java.io.IOException;
import java.lang.ref.SoftReference;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.swing.event.ChangeListener;
import org.netbeans.api.java.classpath.ClassPath;
import org.netbeans.api.java.platform.JavaPlatform;
import org.netbeans.api.java.platform.JavaPlatformManager;
import org.netbeans.api.project.Project;
import org.netbeans.api.project.ProjectManager;
import org.netbeans.modules.apisupport.project.ApisupportAntUtils;
import org.netbeans.modules.apisupport.project.NbModuleProject;
import org.netbeans.modules.apisupport.project.NbModuleType;
import org.netbeans.modules.apisupport.project.ProjectXMLManager;
import org.netbeans.modules.apisupport.project.api.Util;
import org.netbeans.modules.apisupport.project.universe.DestDirProvider;
import org.netbeans.modules.apisupport.project.universe.ModuleEntry;
import org.netbeans.modules.apisupport.project.universe.ModuleList;
import org.netbeans.modules.apisupport.project.universe.TestModuleDependency;
import org.netbeans.spi.project.support.ant.AntProjectEvent;
import org.netbeans.spi.project.support.ant.AntProjectListener;
import org.netbeans.spi.project.support.ant.PropertyEvaluator;
import org.netbeans.spi.project.support.ant.PropertyProvider;
import org.netbeans.spi.project.support.ant.PropertyUtils;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.modules.SpecificationVersion;
import org.openide.util.ChangeSupport;
import org.openide.util.Mutex;
import org.openide.util.RequestProcessor;
import org.openide.util.WeakListeners;
import org.openide.xml.XMLUtil;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public final class Evaluator
implements PropertyEvaluator,
PropertyChangeListener,
AntProjectListener {
    public static final String CP = "cp";
    public static final String NBJDK_BOOTCLASSPATH = "nbjdk.bootclasspath";
    public static final String NBJDK_BOOTCLASSPATH_MODULAR = "nbjdk.bootclasspath.modular";
    static final String NBJDK_HOME = "nbjdk.home";
    public static final String RUN_CP = "run.cp";
    private static final SpecificationVersion JDK9 = new SpecificationVersion("9");
    private final NbModuleProject project;
    private final PropertyChangeSupport pcs = new PropertyChangeSupport(this);
    private PropertyEvaluator delegate;
    private volatile boolean loadedModuleList = false;
    private boolean runInAtomicAction;
    private boolean pendingReset = false;
    private static final Map<Project, Map<String, SoftReference<ModuleEntry>>> cachedProjectModuleEntries = new HashMap<Project, Map<String, SoftReference<ModuleEntry>>>();
    private static final Pattern ANT_PROP_REGEX = Pattern.compile("\\$\\{([a-zA-Z0-9._-]+)\\}");
    private static final RequestProcessor RP = new RequestProcessor(Evaluator.class.getName());
    private static final Set<String> warnedModules = Collections.synchronizedSet(new HashSet());

    Evaluator(NbModuleProject project) {
        this.project = project;
        this.delegate = this.createEvaluator(null);
        this.delegate.addPropertyChangeListener((PropertyChangeListener)this);
        project.getHelper().addAntProjectListener((AntProjectListener)this);
    }

    public String getProperty(String prop) {
        PropertyEvaluator eval = this.delegatingEvaluator(false);
        assert (eval != this);
        String v = eval.getProperty(prop);
        if (v == null && this.isModuleListDependentProperty(prop) || this.isModuleListDependentValue(v)) {
            return this.delegatingEvaluator(true).getProperty(prop);
        }
        return v;
    }

    public String evaluate(String text) {
        String v = this.delegatingEvaluator(false).evaluate(text);
        if (this.isModuleListDependentValue(v)) {
            return this.delegatingEvaluator(true).evaluate(text);
        }
        return v;
    }

    public Map<String, String> getProperties() {
        return this.delegatingEvaluator(true).getProperties();
    }

    private boolean isModuleListDependentProperty(String p) {
        return p.equals("module.classpath") || p.equals(CP) || p.endsWith(".cp") || p.endsWith(".cp.extra");
    }

    private boolean isModuleListDependentValue(String v) {
        if (v == null) {
            return false;
        }
        Matcher m = ANT_PROP_REGEX.matcher(v);
        while (m.find()) {
            if (!this.isModuleListDependentProperty(m.group(1))) continue;
            return true;
        }
        return false;
    }

    public void addPropertyChangeListener(PropertyChangeListener listener) {
        this.pcs.addPropertyChangeListener(listener);
    }

    public void removePropertyChangeListener(PropertyChangeListener listener) {
        this.pcs.removePropertyChangeListener(listener);
    }

    private PropertyEvaluator delegatingEvaluator(final boolean reset) {
        return (PropertyEvaluator)ProjectManager.mutex().readAccess((Mutex.Action)new Mutex.Action<PropertyEvaluator>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public PropertyEvaluator run() {
                if (reset && !Evaluator.this.loadedModuleList) {
                    Evaluator.this.reset();
                    if (Util.err.isLoggable(1)) {
                        Util.err.log("Needed to reset evaluator in " + Evaluator.this.project + "due to use of module-list-dependent property; now cp=" + Evaluator.this.delegate.getProperty(Evaluator.CP));
                    }
                }
                Evaluator evaluator = Evaluator.this;
                synchronized (evaluator) {
                    return Evaluator.this.delegate;
                }
            }
        });
    }

    private void reset() {
        if (!this.project.getProjectDirectoryFile().exists()) {
            return;
        }
        ProjectManager.mutex().readAccess((Mutex.Action)new Mutex.Action<Void>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public Void run() {
                ModuleList moduleList;
                try {
                    moduleList = Evaluator.this.project.getModuleList();
                }
                catch (IOException e) {
                    Util.err.notify(1, (Throwable)e);
                    return null;
                }
                Evaluator evaluator = Evaluator.this;
                synchronized (evaluator) {
                    Evaluator.this.loadedModuleList = true;
                    Evaluator.this.delegate.removePropertyChangeListener((PropertyChangeListener)Evaluator.this);
                    Evaluator.this.delegate = Evaluator.this.createEvaluator(moduleList);
                    Evaluator.this.delegate.addPropertyChangeListener((PropertyChangeListener)Evaluator.this);
                }
                Evaluator.this.pcs.firePropertyChange(null, null, null);
                return null;
            }
        });
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        if ("netbeans.dest.dir".equals(evt.getPropertyName()) || evt.getPropertyName() == null) {
            this.reset();
        } else {
            Util.err.log("Refiring property change from delegate in " + evt.getPropertyName() + " for " + this.project);
            this.pcs.firePropertyChange(evt.getPropertyName(), evt.getOldValue(), evt.getNewValue());
        }
    }

    public void configurationXmlChanged(AntProjectEvent ev) {
        if (ev.getPath().equals("nbproject/project.xml")) {
            if (this.runInAtomicAction) {
                this.pendingReset = true;
            } else {
                this.reset();
            }
        }
    }

    public void propertiesChanged(AntProjectEvent ev) {
    }

    public void setRunInAtomicAction(boolean runInAtomicAction) {
        assert (runInAtomicAction != this.runInAtomicAction) : "Nested calls not supported";
        this.runInAtomicAction = runInAtomicAction;
        if (!runInAtomicAction && this.pendingReset) {
            this.reset();
        }
        this.pendingReset = false;
    }

    boolean isRunInAtomicAction() {
        return this.runInAtomicAction;
    }

    public void removeListeners() {
        this.project.getHelper().removeAntProjectListener((AntProjectListener)this);
        this.delegate.removePropertyChangeListener((PropertyChangeListener)this);
    }

    private PropertyEvaluator createEvaluator(ModuleList ml) {
        PropertyEvaluator baseEval;
        File nbroot;
        PropertyProvider predefs = this.project.getHelper().getStockPropertyPreprovider();
        HashMap<String, String> stock = new HashMap<String, String>();
        File dir = this.project.getProjectDirectoryFile();
        NbModuleType type = this.project.getModuleType();
        PropertyProvider privateProperties = this.project.getHelper().getPropertyProvider("nbproject/private/private.properties");
        PropertyProvider projectProperties = this.project.getHelper().getPropertyProvider("nbproject/project.properties");
        if (type == NbModuleType.NETBEANS_ORG) {
            nbroot = ModuleList.findNetBeansOrg(dir);
            assert (nbroot != null) : "netbeans.org-type module not in a complete netbeans.org source root " + dir;
            stock.put("nb_all", nbroot.getAbsolutePath());
            File destDir = ModuleList.findNetBeansOrgDestDir(nbroot);
            stock.put("netbeans.dest.dir", destDir.getAbsolutePath());
            stock.put("nb.build.dir", "${nb_all}/nbbuild/build");
            stock.put("nbantext.jar", "${nb.build.dir}/nbantext.jar");
            try {
                Map<String, String> clusterProperties = ModuleList.getClusterProperties(nbroot);
                StringBuilder allValsB = new StringBuilder();
                for (PropertyProvider pp : new PropertyProvider[]{privateProperties, projectProperties}) {
                    for (String val : pp.getProperties().values()) {
                        allValsB.append(val);
                    }
                }
                String allVals = allValsB.toString();
                for (Map.Entry<String, String> dirEntry : clusterProperties.entrySet()) {
                    String key = dirEntry.getKey();
                    if (!key.endsWith(".dir")) continue;
                    String clusterDir = new File(destDir, dirEntry.getValue()).getAbsolutePath().intern();
                    String modules = clusterProperties.get(key.substring(0, key.length() - 4));
                    if (modules == null) continue;
                    for (String module : modules.split(",")) {
                        String dirProp = module + ".dir";
                        if (!allVals.contains(dirProp)) continue;
                        stock.put(dirProp.intern(), clusterDir);
                    }
                }
            }
            catch (IOException x) {
                Util.err.notify(1, (Throwable)x);
            }
        } else {
            nbroot = null;
        }
        ArrayList<PropertyProvider> providers = new ArrayList<PropertyProvider>();
        providers.add(PropertyUtils.fixedPropertyProvider(stock));
        if (type == NbModuleType.SUITE_COMPONENT) {
            providers.add(this.project.getHelper().getPropertyProvider("nbproject/private/suite-private.properties"));
            providers.add(this.project.getHelper().getPropertyProvider("nbproject/suite.properties"));
        }
        String codeNameBase = this.project.getCodeNameBase();
        PropertyEvaluator suiteEval = null;
        if (type == NbModuleType.SUITE_COMPONENT) {
            suiteEval = PropertyUtils.sequentialPropertyEvaluator((PropertyProvider)predefs, (PropertyProvider[])providers.toArray(new PropertyProvider[providers.size()]));
        }
        if (type == NbModuleType.SUITE_COMPONENT) {
            String suiteDirS = suiteEval.getProperty("suite.dir");
            if (suiteDirS != null) {
                File suiteDir = PropertyUtils.resolveFile((File)dir, (String)suiteDirS);
                providers.add(PropertyUtils.propertiesFilePropertyProvider((File)new File(suiteDir, "nbproject" + File.separatorChar + "private" + File.separatorChar + "platform-private.properties")));
                providers.add(PropertyUtils.propertiesFilePropertyProvider((File)new File(suiteDir, "nbproject" + File.separatorChar + "platform.properties")));
            }
        } else if (type == NbModuleType.STANDALONE) {
            providers.add(this.project.getHelper().getPropertyProvider("nbproject/private/platform-private.properties"));
            providers.add(this.project.getHelper().getPropertyProvider("nbproject/platform.properties"));
        }
        if (type == NbModuleType.SUITE_COMPONENT || type == NbModuleType.STANDALONE) {
            baseEval = PropertyUtils.sequentialPropertyEvaluator((PropertyProvider)predefs, (PropertyProvider[])providers.toArray(new PropertyProvider[providers.size()]));
            providers.add(new ApisupportAntUtils.UserPropertiesFileProvider(baseEval, dir));
            baseEval = PropertyUtils.sequentialPropertyEvaluator((PropertyProvider)predefs, (PropertyProvider[])providers.toArray(new PropertyProvider[providers.size()]));
            providers.add(new DestDirProvider(baseEval));
        }
        if (type == NbModuleType.NETBEANS_ORG) {
            File nbbuild = new File(nbroot, "nbbuild");
            providers.add(PropertyUtils.propertiesFilePropertyProvider((File)new File(nbbuild, "user.build.properties")));
            providers.add(PropertyUtils.propertiesFilePropertyProvider((File)new File(nbbuild, "site.build.properties")));
            providers.add(PropertyUtils.propertiesFilePropertyProvider((File)new File(System.getProperty("user.home"), ".nbbuild.properties")));
        }
        baseEval = PropertyUtils.sequentialPropertyEvaluator((PropertyProvider)predefs, (PropertyProvider[])providers.toArray(new PropertyProvider[providers.size()]));
        providers.add(new NbJdkProvider(baseEval));
        providers.add(privateProperties);
        providers.add(projectProperties);
        HashMap<String, String> defaults = new HashMap<String, String>();
        if (codeNameBase != null) {
            defaults.put("code.name.base.dashes", codeNameBase.replace('.', '-'));
        }
        defaults.put("module.jar.dir", "modules");
        defaults.put("module.jar.basename", "${code.name.base.dashes}.jar");
        defaults.put("module.jar", "${module.jar.dir}/${module.jar.basename}");
        defaults.put("manifest.mf", "manifest.mf");
        defaults.put("src.dir", "src");
        defaults.put("build.dir", "build");
        defaults.put("build.classes.dir", "${build.dir}/classes");
        defaults.put("release.dir", "release");
        defaults.put("javac.source", "1.4");
        if (type == NbModuleType.NETBEANS_ORG) {
            defaults.put("test.user.dir", "${nb_all}/nbbuild/testuserdir");
        } else if (type == NbModuleType.STANDALONE) {
            defaults.put("test.user.dir", "${build.dir}/testuserdir");
        } else {
            defaults.put("suite.build.dir", "${suite.dir}/build");
            defaults.put("test.user.dir", "${suite.build.dir}/testuserdir");
        }
        HashSet<String> testTypes = new HashSet<String>(Arrays.asList(NbModuleProject.COMMON_TEST_TYPES));
        for (String testType : testTypes) {
            defaults.put("test." + testType + ".src.dir", "test/" + testType + "/src");
            defaults.put("test." + testType + ".data.dir", "test/" + testType + "/data");
            defaults.put("build.test." + testType + ".classes.dir", "${build.dir}/test/" + testType + "/classes");
        }
        providers.add(PropertyUtils.fixedPropertyProvider(defaults));
        try {
            providers.add(PropertyUtils.fixedPropertyProvider(Collections.singletonMap("cluster", ModuleList.findClusterLocation(dir, nbroot, type))));
        }
        catch (IOException ex) {
            Logger.getLogger(this.getClass().getName()).log(Level.INFO, null, ex);
        }
        if (ml != null) {
            ModuleEntry javacapi;
            providers.add(PropertyUtils.fixedPropertyProvider(Collections.singletonMap("module.classpath", this.computeModuleClasspath(ml))));
            providers.add(PropertyUtils.fixedPropertyProvider(Collections.singletonMap("module.run.classpath", this.computeRuntimeModuleClasspath(ml))));
            HashMap<String, String> buildDefaults = new HashMap<String, String>();
            buildDefaults.put("cp.extra", "");
            buildDefaults.put(CP, "${module.classpath}:${cp.extra}");
            buildDefaults.put(RUN_CP, "${module.run.classpath}:${cp.extra}:${build.classes.dir}");
            if (type == NbModuleType.NETBEANS_ORG && "true".equals(projectProperties.getProperties().get("requires.nb.javac")) && (javacapi = ml.getEntry("org.netbeans.libs.javacapi")) != null) {
                buildDefaults.put("bootclasspath.prepend", javacapi.getClassPathExtensions());
            }
            baseEval = PropertyUtils.sequentialPropertyEvaluator((PropertyProvider)predefs, (PropertyProvider[])providers.toArray(new PropertyProvider[providers.size()]));
            Map<String, TestClasspath> testsCPs = this.computeTestingClassPaths(ml, baseEval, testTypes);
            testTypes.addAll(testsCPs.keySet());
            for (String testType : testTypes) {
                buildDefaults.put("test." + testType + ".cp.extra", "");
                TestClasspath tcp = TestClasspath.getOrEmpty(testsCPs, testType);
                String commonCPEntries = "${module.run.classpath}:${cp.extra}:${cluster}/${module.jar}:${test." + testType + ".cp.extra}:";
                buildDefaults.put("test." + testType + ".cp", commonCPEntries + tcp.getCompileClasspath());
                buildDefaults.put("test." + testType + ".run.cp.extra", "");
                buildDefaults.put("test." + testType + ".run.cp", "${build.test." + testType + ".classes.dir}:" + commonCPEntries + "${test." + testType + ".run.cp.extra}:" + tcp.getRuntimeClasspath());
            }
            providers.add(PropertyUtils.fixedPropertyProvider(buildDefaults));
        }
        return PropertyUtils.sequentialPropertyEvaluator((PropertyProvider)predefs, (PropertyProvider[])providers.toArray(new PropertyProvider[providers.size()]));
    }

    private String computeModuleClasspath(ModuleList ml) {
        Element data = this.project.getPrimaryConfigurationData();
        Element moduleDependencies = XMLUtil.findElement((Element)data, (String)"module-dependencies", (String)"http://www.netbeans.org/ns/nb-module-project/3");
        assert (moduleDependencies != null) : "Malformed metadata in " + this.project;
        StringBuilder cp = new StringBuilder();
        for (Element dep : XMLUtil.findSubElements((Element)moduleDependencies)) {
            if (XMLUtil.findElement((Element)dep, (String)"compile-dependency", (String)"http://www.netbeans.org/ns/nb-module-project/3") == null) continue;
            Element cnbEl = XMLUtil.findElement((Element)dep, (String)"code-name-base", (String)"http://www.netbeans.org/ns/nb-module-project/3");
            String cnb = XMLUtil.findText((Node)cnbEl);
            ModuleEntry module = ml.getEntry(cnb);
            if (module == null) {
                Util.err.log(16, "Warning - could not find dependent module " + cnb + " for " + FileUtil.getFileDisplayName((FileObject)this.project.getProjectDirectory()));
                continue;
            }
            File moduleJar = module.getJarLocation();
            if (cp.length() > 0) {
                cp.append(File.pathSeparatorChar);
            }
            cp.append(moduleJar.getAbsolutePath());
            cp.append(module.getClassPathExtensions());
        }
        this.appendMyOwnClassPathExtensions(cp);
        return cp.toString();
    }

    private String computeRuntimeModuleClasspath(ModuleList ml) {
        HashSet<String> unprocessed = new HashSet<String>();
        unprocessed.add(this.project.getCodeNameBase());
        HashSet<String> processed = new HashSet<String>();
        StringBuilder cp = new StringBuilder();
        if (cachedProjectModuleEntries.get(this.project) == null) {
            cachedProjectModuleEntries.put(this.project, new HashMap());
        }
        Map<String, SoftReference<ModuleEntry>> cachedModuleEntries = cachedProjectModuleEntries.get(this.project);
        while (!unprocessed.isEmpty()) {
            Iterator it = unprocessed.iterator();
            String cnb = (String)it.next();
            it.remove();
            if (!processed.add(cnb)) continue;
            ModuleEntry module = null;
            if (cachedModuleEntries.get(cnb) != null && cachedModuleEntries.get(cnb).get() != null) {
                module = cachedModuleEntries.get(cnb).get();
            } else {
                module = ml.getEntry(cnb);
                cachedProjectModuleEntries.get(this.project).put(cnb, new SoftReference<ModuleEntry>(module));
            }
            if (module == null) {
                Util.err.log(16, "Warning - could not find dependent module " + cnb + " for " + FileUtil.getFileDisplayName((FileObject)this.project.getProjectDirectory()));
                continue;
            }
            if (!cnb.equals(this.project.getCodeNameBase())) {
                if (cp.length() > 0) {
                    cp.append(File.pathSeparatorChar);
                }
                cp.append(module.getJarLocation().getAbsolutePath());
                cp.append(module.getClassPathExtensions());
            }
            String[] newDeps = module.getRunDependencies();
            unprocessed.addAll(Arrays.asList(newDeps));
        }
        this.appendMyOwnClassPathExtensions(cp);
        return cp.toString();
    }

    private void appendMyOwnClassPathExtensions(StringBuilder cp) {
        Map<String, String> cpext = new ProjectXMLManager(this.project).getClassPathExtensions();
        for (Map.Entry<String, String> entry : cpext.entrySet()) {
            String binaryOrigin;
            if (cp.length() > 0) {
                cp.append(File.pathSeparatorChar);
            }
            if ((binaryOrigin = entry.getValue()) != null) {
                cp.append(this.project.getHelper().resolveFile(binaryOrigin));
                continue;
            }
            cp.append(PropertyUtils.resolveFile((File)this.project.getModuleJarLocation().getParentFile(), (String)entry.getKey()));
        }
    }

    private Map<String, TestClasspath> computeTestingClassPaths(ModuleList ml, PropertyEvaluator evaluator, Set<String> extraTestTypes) {
        HashMap<String, TestClasspath> classpaths = new HashMap<String, TestClasspath>();
        ProjectXMLManager pxm = new ProjectXMLManager(this.project);
        Map<String, Set<TestModuleDependency>> testDependencies = pxm.getTestDependencies(ml);
        String testDistDir = evaluator.getProperty("test.dist.dir");
        if (testDistDir == null) {
            NbModuleType type = this.project.getModuleType();
            if (type == NbModuleType.NETBEANS_ORG) {
                String nball = evaluator.getProperty("nb_all");
                testDistDir = nball + File.separatorChar + "nbbuild" + File.separatorChar + "build" + File.separatorChar + "testdist";
            } else if (type == NbModuleType.SUITE_COMPONENT) {
                String suiteDir = evaluator.getProperty("suite.build.dir");
                testDistDir = suiteDir + File.separatorChar + "testdist";
            } else {
                String moduleDir = evaluator.getProperty("build.dir");
                testDistDir = moduleDir + File.separatorChar + "testdist";
            }
        }
        for (Map.Entry<String, Set<TestModuleDependency>> entry : testDependencies.entrySet()) {
            this.computeTestType(entry.getKey(), new File(testDistDir), entry.getValue(), classpaths, ml);
        }
        for (String testType : extraTestTypes) {
            if (testDependencies.containsKey(testType)) continue;
            this.computeTestType(testType, new File(testDistDir), Collections.emptySet(), classpaths, ml);
        }
        return classpaths;
    }

    private void computeTestType(String ttName, File testDistDir, Set<TestModuleDependency> ttModules, Map<String, TestClasspath> classpaths, ModuleList ml) {
        HashSet<String> compileCnbs = new HashSet<String>();
        HashSet<String> runtimeCnbs = new HashSet<String>();
        HashSet<String> testCompileCnbs = new HashSet<String>();
        HashSet<String> testRuntimeCnbs = new HashSet<String>();
        Logger logger = Logger.getLogger(Evaluator.class.getName());
        HashMap<String, Boolean> processedRecursive = new HashMap<String, Boolean>();
        for (TestModuleDependency td : ttModules) {
            String cnb = td.getModule().getCodeNameBase();
            logger.log(Level.FINE, "computeTestType: processing ''{0}''", cnb);
            if (td.isRecursive()) {
                HashSet<String> unprocessed = new HashSet<String>();
                String codeNameBase = this.project.getCodeNameBase();
                unprocessed.add(td.getModule().getCodeNameBase());
                while (!unprocessed.isEmpty()) {
                    Iterator it = unprocessed.iterator();
                    String recursiveCNB = (String)it.next();
                    it.remove();
                    Boolean alreadyInCompileCP = (Boolean)processedRecursive.get(recursiveCNB);
                    if (Boolean.TRUE.equals(alreadyInCompileCP) || Boolean.FALSE.equals(alreadyInCompileCP) && !td.isCompile()) continue;
                    logger.log(Level.FINE, "computeTestType: processing ''{0}''", recursiveCNB);
                    ModuleEntry module = ml.getEntry(recursiveCNB);
                    if (module == null) {
                        Util.err.log(16, "Warning - could not find dependent module " + recursiveCNB + " for " + FileUtil.getFileDisplayName((FileObject)this.project.getProjectDirectory()));
                        continue;
                    }
                    if (!recursiveCNB.equals(codeNameBase)) {
                        runtimeCnbs.add(recursiveCNB);
                        if (td.isCompile()) {
                            compileCnbs.add(recursiveCNB);
                        }
                        processedRecursive.put(recursiveCNB, td.isCompile());
                    }
                    String[] newDeps = module.getRunDependencies();
                    unprocessed.addAll(Arrays.asList(newDeps));
                }
            } else {
                runtimeCnbs.add(cnb);
                if (td.isCompile()) {
                    compileCnbs.add(cnb);
                }
            }
            if (!td.isTest()) continue;
            if (td.isCompile()) {
                testCompileCnbs.add(cnb);
            }
            testRuntimeCnbs.add(cnb);
        }
        StringBuilder extra = new StringBuilder();
        TestClasspath testClasspath = new TestClasspath(this.mergePaths(compileCnbs, false, ttName, testDistDir, ml) + extra, this.mergePaths(runtimeCnbs, false, ttName, testDistDir, ml) + extra, this.mergePaths(testCompileCnbs, true, ttName, testDistDir, ml), this.mergePaths(testRuntimeCnbs, true, ttName, testDistDir, ml));
        classpaths.put(ttName, testClasspath);
    }

    private String mergePaths(Set<String> cnbs, boolean test, String testtype, File testDistDir, ModuleList ml) {
        StringBuilder cps = new StringBuilder();
        for (String cnb : cnbs) {
            ModuleEntry module = ml.getEntry(cnb);
            if (module == null) {
                if (!warnedModules.add(cnb)) continue;
                Logger.getLogger(Evaluator.class.getName()).log(Level.WARNING, "Cannot find test module dependency: {0}", cnb);
                continue;
            }
            if (cps.length() > 0) {
                cps.append(':');
            }
            if (test) {
                File clusterDir = module.getClusterDirectory();
                if (clusterDir == null) continue;
                String clusterName = clusterDir.getName();
                char s = File.separatorChar;
                File jarFile = new File(testDistDir, testtype + s + clusterName + s + cnb.replace('.', '-') + s + "tests.jar");
                cps.append(jarFile.getPath());
                if (testtype.equals("unit")) continue;
                cps.append(':');
                jarFile = new File(testDistDir, "unit" + s + clusterName + s + cnb.replace('.', '-') + s + "tests.jar");
                cps.append(jarFile.getPath());
                continue;
            }
            cps.append(module.getJarLocation().getPath());
            cps.append(module.getClassPathExtensions());
        }
        return cps.toString();
    }

    private final class NbJdkProvider
    implements PropertyProvider,
    PropertyChangeListener {
        private final PropertyEvaluator eval;
        private final ChangeSupport changeSupport = new ChangeSupport((Object)this);
        private final PropertyChangeListener weakListener = WeakListeners.propertyChange((PropertyChangeListener)this, null);

        public NbJdkProvider(PropertyEvaluator eval) {
            this.eval = eval;
            eval.addPropertyChangeListener(this.weakListener);
            JavaPlatformManager.getDefault().addPropertyChangeListener(this.weakListener);
        }

        public final Map<String, String> getProperties() {
            String toolsJar;
            Collection installs;
            JavaPlatform platform;
            String active;
            HashMap<String, String> props = new HashMap<String, String>();
            String home = this.eval.getProperty(Evaluator.NBJDK_HOME);
            if (home == null && (active = this.eval.getProperty("nbjdk.active")) != null && !active.equals("default") && (home = this.eval.getProperty("platforms." + active + ".home")) != null) {
                props.put(Evaluator.NBJDK_HOME, home);
            }
            if (home == null && (platform = JavaPlatformManager.getDefault().getDefaultPlatform()) != null && (installs = platform.getInstallFolders()).size() == 1) {
                home = FileUtil.toFile((FileObject)((FileObject)installs.iterator().next())).getAbsolutePath();
            }
            Object bootcp = null;
            if (home != null) {
                FileObject homeFO = FileUtil.toFileObject((File)FileUtil.normalizeFile((File)new File(home)));
                if (homeFO != null) {
                    for (JavaPlatform platform2 : JavaPlatformManager.getDefault().getInstalledPlatforms()) {
                        if (!new HashSet(platform2.getInstallFolders()).equals(Collections.singleton(homeFO))) continue;
                        ClassPath boot = platform2.getBootstrapLibraries();
                        boot.removePropertyChangeListener(this.weakListener);
                        boot.addPropertyChangeListener(this.weakListener);
                        if (JDK9.compareTo((Object)platform2.getSpecification().getVersion()) <= 0) {
                            File locf;
                            Collection loc = platform2.getInstallFolders();
                            if (loc.isEmpty() || (locf = FileUtil.toFile((FileObject)((FileObject)loc.iterator().next()))) == null) continue;
                            bootcp = locf;
                            break;
                        }
                        bootcp = boot.toString(ClassPath.PathConversionMode.WARN);
                        break;
                    }
                }
                if (bootcp == null) {
                    File jHome;
                    if (home != null && (jHome = new File(home, "jre/lib")).isDirectory()) {
                        String[] jars = jHome.list(new FilenameFilter(){

                            @Override
                            public boolean accept(File dir, String name) {
                                String n = name.toLowerCase(Locale.US);
                                return n.endsWith(".jar");
                            }
                        });
                        StringBuilder sb = new StringBuilder();
                        for (String jar : jars) {
                            if (sb.length() > 0) {
                                sb.append(File.pathSeparator);
                            }
                            sb.append("${nbjdk.home}/jre/lib/").append(jar);
                        }
                        bootcp = sb.toString().replace('/', File.separatorChar);
                    } else {
                        bootcp = "${nbjdk.home" + "}/jre/lib/rt.jar".replace('/', File.separatorChar);
                    }
                }
            }
            if (bootcp == null) {
                bootcp = "${sun.boot.class.path}";
            }
            if (bootcp instanceof File) {
                props.remove(Evaluator.NBJDK_BOOTCLASSPATH);
                props.put(Evaluator.NBJDK_BOOTCLASSPATH_MODULAR, ((File)bootcp).getAbsolutePath());
            } else if (bootcp instanceof String) {
                props.remove(Evaluator.NBJDK_BOOTCLASSPATH_MODULAR);
                props.put(Evaluator.NBJDK_BOOTCLASSPATH, (String)bootcp);
            }
            if (home != null && new File(toolsJar = home + "/lib/tools.jar".replace('/', File.separatorChar)).exists()) {
                props.put("tools.jar", toolsJar);
            }
            if (Util.err.isLoggable(1)) {
                TreeMap<String, String> _props = new TreeMap<String, String>(this.eval.getProperties());
                Iterator it = _props.keySet().iterator();
                while (it.hasNext()) {
                    String k = (String)it.next();
                    if (k.startsWith("nbjdk.") || k.startsWith("platforms.")) continue;
                    it.remove();
                }
                _props.putAll(props);
                Util.err.log("JDK-related properties of " + Evaluator.this.project + ": " + _props);
            }
            return props;
        }

        public final void addChangeListener(ChangeListener l) {
            this.changeSupport.addChangeListener(l);
        }

        public final void removeChangeListener(ChangeListener l) {
            this.changeSupport.removeChangeListener(l);
        }

        @Override
        public final void propertyChange(PropertyChangeEvent evt) {
            String p = evt.getPropertyName();
            if (!(p == null || p.startsWith("nbjdk.") || p.startsWith("platforms.") || p.equals("entries") || p.equals("installedPlatforms"))) {
                return;
            }
            if (!this.changeSupport.hasListeners()) {
                return;
            }
            Mutex.Action<Void> action = new Mutex.Action<Void>(){

                public Void run() {
                    NbJdkProvider.this.changeSupport.fireChange();
                    return null;
                }
            };
            if (ProjectManager.mutex().isWriteAccess()) {
                ProjectManager.mutex().readAccess((Mutex.Action)action);
            } else if (ProjectManager.mutex().isReadAccess()) {
                action.run();
            } else {
                RP.post(new Runnable((Mutex.Action)action){
                    final /* synthetic */ Mutex.Action val$action;
                    {
                        this.val$action = action;
                    }

                    @Override
                    public void run() {
                        ProjectManager.mutex().readAccess(this.val$action);
                    }
                });
            }
        }
    }

    private static class TestClasspath {
        private final String compile;
        private final String runtime;
        private final String testCompile;
        private final String testRuntime;

        public TestClasspath(String compile, String runtime, String testCompile, String testRuntime) {
            this.compile = compile;
            this.runtime = runtime;
            this.testCompile = testCompile;
            this.testRuntime = testRuntime;
        }

        public String getCompileClasspath() {
            return this.compile + ':' + this.testCompile;
        }

        public String getRuntimeClasspath() {
            return this.runtime + ':' + this.testRuntime;
        }

        private static TestClasspath getOrEmpty(Map<String, TestClasspath> testsCPs, String testtype) {
            TestClasspath tcp = testsCPs.get(testtype);
            if (tcp == null) {
                tcp = new TestClasspath("", "", "", "");
            }
            return tcp;
        }
    }
}

