/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.api.io;

import org.netbeans.api.annotations.common.NonNull;
import org.netbeans.api.io.OutputColorAccessorImpl;
import org.netbeans.modules.io.OutputColorAccessor;
import org.netbeans.spi.io.support.OutputColorType;

public abstract class OutputColor {
    private final OutputColorType type;
    private static final OutputColor CLR_WARNING = new TypeColor(OutputColorType.WARNING);
    private static final OutputColor CLR_FAILURE = new TypeColor(OutputColorType.FAILURE);
    private static final OutputColor CLR_DEBUG = new TypeColor(OutputColorType.DEBUG);
    private static final OutputColor CLR_SUCCESS = new TypeColor(OutputColorType.SUCCESS);

    private OutputColor(OutputColorType type) {
        this.type = type;
    }

    OutputColorType getType() {
        return this.type;
    }

    @NonNull
    public static OutputColor warning() {
        return CLR_WARNING;
    }

    @NonNull
    public static OutputColor failure() {
        return CLR_FAILURE;
    }

    @NonNull
    public static OutputColor debug() {
        return CLR_DEBUG;
    }

    @NonNull
    public static OutputColor success() {
        return CLR_SUCCESS;
    }

    @NonNull
    public static OutputColor rgb(int r, int g, int b) {
        OutputColor.checkColorComponentRange("r", r);
        OutputColor.checkColorComponentRange("g", g);
        OutputColor.checkColorComponentRange("b", b);
        int value = (r & 0xFF) << 16 | (g & 0xFF) << 8 | b & 0xFF;
        return OutputColor.rgb(value);
    }

    @NonNull
    public static OutputColor rgb(int rgbValue) {
        return new RgbColor(rgbValue);
    }

    private static void checkColorComponentRange(String name, int colorComponent) {
        if (colorComponent < 0 || colorComponent > 255) {
            throw new IllegalArgumentException("Color component " + name + " is out of range (0 - 255): " + colorComponent);
        }
    }

    static {
        OutputColorAccessor.setDefault(new OutputColorAccessorImpl());
    }

    static class RgbColor
    extends OutputColor {
        private final int value;

        public RgbColor(int value) {
            super(OutputColorType.RGB);
            this.value = value;
        }

        public int getRGB() {
            return this.value;
        }
    }

    private static class TypeColor
    extends OutputColor {
        public TypeColor(OutputColorType type) {
            super(type);
        }
    }
}

