/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.docker.ui.node;

import java.util.Objects;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.swing.event.ChangeListener;
import org.netbeans.modules.docker.api.DockerAction;
import org.netbeans.modules.docker.api.DockerInstance;
import org.netbeans.modules.docker.api.DockerSupport;
import org.netbeans.modules.docker.ui.node.Refreshable;
import org.openide.util.ChangeSupport;
import org.openide.util.RequestProcessor;

public class StatefulDockerInstance
implements Refreshable {
    private static final RequestProcessor RP = new RequestProcessor(StatefulDockerInstance.class);
    private final ChangeSupport changeSupport = new ChangeSupport((Object)this);
    private final AtomicBoolean available = new AtomicBoolean(true);
    private final DockerInstance.ConnectionListener listener = new DockerInstance.ConnectionListener(){

        public void onConnect() {
            StatefulDockerInstance.this.update(true);
        }

        public void onDisconnect() {
            StatefulDockerInstance.this.update(false);
        }
    };
    private final DockerInstance instance;

    public StatefulDockerInstance(DockerInstance instance) {
        this.instance = instance;
        instance.addConnectionListener(this.listener);
    }

    public void addChangeListener(ChangeListener listener) {
        this.changeSupport.addChangeListener(listener);
    }

    public void removeChangeListener(ChangeListener listener) {
        this.changeSupport.removeChangeListener(listener);
    }

    public DockerInstance getInstance() {
        return this.instance;
    }

    public boolean isAvailable() {
        return this.available.get();
    }

    @Override
    public void refresh() {
        RP.post(new Runnable(){

            @Override
            public void run() {
                StatefulDockerInstance.this.update(new DockerAction(StatefulDockerInstance.this.instance).ping());
            }
        });
    }

    public void remove() {
        this.instance.removeConnectionListener(this.listener);
        DockerSupport.getDefault().removeInstance(this.instance);
    }

    public int hashCode() {
        int hash = 7;
        hash = 61 * hash + Objects.hashCode(this.instance);
        return hash;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        StatefulDockerInstance other = (StatefulDockerInstance)obj;
        return Objects.equals(this.instance, other.instance);
    }

    private void update(boolean newValue) {
        boolean oldValue = this.available.getAndSet(newValue);
        if (oldValue != newValue) {
            this.changeSupport.fireChange();
        }
    }
}

