/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.performance.utilities;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.PrintStream;
import java.util.HashMap;
import java.util.TreeSet;
import java.util.logging.Level;
import java.util.logging.Logger;
import junit.framework.Assert;
import org.netbeans.junit.NbPerformanceTestCase;
import org.netbeans.modules.performance.utilities.CommonUtilities;

public class MeasureStartupTimeTestCase
extends NbPerformanceTestCase {
    protected static final String UNIX = "unix";
    protected static final String WINDOWS = "windows";
    protected static final String MAC = "mac";
    protected static final String UNKNOWN = "unknown";
    protected static int repeat = Integer.getInteger("org.netbeans.performance.repeat", 1);
    protected static int repeatNewUserdir = Integer.getInteger("org.netbeans.performance.repeat.with.new.userdir", 1);
    protected static final long UNKNOWN_TIME = -1L;
    protected static final String[][] SUPPORTED_PLATFORMS = new String[][]{{"Linux,i386", "unix"}, {"Linux,amd64", "unix"}, {"SunOS,sparc", "unix"}, {"SunOS,x86", "unix"}, {"Windows_NT,x86", "windows"}, {"Windows_NT,amd64", "windows"}, {"Windows_2000,x86", "windows"}, {"Windows_2000,amd64", "windows"}, {"Windows_XP,x86", "windows"}, {"Windows_XP,amd64", "windows"}, {"Windows_95,x86", "windows"}, {"Windows_95,amd64", "windows"}, {"Windows_98,x86", "windows"}, {"Windows_98,amd64", "windows"}, {"Windows_Me,x86", "windows"}, {"Windows_Me,amd64", "windows"}, {"Windows_Vista,x86", "windows"}, {"Windows_Vista,amd64", "windows"}, {"Windows_7,x86", "windows"}, {"Windows_7,amd64", "windows"}, {"Windows_8,x86", "windows"}, {"Windows_8,amd64", "windows"}, {"Mac_OS_X,ppc", "mac"}};
    protected static final String[][] STARTUP_DATA = new String[][]{{"ModuleSystem.readList finished", "ModuleSystem.readList finished, took ", "ms"}, {"Preparation finished", "Preparation finished, took ", "ms"}, {"Window system loaded", "Window system loaded dT=", ""}, {"Window system shown", "Window system shown dT=", ""}, {"Start", "IDE starts t = ", ""}, {"End", "IDE is running t=", ""}, {"Lookups set", "Lookups set dT=", ""}};
    public static final String separator = System.getProperty("file.separator");

    public MeasureStartupTimeTestCase(String testName) {
        super(testName);
    }

    protected void measureComplexStartupTime(String performanceDataName) throws IOException {
        if (new StatusFile().exists()) {
            MeasureStartupTimeTestCase.fail((String)("Prepare failed, so do the measurement of [" + performanceDataName + "]"));
        }
        for (int i = 1; i <= repeat; ++i) {
            long measuredTime = this.runIDEandMeasureStartup(performanceDataName, this.getMeasureFile(i), this.getUserdirFile(), 30000L);
            this.reportPerformance(performanceDataName, measuredTime, "ms", 2);
        }
    }

    protected long runIDEandMeasureStartup(String performanceDataName, File measureFile, File userdir, long timeout) throws IOException {
        try {
            long startTime = MeasureStartupTimeTestCase.runIDE(MeasureStartupTimeTestCase.getIdeHome(), userdir, measureFile, timeout);
            HashMap<String, Long> measuredValues = MeasureStartupTimeTestCase.parseMeasuredValues(measureFile);
            Long tempValue = measuredValues.get("IDE starts t = ");
            long runTime = 0L;
            long endTime = 0L;
            if (tempValue != null) {
                runTime = tempValue;
                measuredValues.remove("IDE starts t = ");
            }
            if ((tempValue = measuredValues.get("IDE is running t=")) != null) {
                endTime = tempValue;
                measuredValues.remove("IDE is running t=");
            }
            long startupTime = endTime - startTime;
            System.out.println("\t" + startTime + " -> run from command line (start) ");
            System.out.println("\t" + runTime + " -> time from -Dorg.netbeans.log.startup.logfile - IDE starts (run)");
            System.out.println("\t" + endTime + " -> time from RepaintManager - IDE is running (end)");
            System.out.println("Measured Startup Time=" + startupTime + " / IDE run=" + (runTime - startTime));
            if (startupTime <= 0L) {
                MeasureStartupTimeTestCase.fail((String)("Measured value [" + startupTime + "] is not > 0 !"));
            }
            this.reportPerformance(performanceDataName + " | IDE run", runTime - startTime, "ms", 1);
            for (String[] data : STARTUP_DATA) {
                if (measuredValues.containsKey(data[1])) {
                    long value = measuredValues.get(data[1]);
                    System.out.println(data[0] + "=" + value);
                    this.reportPerformance(performanceDataName + " | " + data[0], value, "ms", 1);
                    continue;
                }
                System.out.println("Value for " + data[1] + " isn't present");
            }
            return startupTime;
        }
        catch (CantParseMeasuredValuesException ex) {
            Logger.getLogger(MeasureStartupTimeTestCase.class.getName()).log(Level.SEVERE, null, ex);
            throw new AssertionError((Object)ex);
        }
    }

    protected static String getPlatform() {
        String osName = System.getProperty("os.name", "").toLowerCase();
        if (osName.startsWith(WINDOWS)) {
            return WINDOWS;
        }
        if (osName.startsWith("linux") || osName.startsWith("sun")) {
            return UNIX;
        }
        if (osName.startsWith(MAC)) {
            return MAC;
        }
        return UNKNOWN;
    }

    protected static long runIDE(File ideHome, File userdir, File measureFile, long timeout) throws IOException {
        return MeasureStartupTimeTestCase.runIDE(ideHome, userdir, measureFile, timeout, null);
    }

    static long runIDE(File ideHome, File userdir, File measureFile, long timeout, File[] clusters) throws IOException {
        String classpath = ideHome.getAbsolutePath() + separator + "java" + separator + "modules" + separator + "org-netbeans-modules-performance.jar";
        String test_cmd_suffix = System.getProperty("xtest.perf.commandline.suffix");
        String jdkhome = System.getProperty("java.home");
        if (jdkhome.endsWith("jre")) {
            jdkhome = jdkhome.substring(0, jdkhome.length() - 4);
        }
        File ideBinDir = new File(ideHome, "bin");
        String executor = MeasureStartupTimeTestCase.getPlatform().equals(WINDOWS) ? "netbeans.exe" : "netbeans";
        StringBuffer cmd = new StringBuffer();
        String execDir = System.getProperty("netbeans.performance.exec.dir");
        if (execDir == null) {
            execDir = new File(ideBinDir, executor).getAbsolutePath();
        }
        cmd.append(execDir);
        cmd.append(" --cp:a ").append(classpath);
        String userdirPath = userdir.getAbsolutePath();
        if (userdirPath.indexOf(32) >= 0) {
            cmd.append(" --userdir \"").append(userdirPath).append('\"');
        } else {
            cmd.append(" --userdir ").append(userdirPath);
        }
        if (jdkhome.indexOf(32) >= 0) {
            cmd.append(" --jdkhome \"").append(jdkhome).append('\"');
        } else {
            cmd.append(" --jdkhome ").append(jdkhome);
        }
        cmd.append(" -J-Dnetbeans.full.hack=true");
        String measureFilePath = measureFile.getAbsolutePath();
        if (measureFilePath.indexOf(32) >= 0) {
            cmd.append(" -J-Dorg.netbeans.log.startup.logfile=\"").append(measureFilePath).append('\"');
        } else {
            cmd.append(" -J-Dorg.netbeans.log.startup.logfile=").append(measureFilePath);
        }
        cmd.append(" -J-Dorg.netbeans.log.startup=tests");
        cmd.append(" -J-Dnetbeans.close=true");
        cmd.append(" -J-Dorg.netbeans.CLIHandler.fast.random=true");
        cmd.append(" -J-Dnetbeans.logger.console=false");
        cmd.append(" -J-Dorg.openide.awt.StatusDisplayer.DISPLAY_TIME=0");
        if (test_cmd_suffix != null && !test_cmd_suffix.equalsIgnoreCase("${xtest.perf.commandline.suffix}")) {
            cmd.append(' ').append(test_cmd_suffix.replace('\'', ' ').trim());
        }
        System.out.println("-----------------------------------------------");
        System.out.println("Running: " + cmd);
        Runtime runtime = Runtime.getRuntime();
        long startTime = System.nanoTime() / 1000000L;
        Process ideProcess = runtime.exec(cmd.toString(), null, ideBinDir);
        ThreadReader sout = new ThreadReader(ideProcess.getInputStream(), System.out);
        ThreadReader serr = new ThreadReader(ideProcess.getErrorStream(), System.out);
        try {
            System.out.println("IDE exited with status = " + ideProcess.waitFor());
        }
        catch (InterruptedException ie) {
            ie.printStackTrace(System.err);
            throw new IOException("Caught InterruptedException :" + ie.getMessage(), ie);
        }
        return startTime;
    }

    protected static File getIdeHome() throws IOException {
        String nbHome = System.getProperty("netbeans.dest.dir");
        File ideHome = nbHome != null ? new File(nbHome) : MeasureStartupTimeTestCase.findPlatform().getParentFile();
        if (!ideHome.isDirectory()) {
            throw new IOException("Cannot found netbeans.dest.dir - supplied value is " + nbHome);
        }
        return ideHome;
    }

    private static File findPlatform() {
        try {
            Class<?> lookup = Class.forName("org.openide.util.Lookup");
            File util = new File(lookup.getProtectionDomain().getCodeSource().getLocation().toURI());
            Assert.assertTrue((String)("Util exists: " + util), (boolean)util.exists());
            return util.getParentFile().getParentFile();
        }
        catch (Exception ex) {
            try {
                File nbjunit = new File(MeasureStartupTimeTestCase.class.getProtectionDomain().getCodeSource().getLocation().toURI());
                File harness = nbjunit.getParentFile().getParentFile();
                Assert.assertEquals((String)"NbJUnit is in harness", (String)"harness", (String)harness.getName());
                TreeSet<File> sorted = new TreeSet<File>();
                for (File p : harness.getParentFile().listFiles()) {
                    if (!p.getName().startsWith("platform")) continue;
                    sorted.add(p);
                }
                Assert.assertFalse((String)("Platform shall be found in " + harness.getParent()), (boolean)sorted.isEmpty());
                return (File)sorted.last();
            }
            catch (Exception ex2) {
                Assert.fail((String)("Cannot find utilities JAR: " + ex + " and: " + ex2));
                return null;
            }
        }
    }

    protected File getUserdirFile(int n) throws IOException {
        return new File(this.getWorkDir(), "ideuserdir_" + n);
    }

    protected File getUserdirFile() throws IOException {
        String usdPrep = System.getProperty("userdir.prepared");
        System.err.println("\n\n\nUSERDIR=" + usdPrep);
        if (usdPrep != null) {
            return new File(usdPrep);
        }
        return new File(this.getWorkDir(), "userdir0");
    }

    protected File getMeasureFile(int i, int j) throws IOException {
        return new File(this.getWorkDir(), "measured_startup_" + i + "_" + j + ".txt");
    }

    protected File getMeasureFile(int i) throws IOException {
        return new File(this.getWorkDir(), "measured_startup_" + i + ".txt");
    }

    protected static HashMap<String, Long> parseMeasuredValues(File measuredFile) throws CantParseMeasuredValuesException {
        HashMap<String, Long> measuredValues = new HashMap<String, Long>();
        HashMap<String, String> startup_data = new HashMap<String, String>(STARTUP_DATA.length);
        for (String[] data : STARTUP_DATA) {
            startup_data.put(data[1], data[2]);
        }
        BufferedReader br = null;
        try {
            String readLine;
            br = new BufferedReader(new FileReader(measuredFile));
            block12: while ((readLine = br.readLine()) != null && !startup_data.isEmpty()) {
                try {
                    for (String str : startup_data.keySet()) {
                        int begin = readLine.indexOf(str);
                        if (begin == -1) continue;
                        int end = readLine.indexOf((String)startup_data.get(str));
                        if (end <= begin) {
                            end = readLine.length();
                        }
                        String value = readLine.substring(begin + str.length(), end);
                        measuredValues.put(str, new Long(value));
                        startup_data.remove(str);
                        continue block12;
                    }
                }
                catch (NumberFormatException nfe) {
                    throw new CantParseMeasuredValuesException(nfe);
                }
            }
            HashMap<String, Long> hashMap = measuredValues;
            return hashMap;
        }
        catch (IOException ioe) {
            throw new CantParseMeasuredValuesException(ioe);
        }
        finally {
            if (br != null) {
                try {
                    br.close();
                }
                catch (IOException ioe) {
                    throw new CantParseMeasuredValuesException(ioe);
                }
            }
        }
    }

    public static void createStatusFile() throws IOException {
        new StatusFile().createNewFile();
    }

    private static class StatusFile
    extends File {
        private StatusFile() throws IOException {
            super(CommonUtilities.getTempDir(), "prepare_failed.tmp");
        }
    }

    public static class ThreadReader
    implements Runnable {
        private Thread thread;
        private final BufferedReader br;
        private final PrintStream out;
        private String s;

        public ThreadReader(InputStream in, PrintStream out) {
            this.br = new BufferedReader(new InputStreamReader(in));
            this.out = out;
            this.thread = new Thread(this);
            this.thread.start();
        }

        @Override
        public void run() {
            Thread myThread = Thread.currentThread();
            while (this.thread == myThread) {
                try {
                    this.s = this.br.readLine();
                    if (this.s == null) {
                        this.stop();
                        break;
                    }
                    if (this.out == null) continue;
                    this.out.println(this.s);
                }
                catch (IOException ioe) {
                    ioe.printStackTrace(System.err);
                    if (this.out != null) {
                        this.out.println("Caught IOE when reading IDE's out or err streams:" + ioe);
                    }
                    this.stop();
                }
            }
        }

        public void stop() {
            this.thread = null;
        }
    }

    protected static class CantParseMeasuredValuesException
    extends Exception {
        public CantParseMeasuredValuesException(Throwable cause) {
            super("Can't parse measured values", cause);
        }
    }
}

