/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.lib.profiler.ui.cpu;

import java.awt.BorderLayout;
import java.awt.Component;
import java.text.MessageFormat;
import java.util.Date;
import java.util.ResourceBundle;
import javax.swing.BorderFactory;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import org.netbeans.lib.profiler.results.ResultsSnapshot;
import org.netbeans.lib.profiler.results.coderegion.CodeRegionResultsSnapshot;
import org.netbeans.lib.profiler.ui.components.HTMLTextArea;
import org.netbeans.lib.profiler.utils.StringUtils;

public class CodeRegionSnapshotPanel
extends JPanel {
    private static final ResourceBundle messages = ResourceBundle.getBundle("org.netbeans.lib.profiler.ui.cpu.Bundle");
    private static final String PANEL_NAME = messages.getString("CodeRegionSnapshotPanel_PanelName");
    private static final String NO_RESULTS_REGION_MSG = messages.getString("CodeRegionSnapshotPanel_NoResultsRegionMsg");
    private static final String INDIVIDUAL_TIMES_MSG = messages.getString("CodeRegionSnapshotPanel_IndividualTimesMsg");
    private static final String SUMMARY_TIMES_MSG = messages.getString("CodeRegionSnapshotPanel_SummaryTimesMsg");
    private static final String TOTAL_INVOCATIONS_MSG = messages.getString("CodeRegionSnapshotPanel_TotalInvocationsMsg");
    private static final String ALL_REMEMBERED_MSG = messages.getString("CodeRegionSnapshotPanel_AllRememberedMsg");
    private static final String LAST_REMEMBERED_MSG = messages.getString("CodeRegionSnapshotPanel_LastRememberedMsg");
    private static final String INVOCATIONS_LISTED_MSG = messages.getString("CodeRegionSnapshotPanel_InvocationsListedMsg");
    private static final String AREA_ACCESS_NAME = messages.getString("CodeRegionSnapshotPanel_AreaAccessName");
    private CodeRegionResultsSnapshot snapshot;

    public CodeRegionSnapshotPanel(CodeRegionResultsSnapshot snapshot) {
        this.snapshot = snapshot;
        this.setLayout(new BorderLayout());
        this.setBorder(BorderFactory.createEmptyBorder(12, 12, 12, 12));
        long[] results = snapshot.getTimes();
        long timerCountsInSecond = snapshot.getTimerCountsInSecond();
        StringBuilder resultText = new StringBuilder(results.length * 10);
        StringBuffer summaryOfTimes = new StringBuffer();
        long sum = 0L;
        if (results.length < 2) {
            resultText.append("<i>").append(NO_RESULTS_REGION_MSG).append("</i>");
        } else {
            long max;
            long min = max = results[1];
            int nRes = results.length - 1;
            StringBuffer individualTimes = new StringBuffer();
            for (int i = 1; i < results.length; ++i) {
                long time = results[i];
                sum += time;
                if (time > max) {
                    max = time;
                } else if (time < min) {
                    min = time;
                }
                individualTimes.append(MessageFormat.format(INDIVIDUAL_TIMES_MSG, StringUtils.mcsTimeToString((long)(time * 1000000L / timerCountsInSecond))));
                individualTimes.append("<br>");
            }
            summaryOfTimes.append(MessageFormat.format(SUMMARY_TIMES_MSG, StringUtils.mcsTimeToString((long)(sum * 1000000L / timerCountsInSecond)), StringUtils.mcsTimeToString((long)((long)((double)sum * 1000000.0 / (double)nRes / (double)timerCountsInSecond))), StringUtils.mcsTimeToString((long)(min * 1000000L / timerCountsInSecond)), StringUtils.mcsTimeToString((long)(max * 1000000L / timerCountsInSecond))));
            resultText.append(MessageFormat.format(TOTAL_INVOCATIONS_MSG, "" + results[0]));
            resultText.append(", ");
            if (results[0] <= (long)nRes) {
                resultText.append(ALL_REMEMBERED_MSG);
            } else {
                resultText.append(MessageFormat.format(LAST_REMEMBERED_MSG, "" + nRes));
            }
            resultText.append("<br>");
            resultText.append(summaryOfTimes);
            resultText.append("<br><br><hr><br>");
            resultText.append(individualTimes);
            resultText.append("<br><hr><br>");
            resultText.append(MessageFormat.format(INVOCATIONS_LISTED_MSG, "" + nRes));
            resultText.append(", ");
            resultText.append(summaryOfTimes);
        }
        HTMLTextArea resArea = new HTMLTextArea(resultText.toString());
        resArea.getAccessibleContext().setAccessibleName(AREA_ACCESS_NAME);
        this.add((Component)new JScrollPane(resArea), "Center");
    }

    public ResultsSnapshot getSnapshot() {
        return this.snapshot;
    }

    public String getTitle() {
        return MessageFormat.format(PANEL_NAME, StringUtils.formatUserDate((Date)new Date(this.snapshot.getTimeTaken())));
    }
}

