/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.tls;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Hashtable;
import java.util.Vector;
import org.bouncycastle.tls.Certificate;
import org.bouncycastle.tls.CertificateRequest;
import org.bouncycastle.tls.CertificateStatus;
import org.bouncycastle.tls.CipherSuite;
import org.bouncycastle.tls.DTLSProtocol;
import org.bouncycastle.tls.DTLSRecordLayer;
import org.bouncycastle.tls.DTLSReliableHandshake;
import org.bouncycastle.tls.DTLSTransport;
import org.bouncycastle.tls.DatagramTransport;
import org.bouncycastle.tls.DigitallySigned;
import org.bouncycastle.tls.NewSessionTicket;
import org.bouncycastle.tls.ProtocolVersion;
import org.bouncycastle.tls.SecurityParameters;
import org.bouncycastle.tls.SessionParameters;
import org.bouncycastle.tls.TlsCredentials;
import org.bouncycastle.tls.TlsExtensionsUtils;
import org.bouncycastle.tls.TlsFatalAlert;
import org.bouncycastle.tls.TlsHandshakeHash;
import org.bouncycastle.tls.TlsKeyExchange;
import org.bouncycastle.tls.TlsProtocol;
import org.bouncycastle.tls.TlsServer;
import org.bouncycastle.tls.TlsServerContextImpl;
import org.bouncycastle.tls.TlsSession;
import org.bouncycastle.tls.TlsUtils;
import org.bouncycastle.util.Arrays;

public class DTLSServerProtocol
extends DTLSProtocol {
    protected boolean verifyRequests = true;

    public boolean getVerifyRequests() {
        return this.verifyRequests;
    }

    public void setVerifyRequests(boolean bl) {
        this.verifyRequests = bl;
    }

    public DTLSTransport accept(TlsServer tlsServer, DatagramTransport datagramTransport) throws IOException {
        if (tlsServer == null) {
            throw new IllegalArgumentException("'server' cannot be null");
        }
        if (datagramTransport == null) {
            throw new IllegalArgumentException("'transport' cannot be null");
        }
        ServerHandshakeState serverHandshakeState = new ServerHandshakeState();
        serverHandshakeState.server = tlsServer;
        serverHandshakeState.serverContext = new TlsServerContextImpl(tlsServer.getCrypto());
        tlsServer.init(serverHandshakeState.serverContext);
        serverHandshakeState.serverContext.handshakeBeginning(tlsServer);
        SecurityParameters securityParameters = serverHandshakeState.serverContext.getSecurityParametersHandshake();
        securityParameters.extendedPadding = tlsServer.shouldUseExtendedPadding();
        DTLSRecordLayer dTLSRecordLayer = new DTLSRecordLayer(datagramTransport, tlsServer, 22);
        try {
            DTLSTransport dTLSTransport = this.serverHandshake(serverHandshakeState, dTLSRecordLayer);
            return dTLSTransport;
        }
        catch (TlsFatalAlert tlsFatalAlert) {
            this.abortServerHandshake(serverHandshakeState, dTLSRecordLayer, tlsFatalAlert.getAlertDescription());
            throw tlsFatalAlert;
        }
        catch (IOException iOException) {
            this.abortServerHandshake(serverHandshakeState, dTLSRecordLayer, (short)80);
            throw iOException;
        }
        catch (RuntimeException runtimeException) {
            this.abortServerHandshake(serverHandshakeState, dTLSRecordLayer, (short)80);
            throw new TlsFatalAlert(80, (Throwable)runtimeException);
        }
        finally {
            securityParameters.clear();
        }
    }

    protected void abortServerHandshake(ServerHandshakeState serverHandshakeState, DTLSRecordLayer dTLSRecordLayer, short s) {
        dTLSRecordLayer.fail(s);
        this.invalidateSession(serverHandshakeState);
    }

    protected DTLSTransport serverHandshake(ServerHandshakeState serverHandshakeState, DTLSRecordLayer dTLSRecordLayer) throws IOException {
        Object object;
        SecurityParameters securityParameters = serverHandshakeState.serverContext.getSecurityParametersHandshake();
        DTLSReliableHandshake dTLSReliableHandshake = new DTLSReliableHandshake(serverHandshakeState.serverContext, dTLSRecordLayer);
        DTLSReliableHandshake.Message message = dTLSReliableHandshake.receiveMessage();
        if (message.getType() != 1) {
            throw new TlsFatalAlert(10);
        }
        this.processClientHello(serverHandshakeState, message.getBody());
        this.invalidateSession(serverHandshakeState);
        securityParameters.sessionID = TlsUtils.EMPTY_BYTES;
        serverHandshakeState.tlsSession = TlsUtils.importSession(securityParameters.getSessionID(), null);
        serverHandshakeState.sessionParameters = null;
        Object object2 = this.generateServerHello(serverHandshakeState, dTLSRecordLayer);
        Object object3 = serverHandshakeState.serverContext.getServerVersion();
        dTLSRecordLayer.setReadVersion((ProtocolVersion)object3);
        dTLSRecordLayer.setWriteVersion((ProtocolVersion)object3);
        dTLSReliableHandshake.sendMessage((short)2, (byte[])object2);
        dTLSReliableHandshake.notifyHelloComplete();
        object2 = serverHandshakeState.server.getServerSupplementalData();
        if (object2 != null) {
            object3 = DTLSServerProtocol.generateSupplementalData((Vector)object2);
            dTLSReliableHandshake.sendMessage((short)23, (byte[])object3);
        }
        serverHandshakeState.keyExchange = TlsUtils.initKeyExchangeServer(serverHandshakeState.serverContext, serverHandshakeState.server);
        serverHandshakeState.serverCredentials = TlsProtocol.validateCredentials(serverHandshakeState.server.getCredentials());
        object3 = null;
        Object object4 = new ByteArrayOutputStream();
        if (serverHandshakeState.serverCredentials == null) {
            serverHandshakeState.keyExchange.skipServerCredentials();
        } else {
            serverHandshakeState.keyExchange.processServerCredentials(serverHandshakeState.serverCredentials);
            object3 = serverHandshakeState.serverCredentials.getCertificate();
            DTLSServerProtocol.sendCertificateMessage(serverHandshakeState.serverContext, dTLSReliableHandshake, (Certificate)object3, (OutputStream)object4);
        }
        securityParameters.tlsServerEndPoint = ((ByteArrayOutputStream)object4).toByteArray();
        if (object3 == null || ((Certificate)object3).isEmpty()) {
            serverHandshakeState.allowCertificateStatus = false;
        }
        if (serverHandshakeState.allowCertificateStatus && (object3 = serverHandshakeState.server.getCertificateStatus()) != null) {
            object4 = this.generateCertificateStatus(serverHandshakeState, (CertificateStatus)object3);
            dTLSReliableHandshake.sendMessage((short)22, (byte[])object4);
        }
        if ((object3 = (Object)serverHandshakeState.keyExchange.generateServerKeyExchange()) != null) {
            dTLSReliableHandshake.sendMessage((short)12, (byte[])object3);
        }
        if (serverHandshakeState.serverCredentials != null) {
            serverHandshakeState.certificateRequest = serverHandshakeState.server.getCertificateRequest();
            if (serverHandshakeState.certificateRequest != null) {
                if (TlsUtils.isTLSv12(serverHandshakeState.serverContext) != (serverHandshakeState.certificateRequest.getSupportedSignatureAlgorithms() != null)) {
                    throw new TlsFatalAlert(80);
                }
                serverHandshakeState.certificateRequest = TlsUtils.validateCertificateRequest(serverHandshakeState.certificateRequest, serverHandshakeState.keyExchange);
                object4 = this.generateCertificateRequest(serverHandshakeState, serverHandshakeState.certificateRequest);
                dTLSReliableHandshake.sendMessage((short)13, (byte[])object4);
                TlsUtils.trackHashAlgorithms(dTLSReliableHandshake.getHandshakeHash(), serverHandshakeState.certificateRequest.getSupportedSignatureAlgorithms());
            }
        }
        dTLSReliableHandshake.sendMessage((short)14, TlsUtils.EMPTY_BYTES);
        boolean bl = false;
        TlsUtils.sealHandshakeHash(serverHandshakeState.serverContext, dTLSReliableHandshake.getHandshakeHash(), bl);
        message = dTLSReliableHandshake.receiveMessage();
        if (message.getType() == 23) {
            this.processClientSupplementalData(serverHandshakeState, message.getBody());
            message = dTLSReliableHandshake.receiveMessage();
        } else {
            serverHandshakeState.server.processClientSupplementalData(null);
        }
        if (serverHandshakeState.certificateRequest == null) {
            serverHandshakeState.keyExchange.skipClientCredentials();
        } else if (message.getType() == 11) {
            this.processClientCertificate(serverHandshakeState, message.getBody());
            message = dTLSReliableHandshake.receiveMessage();
        } else {
            if (TlsUtils.isTLSv12(serverHandshakeState.serverContext)) {
                throw new TlsFatalAlert(10);
            }
            this.notifyClientCertificate(serverHandshakeState, Certificate.EMPTY_CHAIN);
        }
        if (message.getType() != 16) {
            throw new TlsFatalAlert(10);
        }
        this.processClientKeyExchange(serverHandshakeState, message.getBody());
        TlsHandshakeHash tlsHandshakeHash = dTLSReliableHandshake.prepareToFinish();
        securityParameters.sessionHash = TlsUtils.getCurrentPRFHash(tlsHandshakeHash);
        TlsProtocol.establishMasterSecret(serverHandshakeState.serverContext, serverHandshakeState.keyExchange);
        dTLSRecordLayer.initPendingEpoch(TlsUtils.initCipher(serverHandshakeState.serverContext));
        if (this.expectCertificateVerifyMessage(serverHandshakeState)) {
            object = dTLSReliableHandshake.receiveMessageBody((short)15);
            this.processCertificateVerify(serverHandshakeState, (byte[])object, tlsHandshakeHash);
        }
        securityParameters.peerVerifyData = DTLSServerProtocol.createVerifyData(serverHandshakeState.serverContext, dTLSReliableHandshake, false);
        this.processFinished(dTLSReliableHandshake.receiveMessageBody((short)20), securityParameters.getPeerVerifyData());
        if (serverHandshakeState.expectSessionTicket) {
            object = serverHandshakeState.server.getNewSessionTicket();
            byte[] byArray = this.generateNewSessionTicket(serverHandshakeState, (NewSessionTicket)object);
            dTLSReliableHandshake.sendMessage((short)4, byArray);
        }
        securityParameters.localVerifyData = DTLSServerProtocol.createVerifyData(serverHandshakeState.serverContext, dTLSReliableHandshake, true);
        dTLSReliableHandshake.sendMessage((short)20, securityParameters.getLocalVerifyData());
        dTLSReliableHandshake.finish();
        serverHandshakeState.sessionParameters = new SessionParameters.Builder().setCipherSuite(securityParameters.getCipherSuite()).setCompressionAlgorithm(securityParameters.getCompressionAlgorithm()).setExtendedMasterSecret(securityParameters.isExtendedMasterSecret()).setLocalCertificate(securityParameters.getLocalCertificate()).setMasterSecret(serverHandshakeState.serverContext.getCrypto().adoptSecret(securityParameters.getMasterSecret())).setNegotiatedVersion(securityParameters.getNegotiatedVersion()).setPeerCertificate(securityParameters.getPeerCertificate()).setPSKIdentity(securityParameters.getPSKIdentity()).setSRPIdentity(securityParameters.getSRPIdentity()).setServerExtensions(serverHandshakeState.serverExtensions).build();
        serverHandshakeState.tlsSession = TlsUtils.importSession(serverHandshakeState.tlsSession.getSessionID(), serverHandshakeState.sessionParameters);
        securityParameters.tlsUnique = securityParameters.getPeerVerifyData();
        serverHandshakeState.serverContext.handshakeComplete(serverHandshakeState.server, serverHandshakeState.tlsSession);
        return new DTLSTransport(dTLSRecordLayer);
    }

    protected byte[] generateCertificateRequest(ServerHandshakeState serverHandshakeState, CertificateRequest certificateRequest) throws IOException {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        certificateRequest.encode(byteArrayOutputStream);
        return byteArrayOutputStream.toByteArray();
    }

    protected byte[] generateCertificateStatus(ServerHandshakeState serverHandshakeState, CertificateStatus certificateStatus) throws IOException {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        certificateStatus.encode(byteArrayOutputStream);
        return byteArrayOutputStream.toByteArray();
    }

    protected byte[] generateNewSessionTicket(ServerHandshakeState serverHandshakeState, NewSessionTicket newSessionTicket) throws IOException {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        newSessionTicket.encode(byteArrayOutputStream);
        return byteArrayOutputStream.toByteArray();
    }

    protected byte[] generateServerHello(ServerHandshakeState serverHandshakeState, DTLSRecordLayer dTLSRecordLayer) throws IOException {
        Object object;
        int n;
        TlsServerContextImpl tlsServerContextImpl = serverHandshakeState.serverContext;
        SecurityParameters securityParameters = tlsServerContextImpl.getSecurityParametersHandshake();
        ProtocolVersion protocolVersion = serverHandshakeState.server.getServerVersion();
        if (null == protocolVersion || !ProtocolVersion.DTLSv10.isEqualOrEarlierVersionOf(protocolVersion) || !ProtocolVersion.contains(tlsServerContextImpl.getClientSupportedVersions(), protocolVersion)) {
            throw new TlsFatalAlert(80);
        }
        securityParameters.negotiatedVersion = protocolVersion;
        securityParameters.serverRandom = TlsProtocol.createRandomBlock(serverHandshakeState.server.shouldUseGMTUnixTime(), tlsServerContextImpl);
        if (!protocolVersion.equals(ProtocolVersion.getLatestDTLS(serverHandshakeState.server.getSupportedVersions()))) {
            TlsUtils.writeDowngradeMarker(protocolVersion, securityParameters.getServerRandom());
        }
        if (!Arrays.contains((int[])serverHandshakeState.offeredCipherSuites, (int)(n = serverHandshakeState.server.getSelectedCipherSuite())) || n == 0 || CipherSuite.isSCSV(n) || !TlsUtils.isValidCipherSuiteForVersion(n, tlsServerContextImpl.getServerVersion())) {
            throw new TlsFatalAlert(80);
        }
        securityParameters.cipherSuite = DTLSServerProtocol.validateSelectedCipherSuite(n, (short)80);
        serverHandshakeState.serverExtensions = TlsExtensionsUtils.ensureExtensionsInitialised(serverHandshakeState.server.getServerExtensions());
        ProtocolVersion protocolVersion2 = protocolVersion;
        if (protocolVersion.isLaterVersionOf(ProtocolVersion.DTLSv12)) {
            protocolVersion2 = ProtocolVersion.DTLSv12;
            TlsExtensionsUtils.addSupportedVersionsExtensionServer(serverHandshakeState.serverExtensions, protocolVersion);
        }
        if (securityParameters.isSecureRenegotiation()) {
            boolean bl;
            object = TlsUtils.getExtensionData(serverHandshakeState.serverExtensions, TlsProtocol.EXT_RenegotiationInfo);
            boolean bl2 = bl = null == object;
            if (bl) {
                serverHandshakeState.serverExtensions.put(TlsProtocol.EXT_RenegotiationInfo, TlsProtocol.createRenegotiationInfo(TlsUtils.EMPTY_BYTES));
            }
        }
        if (securityParameters.isExtendedMasterSecret()) {
            TlsExtensionsUtils.addExtendedMasterSecretExtension(serverHandshakeState.serverExtensions);
        }
        securityParameters.applicationProtocol = TlsExtensionsUtils.getALPNExtensionServer(serverHandshakeState.serverExtensions);
        if (!serverHandshakeState.serverExtensions.isEmpty()) {
            securityParameters.encryptThenMAC = TlsExtensionsUtils.hasEncryptThenMACExtension(serverHandshakeState.serverExtensions);
            securityParameters.maxFragmentLength = DTLSServerProtocol.evaluateMaxFragmentLengthExtension(serverHandshakeState.resumedSession, serverHandshakeState.clientExtensions, serverHandshakeState.serverExtensions, (short)80);
            securityParameters.truncatedHMac = TlsExtensionsUtils.hasTruncatedHMacExtension(serverHandshakeState.serverExtensions);
            serverHandshakeState.allowCertificateStatus = !serverHandshakeState.resumedSession && TlsUtils.hasExpectedEmptyExtensionData(serverHandshakeState.serverExtensions, TlsExtensionsUtils.EXT_status_request, (short)80);
            serverHandshakeState.expectSessionTicket = !serverHandshakeState.resumedSession && TlsUtils.hasExpectedEmptyExtensionData(serverHandshakeState.serverExtensions, TlsProtocol.EXT_SessionTicket, (short)80);
        }
        securityParameters.prfAlgorithm = TlsProtocol.getPRFAlgorithm(tlsServerContextImpl, securityParameters.getCipherSuite());
        securityParameters.verifyDataLength = 12;
        DTLSServerProtocol.applyMaxFragmentLengthExtension(dTLSRecordLayer, securityParameters.getMaxFragmentLength());
        object = new ByteArrayOutputStream();
        TlsUtils.writeVersion(protocolVersion2, (OutputStream)object);
        object.write(securityParameters.getServerRandom());
        TlsUtils.writeOpaque8(serverHandshakeState.tlsSession.getSessionID(), (OutputStream)object);
        TlsUtils.writeUint16(securityParameters.getCipherSuite(), (OutputStream)object);
        TlsUtils.writeUint8((short)0, (OutputStream)object);
        TlsProtocol.writeExtensions((OutputStream)object, serverHandshakeState.serverExtensions);
        return object.toByteArray();
    }

    protected void invalidateSession(ServerHandshakeState serverHandshakeState) {
        if (serverHandshakeState.sessionParameters != null) {
            serverHandshakeState.sessionParameters.clear();
            serverHandshakeState.sessionParameters = null;
        }
        if (serverHandshakeState.tlsSession != null) {
            serverHandshakeState.tlsSession.invalidate();
            serverHandshakeState.tlsSession = null;
        }
    }

    protected void notifyClientCertificate(ServerHandshakeState serverHandshakeState, Certificate certificate) throws IOException {
        TlsUtils.processClientCertificate(serverHandshakeState.serverContext, certificate, serverHandshakeState.certificateRequest, serverHandshakeState.keyExchange, serverHandshakeState.server);
    }

    protected void processClientCertificate(ServerHandshakeState serverHandshakeState, byte[] byArray) throws IOException {
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byArray);
        Certificate certificate = Certificate.parse(serverHandshakeState.serverContext, byteArrayInputStream, null);
        TlsProtocol.assertEmpty(byteArrayInputStream);
        this.notifyClientCertificate(serverHandshakeState, certificate);
    }

    protected void processCertificateVerify(ServerHandshakeState serverHandshakeState, byte[] byArray, TlsHandshakeHash tlsHandshakeHash) throws IOException {
        if (serverHandshakeState.certificateRequest == null) {
            throw new IllegalStateException();
        }
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byArray);
        TlsServerContextImpl tlsServerContextImpl = serverHandshakeState.serverContext;
        DigitallySigned digitallySigned = DigitallySigned.parse(tlsServerContextImpl, byteArrayInputStream);
        TlsProtocol.assertEmpty(byteArrayInputStream);
        TlsUtils.verifyCertificateVerify(tlsServerContextImpl, serverHandshakeState.certificateRequest, digitallySigned, tlsHandshakeHash);
    }

    protected void processClientHello(ServerHandshakeState serverHandshakeState, byte[] byArray) throws IOException {
        byte[] byArray2;
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byArray);
        ProtocolVersion protocolVersion = TlsUtils.readVersion(byteArrayInputStream);
        byte[] byArray3 = TlsUtils.readFully(32, (InputStream)byteArrayInputStream);
        byte[] byArray4 = TlsUtils.readOpaque8(byteArrayInputStream, 0, 32);
        int n = ProtocolVersion.DTLSv12.isEqualOrEarlierVersionOf(protocolVersion) ? 255 : 32;
        byte[] byArray5 = TlsUtils.readOpaque8(byteArrayInputStream, 0, n);
        int n2 = TlsUtils.readUint16(byteArrayInputStream);
        if (n2 < 2 || (n2 & 1) != 0) {
            throw new TlsFatalAlert(50);
        }
        serverHandshakeState.offeredCipherSuites = TlsUtils.readUint16Array(n2 / 2, byteArrayInputStream);
        short s = TlsUtils.readUint8(byteArrayInputStream);
        if (s < 1) {
            throw new TlsFatalAlert(47);
        }
        short[] sArray = TlsUtils.readUint8Array(s, byteArrayInputStream);
        serverHandshakeState.clientExtensions = TlsProtocol.readExtensions(byteArrayInputStream);
        TlsServerContextImpl tlsServerContextImpl = serverHandshakeState.serverContext;
        SecurityParameters securityParameters = tlsServerContextImpl.getSecurityParametersHandshake();
        tlsServerContextImpl.setClientSupportedVersions(TlsExtensionsUtils.getSupportedVersionsExtensionClient(serverHandshakeState.clientExtensions));
        if (null == tlsServerContextImpl.getClientSupportedVersions()) {
            if (protocolVersion.isLaterVersionOf(ProtocolVersion.DTLSv12)) {
                protocolVersion = ProtocolVersion.DTLSv12;
            }
            tlsServerContextImpl.setClientSupportedVersions(protocolVersion.downTo(ProtocolVersion.DTLSv10));
        } else {
            protocolVersion = ProtocolVersion.getLatestDTLS(tlsServerContextImpl.getClientSupportedVersions());
        }
        if (null == protocolVersion || !ProtocolVersion.DTLSv10.isEqualOrEarlierVersionOf(protocolVersion)) {
            throw new TlsFatalAlert(47);
        }
        tlsServerContextImpl.setClientVersion(protocolVersion);
        serverHandshakeState.server.notifyClientVersion(tlsServerContextImpl.getClientVersion());
        securityParameters.clientRandom = byArray3;
        serverHandshakeState.server.notifyFallback(Arrays.contains((int[])serverHandshakeState.offeredCipherSuites, (int)22016));
        serverHandshakeState.server.notifyOfferedCipherSuites(serverHandshakeState.offeredCipherSuites);
        if (!Arrays.contains((short[])sArray, (short)0)) {
            throw new TlsFatalAlert(40);
        }
        securityParameters.extendedMasterSecret = TlsExtensionsUtils.hasExtendedMasterSecretExtension(serverHandshakeState.clientExtensions);
        if (!securityParameters.isExtendedMasterSecret() && serverHandshakeState.server.requiresExtendedMasterSecret()) {
            throw new TlsFatalAlert(40);
        }
        if (Arrays.contains((int[])serverHandshakeState.offeredCipherSuites, (int)255)) {
            securityParameters.secureRenegotiation = true;
        }
        if ((byArray2 = TlsUtils.getExtensionData(serverHandshakeState.clientExtensions, TlsProtocol.EXT_RenegotiationInfo)) != null) {
            securityParameters.secureRenegotiation = true;
            if (!Arrays.constantTimeAreEqual((byte[])byArray2, (byte[])TlsProtocol.createRenegotiationInfo(TlsUtils.EMPTY_BYTES))) {
                throw new TlsFatalAlert(40);
            }
        }
        serverHandshakeState.server.notifySecureRenegotiation(securityParameters.isSecureRenegotiation());
        if (serverHandshakeState.clientExtensions != null) {
            TlsExtensionsUtils.getPaddingExtension(serverHandshakeState.clientExtensions);
            securityParameters.clientServerNames = TlsExtensionsUtils.getServerNameExtensionClient(serverHandshakeState.clientExtensions);
            if (TlsUtils.isSignatureAlgorithmsExtensionAllowed(protocolVersion)) {
                securityParameters.clientSigAlgs = TlsExtensionsUtils.getSignatureAlgorithmsExtension(serverHandshakeState.clientExtensions);
                securityParameters.clientSigAlgsCert = TlsExtensionsUtils.getSignatureAlgorithmsCertExtension(serverHandshakeState.clientExtensions);
            }
            securityParameters.clientSupportedGroups = TlsExtensionsUtils.getSupportedGroupsExtension(serverHandshakeState.clientExtensions);
            serverHandshakeState.server.processClientExtensions(serverHandshakeState.clientExtensions);
        }
    }

    protected void processClientKeyExchange(ServerHandshakeState serverHandshakeState, byte[] byArray) throws IOException {
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byArray);
        serverHandshakeState.keyExchange.processClientKeyExchange(byteArrayInputStream);
        TlsProtocol.assertEmpty(byteArrayInputStream);
    }

    protected void processClientSupplementalData(ServerHandshakeState serverHandshakeState, byte[] byArray) throws IOException {
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byArray);
        Vector vector = TlsProtocol.readSupplementalDataMessage(byteArrayInputStream);
        serverHandshakeState.server.processClientSupplementalData(vector);
    }

    protected boolean expectCertificateVerifyMessage(ServerHandshakeState serverHandshakeState) {
        Certificate certificate = serverHandshakeState.serverContext.getSecurityParametersHandshake().getPeerCertificate();
        return null != certificate && !certificate.isEmpty() && serverHandshakeState.keyExchange.requiresCertificateVerify();
    }

    protected static class ServerHandshakeState {
        TlsServer server = null;
        TlsServerContextImpl serverContext = null;
        TlsSession tlsSession = null;
        SessionParameters sessionParameters = null;
        SessionParameters.Builder sessionParametersBuilder = null;
        int[] offeredCipherSuites = null;
        Hashtable clientExtensions = null;
        Hashtable serverExtensions = null;
        boolean resumedSession = false;
        boolean allowCertificateStatus = false;
        boolean expectSessionTicket = false;
        TlsKeyExchange keyExchange = null;
        TlsCredentials serverCredentials = null;
        CertificateRequest certificateRequest = null;

        protected ServerHandshakeState() {
        }
    }
}

