/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.codegen.optimization.boxing;

import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.codegen.AsmUtil;
import org.jetbrains.kotlin.codegen.state.GenerationState;
import org.jetbrains.kotlin.descriptors.ClassDescriptor;
import org.jetbrains.kotlin.resolve.jvm.AsmTypes;
import org.jetbrains.org.objectweb.asm.Type;

@Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=2, d1={"\u0000\u0018\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\u001a\u0016\u0010\u0000\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u00012\u0006\u0010\u0003\u001a\u00020\u0004\u001a\u0010\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0002\u001a\u00020\u0001H\u0002\u001a\u0018\u0010\u0007\u001a\u0004\u0018\u00010\u00012\u0006\u0010\u0002\u001a\u00020\u00012\u0006\u0010\u0003\u001a\u00020\u0004\u00a8\u0006\b"}, d2={"getUnboxedType", "Lorg/jetbrains/org/objectweb/asm/Type;", "boxedType", "state", "Lorg/jetbrains/kotlin/codegen/state/GenerationState;", "isInlineClassValue", "", "unboxedTypeOfInlineClass", "backend"})
public final class BoxedBasicValueKt {
    @NotNull
    public static final Type getUnboxedType(@NotNull Type boxedType, @NotNull GenerationState state2) {
        Intrinsics.checkParameterIsNotNull(boxedType, "boxedType");
        Intrinsics.checkParameterIsNotNull(state2, "state");
        Type primitiveType = AsmUtil.unboxPrimitiveTypeOrNull(boxedType);
        if (primitiveType != null) {
            return primitiveType;
        }
        if (Intrinsics.areEqual(boxedType, AsmTypes.K_CLASS_TYPE)) {
            Type type2 = AsmTypes.JAVA_CLASS_TYPE;
            Intrinsics.checkExpressionValueIsNotNull(type2, "AsmTypes.JAVA_CLASS_TYPE");
            return type2;
        }
        Type type3 = BoxedBasicValueKt.unboxedTypeOfInlineClass(boxedType, state2);
        if (type3 != null) {
            Type type4 = type3;
            boolean bl = false;
            boolean bl2 = false;
            Type it = type4;
            boolean bl3 = false;
            return it;
        }
        throw (Throwable)new IllegalArgumentException("Expected primitive type wrapper or KClass or inline class wrapper, got: " + boxedType);
    }

    @Nullable
    public static final Type unboxedTypeOfInlineClass(@NotNull Type boxedType, @NotNull GenerationState state2) {
        Intrinsics.checkParameterIsNotNull(boxedType, "boxedType");
        Intrinsics.checkParameterIsNotNull(state2, "state");
        ClassDescriptor classDescriptor2 = CollectionsKt.singleOrNull(state2.getJvmBackendClassResolver().resolveToClassDescriptors(boxedType));
        if (classDescriptor2 == null) {
            return null;
        }
        ClassDescriptor descriptor2 = classDescriptor2;
        return state2.getTypeMapper().mapType(descriptor2.getDefaultType());
    }

    private static final boolean isInlineClassValue(Type boxedType) {
        return !AsmUtil.isBoxedPrimitiveType(boxedType) && Intrinsics.areEqual(boxedType, AsmTypes.K_CLASS_TYPE) ^ true;
    }

    public static final /* synthetic */ boolean access$isInlineClassValue(Type boxedType) {
        return BoxedBasicValueKt.isInlineClassValue(boxedType);
    }
}

