'use strict';

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.registries = undefined;

var _common = require('../common');

var _render_functions_registry = require('./render_functions_registry');

var _browser = require('../plugin/functions/browser');

var _types = require('../plugin/types');

/*
 * Licensed to Elasticsearch B.V. under one or more contributor
 * license agreements. See the NOTICE file distributed with
 * this work for additional information regarding copyright
 * ownership. Elasticsearch B.V. licenses this file to you under
 * the Apache License, Version 2.0 (the "License"); you may
 * not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *    http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */

var registries = exports.registries = {
  browserFunctions: new _common.FunctionsRegistry(),
  renderers: new _render_functions_registry.RenderFunctionsRegistry(),
  types: new _common.TypesRegistry()
};

(0, _common.register)(registries, {
  browserFunctions: _browser.browserFunctions,
  types: _types.typeSpecs
});