#!/bin/sh
export PATH='/usr/local/sbin:/usr/local/bin:/usr/bin:/usr/bin/site_perl:/usr/bin/vendor_perl:/usr/bin/core_perl:/usr/bin/site_perl:/usr/bin/vendor_perl:/usr/bin/core_perl:/usr/bin/site_perl:/usr/bin/vendor_perl:/usr/bin/core_perl:/usr/bin/site_perl:/usr/bin/vendor_perl:/usr/bin/core_perl'
echo 'name: binary-tagged
version: 0.2
id: binary-tagged-0.2-8PKcmtOwTBQ8DCTMMCu9yz
key: binary-tagged-0.2-8PKcmtOwTBQ8DCTMMCu9yz
license: BSD-3-Clause
maintainer: Oleg Grenrus <oleg.grenrus@iki.fi>
author: Oleg Grenrus <oleg.grenrus@iki.fi>
homepage: https://github.com/phadej/binary-tagged#readme
synopsis: Tagged binary serialisation.
description:
    Structurally tag binary serialisation stream.
    .
    Say you have:
    .
    @
    data Record = Record
    \  { _recordFields  :: HM.HashMap Text (Integer, ByteString)
    \  , _recordEnabled :: Bool
    \  }
    \  deriving (Eq, Show, Generic)
    .
    instance Binary Record
    instance HasStructuralInfo Record
    instance HasSemanticVersion Record
    @
    .
    then you can serialise and deserialise @Record@ values with a structure tag by simply
    .
    @
    encodeTaggedFile "cachefile" record
    decodeTaggedFile "cachefile" :: IO Record
    @
    .
    If structure of @Record@ changes in between, deserialisation will fail early.
    .
    The overhead is next to non-observable, see [a simple benchmark](https://github.com/phadej/binary-tagged/blob/master/bench/Bench.hs).
    .
    @
    benchmarking encode/Binary
    time                 362.6 μs   (361.2 μs .. 363.8 μs)
    .
    benchmarking encode/Tagged
    time                 379.2 μs   (375.5 μs .. 382.2 μs)
    .
    benchmarking decode/Binary
    time                 366.3 μs   (365.1 μs .. 368.1 μs)
    .
    benchmarking decode/Tagged
    time                 367.6 μs   (367.0 μs .. 368.2 μs)
    @
category: Data
abi: 4e480fad5761ec35477bd496f28374f8
exposed: True
exposed-modules:
    Data.Binary.Tagged
import-dirs: /usr/lib/ghc-8.6.5/site-local/binary-tagged-0.2
library-dirs: /usr/lib/ghc-8.6.5/site-local/binary-tagged-0.2
dynamic-library-dirs: /usr/lib
data-dir: /usr/share/x86_64-linux-ghc-8.6.5/binary-tagged-0.2
hs-libraries: HSbinary-tagged-0.2-8PKcmtOwTBQ8DCTMMCu9yz
depends:
    aeson-1.4.3.0-BTVTAPf4Xo575Po56SJ3Aq array-0.5.3.0 base-4.12.0.0
    base16-bytestring-0.1.1.6-17atVnUhDnM13pAkKbwL6I binary-0.8.6.0
    bytestring-0.10.8.2 containers-0.6.0.1
    cryptohash-sha1-0.11.100.1-FedZHhK3zTs7eOQXIrPeso
    generics-sop-0.5.0.0-KcRCSh2JEyL6JzNJdcWr49
    hashable-1.2.7.0-KHvCgUH7dIl7mI8fl4akIo
    scientific-0.3.6.2-L1dtV0bHm4E7J1We1UVw6b
    tagged-0.8.6-AoE7RQX12AwJxLvAxGYxtP text-1.2.3.1 time-1.8.0.2
    unordered-containers-0.2.10.0-2N7l4ZvxBr3HGayD0s0P1Q
    vector-0.12.0.3-2LEYu9M2i7lERDtz76XG3n
haddock-interfaces: /usr/share/doc/haskell-binary-tagged/html/binary-tagged.haddock
haddock-html: /usr/share/doc/haskell-binary-tagged/html
' | '/usr/bin/ghc-pkg' 'update' '--force' '-' '--global' '--no-user-package-db' "$@"

