/*
 * Decompiled with CFR 0.152.
 */
package org.grails.core.support;

import java.beans.PropertyEditorSupport;
import org.springframework.util.ClassUtils;

public class ClassEditor
extends PropertyEditorSupport {
    private ClassLoader classLoader;

    public ClassEditor() {
    }

    public ClassEditor(Object source) {
        super(source);
    }

    public void setClassLoader(ClassLoader classLoader) {
        if (classLoader != null) {
            this.classLoader = classLoader;
        }
    }

    @Override
    public String getAsText() {
        return ((Class)this.getValue()).getName();
    }

    @Override
    public void setAsText(String className) throws IllegalArgumentException {
        try {
            Class clazz = ClassUtils.resolvePrimitiveClassName((String)className);
            if (clazz != null) {
                this.setValue(clazz);
            } else {
                ClassLoader cl = this.classLoader != null ? this.classLoader : Thread.currentThread().getContextClassLoader();
                this.setValue(cl.loadClass(className));
            }
        }
        catch (ClassNotFoundException e) {
            throw new IllegalArgumentException("Could not load class [" + className + "]!");
        }
    }
}

