---
comments: false
---

# Get started with GitLab

## Organize

Create projects and groups.

- [Create a new project](../gitlab-basics/create-project.md)
- [Create a new group](../user/group/index.md#create-a-new-group)

## Prioritize

Create issues, labels, milestones, cast your vote, and review issues.

- [Create an issue](../user/project/issues/create_new_issue.md)
- [Assign labels to issues](../user/project/labels.md)
- [Use milestones as an overview of your project's tracker](../user/project/milestones/index.md)
- [Use voting to express your like/dislike to issues and merge requests](../workflow/award_emoji.md)

## Collaborate

Create merge requests and review code.

- [Fork a project and contribute to it](../workflow/forking_workflow.md)
- [Create a new merge request](../gitlab-basics/add-merge-request.md)
- [Automatically close issues from merge requests](../user/project/issues/automatic_issue_closing.md)
- [Automatically merge when pipeline succeeds](../user/project/merge_requests/merge_when_pipeline_succeeds.md)
- [Revert any commit](../user/project/merge_requests/revert_changes.md)
- [Cherry-pick any commit](../user/project/merge_requests/cherry_pick_changes.md)

## Test and Deploy

Use the built-in continuous integration in GitLab.

- [Get started with GitLab CI](../ci/quick_start/README.md)

## Install and Update

Install and update your GitLab installation.

- [Install GitLab](https://about.gitlab.com/installation/)
- [Update GitLab](https://about.gitlab.com/update/)
- [Explore Omnibus GitLab configuration options](http://docs.gitlab.com/omnibus/settings/configuration.html)
