---
comments: false
---

# GitLab basics guides

This section provides resources to help you start with GitLab by focusing on basic functionality.

This documentation is split into the following groups:

- [GitLab-specific functionality](#gitlab-basics), for basic GitLab features.
- [General Git functionality](#git-basics), for working with Git in conjunction with GitLab.

## GitLab basics

The following are guides to basic GitLab functionality:

- [Create and add your SSH Keys](create-your-ssh-keys.md), for enabling Git over SSH.
- [Create a project](create-project.md), to start using GitLab.
- [Create a group](../user/group/index.md#create-a-new-group), to combine and administer projects together.
- [Create a branch](create-branch.md), to make changes to files stored in a project's repository.
- [Fork a project](fork-project.md), to duplicate projects so they can be worked on in parallel.
- [Add a file](add-file.md), to add new files to a project's repository.
- [Add an image](add-image.md), to add new images to a project's repository.
- [Create an issue](../user/project/issues/create_new_issue.md), to start collaborating within a project.
- [Create a merge request](add-merge-request.md), to request changes made in a branch be merged into a project's repository.

## Git basics

If you're unfamiliar with the command line, these resources will help:

- [Command line basics](command-line-commands.md), for those unfamiliar with the command line interface.
- [Start using Git on the command line](start-using-git.md), for some simple Git commands.

More Git resources are available at GitLab's [Git documentation](../topics/git/index.md).
