# OpenID Connect OmniAuth provider

GitLab can use [OpenID Connect](https://openid.net/specs/openid-connect-core-1_0.html) as an OmniAuth provider.

To enable the OpenID Connect OmniAuth provider, you must register your application with an OpenID Connect provider.
The OpenID Connect will provide you with a client details and secret for you to use.

1.  On your GitLab server, open the configuration file.

    For Omnibus GitLab:

    ```sh
    sudo editor /etc/gitlab/gitlab.rb
    ```

    For installations from source:

    ```sh
    cd /home/git/gitlab
    sudo -u git -H editor config/gitlab.yml
    ```

    See [Initial OmniAuth Configuration](../../integration/omniauth.md#initial-omniauth-configuration) for initial settings.

1.  Add the provider configuration.

    For Omnibus GitLab:

    ```ruby
    gitlab_rails['omniauth_providers'] = [
      { 'name' => 'openid_connect',
        'label' => '<your_oidc_label>',
        'args' => {
          'scope' => ['openid','profile'],
          'response_type' => 'code',
          'issuer' => '<your_oidc_url>',
          'discovery' => true,
          'client_auth_method' => 'query',
          'uid_field' => '<uid_field>',
          'client_options' => {
            'identifier' => '<your_oidc_client_id>',
            'secret' => '<your_oidc_client_secret>',
            'redirect_uri' => '<your_gitlab_url>/users/auth/openid_connect/callback'
          }
        }
      }
    ]
    ```

    For installation from source:

    ```yaml
      - { name: 'openid_connect',
          label: '<your_oidc_label>',
          args: {
            scope: ['openid','profile'],
            response_type: 'code',
            issuer: '<your_oidc_url>',
            discovery: true,
            client_auth_method: 'query',
            uid_field: '<uid_field>',
            client_options: {
              identifier: '<your_oidc_client_id>',
              secret: '<your_oidc_client_secret>',
              redirect_uri: '<your_gitlab_url>/users/auth/openid_connect/callback'
            }
          }
        }
    ```

    > **Note:**
    >
    > - For more information on each configuration option refer to
        the [OmniAuth OpenID Connect usage documentation](https://github.com/m0n9oose/omniauth_openid_connect#usage) and
        the [OpenID Connect Core 1.0 specification](https://openid.net/specs/openid-connect-core-1_0.html).

1. For the configuration above, change the values for the provider to match your OpenID Connect client setup. Use the following as a guide:
    - `<your_oidc_label>` is the label that will be displayed on the login page.
    - `<your_oidc_url>` (optional) is the URL that points to the OpenID Connect provider. For example, `https://example.com/auth/realms/your-realm`.
      If this value is not provided, the URL is constructed from the `client_options` in the following format: `<client_options.scheme>://<client_options.host>:<client_options.port>`.
    - If `discovery` is set to `true`, the OpenID Connect provider will try to auto discover the client options using `<your_oidc_url>/.well-known/openid-configuration`. Defaults to `false`.
    - `<uid_field>` (optional) is the field name from the `user_info` details that will be used as `uid` value. For example, `preferred_username`.
      If this value is not provided or the field with the configured value is missing from the `user_info` details, the `uid` will use the `sub` field.
    - `client_options` are the OpenID Connect client-specific options. Specifically:

      - `identifier` is the client identifier as configured in the OpenID Connect service provider.
      - `secret` is the client secret as configured in the OpenID Connect service provider.
      - `redirect_uri` is the GitLab URL to redirect the user to after successful login. For example, `http://example.com/users/auth/openid_connect/callback`.
      - `end_session_endpoint` (optional) is the URL to the endpoint that end the session (logout). Can be provided if auto-discovery disabled or unsuccessful.

      The following `client_options` are optional unless auto-discovery is disabled or unsuccessful:

        - `authorization_endpoint` is the URL to the endpoint that authorizes the end user.
        - `token_endpoint` is the URL to the endpoint that provides Access Token.
        - `userinfo_endpoint` is the URL to the endpoint that provides the user information.
        - `jwks_uri` is the URL to the endpoint where the Token signer publishes its keys.

1.  Save the configuration file.
1.  [Reconfigure](../restart_gitlab.md#omnibus-gitlab-reconfigure) or [restart GitLab](../restart_gitlab.md#installations-from-source)
    for the changes to take effect if you installed GitLab via Omnibus or from source respectively.

On the sign in page, there should now be an OpenID Connect icon below the regular sign in form.
Click the icon to begin the authentication process. The OpenID Connect provider will ask the user to
sign in and authorize the GitLab application (if confirmation required by the client). If everything goes well, the user
will be redirected to GitLab and will be signed in.
